/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import kafka.cluster.Partition;
import kafka.common.EvenClusterLoadPlanBrokerStats;
import kafka.common.EvenClusterLoadPlanDetailedClusterBalanceStats;
import kafka.common.EvenClusterLoadPlanGoalOverview;
import kafka.common.EvenClusterLoadPlanGoalStats;
import kafka.common.EvenClusterLoadPlanInternal;
import kafka.common.EvenClusterLoadPlanInternalBrokerRelatedStats;
import kafka.common.EvenClusterLoadPlanInternalClusterRelatedStats;
import kafka.common.EvenClusterLoadPlanInternalGoalRelatedStats;
import kafka.common.EvenClusterLoadPlanInternalReplicaMovementStats;
import kafka.common.EvenClusterLoadPlanRejectingGoal;
import kafka.common.EvenClusterLoadPlanResources;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.RequestHandlerHelper$;
import kafka.server.link.ClusterLinkFactory;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.backupObjectLifecycle.BackupObjectLifecycleManagerCoordinator;
import kafka.tier.backupObjectLifecycle.BackupObjectLifecycleManagerCoordinator$;
import kafka.tier.snapshot.TierTopicSnapshotCoordinator;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.errors.InvalidBrokerRemovalException;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.UnrepresentableBrokerIdException;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsRequestData;
import org.apache.kafka.common.message.ComputeEvenClusterLoadPlanResponseData;
import org.apache.kafka.common.message.RemoveBrokersRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.RemoveBrokersRequest;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011\b\u0003\u0004H\u0001\u0001\u0006IA\u000f\u0005\b\u0011\u0002\u0011\r\u0011\"\u0001J\u0011\u0019\t\u0006\u0001)A\u0005\u0015\"9!\u000b\u0001b\u0001\n\u0003\u0019\u0006B\u00020\u0001A\u0003%A\u000bC\u0004`\u0001\t\u0007I\u0011\u00011\t\r)\u0004\u0001\u0015!\u0003b\u0011\u001dY\u0007A1A\u0005\u00021Daa\u001d\u0001!\u0002\u0013i\u0007b\u0002;\u0001\u0005\u0004%\t!\u001e\u0005\u0007o\u0002\u0001\u000b\u0011\u0002<\t\u000fa\u0004!\u0019!C\u0001s\"9\u0011\u0011\u0001\u0001!\u0002\u0013Q\b\"CA\u0002\u0001\t\u0007I\u0011AA\u0003\u0011!\tI\u0001\u0001Q\u0001\n\u0005\u001d\u0001\"CA\u0006\u0001\t\u0007I\u0011AA\u0007\u0011!\ti\u0002\u0001Q\u0001\n\u0005=\u0001\"CA\u0010\u0001\t\u0007I\u0011AA\u0011\u0011!\ty\u0003\u0001Q\u0001\n\u0005\r\u0002\"CA\u0019\u0001\t\u0007I\u0011AA\u0011\u0011!\t\u0019\u0004\u0001Q\u0001\n\u0005\r\u0002\"CA\u001b\u0001\t\u0007I\u0011AA\u0011\u0011!\t9\u0004\u0001Q\u0001\n\u0005\r\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u00033\u0002A\u0011AA\u001e\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003wAq!a\u001a\u0001\t\u0003\tY\u0004C\u0004\u0002l\u0001!\t!a\u000f\t\u000f\u0005=\u0004\u0001\"\u0001\u0002<!9\u00111\u000f\u0001\u0005\u0002\u0005m\u0002bBA<\u0001\u0011\u0005\u00111\b\u0005\b\u0003w\u0002A\u0011AA\u001e\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003Cq!a \u0001\t\u0013\ti\u000bC\u0004\u0002:\u0002!I!a/\t\u000f\u0005-\b\u0001\"\u0003\u0002n\nA\"+Z9vKN$\b*\u00198eY\u0016\u0014\b*\u001a7qKJ$Vm\u001d;\u000b\u0005%R\u0013AB:feZ,'OC\u0001,\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0007\u0005\u00028\u00015\t\u0001&\u0001\the>,\boQ8pe\u0012Lg.\u0019;peV\t!\b\u0005\u0002<\u000b6\tAH\u0003\u0002>}\u0005)qM]8va*\u0011q\bQ\u0001\fG>|'\u000fZ5oCR|'O\u0003\u0002,\u0003*\u0011!iQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\u000b1a\u001c:h\u0013\t1EH\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;pe\u0006\trM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002\u001dQDhnQ8pe\u0012Lg.\u0019;peV\t!\n\u0005\u0002L\u001f6\tAJ\u0003\u0002N\u001d\u0006YAO]1og\u0006\u001cG/[8o\u0015\ty$&\u0003\u0002Q\u0019\n1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'/A\buq:\u001cun\u001c:eS:\fGo\u001c:!\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0016\u0003Q\u0003\"!V.\u000f\u0005YKV\"A,\u000b\u0005aC\u0013\u0001\u00027j].L!AW,\u0002%\rcWo\u001d;fe2Kgn\u001b$bGR|'/_\u0005\u00039v\u00131\u0002T5oW6\u000bg.Y4fe*\u0011!lV\u0001\u0014G2,8\u000f^3s\u0019&t7.T1oC\u001e,'\u000fI\u0001$i&,'\u000fR3mKR,G\rU1si&$\u0018n\u001c8t\u0007>|'\u000fZ5oCR|'o\u00149u+\u0005\t\u0007cA\u0018cI&\u00111\r\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001dT\u0013\u0001\u0002;jKJL!!\u001b4\u0003AQKWM\u001d#fY\u0016$X\r\u001a)beRLG/[8og\u000e{wN\u001d3j]\u0006$xN]\u0001%i&,'\u000fR3mKR,G\rU1si&$\u0018n\u001c8t\u0007>|'\u000fZ5oCR|'o\u00149uA\u00059#-Y2lkB|%M[3di2Kg-Z2zG2,W*\u00198bO\u0016\u00148i\\8sI&t\u0017\r^8s+\u0005i\u0007C\u00018r\u001b\u0005y'B\u00019g\u0003U\u0011\u0017mY6va>\u0013'.Z2u\u0019&4WmY=dY\u0016L!A]8\u0003O\t\u000b7m[;q\u001f\nTWm\u0019;MS\u001a,7-_2mK6\u000bg.Y4fe\u000e{wN\u001d3j]\u0006$xN]\u0001)E\u0006\u001c7.\u001e9PE*,7\r\u001e'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s\u0007>|'\u000fZ5oCR|'\u000fI\u0001+E\u0006\u001c7.\u001e9PE*,7\r\u001e'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s\u0007>|'\u000fZ5oCR|'o\u00149u+\u00051\bcA\u0018c[\u0006Y#-Y2lkB|%M[3di2Kg-Z2zG2,W*\u00198bO\u0016\u00148i\\8sI&t\u0017\r^8s\u001fB$\b%A\u0012uS\u0016\u0014Hk\u001c9jGNs\u0017\r]:i_Rl\u0015M\\1hKJ\u001cun\u001c:eS:\fGo\u001c:\u0016\u0003i\u0004\"a\u001f@\u000e\u0003qT!! 4\u0002\u0011Mt\u0017\r]:i_RL!a ?\u00039QKWM\u001d+pa&\u001c7K\\1qg\"|GoQ8pe\u0012Lg.\u0019;pe\u0006!C/[3s)>\u0004\u0018nY*oCB\u001c\bn\u001c;NC:\fw-\u001a:D_>\u0014H-\u001b8bi>\u0014\b%\u0001\u0014uS\u0016\u0014Hk\u001c9jGNs\u0017\r]:i_Rl\u0015M\\1hKJ\u001cun\u001c:eS:\fGo\u001c:PaR,\"!a\u0002\u0011\u0007=\u0012'0A\u0014uS\u0016\u0014Hk\u001c9jGNs\u0017\r]:i_Rl\u0015M\\1hKJ\u001cun\u001c:eS:\fGo\u001c:PaR\u0004\u0013aE9v_R\f7i\\8sI&t\u0017\r^8s\u001fB$XCAA\b!\u0011y#-!\u0005\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006O\u0003\u0015\tXo\u001c;b\u0013\u0011\tY\"!\u0006\u0003!E+x\u000e^1D_>\u0014H-\u001b8bi>\u0014\u0018\u0001F9v_R\f7i\\8sI&t\u0017\r^8s\u001fB$\b%A\u0006qCJ$\u0018\u000e^5p]~\u000bTCAA\u0012!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015U\u000591\r\\;ti\u0016\u0014\u0018\u0002BA\u0017\u0003O\u0011\u0011\u0002U1si&$\u0018n\u001c8\u0002\u0019A\f'\u000f^5uS>tw,\r\u0011\u0002\u0017A\f'\u000f^5uS>twLM\u0001\ra\u0006\u0014H/\u001b;j_:|&\u0007I\u0001\fa\u0006\u0014H/\u001b;j_:|6'\u0001\u0007qCJ$\u0018\u000e^5p]~\u001b\u0004%A\u0003tKR,\b\u000f\u0006\u0002\u0002>A\u0019q&a\u0010\n\u0007\u0005\u0005\u0003G\u0001\u0003V]&$\bf\u0001\u000e\u0002FA!\u0011qIA+\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013aA1qS*!\u0011qJA)\u0003\u001dQW\u000f]5uKJT1!a\u0015D\u0003\u0015QWO\\5u\u0013\u0011\t9&!\u0013\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A!uKN$()Y2lkB|%M[3di2Kg-Z2zG2,W*\u00198bO\u0016\u00148\u000b^1siN<\u0006.\u001a8Ce>\\WM]!tgVlWm\u001d'fC\u0012,'o\u001d5ja\"\u001a1$!\u0018\u0011\t\u0005\u001d\u0013qL\u0005\u0005\u0003C\nIE\u0001\u0003UKN$\u0018A\u0010;fgR\u0014\u0015mY6va>\u0013'.Z2u\u0019&4WmY=dY\u0016l\u0015M\\1hKJ\u001cFo\u001c9t/\",gN\u0011:pW\u0016\u0014()Z2p[\u0016\u001chi\u001c7m_^,'\u000fK\u0002\u001d\u0003;\n\u0011\b^3tiZ\u000bG.\u001b3bi\u0016\fE\u000e^3s\u000bb\u001cG.^:j_:\u0014V-];fgR$\u0006N]8xg&3\u0017J\u001c<bY&$'I]8lKJLEm\u001d\u0015\u0004;\u0005u\u0013!\u0010;fgR4\u0016\r\\5eCR,\u0017\t\u001c;fe\u0016C8\r\\;tS>t'+Z9vKN$H\u000b\u001b:poNLe-\u00138wC2LG-\u0012=dYV\u001c\u0018n\u001c8UsB,\u0007f\u0001\u0010\u0002^\u00051D/Z:u-\u0006d\u0017\u000eZ1uK\u0006cG/\u001a:Fq\u000edWo]5p]J+\u0017/^3tiRC'o\\<t\u0013\u001aLeN^1mS\u0012\u0014V-Y:p]\"\u001aq$!\u0018\u0002WQ,7\u000f\u001e,bY&$\u0017\r^3SK6|g/\u00197SKF,Xm\u001d;UQJ|wo]%g\u001d>\u0014%o\\6feND3\u0001IA/\u0003a\"Xm\u001d;WC2LG-\u0019;f%\u0016lwN^1m%\u0016\fX/Z:u)\"\u0014xn^:JMVs'/\u001a9sKN,g\u000e^1cY\u0016\u0014%o\\6feND3!IA/\u0003Q\"Xm\u001d;D_:4XM\u001d;Fm\u0016t7\t\\;ti\u0016\u0014Hj\\1e!2\fg.\u00138uKJt\u0017\r\u001c+p%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0015\u0004E\u0005u\u0013!\n3p\u0005J|7.\u001a:Ti\u0006$8/R9vC2\u0014Vm\u001d9p]N,'I]8lKJ\u001cF/\u0019;t)\u0019\ti$a!\u0002\u0014\"9\u0011QQ\u0012A\u0002\u0005\u001d\u0015A\u00012t!\u0011\tI)a$\u000e\u0005\u0005-%bAAGU\u000511m\\7n_:LA!!%\u0002\f\nqRI^3o\u00072,8\u000f^3s\u0019>\fG\r\u00157b]\n\u0013xn[3s'R\fGo\u001d\u0005\b\u0003+\u001b\u0003\u0019AAL\u0003\r\u0011(m\u001d\t\u0005\u00033\u000b9K\u0004\u0003\u0002\u001c\u0006\rVBAAO\u0015\u0011\ty*!)\u0002\u000f5,7o]1hK*\u0019\u0011Q\u0012!\n\t\u0005\u0015\u0016QT\u0001'\u0007>l\u0007/\u001e;f\u000bZ,gn\u00117vgR,'\u000fT8bIBc\u0017M\u001c*fgB|gn]3ECR\f\u0017\u0002BAU\u0003W\u0013Q\u0002\u0015:f\u0005J|7.\u001a:Ti\u0006$(\u0002BAS\u0003;#b!!\u0010\u00020\u0006E\u0006bBACI\u0001\u0007\u0011q\u0011\u0005\b\u0003+#\u0003\u0019AAZ!\u0011\tI*!.\n\t\u0005]\u00161\u0016\u0002\u000f!>\u001cHO\u0011:pW\u0016\u00148\u000b^1u\u0003A\nG\u000e^3s\u0005J|7.\u001a:SKBd\u0017nY1Fq\u000edWo]5p]N\u0014V-];fgR<\u0016\u000e\u001e5Ce>\\WM]%egR!\u0011QXAe!\u0011\ty,!2\u000e\u0005\u0005\u0005'\u0002BAb\u0003C\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u000f\f\tMA\u0012BYR,'O\u0011:pW\u0016\u0014(+\u001a9mS\u000e\fW\t_2mkNLwN\\:SKF,Xm\u001d;\t\u000f\u0005-W\u00051\u0001\u0002N\u0006I!M]8lKJLEm\u001d\t\u0007\u0003\u001f\fy.!:\u000f\t\u0005E\u00171\u001c\b\u0005\u0003'\fI.\u0004\u0002\u0002V*\u0019\u0011q\u001b\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0014bAAoa\u00059\u0001/Y2lC\u001e,\u0017\u0002BAq\u0003G\u0014A\u0001T5ti*\u0019\u0011Q\u001c\u0019\u0011\u0007=\n9/C\u0002\u0002jB\u00121!\u00138u\u0003\r\nG\u000e^3s\u0005J|7.\u001a:SKBd\u0017nY1Fq\u000edWo]5p]N\u0014V-];fgR$B!!0\u0002p\"9\u0011\u0011\u001f\u0014A\u0002\u0005M\u0018aC3yG2,8/[8o\u001fB\u0004b!a4\u0002`\u0006U\b\u0003BA|\u0003{l!!!?\u000b\t\u00055\u00151 \u0006\u0003S\u0001KA!a@\u0002z\n9\u0012\t\u001c;feJ+\u0007\u000f\\5dC\u0016C8\r\\;tS>tw\n\u001d")
public class RequestHandlerHelperTest {
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private final TransactionCoordinator txnCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private final ClusterLinkFactory.LinkManager clusterLinkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
    private final Option<TierDeletedPartitionsCoordinator> tierDeletedPartitionsCoordinatorOpt = new Some(Mockito.mock(TierDeletedPartitionsCoordinator.class));
    private final BackupObjectLifecycleManagerCoordinator backupObjectLifecycleManagerCoordinator = (BackupObjectLifecycleManagerCoordinator)Mockito.mock(BackupObjectLifecycleManagerCoordinator.class);
    private final Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt = new Some((Object)this.backupObjectLifecycleManagerCoordinator());
    private final TierTopicSnapshotCoordinator tierTopicSnapshotManagerCoordinator = (TierTopicSnapshotCoordinator)Mockito.mock(TierTopicSnapshotCoordinator.class);
    private final Option<TierTopicSnapshotCoordinator> tierTopicSnapshotManagerCoordinatorOpt = new Some((Object)this.tierTopicSnapshotManagerCoordinator());
    private final Option<QuotaCoordinator> quotaCoordinatorOpt = new Some(Mockito.mock(QuotaCoordinator.class));
    private final Partition partition_1 = (Partition)Mockito.mock(Partition.class);
    private final Partition partition_2 = (Partition)Mockito.mock(Partition.class);
    private final Partition partition_3 = (Partition)Mockito.mock(Partition.class);

    public GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    public TransactionCoordinator txnCoordinator() {
        return this.txnCoordinator;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public Option<TierDeletedPartitionsCoordinator> tierDeletedPartitionsCoordinatorOpt() {
        return this.tierDeletedPartitionsCoordinatorOpt;
    }

    public BackupObjectLifecycleManagerCoordinator backupObjectLifecycleManagerCoordinator() {
        return this.backupObjectLifecycleManagerCoordinator;
    }

    public Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt() {
        return this.backupObjectLifecycleManagerCoordinatorOpt;
    }

    public TierTopicSnapshotCoordinator tierTopicSnapshotManagerCoordinator() {
        return this.tierTopicSnapshotManagerCoordinator;
    }

    public Option<TierTopicSnapshotCoordinator> tierTopicSnapshotManagerCoordinatorOpt() {
        return this.tierTopicSnapshotManagerCoordinatorOpt;
    }

    public Option<QuotaCoordinator> quotaCoordinatorOpt() {
        return this.quotaCoordinatorOpt;
    }

    public Partition partition_1() {
        return this.partition_1;
    }

    public Partition partition_2() {
        return this.partition_2;
    }

    public Partition partition_3() {
        return this.partition_3;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.partition_1().topic()).thenReturn((Object)"_confluent-tier-state");
        Mockito.when((Object)this.partition_2().topic()).thenReturn((Object)"_confluent-tier-state");
        Mockito.when((Object)this.partition_3().topic()).thenReturn((Object)"blah");
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.partition_1().partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.partition_2().partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER() + 1)));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.partition_3().partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER() + 2)));
    }

    @Test
    public void testBackupObjectLifecycleManagerStartsWhenBrokerAssumesLeadership() {
        .colon.colon updatedLeaders = new .colon.colon((Object)this.partition_1(), (List)Nil$.MODULE$);
        .colon.colon updatedFollowers = new .colon.colon((Object)this.partition_2(), (List)new .colon.colon((Object)this.partition_3(), (List)Nil$.MODULE$));
        RequestHandlerHelper$.MODULE$.onLeadershipChange(this.groupCoordinator(), this.txnCoordinator(), this.clusterLinkManager(), this.tierDeletedPartitionsCoordinatorOpt(), this.backupObjectLifecycleManagerCoordinatorOpt(), this.quotaCoordinatorOpt(), this.tierTopicSnapshotManagerCoordinatorOpt(), (Iterable)updatedLeaders, (Iterable)updatedFollowers);
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)1))).onElection(this.partition_1().partitionId());
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)1))).onResignation(this.partition_2().partitionId());
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)0))).onResignation(this.partition_3().partitionId());
    }

    @Test
    public void testBackupObjectLifecycleManagerStopsWhenBrokerBecomesFollower() {
        .colon.colon updatedLeaders = new .colon.colon((Object)this.partition_2(), (List)new .colon.colon((Object)this.partition_3(), (List)Nil$.MODULE$));
        .colon.colon updatedFollowers = new .colon.colon((Object)this.partition_1(), (List)Nil$.MODULE$);
        RequestHandlerHelper$.MODULE$.onLeadershipChange(this.groupCoordinator(), this.txnCoordinator(), this.clusterLinkManager(), this.tierDeletedPartitionsCoordinatorOpt(), this.backupObjectLifecycleManagerCoordinatorOpt(), this.quotaCoordinatorOpt(), this.tierTopicSnapshotManagerCoordinatorOpt(), (Iterable)updatedLeaders, (Iterable)updatedFollowers);
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)1))).onElection(this.partition_2().partitionId());
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)0))).onElection(this.partition_3().partitionId());
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)1))).onResignation(this.partition_1().partitionId());
    }

    @Test
    public void testValidateAlterExclusionRequestThrowsIfInvalidBrokerIds() {
        Assertions.assertThrows(InvalidBrokerReplicaExclusionException.class, () -> {
            AlterBrokerReplicaExclusionsRequest emptyReq = this.alterBrokerReplicaExclusionsRequestWithBrokerIds((List<Object>)package$.MODULE$.List().empty());
            RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(emptyReq);
        });
        Assertions.assertThrows(UnrepresentableBrokerIdException.class, () -> {
            AlterBrokerReplicaExclusionsRequest unrepresentableBrokersReq = this.alterBrokerReplicaExclusionsRequestWithBrokerIds((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, -100}))));
            RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(unrepresentableBrokersReq);
        });
        Assertions.assertThrows(InvalidBrokerReplicaExclusionException.class, () -> {
            AlterBrokerReplicaExclusionsRequest duplicateBrokersReq = this.alterBrokerReplicaExclusionsRequestWithBrokerIds((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 1}))));
            RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(duplicateBrokersReq);
        });
    }

    @Test
    public void testValidateAlterExclusionRequestThrowsIfInvalidExclusionType() {
        ListBuffer exclusionOps = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        exclusionOps.$plus$eq((Object)new AlterReplicaExclusionOp(1, "reason", ExclusionOp.OpType.SET));
        AlterBrokerReplicaExclusionsRequest validRequest = this.alterBrokerReplicaExclusionsRequest((List<AlterReplicaExclusionOp>)exclusionOps.toList());
        RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(validRequest);
        exclusionOps.$plus$eq((Object)new AlterReplicaExclusionOp(1, "reason", ExclusionOp.OpType.UNKNOWN));
        AlterBrokerReplicaExclusionsRequest invalidRequest = this.alterBrokerReplicaExclusionsRequest((List<AlterReplicaExclusionOp>)exclusionOps.toList());
        Assertions.assertThrows(InvalidBrokerReplicaExclusionException.class, () -> RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(invalidRequest));
    }

    @Test
    public void testValidateAlterExclusionRequestThrowsIfInvalidReason() {
        String chars1028Reason = String.join((CharSequence)"", Collections.nCopies(257, "Test"));
        new .colon.colon((Object)".", (List)new .colon.colon((Object)chars1028Reason, (List)new .colon.colon((Object)"\\", (List)Nil$.MODULE$))).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)RequestHandlerHelperTest.$anonfun$testValidateAlterExclusionRequestThrowsIfInvalidReason$1(check$ifrefutable$1))).foreach((Function1 & Serializable)invalidReason -> {
            AlterReplicaExclusionOp op = new AlterReplicaExclusionOp(1, invalidReason, ExclusionOp.OpType.SET);
            return (InvalidBrokerReplicaExclusionException)Assertions.assertThrows(InvalidBrokerReplicaExclusionException.class, () -> RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(this.alterBrokerReplicaExclusionsRequest((List<AlterReplicaExclusionOp>)new .colon.colon((Object)op, (List)Nil$.MODULE$))));
        });
    }

    @Test
    public void testValidateRemovalRequestThrowsIfNoBrokers() {
        RemoveBrokersRequest request = new RemoveBrokersRequest.Builder(Collections.emptySet(), true).build((short)1);
        Assertions.assertThrows(InvalidBrokerRemovalException.class, () -> RequestHandlerHelper$.MODULE$.validateRemoveBrokersRequest(request));
    }

    @Test
    public void testValidateRemovalRequestThrowsIfUnrepresentableBrokers() {
        RemoveBrokersRequestData.BrokerId brokerId = new RemoveBrokersRequestData.BrokerId().setBrokerId(-1);
        RemoveBrokersRequest request = new RemoveBrokersRequest.Builder(Collections.singleton(brokerId), true).build((short)1);
        Assertions.assertThrows(UnrepresentableBrokerIdException.class, () -> RequestHandlerHelper$.MODULE$.validateRemoveBrokersRequest(request));
    }

    @Test
    public void testConvertEvenClusterLoadPlanInternalToResponseData() {
        int interBrokerMoves = 15;
        double interBrokerMovesMB = 35.4;
        int leadershipMoves = 2;
        .colon.colon brokersExcludedForLeadership = new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$));
        .colon.colon brokersExcludedForReplicaMove = new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(4), (List)Nil$.MODULE$));
        .colon.colon newBrokers = new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(6), (List)Nil$.MODULE$));
        .colon.colon deadOrRemovedBrokers = new .colon.colon((Object)Predef$.MODULE$.int2Integer(7), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(8), (List)Nil$.MODULE$));
        int recentWindows = 1;
        double partitionCoveragePercent = 80.5;
        .colon.colon excludedTopics = new .colon.colon((Object)"topic1", (List)Nil$.MODULE$);
        int totalBrokers = 10;
        int totalReplicas = 200;
        int totalTopics = 15;
        double balancednessScoreBefore = 95.1;
        double balancednessScoreAfter = 99.9;
        EvenClusterLoadPlanBrokerStats broker0PreBalance = new EvenClusterLoadPlanBrokerStats(0, "host0", 100.0, 100.0, 50.0, 10000.0, 10000.0, 20000.0, 30000.0, 10, 30);
        EvenClusterLoadPlanBrokerStats broker1PreBalance = new EvenClusterLoadPlanBrokerStats(1, "host1", 101.0, 101.0, 51.0, 10001.0, 10001.0, 20001.0, 30001.0, 11, 31);
        EvenClusterLoadPlanBrokerStats broker0PostBalance = new EvenClusterLoadPlanBrokerStats(0, "host0", 102.0, 102.0, 52.0, 10002.0, 10002.0, 20002.0, 30002.0, 12, 32);
        EvenClusterLoadPlanBrokerStats broker1PostBalance = new EvenClusterLoadPlanBrokerStats(1, "host1", 103.0, 103.0, 53.0, 10003.0, 10003.0, 20003.0, 30003.0, 13, 33);
        .colon.colon clusterLoadPreBalance = new .colon.colon((Object)broker0PreBalance, (List)new .colon.colon((Object)broker1PreBalance, (List)Nil$.MODULE$));
        .colon.colon clusterLoadPostBalance = new .colon.colon((Object)broker0PostBalance, (List)new .colon.colon((Object)broker1PostBalance, (List)Nil$.MODULE$));
        String replicaDistributionGoalName = "ReplicaDistributionGoal";
        String diskCapacityGoalName = "DiskCapacityGoal";
        String networkInboundCapacityGoalName = "NetworkInboundCapacityGoal";
        .colon.colon movementGeneratingGoal = new .colon.colon((Object)replicaDistributionGoalName, (List)Nil$.MODULE$);
        EvenClusterLoadPlanRejectingGoal replicaRejectionGoalDisk = new EvenClusterLoadPlanRejectingGoal(diskCapacityGoalName, 100);
        EvenClusterLoadPlanRejectingGoal replicaRejectionGoalNetworkIn = new EvenClusterLoadPlanRejectingGoal(networkInboundCapacityGoalName, 20);
        .colon.colon replicaGoalOverviewRejectingGoals = new .colon.colon((Object)replicaRejectionGoalDisk, (List)new .colon.colon((Object)replicaRejectionGoalNetworkIn, (List)Nil$.MODULE$));
        String replicaGoalStatus = "FIXED";
        int replicaProposalsGen = 200;
        int replicaProposalsRej = 50;
        int replicaProposalsRejPerc = 25;
        int replicaProposalsAcc = 2;
        boolean replicaPropoalsAccPerc = true;
        int replicaPropoalsMoves = 10;
        int replicaPropoalsSwaps = 12;
        EvenClusterLoadPlanGoalOverview replicaGoalOverview = new EvenClusterLoadPlanGoalOverview(replicaGoalStatus, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaGoalOverviewRejectingGoals).asJava(), replicaProposalsGen, replicaProposalsRej, (double)replicaProposalsRejPerc, replicaProposalsAcc, (double)replicaPropoalsAccPerc, replicaPropoalsMoves, replicaPropoalsSwaps);
        EvenClusterLoadPlanResources clusterResources = new EvenClusterLoadPlanResources(1.0, 2.0, 2.5, 3.0, 4.0, 5.0, 6.0, 7, 8, 9);
        EvenClusterLoadPlanGoalStats replicaGoalStats = new EvenClusterLoadPlanGoalStats(replicaDistributionGoalName, clusterResources, clusterResources, clusterResources, clusterResources, replicaGoalOverview);
        .colon.colon goalStats = new .colon.colon((Object)replicaGoalStats, (List)Nil$.MODULE$);
        .colon.colon violatedGoalsBeforeOptimization = new .colon.colon((Object)replicaDistributionGoalName, (List)new .colon.colon((Object)diskCapacityGoalName, (List)new .colon.colon((Object)networkInboundCapacityGoalName, (List)Nil$.MODULE$)));
        .colon.colon violatedGoalsAfterOptimization = new .colon.colon((Object)diskCapacityGoalName, (List)Nil$.MODULE$);
        EvenClusterLoadPlanInternal plan = new EvenClusterLoadPlanInternal(new EvenClusterLoadPlanInternalReplicaMovementStats(interBrokerMoves, interBrokerMovesMB, leadershipMoves), new EvenClusterLoadPlanInternalBrokerRelatedStats(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokersExcludedForLeadership).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokersExcludedForReplicaMove).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newBrokers).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)deadOrRemovedBrokers).asJava()), new EvenClusterLoadPlanInternalClusterRelatedStats(recentWindows, partitionCoveragePercent, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)excludedTopics).asJava(), totalBrokers, totalReplicas, totalTopics), new EvenClusterLoadPlanDetailedClusterBalanceStats(balancednessScoreBefore, balancednessScoreAfter, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)clusterLoadPreBalance).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)clusterLoadPostBalance).asJava()), new EvenClusterLoadPlanInternalGoalRelatedStats(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)movementGeneratingGoal).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)goalStats).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)violatedGoalsBeforeOptimization).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)violatedGoalsAfterOptimization).asJava()));
        ComputeEvenClusterLoadPlanResponseData responseData = RequestHandlerHelper$.MODULE$.convertEvenClusterLoadPlanInternalToResponseData(plan);
        Assertions.assertEquals((int)interBrokerMoves, (int)responseData.interBrokerMoves());
        Assertions.assertEquals((double)interBrokerMovesMB, (double)responseData.interBrokerMovesMB());
        Assertions.assertEquals((int)leadershipMoves, (int)responseData.leadershipMoves());
        Assertions.assertEquals((Object)brokersExcludedForLeadership, (Object)CollectionConverters$.MODULE$.ListHasAsScala(responseData.brokersExcludedForLeadership()).asScala());
        Assertions.assertEquals((Object)brokersExcludedForReplicaMove, (Object)CollectionConverters$.MODULE$.ListHasAsScala(responseData.brokersExcludedForReplicaMove()).asScala());
        Assertions.assertEquals((Object)newBrokers, (Object)CollectionConverters$.MODULE$.ListHasAsScala(responseData.newBrokers()).asScala());
        Assertions.assertEquals((Object)deadOrRemovedBrokers, (Object)CollectionConverters$.MODULE$.ListHasAsScala(responseData.deadOrRemovedBrokers()).asScala());
        Assertions.assertEquals((int)recentWindows, (int)responseData.recentWindows());
        Assertions.assertEquals((double)partitionCoveragePercent, (double)responseData.partitionCoveragePercent());
        Assertions.assertEquals((Object)newBrokers, (Object)CollectionConverters$.MODULE$.ListHasAsScala(responseData.newBrokers()).asScala());
        Assertions.assertEquals((Object)deadOrRemovedBrokers, (Object)CollectionConverters$.MODULE$.ListHasAsScala(responseData.deadOrRemovedBrokers()).asScala());
        Assertions.assertEquals((Object)excludedTopics, (Object)CollectionConverters$.MODULE$.ListHasAsScala(responseData.excludedTopics()).asScala());
        Assertions.assertEquals((int)totalBrokers, (int)responseData.totalBrokers());
        Assertions.assertEquals((int)totalReplicas, (int)responseData.totalReplicas());
        Assertions.assertEquals((int)totalTopics, (int)responseData.totalTopics());
        Assertions.assertEquals((double)balancednessScoreBefore, (double)responseData.balancednessScorePreRebalance());
        Assertions.assertEquals((double)balancednessScoreAfter, (double)responseData.balancednessScorePostRebalance());
        Assertions.assertEquals((int)2, (int)clusterLoadPreBalance.size());
        Assertions.assertEquals((int)2, (int)clusterLoadPostBalance.size());
        this.doBrokerStatsEqualResponseBrokerStats(broker0PreBalance, (ComputeEvenClusterLoadPlanResponseData.PreBrokerStat)responseData.clusterLoadPreRebalance().get(0));
        this.doBrokerStatsEqualResponseBrokerStats(broker1PreBalance, (ComputeEvenClusterLoadPlanResponseData.PreBrokerStat)responseData.clusterLoadPreRebalance().get(1));
        this.doBrokerStatsEqualResponseBrokerStats(broker0PostBalance, (ComputeEvenClusterLoadPlanResponseData.PostBrokerStat)responseData.clusterLoadPostRebalance().get(0));
        this.doBrokerStatsEqualResponseBrokerStats(broker1PostBalance, (ComputeEvenClusterLoadPlanResponseData.PostBrokerStat)responseData.clusterLoadPostRebalance().get(1));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)movementGeneratingGoal).asJava(), (Object)responseData.movementGeneratingGoals());
        Assertions.assertEquals((int)1, (int)responseData.goalStats().size());
        Assertions.assertEquals((Object)replicaDistributionGoalName, (Object)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalName());
        Assertions.assertEquals((int)clusterResources.replicas(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().replicas());
        Assertions.assertEquals((double)clusterResources.cpuPercent(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().cpuPercent());
        Assertions.assertEquals((double)clusterResources.diskMB(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().diskMB());
        Assertions.assertEquals((double)clusterResources.networkOutboundKBps(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().networkOutboundKBps());
        Assertions.assertEquals((double)clusterResources.networkInboundKBps(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().networkInboundKBps());
        Assertions.assertEquals((double)clusterResources.producerInboundKBps(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().producerInboundKBps());
        Assertions.assertEquals((double)clusterResources.consumeOutboundKBps(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().consumerOutboundKBps());
        Assertions.assertEquals((double)clusterResources.potentialNwOutKBps(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().potentialNwOutKBps());
        Assertions.assertEquals((int)clusterResources.leaderReplicas(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().leaderReplicas());
        Assertions.assertEquals((int)clusterResources.topicReplicas(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).avgResources().topicReplicas());
        Assertions.assertEquals((Object)replicaGoalOverview.goalStatus(), (Object)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().goalStatus());
        Assertions.assertEquals((int)2, (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().rejectingGoals().size());
        Assertions.assertEquals((Object)((EvenClusterLoadPlanRejectingGoal)replicaGoalOverview.rejectingGoals().get(0)).goalName(), (Object)((ComputeEvenClusterLoadPlanResponseData.RejectingGoal)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().rejectingGoals().get(0)).goalName());
        Assertions.assertEquals((int)((EvenClusterLoadPlanRejectingGoal)replicaGoalOverview.rejectingGoals().get(0)).proposalsRejected(), (int)((ComputeEvenClusterLoadPlanResponseData.RejectingGoal)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().rejectingGoals().get(0)).proposalsRejected());
        Assertions.assertEquals((int)replicaGoalOverview.proposalsGenerated(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().proposalsGenerated());
        Assertions.assertEquals((int)replicaGoalOverview.proposalsRejected(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().proposalsRejected());
        Assertions.assertEquals((double)replicaGoalOverview.proposalsRejectedPercent(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().proposalsRejectedPercent());
        Assertions.assertEquals((int)replicaGoalOverview.proposalsAccepted(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().proposalsAccepted());
        Assertions.assertEquals((double)replicaGoalOverview.proposalsAcceptedPercent(), (double)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().proposalsAcceptedPercent());
        Assertions.assertEquals((int)replicaGoalOverview.moves(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().moves());
        Assertions.assertEquals((int)replicaGoalOverview.swaps(), (int)((ComputeEvenClusterLoadPlanResponseData.GoalStat)responseData.goalStats().get(0)).goalOverview().swaps());
    }

    private void doBrokerStatsEqualResponseBrokerStats(EvenClusterLoadPlanBrokerStats bs, ComputeEvenClusterLoadPlanResponseData.PreBrokerStat rbs) {
        Assertions.assertEquals((int)bs.brokerId(), (int)rbs.brokerId());
        Assertions.assertEquals((Object)bs.host(), (Object)rbs.host());
        Assertions.assertEquals((double)bs.diskMB(), (double)rbs.diskMB());
        Assertions.assertEquals((double)bs.diskPercent(), (double)rbs.diskPercent());
        Assertions.assertEquals((double)bs.cpuPercent(), (double)rbs.cpuPercent());
        Assertions.assertEquals((double)bs.leaderNetworkInKBps(), (double)rbs.leaderNetworkInKBps());
        Assertions.assertEquals((double)bs.followerNetworkInKBps(), (double)rbs.followerNetworkInKBps());
        Assertions.assertEquals((double)bs.networkOutKBps(), (double)rbs.networkOutKBps());
        Assertions.assertEquals((double)bs.potentialNetworkOutKBps(), (double)rbs.potentialNetworkOutKBps());
        Assertions.assertEquals((int)bs.leaders(), (int)rbs.leaders());
        Assertions.assertEquals((int)bs.replicas(), (int)rbs.replicas());
    }

    private void doBrokerStatsEqualResponseBrokerStats(EvenClusterLoadPlanBrokerStats bs, ComputeEvenClusterLoadPlanResponseData.PostBrokerStat rbs) {
        Assertions.assertEquals((int)bs.brokerId(), (int)rbs.brokerId());
        Assertions.assertEquals((Object)bs.host(), (Object)rbs.host());
        Assertions.assertEquals((double)bs.diskMB(), (double)rbs.diskMB());
        Assertions.assertEquals((double)bs.diskPercent(), (double)rbs.diskPercent());
        Assertions.assertEquals((double)bs.cpuPercent(), (double)rbs.cpuPercent());
        Assertions.assertEquals((double)bs.leaderNetworkInKBps(), (double)rbs.leaderNetworkInKBps());
        Assertions.assertEquals((double)bs.followerNetworkInKBps(), (double)rbs.followerNetworkInKBps());
        Assertions.assertEquals((double)bs.networkOutKBps(), (double)rbs.networkOutKBps());
        Assertions.assertEquals((double)bs.potentialNetworkOutKBps(), (double)rbs.potentialNetworkOutKBps());
        Assertions.assertEquals((int)bs.leaders(), (int)rbs.leaders());
        Assertions.assertEquals((int)bs.replicas(), (int)rbs.replicas());
    }

    private AlterBrokerReplicaExclusionsRequest alterBrokerReplicaExclusionsRequestWithBrokerIds(List<Object> brokerIds) {
        return this.alterBrokerReplicaExclusionsRequest((List<AlterReplicaExclusionOp>)brokerIds.map((Function1 & Serializable)x$1 -> RequestHandlerHelperTest.$anonfun$alterBrokerReplicaExclusionsRequestWithBrokerIds$1(BoxesRunTime.unboxToInt((Object)x$1))));
    }

    private AlterBrokerReplicaExclusionsRequest alterBrokerReplicaExclusionsRequest(List<AlterReplicaExclusionOp> exclusionOp2) {
        AlterBrokerReplicaExclusionsRequestData requestData = new AlterBrokerReplicaExclusionsRequestData();
        java.util.List exclusions = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)exclusionOp2.map((Function1 & Serializable)exclusionOp -> new AlterBrokerReplicaExclusionsRequestData.BrokerExclusion().setBrokerId(exclusionOp.brokerId()).setExclusionOperationCode(exclusionOp.opType().id()).setReason(exclusionOp.reason()))).asJava();
        return new AlterBrokerReplicaExclusionsRequest(requestData.setBrokersToExclude(exclusions), ApiKeys.ALTER_BROKER_REPLICA_EXCLUSIONS.latestVersion());
    }

    public static final /* synthetic */ boolean $anonfun$testValidateAlterExclusionRequestThrowsIfInvalidReason$1(String check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ AlterReplicaExclusionOp $anonfun$alterBrokerReplicaExclusionsRequestWithBrokerIds$1(int x$1) {
        return new AlterReplicaExclusionOp(x$1, "reason", ExclusionOp.OpType.SET);
    }
}

