/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.net.Socket;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.network.SocketServer;
import kafka.security.minikdc.MiniKdc;
import kafka.server.AbstractApiVersionsRequestTest;
import kafka.server.IntegrationTestUtils$;
import kafka.server.SaslApiVersionsRequestTest$;
import kafka.test.ClusterConfig;
import kafka.test.ClusterGenerator;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.$less$colon$less$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005s!\u0002\u000b\u0016\u0011\u0003Qb!\u0002\u000f\u0016\u0011\u0003i\u0002\"\u0002\u0013\u0002\t\u0003)\u0003\"\u0002\u0014\u0002\t\u00039c\u0001\u0002\u000f\u0016\u0001MB\u0001b\u000e\u0003\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\u0006I\u0011!\ta\u000f\u0005\b}\u0011\u0011\r\u0011\"\u0001@\u0011\u0019AE\u0001)A\u0005\u0001\"9\u0011\n\u0002b\u0001\n\u0003Q\u0005BB*\u0005A\u0003%1\nC\u0005U\t\u0001\u0007\t\u0019!C\u0005+\"IA\f\u0002a\u0001\u0002\u0004%I!\u0018\u0005\nA\u0012\u0001\r\u0011!Q!\nYCQ!\u0019\u0003\u0005\u0002\tDQ\u0001\u001e\u0003\u0005\u0002UDQa \u0003\u0005\u0002UDa!a\u0001\u0005\t\u0003)\bBBA\u0004\t\u0011\u0005Q\u000fC\u0004\u0002\u0012\u0011!I!a\u0005\u00025M\u000b7\u000f\\!qSZ+'o]5p]N\u0014V-];fgR$Vm\u001d;\u000b\u0005Y9\u0012AB:feZ,'OC\u0001\u0019\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"aG\u0001\u000e\u0003U\u0011!dU1tY\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgR\u001c\"!\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!$\u0001\u0007ti\u0006\u0014G.\u001a.l\u0003BL7\u000f\u0006\u0002)WA\u0011q$K\u0005\u0003U\u0001\u0012A!\u00168ji\")Af\u0001a\u0001[\u0005Iq-\u001a8fe\u0006$xN\u001d\t\u0003]Ej\u0011a\f\u0006\u0003a]\tA\u0001^3ti&\u0011!g\f\u0002\u0011\u00072,8\u000f^3s\u000f\u0016tWM]1u_J\u001c\"\u0001\u0002\u001b\u0011\u0005m)\u0014B\u0001\u001c\u0016\u0005y\t%m\u001d;sC\u000e$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u0016\u001cH/A\u0004dYV\u001cH/\u001a:\u0011\u00059J\u0014B\u0001\u001e0\u0005=\u0019E.^:uKJLen\u001d;b]\u000e,GC\u0001\u001f>!\tYB\u0001C\u00038\r\u0001\u0007\u0001(\u0001\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6,\u0012\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bA\u0001\\1oO*\tQ)\u0001\u0003kCZ\f\u0017BA$C\u0005\u0019\u0019FO]5oO\u0006I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003-\u00032\u0001T)A\u001b\u0005i%B\u0001(P\u0003%IW.\\;uC\ndWM\u0003\u0002QA\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ik%\u0001\u0002'jgR\f!d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ng\u0002\nAa]1tYV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002Z/\u0005\u0019\u0011\r]5\n\u0005mC&!C*bg2\u001cV\r^;q\u0003!\u0019\u0018m\u001d7`I\u0015\fHC\u0001\u0015_\u0011\u001dyF\"!AA\u0002Y\u000b1\u0001\u001f\u00132\u0003\u0015\u0019\u0018m\u001d7!\u0003%\u0019X\r^;q'\u0006\u001cH\u000e\u0006\u0002)G\")AM\u0004a\u0001K\u000611m\u001c8gS\u001e\u0004\"A\f4\n\u0005\u001d|#!D\"mkN$XM]\"p]\u001aLw\r\u000b\u0002\u000fSB\u0011!N]\u0007\u0002W*\u0011\u0011\f\u001c\u0006\u0003[:\fqA[;qSR,'O\u0003\u0002pa\u0006)!.\u001e8ji*\t\u0011/A\u0002pe\u001eL!a]6\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0019uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u\u0005\u00164wN]3TCNd\u0007*\u00198eg\"\f7.\u001a*fcV,7\u000f\u001e\u000b\u0002Q!\"qb^?\u007f!\tA80D\u0001z\u0015\tQx&\u0001\u0006b]:|G/\u0019;j_:L!\u0001`=\u0003\u001f\rcWo\u001d;feR+W\u000e\u001d7bi\u0016\fQA^1mk\u0016\f\u0013AJ\u00010i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti\u00063G/\u001a:TCNd\u0007*\u00198eg\"\f7.\u001a*fcV,7\u000f\u001e\u0015\u0005!]lh0\u0001\u0017uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u/&$\b.\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\"\"\u0011c^?\u007f\u0003%\u0019Gn\\:f'\u0006\u001cH\u000eK\u0002\u0013\u0003\u0017\u00012A[A\u0007\u0013\r\tya\u001b\u0002\n\u0003\u001a$XM]#bG\"\f\u0001f]3oIN\u000b7\u000f\u001c%b]\u0012\u001c\b.Y6f%\u0016\fX/Z:u-\u0006d\u0017\u000eZ1uKJ+7\u000f]8og\u0016$2\u0001KA\u000b\u0011\u001d\t9b\u0005a\u0001\u00033\taa]8dW\u0016$\b\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}A)A\u0002oKRLA!a\t\u0002\u001e\t11k\\2lKRDc\u0001BA\u0014{\u0006M\u0002\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u000552.A\u0005fqR,gn]5p]&!\u0011\u0011GA\u0016\u0005))\u0005\u0010^3oI^KG\u000f\u001b\u0017\u0003\u0003k\u0019#!a\u000e\u0011\t\u0005e\u0012QH\u0007\u0003\u0003wQ!a\\\u0018\n\t\u0005}\u00121\b\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8t\u0001")
public class SaslApiVersionsRequestTest
extends AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private SaslSetup sasl;

    public static void stableZkApis(ClusterGenerator generator) {
        SaslApiVersionsRequestTest$.MODULE$.stableZkApis(generator);
    }

    public String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    public List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private SaslSetup sasl() {
        return this.sasl;
    }

    private void sasl_$eq(SaslSetup x$1) {
        this.sasl = x$1;
    }

    @BeforeEach
    public void setupSasl(ClusterConfig config) {
        this.sasl_$eq(new SaslSetup(null){
            private File kafka$api$SaslSetup$$workDir;
            private Properties kafka$api$SaslSetup$$kdcConf;
            private MiniKdc kafka$api$SaslSetup$$kdc;
            private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
            private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

            public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
                SaslSetup.startSasl$(this, jaasSections);
            }

            public void initializeKerberos() {
                SaslSetup.initializeKerberos$(this);
            }

            public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
                return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
            }

            public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
                return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
            }

            public SaslSetupMode jaasSections$default$3() {
                return SaslSetup.jaasSections$default$3$(this);
            }

            public String jaasSections$default$4() {
                return SaslSetup.jaasSections$default$4$(this);
            }

            public void closeSasl() {
                SaslSetup.closeSasl$(this);
            }

            public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
                return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
            }

            public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
                return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
            }

            public boolean kafkaClientSaslProperties$default$2() {
                return SaslSetup.kafkaClientSaslProperties$default$2$(this);
            }

            public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
                return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
            }

            public Option<String> jaasClientLoginModule$default$2() {
                return SaslSetup.jaasClientLoginModule$default$2$(this);
            }

            public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
                return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
            }

            public Option<String> jaasAdminLoginModule$default$2() {
                return SaslSetup.jaasAdminLoginModule$default$2$(this);
            }

            public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
                return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
            }

            public Admin createPrivilegedAdminClient() {
                return SaslSetup.createPrivilegedAdminClient$(this);
            }

            public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
                return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
            }

            public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
                SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
            }

            public void createScramCredentials(Admin adminClient, String userName, String password) {
                SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
            }

            public void createScramCredentials(String zkConnect, String userName, String password) {
                SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
            }

            public File kafka$api$SaslSetup$$workDir() {
                return this.kafka$api$SaslSetup$$workDir;
            }

            public Properties kafka$api$SaslSetup$$kdcConf() {
                return this.kafka$api$SaslSetup$$kdcConf;
            }

            public MiniKdc kafka$api$SaslSetup$$kdc() {
                return this.kafka$api$SaslSetup$$kdc;
            }

            public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
                this.kafka$api$SaslSetup$$kdc = x$1;
            }

            public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
                return this.kafka$api$SaslSetup$$serverKeytabFile;
            }

            public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
                this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
            }

            public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
                return this.kafka$api$SaslSetup$$clientKeytabFile;
            }

            public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
                this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
            }

            public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
                this.kafka$api$SaslSetup$$workDir = x$1;
            }

            public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
                this.kafka$api$SaslSetup$$kdcConf = x$1;
            }
            {
                SaslSetup.$init$(this);
                Statics.releaseFence();
            }
        });
        this.sasl().startSasl(this.sasl().jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        config.saslServerProperties().putAll((Map<?, ?>)this.sasl().kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        SaslSetup qual$1 = this.sasl();
        String x$1 = this.kafkaClientSaslMechanism();
        boolean x$2 = qual$1.kafkaClientSaslProperties$default$2();
        config.saslClientProperties().putAll((Map<?, ?>)qual$1.kafkaClientSaslProperties(x$1, x$2));
        super.brokerPropertyOverrides(config.serverProperties());
    }

    @ClusterTemplate(value="stableZkApis")
    public void testApiVersionsRequestBeforeSaslHandshakeRequest() {
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head(), this.cluster.clientListener());){
            ApiVersionsResponse apiVersionsResponse = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, "client-id", (Option<Object>)None$.MODULE$, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            this.validateApiVersionsResponse(apiVersionsResponse, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
            this.sendSaslHandshakeRequestValidateResponse(socket);
        }
    }

    @ClusterTemplate(value="stableZkApis")
    public void testApiVersionsRequestAfterSaslHandshakeRequest() {
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head(), this.cluster.clientListener());){
            this.sendSaslHandshakeRequestValidateResponse(socket);
            ApiVersionsResponse response = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, "client-id", (Option<Object>)None$.MODULE$, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            Assertions.assertEquals((short)Errors.ILLEGAL_SASL_STATE.code(), (short)response.data().errorCode());
        }
    }

    @ClusterTemplate(value="stableZkApis")
    public void testApiVersionsRequestWithUnsupportedVersion() {
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head(), this.cluster.clientListener());){
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
            ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
            Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)apiVersionsResponse.data().errorCode());
            ApiVersionsResponse apiVersionsResponse2 = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, "client-id", (Option<Object>)None$.MODULE$, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            this.validateApiVersionsResponse(apiVersionsResponse2, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
            this.sendSaslHandshakeRequestValidateResponse(socket);
        }
    }

    @AfterEach
    public void closeSasl() {
        this.sasl().closeSasl();
    }

    private void sendSaslHandshakeRequestValidateResponse(Socket socket) {
        SaslHandshakeRequest request = new SaslHandshakeRequest(new SaslHandshakeRequestData().setMechanism("PLAIN"), ApiKeys.SASL_HANDSHAKE.latestVersion());
        SaslHandshakeResponse response = (SaslHandshakeResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)request, socket, "client-id", (Option<Object>)None$.MODULE$, ClassTag$.MODULE$.apply(SaslHandshakeResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
        Assertions.assertEquals(Collections.singletonList("PLAIN"), (Object)response.enabledMechanisms());
    }

    public SaslApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)"PLAIN", (List)Nil$.MODULE$);
    }
}

