/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.OptionalInt;
import java.util.Properties;
import kafka.common.InconsistentBrokerIdException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.test.TestUtils;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001\u0002\u000e\u001c\u0001\u0001BQ!\n\u0001\u0005\u0002\u0019B\u0011\u0002\u000b\u0001A\u0002\u0003\u0007I\u0011A\u0015\t\u0013I\u0002\u0001\u0019!a\u0001\n\u0003\u0019\u0004\"\u0003\u001f\u0001\u0001\u0004\u0005\t\u0015)\u0003+\u0011%i\u0004\u00011AA\u0002\u0013\u0005a\bC\u0005C\u0001\u0001\u0007\t\u0019!C\u0001\u0007\"IQ\t\u0001a\u0001\u0002\u0003\u0006Ka\u0010\u0005\n\r\u0002\u0001\r\u00111A\u0005\u0002%B\u0011b\u0012\u0001A\u0002\u0003\u0007I\u0011\u0001%\t\u0013)\u0003\u0001\u0019!A!B\u0013Q\u0003\"C&\u0001\u0001\u0004\u0005\r\u0011\"\u0001?\u0011%a\u0005\u00011AA\u0002\u0013\u0005Q\nC\u0005P\u0001\u0001\u0007\t\u0011)Q\u0005\u007f!9\u0001\u000b\u0001a\u0001\n\u0003\t\u0006bB.\u0001\u0001\u0004%\t\u0001\u0018\u0005\u0007=\u0002\u0001\u000b\u0015\u0002*\t\u000b}\u0003A\u0011\t1\t\u000bM\u0004A\u0011\t;\t\u000be\u0004A\u0011\u0001;\t\u000by\u0004A\u0011\u0001;\t\r\u0005\u0005\u0001\u0001\"\u0001u\u0011\u0019\t)\u0001\u0001C\u0001i\"1\u0011\u0011\u0002\u0001\u0005\u0002QDa!!\u0004\u0001\t\u0003!\bbBA\t\u0001\u0011\u0005\u00111\u0003\u0002\u001b'\u0016\u0014h/\u001a:HK:,'/\u0019;f\u0005J|7.\u001a:JIR+7\u000f\u001e\u0006\u00039u\taa]3sm\u0016\u0014(\"\u0001\u0010\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\t\t\u0003E\rj\u0011aG\u0005\u0003Im\u0011\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002#\u0001\u00051\u0001O]8qgF*\u0012A\u000b\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nA!\u001e;jY*\tq&\u0001\u0003kCZ\f\u0017BA\u0019-\u0005)\u0001&o\u001c9feRLWm]\u0001\u000baJ|\u0007o]\u0019`I\u0015\fHC\u0001\u001b;!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0011)f.\u001b;\t\u000fm\u001a\u0011\u0011!a\u0001U\u0005\u0019\u0001\u0010J\u0019\u0002\u000fA\u0014x\u000e]:2A\u000591m\u001c8gS\u001e\fT#A \u0011\u0005\t\u0002\u0015BA!\u001c\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0017\r|gNZ5hc}#S-\u001d\u000b\u0003i\u0011Cqa\u000f\u0004\u0002\u0002\u0003\u0007q(\u0001\u0005d_:4\u0017nZ\u0019!\u0003\u0019\u0001(o\u001c9te\u0005Q\u0001O]8qgJzF%Z9\u0015\u0005QJ\u0005bB\u001e\n\u0003\u0003\u0005\rAK\u0001\baJ|\u0007o\u001d\u001a!\u0003\u001d\u0019wN\u001c4jOJ\n1bY8oM&<'g\u0018\u0013fcR\u0011AG\u0014\u0005\bw1\t\t\u00111\u0001@\u0003!\u0019wN\u001c4jOJ\u0002\u0013aB:feZ,'o]\u000b\u0002%B\u00191K\u0016-\u000e\u0003QS!!\u0016\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002X)\n\u00191+Z9\u0011\u0005\tJ\u0016B\u0001.\u001c\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003iuCqaO\b\u0002\u0002\u0003\u0007!+\u0001\u0005tKJ4XM]:!\u0003\u0015\u0019X\r^+q)\t!\u0014\rC\u0003c#\u0001\u00071-\u0001\u0005uKN$\u0018J\u001c4p!\t!W.D\u0001f\u0015\t1w-A\u0002ba&T!\u0001[5\u0002\u000f),\b/\u001b;fe*\u0011!n[\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002Y\u0006\u0019qN]4\n\u00059,'\u0001\u0003+fgRLeNZ8)\u0005E\u0001\bC\u00013r\u0013\t\u0011XM\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002i!\u0012!C\u001e\t\u0003I^L!\u0001_3\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\u0007;fgR\fU\u000f^8HK:,'/\u0019;f\u0005J|7.\u001a:JI\"\u00121c\u001f\t\u0003IrL!!`3\u0003\tQ+7\u000f^\u0001#i\u0016\u001cH/V:fe\u000e{gNZ5h\u0003:$w)\u001a8fe\u0006$X\r\u001a\"s_.,'/\u00133)\u0005QY\u0018\u0001\b;fgR$\u0015n]1cY\u0016<UM\\3sCR,GM\u0011:pW\u0016\u0014\u0018\n\u001a\u0015\u0003+m\fA\u0004^3ti6+H\u000e^5qY\u0016dun\u001a#jeNlU\r^1Qe>\u00048\u000f\u000b\u0002\u0017w\u0006\u0001D/Z:u\u0007>t7/[:uK:$(I]8lKJLEM\u0012:p[V\u001bXM]\"p]\u001aLw-\u00118e\u001b\u0016$\u0018\r\u0015:paND#aF>\u0002?Q,7\u000f\u001e\"s_.,'/T3uC\u0012\fG/Y(o\u0013\u0012\u001cu\u000e\u001c7jg&|g\u000e\u000b\u0002\u0019w\u0006!b/\u001a:jMf\u0014%o\\6fe6+G/\u00193bi\u0006$b!!\u0006\u0002\u001c\u0005]\u0002cA\u001b\u0002\u0018%\u0019\u0011\u0011\u0004\u001c\u0003\u000f\t{w\u000e\\3b]\"9\u0011QD\rA\u0002\u0005}\u0011a\u00027pO\u0012K'o\u001d\t\u0005'Z\u000b\t\u0003\u0005\u0003\u0002$\u0005Eb\u0002BA\u0013\u0003[\u00012!a\n7\u001b\t\tICC\u0002\u0002,}\ta\u0001\u0010:p_Rt\u0014bAA\u0018m\u00051\u0001K]3eK\u001aLA!a\r\u00026\t11\u000b\u001e:j]\u001eT1!a\f7\u0011\u001d\tI$\u0007a\u0001\u0003w\t\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0004k\u0005u\u0012bAA m\t\u0019\u0011J\u001c;")
public class ServerGenerateBrokerIdTest
extends QuorumTestHarness {
    private Properties props1;
    private KafkaConfig config1;
    private Properties props2;
    private KafkaConfig config2;
    private Seq<KafkaServer> servers = Nil$.MODULE$;

    public Properties props1() {
        return this.props1;
    }

    public void props1_$eq(Properties x$1) {
        this.props1 = x$1;
    }

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public Properties props2() {
        return this.props2;
    }

    public void props2_$eq(Properties x$1) {
        this.props2 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.props1_$eq(TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        this.props2_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(this.props2()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), true);
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoGenerateBrokerId() {
        void createServer_createServer_createServer_startup;
        void createServer_threadNamePrefix;
        void createServer_config;
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        boolean x$4 = false;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        KafkaConfig kafkaConfig = this.config1();
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Time createServer_createServer_time = Time.SYSTEM;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var9_9 = null;
        Object var6_8 = null;
        kafkaConfig = null;
        option = null;
        server1 = createServer_this.createServer((KafkaConfig)createServer_config, createServer_createServer_time, (Option<String>)createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        Assertions.assertEquals((int)server1.config().brokerId(), (int)1001);
        server1.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testUserConfigAndGeneratedBrokerId() {
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        boolean x$4 = false;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        KafkaConfig x$52 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = Time.SYSTEM;
        boolean x$8 = false;
        KafkaServer server2 = new KafkaServer(x$52, x$7, x$6, x$8);
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig x$9 = KafkaConfig$.MODULE$.fromProps(props3);
        Option x$10 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$11 = Time.SYSTEM;
        boolean x$12 = false;
        KafkaServer server3 = new KafkaServer(x$9, x$11, x$10, x$12);
        server1.startup();
        Assertions.assertEquals((int)server1.config().brokerId(), (int)1001);
        server2.startup();
        Assertions.assertEquals((int)server2.config().brokerId(), (int)0);
        server3.startup();
        Assertions.assertEquals((int)server3.config().brokerId(), (int)1002);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)new .colon.colon((Object)server3, (List)Nil$.MODULE$))));
        this.servers().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server1.config().logDirs(), 1001));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server2.config().logDirs(), 0));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 1002));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDisableGeneratedBrokerId() {
        void createServer_createServer_createServer_startup;
        void createServer_threadNamePrefix;
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props3.put(KafkaConfig$.MODULE$.BrokerIdGenerationEnableProp(), "false");
        props3.put(KafkaConfig$.MODULE$.MaxReservedBrokerIdProp(), "0");
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(props3);
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Time createServer_createServer_time = Time.SYSTEM;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var6_5 = null;
        Object var4_4 = null;
        option = null;
        KafkaServer server3 = createServer_this.createServer(config3, createServer_createServer_time, (Option<String>)createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server3, (List)Nil$.MODULE$));
        Assertions.assertEquals((int)server3.config().brokerId(), (int)3);
        server3.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 3));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testMultipleLogDirsMetaProps() {
        String logDirs = new StringBuilder(2).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append(",").append(TestUtils.tempDirectory(null, null).getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", logDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        boolean x$4 = false;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        String newLogDirs = new StringBuilder(1).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils.tempDirectory(null, null).getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", newLogDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$5 = this.config1();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = Time.SYSTEM;
        boolean x$8 = false;
        server1 = new KafkaServer(x$5, x$7, x$6, x$8);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testConsistentBrokerIdFromUserConfigAndMetaProps() {
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        boolean x$4 = false;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        KafkaConfig x$5 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = Time.SYSTEM;
        boolean x$8 = false;
        server1 = new KafkaServer(x$5, x$7, x$6, x$8);
        try {
            server1.startup();
        }
        catch (InconsistentBrokerIdException inconsistentBrokerIdException) {}
        server1.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerMetadataOnIdCollision() {
        void createServer_createServer_createServer_startup;
        void createServer_threadNamePrefix;
        Properties propsA = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig configA = KafkaConfig$.MODULE$.fromProps(propsA);
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Time createServer_createServer_time = Time.SYSTEM;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var23_5 = null;
        Object var21_4 = null;
        option = null;
        KafkaServer serverA = createServer_this.createServer(configA, createServer_createServer_time, (Option<String>)createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        Properties propsB = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig configB = KafkaConfig$.MODULE$.fromProps(propsB);
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        boolean x$4 = false;
        KafkaServer serverB = new KafkaServer(configB, x$3, x$2, x$4);
        Assertions.assertThrows(KeeperException.NodeExistsException.class, () -> serverB.startup());
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)serverA, (List)Nil$.MODULE$));
        propsB.setProperty(KafkaConfig$.MODULE$.BrokerIdProp(), "2");
        KafkaConfig x$5 = KafkaConfig$.MODULE$.fromProps(propsB);
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = Time.SYSTEM;
        boolean x$8 = false;
        KafkaServer serverB2 = new KafkaServer(x$5, x$7, x$6, x$8);
        RuntimeException startupException = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serverB2.startup());
        Assertions.assertTrue((boolean)startupException.getMessage().startsWith("Stored node id 1 doesn't match previous node id 2"), (String)new StringBuilder(29).append("Unexpected exception message ").append(startupException.getMessage()).toString());
        serverB2.config().logDirs().foreach((Function1 & Serializable)logDir -> {
            ServerGenerateBrokerIdTest.$anonfun$testBrokerMetadataOnIdCollision$3(logDir);
            return BoxedUnit.UNIT;
        });
        propsB.setProperty(KafkaConfig$.MODULE$.BrokerIdProp(), "3");
        KafkaConfig x$9 = KafkaConfig$.MODULE$.fromProps(propsB);
        Option x$10 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$11 = Time.SYSTEM;
        boolean x$12 = false;
        KafkaServer serverB3 = new KafkaServer(x$9, x$11, x$10, x$12);
        serverB3.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)serverA, (List)new .colon.colon((Object)serverB3, (List)Nil$.MODULE$)));
        serverA.shutdown();
        serverB3.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)serverA.config().logDirs(), 1));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)serverB3.config().logDirs(), 3));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, int brokerId) {
        Object object = new Object();
        try {
            logDirs.foreach((Function1 & Serializable)logDir -> {
                ServerGenerateBrokerIdTest.$anonfun$verifyBrokerMetadata$1(brokerId, object, logDir);
                return BoxedUnit.UNIT;
            });
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$testBrokerMetadataOnIdCollision$3(String logDir) {
        Utils.delete((File)new File(logDir), (boolean)false);
    }

    public static final /* synthetic */ void $anonfun$verifyBrokerMetadata$1(int brokerId$1, Object nonLocalReturnKey1$1, String logDir) {
        Properties properties = PropertiesUtils.readPropertiesFile((String)new File(logDir, "meta.properties").getAbsolutePath());
        if (!new MetaProperties.Builder(properties).build().nodeId().equals(OptionalInt.of(brokerId$1))) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }
}

