/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.StateChangeLogger;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction1;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0005\t}d\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004?\u0001\u0001\u0006IA\u000e\u0005\b\u007f\u0001\u0011\r\u0011\"\u00016\u0011\u0019\u0001\u0005\u0001)A\u0005m!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0005BB'\u0001A\u0003%1\tC\u0004O\u0001\t\u0007I\u0011\u0001\"\t\r=\u0003\u0001\u0015!\u0003D\u0011\u001d\u0001\u0006A1A\u0005\u0002ECa\u0001\u0017\u0001!\u0002\u0013\u0011\u0006bB-\u0001\u0001\u0004%\tA\u0017\u0005\bE\u0002\u0001\r\u0011\"\u0001d\u0011\u0019I\u0007\u0001)Q\u00057\")!\u000e\u0001C!W\")\u0001\u000f\u0001C!c\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!!\"\u0001\t\u0003\t9\tC\u0004\u0002\u0014\u0002!I!!&\t\u000f\u0005-\u0007\u0001\"\u0003\u0002N\"A\u00111\u001f\u0001!\n\u0013\t)\u0010C\u0004\u0003\b\u0001!\tA!\u0003\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e!9!q\u0003\u0001\u0005\u0002\te\u0001b\u0002B\"\u0001\u0011\u0005!Q\t\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0011\u001d\u0011Y\u0006\u0001C\u0005\u0005;BqAa\u0018\u0001\t\u0013\u0011\t\u0007C\u0004\u0003j\u0001!IA!\u0003\t\u000f\t-\u0004\u0001\"\u0003\u0003\n!9!Q\u000e\u0001\u0005\n\t=$AE*feZ,'o\u00155vi\u0012|wO\u001c+fgRT!!\n\u0014\u0002\rM,'O^3s\u0015\u00059\u0013!B6bM.\f7\u0001A\n\u0003\u0001)\u0002\"a\u000b\u0018\u000e\u00031R!!\f\u0014\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003_1\u0012acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0002\"a\r\u0001\u000e\u0003\u0011\nA\u0001[8tiV\ta\u0007\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005!A.\u00198h\u0015\u0005Y\u0014\u0001\u00026bm\u0006L!!\u0010\u001d\u0003\rM#(/\u001b8h\u0003\u0015Awn\u001d;!\u0003\u0015!x\u000e]5d\u0003\u0019!x\u000e]5dA\u0005)1/\u001a8ucU\t1\tE\u0002E\u0017Zj\u0011!\u0012\u0006\u0003\r\u001e\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005!K\u0015AC2pY2,7\r^5p]*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u000b\n!A*[:u\u0003\u0019\u0019XM\u001c;2A\u0005)1/\u001a8ue\u000511/\u001a8ue\u0001\n\u0001\u0004\u001d:paN$vn\u00115b]\u001e,W\u000b]8o%\u0016\u001cH/\u0019:u+\u0005\u0011\u0006CA*W\u001b\u0005!&BA+;\u0003\u0011)H/\u001b7\n\u0005]#&A\u0003)s_B,'\u000f^5fg\u0006I\u0002O]8qgR{7\t[1oO\u0016,\u0006o\u001c8SKN$\u0018M\u001d;!\u0003-\u0001(/[8s\u0007>tg-[4\u0016\u0003m\u00032\u0001X/`\u001b\u0005I\u0015B\u00010J\u0005\u0019y\u0005\u000f^5p]B\u00111\u0007Y\u0005\u0003C\u0012\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006y\u0001O]5pe\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0002eOB\u0011A,Z\u0005\u0003M&\u0013A!\u00168ji\"9\u0001.DA\u0001\u0002\u0004Y\u0016a\u0001=%c\u0005a\u0001O]5pe\u000e{gNZ5hA\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001m!\rignX\u0007\u0002\u000f&\u0011qn\u0012\u0002\u0004'\u0016\f\u0018!B:fiV\u0003HC\u00013s\u0011\u0015\u0019\b\u00031\u0001u\u0003!!Xm\u001d;J]\u001a|\u0007CA;\u007f\u001b\u00051(BA<y\u0003\r\t\u0007/\u001b\u0006\u0003sj\fqA[;qSR,'O\u0003\u0002|y\u0006)!.\u001e8ji*\tQ0A\u0002pe\u001eL!a <\u0003\u0011Q+7\u000f^%oM>D3\u0001EA\u0002!\r)\u0018QA\u0005\u0004\u0003\u000f1(A\u0003\"fM>\u0014X-R1dQ\u0006\tB/Z:u\u00072,\u0017M\\*ikR$wn\u001e8\u0015\u0007\u0011\fi\u0001C\u0004\u0002\u0010E\u0001\r!!\u0005\u0002\rE,xN];n!\u0011\t\u0019\"!\t\u000f\t\u0005U\u0011Q\u0004\t\u0004\u0003/IUBAA\r\u0015\r\tY\u0002K\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}\u0011*\u0001\u0004Qe\u0016$WMZ\u0005\u0004{\u0005\r\"bAA\u0010\u0013\":\u0011#a\n\u00024\u0005U\u0002\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055\u00020\u0001\u0004qCJ\fWn]\u0005\u0005\u0003c\tYCA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u0011qG\u0001#w\u0012L7\u000f\u001d7bs:\u000bW.Z?/w\u0006\u0014x-^7f]R\u001cx+\u001b;i\u001d\u0006lWm]?)\u000fE\tY$a\u0012\u0002JA!\u0011QHA\"\u001b\t\tyD\u0003\u0003\u0002B\u0005-\u0012\u0001\u00039s_ZLG-\u001a:\n\t\u0005\u0015\u0013q\b\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005-\u0013qJ\u0011\u0003\u0003\u001b\n!A_6\"\u0005\u0005E\u0013!B6sC\u001a$\u0018a\t;fgR\u001cE.Z1o'\",H\u000fZ8x]\u00063G/\u001a:GC&dW\rZ*uCJ$X\u000f\u001d\u000b\u0004I\u0006]\u0003bBA\b%\u0001\u0007\u0011\u0011\u0003\u0015\b%\u0005\u001d\u00121GA\u001bQ\u001d\u0011\u00121HA$\u0003;bC!a\u0013\u0002P\u0005)D/Z:u\u001d>\u001cE.Z1o'\",H\u000fZ8x]\u00063G/\u001a:GC&dW\rZ*uCJ$X\u000f\u001d#vKR{7i\u001c:skB$Hj\\4t)\r!\u00171\r\u0005\b\u0003\u001f\u0019\u0002\u0019AA\tQ\u001d\u0019\u0012qEA\u001a\u0003kAsaEA\u001e\u0003\u000f\nI\u0007\f\u0002\u0002P\u0005\u0011C/Z:u\u00072,\u0017M\\*ikR$wn\u001e8XSRD'l[+oCZ\f\u0017\u000e\\1cY\u0016$2\u0001ZA8\u0011\u001d\ty\u0001\u0006a\u0001\u0003#As\u0001FA\u0014\u0003g\t)\u0004K\u0004\u0015\u0003w\t9%!\u001e-\u0005\u0005-\u0003f\u0002\u000b\u0002z\u0005}\u0014\u0011\u0011\t\u0004k\u0006m\u0014bAA?m\nAA)[:bE2,G-A\u0003wC2,X-\t\u0002\u0002\u0004\u0006A1*T#U\u00036\u001a\u0004(A\u0018uKN$8\t\\3b]NCW\u000f\u001e3po:<\u0016\u000e\u001e5L%\u00064GoQ8oiJ|G\u000e\\3s+:\fg/Y5mC\ndW\rF\u0002e\u0003\u0013Cq!a\u0004\u0016\u0001\u0004\t\t\u0002K\u0002\u0016\u0003sBs!FA\u0014\u0003g\t)\u0004K\u0004\u0016\u0003w\t9%!%-\u0005\u0005=\u0013!\n<fe&4\u0017p\u00117fC:\u001c\u0006.\u001e;e_^t\u0017I\u001a;fe\u001a\u000b\u0017\u000e\\3e'R\f'\u000f^;q+\u0011\t9*!,\u0015\u0007\u0011\fI\nC\u0004\u0002\u001cZ\u0001\u001d!!(\u0002#\u0015D8-\u001a9uS>t7\t\\1tgR\u000bw\r\u0005\u0004\u0002 \u0006\u0015\u0016\u0011V\u0007\u0003\u0003CS1!a)J\u0003\u001d\u0011XM\u001a7fGRLA!a*\u0002\"\nA1\t\\1tgR\u000bw\r\u0005\u0003\u0002,\u00065F\u0002\u0001\u0003\b\u0003_3\"\u0019AAY\u0005\u0005)\u0015\u0003BAZ\u0003s\u00032\u0001XA[\u0013\r\t9,\u0013\u0002\b\u001d>$\b.\u001b8h!\u0011\tY,!2\u000f\t\u0005u\u0016\u0011\u0019\b\u0005\u0003/\ty,C\u0001K\u0013\r\t\u0019-S\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9-!3\u0003\u0013\u0015C8-\u001a9uS>t'bAAb\u0013\u0006Y\u0011m]:feR\u001c\u0015-^:f)\u0015!\u0017qZAu\u0011\u001d\t\tn\u0006a\u0001\u0003'\fQ\"\u001a=qK\u000e$X\rZ\"mCN\u001c\b\u0007BAk\u0003;\u0004b!a\u0005\u0002X\u0006m\u0017\u0002BAm\u0003G\u0011Qa\u00117bgN\u0004B!a+\u0002^\u0012a\u0011q\\Ah\u0003\u0003\u0005\tQ!\u0001\u0002b\n\u0019q\fJ\u0019\u0012\t\u0005M\u00161\u001d\t\u00049\u0006\u0015\u0018bAAt\u0013\n\u0019\u0011I\\=\t\u000f\u0005-x\u00031\u0001\u0002n\u0006\tQ\r\u0005\u0003\u0002<\u0006=\u0018\u0002BAy\u0003\u0013\u0014\u0011\u0002\u00165s_^\f'\r\\3\u0002-%\u001chj\u001c8EC\u0016lwN\\&bM.\fG\u000b\u001b:fC\u0012$B!a>\u0002~B\u0019A,!?\n\u0007\u0005m\u0018JA\u0004C_>dW-\u00198\t\u000f\u0005}\b\u00041\u0001\u0003\u0002\u0005\tA\u000fE\u00028\u0005\u0007I1A!\u00029\u0005\u0019!\u0006N]3bI\u0006ab/\u001a:jMftuN\u001c#bK6|g\u000e\u00165sK\u0006$7o\u0015;biV\u001cH#\u00013\u0002/Q,7\u000f^\"p]N,7-\u001e;jm\u0016\u001c\u0006.\u001e;e_^tGc\u00013\u0003\u0010!9\u0011q\u0002\u000eA\u0002\u0005E\u0001f\u0002\u000e\u0002(\u0005M\u0012Q\u0007\u0015\b5\u0005m\u0012q\tB\u000bY\u0011\tY%a\u0014\u0002#Q,7\u000f\u001e\"fO&t7\u000b[;uI><h\u000eF\u0003e\u00057\u0011i\u0002C\u0004\u0002\u0010m\u0001\r!!\u0005\t\u000f\t}1\u00041\u0001\u0003\"\u0005ya.^7IiR\u0004(+Z9vKN$8\u000fE\u0002]\u0005GI1A!\nJ\u0005\rIe\u000e\u001e\u0015\b7\u0005\u001d\u00121GA\u001bQ\u001dY\"1FA@\u0005c\u0001B!!\u0010\u0003.%!!qFA \u0005%\u00195O^*pkJ\u001cW\r\f\u0005\u00034\t]\"1\bB C\t\u0011)$\u0001\u0003{W2\n\u0014E\u0001B\u001d\u0003\u0011Q8\u000e\f\u001a\"\u0005\tu\u0012aB6sC\u001a$H&M\u0011\u0003\u0005\u0003\nqa\u001b:bMRd#'A\u000euKN$()Z4j]NCW\u000f\u001e3po:<&o\u001c8h\u000bB|7\r\u001b\u000b\u0004I\n\u001d\u0003bBA\b9\u0001\u0007\u0011\u0011\u0003\u0015\b9\u0005\u001d\u00121GA\u001bQ\u001da\u00121HA$\u0005\u001bbC!a\u0013\u0002P\u0005\u0001C/Z:u\u0007>tGO]8mY\u0016\u00148\u000b[;uI><h\u000eR;sS:<7+\u001a8e)\r!'1\u000b\u0005\b\u0003\u001fi\u0002\u0019AA\tQ\u001di\u0012qEA\u001a\u0003kAs!HA\u001e\u0003\u000f\u0012I\u0006\f\u0002\u0002L\u000511m\u001c8gS\u001e,\u0012aX\u0001\u0007EJ|7.\u001a:\u0016\u0005\t\r\u0004cA\u001a\u0003f%\u0019!q\r\u0013\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\u000fg\",H\u000fZ8x]\n\u0013xn[3s\u00035\u0011Xm\u001d;beR\u0014%o\\6fe\u0006q!/Z2sK\u0006$XM\u0011:pW\u0016\u0014Hc\u00013\u0003r!9!1\u000f\u0012A\u0002\u0005]\u0018aB:uCJ$X\u000f\u001d\u0015\b\u0001\t]\u0014q\u0010B?!\r)(\u0011P\u0005\u0004\u0005w2(a\u0002+j[\u0016|W\u000f\u001e\u0010\u0002y\u0001")
public class ServerShutdownTest
extends KafkaServerTestHarness {
    private final String host;
    private final String topic;
    private final List<String> sent1 = new .colon.colon((Object)"hello", (List)new .colon.colon((Object)"there", (List)Nil$.MODULE$));
    private final List<String> sent2 = new .colon.colon((Object)"more", (List)new .colon.colon((Object)"messages", (List)Nil$.MODULE$));
    private final Properties propsToChangeUponRestart = new Properties();
    private Option<KafkaConfig> priorConfig = None$.MODULE$;

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    public Properties propsToChangeUponRestart() {
        return this.propsToChangeUponRestart;
    }

    public Option<KafkaConfig> priorConfig() {
        return this.priorConfig;
    }

    public void priorConfig_$eq(Option<KafkaConfig> x$1) {
        this.priorConfig = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        this.priorConfig().foreach((Function1 & Serializable)config -> {
            java.util.Map originals = config.originals();
            Object logDirsValue = originals.get(KafkaConfig$.MODULE$.LogDirsProp());
            if (logDirsValue != null) {
                return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirsProp(), logDirsValue);
            }
            return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirProp(), originals.get(KafkaConfig$.MODULE$.LogDirProp()));
        });
        this.priorConfig_$eq((Option<KafkaConfig>)new Some((Object)KafkaConfig$.MODULE$.fromProps((Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head(), this.propsToChangeUponRestart(), true)));
        return new .colon.colon((Object)((KafkaConfig)this.priorConfig().get()), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.priorConfig_$eq((Option<KafkaConfig>)None$.MODULE$);
        this.propsToChangeUponRestart().clear();
        super.setUp(testInfo);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdown(String quorum) {
        ObjectRef producer = ObjectRef.create((Object)this.createProducer$1());
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sent1().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
        this.killBroker(0);
        this.config().logDirs().foreach((Function1 & Serializable)logDir -> {
            ServerShutdownTest.$anonfun$testCleanShutdown$3(logDir);
            return BoxedUnit.UNIT;
        });
        ((KafkaProducer)producer.elem).close();
        this.restartBroker();
        TestUtils$.MODULE$.waitForPartitionMetadata(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), this.topic(), 0, 15000L);
        producer.elem = this.createProducer$1();
        Consumer consumer = this.createConsumer$1();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Seq consumerRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.sent1().size(), 15000L);
        Assertions.assertEquals(this.sent1(), (Object)consumerRecords.map((Function1 & Serializable)x$2 -> (String)x$2.value()));
        this.sent2().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get());
        Seq consumerRecords2 = TestUtils$.MODULE$.consumeRecords(consumer, this.sent2().size(), 15000L);
        Assertions.assertEquals(this.sent2(), (Object)consumerRecords2.map((Function1 & Serializable)x$4 -> (String)x$4.value()));
        consumer.close();
        ((KafkaProducer)producer.elem).close();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdownAfterFailedStartup(String quorum) {
        if (this.isKRaftTest()) {
            this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.InitialBrokerRegistrationTimeoutMsProp(), "1000");
            this.killBroker(0);
            this.shutdownKRaftController();
            this.verifyCleanShutdownAfterFailedStartup(ClassTag$.MODULE$.apply(CancellationException.class));
            return;
        }
        this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "50");
        this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "some.invalid.hostname.foo.bar.local:65535");
        this.verifyCleanShutdownAfterFailedStartup(ClassTag$.MODULE$.apply(ZooKeeperClientTimeoutException.class));
    }

    /*
     * Unable to fully structure code
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft"})
    public void testNoCleanShutdownAfterFailedStartupDueToCorruptLogs(String quorum) {
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.killBroker(0);
        this.config().logDirs().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1$adapted(kafka.server.ServerShutdownTest java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((ServerShutdownTest)this));
        expectedStatusCode = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        receivedStatusCode = VolatileObjectRef.create((Object)Option$.MODULE$.empty());
        hasHaltProcedureCalled = VolatileBooleanRef.create((boolean)false);
        setHaltProcedure_haltProcedure = (Function2 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3$adapted(scala.runtime.VolatileBooleanRef scala.runtime.VolatileObjectRef java.lang.Object scala.Option ), (Ljava/lang/Object;Lscala/Option;)Lscala/runtime/Nothing$;)((VolatileBooleanRef)hasHaltProcedureCalled, (VolatileObjectRef)receivedStatusCode);
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        var6_5 = null;
        try {
            Assertions.assertDoesNotThrow((Executable)(Executable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$4(kafka.server.ServerShutdownTest ), ()V)((ServerShutdownTest)this));
            var9_6 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if (!hasHaltProcedureCalled.elem) ** GOTO lbl-1000
                v0 = expectedStatusCode;
                var13_9 = (Option)receivedStatusCode.elem;
                if (!(v0 != null ? v0.equals(var13_9) == false : var13_9 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                var13_9 = null;
                if (!v1) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)new StringBuilder(117).append("Expected to halt directly with the expected status code:").append(expectedStatusCode.get()).append(", ").append("but got hasHaltProcedureCalled: ").append(hasHaltProcedureCalled.elem).append(" and received status code: ").append(((Option)receivedStatusCode.elem).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).toString());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                    continue;
                }
                break;
            }
        }
        finally {
            Exit.resetHaltProcedure();
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    @Disabled(value="KMETA-38")
    public void testCleanShutdownWithZkUnavailable(String quorum) {
        this.shutdownZooKeeper();
        this.killBroker(0);
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft"})
    public void testCleanShutdownWithKRaftControllerUnavailable(String quorum) {
        this.shutdownKRaftController();
        this.killBroker(0);
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    private <E extends Exception> void verifyCleanShutdownAfterFailedStartup(ClassTag<E> exceptionClassTag) {
        try {
            try {
                this.recreateBroker(true);
                Assertions.fail((String)"Expected KafkaServer setup to fail and throw exception");
            }
            catch (Exception e) {
                this.assertCause(exceptionClassTag.runtimeClass(), e);
                Assertions.assertEquals((Object)(this.isKRaftTest() ? BrokerState.SHUTTING_DOWN : BrokerState.NOT_RUNNING), (Object)((KafkaBroker)this.brokers().head()).brokerState());
            }
        }
        finally {
            this.killBroker(0);
        }
    }

    private void assertCause(Class<?> expectedClass, Throwable e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!expectedClass.isInstance(cause)) continue;
            return;
        }
        Assertions.fail((String)new StringBuilder(43).append("Failed to assert cause of ").append(e).append(", expected cause ").append(expectedClass).toString());
    }

    private boolean isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    public void verifyNonDaemonThreadsStatus() {
        Assertions.assertEquals((int)0, (int)ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray()), (Function1 & Serializable)x$6 -> (Thread)x$6, ClassTag$.MODULE$.apply(Thread.class))), (Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isNonDaemonKafkaThread(t))));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConsecutiveShutdown(String quorum) {
        this.killBroker(0);
        this.broker().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @CsvSource(value={"zk,1", "zk,2", "kraft,1", "kraft,2"})
    public void testBeginShutdown(String quorum, int numHttpRequests) {
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ServerShutdownTest.$anonfun$testBeginShutdown$1(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var10_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_4 = null;
        Object var9_8 = null;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numHttpRequests).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> {
            this.broker().beginShutdown(this.broker().brokerEpoch());
            Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)this.broker().brokerState(), (String)"broker should only be in shutting down state");
        });
        this.broker().shutdown();
        this.broker().awaitShutdown();
        String string = quorum;
        String string2 = "zk";
        Assertions.assertEquals((Object)(string != null && string.equals(string2) ? BrokerState.NOT_RUNNING : BrokerState.SHUTTING_DOWN), (Object)this.broker().brokerState(), (String)"expected broker to be fully shut down");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBeginShutdownWrongEpoch(String quorum) {
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ServerShutdownTest.$anonfun$testBeginShutdownWrongEpoch$1(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var10_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_3 = null;
        Object var9_7 = null;
        long wrongBrokerEpoch = this.broker().brokerEpoch() - 1L;
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> this.broker().beginShutdown(wrongBrokerEpoch), () -> "expected a begin shutdown requests at a different epoch to result in an exception");
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)this.broker().brokerState(), (String)"broker shutdown should not have started");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testControllerShutdownDuringSend(String quorum) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int controllerId = 2;
        Metrics metrics = new Metrics();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ObjectRef serverSocket = ObjectRef.create(null);
        ObjectRef controllerChannelManager = ObjectRef.create(null);
        try {
            serverSocket.elem = new ServerSocket(0);
            Future<?> receiveFuture = executor.submit(new Runnable(null, serverSocket){
                private final ObjectRef serverSocket$1;

                public void run() {
                    Socket socket = ((ServerSocket)this.serverSocket$1.elem).accept();
                    new DataInputStream(socket.getInputStream()).readByte();
                }
                {
                    this.serverSocket$1 = serverSocket$1;
                }
            });
            scala.collection.immutable.Map brokerAndEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Broker(1, "localhost", ((ServerSocket)serverSocket.elem).getLocalPort(), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)0L))}));
            KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
            ControllerContext controllerContext = new ControllerContext();
            controllerContext.setLiveBrokers((Map)brokerAndEpochs);
            controllerChannelManager.elem = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), (Option)None$.MODULE$);
            ((ControllerChannelManager)controllerChannelManager.elem).startup();
            LeaderAndIsrBatch batch = new LeaderAndIsrBatch(1).setControllerId(controllerId).setControllerEpoch(1).setBrokerEpoch(0L).addPartitionState(new TopicPartition("topic", 0), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState()).addLiveLeaders(((IterableOnceOps)brokerAndEpochs.keys().map((Function1 & Serializable)x$8 -> x$8.node(listenerName))).toSet()).addTopicId(this.topic(), Uuid.randomUuid());
            ControllerChannelManager qual$1 = (ControllerChannelManager)controllerChannelManager.elem;
            Function2 x$3 = qual$1.sendControlMetadataBatch$default$3();
            qual$1.sendControlMetadataBatch(1, (ControlMetadataBatch)batch, x$3);
            receiveFuture.get(10L, TimeUnit.SECONDS);
            executor.submit(new Runnable(null, controllerChannelManager){
                private final ObjectRef controllerChannelManager$1;

                public void run() {
                    ((ControllerChannelManager)this.controllerChannelManager$1.elem).shutdown();
                }
                {
                    this.controllerChannelManager$1 = controllerChannelManager$1;
                }
            }).get(10L, TimeUnit.SECONDS);
        }
        finally {
            if ((ServerSocket)serverSocket.elem != null) {
                ((ServerSocket)serverSocket.elem).close();
            }
            if ((ControllerChannelManager)controllerChannelManager.elem != null) {
                ((ControllerChannelManager)controllerChannelManager.elem).shutdown();
            }
            executor.shutdownNow();
            metrics.close();
        }
    }

    private KafkaConfig config() {
        return (KafkaConfig)this.configs().head();
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private void shutdownBroker() {
        this.killBroker(0);
    }

    private void restartBroker() {
        this.killBroker(0);
        this.restartDeadBrokers(!this.propsToChangeUponRestart().isEmpty());
    }

    private void recreateBroker(boolean startup) {
        this.recreateBrokers(!this.propsToChangeUponRestart().isEmpty(), startup);
    }

    private final KafkaProducer createProducer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = -1;
        long x$5 = 60000L;
        long x$6 = 0x100000L;
        int x$7 = Integer.MAX_VALUE;
        int x$8 = 30000;
        int x$9 = 0;
        int x$10 = 16384;
        String x$11 = "none";
        int x$12 = 20000;
        SecurityProtocol x$13 = SecurityProtocol.PLAINTEXT;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = false;
        return TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, x$16);
    }

    private final Consumer createConsumer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerDeserializer x$3 = new IntegerDeserializer();
        StringDeserializer x$4 = new StringDeserializer();
        String x$5 = "group";
        None$ x$6 = None$.MODULE$;
        String x$7 = "earliest";
        boolean x$8 = true;
        boolean x$9 = false;
        int x$10 = 500;
        None$ x$11 = None$.MODULE$;
        None$ x$12 = None$.MODULE$;
        return TestUtils$.MODULE$.createConsumer(x$1, x$5, (Option<String>)x$6, x$7, x$8, x$9, x$10, SecurityProtocol.PLAINTEXT, (Option<File>)x$11, (Option<Properties>)x$12, x$3, x$4, (String)null);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdown$3(String logDir) {
        File OffsetCheckpointFile2 = new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile());
        Assertions.assertTrue((boolean)OffsetCheckpointFile2.exists());
        Assertions.assertTrue((OffsetCheckpointFile2.length() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1(ServerShutdownTest $this, String dirName) {
        File partitionDir = new File(dirName, new StringBuilder(2).append($this.topic()).append("-0").toString());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])partitionDir.listFiles()), (Function1 & Serializable)f -> {
            TestUtils$.MODULE$.appendNonsenseToFile(f, TestUtils$.MODULE$.random().nextInt(1024) + 1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Nothing$ $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1, int statusCode, Option x$5) {
        hasHaltProcedureCalled$1.elem = true;
        receivedStatusCode$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        return (Nothing$)BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$4(ServerShutdownTest $this) {
        $this.recreateBroker(true);
    }

    public static final /* synthetic */ boolean $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$5(VolatileBooleanRef hasHaltProcedureCalled$1, Some expectedStatusCode$1, VolatileObjectRef receivedStatusCode$1) {
        if (hasHaltProcedureCalled$1.elem) {
            Some some = expectedStatusCode$1;
            Option option = (Option)receivedStatusCode$1.elem;
            if (!(some != null ? !some.equals(option) : option != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$6(Some expectedStatusCode$1, VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1) {
        return new StringBuilder(117).append("Expected to halt directly with the expected status code:").append(expectedStatusCode$1.get()).append(", ").append("but got hasHaltProcedureCalled: ").append(hasHaltProcedureCalled$1.elem).append(" and received status code: ").append(((Option)receivedStatusCode$1.elem).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).toString();
    }

    public static final /* synthetic */ void $anonfun$testBeginShutdown$1(ServerShutdownTest $this) {
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)$this.broker().brokerState(), (String)"broker should be started");
    }

    public static final /* synthetic */ void $anonfun$testBeginShutdownWrongEpoch$1(ServerShutdownTest $this) {
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)$this.broker().brokerState(), (String)"broker should be started");
    }

    public ServerShutdownTest() {
        this.host = "localhost";
        this.topic = "test";
    }

    public static final /* synthetic */ Object $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1$adapted(ServerShutdownTest $this, String dirName) {
        ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1($this, dirName);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Nothing$ $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3$adapted(VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1, Object statusCode, Option x$5) {
        return ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(hasHaltProcedureCalled$1, receivedStatusCode$1, BoxesRunTime.unboxToInt((Object)statusCode), x$5);
    }
}

