/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.cluster.Broker;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005%4AAD\b\u0001)!)\u0011\u0004\u0001C\u00015!I\u0001\u0003\u0001a\u0001\u0002\u0004%I\u0001\b\u0005\nA\u0001\u0001\r\u00111A\u0005\n\u0005B\u0011B\u000b\u0001A\u0002\u0003\u0005\u000b\u0015B\u000f\t\u000b-\u0002A\u0011\t\u0017\t\u000bi\u0002A\u0011\u0001\u0017\t\u000b}\u0002A\u0011\u0001\u0017\t\u000b\u0005\u0003A\u0011\u0001\u0017\t\u000b\u001d\u0003A\u0011\u0001\u0017\t\u000b)\u0003A\u0011\u0001\u0017\t\u000b1\u0003A\u0011\u0001\u0017\t\u000b9\u0003A\u0011\u0001\u0017\t\u000bA\u0003A\u0011A)\u0003#M+'O^3s'R\f'\u000f^;q)\u0016\u001cHO\u0003\u0002\u0011#\u000511/\u001a:wKJT\u0011AE\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u0017/5\tq\"\u0003\u0002\u0019\u001f\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\f\u0001+\u0005i\u0002C\u0001\f\u001f\u0013\tyrBA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR\u0011!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000fC\u0004*\u0007\u0005\u0005\t\u0019A\u000f\u0002\u0007a$\u0013'A\u0004tKJ4XM\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:$\u0012A\t\u0015\u0003\u000b9\u0002\"a\f\u001d\u000e\u0003AR!!\r\u001a\u0002\u0007\u0005\u0004\u0018N\u0003\u00024i\u00059!.\u001e9ji\u0016\u0014(BA\u001b7\u0003\u0015QWO\\5u\u0015\u00059\u0014aA8sO&\u0011\u0011\b\r\u0002\n\u0003\u001a$XM]#bG\"\f\u0011\u0004^3ti\n\u0013xn[3s\u0007J,\u0017\r^3t5.\u001b\u0005N]8pi\"\u0012a\u0001\u0010\t\u0003_uJ!A\u0010\u0019\u0003\tQ+7\u000f^\u0001&i\u0016\u001cHoQ8oM2L7\r\u001e\"s_.,'o\u0015;beR,\boV5uQN\u000bW.\u001a)peRD#a\u0002\u001f\u00021Q,7\u000f\u001e*f[>$Xm\u0015;pe\u0006<W-\u00128bE2,G\r\u000b\u0002\ty!\u0012\u0001\u0002\u0012\t\u0003_\u0015K!A\u0012\u0019\u0003\u0011\u0011K7/\u00192mK\u0012\fa\u0006^3tiJ+Wn\u001c;f'R|'/Y4f\u000b:\f'\r\\3e/&$\bn\\;u'\u0016$H/\u001b8h\u0019&\u001cH/\u001a8fe\"\u0012\u0011\u0002\u0010\u0015\u0003\u0013\u0011\u000ba\u0004^3ti\u000e{gN\u001a7jGR\u0014%o\\6feJ+w-[:ue\u0006$\u0018n\u001c8)\u0005)a\u0014a\u0005;fgR\u0014%o\\6feN+GNZ!xCJ,\u0007FA\u0006=\u0003u!Xm\u001d;Ce>\\WM]*uCR,'+\u001e8oS:<\u0017I\u001a;fej[\u0005F\u0001\u0007=\u0003\u001d\"Xm\u001d;ESJ,7\r^8ss&#7o\u0011:fCR,Gm\u00148ms\u001a{'/T5he\u0006$\u0018n\u001c8\u0015\u0005\t\u0012\u0006\"B*\u000e\u0001\u0004!\u0016\u0001E7jOJ\fG/[8o\u000b:\f'\r\\3e!\t\u0019S+\u0003\u0002WI\t9!i\\8mK\u0006t\u0007FA\u0007Y!\tIF,D\u0001[\u0015\tY&'\u0001\u0004qCJ\fWn]\u0005\u0003;j\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u0011iq,\u001a4\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\tT\u0016\u0001\u00039s_ZLG-\u001a:\n\u0005\u0011\f'a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0003O\"L\u0012\u0001A\r\u0002\u0003\u0001")
public class ServerStartupTest
extends QuorumTestHarness {
    private KafkaServer server;

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.server() != null) {
            TestUtils$.MODULE$.shutdownServers(new .colon.colon((Object)this.server(), (List)Nil$.MODULE$), true);
        }
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerCreatesZKChroot() {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        int brokerId = 0;
        String zookeeperChroot = "/kafka-chroot-for-unittest";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        Object zooKeeperConnect = props.get("zookeeper.connect");
        props.put("zookeeper.connect", new StringBuilder(0).append(zooKeeperConnect.toString()).append(zookeeperChroot).toString());
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var8_8 = null;
        Object var5_7 = null;
        kafkaConfig = null;
        time = null;
        this.server_$eq(createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false));
        Assertions.assertTrue((boolean)this.zkClient().pathExists(zookeeperChroot));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConflictBrokerStartupWithSamePort() {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        int brokerId1 = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props1);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var28_6 = null;
        Object var25_5 = null;
        kafkaConfig = null;
        time = null;
        this.server_$eq(createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false));
        int port = TestUtils$.MODULE$.boundPort((KafkaBroker)this.server(), SecurityProtocol.PLAINTEXT);
        int brokerId2 = 1;
        String x$2 = this.zkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var31_19 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var32_22 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var33_25 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(brokerId2, x$2, x$4, x$5, port, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            void createServer_createServer_createServer_startup;
            void createServer_time;
            Time time = Time.SYSTEM;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(props2);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            boolean bl = true;
            int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
            createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @Disabled
    public void testRemoteStorageEnabled() {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        int brokerId1 = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props1.put("remote.log.storage.system.enable", "true");
        props1.put("remote.log.storage.manager.class.name", NoOpRemoteStorageManager.class.getName());
        props1.put("remote.log.metadata.manager.class.name", NoOpRemoteLogMetadataManager.class.getName());
        props1.put("remote.log.metadata.manager.listener.name", "badListenerName");
        Assertions.assertThrows(ConfigException.class, () -> {
            void createServer_createServer_createServer_startup;
            void createServer_time;
            Time time = Time.SYSTEM;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(props1);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            boolean bl = true;
            int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
            createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        });
        props1.put("remote.log.metadata.manager.listener.name", "PLAINTEXT");
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props1);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var6_6 = null;
        Object var3_5 = null;
        kafkaConfig = null;
        time = null;
        this.server_$eq(createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @Disabled
    public void testRemoteStorageEnabledWithoutSettingListener() {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        int brokerId1 = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props1.put("remote.log.storage.system.enable", "true");
        props1.put("remote.log.storage.manager.class.name", NoOpRemoteStorageManager.class.getName());
        props1.put("remote.log.metadata.manager.class.name", NoOpRemoteLogMetadataManager.class.getName());
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props1);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var6_6 = null;
        Object var3_5 = null;
        kafkaConfig = null;
        time = null;
        this.server_$eq(createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConflictBrokerRegistration() {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        int brokerId = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props1);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var8_6 = null;
        Object var5_5 = null;
        kafkaConfig = null;
        time = null;
        this.server_$eq(createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false));
        Broker brokerRegistration = (Broker)this.zkClient().getBroker(brokerId).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"broker doesn't exists"));
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        Assertions.assertThrows(KeeperException.NodeExistsException.class, () -> {
            void createServer_createServer_createServer_startup;
            void createServer_time;
            Time time = Time.SYSTEM;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(props2);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            boolean bl = true;
            int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
            createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        });
        Assertions.assertEquals((Object)brokerRegistration, (Object)this.zkClient().getBroker(brokerId).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"broker doesn't exists")));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerSelfAware() {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        int brokerId = 0;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var12_6 = null;
        Object var9_5 = null;
        kafkaConfig = null;
        time = null;
        this.server_$eq(createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ServerStartupTest.$anonfun$testBrokerSelfAware$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Wait for cache to update");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)this.server().metadataCache().getAliveBrokers().size());
        Assertions.assertEquals((int)brokerId, (int)((BrokerMetadata)this.server().metadataCache().getAliveBrokers().head()).id);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerStateRunningAfterZK() {
        int brokerId = 0;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        this.server_$eq(new KafkaServer(KafkaConfig$.MODULE$.fromProps(props), Time.SYSTEM, (Option)None$.MODULE$, false));
        this.server().startup();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ServerStartupTest.$anonfun$testBrokerStateRunningAfterZK$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"waiting for the broker state to become RUNNING");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Seq brokers = this.zkClient().getAllBrokersInCluster();
        Assertions.assertEquals((int)1, (int)brokers.size());
        Assertions.assertEquals((int)brokerId, (int)((Broker)brokers.head()).id());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testDirectoryIdsCreatedOnlyForMigration(boolean migrationEnabled) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.setProperty(KafkaConfig$.MODULE$.MigrationEnabledProp(), Boolean.toString(migrationEnabled));
        if (migrationEnabled) {
            props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "3000@localhost:9093");
            props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            props.setProperty("confluent.cluster.link.metadata.topic.enable", "true");
        }
        this.server_$eq(new KafkaServer(KafkaConfig$.MODULE$.fromProps(props), Time.SYSTEM, (Option)None$.MODULE$, false));
        this.server().startup();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!migrationEnabled ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)this.server().logManager().directoryIdsSet().isEmpty()));
        this.server().shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerSelfAware$1(ServerStartupTest $this) {
        return $this.server().metadataCache().getAliveBrokers().nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testBrokerSelfAware$2() {
        return "Wait for cache to update";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerStateRunningAfterZK$1(ServerStartupTest $this) {
        BrokerState brokerState = $this.server().brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testBrokerStateRunningAfterZK$2() {
        return "waiting for the broker state to become RUNNING";
    }
}

