/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.StorageProbe;
import kafka.server.StorageProbeLatencyAggregator;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005=2AAB\u0004\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011!)1\u0006\u0001C\u00011!)Q\u0006\u0001C\u00011\t\u00012\u000b^8sC\u001e,\u0007K]8cKR+7\u000f\u001e\u0006\u0003\u0011%\taa]3sm\u0016\u0014(\"\u0001\u0006\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0004\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u00059\u0011\u0001\b;fgR\u001cFo\u001c:bO\u0016\u0004&o\u001c2f'&tw\r\\3M_\u001e$\u0017N\u001d\u000b\u00023A\u0011aBG\u0005\u00037=\u0011A!\u00168ji\"\u0012!!\b\t\u0003=\u001dj\u0011a\b\u0006\u0003A\u0005\n1!\u00199j\u0015\t\u00113%A\u0004kkBLG/\u001a:\u000b\u0005\u0011*\u0013!\u00026v]&$(\"\u0001\u0014\u0002\u0007=\u0014x-\u0003\u0002)?\t!A+Z:u\u0003}!Xm\u001d;Ti>\u0014\u0018mZ3Qe>\u0014W-T;mi&\u0004H.\u001a'pO\u0012L'o\u001d\u0015\u0003\u0007u\tq\u0003^3ti\u0012K7/\u00192mKN#xN]1hKB\u0013xNY3)\u0005\u0011i\u0012!\t;fgR\u001cFo\u001c:bO\u0016\u0004&o\u001c2f\u0019\u0006$XM\\2z\u0003\u001e<'/Z4bi>\u0014\bFA\u0003\u001e\u0001")
public class StorageProbeTest {
    @Test
    public void testStorageProbeSingleLogdir() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.StorageProbePeriodMsProp(), "1000");
        KafkaConfig config = new KafkaConfig((Map)props);
        MockTime time = new MockTime(500000000L, 1600592000000L, 1600592000000L);
        StorageProbe storageProbe = new StorageProbe(config, (Time)time, false);
        storageProbe.startup();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(config.logDirs().apply(0)), (Object)BoxesRunTime.boxToInteger((int)500000000))})), (Object)storageProbe.probe(), (String)"mock time should have calculated storage latency as 1ms for each logdir");
        config.logDirs().foreach((Function1 & Serializable)dir -> {
            StorageProbeTest.$anonfun$testStorageProbeSingleLogdir$1(dir);
            return BoxedUnit.UNIT;
        });
        storageProbe.shutdown();
    }

    @Test
    public void testStorageProbeMultipleLogdirs() {
        boolean x$4 = true;
        boolean x$5 = true;
        TestUtils$ createBrokerConfig$default$5_this = TestUtils$.MODULE$;
        Object var23_3 = null;
        int x$6 = createBrokerConfig$default$5_this.RandomPort();
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        boolean x$10 = true;
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var24_10 = null;
        int x$12 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var25_13 = null;
        int x$14 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$15 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var26_16 = null;
        int x$16 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$17 = None$.MODULE$;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", x$4, x$5, x$6, (Option<SecurityProtocol>)x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, (Option<String>)x$17, 2, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.StorageProbePeriodMsProp(), "1000");
        KafkaConfig config = new KafkaConfig((Map)props);
        MockTime time = new MockTime(100000000L, 1600592000000L, 1600592000000L);
        StorageProbe storageProbe = new StorageProbe(config, (Time)time, false);
        storageProbe.startup();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(config.logDirs().apply(0)), (Object)BoxesRunTime.boxToInteger((int)100000000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(config.logDirs().apply(1)), (Object)BoxesRunTime.boxToInteger((int)100000000))})), (Object)storageProbe.probe(), (String)"mock time should have calculated storage latency for each logdir");
        Assertions.assertEquals((Object)"0,1600692000000", (Object)Utils.readFileAsString((String)Paths.get((String)config.logDirs().apply(0), "storage.probe").toFile().getAbsolutePath()), (String)"time of the first write should have been recorded");
        Assertions.assertEquals((Object)"0,1601092000000", (Object)Utils.readFileAsString((String)Paths.get((String)config.logDirs().apply(1), "storage.probe").toFile().getAbsolutePath()), (String)"time of the last write should have been recorded later than the first");
        storageProbe.shutdown();
    }

    @Test
    public void testDisableStorageProbe() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.StorageProbePeriodMsProp(), "-1");
        KafkaConfig config = new KafkaConfig((Map)props);
        MockTime time = new MockTime(1L);
        StorageProbe storageProbe = new StorageProbe(config, (Time)time, false);
        storageProbe.startup();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)storageProbe.probe(), (String)"Storage probe should not return any results");
        Assertions.assertFalse((boolean)Paths.get((String)config.logDirs().head(), "storage.probe").toFile().exists());
        storageProbe.shutdown();
    }

    @Test
    public void testStorageProbeLatencyAggregator() {
        StorageProbeLatencyAggregator queue = new StorageProbeLatencyAggregator(5);
        Assertions.assertEquals((double)0.0, (double)queue.avg());
        Assertions.assertEquals((long)0L, (long)queue.max());
        IntRef sum = IntRef.create((int)0);
        package$.MODULE$.Range().inclusive(1, 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x -> {
            queue.enqueue((long)x);
            sum$1.elem += x;
            Assertions.assertEquals((long)x, (long)queue.max());
            Assertions.assertEquals((double)((double)sum$1.elem / (double)x), (double)queue.avg());
        });
        Assertions.assertEquals((double)3.0, (double)queue.avg());
        queue.enqueue(6L);
        Assertions.assertEquals((long)6L, (long)queue.max());
        Assertions.assertEquals((double)4.0, (double)queue.avg());
        queue.enqueue(8L);
        Assertions.assertEquals((long)8L, (long)queue.max());
        Assertions.assertEquals((double)5.2, (double)queue.avg());
    }

    public static final /* synthetic */ void $anonfun$testStorageProbeSingleLogdir$1(String dir) {
        Assertions.assertEquals((Object)"0,1601092000000", (Object)Utils.readFileAsString((String)Paths.get(dir, "storage.probe").toFile().getAbsolutePath()), (String)"time of the last write should have been recorded");
    }
}

