/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@Tag(value="bazel:shard_count:4")
@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001\u0002\u0011\"\u0001\u0019BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004:\u0001\u0001\u0006Ia\r\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019!\u0005\u0001)A\u0005y!9Q\t\u0001b\u0001\n\u00131\u0005B\u0002*\u0001A\u0003%q\tC\u0004T\u0001\t\u0007I\u0011B\u001e\t\rQ\u0003\u0001\u0015!\u0003=\u0011\u001d)\u0006A1A\u0005\nmBaA\u0016\u0001!\u0002\u0013a\u0004bB,\u0001\u0005\u0004%Ia\u000f\u0005\u00071\u0002\u0001\u000b\u0011\u0002\u001f\t\u000fe\u0003!\u0019!C\u00055\"1Q\r\u0001Q\u0001\nmCqA\u001a\u0001C\u0002\u0013%!\u0007\u0003\u0004h\u0001\u0001\u0006Ia\r\u0005\bQ\u0002\u0011\r\u0011\"\u00033\u0011\u0019I\u0007\u0001)A\u0005g!)!\u000e\u0001C)e!)1\u000e\u0001C!Y\"1q\u0010\u0001C\u0001\u0003\u0003Aq!a\u0003\u0001\t\u0003\t\t\u0001C\u0004\u0002\u0010\u0001!\t!!\u0001\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0002!9\u0011q\u0003\u0001\u0005\u0002\u0005\u0005\u0001bBA\u000e\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\tY\u0003\u0001C\u0005\u0003[Aq!!\u0010\u0001\t\u0013\ty\u0004C\u0004\u0002P\u0001!I!!\u0015\u0003;M#(/Y=QCJ$\u0018\u000e^5p]&sG/Z4sCRLwN\u001c+fgRT!AI\u0012\u0002\rM,'O^3s\u0015\u0005!\u0013!B6bM.\f7\u0001A\n\u0003\u0001\u001d\u0002\"\u0001K\u0016\u000e\u0003%R!AK\u0012\u0002\u0007\u0005\u0004\u0018.\u0003\u0002-S\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002_A\u0011\u0001\u0007A\u0007\u0002C\u0005Qa.^7Ce>\\WM]:\u0016\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u00121!\u00138u\u0003-qW/\u001c\"s_.,'o\u001d\u0011\u0002\u000bQ|\u0007/[2\u0016\u0003q\u0002\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\t1\fgn\u001a\u0006\u0002\u0003\u0006!!.\u0019<b\u0013\t\u0019eH\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\tq\t\u0005\u0002I!6\t\u0011J\u0003\u0002K\u0017\u000611m\\7n_:T!\u0001\n'\u000b\u00055s\u0015AB1qC\u000eDWMC\u0001P\u0003\ry'oZ\u0005\u0003#&\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u000311\u0018\r\\5e)>\u0004\u0018nY02\u000351\u0018\r\\5e)>\u0004\u0018nY02A\u0005aa/\u00197jIR{\u0007/[2`e\u0005ia/\u00197jIR{\u0007/[2`e\u0001\nAb\u001d;sCf$v\u000e]5d?F\nQb\u001d;sCf$v\u000e]5d?F\u0002\u0013\u0001D:ue\u0006LHk\u001c9jG~\u0013T#A.\u0011\u0005q\u001bgBA/b!\tqV'D\u0001`\u0015\t\u0001W%\u0001\u0004=e>|GOP\u0005\u0003EV\na\u0001\u0015:fI\u00164\u0017BA\"e\u0015\t\u0011W'A\u0007tiJ\f\u0017\u0010V8qS\u000e|&\u0007I\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\u0018A\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018A\u00048v[B\u000b'\u000f^5uS>t7\u000fI\u0001\fEJ|7.\u001a:D_VtG/A\u0003tKR,\u0006\u000f\u0006\u0002naB\u0011AG\\\u0005\u0003_V\u0012A!\u00168ji\")\u0011/\u0006a\u0001e\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002ts6\tAO\u0003\u0002+k*\u0011ao^\u0001\bUV\u0004\u0018\u000e^3s\u0015\tAh*A\u0003kk:LG/\u0003\u0002{i\nAA+Z:u\u0013:4w\u000e\u000b\u0002\u0016yB\u00111/`\u0005\u0003}R\u0014!BQ3g_J,W)Y2i\u0003y!Xm\u001d;PM\u001a\u001cX\r^%oI\u0016DxJ\\*ue\u0006LHj\\4DY>\u001cX\rF\u0001nQ\r1\u0012Q\u0001\t\u0004g\u0006\u001d\u0011bAA\u0005i\n!A+Z:u\u0003%\"Xm\u001d;TiJ\f\u0017\u0010U1si&$\u0018n\u001c8EK2,G/[8o\u001f:\u0014%o\\6feJ+7\u000f^1si\"\u001aq#!\u0002\u0002SQ,7\u000f^*ue\u0006L\b+\u0019:uSRLwN\u001c#fY\u0016$\u0018n\u001c8P]\n\u0013xn[3s'R\f'\u000f^;qQ\rA\u0012QA\u0001/i\u0016\u001cHo\u0015;sCf\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\\(o\u0007>tGO]8mY\u0016\u0014h)Y5m_Z,'\u000fK\u0002\u001a\u0003\u000b\tq\u0005^3tiB\u000b'\u000f^5uS>tgj\u001c;TiJ\f\u0017\u0010R;sS:<'+Z1tg&<g.\\3oi\"\u001a!$!\u0002\u0002}Q,7\u000f^*ue\u0006L\b+\u0019:uSRLwN\u001c#fi\u0016\u001cG/[8o\u001f:\u0014%o\\6feN#\u0018M\u001d;va^KG\u000f\u001b#fY\u0016$\u0018n\u001c8ESN\f'\r\\3eQ\rY\u0012QA\u0001\u0017m\u0016\u0014\u0018NZ=TiJ\f\u0017\u0010T8h\t\u0016dW\r^5p]R\u0019Q.a\t\t\r\tb\u0002\u0019AA\u0013!\r\u0001\u0014qE\u0005\u0004\u0003S\t#aC&bM.\f7+\u001a:wKJ\fQb\u0019:fCR,7+Z4nK:$HcA7\u00020!9\u0011\u0011G\u000fA\u0002\u0005M\u0012a\u00017pOB!\u0011QGA\u001d\u001b\t\t9DC\u0002\u00022\rJA!a\u000f\u00028\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u0003m1XM]5gsN#(/Y=QCJ$\u0018\u000e^5p]6+GO]5dgR)Q.!\u0011\u0002F!1\u00111\t\u0010A\u0002M\n1c\u001d;sCf\u0004\u0016M\u001d;ji&|gnQ8v]RDq!a\u0012\u001f\u0001\u0004\tI%A\ftiJ\f\u0017\u0010U1si&$\u0018n\u001c8U_R\fGnU5{KB\u0019A'a\u0013\n\u0007\u00055SG\u0001\u0003M_:<\u0017A\u00027pO>\u0003H\u000f\u0006\u0004\u0002T\u0005e\u0013Q\f\t\u0006i\u0005U\u00131G\u0005\u0004\u0003/*$AB(qi&|g\u000e\u0003\u0004\u0002\\}\u0001\raM\u0001\u0007EJ|7.\u001a:\t\u000b\u0015{\u0002\u0019A$)\u000f\u0001\t\t'a\u001a\u0002jA\u00191/a\u0019\n\u0007\u0005\u0015DOA\u0002UC\u001e\fQA^1mk\u0016\f#!a\u001b\u0002'\t\f'0\u001a7;g\"\f'\u000fZ0d_VtGO\u000f\u001b")
public class StrayPartitionIntegrationTest
extends IntegrationTestHarness {
    private final int numBrokers;
    private final String topic;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
    private final String validTopic_1;
    private final String validTopic_2;
    private final String strayTopic_1;
    private final String strayTopic_2 = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("a"), 253);
    private final int replicationFactor;
    private final int numPartitions;

    private int numBrokers() {
        return this.numBrokers;
    }

    private String topic() {
        return this.topic;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private String validTopic_1() {
        return this.validTopic_1;
    }

    private String validTopic_2() {
        return this.validTopic_2;
    }

    private String strayTopic_1() {
        return this.strayTopic_1;
    }

    private String strayTopic_2() {
        return this.strayTopic_2;
    }

    private int replicationFactor() {
        return this.replicationFactor;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    @Override
    public int brokerCount() {
        return this.numBrokers();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        v0 = ((Method)testInfo.getTestMethod().get()).getName();
        var2_2 = "testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled";
        if (v0 != null && v0.equals(var2_2)) {
            this.serverConfig().setProperty("confluent.enable.stray.partition.deletion", "false");
        } else {
            this.serverConfig().setProperty("confluent.enable.stray.partition.deletion", "true");
        }
        v1 = ((Method)testInfo.getTestMethod().get()).getName();
        var3_3 = "testStrayPartitionDeletionOnBrokerRestart";
        if (v1 != null && v1.equals(var3_3)) ** GOTO lbl-1000
        v2 = ((Method)testInfo.getTestMethod().get()).getName();
        var4_4 = "testStrayLogClose";
        if (v2 != null && v2.equals(var4_4)) lbl-1000:
        // 2 sources

        {
            this.serverConfig().setProperty("confluent.stray.log.delete.delay.ms", "1200000");
        } else {
            this.serverConfig().setProperty("confluent.stray.log.delete.delay.ms", "5000");
        }
        super.setUp(testInfo);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetIndexOnStrayLogClose() {
        KafkaServer server = (KafkaServer)this.servers().head();
        LogManager logManager = server.logManager();
        TopicPartition partition = new TopicPartition(this.strayTopic_1(), Random$.MODULE$.nextInt(10));
        None$ x$22 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        Option x$5 = logManager.getOrCreateLog$default$5();
        logManager.getOrCreateLog(partition, x$3, x$4, (Option)x$22, x$5);
        AbstractLog strayLog = (AbstractLog)logManager.getLog(partition, logManager.getLog$default$2()).get();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)x$1 -> strayLog.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, strayLog.appendAsLeader$default$3(), strayLog.appendAsLeader$default$4(), strayLog.appendAsLeader$default$5(), strayLog.appendAsLeader$default$6()));
        strayLog.roll(strayLog.roll$default$1(), strayLog.roll$default$2());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)x$2 -> strayLog.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, strayLog.appendAsLeader$default$3(), strayLog.appendAsLeader$default$4(), strayLog.appendAsLeader$default$5(), strayLog.appendAsLeader$default$6()));
        long lastIndexOffset = strayLog.activeSegment().offsetIndex().lastOffset();
        Assertions.assertTrue((lastIndexOffset > 10L ? 1 : 0) != 0, (String)"Offset index should have new entries after append.");
        this.killBrokerById(server.config().brokerId());
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testOffsetIndexOnStrayLogClose$3(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting stray logs queue up for deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.killBrokerById(server.config().brokerId());
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        Assertions.assertEquals((long)lastIndexOffset, (long)((AbstractLog)server.logManager().getStrayLog(partition).get()).activeSegment().offsetIndex().lastOffset(), (String)"Offset index should be the same after stray log close and re-open.");
    }

    @Test
    public void testStrayPartitionDeletionOnBrokerRestart() {
        this.createTopic(this.validTopic_1(), this.numPartitions(), this.replicationFactor(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.validTopic_2(), this.numPartitions(), this.replicationFactor(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.servers().foreach((Function1 & Serializable)server -> {
            LogManager logManager = server.logManager();
            TopicPartition x$1 = new TopicPartition(this.strayTopic_1(), Random$.MODULE$.nextInt(10));
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            Option x$5 = logManager.getOrCreateLog$default$5();
            logManager.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
            TopicPartition x$6 = new TopicPartition(this.strayTopic_2(), Random$.MODULE$.nextInt(10));
            None$ x$7 = None$.MODULE$;
            boolean x$8 = logManager.getOrCreateLog$default$2();
            boolean x$9 = logManager.getOrCreateLog$default$3();
            Option x$10 = logManager.getOrCreateLog$default$5();
            return logManager.getOrCreateLog(x$6, x$8, x$9, (Option)x$7, x$10);
        });
        this.servers().foreach((Function1 & Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerRestart$2(this, server);
            return BoxedUnit.UNIT;
        });
        Properties newConfig = new Properties();
        newConfig.setProperty("confluent.stray.log.delete.delay.ms", "5000");
        Thread.sleep(3000L);
        this.servers().foreach((Function1 & Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerRestart$5(this, newConfig, server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStrayPartitionDeletionOnBrokerStartup() {
        this.createTopic(this.validTopic_1(), this.numPartitions(), this.replicationFactor(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.validTopic_2(), this.numPartitions(), this.replicationFactor(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.servers().foreach((Function1 & Serializable)server -> {
            LogManager logManager = server.logManager();
            TopicPartition x$1 = new TopicPartition(this.strayTopic_1(), Random$.MODULE$.nextInt(10));
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            Option x$5 = logManager.getOrCreateLog$default$5();
            logManager.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
            TopicPartition x$6 = new TopicPartition(this.strayTopic_2(), Random$.MODULE$.nextInt(10));
            None$ x$7 = None$.MODULE$;
            boolean x$8 = logManager.getOrCreateLog$default$2();
            boolean x$9 = logManager.getOrCreateLog$default$3();
            Option x$10 = logManager.getOrCreateLog$default$5();
            return logManager.getOrCreateLog(x$6, x$8, x$9, (Option)x$7, x$10);
        });
        ObjectRef controllerServer = ObjectRef.create((Object)((KafkaServer)this.servers().last()));
        this.servers().foreach((Function1 & Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerStartup$2(this, controllerServer, server);
            return BoxedUnit.UNIT;
        });
        this.killBrokerById(((KafkaServer)controllerServer.elem).config().brokerId());
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((KafkaServer)controllerServer.elem).logManager().hasStrayLogsToBeDeleted()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting stray logs queue up for deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyStrayLogDeletion((KafkaServer)controllerServer.elem);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStrayPartitionDeletionOnControllerFailover() {
        this.createTopic(this.validTopic_1(), this.numPartitions(), this.replicationFactor(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.validTopic_2(), this.numPartitions(), this.replicationFactor(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.servers().foreach((Function1 & Serializable)server -> {
            LogManager logManager = server.logManager();
            TopicPartition x$1 = new TopicPartition(this.strayTopic_1(), Random$.MODULE$.nextInt(10));
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            Option x$5 = logManager.getOrCreateLog$default$5();
            logManager.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
            TopicPartition x$6 = new TopicPartition(this.strayTopic_2(), Random$.MODULE$.nextInt(10));
            None$ x$7 = None$.MODULE$;
            boolean x$8 = logManager.getOrCreateLog$default$2();
            boolean x$9 = logManager.getOrCreateLog$default$3();
            Option x$10 = logManager.getOrCreateLog$default$5();
            return logManager.getOrCreateLog(x$6, x$8, x$9, (Option)x$7, x$10);
        });
        this.zkClient().deleteController(((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for controller election");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$4(this, controllerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for controller initialization");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.servers().foreach((Function1 & Serializable)server -> {
            this.verifyStrayLogDeletion(server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionNotStrayDuringReassignment() {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("segment.bytes", Integer.toString(100));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), (Seq<KafkaBroker>)this.servers(), topicConfig);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"message".getBytes());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)x$3 -> StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$1(producer, record, BoxesRunTime.unboxToInt((Object)x$3)));
        ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        int newLeader = 2;
        scala.collection.immutable.Seq newReplicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1}));
        NewPartitionReassignment newAssignment = new NewPartitionReassignment(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newReplicas.map((Function1 & Serializable)x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x)))).asJava());
        adminClient.alterPartitionReassignments(Collections.singletonMap(this.topicPartition(), Optional.of(newAssignment))).all().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$3(this, newLeader)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for reassignment to initiate");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$5(this, newLeader)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for segments to roll");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        ((LogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(((AbstractLog)this.logOpt(newLeader, this.topicPartition()).get()).localLogSegments()).asScala().head()).setLastModified(System.currentTimeMillis() + 100000L);
        Iterable lastModified = (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AbstractLog)this.logOpt(newLeader, this.topicPartition()).get()).localLogSegments()).asScala().dropRight(1)).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.lastModified()));
        this.killBroker(newLeader);
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)x$5 -> StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$8(producer, record, BoxesRunTime.unboxToInt((Object)x$5)));
        this.servers().foreach((Function1 & Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$9(this, server);
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$10(this, adminClient)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timed out waiting for reassignment to complete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$12(this, newLeader)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$14(this, newLeader));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)lastModified, (Object)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AbstractLog)this.logOpt(newLeader, this.topicPartition()).get()).localLogSegments()).asScala().take(lastModified.size())).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.lastModified())));
    }

    @Test
    public void testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled() {
        this.createTopic(this.validTopic_1(), 3, 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.validTopic_2(), 5, 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.servers().foreach((Function1 & Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$1(this, server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$2(this, server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyStrayLogDeletion(KafkaServer server) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$verifyStrayLogDeletion$2(this, server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for stray topic deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)this.numPartitions(), (int)((IterableOnceOps)StrayPartitionIntegrationTest.allLogs$2(server).filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$verifyStrayLogDeletion$5(this, x$13)))).size());
        Assertions.assertEquals((int)this.numPartitions(), (int)((IterableOnceOps)StrayPartitionIntegrationTest.allLogs$2(server).filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$verifyStrayLogDeletion$6(this, x$14)))).size());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 60000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$verifyStrayLogDeletion$7(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for stray log deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 60000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$verifyStrayLogDeletion$9(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timed out waiting for stray partitions count metric to clear");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)server.replicaManager().strayPartitionsTotalSize());
        this.verifyStrayPartitionMetrics(0, 0L);
    }

    /*
     * WARNING - void declaration
     */
    private void createSegment(AbstractLog log) {
        void builder_baseOffset;
        void builder_timestampType;
        long l = 0L;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType builder_compressionType = CompressionType.NONE;
        Object var3_4 = null;
        timestampType = null;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)2, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)builder_baseOffset);
        builder.append(System.currentTimeMillis(), (byte[])Array$.MODULE$.fill(3, (Function0)(JFunction0.mcB.sp & Serializable)() -> 32, (ClassTag)ClassTag$.MODULE$.Byte()), (byte[])Array$.MODULE$.fill(10, (Function0)(JFunction0.mcB.sp & Serializable)() -> 31, (ClassTag)ClassTag$.MODULE$.Byte()));
        log.appendAsLeader(builder.build(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    private void verifyStrayPartitionMetrics(int strayPartitionCount, long strayPartitionTotalSize) {
        Assertions.assertEquals((int)strayPartitionCount, (int)BoxesRunTime.unboxToInt((Object)((Gauge)StrayPartitionIntegrationTest.replicaMetric$1("StrayPartitionsCount")).value()));
        Assertions.assertEquals((long)strayPartitionTotalSize, (long)BoxesRunTime.unboxToLong((Object)((Gauge)StrayPartitionIntegrationTest.replicaMetric$1("StrayPartitionsTotalSize")).value()));
    }

    private Option<AbstractLog> logOpt(int broker, TopicPartition topicPartition) {
        LogManager qual$1 = ((KafkaServer)this.servers().apply(broker)).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$testOffsetIndexOnStrayLogClose$3(KafkaServer server$1) {
        return server$1.logManager().hasStrayLogsToBeDeleted();
    }

    public static final /* synthetic */ String $anonfun$testOffsetIndexOnStrayLogClose$4() {
        return "Timeout waiting stray logs queue up for deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerRestart$3(KafkaServer server$2) {
        return server$2.logManager().hasStrayLogsToBeDeleted();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnBrokerRestart$4() {
        return "Timeout waiting stray logs queue up for deletion";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testStrayPartitionDeletionOnBrokerRestart$2(StrayPartitionIntegrationTest $this, KafkaServer server) {
        $this.killBrokerById(server.config().brokerId());
        $this.restartDeadBrokers($this.restartDeadBrokers$default$1());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerRestart$3(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting stray logs queue up for deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerRestart$6(KafkaServer server$3) {
        return server$3.logManager().hasStrayLogsToBeDeleted();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnBrokerRestart$7() {
        return "Timeout waiting stray logs queue up for deletion";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testStrayPartitionDeletionOnBrokerRestart$5(StrayPartitionIntegrationTest $this, Properties newConfig$1, KafkaServer server) {
        Assertions.assertTrue((boolean)server.logManager().hasStrayLogsToBeDeleted(), (String)"Stray logs were deleted early.");
        $this.killBrokerById(server.config().brokerId());
        $this.restartDeadBrokers($this.restartDeadBrokers$default$1());
        AdminZkClient qual$1 = server.dynamicConfigManager().adminZkClient();
        String x$12 = Integer.toString(server.config().brokerId());
        boolean x$14 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs("brokers", x$12, newConfig$1, x$14);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 2500L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerRestart$6(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting stray logs queue up for deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        $this.verifyStrayLogDeletion(server);
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerStartup$3(KafkaServer server$4) {
        return server$4.logManager().hasStrayLogsToBeDeleted();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnBrokerStartup$4() {
        return "Timeout waiting stray logs queue up for deletion";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testStrayPartitionDeletionOnBrokerStartup$2(StrayPartitionIntegrationTest $this, ObjectRef controllerServer$1, KafkaServer server) {
        if (!server.kafkaController().isActive()) {
            $this.killBrokerById(server.config().brokerId());
            $this.restartDeadBrokers($this.restartDeadBrokers$default$1());
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerStartup$3(server)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timeout waiting stray logs queue up for deletion");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            $this.verifyStrayLogDeletion(server);
            return;
        }
        controllerServer$1.elem = server;
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerStartup$5(ObjectRef controllerServer$1) {
        return ((KafkaServer)controllerServer$1.elem).logManager().hasStrayLogsToBeDeleted();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnBrokerStartup$6() {
        return "Timeout waiting stray logs queue up for deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnControllerFailover$2(StrayPartitionIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnControllerFailover$3() {
        return "Timed out waiting for controller election";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnControllerFailover$4(StrayPartitionIntegrationTest $this, int controllerId$1) {
        return ((KafkaServer)$this.servers().apply(controllerId$1)).kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnControllerFailover$5() {
        return "Timed out waiting for controller initialization";
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testPartitionNotStrayDuringReassignment$1(KafkaProducer producer$1, ProducerRecord record$1, int x$3) {
        return (RecordMetadata)producer$1.send(record$1).get();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionNotStrayDuringReassignment$3(StrayPartitionIntegrationTest $this, int newLeader$1) {
        return $this.logOpt(newLeader$1, $this.topicPartition()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testPartitionNotStrayDuringReassignment$4() {
        return "Timed out waiting for reassignment to initiate";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionNotStrayDuringReassignment$5(StrayPartitionIntegrationTest $this, int newLeader$1) {
        return ((AbstractLog)$this.logOpt(newLeader$1, $this.topicPartition()).get()).numberOfSegments() > 1;
    }

    public static final /* synthetic */ String $anonfun$testPartitionNotStrayDuringReassignment$6() {
        return "Timed out waiting for segments to roll";
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testPartitionNotStrayDuringReassignment$8(KafkaProducer producer$1, ProducerRecord record$1, int x$5) {
        return (RecordMetadata)producer$1.send(record$1).get();
    }

    public static final /* synthetic */ void $anonfun$testPartitionNotStrayDuringReassignment$9(StrayPartitionIntegrationTest $this, KafkaServer server) {
        Assertions.assertEquals((int)0, (int)server.replicaManager().strayPartitionsCount());
        Assertions.assertEquals((long)0L, (long)server.replicaManager().strayPartitionsTotalSize());
        $this.verifyStrayPartitionMetrics(0, 0L);
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionNotStrayDuringReassignment$10(StrayPartitionIntegrationTest $this, ConfluentAdmin adminClient$1) {
        return ((java.util.Map)adminClient$1.listPartitionReassignments(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{$this.topicPartition()}))).asJava()).reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testPartitionNotStrayDuringReassignment$11() {
        return "Timed out waiting for reassignment to complete";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionNotStrayDuringReassignment$12(StrayPartitionIntegrationTest $this, int newLeader$1) {
        return ((KafkaServer)$this.servers().apply(newLeader$1)).replicaManager().leaderPartitionsIterator().map((Function1 & Serializable)x$6 -> x$6.topicPartition()).contains((Object)$this.topicPartition());
    }

    public static final /* synthetic */ String $anonfun$testPartitionNotStrayDuringReassignment$14(StrayPartitionIntegrationTest $this, int newLeader$1) {
        return new StringBuilder(75).append("Timed out waiting for ").append(newLeader$1).append(" to become the new leader of ").append($this.topicPartition()).append(" after it was reassigned").toString();
    }

    public static final /* synthetic */ void $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$1(StrayPartitionIntegrationTest $this, KafkaServer server) {
        LogManager logManager = server.logManager();
        TopicPartition x$1 = new TopicPartition($this.strayTopic_1(), server.config().brokerId() * 2);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        Option x$5 = logManager.getOrCreateLog$default$5();
        AbstractLog strayLog1 = logManager.getOrCreateLog(x$1, x$3, x$4, (Option)x$2, x$5);
        TopicPartition x$6 = new TopicPartition($this.strayTopic_2(), server.config().brokerId() * 2 + 1);
        None$ x$7 = None$.MODULE$;
        boolean x$8 = logManager.getOrCreateLog$default$2();
        boolean x$9 = logManager.getOrCreateLog$default$3();
        Option x$10 = logManager.getOrCreateLog$default$5();
        AbstractLog strayLog2 = logManager.getOrCreateLog(x$6, x$8, x$9, (Option)x$7, x$10);
        $this.createSegment(strayLog1);
        $this.createSegment(strayLog2);
    }

    private static final Iterable allLogs$1(KafkaServer server$5) {
        return (Iterable)server$5.logManager().allLogs().map((Function1 & Serializable)x$8 -> x$8.topicPartition());
    }

    private static final long logSize$1(TopicPartition topicPartition, KafkaServer server$5) {
        LogManager qual$1 = server$5.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return BoxesRunTime.unboxToLong((Object)qual$1.getLog(topicPartition, x$2).map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.size())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$6(KafkaServer server$5) {
        return server$5.replicaManager().strayPartitionsCount() == 2;
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$7() {
        return "Timed out waiting for stray partition detection";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$8(KafkaServer server$5, long totalLogSize$1) {
        return server$5.replicaManager().strayPartitionsTotalSize() == totalLogSize$1;
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$9() {
        return "Timed out waiting for stray partition total size detection";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$10(StrayPartitionIntegrationTest $this, TopicPartition x$10) {
        String string = x$10.topic();
        String string2 = $this.validTopic_1();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$11(StrayPartitionIntegrationTest $this, TopicPartition x$11) {
        String string = x$11.topic();
        String string2 = $this.validTopic_2();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$2(StrayPartitionIntegrationTest $this, KafkaServer server) {
        $this.killBrokerById(server.config().brokerId());
        $this.restartDeadBrokers($this.restartDeadBrokers$default$1());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$6(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for stray partition detection");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long totalLogSize = StrayPartitionIntegrationTest.logSize$1(new TopicPartition($this.strayTopic_1(), server.config().brokerId() * 2), server) + StrayPartitionIntegrationTest.logSize$1(new TopicPartition($this.strayTopic_2(), server.config().brokerId() * 2 + 1), server);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$8(server, totalLogSize)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for stray partition total size detection");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        $this.verifyStrayPartitionMetrics(2, totalLogSize);
        Assertions.assertEquals((int)3, (int)((IterableOnceOps)StrayPartitionIntegrationTest.allLogs$1(server).filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$10($this, x$10)))).size());
        Assertions.assertEquals((int)5, (int)((IterableOnceOps)StrayPartitionIntegrationTest.allLogs$1(server).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$11($this, x$11)))).size());
    }

    private static final Iterable allLogs$2(KafkaServer server$6) {
        return (Iterable)server$6.logManager().allLogs().map((Function1 & Serializable)x$12 -> x$12.topicPartition());
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayLogDeletion$3(StrayPartitionIntegrationTest $this, TopicPartition tp) {
        block3: {
            block2: {
                String string = tp.topic();
                String string2 = $this.strayTopic_1();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = tp.topic();
                String string4 = $this.strayTopic_2();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayLogDeletion$2(StrayPartitionIntegrationTest $this, KafkaServer server$6) {
        return ((IterableOnceOps)StrayPartitionIntegrationTest.allLogs$2(server$6).filter((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$verifyStrayLogDeletion$3($this, tp)))).size() == 0;
    }

    public static final /* synthetic */ String $anonfun$verifyStrayLogDeletion$4() {
        return "Timed out waiting for stray topic deletion";
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayLogDeletion$5(StrayPartitionIntegrationTest $this, TopicPartition x$13) {
        String string = x$13.topic();
        String string2 = $this.validTopic_1();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayLogDeletion$6(StrayPartitionIntegrationTest $this, TopicPartition x$14) {
        String string = x$14.topic();
        String string2 = $this.validTopic_2();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayLogDeletion$7(KafkaServer server$6) {
        return !server$6.logManager().hasStrayLogsToBeDeleted();
    }

    public static final /* synthetic */ String $anonfun$verifyStrayLogDeletion$8() {
        return "Timed out waiting for stray log deletion";
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayLogDeletion$9(KafkaServer server$6) {
        return 0 == server$6.replicaManager().strayPartitionsCount();
    }

    public static final /* synthetic */ String $anonfun$verifyStrayLogDeletion$10() {
        return "Timed out waiting for stray partitions count metric to clear";
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayPartitionMetrics$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName m = (MetricName)x0$1._1();
            String string = m.getName();
            if (!(string != null ? !string.equals(metricName$1) : metricName$1 != null)) {
                String string2 = m.getType();
                String string3 = "ReplicaManager";
                if (string2 != null && string2.equals(string3)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    private static final Metric replicaMetric$1(String metricName) {
        return (Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$verifyStrayPartitionMetrics$1(metricName, x0$1)))).head())._2();
    }

    public StrayPartitionIntegrationTest() {
        this.numBrokers = 3;
        this.topic = "topic_1";
        this.validTopic_1 = "valid-1";
        this.validTopic_2 = "valid-2";
        this.strayTopic_1 = "stray-1";
        this.replicationFactor = 3;
        this.numPartitions = 3;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LeaderImbalancePerBrokerPercentageProp(), "0");
        Predef$.MODULE$.locally(this.serverConfig().setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "1"));
    }
}

