/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ClusterTestDefaults(clusterType=Type.ALL_NON_CORESIDENT, brokers=1, controllers=1)
@ExtendWith(value={ClusterTestExtensions.class})
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d\u0001\u0002\u0007\u000e\u0001IA\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IA\u0007\u0005\u0006A\u0001!\t!\t\u0005\u0006K\u0001!\tA\n\u0005\u0006c\u0001!\tA\n\u0005\u0006g\u0001!\tA\n\u0005\u0006k\u0001!IA\u000e\u0005\u0006k\u0001!Ia\u0017\u0005\u0006S\u0002!IA\u001b\u0005\u0006g\u0002!I\u0001\u001e\u0005\u0006o\u0002!I\u0001\u001f\u0005\u0006}\u0002!Ia \u0002')>\u0004\u0018n\u0019*fcV,7\u000f^:WKJ\u001c\u0018n\u001c8D_6\u0004\u0018\r^5cS2LG/\u001f+fgR\u001c(B\u0001\b\u0010\u0003\u0019\u0019XM\u001d<fe*\t\u0001#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-A\bdYV\u001cH/\u001a:J]N$\u0018M\\2f!\tYb$D\u0001\u001d\u0015\tir\"\u0001\u0003uKN$\u0018BA\u0010\u001d\u0005=\u0019E.^:uKJLen\u001d;b]\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0002#IA\u00111\u0005A\u0007\u0002\u001b!)\u0011D\u0001a\u00015\u0005QB/Z:u\u0007J,\u0017\r^3U_BL7-\u00119j-\u0016\u00148/[8ogR\tq\u0005\u0005\u0002\u0015Q%\u0011\u0011&\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u0004WA\u0011AfL\u0007\u0002[)\u0011a\u0006H\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\u0019.\u0005-\u0019E.^:uKJ$Vm\u001d;\u00029Q,7\u000f^!eIB\u000b'\u000f^5uS>t7/\u00119j-\u0016\u00148/[8og\"\u0012AaK\u0001\u001ai\u0016\u001cH\u000fR3mKR,Gk\u001c9jG\u0006\u0003\u0018NV3sg&|g\u000e\u000b\u0002\u0006W\u0005a1M]3bi\u0016$v\u000e]5dgR\u0011q\u0007\u0015\t\u0005q}\u0012UI\u0004\u0002:{A\u0011!(F\u0007\u0002w)\u0011A(E\u0001\u0007yI|w\u000e\u001e \n\u0005y*\u0012A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n\u0019Q*\u00199\u000b\u0005y*\u0002C\u0001\u001dD\u0013\t!\u0015I\u0001\u0004TiJLgn\u001a\t\u0003\r:k\u0011a\u0012\u0006\u0003\u0011&\u000baaY8n[>t'B\u0001\tK\u0015\tYE*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0006\u0019qN]4\n\u0005=;%\u0001B+vS\u0012DQ!\u0015\u0004A\u0002I\u000b!\u0002^8qS\u000et\u0015-\\3t!\r\u0019\u0006L\u0011\b\u0003)Zs!AO+\n\u0003YI!aV\u000b\u0002\u000fA\f7m[1hK&\u0011\u0011L\u0017\u0002\u0004'\u0016\f(BA,\u0016)\ra6\r\u001a\t\u0005q}\u0012U\f\u0005\u0002_C6\tqL\u0003\u0002a\u000f\u0006A\u0001O]8u_\u000e|G.\u0003\u0002c?\n1QI\u001d:peNDQ!U\u0004A\u0002ICQ!Z\u0004A\u0002\u0019\faB]3rk\u0016\u001cHOV3sg&|g\u000e\u0005\u0002\u0015O&\u0011\u0001.\u0006\u0002\u0006'\"|'\u000f^\u0001\u0018g\u0016tGm\u0011:fCR,Gk\u001c9jGN\u0014V-];fgR$2a[9s!\taw.D\u0001n\u0015\tqw)\u0001\u0005sKF,Xm\u001d;t\u0013\t\u0001XN\u0001\u000bDe\u0016\fG/\u001a+pa&\u001c7OU3ta>t7/\u001a\u0005\u0006#\"\u0001\rA\u0015\u0005\u0006K\"\u0001\rAZ\u0001\rI\u0016dW\r^3U_BL7m\u001d\u000b\u00049V4\b\"B)\n\u0001\u0004\u0011\u0006\"B3\n\u0001\u00041\u0017a\u00053fY\u0016$X\rV8qS\u000e\u001cXk]5oO&#GcA={{B!\u0001hP#^\u0011\u0015Y(\u00021\u0001}\u0003!!x\u000e]5d\u0013\u0012\u001c\bcA*Y\u000b\")QM\u0003a\u0001M\u0006i\u0011\r\u001a3QCJ$\u0018\u000e^5p]N$R\u0001XA\u0001\u0003\u001bAq!a\u0001\f\u0001\u0004\t)!\u0001\ru_BL7\rV8QCJ$\u0018\u000e^5p]\u000e{WO\u001c;NCB\u0004R\u0001O C\u0003\u000f\u00012\u0001FA\u0005\u0013\r\tY!\u0006\u0002\u0004\u0013:$\b\"B3\f\u0001\u00041\u0007f\u0004\u0001\u0002\u0012\u0005]\u0011\u0011DA\u0012\u0003K\t9#!\n\u0011\u00071\n\u0019\"C\u0002\u0002\u00165\u00121c\u00117vgR,'\u000fV3ti\u0012+g-Y;miN\f1b\u00197vgR,'\u000fV=qK\u0012\u0012\u00111D\u0005\u0005\u0003;\ty\"\u0001\nB\u00192{fj\u0014(`\u0007>\u0013ViU%E\u000b:#&bAA\u0011[\u0005!A+\u001f9f\u0003\u001d\u0011'o\\6feNl\u0012!A\u0001\fG>tGO]8mY\u0016\u00148\u000fK\u0004\u0001\u0003W\t\u0019%!\u0012\u0011\t\u00055\u0012qH\u0007\u0003\u0003_QA!!\r\u00024\u0005IQ\r\u001f;f]NLwN\u001c\u0006\u0005\u0003k\t9$A\u0002ba&TA!!\u000f\u0002<\u00059!.\u001e9ji\u0016\u0014(bAA\u001f\u0019\u0006)!.\u001e8ji&!\u0011\u0011IA\u0018\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003\u000f\u001a#!!\u0013\u0011\t\u0005-\u0013qJ\u0007\u0003\u0003\u001bR1!!\u0010\u001d\u0013\u0011\t\t&!\u0014\u0003+\rcWo\u001d;feR+7\u000f^#yi\u0016t7/[8og\":\u0001!!\u0016\u0002D\u0005u\u0003\u0003BA,\u00033j!!a\r\n\t\u0005m\u00131\u0007\u0002\u0004)\u0006<\u0017EAA0\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8")
public class TopicRequestsVersionCompatibilityTests {
    private final ClusterInstance clusterInstance;

    @ClusterTest
    public void testCreateTopicApiVersions() {
        Assertions.assertEquals((int)0, (int)0);
        Assertions.assertEquals((int)7, (int)7);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            ListBuffer topicNames = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1 & Serializable)i -> TopicRequestsVersionCompatibilityTests.$anonfun$testCreateTopicApiVersions$2(topicNames, version, BoxesRunTime.unboxToInt((Object)i)));
            Assertions.assertTrue((boolean)this.createTopics((Seq<String>)((Seq)package$.MODULE$.Seq().empty()), (short)version).isEmpty());
            this.createTopics((Seq<String>)topicNames.toSeq(), (short)version).foreach((Function1 & Serializable)keyVal -> {
                TopicRequestsVersionCompatibilityTests.$anonfun$testCreateTopicApiVersions$3(keyVal);
                return BoxedUnit.UNIT;
            });
        });
    }

    @ClusterTest
    public void testAddPartitionsApiVersions() {
        Assertions.assertEquals((int)0, (int)0);
        Assertions.assertEquals((int)3, (int)3);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            ListBuffer topicNames = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1 & Serializable)i -> TopicRequestsVersionCompatibilityTests.$anonfun$testAddPartitionsApiVersions$2(topicNames, version, BoxesRunTime.unboxToInt((Object)i)));
            this.createTopics((Seq<String>)topicNames.toSeq());
            Assertions.assertTrue((boolean)this.addPartitions((Map<String, Object>)Predef$.MODULE$.Map().empty(), (short)version).isEmpty());
            this.addPartitions((Map<String, Object>)((IterableOnceOps)topicNames.map((Function1 & Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)BoxesRunTime.boxToInteger((int)2)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (short)version).foreach((Function1 & Serializable)keyVal -> {
                TopicRequestsVersionCompatibilityTests.$anonfun$testAddPartitionsApiVersions$4(keyVal);
                return BoxedUnit.UNIT;
            });
        });
    }

    @ClusterTest
    public void testDeleteTopicApiVersion() {
        Assertions.assertEquals((int)0, (int)0);
        Assertions.assertEquals((int)6, (int)6);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            ListBuffer topicNames = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach((Function1 & Serializable)i -> TopicRequestsVersionCompatibilityTests.$anonfun$testDeleteTopicApiVersion$2(topicNames, version, BoxesRunTime.unboxToInt((Object)i)));
            Map<String, Uuid> topicNameToUuidMap = this.createTopics((Seq<String>)topicNames.toSeq());
            Assertions.assertTrue((boolean)this.deleteTopics((Seq<String>)((Seq)package$.MODULE$.Seq().empty()), (short)version).isEmpty());
            if (version <= 5) {
                this.deleteTopics((Seq<String>)topicNames.toSeq(), (short)version).foreach((Function1 & Serializable)keyVal -> {
                    TopicRequestsVersionCompatibilityTests.$anonfun$testDeleteTopicApiVersion$3(keyVal);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            ListBuffer requestWithNames = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ListBuffer requestWithIds = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach((Function1 & Serializable)i -> TopicRequestsVersionCompatibilityTests.$anonfun$testDeleteTopicApiVersion$4(requestWithNames, version, requestWithIds, topicNameToUuidMap, BoxesRunTime.unboxToInt((Object)i)));
            this.deleteTopics((Seq<String>)requestWithNames.toSeq(), (short)version).foreach((Function1 & Serializable)keyVal -> {
                TopicRequestsVersionCompatibilityTests.$anonfun$testDeleteTopicApiVersion$5(keyVal);
                return BoxedUnit.UNIT;
            });
            this.deleteTopicsUsingId((Seq<Uuid>)requestWithIds.toSeq(), (short)version).foreach((Function1 & Serializable)keyVal -> {
                TopicRequestsVersionCompatibilityTests.$anonfun$testDeleteTopicApiVersion$6(keyVal);
                return BoxedUnit.UNIT;
            });
        });
    }

    private Map<String, Uuid> createTopics(Seq<String> topicNames) {
        CreateTopicsResponse response = this.sendCreateTopicsRequest(topicNames, (short)7);
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().topics()).asScala().map((Function1 & Serializable)result -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)result.errorCode()), (String)new StringBuilder(23).append("Failed to create topic ").append(result.name()).toString());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.name()), (Object)result.topicId());
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, Errors> createTopics(Seq<String> topicNames, short requestVersion) {
        CreateTopicsResponse response = this.sendCreateTopicsRequest(topicNames, requestVersion);
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().topics()).asScala().map((Function1 & Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.name()), (Object)Errors.forCode((short)result.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private CreateTopicsResponse sendCreateTopicsRequest(Seq<String> topicNames, short requestVersion) {
        CreateTopicsRequestData.CreatableTopicCollection topicCollection = new CreateTopicsRequestData.CreatableTopicCollection();
        topicNames.foreach((Function1 & Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)topicCollection.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(topic).setReplicationFactor((short)1).setNumPartitions(1))));
        CreateTopicsRequest request = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topicCollection)).build(requestVersion);
        return (CreateTopicsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.clusterInstance.anyBrokerSocketServer(), this.clusterInstance.clientListener(), ClassTag$.MODULE$.apply(CreateTopicsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private Map<String, Errors> deleteTopics(Seq<String> topicNames, short requestVersion) {
        DeleteTopicsRequest request = new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava(topicNames).asJava()).setTimeoutMs(10000)).build(requestVersion);
        DeleteTopicsResponse response = (DeleteTopicsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.clusterInstance.anyBrokerSocketServer(), this.clusterInstance.clientListener(), ClassTag$.MODULE$.apply(DeleteTopicsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().responses()).asScala().map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic.name()), (Object)Errors.forCode((short)topic.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<Uuid, Errors> deleteTopicsUsingId(Seq<Uuid> topicIds, short requestVersion) {
        ListBuffer topicCollection = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        topicIds.foreach((Function1 & Serializable)topic -> (ListBuffer)topicCollection.$plus$eq((Object)new DeleteTopicsRequestData.DeleteTopicState().setTopicId(topic)));
        DeleteTopicsRequest request = new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)topicCollection).asJava()).setTimeoutMs(10000)).build(requestVersion);
        DeleteTopicsResponse response = (DeleteTopicsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.clusterInstance.anyBrokerSocketServer(), this.clusterInstance.clientListener(), ClassTag$.MODULE$.apply(DeleteTopicsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().responses()).asScala().map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic.topicId()), (Object)Errors.forCode((short)topic.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, Errors> addPartitions(Map<String, Object> topicToPartitionCountMap, short requestVersion) {
        CreatePartitionsRequestData.CreatePartitionsTopicCollection topicCollection = new CreatePartitionsRequestData.CreatePartitionsTopicCollection();
        topicToPartitionCountMap.foreach((Function1 & Serializable)keyVal -> BoxesRunTime.boxToBoolean((boolean)topicCollection.add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName((String)keyVal._1()).setCount(keyVal._2$mcI$sp()).setAssignments(null))));
        CreatePartitionsRequest request = new CreatePartitionsRequest.Builder(new CreatePartitionsRequestData().setTopics(topicCollection).setTimeoutMs(10000)).build(requestVersion);
        CreatePartitionsResponse response = (CreatePartitionsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.clusterInstance.anyBrokerSocketServer(), this.clusterInstance.clientListener(), ClassTag$.MODULE$.apply(CreatePartitionsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(response.data().results()).asScala().map((Function1 & Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.name()), (Object)Errors.forCode((short)result.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ ListBuffer $anonfun$testCreateTopicApiVersions$2(ListBuffer topicNames$1, int version$1, int i) {
        return (ListBuffer)topicNames$1.$plus$eq((Object)new StringBuilder(7).append("topic-").append(version$1).append("-").append(i).toString());
    }

    public static final /* synthetic */ void $anonfun$testCreateTopicApiVersions$3(Tuple2 keyVal) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)keyVal._2(), (String)new StringBuilder(30).append("CreateTopics failed for topic ").append(keyVal._1()).toString());
    }

    public static final /* synthetic */ ListBuffer $anonfun$testAddPartitionsApiVersions$2(ListBuffer topicNames$2, int version$2, int i) {
        return (ListBuffer)topicNames$2.$plus$eq((Object)new StringBuilder(7).append("topic-").append(version$2).append("-").append(i).toString());
    }

    public static final /* synthetic */ void $anonfun$testAddPartitionsApiVersions$4(Tuple2 keyVal) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)keyVal._2(), (String)new StringBuilder(34).append("CreatePartitions failed for topic ").append(keyVal._1()).toString());
    }

    public static final /* synthetic */ ListBuffer $anonfun$testDeleteTopicApiVersion$2(ListBuffer topicNames$3, int version$3, int i) {
        return (ListBuffer)topicNames$3.$plus$eq((Object)new StringBuilder(7).append("topic-").append(version$3).append("-").append(i).toString());
    }

    public static final /* synthetic */ void $anonfun$testDeleteTopicApiVersion$3(Tuple2 keyVal) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)keyVal._2(), (String)new StringBuilder(30).append("DeleteTopics failed for topic ").append(keyVal._1()).toString());
    }

    public static final /* synthetic */ ListBuffer $anonfun$testDeleteTopicApiVersion$4(ListBuffer requestWithNames$1, int version$3, ListBuffer requestWithIds$1, Map topicNameToUuidMap$1, int i) {
        if (i < 2) {
            return (ListBuffer)requestWithNames$1.$plus$eq((Object)new StringBuilder(7).append("topic-").append(version$3).append("-").append(i).toString());
        }
        return (ListBuffer)requestWithIds$1.$plus$eq(topicNameToUuidMap$1.apply((Object)new StringBuilder(7).append("topic-").append(version$3).append("-").append(i).toString()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteTopicApiVersion$5(Tuple2 keyVal) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)keyVal._2(), (String)new StringBuilder(30).append("DeleteTopics failed for topic ").append(keyVal._1()).toString());
    }

    public static final /* synthetic */ void $anonfun$testDeleteTopicApiVersion$6(Tuple2 keyVal) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)keyVal._2(), (String)new StringBuilder(30).append("DeleteTopics failed for topic ").append(keyVal._1()).toString());
    }

    public TopicRequestsVersionCompatibilityTests(ClusterInstance clusterInstance) {
        this.clusterInstance = clusterInstance;
    }
}

