/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.controller.ControllerContext;
import kafka.server.KafkaConfig;
import kafka.server.QuorumTestHarness;
import kafka.server.cell.ZkCellControlManager;
import kafka.server.cell.ZkTenantControlManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellLoad;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.errors.CellNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.placement.CellAssignor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001B\f\u0019\u0001uAQA\t\u0001\u0005\u0002\rBq!\n\u0001C\u0002\u0013\u0005a\u0005\u0003\u0004.\u0001\u0001\u0006Ia\n\u0005\b]\u0001\u0011\r\u0011\"\u00010\u0011\u00191\u0004\u0001)A\u0005a!)q\u0007\u0001C!q!)a\n\u0001C\u0001\u001f\")A\u000b\u0001C\u0001\u001f\")a\u000b\u0001C\u0001\u001f\")\u0001\f\u0001C\u0001\u001f\")!\f\u0001C\u0001\u001f\")A\f\u0001C\u0001\u001f\")a\f\u0001C\u0001\u001f\")\u0001\r\u0001C\u0001\u001f\")!\r\u0001C\u0001\u001f\")A\r\u0001C\u0001\u001f\")a\r\u0001C\u0001\u001f\")\u0001\u000e\u0001C\u0001\u001f\")!\u000e\u0001C\u0001\u001f\")A\u000e\u0001C\u0001\u001f\")a\u000e\u0001C\u0005_\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\"\u0001\u0007.l\u0007\u0016dGnQ8oiJ|G.T1oC\u001e,'\u000fV3ti*\u0011\u0011DG\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003m\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001=A\u0011q\u0004I\u0007\u00021%\u0011\u0011\u0005\u0007\u0002\u0012#V|'/^7UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001%!\ty\u0002!A\u0004d_:$X\r\u001f;\u0016\u0003\u001d\u0002\"\u0001K\u0016\u000e\u0003%R!A\u000b\u000e\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0002-S\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002\u0011\r|g\u000e^3yi\u0002\n\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s+\u0005\u0001\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$!B*i_J$\u0018A\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\nQa]3u+B$\"!\u000f\u001f\u0011\u0005ER\u0014BA\u001e3\u0005\u0011)f.\u001b;\t\u000bu2\u0001\u0019\u0001 \u0002\u0011Q,7\u000f^%oM>\u0004\"a\u0010%\u000e\u0003\u0001S!!\u0011\"\u0002\u0007\u0005\u0004\u0018N\u0003\u0002D\t\u00069!.\u001e9ji\u0016\u0014(BA#G\u0003\u0015QWO\\5u\u0015\u00059\u0015aA8sO&\u0011\u0011\n\u0011\u0002\t)\u0016\u001cH/\u00138g_\"\u0012aa\u0013\t\u0003\u007f1K!!\u0014!\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\buKN$8)\u001a7m\u0007J,\u0017\r^3\u0015\u0003eB#aB)\u0011\u0005}\u0012\u0016BA*A\u0005\u0011!Vm\u001d;\u0002+Q,7\u000f^!tg&<gN\u0011:pW\u0016\u00148)\u001a7mg\"\u0012\u0001\"U\u0001'i\u0016\u001cH/Q:tS\u001et'I]8lKJ\u001cU\r\u001c7t/&$\b.\u0012=jgRLgnZ\"fY2\u001c\bFA\u0005R\u00035\"Xm\u001d;BgNLwM\u001c\"s_.,'oQ3mYN<\u0016\u000e\u001e5Fq&\u001cH/\u001b8h\u0007\u0016dGn](wKJl\u0015\r\u001f\u0015\u0003\u0015E\u000ba\u0006^3ti\u0016C\b\u000f\\5dSR\f5o]5h]\n\u0013xn[3s\u0007\u0016dGn],ji\",\u00050[:uS:<7)\u001a7mg\"\u00121\"U\u0001,i\u0016\u001cH/\u0012=qY&\u001c\u0017\u000e^!tg&<gN\u0011:pW\u0016\u00148)\u001a7mgRC'o\\<t\u0013\u001atunQ3mY\"\u0012A\"U\u0001\u0010i\u0016\u001cHoR3u\u00032d7)\u001a7mg\"\u0012Q\"U\u0001\u0016i\u0016\u001cHoQ8naV$X-V:bE2,7)\u001a7mQ\tq\u0011+A\u0015uKN$8i\\7qkR,Wk]1cY\u0016\u001cU\r\u001c7Q_^,'o\u00144Uo>\u001c\u0016.\\;mCRLwN\u001c\u0015\u0003\u001fE\u000bQ\u0006^3ti\u000e{W\u000e];uKV\u001b\u0018M\u00197f\u0007\u0016dGN\u0011:pW\u0016\u00148i\\;oi\u000e{gn]5eKJ\fG/[8oQ\t\u0001\u0012+\u0001\fuKN$X\u000b\u001d3bi\u0016\u001cU\r\u001c7NKR\fG-\u0019;bQ\t\t\u0012+\u0001\u0006uKN$H)\u001a7fi\u0016D#AE)\u0002'Q,7\u000f^$fi\n\u0013xn[3s\u0007\u0016dG.\u00133)\u0005M\t\u0016a\u0007;fgR,f.Y:tS\u001et'I]8lKJ\u001chI]8n\u0007\u0016dG\u000e\u000b\u0002\u0015#\u0006Q1M]3bi\u0016\u001cU\r\u001c7\u0015\u0013ALh0a\u0006\u0002\"\u0005\u0015\u0002CA9x\u001b\u0005\u0011(BA:u\u0003\u0019\u0019w.\\7p]*\u00111$\u001e\u0006\u0003m\u001a\u000ba!\u00199bG\",\u0017B\u0001=s\u0005\u0011\u0019U\r\u001c7\t\u000bi,\u0002\u0019A>\u0002\r\r,G\u000e\\%e!\t\tD0\u0003\u0002~e\t\u0019\u0011J\u001c;\t\r},\u0002\u0019AA\u0001\u0003\u001d\u0011'o\\6feN\u0004R!a\u0001\u0002\u0012mtA!!\u0002\u0002\u000eA\u0019\u0011q\u0001\u001a\u000e\u0005\u0005%!bAA\u00069\u00051AH]8pizJ1!a\u00043\u0003\u0019\u0001&/\u001a3fM&!\u00111CA\u000b\u0005\r\u0019V\r\u001e\u0006\u0004\u0003\u001f\u0011\u0004bBA\r+\u0001\u0007\u00111D\u0001\u0006gR\fG/\u001a\t\u0004c\u0006u\u0011bAA\u0010e\nI1)\u001a7m'R\fG/\u001a\u0005\u0007\u0003G)\u0002\u0019\u0001\u0019\u0002\u000f5LgnU5{K\"1\u0011qE\u000bA\u0002A\nq!\\1y'&TX-A\u0006lC\u001a\\\u0017mQ8oM&<GCAA\u0017!\ry\u0012qF\u0005\u0004\u0003cA\"aC&bM.\f7i\u001c8gS\u001e\u0004")
public class ZkCellControlManagerTest
extends QuorumTestHarness {
    private final ControllerContext context = new ControllerContext();
    private final short replicationFactor = (short)3;

    public ControllerContext context() {
        return this.context;
    }

    public short replicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.zkClient().createControllerEpochRaw(1);
    }

    @Test
    public void testCellCreate() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        int cellId = 0;
        scala.collection.immutable.Seq brokers = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        CellState state = CellState.READY;
        short minSize = (short)3;
        short maxSize = (short)6;
        Cell cell = cellControl.createCell(cellId, (Seq)brokers, state, minSize, maxSize);
        Assertions.assertEquals((Object)this.createCell(cellId, (scala.collection.immutable.Set<Object>)brokers.toSet(), state, minSize, maxSize), (Object)cellControl.getCell(cellId).get());
        Assertions.assertEquals((Object)cell, (Object)cellControl.getCell(cellId).get());
        int secondCellId = 1;
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(cellId, (Seq)brokers, state, minSize, maxSize));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(-1, (Seq)brokers, state, minSize, maxSize));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(secondCellId, (Seq)brokers, CellState.UNKNOWN, minSize, maxSize));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(secondCellId, (Seq)brokers, CellState.READY, (short)(maxSize + 1), maxSize));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(secondCellId, (Seq)brokers, state, (short)0, maxSize));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(secondCellId, (Seq)brokers, state, minSize, (short)0));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(secondCellId, (Seq)brokers, state, minSize, (short)(brokers.size() - 1)));
    }

    @Test
    public void testAssignBrokerCells() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        int cellId = 0;
        Range brokers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 15);
        Cell firstCell = cellControl.createCell(cellId, (Seq)brokers, CellState.READY, (short)6, (short)15);
        int secondCellId = 1;
        Range secondBrokers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(15), 30);
        Cell secondCell = cellControl.createCell(secondCellId, (Seq)secondBrokers, CellState.READY, (short)6, (short)15);
        int thirdCellId = 2;
        Cell thirdCell = this.createCell(thirdCellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{30}))), CellState.READY, (short)6, (short)15);
        cellControl.assignBrokersToCells((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 30));
        Assertions.assertEquals((Object)new Some((Object)firstCell), (Object)cellControl.getCell(cellId));
        Assertions.assertEquals((Object)new Some((Object)secondCell), (Object)cellControl.getCell(secondCellId));
        Assertions.assertEquals((Object)new Some((Object)thirdCell), (Object)cellControl.getCell(thirdCellId));
    }

    @Test
    public void testAssignBrokerCellsWithExistingCells() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        int cellId = 0;
        int secondCellId = 1;
        cellControl.createCell(cellId, (Seq)Nil$.MODULE$, CellState.READY, (short)6, (short)15);
        cellControl.createCell(secondCellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)15);
        cellControl.assignBrokersToCells((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 30));
        Cell cell = this.createCell(cellId, (scala.collection.immutable.Set<Object>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(3), 15).toSet(), CellState.READY, (short)6, (short)15);
        Assertions.assertEquals((Object)new Some((Object)cell), (Object)cellControl.getCell(cellId));
        Cell secondCell = this.createCell(secondCellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26}))), CellState.READY, (short)3, (short)15);
        Assertions.assertEquals((Object)new Some((Object)secondCell), (Object)cellControl.getCell(secondCellId));
    }

    @Test
    public void testAssignBrokerCellsWithExistingCellsOverMax() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        int cellId = 0;
        Cell cell = cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 11, 12, 13, 14, 15})), CellState.READY, (short)3, (short)6);
        cellControl.assignBrokersToCells((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5));
        Assertions.assertEquals((Object)new Some((Object)cell), (Object)cellControl.getCell(cellId));
    }

    @Test
    public void testExplicitAssignBrokerCellsWithExistingCells() {
        KafkaConfig config = this.kafkaConfig();
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, config, new Random(0), this.replicationFactor());
        int cellId = 0;
        int secondCellId = 1;
        Range brokerIds = (Range)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), (int)config.cellDefaultSize()).toSeq();
        cellControl.createCell(cellId, (Seq)Nil$.MODULE$, CellState.READY, (short)3, config.cellMaxSize());
        cellControl.createCell(secondCellId, (Seq)brokerIds, CellState.READY, (short)3, config.cellMaxSize());
        cellControl.assignBrokersToCell((Seq)brokerIds, 0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false);
        Cell cell = this.createCell(cellId, (scala.collection.immutable.Set<Object>)brokerIds.toSet(), CellState.READY, (short)3, config.cellMaxSize());
        Assertions.assertEquals((Object)new Some((Object)cell), (Object)cellControl.getCell(cellId));
        Cell otherCell = this.createCell(secondCellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), CellState.READY, (short)3, config.cellMaxSize());
        Assertions.assertEquals((Object)new Some((Object)otherCell), (Object)cellControl.getCell(secondCellId));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.assignBrokersToCell((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6})), 0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.assignBrokersToCell((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6})), 1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false));
    }

    @Test
    public void testExplicitAssignBrokerCellsThrowsIfNoCell() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        Assertions.assertThrows(CellNotFoundException.class, () -> cellControl.assignBrokersToCell((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), 0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false));
    }

    @Test
    public void testGetAllCells() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)cellControl.sortedCells());
        cellControl.createCell(0, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        cellControl.createCell(1, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6})), CellState.READY, (short)4, (short)6);
        cellControl.createCell(2, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7})), CellState.READY, (short)1, (short)2);
        Assertions.assertEquals((Object)new .colon.colon((Object)this.createCell(0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6), (List)new .colon.colon((Object)this.createCell(1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))), CellState.READY, (short)4, (short)6), (List)new .colon.colon((Object)this.createCell(2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7}))), CellState.READY, (short)1, (short)2), (List)Nil$.MODULE$))), (Object)cellControl.sortedCells());
    }

    @Test
    public void testComputeUsableCell() {
        long currTime = 1000L;
        MockTime time = new MockTime(0L, currTime, 0L);
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), (Time)time, this.kafkaConfig(), new Random(0), (short)3);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        cellControl.createCell(0, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        cellControl.createCell(1, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6})), CellState.READY, (short)4, (short)6);
        cellControl.createCell(2, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), CellState.READY, (short)1, (short)3);
        cellControl.createCell(3, (Seq)Nil$.MODULE$, CellState.QUARANTINED, (short)1, (short)2);
        cellControl.createCell(4, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(5, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{11})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(6, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{12})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(7, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{13})), CellState.READY, (short)1, (short)2);
        scala.collection.immutable.Set cellLoads = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CellLoad[]{new CellLoad(0, 0.1), new CellLoad(1, 0.05), new CellLoad(3, 0.0), new CellLoad(4, 0.101), new CellLoad(5, 0.102), new CellLoad(6, 0.103), new CellLoad(7, 0.104)}));
        cellControl.fullUpdateCellLoadCache(CollectionConverters$.MODULE$.SetHasAsJava((Set)cellLoads).asJava(), currTime);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3, 4, 7}))));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7}))));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8}))));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101, 102, 103}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))), CellState.READY, (short)4, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))), CellState.READY, (short)4, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
        time.setCurrentTimeMs(currTime + CellAssignor.CELL_LOAD_FRESH_DURATION_MS + 1L);
        Assertions.assertEquals((Object)new Some((Object)this.createCell(0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))), CellState.READY, (short)4, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))), CellState.READY, (short)1, (short)3)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))), CellState.READY, (short)4, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))), CellState.READY, (short)1, (short)3)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
    }

    @Test
    public void testComputeUsableCellPowerOfTwoSimulation() {
        int runs = 1000000;
        long currTime = 0L;
        MockTime time = new MockTime(0L, currTime, currTime);
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), (Time)time, this.kafkaConfig(), new Random(0), (short)1);
        cellControl.createCell(0, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(1, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(2, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(3, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(4, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})), CellState.READY, (short)1, (short)2);
        scala.collection.immutable.Set cellLoads = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CellLoad[]{new CellLoad(0, 0.0), new CellLoad(1, 0.1), new CellLoad(2, 0.2), new CellLoad(3, 0.3), new CellLoad(4, 0.4)}));
        cellControl.fullUpdateCellLoadCache(CollectionConverters$.MODULE$.SetHasAsJava((Set)cellLoads).asJava(), currTime);
        .colon.colon cellsChosen = new .colon.colon((Object)new AtomicInteger(), (List)new .colon.colon((Object)new AtomicInteger(), (List)new .colon.colon((Object)new AtomicInteger(), (List)new .colon.colon((Object)new AtomicInteger(), (List)new .colon.colon((Object)new AtomicInteger(), (List)Nil$.MODULE$)))));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), runs).foreach((Function1)((JFunction1.mcII.sp & Serializable)arg_0 -> ZkCellControlManagerTest.$anonfun$testComputeUsableCellPowerOfTwoSimulation$1(cellControl, (scala.collection.immutable.Seq)cellsChosen, arg_0)));
        float firstChosenRatio = (float)((AtomicInteger)cellsChosen.head()).get() / (float)runs;
        float secondChosenRatio = (float)((AtomicInteger)cellsChosen.apply(1)).get() / (float)runs;
        float thirdChosenRatio = (float)((AtomicInteger)cellsChosen.apply(2)).get() / (float)runs;
        float fourthChosenRatio = (float)((AtomicInteger)cellsChosen.apply(3)).get() / (float)runs;
        float fifthChosenRatio = (float)((AtomicInteger)cellsChosen.apply(4)).get() / (float)runs;
        double error = 0.01;
        Assertions.assertTrue((Math.abs((double)firstChosenRatio - 0.4) < error ? 1 : 0) != 0);
        Assertions.assertTrue((Math.abs((double)secondChosenRatio - 0.3) < error ? 1 : 0) != 0);
        Assertions.assertTrue((Math.abs((double)thirdChosenRatio - 0.2) < error ? 1 : 0) != 0);
        Assertions.assertTrue((Math.abs((double)fourthChosenRatio - 0.1) < error ? 1 : 0) != 0);
        Assertions.assertEquals((float)0.0f, (float)fifthChosenRatio);
    }

    @Test
    public void testComputeUsableCellBrokerCountConsideration() {
        int runs = 100;
        long currTime = 1000L;
        MockTime time = new MockTime(0L, currTime, 0L);
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), (Time)time, this.kafkaConfig(), new Random(0), this.replicationFactor());
        cellControl.createCell(0, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), CellState.READY, (short)1, (short)1);
        cellControl.createCell(1, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5})), CellState.READY, (short)5, (short)5);
        scala.collection.immutable.Set cellLoads = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CellLoad[]{new CellLoad(0, 0.0), new CellLoad(1, 0.1)}));
        cellControl.fullUpdateCellLoadCache(CollectionConverters$.MODULE$.SetHasAsJava((Set)cellLoads).asJava(), currTime);
        .colon.colon cellsChosen = new .colon.colon((Object)new AtomicInteger(), (List)new .colon.colon((Object)new AtomicInteger(), (List)Nil$.MODULE$));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), runs).foreach((Function1)((JFunction1.mcII.sp & Serializable)arg_0 -> ZkCellControlManagerTest.$anonfun$testComputeUsableCellBrokerCountConsideration$1(cellControl, (scala.collection.immutable.Seq)cellsChosen, arg_0)));
        float firstChosenRatio = (float)((AtomicInteger)cellsChosen.head()).get() / (float)runs;
        float secondChosenRatio = (float)((AtomicInteger)cellsChosen.apply(1)).get() / (float)runs;
        Assertions.assertTrue(((double)firstChosenRatio == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue(((double)secondChosenRatio == 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateCellMetadata() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        int cellId = 0;
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        scala.collection.immutable.Set cellBrokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Assertions.assertThrows(CellNotFoundException.class, () -> cellControl.updateCellMetadata(1, CellState.READY, (short)3, (short)6, cellBrokers));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.updateCellMetadata(cellId, CellState.READY, (short)0, (short)6, cellBrokers));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.updateCellMetadata(cellId, CellState.READY, (short)6, (short)0, cellBrokers));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.updateCellMetadata(cellId, CellState.READY, (short)0, (short)0, cellBrokers));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.updateCellMetadata(cellId, CellState.READY, (short)0, (short)0, cellBrokers));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.updateCellMetadata(cellId, CellState.READY, (short)4, (short)3, cellBrokers));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.updateCellMetadata(cellId, CellState.UNKNOWN, (short)3, (short)6, cellBrokers));
        Assertions.assertThrows(CellNotFoundException.class, () -> cellControl.updateCellMetadata(-1, CellState.READY, (short)3, (short)6, cellBrokers));
        cellControl.updateCellMetadata(cellId, CellState.QUARANTINED, (short)4, (short)5, cellBrokers);
        Cell cell = this.createCell(cellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.QUARANTINED, (short)4, (short)5);
        Assertions.assertEquals((Object)new Some((Object)cell), (Object)cellControl.getCell(cellId));
    }

    @Test
    public void testDelete() {
        KafkaConfig config = this.kafkaConfig();
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, config, new Random(0), this.replicationFactor());
        ZkTenantControlManager tenantControl = new ZkTenantControlManager(this.zkClient(), cellControl, this.context(), config, this.replicationFactor());
        int cellId = 0;
        int secondCellId = 1;
        String tenantId = "lkc-0000";
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), CellState.READY, (short)3, config.cellMaxSize());
        cellControl.createCell(secondCellId, (Seq)Nil$.MODULE$, CellState.READY, (short)3, config.cellMaxSize());
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.deleteCell(cellId));
        Range brokerIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), (int)config.cellDefaultSize());
        cellControl.assignBrokersToCell((Seq)brokerIds, secondCellId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), false);
        tenantControl.createTenant(tenantId, cellId);
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.deleteCell(cellId));
        tenantControl.deleteTenant(tenantId);
        cellControl.deleteCell(cellId);
        Assertions.assertEquals((Object)new .colon.colon((Object)this.createCell(secondCellId, (scala.collection.immutable.Set<Object>)brokerIds.toSet(), CellState.READY, (short)3, config.cellMaxSize()), (List)Nil$.MODULE$), (Object)cellControl.sortedCells());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.getCell(cellId));
        Assertions.assertThrows(CellNotFoundException.class, () -> cellControl.deleteCell(cellId));
    }

    @Test
    public void testGetBrokerCellId() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        ZkCellControlManager cellDescriber = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        int cellId = 0;
        int secondCellId = 1;
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        cellControl.createCell(secondCellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), CellState.READY, (short)3, (short)6);
        Assertions.assertEquals((int)cellId, (int)cellDescriber.getBrokerCellId(0));
        Assertions.assertEquals((int)cellId, (int)cellDescriber.getBrokerCellId(1));
        Assertions.assertEquals((int)cellId, (int)cellDescriber.getBrokerCellId(2));
        Assertions.assertEquals((int)secondCellId, (int)cellDescriber.getBrokerCellId(3));
        Assertions.assertEquals((int)secondCellId, (int)cellDescriber.getBrokerCellId(4));
        Assertions.assertEquals((int)secondCellId, (int)cellDescriber.getBrokerCellId(5));
        Assertions.assertEquals((int)-1, (int)cellDescriber.getBrokerCellId(6));
        Assertions.assertEquals((int)-1, (int)cellDescriber.getBrokerCellId(7));
    }

    @Test
    public void testUnassignBrokersFromCell() {
        KafkaConfig config = this.kafkaConfig();
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, config, new Random(0), this.replicationFactor());
        int cellId = 0;
        Range brokerIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), (int)config.cellDefaultSize());
        cellControl.assignBrokersToCells((Seq)brokerIds);
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.unassignBrokersFromCell((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).toSet()));
        cellControl.unassignBrokersFromCell((Seq)brokerIds, brokerIds.toSet());
        Cell cell = this.createCell(cellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), CellState.READY, (short)6, (short)15);
        Assertions.assertEquals((Object)new Some((Object)cell), (Object)cellControl.getCell(cellId));
    }

    private Cell createCell(int cellId, scala.collection.immutable.Set<Object> brokers, CellState state, short minSize, short maxSize) {
        return new Cell(cellId, CollectionConverters$.MODULE$.SetHasAsJava((Set)brokers.map((Function1 & Serializable)x -> ZkCellControlManagerTest.$anonfun$createCell$1(BoxesRunTime.unboxToInt((Object)x)))).asJava(), state, minSize, maxSize);
    }

    private KafkaConfig kafkaConfig() {
        boolean apply_doLog = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        return new KafkaConfig((Map)apply_props, apply_doLog);
    }

    public static final /* synthetic */ int $anonfun$testComputeUsableCellPowerOfTwoSimulation$1(ZkCellControlManager cellControl$4, scala.collection.immutable.Seq cellsChosen$1, int i) {
        Cell chosenCell = (Cell)cellControl$4.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))).get();
        return ((AtomicInteger)cellsChosen$1.apply(chosenCell.cellId())).getAndIncrement();
    }

    public static final /* synthetic */ int $anonfun$testComputeUsableCellBrokerCountConsideration$1(ZkCellControlManager cellControl$5, scala.collection.immutable.Seq cellsChosen$2, int i) {
        Cell chosenCell = (Cell)cellControl$5.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5}))).get();
        return ((AtomicInteger)cellsChosen$2.apply(chosenCell.cellId())).getAndIncrement();
    }

    public static final /* synthetic */ Integer $anonfun$createCell$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

