/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import kafka.admin.RackAwareMode;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ZkInternalAdmin;
import kafka.tier.topic.TierTopic;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.server.common.AdminOperationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005M4A!\u0006\f\u00037!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00139\u0003B\u0002\u0018\u0001A\u0003%\u0001\u0006C\u00040\u0001\t\u0007I\u0011\u0002\u0019\t\rQ\u0002\u0001\u0015!\u00032\u0011\u001d)\u0004A1A\u0005\nYBaA\u000f\u0001!\u0002\u00139\u0004bB\u001e\u0001\u0005\u0004%I\u0001\u0010\u0005\u0007\u000b\u0002\u0001\u000b\u0011B\u001f\t\u000f\u0019\u0003!\u0019!C\u0005\u000f\"11\n\u0001Q\u0001\n!Cq\u0001\u0014\u0001C\u0002\u0013%Q\n\u0003\u0004U\u0001\u0001\u0006IA\u0014\u0005\u0006+\u0002!\tA\u0016\u0005\u0006O\u0002!\tA\u0016\u0005\u0006S\u0002!\tA\u0016\u0005\u0006W\u0002!\tA\u0016\u0005\u0006[\u0002!\tA\u0016\u0005\u0006_\u0002!\tA\u0016\u0005\u0006c\u0002!\tA\u0016\u0002\u00145.Le\u000e^3s]\u0006d\u0017\tZ7j]R+7\u000f\u001e\u0006\u0003/a\taa]3sm\u0016\u0014(\"A\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0003CA\u0013\u0001\u001b\u00051\u0012!D1e[&t'l[\"mS\u0016tG/F\u0001)!\tIC&D\u0001+\u0015\tY\u0003$\u0001\u0002{W&\u0011QF\u000b\u0002\u000e\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0002\u001d\u0005$W.\u001b8[W\u000ec\u0017.\u001a8uA\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012!\r\t\u0003KIJ!a\r\f\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00039iW\r^1eCR\f7)Y2iK\u0002\naaY8oM&<W#A\u001c\u0011\u0005\u0015B\u0014BA\u001d\u0017\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005IAo\u001c9jG:\u000bW.Z\u000b\u0002{A\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005Y\u0006twMC\u0001C\u0003\u0011Q\u0017M^1\n\u0005\u0011{$AB*ue&tw-\u0001\u0006u_BL7MT1nK\u0002\n1dY8oM&<WO]3e%\u0016\u0004H.[2bi&|gNR1di>\u0014X#\u0001%\u0011\u0005uI\u0015B\u0001&\u001f\u0005\u0015\u0019\u0006n\u001c:u\u0003q\u0019wN\u001c4jOV\u0014X\r\u001a*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\n1\u0002^8qS\u000e\u001cuN\u001c4jOV\ta\n\u0005\u0002P%6\t\u0001K\u0003\u0002R\u0003\u0006!Q\u000f^5m\u0013\t\u0019\u0006K\u0001\u0006Qe>\u0004XM\u001d;jKN\fA\u0002^8qS\u000e\u001cuN\u001c4jO\u0002\nQ\u0005^3ti\u0012{gj\u001c;DC2d7I]3bi\u0016$v\u000e]5d\u0013\u001a$v\u000e]5d\u000bbL7\u000f^:\u0015\u0003]\u0003\"!\b-\n\u0005es\"\u0001B+oSRD#AD.\u0011\u0005q+W\"A/\u000b\u0005y{\u0016aA1qS*\u0011\u0001-Y\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00117-A\u0003kk:LGOC\u0001e\u0003\ry'oZ\u0005\u0003Mv\u0013A\u0001V3ti\u0006yA/Z:u)>\u0004\u0018nY\"sK\u0006$X\r\u000b\u0002\u00107\u0006yA/Z:u)>\u0004\u0018nY#ySN$8\u000f\u000b\u0002\u00117\u0006!B/Z:u+:\\gn\\<o\u000bb\u001cW\r\u001d;j_:D#!E.\u0002MQ,7\u000f\u001e+pa&\u001c7i\u001c8gS\u001e,(/\u0019;j_:\u001cx+\u001b;i)>\u0004\u0018n\u0019#fY\u0016$X\r\u000b\u0002\u00137\u0006)B/Z:u+B$\u0017\r^3U_BL7mQ8oM&<\u0007FA\n\\\u0003%\"Xm\u001d;Va\u0012\fG/\u001a+pa&\u001c7i\u001c8gS\u001eLeMV1mk\u0016\u001c\u0018\t\u001c:fC\u0012LX*\u0019;dQ\"\u0012Ac\u0017")
public final class ZkInternalAdminTest {
    private final AdminZkClient adminZkClient = (AdminZkClient)Mockito.mock(AdminZkClient.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
    private final String topicName;
    private final short configuredReplicationFactor = (short)3;
    private final Properties topicConfig;

    private AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private String topicName() {
        return this.topicName;
    }

    private short configuredReplicationFactor() {
        return this.configuredReplicationFactor;
    }

    private Properties topicConfig() {
        return this.topicConfig;
    }

    @Test
    public void testDoNotCallCreateTopicIfTopicExists() {
        int configuredNumPartitions = 10;
        int actualNumPartitions = 5;
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.adminZkClient().topicExists(this.topicName()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.adminZkClient().numPartitions(this.topicName())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)actualNumPartitions)));
        int createdPartitions = new ZkInternalAdmin(this.adminZkClient(), this.metadataCache(), () -> this.config()).ensureTopic(this.topicName(), configuredNumPartitions, this.configuredReplicationFactor(), this.topicConfig());
        ((AdminZkClient)Mockito.verify((Object)this.adminZkClient(), (VerificationMode)Mockito.times((int)1))).topicExists(this.topicName());
        AdminZkClient qual$1 = (AdminZkClient)Mockito.verify((Object)this.adminZkClient(), (VerificationMode)Mockito.times((int)0));
        String x$1 = this.topicName();
        short x$3 = this.configuredReplicationFactor();
        Properties x$4 = this.topicConfig();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(x$1, configuredNumPartitions, (int)x$3, x$4, x$5, x$6, x$7, x$8);
        Assertions.assertEquals((int)createdPartitions, (int)actualNumPartitions);
    }

    @Test
    public void testTopicCreate() {
        int configuredNumPartitions = 5;
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.adminZkClient().topicExists(this.topicName()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        int createdPartitions = new ZkInternalAdmin(this.adminZkClient(), this.metadataCache(), () -> this.config()).ensureTopic(this.topicName(), configuredNumPartitions, this.configuredReplicationFactor(), this.topicConfig());
        Assertions.assertEquals((int)configuredNumPartitions, (int)createdPartitions);
        AdminZkClient qual$1 = (AdminZkClient)Mockito.verify((Object)this.adminZkClient(), (VerificationMode)Mockito.times((int)1));
        String x$1 = this.topicName();
        short x$3 = this.configuredReplicationFactor();
        Properties x$4 = this.topicConfig();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(x$1, configuredNumPartitions, (int)x$3, x$4, x$5, x$6, x$7, x$8);
    }

    @Test
    public void testTopicExists() {
        int numPartitionsConfigured = 10;
        int numPartitionsExist = 5;
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.adminZkClient().topicExists(this.topicName()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.adminZkClient().createTopic(this.topicName(), numPartitionsConfigured, (int)this.configuredReplicationFactor(), this.topicConfig(), this.adminZkClient().createTopic$default$5(), this.adminZkClient().createTopic$default$6(), this.adminZkClient().createTopic$default$7(), this.adminZkClient().createTopic$default$8());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TopicExistsException("topic exists")});
        Mockito.when((Object)this.adminZkClient().numPartitions(this.topicName())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitionsExist)));
        int numPartitions = new ZkInternalAdmin(this.adminZkClient(), this.metadataCache(), () -> this.config()).ensureTopic(this.topicName(), numPartitionsConfigured, this.configuredReplicationFactor(), this.topicConfig());
        Assertions.assertEquals((int)numPartitionsExist, (int)numPartitions);
    }

    @Test
    public void testUnknownException() {
        int numPartitionsConfigured = 10;
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.adminZkClient().topicExists(this.topicName()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.adminZkClient().createTopic(this.topicName(), numPartitionsConfigured, (int)this.configuredReplicationFactor(), this.topicConfig(), this.adminZkClient().createTopic$default$5(), this.adminZkClient().createTopic$default$6(), this.adminZkClient().createTopic$default$7(), this.adminZkClient().createTopic$default$8());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new AdminOperationException("admin exception")});
        ZkInternalAdmin internalAdmin = new ZkInternalAdmin(this.adminZkClient(), this.metadataCache(), () -> this.config());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> internalAdmin.ensureTopic(this.topicName(), numPartitionsConfigured, this.configuredReplicationFactor(), this.topicConfig()), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("ZkInternalAdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
    }

    @Test
    public void testTopicConfigurationsWithTopicDelete() {
        Uuid uuid1 = Uuid.randomUuid();
        Mockito.when((Object)this.metadataCache().getTopicId(this.topicName())).thenReturn((Object)Uuid.ZERO_UUID).thenReturn((Object)uuid1);
        ZkInternalAdmin internalAdmin = new ZkInternalAdmin(this.adminZkClient(), this.metadataCache(), () -> this.config());
        List<String> topics = Arrays.asList(this.topicName());
        List<String> configKeys = Arrays.asList("retention.ms", "cleanup.policy");
        Assertions.assertTrue((boolean)internalAdmin.topicConfigurations(topics, configKeys).isEmpty());
    }

    @Test
    public void testUpdateTopicConfig() {
        Properties existingConfigs = TierTopic.topicConfig();
        existingConfigs.put("unclean.leader.election.enable", "true");
        Mockito.when((Object)this.adminZkClient().fetchEntityConfig("topics", this.topicName())).thenReturn((Object)existingConfigs);
        ((AdminZkClient)Mockito.doNothing().when((Object)this.adminZkClient())).changeTopicConfig(this.topicName(), TierTopic.topicConfig());
        new ZkInternalAdmin(this.adminZkClient(), this.metadataCache(), () -> this.config()).updateTopicConfig(this.topicName(), TierTopic.topicConfig());
        ((AdminZkClient)Mockito.verify((Object)this.adminZkClient(), (VerificationMode)Mockito.times((int)1))).fetchEntityConfig("topics", this.topicName());
        ((AdminZkClient)Mockito.verify((Object)this.adminZkClient(), (VerificationMode)Mockito.times((int)1))).changeTopicConfig(this.topicName(), TierTopic.topicConfig());
    }

    @Test
    public void testUpdateTopicConfigIfValuesAlreadyMatch() {
        Mockito.when((Object)this.adminZkClient().fetchEntityConfig("topics", this.topicName())).thenReturn((Object)TierTopic.topicConfig());
        new ZkInternalAdmin(this.adminZkClient(), this.metadataCache(), () -> this.config()).updateTopicConfig(this.topicName(), TierTopic.topicConfig());
        ((AdminZkClient)Mockito.verify((Object)this.adminZkClient(), (VerificationMode)Mockito.times((int)1))).fetchEntityConfig("topics", this.topicName());
        ((AdminZkClient)Mockito.verify((Object)this.adminZkClient(), (VerificationMode)Mockito.never())).changeTopicConfig((String)ArgumentMatchers.any(), (Properties)ArgumentMatchers.any());
    }

    /*
     * WARNING - void declaration
     */
    public ZkInternalAdminTest() {
        void var1_1;
        this.topicName = "testTopic";
        Properties properties = new Properties();
        properties.put("cleanup.policy", "delete");
        properties.put("retention.ms", "-1");
        properties.put("retention.bytes", "-1");
        properties.put("unclean.leader.election.enable", "false");
        this.topicConfig = var1_1;
    }
}

