/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.controller.ControllerContext;
import kafka.server.KafkaConfig;
import kafka.server.QuorumTestHarness;
import kafka.server.cell.ZkCellControlManager;
import kafka.server.cell.ZkTenantControlManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellLoad;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.errors.CellNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.ResourceNotFoundException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005m4A!\u0004\b\u0001'!)\u0001\u0004\u0001C\u00013!91\u0004\u0001b\u0001\n\u0003a\u0002BB\u0012\u0001A\u0003%Q\u0004C\u0004%\u0001\t\u0007I\u0011A\u0013\t\r1\u0002\u0001\u0015!\u0003'\u0011\u0015i\u0003\u0001\"\u0011/\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015Q\u0005\u0001\"\u0001F\u0011\u0015a\u0005\u0001\"\u0001F\u0011\u0015q\u0005\u0001\"\u0001F\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0011\u00151\b\u0001\"\u0003x\u0005iQ6\u000eV3oC:$8i\u001c8ue>dW*\u00198bO\u0016\u0014H+Z:u\u0015\ty\u0001#\u0001\u0004tKJ4XM\u001d\u0006\u0002#\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0015!\t)b#D\u0001\u000f\u0013\t9bBA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u000e\u0011\u0005U\u0001\u0011aB2p]R,\u0007\u0010^\u000b\u0002;A\u0011a$I\u0007\u0002?)\u0011\u0001\u0005E\u0001\u000bG>tGO]8mY\u0016\u0014\u0018B\u0001\u0012 \u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\tG>tG/\u001a=uA\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0016\u0003\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012Qa\u00155peR\f!C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA\u0005)1/\u001a;VaR\u0011qF\r\t\u0003OAJ!!\r\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006g\u0019\u0001\r\u0001N\u0001\ti\u0016\u001cH/\u00138g_B\u0011QGP\u0007\u0002m)\u0011q\u0007O\u0001\u0004CBL'BA\u001d;\u0003\u001dQW\u000f]5uKJT!a\u000f\u001f\u0002\u000b),h.\u001b;\u000b\u0003u\n1a\u001c:h\u0013\tydG\u0001\u0005UKN$\u0018J\u001c4pQ\t1\u0011\t\u0005\u00026\u0005&\u00111I\u000e\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0006;fgR\f5o]5h]R+g.\u00198u\u0007\u0016dG\u000eF\u00010Q\t9q\t\u0005\u00026\u0011&\u0011\u0011J\u000e\u0002\u0005)\u0016\u001cH/\u0001\u0010uKN$\u0018i]:jO:$VM\\1oi\u000e+G\u000e\\#ya2L7-\u001b;ms\"\u0012\u0001bR\u0001\u0011i\u0016\u001cH\u000fR3mKR,G+\u001a8b]RD#!C$\u0002!Q,7\u000f^\"sK\u0006$X\rV3oC:$\bF\u0001\u0006H\u0003)\u0019'/Z1uK\u000e+G\u000e\u001c\u000b\u0007%n\u0003WN\u001d;\u0011\u0005MKV\"\u0001+\u000b\u0005U3\u0016AB2p[6|gN\u0003\u0002\u0012/*\u0011\u0001\fP\u0001\u0007CB\f7\r[3\n\u0005i#&\u0001B\"fY2DQ\u0001X\u0006A\u0002u\u000baaY3mY&#\u0007CA\u0014_\u0013\ty\u0006FA\u0002J]RDQ!Y\u0006A\u0002\t\fqA\u0019:pW\u0016\u00148\u000fE\u0002dUvs!\u0001\u001a5\u0011\u0005\u0015DS\"\u00014\u000b\u0005\u001d\u0014\u0012A\u0002\u001fs_>$h(\u0003\u0002jQ\u00051\u0001K]3eK\u001aL!a\u001b7\u0003\u0007M+GO\u0003\u0002jQ!)an\u0003a\u0001_\u0006)1\u000f^1uKB\u00111\u000b]\u0005\u0003cR\u0013\u0011bQ3mYN#\u0018\r^3\t\u000bM\\\u0001\u0019\u0001\u0014\u0002\u000f5LgnU5{K\")Qo\u0003a\u0001M\u00059Q.\u0019=TSj,\u0017aC6bM.\f7i\u001c8gS\u001e$\u0012\u0001\u001f\t\u0003+eL!A\u001f\b\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a")
public class ZkTenantControlManagerTest
extends QuorumTestHarness {
    private final ControllerContext context = new ControllerContext();
    private final short replicationFactor = (short)3;

    public ControllerContext context() {
        return this.context;
    }

    public short replicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.zkClient().createControllerEpochRaw(1);
    }

    @Test
    public void testAssignTenantCell() {
        ControllerContext context = new ControllerContext();
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), context, (Time)new MockTime(0L, 0L), this.kafkaConfig(), new Random(0), this.replicationFactor());
        ZkTenantControlManager tenantControl = new ZkTenantControlManager(this.zkClient(), cellControl, context, this.kafkaConfig(), this.replicationFactor());
        String tenantId = "lkc-abcd";
        int cellId = 0;
        int secondCellId = 1;
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        cellControl.createCell(secondCellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), CellState.READY, (short)3, (short)6);
        cellControl.fullUpdateCellLoadCache(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CellLoad[]{new CellLoad(cellId, 0.3), new CellLoad(secondCellId, 0.5)}))).asJava(), 0L);
        Assertions.assertThrows(ResourceNotFoundException.class, () -> tenantControl.getOrCreateTenantToCellAssignment(tenantId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), false));
        tenantControl.getOrCreateTenantToCellAssignment(tenantId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false);
        Assertions.assertEquals((Object)new Some((Object)this.createCell(cellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6)), (Object)tenantControl.getTenantCell(tenantId));
        tenantControl.deleteTenant(tenantId);
        tenantControl.getOrCreateTenantToCellAssignment(tenantId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), true);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)tenantControl.getTenantCell(tenantId));
        Cell expectedCell = this.createCell(cellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6);
        Assertions.assertEquals((Object)expectedCell, (Object)tenantControl.getOrCreateTenantToCellAssignment(tenantId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5})), false));
        Assertions.assertEquals((Object)new Some((Object)expectedCell), (Object)tenantControl.getTenantCell(tenantId));
    }

    @Test
    public void testAssignTenantCellExplicitly() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        ZkTenantControlManager tenantControl = new ZkTenantControlManager(this.zkClient(), cellControl, this.context(), this.kafkaConfig(), this.replicationFactor());
        String tenantId = "lkc-abcd";
        int cellId = 0;
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        Assertions.assertThrows(CellNotFoundException.class, () -> tenantControl.assignTenantToCell(tenantId, 1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true));
        tenantControl.createTenant(tenantId, cellId);
        Assertions.assertEquals((Object)new Some((Object)this.createCell(cellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6)), (Object)tenantControl.getTenantCell(tenantId));
        int secondCellId = 1;
        cellControl.createCell(secondCellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), CellState.QUARANTINED, (short)3, (short)6);
        int thirdCellId = 2;
        cellControl.createCell(thirdCellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6, 7, 8})), CellState.QUARANTINED, (short)3, (short)6);
        Assertions.assertThrows(InvalidRequestException.class, () -> tenantControl.assignTenantToCell(tenantId, secondCellId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false));
        Assertions.assertThrows(InvalidRequestException.class, () -> tenantControl.assignTenantToCell(tenantId, thirdCellId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false));
        scala.collection.immutable.Set clusterBrokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}));
        cellControl.updateCellMetadata(cellId, CellState.EXCLUDED, (short)3, (short)6, clusterBrokers);
        cellControl.updateCellMetadata(secondCellId, CellState.READY, (short)3, (short)6, clusterBrokers);
        tenantControl.assignTenantToCell(tenantId, secondCellId, clusterBrokers, false);
        Assertions.assertEquals((Object)new Some((Object)this.createCell(secondCellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5}))), CellState.READY, (short)3, (short)6)), (Object)tenantControl.getTenantCell(tenantId));
        cellControl.updateCellMetadata(secondCellId, CellState.QUARANTINED, (short)3, (short)6, clusterBrokers);
        Assertions.assertThrows(InvalidRequestException.class, () -> tenantControl.assignTenantToCell(tenantId, cellId, clusterBrokers, false));
        tenantControl.assignTenantToCell(tenantId, cellId, clusterBrokers, true);
        tenantControl.assignTenantToCell(tenantId, thirdCellId, clusterBrokers, true);
        cellControl.updateCellMetadata(thirdCellId, CellState.EXCLUDED, (short)3, (short)6, clusterBrokers);
        tenantControl.assignTenantToCell(tenantId, secondCellId, clusterBrokers, true);
        Assertions.assertEquals((Object)new Some((Object)this.createCell(secondCellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5}))), CellState.QUARANTINED, (short)3, (short)6)), (Object)tenantControl.getTenantCell(tenantId));
    }

    @Test
    public void testDeleteTenant() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        ZkTenantControlManager tenantControl = new ZkTenantControlManager(this.zkClient(), cellControl, this.context(), this.kafkaConfig(), this.replicationFactor());
        String tenantId = "lkc-abcd";
        int cellId = 0;
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        tenantControl.createTenant(tenantId, cellId);
        tenantControl.deleteTenant(tenantId);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)tenantControl.getTenantCell(tenantId));
    }

    @Test
    public void testCreateTenant() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        ZkTenantControlManager tenantControl = new ZkTenantControlManager(this.zkClient(), cellControl, this.context(), this.kafkaConfig(), this.replicationFactor());
        String tenantId = "lkc-abcd";
        int cellId = 0;
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        tenantControl.createTenant(tenantId, cellId);
        Assertions.assertThrows(InvalidRequestException.class, () -> tenantControl.createTenant(tenantId, cellId));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(cellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6)), (Object)tenantControl.getTenantCell(tenantId));
    }

    private Cell createCell(int cellId, scala.collection.immutable.Set<Object> brokers, CellState state, short minSize, short maxSize) {
        return new Cell(cellId, CollectionConverters$.MODULE$.SetHasAsJava((Set)brokers.map((Function1 & Serializable)x -> ZkTenantControlManagerTest.$anonfun$createCell$1(BoxesRunTime.unboxToInt((Object)x)))).asJava(), state, minSize, maxSize);
    }

    private KafkaConfig kafkaConfig() {
        boolean apply_doLog = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        return new KafkaConfig((Map)apply_props, apply_doLog);
    }

    public static final /* synthetic */ Integer $anonfun$createCell$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

