/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t-b\u0001\u0002 @\u0001\u0019CQ!\u0014\u0001\u0005\u00029Cq!\u0015\u0001C\u0002\u0013\u0005!\u000b\u0003\u0004_\u0001\u0001\u0006Ia\u0015\u0005\b?\u0002\u0011\r\u0011\"\u0003a\u0011\u0019Q\u0007\u0001)A\u0005C\"91\u000e\u0001b\u0001\n\u0013a\u0007B\u0002:\u0001A\u0003%Q\u000eC\u0003t\u0001\u0011\u0005A\u000f\u0003\u0004\u0002\b\u0001!\t\u0001\u001e\u0005\u0007\u0003#\u0001A\u0011\u0001;\t\r\u0005U\u0001\u0001\"\u0001u\u0011\u0019\tI\u0002\u0001C\u0001i\"1\u0011Q\u0004\u0001\u0005\u0002QDa!!\t\u0001\t\u0003!\bBBA\u0013\u0001\u0011\u0005A\u000f\u0003\u0004\u0002*\u0001!\t\u0001\u001e\u0005\u0007\u0003[\u0001A\u0011\u0001;\t\r\u0005E\u0002\u0001\"\u0001u\u0011\u0019\t)\u0004\u0001C\u0001i\"1\u0011\u0011\b\u0001\u0005\u0002QDa!!\u0010\u0001\t\u0003!\bBBA!\u0001\u0011\u0005A\u000f\u0003\u0004\u0002F\u0001!\t\u0001\u001e\u0005\u0007\u0003\u0013\u0002A\u0011\u0001;\t\r\u00055\u0003\u0001\"\u0001u\u0011\u0019\t\t\u0006\u0001C\u0001i\"1\u0011Q\u000b\u0001\u0005\u0002QDq!!\u0017\u0001\t\u0013\tY\u0006\u0003\u0004\u0002*\u0002!\t\u0001\u001e\u0005\u0007\u0003[\u0003A\u0011\u0001;\t\r\u0005E\u0006\u0001\"\u0001u\u0011\u0019\t)\f\u0001C\u0001i\"1\u0011\u0011\u0018\u0001\u0005\u0002QDa!!0\u0001\t\u0003!\bBBAa\u0001\u0011\u0005A\u000f\u0003\u0004\u0002F\u0002!\t\u0001\u001e\u0005\u0007\u0003\u0013\u0004A\u0011\u0001;\t\r\u00055\u0007\u0001\"\u0001u\u0011\u0019\t\t\u000e\u0001C\u0001i\"1\u0011Q\u001b\u0001\u0005\u0002QDa!!7\u0001\t\u0003!\bBBAo\u0001\u0011\u0005A\u000f\u0003\u0004\u0002b\u0002!\t\u0001\u001e\u0005\u0007\u0003K\u0004A\u0011\u0001;\t\r\u0005%\b\u0001\"\u0001u\u0011\u0019\ti\u000f\u0001C\u0001i\"1\u0011\u0011\u001f\u0001\u0005\u0002QDa!!>\u0001\t\u0003!\bBBA}\u0001\u0011\u0005A\u000f\u0003\u0004\u0002~\u0002!\t\u0001\u001e\u0005\u0007\u0005\u0003\u0001A\u0011\u0001;\t\r\t\u0015\u0001\u0001\"\u0001u\u0011\u0019\u0011I\u0001\u0001C\u0001i\"1!Q\u0002\u0001\u0005\u0002QDaA!\u0005\u0001\t\u0003!\bB\u0002B\u000b\u0001\u0011\u0005A\u000f\u0003\u0004\u0003\u001a\u0001!\t\u0001\u001e\u0005\u0007\u00057\u0001A\u0011\u0001;\t\r\t}\u0001\u0001\"\u0001u\u0011\u0019\u0011\u0019\u0003\u0001C\u0001i\"1!q\u0005\u0001\u0005\u0002Q\u0014\u0001\u0004T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",G+Z:u\u0015\t\u0001\u0015)A\u0003fa>\u001c\u0007N\u0003\u0002C\u0007\u000611/\u001a:wKJT\u0011\u0001R\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\t\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0003\"\u0001\u0015\u0001\u000e\u0003}\n!\u0001\u001e9\u0016\u0003M\u0003\"\u0001\u0016/\u000e\u0003US!AV,\u0002\r\r|W.\\8o\u0015\t!\u0005L\u0003\u0002Z5\u00061\u0011\r]1dQ\u0016T\u0011aW\u0001\u0004_J<\u0017BA/V\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0001\u001e9!\u0003)\u0019\u0007.Z2la>Lg\u000e^\u000b\u0002CB\u0011!\r[\u0007\u0002G*\u0011q\f\u001a\u0006\u0003K\u001a\f\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005\u001d<\u0016aB:u_J\fw-Z\u0005\u0003S\u000e\u0014Q\u0003T3bI\u0016\u0014X\t]8dQ\u000eCWmY6q_&tG/A\u0006dQ\u0016\u001c7\u000e]8j]R\u0004\u0013!B2bG\",W#A7\u0011\u00059\u0004X\"A8\u000b\u0005\u0001#\u0017BA9p\u0005QaU-\u00193fe\u0016\u0003xn\u00195GS2,7)Y2iK\u000611-Y2iK\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002kB\u0011\u0001J^\u0005\u0003o&\u0013A!\u00168ji\"\u0012\u0001\"\u001f\t\u0004u\u0006\rQ\"A>\u000b\u0005ql\u0018aA1qS*\u0011ap`\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\tAW\u0001\u0006UVt\u0017\u000e^\u0005\u0004\u0003\u000bY(!C!gi\u0016\u0014X)Y2i\u0003E!Xm\u001d;Qe\u00164\u0018n\\;t\u000bB|7\r\u001b\u0015\u0004\u0013\u0005-\u0001c\u0001>\u0002\u000e%\u0019\u0011qB>\u0003\tQ+7\u000f^\u0001&g\"|W\u000f\u001c3BI\u0012,\u0005o\\2i\u0003:$W*Z:tC\u001e,wJ\u001a4tKR$vnQ1dQ\u0016D3ACA\u0006\u0003}\u0019\bn\\;mIN+GOU3tKR4E.Y4ESJ$\u0018p\u00148BgNLwM\u001c\u0015\u0004\u0017\u0005-\u0011AL:i_VdGMU3ukJtGj\\4F]\u0012|eMZ:fi&3G*\u0019;fgR,\u0005o\\2i%\u0016\fX/Z:uK\u0012D3\u0001DA\u0006\u0003Q\u001a\bn\\;mIJ+G/\u001e:o+:$WMZ5oK\u0012|eMZ:fi&3WK\u001c3fM&tW\rZ#q_\u000eD'+Z9vKN$X\r\u001a\u0015\u0004\u001b\u0005-\u0011AQ:i_VdGMT8u\u001fZ,'o\u001e:ji\u0016dunZ#oI>3gm]3u\r>\u0014\u0018\tT3bI\u0016\u0014X\t]8dQ>s7-Z%u\u0011\u0006\u001c()Z3o\u0003N\u001c\u0018n\u001a8fI\"\u001aa\"a\u0003\u0002aMDw.\u001e7e\u000b:4wN]2f\u001b>tw\u000e^8oS\u000e\fG\u000e\\=J]\u000e\u0014X-Y:j]\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;tQ\ry\u00111B\u0001=g\"|W\u000f\u001c3O_R|e/\u001a:xe&$Xm\u00144gg\u0016$hi\u001c:B\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00148dK&#\b*Y:CK\u0016t\u0017i]:jO:,G\rK\u0002\u0011\u0003\u0017\t\u0001f\u001d5pk2$'+\u001a;ve:,fn];qa>\u0014H/\u001a3JM:{W\t]8dQJ+7m\u001c:eK\u0012D3!EA\u0006\u0003\t\u001b\bn\\;mIJ+G/\u001e:o+:\u001cX\u000f\u001d9peR,G-\u00134O_\u0016\u0003xn\u00195SK\u000e|'\u000fZ3e\u0003:$WK\u001c3fM&tW\rZ#q_\u000eD'+Z9vKN$X\r\u001a\u0015\u0004%\u0005-\u0011\u0001O:i_VdGMU3ukJtg)\u001b:ti\u0016\u0003xn\u00195JMJ+\u0017/^3ti\u0016$W\t]8dQ2+7o\u001d+iC:4\u0015N]:u\u000bB|7\r\u001b\u0015\u0004'\u0005-\u0011!N:i_VdG\r\u0016:v]\u000e\fG/Z%g\u001b\u0006$8\r[5oO\u0016\u0003xn\u00195CkR,\u0015M\u001d7jKJ\u001cF/\u0019:uS:<wJ\u001a4tKRD3\u0001FA\u0006\u0003!\u001b\bn\\;mI\u001e+GOR5sgR|eMZ:fi>37+\u001e2tKF,XM\u001c;Fa>\u001c\u0007n\u00165f]>3gm]3u%\u0016\fX/Z:uK\u00124uN\u001d)sKZLw.^:Fa>\u001c\u0007\u000eK\u0002\u0016\u0003\u0017\tQi\u001d5pk2$'+\u001a;ve:tU\r\u001f;Bm\u0006LG.\u00192mK\u0016\u0003xn\u00195JMRCWM]3Jg:{W\t_1di\u0016\u0003xn\u00195G_J$\u0006.Z(oKJ+\u0017/^3ti\u0016$\u0007f\u0001\f\u0002\f\u0005\u00114\u000f[8vY\u0012tu\u000e^+qI\u0006$X-\u00129pG\"\fe\u000eZ*uCJ$xJ\u001a4tKRLe-\u0013;ES\u0012tu\u000e^\"iC:<W\rK\u0002\u0018\u0003\u0017\tQi\u001d5pk2$'+\u001a;ve:LeN^1mS\u0012|eMZ:fi&3W\t]8dQ&\u001b(+Z9vKN$X\rZ,iS\u000eD\u0017j\u001d(pi\u000e+(O]3oi2LHK]1dW\u0016$\u0007f\u0001\r\u0002\f\u0005I3\u000f[8vY\u0012\u001cV\u000f\u001d9peR,\u0005o\\2igRC\u0017\r\u001e#p\u001d>$8\u000b^1si\u001a\u0013x.\u001c.fe>D3!GA\u0006\u0003\r\u001a\bn\\;mIB+'o]5ti\u0016\u0003xn\u00195t\u0005\u0016$x/Z3o\u0013:\u001cH/\u00198dKND3AGA\u0006\u0003)\u001a\bn\\;mI\u0016sgm\u001c:dK6{gn\u001c;p]&\u001c\u0017\r\u001c7z\u0013:\u001c'/Z1tS:<W\t]8dQND3aGA\u0006\u0003\u001d!x\u000eV;qY\u0016,b!!\u0018\u0002j\u0005uD\u0003BA0\u0003\u0003\u0003r\u0001SA1\u0003K\nY(C\u0002\u0002d%\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BA4\u0003Sb\u0001\u0001B\u0004\u0002lq\u0011\r!!\u001c\u0003\u0003-\u000bB!a\u001c\u0002vA\u0019\u0001*!\u001d\n\u0007\u0005M\u0014JA\u0004O_RD\u0017N\\4\u0011\u0007!\u000b9(C\u0002\u0002z%\u00131!\u00118z!\u0011\t9'! \u0005\u000f\u0005}DD1\u0001\u0002n\t\ta\u000bC\u0004\u0002\u0004r\u0001\r!!\"\u0002\u000b\u0015tGO]=\u0011\u0011\u0005\u001d\u00151UA3\u0003wrA!!#\u0002\u001e:!\u00111RAL\u001d\u0011\ti)a%\u000e\u0005\u0005=%bAAI\u000b\u00061AH]8pizJ!!!&\u0002\t)\fg/Y\u0005\u0005\u00033\u000bY*\u0001\u0003vi&d'BAAK\u0013\u0011\ty*!)\u0002\u00075\u000b\u0007O\u0003\u0003\u0002\u001a\u0006m\u0015\u0002BAS\u0003O\u0013Q!\u00128uefTA!a(\u0002\"\u0006I3\u000f[8vY\u0012,eNZ8sG\u0016|eMZ:fiNLen\u0019:fCN,Wj\u001c8pi>t\u0017nY1mYfD3!HA\u0006\u0003Q\u001a\bn\\;mI&s7M]3bg\u0016\fe\u000e\u001a+sC\u000e\\W\t]8dQN\f5\u000fT3bI\u0016\u00148o\u00115b]\u001e,W*\u00198z)&lWm\u001d\u0015\u0004=\u0005-\u0011AO:i_VdG-\u00138de\u0016\f7/Z!oIR\u0013\u0018mY6Fa>\u001c\u0007n]!t\r>dGn\\<feJ+7-Z5wKNl\u0015M\\=NKN\u001c\u0018mZ3tQ\ry\u00121B\u0001:g\"|W\u000f\u001c3Ee>\u0004XI\u001c;sS\u0016\u001cxJ\\#q_\u000eD'i\\;oI\u0006\u0014\u0018p\u00165f]J+Wn\u001c<j]\u001ed\u0015\r^3ti\u0016sGO]5fg\"\u001a\u0001%a\u0003\u0002gMDw.\u001e7e!J,7/\u001a:wKJ+7/\u001a;PM\u001a\u001cX\r^(o\u00072,\u0017M]#be2LWm\u001d;JM>sW-\u0012=jgR\u001c\bfA\u0011\u0002\f\u0005I4\u000f[8vY\u0012,\u0006\u000fZ1uKN\u000bg/\u001a3PM\u001a\u001cX\r^,iK:|eMZ:fiR{7\t\\3beR{\u0017j\u001d\"fi^,WM\\#q_\u000eD7\u000fK\u0002#\u0003\u0017\tQe\u001d5pk2$gj\u001c;DY\u0016\f'/\u00118zi\"LgnZ%g\u001f\u001a47/\u001a;U_\u0016\u000b'\u000f\\=)\u0007\r\nY!A\u0016tQ>,H\u000e\u001a(pi\u000ecW-\u0019:B]f$\b.\u001b8h\u0013\u001a|eMZ:fiR{g)\u001b:ti>3gm]3uQ\r!\u00131B\u0001*g\"|W\u000f\u001c3SKR\f\u0017N\u001c'bi\u0016\u001cH/\u00129pG\"|en\u00117fCJ\fE\u000e\\#be2LWm\u001d;)\u0007\u0015\nY!A\u001ctQ>,H\u000eZ+qI\u0006$Xm\u00144gg\u0016$()\u001a;xK\u0016tW\t]8dQ\n{WO\u001c3be&,7o\u00148DY\u0016\f'/R1sY&,7\u000f\u001e\u0015\u0004M\u0005-\u0011\u0001O:i_VdG-\u00169eCR,wJ\u001a4tKR\u0014U\r^<fK:,\u0005o\\2i\u0005>,h\u000eZ1sS\u0016\u001cxJ\\\"mK\u0006\u0014X)\u0019:mS\u0016\u001cHO\r\u0015\u0004O\u0005-\u0011aO:i_VdGMU3uC&tG*\u0019;fgR,\u0005o\\2i\u001f:\u001cE.Z1s\u00032dW)\u0019:mS\u0016\u001cH/\u00118e+B$\u0017\r^3JiN|eMZ:fi\"\u001a\u0001&a\u0003\u0002AQ,7\u000f\u001e+sk:\u001c\u0017\r^3Ge>l7\u000b^1si^KG\u000f\u001b(p\r2,8\u000f\u001b\u0015\u0004S\u0005-\u0011aN:i_VdG\r\u0012:pa\u0016sGO]5fg\n+Go^3f]\u0016\u0003xn\u00195C_VtG-\u0019:z/\",gNU3n_ZLgn\u001a(fo\u0016\u001cH\u000fK\u0002+\u0003\u0017\tQd\u001d5pk2$7\t\\3be\u0006sGM\u00127vg\"\fE\u000e\\#oiJLWm\u001d\u0015\u0004W\u0005-\u0011!F:i_VdGm\u00117fCJ\fE\u000e\\#oiJLWm\u001d\u0015\u0004Y\u0005-\u0011aL:i_VdGMT8u%\u0016\u001cX\r^#q_\u000eD\u0007*[:u_JL\b*Z1e\u0013\u001a,f\u000eZ3gS:,G\rU1tg\u0016$\u0007fA\u0017\u0002\f\u0005y3\u000f[8vY\u0012tu\u000e\u001e*fg\u0016$X\t]8dQ\"K7\u000f^8ssR\u000b\u0017\u000e\\%g+:$WMZ5oK\u0012\u0004\u0016m]:fI\"\u001aa&a\u0003\u0002EMDw.\u001e7e\u0007>\u0014(/Z2uYf\u0014Vm\u001d;pe\u00164U\u000f\u001c7T]\u0006\u00048\u000f[8uQ\ry\u00131B\u0001#g\"|W\u000f\u001c3GKR\u001c\u0007\u000eT1uKN$X\t]8dQ>3W)\u001c9us\u000e\u000b7\r[3)\u0007A\nY!\u0001\u0011tQ>,H\u000e\u001a$fi\u000eDWI\u001c3PM\u001a\u001cX\r^(g\u000b6\u0004H/_\"bG\",\u0007fA\u0019\u0002\f\u0005y2\u000f[8vY\u0012\u001cE.Z1s\u000b\u0006\u0014H.[3ti>sW)\u001c9us\u000e\u000b7\r[3)\u0007I\nY!A\u000ftQ>,H\u000eZ\"mK\u0006\u0014H*\u0019;fgR|e.R7qif\u001c\u0015m\u00195fQ\r\u0019\u00141B\u0001'g\"|W\u000f\u001c3SKR,(O\\\"peJ,7\r^*uCJ$xJ\u001a4tKR4uN]#q_\u000eD\u0007f\u0001\u001b\u0002\f\u0005AB/[3sK\u0012,\u0005o\\2i\u0007\u0006\u001c\u0007.Z*oCB\u001c\bn\u001c;)\u0007U\nY!A\u0015tQ>,H\u000e\u001a(piJ+\u0007o\u001c:u\t&4XM]4f]\u000e,w\u000b[3o\u001d>$\u0015N^3sO\u0016t7-\u001a\u0015\u0004m\u0005-\u0011aI:i_VdGMU3q_J$H)\u001b<fe\u001e,gnY3XQ\u0016tG)\u001b<fe\u001eLgn\u001a\u0015\u0004o\u0005-\u0011!J:i_VdGmQ8oi&tW/Z,sSR,Gk\\\"bG\",wJ\u001c#jg.\u0004\u0016-^:fQ\rA\u00141B\u0001\u0016i\u0016\u001cHOR5oIB\u0013XM^5pkN,\u0005o\\2i\u0003U!Xm\u001d;GS:$\u0007K]3wS>,8/\u00128uefD3AOA\u0006\u0003E!Xm\u001d;GS:$g*\u001a=u\u000bB|7\r\u001b\u0015\u0004w\u0005-\u0011!\u0005;fgR<U\r^#q_\u000eDWI\u001c;ss\"\u001aA(a\u0003\u0002=MDw.\u001e7e\r\u0016$8\r[#q_\u000eDgi\u001c:HSZ,gn\u00144gg\u0016$\bfA\u001f\u0002\f\u0001")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private final LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
        private Seq<EpochEntry> epochs;
        private final File file;

        public void write(Collection<EpochEntry> x$1) {
            super.write(x$1);
        }

        private Seq<EpochEntry> epochs() {
            return this.epochs;
        }

        private void epochs_$eq(Seq<EpochEntry> x$1) {
            this.epochs = x$1;
        }

        public File file() {
            return this.file;
        }

        public void write(Collection<EpochEntry> epochs, boolean ignored) {
            this.epochs_$eq((Seq<EpochEntry>)CollectionConverters$.MODULE$.CollectionHasAsScala(epochs).asScala().toSeq());
        }

        public byte[] toByteArray(java.util.List<EpochEntry> epochs) {
            throw new UnsupportedOperationException("toByteArray is currently unused and is not implemented for the test checkpoint implementation");
        }

        public java.util.List<EpochEntry> read() {
            return CollectionConverters$.MODULE$.SeqHasAsJava(this.epochs()).asJava();
        }
        {
            this.epochs = (Seq)Seq$.MODULE$.empty();
            this.file = TestUtils.tempFile((String)"kafka", (String)".tmp");
        }
    };
    private final LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), this.checkpoint());

    public TopicPartition tp() {
        return this.tp;
    }

    private LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    private LeaderEpochFileCache cache() {
        return this.cache;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.checkpoint().file(), (boolean)false);
    }

    @Test
    public void testPreviousEpoch() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch());
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch());
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch());
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)OptionalInt.of(4), (Object)this.cache().previousEpoch());
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch());
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        this.cache().assign(2, 10L);
        int logEndOffset = 11;
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new EpochEntry(2, 10L), this.cache().epochEntries().get(0));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
    }

    @Test
    public void shouldSetResetFlagDirtyOnAssign() {
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.cache().isDirty()));
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.cache().isDirty()));
        this.cache().maybeFlush();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.cache().isDirty()));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        this.cache().assign(2, 11L);
        this.cache().assign(2, 12L);
        int logEndOffset = 14;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        Tuple2.mcIJ.sp expectedEpochEndOffset = new Tuple2.mcIJ.sp(-1, -1L);
        this.cache().assign(2, 11L);
        this.cache().assign(3, 12L);
        Tuple2 epochAndOffsetFor = this.toTuple(this.cache().endOffsetFor(-1, 0L));
        Assertions.assertEquals((Object)expectedEpochEndOffset, epochAndOffsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Cache not empty.");
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        int logEndOffset = 9;
        this.cache().assign(2, (long)logEndOffset);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)logEndOffset, (long)((EpochEntry)this.cache().epochEntries().get((int)0)).startOffset);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 9L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingStartOffsets() {
        this.cache().assign(2, 9L);
        this.cache().assign(3, 9L);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 9L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)6L, (long)((EpochEntry)this.cache().epochEntries().get((int)0)).startOffset);
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(0, 0L)));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        Tuple2 offsetFor = this.toTuple(this.cache().endOffsetFor(-1, 73L));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), offsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Empty cache.");
    }

    @Test
    public void shouldReturnFirstEpochIfRequestedEpochLessThanFirstEpoch() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        Tuple2 epochAndOffset = this.toTuple(this.cache().endOffsetFor(4, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(4, 11), epochAndOffset);
    }

    @Test
    public void shouldTruncateIfMatchingEpochButEarlierStartingOffset() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        this.cache().assign(7, 12L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), this.toTuple(this.cache().endOffsetFor(5, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), this.toTuple(this.cache().endOffsetFor(6, 0L)));
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        this.cache().assign(1, 11L);
        this.cache().assign(1, 12L);
        this.cache().assign(2, 13L);
        this.cache().assign(2, 14L);
        this.cache().assign(3, 15L);
        this.cache().assign(3, 16L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 15), this.toTuple(this.cache().endOffsetFor(2, 17L)));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        this.cache().assign(0, 10L);
        this.cache().assign(2, 13L);
        this.cache().assign(4, 17L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 13), this.toTuple(this.cache().endOffsetFor(1, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), this.toTuple(this.cache().endOffsetFor(2, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), this.toTuple(this.cache().endOffsetFor(3, 0L)));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        int logEndOffset = 100;
        this.cache().assign(2, 100L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(3, (long)logEndOffset)));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        this.cache().assign(2, 6L);
        int logEndOffset = 7;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils.tempFile((String)"kafka", (String)".tmp").getAbsolutePath();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(new File(checkpointPath), new LogDirFailureChannel(1));
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint);
        cache.assign(2, 6L);
        cache.maybeFlush();
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), new LogDirFailureChannel(1));
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint2);
        Assertions.assertEquals((int)1, (int)cache2.epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), cache2.epochEntries().get(0));
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingEpochs() {
        this.cache().assign(1, 5L);
        this.cache().assign(2, 6L);
        this.cache().assign(1, 7L);
        int logEndOffset = 8;
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 8), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((Object)new EpochEntry(1, 7L), this.cache().epochEntries().get(0));
    }

    private <K, V> Tuple2<K, V> toTuple(Map.Entry<K, V> entry) {
        return new Tuple2(entry.getKey(), entry.getValue());
    }

    @Test
    public void shouldEnforceOffsetsIncreaseMonotonically() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 5L);
        Assertions.assertEquals((Object)new EpochEntry(3, 5L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        long logEndOffset = 0L;
        this.cache().assign(0, 0L);
        this.cache().assign(1, 0L);
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 0), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
        logEndOffset = 5L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
        this.cache().assign(2, 5L);
        logEndOffset = 10L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 10), this.toTuple(this.cache().endOffsetFor(2, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        this.cache().assign(0, 0L);
        this.cache().assign(0, 1L);
        this.cache().assign(0, 2L);
        int logEndOffset = 3;
        Assertions.assertEquals((Object)OptionalInt.of(0), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, logEndOffset), this.toTuple(this.cache().endOffsetFor(0, (long)logEndOffset)));
        this.cache().assign(1, 3L);
        this.cache().assign(1, 4L);
        this.cache().assign(1, 5L);
        logEndOffset = 6;
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, logEndOffset), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        this.cache().assign(2, 8L);
        logEndOffset = 9;
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 3), this.toTuple(this.cache().endOffsetFor(0, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 6), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(8L);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 6L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(8L, true);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 8L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L, true);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 9L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        Assertions.assertTrue((boolean)this.cache().isDirty());
        this.cache().truncateFromStart(1L, true);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
        Assertions.assertTrue((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(6L, true);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(11L, true);
        Assertions.assertEquals(Collections.singletonList(new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L, true);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 9L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 7L);
        this.cache().assign(2, 10L);
        this.cache().truncateFromStart(5L, true);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(15L, true);
        Assertions.assertEquals(Collections.singletonList(new EpochEntry(4, 15L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void testTruncateFromStartWithNoFlush() {
        java.util.List<EpochEntry> epochs = Arrays.asList(new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L));
        epochs.forEach(epoch -> this.cache().assign(epoch.epoch, epoch.startOffset));
        Assertions.assertTrue((boolean)this.cache().isDirty());
        this.cache().maybeFlush();
        Assertions.assertFalse((boolean)this.cache().isDirty());
        this.cache().truncateFromStart(8L, false);
        java.util.List<EpochEntry> updatedEpochs = epochs.subList(1, epochs.size());
        Assertions.assertTrue((boolean)this.cache().isDirty());
        Assertions.assertEquals(updatedEpochs, (Object)this.cache().epochEntries());
        Assertions.assertEquals(epochs, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
        this.cache().maybeFlush();
        Assertions.assertFalse((boolean)this.cache().isDirty());
        Assertions.assertEquals(updatedEpochs, (Object)this.cache().epochEntries());
        Assertions.assertEquals(updatedEpochs, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(9L);
        Assertions.assertEquals((Object)OptionalInt.of(3), (Object)this.cache().latestEpoch());
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 6L), new EpochEntry(3, 8L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldClearAndFlushAllEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().clearAndFlush();
        Assertions.assertEquals((int)0, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldClearAllEntries() {
        java.util.List<EpochEntry> epochs = Arrays.asList(new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L));
        epochs.forEach(epoch -> this.cache().assign(epoch.epoch, epoch.startOffset));
        Assertions.assertTrue((boolean)this.cache().isDirty());
        this.cache().maybeFlush();
        Assertions.assertFalse((boolean)this.cache().isDirty());
        this.cache().clear();
        Assertions.assertEquals(Collections.emptyList(), (Object)this.cache().epochEntries());
        Assertions.assertTrue((boolean)this.cache().isDirty());
        Assertions.assertEquals(epochs, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
        this.cache().maybeFlush();
        Assertions.assertEquals(Collections.emptyList(), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
        Assertions.assertEquals(Collections.emptyList(), (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(-1L, true);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldCorrectlyRestoreFullSnapshot() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        java.util.List<EpochEntry> snapshot = Arrays.asList(new EpochEntry(3, 8L), new EpochEntry(4, 11L), new EpochEntry(5, 14L));
        this.cache().restore(snapshot);
        Assertions.assertEquals(snapshot, (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(7, 0L)));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        this.cache().truncateFromStart(7L, true);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        this.cache().truncateFromEnd(7L);
    }

    @Test
    public void shouldReturnCorrectStartOffsetForEpoch() {
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        int requestedEpoch = 0;
        Assertions.assertEquals((long)-1L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
        requestedEpoch = 4;
        Assertions.assertEquals((long)-1L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
        requestedEpoch = 1;
        Assertions.assertEquals((long)10L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
        this.cache().clearAndFlush();
        Assertions.assertEquals((long)-1L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
    }

    @Test
    public void tieredEpochCacheSnapshot() {
        File checkpointFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(checkpointFile, null);
        LeaderEpochFileCache newCache = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint);
        newCache.assign(3, 43L);
        newCache.assign(5, 50L);
        newCache.assign(7, 70L);
        newCache.assign(8, 80L);
        byte[] bytesOut = newCache.snapshotForSegment(70L);
        java.util.List epochEntries = LeaderEpochCheckpoint.read((String)"frombuffer", (BufferedReader)new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytesOut))));
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 43L), new EpochEntry(5, 50L), new EpochEntry(7, 70L)), (Object)epochEntries);
    }

    @Test
    public void shouldNotReportDivergenceWhenNoDivergence() {
        this.cache().assign(5, 50L);
        this.cache().assign(6, 60L);
        this.cache().assign(7, 70L);
        this.cache().assign(8, 80L);
        java.util.List<Object> tieredEpochState = this.cache().epochEntries();
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache((java.util.List)tieredEpochState, 50L, 89L, 50L, 89L), (String)"False positive for divergence while comparing with identical tier state");
        this.cache().clearAndFlush();
        this.cache().assign(6, 60L);
        this.cache().assign(7, 70L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache((java.util.List)tieredEpochState, 50L, 89L, 60L, 79L), (String)"False positive for divergence while comparing with an identical but superset tier state");
        this.cache().clearAndFlush();
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache((java.util.List)tieredEpochState, 50L, 89L, 0L, -1L), (String)"False positive for divergence when epoch cache is empty");
        tieredEpochState = Collections.emptyList();
        this.cache().clearAndFlush();
        this.cache().assign(10, 100L);
        this.cache().assign(11, 110L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, -1L, 100L, 119L), (String)"False positive for divergence when epoch cache is empty");
        tieredEpochState = Arrays.asList(new EpochEntry(5, 50L), new EpochEntry(6, 60L), new EpochEntry(7, 70L), new EpochEntry(8, 80L));
        this.cache().clearAndFlush();
        this.cache().assign(10, 100L);
        this.cache().assign(11, 110L);
        this.cache().assign(12, 120L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 100L, 129L), (String)"False positive for divergence while comparing with a disjointed epoch cache");
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 0L, 39L), (String)"False positive for divergence while comparing with a disjointed epoch cache");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 10L), new EpochEntry(2, 20L), new EpochEntry(3, 30L), new EpochEntry(4, 40L), new EpochEntry(5, 40L), new EpochEntry(6, 40L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        this.cache().assign(6, 40L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 49L, 0L, 49L), (String)"False positive for divergence when follower had not recorded leader with no messages");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 10L), new EpochEntry(2, 20L), new EpochEntry(3, 30L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 5L);
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 39L, 5L, 29L), (String)"False positive for divergence when local log had been incremented");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 100L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 899L, 100L, 999L), (String)"False positive for divergence when single entry in leaderCache, local log incremented and lastLocalOffset != lastTieredOffset");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 899L, 0L, 999L), (String)"False positive for divergence when end offset for an epoch mismatch due to lastLocalOffset != lastTieredOffset");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 100L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 49L, 0L, 149L), (String)"False negative when end offset for an epoch mismatches");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 100L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 199L, 0L, 49L), (String)"False negative when end offset for an epoch mismatches");
    }

    @Test
    public void shouldReportDivergenceWhenDiverging() {
        java.util.List<EpochEntry> tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 10L), new EpochEntry(2, 20L), new EpochEntry(3, 30L));
        this.cache().assign(2, 20L);
        this.cache().assign(3, 25L);
        this.cache().assign(4, 40L);
        this.cache().assign(5, 50L);
        Assertions.assertEquals((long)25L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 39L, 20L, 59L), (String)"False negative for an overlapping but diverging tier state");
        this.cache().clearAndFlush();
        this.cache().assign(2, 20L);
        this.cache().assign(3, 35L);
        this.cache().assign(4, 40L);
        this.cache().assign(5, 50L);
        Assertions.assertEquals((long)30L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 39L, 20L, 59L), (String)"False negative for an overlapping but diverging tier state");
        tieredEpochState = Arrays.asList(new EpochEntry(1, 10L), new EpochEntry(2, 20L), new EpochEntry(3, 30L));
        this.cache().clearAndFlush();
        this.cache().assign(1, 5L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        Assertions.assertEquals((long)5L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 10L, 39L, 5L, 39L), (String)"False negative when first local epoch has offset lower than tiered offset for the same epoch");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 10L), new EpochEntry(2, 20L), new EpochEntry(3, 30L));
        this.cache().clearAndFlush();
        this.cache().assign(3, 25L);
        this.cache().assign(4, 40L);
        this.cache().assign(5, 50L);
        Assertions.assertEquals((long)20L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 39L, 25L, 59L), (String)"False negative when local cache misses an epoch but includes the corresponding offset");
        tieredEpochState = Arrays.asList(new EpochEntry(3, 30L), new EpochEntry(4, 40L), new EpochEntry(5, 50L));
        this.cache().clearAndFlush();
        this.cache().assign(2, 20L);
        this.cache().assign(3, 35L);
        this.cache().assign(4, 40L);
        Assertions.assertEquals((long)30L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 30L, 59L, 20L, 49L), (String)"False negative when divergence at first matching epoch but it is not the first local epoch");
        this.cache().clearAndFlush();
        this.cache().assign(2, 20L);
        this.cache().assign(3, 25L);
        this.cache().assign(4, 40L);
        Assertions.assertEquals((long)25L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 30L, 59L, 20L, 49L), (String)"False negative when divergence at first matching epoch but it is not the first local epoch");
        tieredEpochState = Arrays.asList(new EpochEntry(5, 50L), new EpochEntry(6, 60L), new EpochEntry(7, 70L));
        this.cache().clearAndFlush();
        this.cache().assign(2, 60L);
        this.cache().assign(3, 70L);
        this.cache().assign(4, 80L);
        Assertions.assertEquals((long)60L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 79L, 60L, 89L), (String)"False negative when offsets at tieredEpochState and localCache do not increase monotonically");
        tieredEpochState = Arrays.asList(new EpochEntry(1, 100L), new EpochEntry(2, 150L));
        this.cache().clearAndFlush();
        this.cache().assign(1, 100L);
        Assertions.assertEquals((long)150L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 100L, 179L, 100L, 199L), (String)"False negative when localCache is missing an epoch but the corresponding offsets are written to by a different epoch");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 100L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 50L);
        this.cache().assign(1, 75L);
        Assertions.assertEquals((long)75L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 199L, 50L, 199L), (String)"False negative when end offset for start epoch mismatches");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 100L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        Assertions.assertEquals((long)100L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 149L, 0L, 149L), (String)"False negative when end offset for an epoch mismatches");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 50L);
        Assertions.assertEquals((long)50L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 99L, 0L, 199L), (String)"False negative when end offset for an epoch mismatches");
    }

    @Test
    public void shouldContinueWriteToCacheOnDiskPause() {
        TopicPartition tp = new TopicPartition("TestTopic", 5);
        LeaderEpochCheckpoint pausedDiskCheckpoint = new LeaderEpochCheckpoint(null){
            private Seq<EpochEntry> epochs;
            private final File file;

            public void write(Collection<EpochEntry> x$1) {
                super.write(x$1);
            }

            private Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public File file() {
                return this.file;
            }

            public void write(Collection<EpochEntry> epochs, boolean ignored) {
                Thread.sleep(100L);
                this.epochs_$eq((Seq<EpochEntry>)CollectionConverters$.MODULE$.CollectionHasAsScala(epochs).asScala().toSeq());
            }

            public byte[] toByteArray(java.util.List<EpochEntry> epochs) {
                throw new UnsupportedOperationException("toByteArray is currently unused and is not implemented for the test checkpoint implementation");
            }

            public java.util.List<EpochEntry> read() {
                return CollectionConverters$.MODULE$.SeqHasAsJava(this.epochs()).asJava();
            }
            {
                this.epochs = (Seq)Seq$.MODULE$.empty();
                this.file = TestUtils.tempFile((String)"kafka", (String)".tmp");
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(tp, pausedDiskCheckpoint);
        cache.assign(1, 10L);
        cache.assign(2, 20L);
        cache.assign(3, 30L);
        ExecutionContextExecutor ec = ExecutionContext$.MODULE$.fromExecutor((Executor)Executors.newFixedThreadPool(3));
        Future maybeFlushTask = Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            long tBefore = System.currentTimeMillis();
            cache.maybeFlush();
            return System.currentTimeMillis() - tBefore < 100L;
        }, (ExecutionContext)ec);
        Future assignTask = Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            long tBefore = System.currentTimeMillis();
            cache.assign(4, 40L);
            return System.currentTimeMillis() - tBefore < 100L;
        }, (ExecutionContext)ec);
        Future endOffsetForEpochTask = Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            long tBefore = System.currentTimeMillis();
            cache.endOffsetFor(3, 50L);
            return System.currentTimeMillis() - tBefore < 100L;
        }, (ExecutionContext)ec);
        Future tasks = Future$.MODULE$.sequence((IterableOnce)new .colon.colon((Object)maybeFlushTask, (List)new .colon.colon((Object)assignTask, (List)new .colon.colon((Object)endOffsetForEpochTask, (List)Nil$.MODULE$))), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)ec);
        Seq res = (Seq)Await$.MODULE$.result((Awaitable)tasks, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true, true})), (Object)res);
    }

    public void testFindPreviousEpoch() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch(2));
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch(2));
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch(4));
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)OptionalInt.of(4), (Object)this.cache().previousEpoch(10));
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch(this.cache().latestEpoch().getAsInt()));
    }

    @Test
    public void testFindPreviousEntry() {
        Assertions.assertEquals(Optional.empty(), (Object)this.cache().previousEntry(2));
        this.cache().assign(2, 10L);
        Assertions.assertEquals(Optional.empty(), (Object)this.cache().previousEntry(2));
        this.cache().assign(4, 15L);
        Assertions.assertEquals(Optional.of(new EpochEntry(2, 10L)), (Object)this.cache().previousEntry(4));
        this.cache().assign(10, 20L);
        Assertions.assertEquals(Optional.of(new EpochEntry(4, 15L)), (Object)this.cache().previousEntry(10));
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals(Optional.of(new EpochEntry(2, 10L)), (Object)this.cache().previousEntry(this.cache().latestEpoch().getAsInt()));
    }

    @Test
    public void testFindNextEpoch() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 100L);
        this.cache().assign(2, 200L);
        Assertions.assertEquals((Object)OptionalInt.of(0), (Object)this.cache().nextEpoch(-1));
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().nextEpoch(0));
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().nextEpoch(1));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().nextEpoch(2));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().nextEpoch(100));
    }

    @Test
    public void testGetEpochEntry() {
        this.cache().assign(2, 100L);
        this.cache().assign(3, 500L);
        this.cache().assign(5, 1000L);
        Assertions.assertEquals((Object)new EpochEntry(2, 100L), this.cache().epochEntry(2).get());
        Assertions.assertEquals((Object)new EpochEntry(3, 500L), this.cache().epochEntry(3).get());
        Assertions.assertEquals((Object)new EpochEntry(5, 1000L), this.cache().epochEntry(5).get());
    }

    @Test
    public void shouldFetchEpochForGivenOffset() {
        this.cache().assign(0, 10L);
        this.cache().assign(1, 20L);
        this.cache().assign(5, 30L);
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().epochForOffset(25L));
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().epochForOffset(20L));
        Assertions.assertEquals((Object)OptionalInt.of(5), (Object)this.cache().epochForOffset(30L));
        Assertions.assertEquals((Object)OptionalInt.of(5), (Object)this.cache().epochForOffset(50L));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().epochForOffset(5L));
    }
}

