/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.mockito.Mockito;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001\u0002\r\u001a\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013EA\u0006\u0003\u00042\u0001\u0001\u0006I!\f\u0005\be\u0001\u0011\r\u0011\"\u00054\u0011\u00199\u0004\u0001)A\u0005i!I\u0001\b\u0001a\u0001\u0002\u0004%\t\"\u000f\u0005\n{\u0001\u0001\r\u00111A\u0005\u0012yB\u0011\u0002\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001e\t\u000f\u0015\u0003!\u0019!C\t\r\"1A\u000b\u0001Q\u0001\n\u001dCq!\u0016\u0001A\u0002\u0013Ea\u000bC\u0004[\u0001\u0001\u0007I\u0011C.\t\ru\u0003\u0001\u0015)\u0003X\r\u0011q\u0006\u0001A0\t\u0011\rt!\u0011!Q\u0001\n\u0011Daa\n\b\u0005\u0002\u0005%\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003W\u0001A\u0011AA\n\u0011\u001d\t)\u0004\u0001C\u0005\u0003oAq!!\u000f\u0001\t#\tY\u0004C\u0004\u0002D\u0001!\t\"!\u0012\t\u0013\u0005E\u0003!%A\u0005\u0012\u0005M\u0003bBA5\u0001\u0011E\u00111\u000e\u0002'\u0003\n\u001cHO]1di\u000ecWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:UKN$(B\u0001\u000e\u001c\u0003\u0011a\u0017N\\6\u000b\u0005qi\u0012AB:feZ,'OC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\t\u0011$\u0001\u0007ce>\\WM]\"p]\u001aLw-F\u0001.!\tqs&D\u0001\u001c\u0013\t\u00014DA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00042s_.,'oQ8oM&<\u0007%\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014X#\u0001\u001b\u0011\u0005)*\u0014B\u0001\u001c\u001a\u0005I\u0019E.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0002'\rdWo\u001d;fe2Kgn['b]\u0006<WM\u001d\u0011\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ,\u0012A\u000f\t\u0003UmJ!\u0001P\r\u00035\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0002'5,G/\u00193bi\u0006l\u0015M\\1hKJ|F%Z9\u0015\u0005}\u0012\u0005C\u0001\u0012A\u0013\t\t5E\u0001\u0003V]&$\bbB\"\b\u0003\u0003\u0005\rAO\u0001\u0004q\u0012\n\u0014\u0001E7fi\u0006$\u0017\r^1NC:\fw-\u001a:!\u0003%!Wm\u001d;BI6Lg.F\u0001H!\tA%+D\u0001J\u0015\tQ5*A\u0003bI6LgN\u0003\u0002M\u001b\u000691\r\\5f]R\u001c(B\u0001\u0010O\u0015\ty\u0005+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0006\u0019qN]4\n\u0005MK%!B!e[&t\u0017A\u00033fgR\fE-\\5oA\u0005I1o\u00195fIVdWM]\u000b\u0002/B\u0011!\u0006W\u0005\u00033f\u0011Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018!D:dQ\u0016$W\u000f\\3s?\u0012*\u0017\u000f\u0006\u0002@9\"91\tDA\u0001\u0002\u00049\u0016AC:dQ\u0016$W\u000f\\3sA\t1Rj\\2l\u0007J,\u0017\r^3U_BL7m\u001d*fgVdGo\u0005\u0002\u000fAB\u0011\u0001*Y\u0005\u0003E&\u0013!c\u0011:fCR,Gk\u001c9jGN\u0014Vm];mi\u00069a-\u001e;ve\u0016\u001c\b\u0003B3kY^l\u0011A\u001a\u0006\u0003O\"\fA!\u001e;jY*\t\u0011.\u0001\u0003kCZ\f\u0017BA6g\u0005\ri\u0015\r\u001d\t\u0003[Rt!A\u001c:\u0011\u0005=\u001cS\"\u00019\u000b\u0005E|\u0012A\u0002\u001fs_>$h(\u0003\u0002tG\u00051\u0001K]3eK\u001aL!!\u001e<\u0003\rM#(/\u001b8h\u0015\t\u00198\u0005E\u0002ywvl\u0011!\u001f\u0006\u0003u6\u000baaY8n[>t\u0017B\u0001?z\u0005-Y\u0015MZ6b\rV$XO]3\u0011\u0007y\f\u0019A\u0004\u0002I\u007f&\u0019\u0011\u0011A%\u0002%\r\u0013X-\u0019;f)>\u0004\u0018nY:SKN,H\u000e^\u0005\u0005\u0003\u000b\t9A\u0001\fU_BL7-T3uC\u0012\fG/Y!oI\u000e{gNZ5h\u0015\r\t\t!\u0013\u000b\u0005\u0003\u0017\ty\u0001E\u0002\u0002\u000e9i\u0011\u0001\u0001\u0005\u0006GB\u0001\r\u0001Z\u0001\bgR\f'\u000f^+q)\u0005y\u0004fA\t\u0002\u0018A!\u0011\u0011DA\u0014\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011aA1qS*!\u0011\u0011EA\u0012\u0003\u001dQW\u000f]5uKJT1!!\nQ\u0003\u0015QWO\\5u\u0013\u0011\tI#a\u0007\u0003\u0013\t+gm\u001c:f\u00032d\u0017!\u0004;fCJ$un\u001e8DY\u0006\u001c8\u000fK\u0002\u0013\u0003_\u0001B!!\u0007\u00022%!\u00111GA\u000e\u0005!\te\r^3s\u00032d\u0017AE2sK\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e$\u0012!L\u0001\u0017SNlU\r^1eCR\fGk\u001c9jG\u000e\u0013X-\u0019;fIV\u0011\u0011Q\b\t\u0004E\u0005}\u0012bAA!G\t9!i\\8mK\u0006t\u0017AG<bSR\fe\u000eZ\"sK\u0006$X-T3uC\u0012\fG/\u0019+pa&\u001cGcA \u0002H!I\u0011\u0011J\u000b\u0011\u0002\u0003\u0007\u00111J\u0001\u000bo\u0006LG\u000fV5nK6\u001b\bc\u0001\u0012\u0002N%\u0019\u0011qJ\u0012\u0003\t1{gnZ\u0001%o\u0006LG/\u00118e\u0007J,\u0017\r^3NKR\fG-\u0019;b)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u000b\u0016\u0005\u0003\u0017\n9f\u000b\u0002\u0002ZA!\u00111LA3\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014!C;oG\",7m[3e\u0015\r\t\u0019gI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA4\u0003;\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003e\u0019'/Z1uK6+G/\u00193bi\u0006$v\u000e]5d%\u0016\u001cX\u000f\u001c;\u0015\u0007\u0001\fi\u0007C\u0004\u0002p]\u0001\r!!\u001d\u0002\u001dQD'o\\<Fq\u000e,\u0007\u000f^5p]B)!%a\u001d\u0002x%\u0019\u0011QO\u0012\u0003\r=\u0003H/[8o!\u0011\tI(a!\u000f\t\u0005m\u0014q\u0010\b\u0004_\u0006u\u0014\"\u0001\u0013\n\u0007\u0005\u00055%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0015q\u0011\u0002\n)\"\u0014xn^1cY\u0016T1!!!$Q\u001d\u0001\u00111RAI\u0003'\u0003B!!\u0007\u0002\u000e&!\u0011qRA\u000e\u00051!Vm\u001d;J]N$\u0018M\\2f\u0003\u00151\u0018\r\\;fI\t\t)*\u0003\u0003\u0002\u0018\u0006e\u0015!\u0003)F%~\u001bE*Q*T\u0015\u0011\tY*!(\u0002\u00131Kg-Z2zG2,'\u0002BAP\u00037\tA\u0002V3ti&s7\u000f^1oG\u0016\u0004")
public class AbstractClusterLinkMetadataManagerTest {
    private final KafkaConfig brokerConfig = this.createBrokerConfig();
    private final ClusterLinkManager clusterLinkManager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
    private ClusterLinkMetadataManager metadataManager;
    private final Admin destAdmin = (Admin)Mockito.mock(KafkaAdminClient.class);
    private ClusterLinkScheduler scheduler = new ClusterLinkScheduler(0, 100);

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    public void metadataManager_$eq(ClusterLinkMetadataManager x$1) {
        this.metadataManager = x$1;
    }

    public Admin destAdmin() {
        return this.destAdmin;
    }

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(ClusterLinkScheduler x$1) {
        this.scheduler = x$1;
    }

    @BeforeAll
    public void startUp() {
        Mockito.when((Object)this.clusterLinkManager().listClusterLinks()).thenReturn((Object)package$.MODULE$.Seq().empty());
    }

    @AfterAll
    public void tearDownClass() {
        this.scheduler().shutdown();
        this.scheduler_$eq(null);
    }

    private KafkaConfig createBrokerConfig() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        props.put("confluent.cluster.link.metadata.topic.enable", "true");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public boolean isMetadataTopicCreated() {
        Field field = this.metadataManager().getClass().getSuperclass().getDeclaredField("initialized");
        field.setAccessible(true);
        return BoxesRunTime.unboxToBoolean((Object)field.get(this.metadataManager()));
    }

    public void waitAndCreateMetadataTopic(long waitTimeMs) {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.isMetadataTopicCreated()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTimeMs) {
                Assertions.fail((String)"MetadataTopic not created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), waitUntilTrue_pause));
        }
    }

    public long waitAndCreateMetadataTopic$default$1() {
        return 15000L;
    }

    public CreateTopicsResult createMetadataTopicResult(Option<Throwable> throwException) {
        KafkaFutureImpl createTopicFuture = new KafkaFutureImpl();
        if (throwException instanceof Some) {
            Throwable exception = (Throwable)((Some)throwException).value();
            createTopicFuture.completeExceptionally(exception);
            Map.Entry[] entryArray = new Map.Entry[1];
            String mkEntry_k = "_confluent-link-metadata";
            Object var4_4 = null;
            entryArray[0] = new AbstractMap.SimpleEntry<String, KafkaFutureImpl>(mkEntry_k, createTopicFuture);
            return new MockCreateTopicsResult(Utils.mkMap((Map.Entry[])entryArray));
        }
        if (None$.MODULE$.equals(throwException)) {
            createTopicFuture.complete((Object)new CreateTopicsResult.TopicMetadataAndConfig(Uuid.randomUuid(), Predef$.MODULE$.Integer2int(this.brokerConfig().clusterLinkMetadataTopicPartitions()), 2, new Config(Collections.emptyList())));
            Map.Entry[] entryArray = new Map.Entry[1];
            String mkEntry_k = "_confluent-link-metadata";
            Object var5_5 = null;
            entryArray[0] = new AbstractMap.SimpleEntry<String, KafkaFutureImpl>(mkEntry_k, createTopicFuture);
            return new MockCreateTopicsResult(Utils.mkMap((Map.Entry[])entryArray));
        }
        throw new MatchError(throwException);
    }

    public static final /* synthetic */ boolean $anonfun$waitAndCreateMetadataTopic$1(AbstractClusterLinkMetadataManagerTest $this) {
        return $this.isMetadataTopicCreated();
    }

    public static final /* synthetic */ String $anonfun$waitAndCreateMetadataTopic$2() {
        return "MetadataTopic not created";
    }

    public class MockCreateTopicsResult
    extends CreateTopicsResult {
        public /* synthetic */ AbstractClusterLinkMetadataManagerTest kafka$server$link$AbstractClusterLinkMetadataManagerTest$MockCreateTopicsResult$$$outer() {
            return AbstractClusterLinkMetadataManagerTest.this;
        }

        public MockCreateTopicsResult(Map<String, KafkaFuture<CreateTopicsResult.TopicMetadataAndConfig>> futures) {
            if (AbstractClusterLinkMetadataManagerTest.this == null) {
                throw null;
            }
            super(futures);
        }
    }
}

