/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.util.Arrays;
import java.util.Collections;
import kafka.server.link.AclFilter;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import org.apache.kafka.common.Uuid;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005a3Aa\u0005\u000b\u00017!)!\u0005\u0001C\u0001G!)a\u0005\u0001C\u0001O!)\u0001\b\u0001C\u0001O!)!\b\u0001C\u0001O!)A\b\u0001C\u0001O!)a\b\u0001C\u0001O!)\u0001\t\u0001C\u0001O!)!\t\u0001C\u0001O!)A\t\u0001C\u0001O!)a\t\u0001C\u0001O!)\u0001\n\u0001C\u0001O!)!\n\u0001C\u0001O!)A\n\u0001C\u0001O!)a\n\u0001C\u0001O!)\u0001\u000b\u0001C\u0001O!)!\u000b\u0001C\u0001O!)A\u000b\u0001C\u0001O!)a\u000b\u0001C\u0001O\tY\u0011i\u00197Kg>tG+Z:u\u0015\t)b#\u0001\u0003mS:\\'BA\f\u0019\u0003\u0019\u0019XM\u001d<fe*\t\u0011$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011Q\u0005A\u0007\u0002)\u0005QC/Z:u\u000b6\u0004H/_*ue&tw\rU1sg\u0016\u001cHk\\#naRL\u0018i\u00197GS2$XM]:Kg>tG#\u0001\u0015\u0011\u0005uI\u0013B\u0001\u0016\u001f\u0005\u0011)f.\u001b;)\u0005\ta\u0003CA\u00177\u001b\u0005q#BA\u00181\u0003\r\t\u0007/\u001b\u0006\u0003cI\nqA[;qSR,'O\u0003\u00024i\u0005)!.\u001e8ji*\tQ'A\u0002pe\u001eL!a\u000e\u0018\u0003\tQ+7\u000f^\u0001&i\u0016\u001cHOV1mS\u0012\u001cFO]5oOB\u000b'o]3t)>\f5\r\u001c$jYR,'o\u001d&t_:D#a\u0001\u0017\u0002#Q,7\u000f\u001e'j].\f5\r\u001c$jYR,'\u000f\u000b\u0002\u0005Y\u0005)B/Z:u\u00032dG*\u001b8l\u0003\u000ed7OR5mi\u0016\u0014\bFA\u0003-\u0003Q!Xm\u001d;Ok2d'j]8o\u0003J<W/\\3oi\"\u0012a\u0001L\u0001\u0018i\u0016\u001cH/T5tg&twMU3t_V\u00148-\u001a+za\u0016D#a\u0002\u0017\u00029Q,7\u000f^'jgNLgn\u001a*fg>,(oY3UsB,g+\u00197vK\"\u0012\u0001\u0002L\u0001\u0018i\u0016\u001cH/\u00138wC2LGMU3t_V\u00148-\u001a+za\u0016D#!\u0003\u0017\u0002-Q,7\u000f^'jgNLgn\u001a)biR,'O\u001c+za\u0016D#A\u0003\u0017\u00027Q,7\u000f^'jgNLgn\u001a)biR,'O\u001c+za\u00164\u0016\r\\;fQ\tYA&\u0001\fuKN$\u0018J\u001c<bY&$\u0007+\u0019;uKJtG+\u001f9fQ\taA&\u0001\u000buKN$X*[:tS:<w\n]3sCRLwN\u001c\u0015\u0003\u001b1\n\u0011\u0004^3ti6K7o]5oO>\u0003XM]1uS>tg+\u00197vK\"\u0012a\u0002L\u0001\u0015i\u0016\u001cH/\u00138wC2LGm\u00149fe\u0006$\u0018n\u001c8)\u0005=a\u0013!\u0007;fgRl\u0015n]:j]\u001e\u0004VM]7jgNLwN\u001c+za\u0016D#\u0001\u0005\u0017\u0002=Q,7\u000f^'jgNLgn\u001a)fe6L7o]5p]RK\b/\u001a,bYV,\u0007FA\t-\u0003e!Xm\u001d;J]Z\fG.\u001b3QKJl\u0017n]:j_:$\u0016\u0010]3)\u0005Ia\u0003")
public class AclJsonTest {
    @Test
    public void testEmptyStringParsesToEmptyAclFiltersJson() {
        Assertions.assertTrue((boolean)AclJson$.MODULE$.parse("").isEmpty());
    }

    @Test
    public void testValidStringParsesToAclFiltersJson() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        Option aclJson = AclJson$.MODULE$.parse(aclFiltersJson);
        Assertions.assertTrue((boolean)aclJson.isDefined());
        AclFilter aclFilter = (AclFilter)((AclFiltersJson)aclJson.get()).aclFilters().head();
        Assertions.assertEquals((Object)"any", (Object)aclFilter.resourceFilter().resourceType());
        Assertions.assertEquals((Object)"any", (Object)aclFilter.resourceFilter().patternType());
        Assertions.assertEquals((Object)"any", (Object)aclFilter.accessFilter().operation());
        Assertions.assertEquals((Object)"any", (Object)aclFilter.accessFilter().permissionType());
        Assertions.assertEquals(Collections.singleton(Uuid.ZERO_UUID), (Object)aclFilter.accessFilter().clusterLinkIds());
        Assertions.assertNull((Object)aclFilter.resourceFilter().name());
        Assertions.assertNull((Object)aclFilter.accessFilter().host());
        Assertions.assertNull((Object)aclFilter.accessFilter().principal());
    }

    @Test
    public void testLinkAclFilter() {
        Uuid linkId = Uuid.randomUuid();
        Uuid localLinkId = Uuid.ZERO_UUID;
        String aclFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(344).append("{\n         | \"aclFilters\": [{\n         |  \"resourceFilter\": {\n         |      \"resourceType\": \"any\",\n         |      \"patternType\": \"any\"\n         |    },\n         |  \"accessFilter\": {\n         |     \"operation\": \"any\",\n         |     \"permissionType\": \"any\",\n         |     \"clusterLinkIds\": [\"").append(localLinkId).append("\",\"").append(linkId).append("\"]\n         |    }\n         |  }]\n         | }").toString()));
        Option aclJson = AclJson$.MODULE$.parse(aclFiltersJson);
        Assertions.assertTrue((boolean)aclJson.isDefined());
        AclFilter aclFilter = (AclFilter)((AclFiltersJson)aclJson.get()).aclFilters().head();
        Assertions.assertEquals((Object)"any", (Object)aclFilter.resourceFilter().resourceType());
        Assertions.assertEquals((Object)"any", (Object)aclFilter.resourceFilter().patternType());
        Assertions.assertEquals((Object)"any", (Object)aclFilter.accessFilter().operation());
        Assertions.assertEquals((Object)"any", (Object)aclFilter.accessFilter().permissionType());
        Assertions.assertEquals(Arrays.asList(localLinkId, linkId), (Object)aclFilter.accessFilter().clusterLinkIds());
        Assertions.assertNull((Object)aclFilter.resourceFilter().name());
        Assertions.assertNull((Object)aclFilter.accessFilter().host());
        Assertions.assertNull((Object)aclFilter.accessFilter().principal());
    }

    @Test
    public void testAllLinkAclsFilter() {
        String allLinkIdsFilter = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         | \"aclFilters\": [{\n         |  \"resourceFilter\": {\n         |      \"resourceType\": \"any\",\n         |      \"patternType\": \"any\"\n         |    },\n         |  \"accessFilter\": {\n         |     \"operation\": \"any\",\n         |     \"permissionType\": \"any\",\n         |     \"clusterLinkIds\": []\n         |    }\n         |  }]\n         | }"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(allLinkIdsFilter));
    }

    @Test
    public void testNullJsonArgument() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse("{}"));
        Assertions.assertEquals((Object)"acl.filters cannot be the JSON null", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingResourceType() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": { \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"resourceType field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingResourceTypeValue() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"resourceType field may not be empty.", (Object)thrown.getMessage());
    }

    @Test
    public void testInvalidResourceType() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"foo\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"Unknown resourceType: foo", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingPatternType() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"patternType field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingPatternTypeValue() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"patternType field may not be empty.", (Object)thrown.getMessage());
    }

    @Test
    public void testInvalidPatternType() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"foo\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"Unknown patternType: foo", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingOperation() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": { \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"operation field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingOperationValue() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"operation field may not be empty.", (Object)thrown.getMessage());
    }

    @Test
    public void testInvalidOperation() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"foo\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"Unknown operation: foo", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingPermissionType() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"permissionType field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingPermissionTypeValue() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"permissionType field may not be empty.", (Object)thrown.getMessage());
    }

    @Test
    public void testInvalidPermissionType() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"foo\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"Unknown permissionType: foo", (Object)thrown.getMessage());
    }
}

