/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.UnboundedClusterLinkRequestQuota$;
import kafka.server.link.AbstractClusterLinkClientManager;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkAutoCreateMirror;
import kafka.server.link.ClusterLinkAutoCreateMirror$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidTopicTaskErrorCode$;
import kafka.server.link.PolicyViolationTaskErrorCode$;
import kafka.server.link.SourceCluster$;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicExistsTaskErrorCode$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkState;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.ListMirrorsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkDisabledException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011ea\u0001B8q\u0001]DQA \u0001\u0005\u0002}D\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003\u0013A\u0011\"!\n\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u0003\u0013A\u0011\"!\u000b\u0001\u0005\u0004%I!a\u000b\t\u0011\u0005M\u0002\u0001)A\u0005\u0003[A\u0011\"!\u000e\u0001\u0005\u0004%I!a\u000e\t\u0011\u0005}\u0002\u0001)A\u0005\u0003sA\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005m\u0003\u0001)A\u0005\u0003\u000bB\u0011\"!\u0018\u0001\u0005\u0004%I!a\u0018\t\u0011\u00055\u0004\u0001)A\u0005\u0003CB\u0011\"a\u001c\u0001\u0005\u0004%I!a\u0018\t\u0011\u0005E\u0004\u0001)A\u0005\u0003CB\u0011\"a\u001d\u0001\u0005\u0004%I!!\u001e\t\u0011\u0005\r\u0005\u0001)A\u0005\u0003oB\u0011\"!\"\u0001\u0005\u0004%I!a\"\t\u0011\u0005=\u0005\u0001)A\u0005\u0003\u0013C\u0011\"!%\u0001\u0005\u0004%I!a%\t\u0011\u0005m\u0005\u0001)A\u0005\u0003+C\u0011\"!(\u0001\u0005\u0004%I!a(\t\u0011\u0005e\u0006\u0001)A\u0005\u0003CC\u0011\"a/\u0001\u0005\u0004%I!a(\t\u0011\u0005u\u0006\u0001)A\u0005\u0003CC\u0011\"a0\u0001\u0005\u0004%I!a(\t\u0011\u0005\u0005\u0007\u0001)A\u0005\u0003CC\u0011\"a1\u0001\u0005\u0004%I!a(\t\u0011\u0005\u0015\u0007\u0001)A\u0005\u0003CC\u0011\"a2\u0001\u0005\u0004%I!a(\t\u0011\u0005%\u0007\u0001)A\u0005\u0003CC\u0011\"a3\u0001\u0005\u0004%I!!4\t\u0011\u0005m\u0007\u0001)A\u0005\u0003\u001fD\u0011\"!8\u0001\u0005\u0004%I!a8\t\u0011\u0005%\b\u0001)A\u0005\u0003CDq!a;\u0001\t\u0003\ti\u000fC\u0004\u0003\f\u0001!\t!!<\t\u000f\tU\u0001\u0001\"\u0003\u0002n\"9!q\u0003\u0001\u0005\n\te\u0001\"\u0003B\u0013\u0001E\u0005I\u0011\u0002B\u0014\u0011\u001d\u0011i\u0004\u0001C\u0005\u0005\u007fA\u0011Ba\u0011\u0001#\u0003%IAa\n\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H!I!\u0011\r\u0001\u0012\u0002\u0013%!1\r\u0005\n\u0005O\u0002\u0011\u0013!C\u0005\u0005GBqA!\u001b\u0001\t\u0013\u0011Y\u0007C\u0004\u0003~\u0001!IAa \t\u0013\te\u0005!%A\u0005\n\t\r\u0004b\u0002BN\u0001\u0011%!Q\u0014\u0005\n\u0005S\u0003\u0011\u0013!C\u0005\u0005GBqAa+\u0001\t\u0013\u0011i\u000bC\u0005\u0003>\u0002\t\n\u0011\"\u0003\u0003d!9!q\u0018\u0001\u0005\n\t\u0005\u0007b\u0002B`\u0001\u0011%!\u0011\u001a\u0005\b\u0005\u001b\u0004A\u0011\u0002Bh\u0011\u001d\u0011)\u000e\u0001C\u0005\u0005/DqA!6\u0001\t\u0013\u0011Y\u000fC\u0004\u0003x\u0002!IA!?\t\u0013\t}\b!%A\u0005\n\t\r\u0004\"CB\u0001\u0001E\u0005I\u0011\u0002B2\u0011\u001d\u0019\u0019\u0001\u0001C\u0001\u0003[Dqa!\u0004\u0001\t\u0003\ti\u000fC\u0004\u0004\u0012\u0001!\t!!<\t\u000f\rU\u0001\u0001\"\u0001\u0002n\"91\u0011\u0004\u0001\u0005\u0002\u00055\bbBB\u000f\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0007C\u0001A\u0011AAw\u0011\u001d\u0019)\u0003\u0001C\u0001\u0003[Dqa!\u000b\u0001\t\u0003\ti\u000fC\u0004\u0004.\u0001!\t!!<\t\u000f\rE\u0002\u0001\"\u0001\u0002n\"91Q\u0007\u0001\u0005\u0002\u00055\bbBB\u001d\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0007{\u0001A\u0011AAw\u0011\u001d\u0019\t\u0005\u0001C\u0001\u0003[Dqa!\u0012\u0001\t\u0003\ti\u000fC\u0004\u0004J\u0001!\t!!<\t\u000f\r5\u0003\u0001\"\u0001\u0002n\"91\u0011\u000b\u0001\u0005\u0002\u00055\bbBB+\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u00073\u0002A\u0011AAw\u0011\u001d\u0019i\u0006\u0001C\u0001\u0003[Dqa!\u0019\u0001\t\u0003\ti\u000fC\u0004\u0004f\u0001!\t!!<\t\u000f\r%\u0004\u0001\"\u0001\u0002n\"91Q\u000e\u0001\u0005\u0002\u00055\bbBB9\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0007k\u0002A\u0011AAw\u0011\u001d\u0019I\b\u0001C\u0001\u0003[Dqa! \u0001\t\u0013\u0019y\bC\u0004\u0004\u0006\u0002!\t!!<\t\u000f\r%\u0005\u0001\"\u0001\u0002n\"91Q\u0012\u0001\u0005\u0002\u00055\bbBBI\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0007+\u0003A\u0011AAw\u0011\u001d\u0019I\n\u0001C\u0001\u0003[Dqa!(\u0001\t\u0003\ti\u000fC\u0004\u0004\"\u0002!\t!!<\u0007\r\r\u0015\u0006\u0001ABT\u0011)\u0019yk\u0019B\u0001B\u0003%1\u0011\u0017\u0005\u0007}\u000e$\taa.\t\u0013\t\r5\r1A\u0005\u0002\r}\u0006\"CBcG\u0002\u0007I\u0011ABd\u0011!\u0019im\u0019Q!\n\r\u0005\u0007\"CBhG\u0002\u0007I\u0011ABi\u0011%\u0019\u0019n\u0019a\u0001\n\u0003\u0019)\u000e\u0003\u0005\u0004Z\u000e\u0004\u000b\u0015\u0002B\u0010\u0011\u001d\u0019Yn\u0019C!\u0007;Dq\u0001b\u0001d\t\u0003\")\u0001C\u0004\u0005\u0012\r$\t\u0001b\u0005\u0003?\rcWo\u001d;fe2Kgn[!vi>\u001c%/Z1uK6K'O]8s)\u0016\u001cHO\u0003\u0002re\u0006!A.\u001b8l\u0015\t\u0019H/\u0001\u0004tKJ4XM\u001d\u0006\u0002k\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001y!\tIH0D\u0001{\u0015\u0005Y\u0018!B:dC2\f\u0017BA?{\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\"!!\u0001\u0011\u0007\u0005\r\u0001!D\u0001q\u0003-\u0019x.\u001e:dK\u0006#W.\u001b8\u0016\u0005\u0005%\u0001\u0003BA\u0006\u0003?i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0005\u0003'\t)\"A\u0004dY&,g\u000e^:\u000b\u0007U\f9B\u0003\u0003\u0002\u001a\u0005m\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u001e\u0005\u0019qN]4\n\t\u0005\u0005\u0012Q\u0002\u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u00031\u0019x.\u001e:dK\u0006#W.\u001b8!\u0003%!Wm\u001d;BI6Lg.\u0001\u0006eKN$\u0018\tZ7j]\u0002\nq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0003\u0003[\u0001B!a\u0001\u00020%\u0019\u0011\u0011\u00079\u00035\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0002!5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004\u0013!D2mS\u0016tG/T1oC\u001e,'/\u0006\u0002\u0002:A!\u00111AA\u001e\u0013\r\ti\u0004\u001d\u0002\u001d\u00072,8\u000f^3s\u0019&t7\u000eR3ti\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s\u00039\u0019G.[3oi6\u000bg.Y4fe\u0002\n\u0001#\u001b8dYV$W-\u00117m\r&dG/\u001a:\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003+rA!!\u0013\u0002RA\u0019\u00111\n>\u000e\u0005\u00055#bAA(m\u00061AH]8pizJ1!a\u0015{\u0003\u0019\u0001&/\u001a3fM&!\u0011qKA-\u0005\u0019\u0019FO]5oO*\u0019\u00111\u000b>\u0002#%t7\r\\;eK\u0006cGNR5mi\u0016\u0014\b%\u0001\u0004mS:\\\u0017\nZ\u000b\u0003\u0003C\u0002B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0005\u0003O\n)\"\u0001\u0004d_6lwN\\\u0005\u0005\u0003W\n)G\u0001\u0003Vk&$\u0017a\u00027j].LE\rI\u0001\u000eg>,(oY3U_BL7-\u00133\u0002\u001dM|WO]2f)>\u0004\u0018nY%eA\u0005AA.\u001b8l\t\u0006$\u0018-\u0006\u0002\u0002xA!\u0011\u0011PA@\u001b\t\tYHC\u0002\u0002~Q\f!A_6\n\t\u0005\u0005\u00151\u0010\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC\u0006IA.\u001b8l\t\u0006$\u0018\rI\u0001\b[\u0016$(/[2t+\t\tI\t\u0005\u0003\u0002\u0004\u0005-\u0015bAAGa\n\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\t\t)\n\u0005\u0003\u0002\u0004\u0005]\u0015bAAMa\n!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003Q!x\u000e]5d\u000bbL7\u000f^:Fq\u000e,\u0007\u000f^5p]V\u0011\u0011\u0011\u0015\t\u0006s\u0006\r\u0016qU\u0005\u0004\u0003KS(AB(qi&|g\u000e\u0005\u0003\u0002*\u0006Mf\u0002BAV\u0003_sA!a\u0013\u0002.&\t10C\u0002\u00022j\fq\u0001]1dW\u0006<W-\u0003\u0003\u00026\u0006]&!\u0003+ie><\u0018M\u00197f\u0015\r\t\tL_\u0001\u0016i>\u0004\u0018nY#ySN$8/\u0012=dKB$\u0018n\u001c8!\u0003Y\tW\u000f\u001e5pe&T\u0018\r^5p]\u0016C8-\u001a9uS>t\u0017aF1vi\"|'/\u001b>bi&|g.\u0012=dKB$\u0018n\u001c8!\u0003a\u0001x\u000e\\5dsZKw\u000e\\1uS>tW\t_2faRLwN\\\u0001\u001aa>d\u0017nY=WS>d\u0017\r^5p]\u0016C8-\u001a9uS>t\u0007%A\u000bj]Z\fG.\u001b3U_BL7-\u0012=dKB$\u0018n\u001c8\u0002-%tg/\u00197jIR{\u0007/[2Fq\u000e,\u0007\u000f^5p]\u0002\n!#\u001a=fGV$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\u0006\u0019R\r_3dkRLwN\\#yG\u0016\u0004H/[8oA\u0005!A/[7f+\t\ty\r\u0005\u0003\u0002R\u0006]WBAAj\u0015\u0011\t).!\u001a\u0002\u000bU$\u0018\u000e\\:\n\t\u0005e\u00171\u001b\u0002\u0005)&lW-A\u0003uS6,\u0007%A\u0003rk>$\u0018-\u0006\u0002\u0002bB!\u00111]As\u001b\u0005\u0011\u0018bAAte\n92\t\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\u0001\u0007cV|G/\u0019\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005=\bcA=\u0002r&\u0019\u00111\u001f>\u0003\tUs\u0017\u000e\u001e\u0015\u0004I\u0005]\b\u0003BA}\u0005\u000fi!!a?\u000b\t\u0005u\u0018q`\u0001\u0004CBL'\u0002\u0002B\u0001\u0005\u0007\tqA[;qSR,'O\u0003\u0003\u0003\u0006\u0005m\u0011!\u00026v]&$\u0018\u0002\u0002B\u0005\u0003w\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\u0013\u0003\u0010A!\u0011\u0011 B\t\u0013\u0011\u0011\u0019\"a?\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\u0003:fg\u0016$Xj\\2l\u0003%\u0019X\r^;q\u001b>\u001c7\u000e\u0006\u0003\u0002p\nm\u0001\"\u0003B\u000fOA\u0005\t\u0019\u0001B\u0010\u0003!\u001a8.\u001b9NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u0019&t7.\u001a3U_BL7m]!oIJ+\u0007\u000f\\1z!\rI(\u0011E\u0005\u0004\u0005GQ(a\u0002\"p_2,\u0017M\\\u0001\u0014g\u0016$X\u000f]'pG.$C-\u001a4bk2$H%M\u000b\u0003\u0005SQCAa\b\u0003,-\u0012!Q\u0006\t\u0005\u0005_\u0011I$\u0004\u0002\u00032)!!1\u0007B\u001b\u0003%)hn\u00195fG.,GMC\u0002\u00038i\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YD!\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0006wKJLg-_'pG.$B!a<\u0003B!I!QD\u0015\u0011\u0002\u0003\u0007!qD\u0001\u0015m\u0016\u0014\u0018NZ=N_\u000e\\G\u0005Z3gCVdG\u000fJ\u0019\u0002+5L'O]8s)>\u0004\u0018nY:B]\u00124VM]5gsRA!\u0011\nB(\u00053\u0012i\u0006\u0005\u0003\u0002\u0004\t-\u0013b\u0001B'a\nY2\t\\;ti\u0016\u0014H*\u001b8l\u0003V$xn\u0011:fCR,W*\u001b:s_JDqA!\u0015,\u0001\u0004\u0011\u0019&A\tdYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u0004B!a\u0001\u0003V%\u0019!q\u000b9\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw\rC\u0005\u0003\\-\u0002\n\u00111\u0001\u0002\"\u0006)2M]3bi\u0016$v\u000e]5dg\u0016C8-\u001a9uS>t\u0007\"\u0003B0WA\u0005\t\u0019AAQ\u0003Ma\u0017n\u001d;U_BL7m]#yG\u0016\u0004H/[8o\u0003}i\u0017N\u001d:peR{\u0007/[2t\u0003:$g+\u001a:jMf$C-\u001a4bk2$HEM\u000b\u0003\u0005KRC!!)\u0003,\u0005yR.\u001b:s_J$v\u000e]5dg\u0006sGMV3sS\u001aLH\u0005Z3gCVdG\u000fJ\u001a\u0002!5|7m[\"sK\u0006$X\rV8qS\u000e\u001cH\u0003\u0002B7\u0005g\u0002B!a\u0003\u0003p%!!\u0011OA\u0007\u0005I\u0019%/Z1uKR{\u0007/[2t%\u0016\u001cX\u000f\u001c;\t\u000f\tUd\u00061\u0001\u0003x\u0005QAo\u001c9jGN$v.\u0012=\u0011\u0011\u0005\u001d#\u0011PA#\u0003CKAAa\u001f\u0002Z\t\u0019Q*\u00199\u000255|7m[\"sK\u0006$X\rV8qS\u000e\u001c8+Y7f%\u0016\u001cX\u000f\u001c;\u0015\r\t5$\u0011\u0011BK\u0011\u001d\u0011\u0019i\fa\u0001\u0005\u000b\u000ba\u0001^8qS\u000e\u001c\bC\u0002BD\u0005#\u000b)%\u0004\u0002\u0003\n*!!1\u0012BG\u0003\u001diW\u000f^1cY\u0016T1Aa${\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005'\u0013IIA\u0002TKRD\u0011Ba&0!\u0003\u0005\r!!)\u0002\u0005\u0015D\u0018\u0001J7pG.\u001c%/Z1uKR{\u0007/[2t'\u0006lWMU3tk2$H\u0005Z3gCVdG\u000f\n\u001a\u000215|7m\u001b(p\u0013:$XM\u001d8bY2K7\u000f\u001e+pa&\u001c7\u000f\u0006\u0004\u0003 \n\u0015&q\u0015\t\u0005\u0003\u0017\u0011\t+\u0003\u0003\u0003$\u00065!\u0001\u0005'jgR$v\u000e]5dgJ+7/\u001e7u\u0011\u001d\u0011\u0019)\ra\u0001\u0005\u000bC\u0011Ba&2!\u0003\u0005\r!!)\u0002E5|7m\u001b(p\u0013:$XM\u001d8bY2K7\u000f\u001e+pa&\u001c7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u00039iwnY6MSN$Hk\u001c9jGN$bAa(\u00030\nm\u0006b\u0002BYg\u0001\u0007!1W\u0001\u0010]\u0006lWm\u001d+p\u0019&\u001cH/\u001b8hgBA\u0011q\tB=\u0003\u000b\u0012)\f\u0005\u0003\u0002\f\t]\u0016\u0002\u0002B]\u0003\u001b\u0011A\u0002V8qS\u000ed\u0015n\u001d;j]\u001eD\u0011Ba&4!\u0003\u0005\r!!)\u000215|7m\u001b'jgR$v\u000e]5dg\u0012\"WMZ1vYR$#'A\bn_\u000e\\G*[:u\u001b&\u0014(o\u001c:t)\t\u0011\u0019\r\u0005\u0003\u0002\f\t\u0015\u0017\u0002\u0002Bd\u0003\u001b\u0011\u0011\u0003T5ti6K'O]8sgJ+7/\u001e7u)\u0011\u0011\u0019Ma3\t\u000f\t\re\u00071\u0001\u0003\u0006\u000611m\u001c8gS\u001e$BAa\u0015\u0003R\"9!1[\u001cA\u0002\u0005\u0015\u0013a\u0003;pa&\u001cg)\u001b7uKJ\f\u0001\u0003^3ti6K'O]8s)>\u0004\u0018nY:\u0015\u0019\u0005=(\u0011\u001cBo\u0005C\u0014)O!;\t\u000f\tm\u0007\b1\u0001\u0003\u0006\u0006a1o\\;sG\u0016$v\u000e]5dg\"9!q\u001c\u001dA\u0002\t\u0015\u0015AE:pkJ\u001cW-T5se>\u0014Hk\u001c9jGNDqAa99\u0001\u0004\u0011))\u0001\u0006eKN$Hk\u001c9jGNDqAa:9\u0001\u0004\u0011))A\bfqB,7\r^3e\u001b&\u0014(o\u001c:t\u0011\u001d\u0011i\r\u000fa\u0001\u0005'\"\"\"a<\u0003n\n=(\u0011\u001fBz\u0011\u001d\u0011Y.\u000fa\u0001\u0005\u000bCqAa9:\u0001\u0004\u0011)\tC\u0004\u0003hf\u0002\rA!\"\t\u000f\tU\u0018\b1\u0001\u0002F\u00051a-\u001b7uKJ\f\u0011\u0004^3ti6K'O]8s)>\u0004\u0018nY:Fq\u000e,\u0007\u000f^5p]R1\u0011q\u001eB~\u0005{D\u0011Ba\u0017;!\u0003\u0005\r!!)\t\u0013\t}#\b%AA\u0002\u0005\u0005\u0016a\t;fgRl\u0015N\u001d:peR{\u0007/[2t\u000bb\u001cW\r\u001d;j_:$C-\u001a4bk2$H%M\u0001$i\u0016\u001cH/T5se>\u0014Hk\u001c9jGN,\u0005pY3qi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00133\u0003I!Xm\u001d;NSJ\u0014xN](oKR{\u0007/[2)\u0007u\u001a9\u0001\u0005\u0003\u0002z\u000e%\u0011\u0002BB\u0006\u0003w\u0014A\u0001V3ti\u0006yB/Z:u\u001d>\u001c%/Z1uKR{\u0007/[2t\u0013\u001a$v\u000e]5d\u000bbL7\u000f^:)\u0007y\u001a9!\u0001\u000euKN$8I]3bi\u0016$v\u000e]5dg^KG\u000f\u001b)sK\u001aL\u0007\u0010K\u0002@\u0007\u000f\t\u0011\u0005^3ti:{7I]3bi\u0016$v\u000e]5dg&3Gk\u001c9jG&\u001bX*\u001b:s_JD3\u0001QB\u0004\u00039!Xm\u001d;J]&$\u0018.\u00197ju\u0016D3!QB\u0004\u0003}!Xm\u001d;NSJ\u0014xN](oKR{\u0007/[2Ge>l\u0017i[\"mkN$XM\u001d\u0015\u0004\u0005\u000e\u001d\u0011\u0001\u0007;fgRLen\u00197vI\u0016d\u0015\u000e^3sC24\u0015\u000e\u001c;fe\"\u001a1ia\u0002\u00023Q,7\u000f^%oG2,H-\u001a)sK\u001aL\u00070\u001a3GS2$XM\u001d\u0015\u0004\t\u000e\u001d\u0011\u0001\u0007;fgR,\u0005p\u00197vI\u0016d\u0015\u000e^3sC24\u0015\u000e\u001c;fe\"\u001aQia\u0002\u00023Q,7\u000f^#yG2,H-\u001a)sK\u001aL\u00070\u001a3GS2$XM\u001d\u0015\u0004\r\u000e\u001d\u0011A\u0005;fgR\u0014\u0015\r^2i\u001b&\u0014(o\u001c:j]\u001eD3aRB\u0004\u0003m!Xm\u001d;MSN$Hk\u001c9jGN\fU\u000f\u001e5Fq\u000e,\u0007\u000f^5p]\"\u001a\u0001ja\u0002\u0002AQ,7\u000f\u001e'jgR$v\u000e]5dg\u0016CXmY;uS>tW\t_2faRLwN\u001c\u0015\u0004\u0013\u000e\u001d\u0011A\t;fgR\u001c%/Z1uKR{\u0007/[2t\u000bb,7-\u001e;j_:,\u0005pY3qi&|g\u000eK\u0002K\u0007\u000f\tQ\u0004^3ti\u000e\u0013X-\u0019;f)>\u0004\u0018nY:BkRDW\t_2faRLwN\u001c\u0015\u0004\u0017\u000e\u001d\u0011!\n;fgR\u001c%/Z1uKR{\u0007/[2t\u0007V\u001cHo\\7fe\u0006+H\u000f[#yG\u0016\u0004H/[8oQ\ra5qA\u0001)i\u0016\u001cHo\u0011:fCR,Gk\u001c9jGN\u0004v\u000e\\5dsZKw\u000e\\1uS>tW\t_2faRLwN\u001c\u0015\u0004\u001b\u000e\u001d\u0011a\b;fgR\u001c%/Z1uKR{\u0007/[2t\u000bbL7\u000f^:Fq\u000e,\u0007\u000f^5p]\"\u001aaja\u0002\u0002?Q,7\u000f^\"sK\u0006$X-\u00138wC2LG\rV8qS\u000e,\u0005pY3qi&|g\u000eK\u0002P\u0007\u000f\t1\u0004^3ti\u0012+7\u000f\u001e'jgR$v\u000e]5dg\u0016C8-\u001a9uS>t\u0007f\u0001)\u0004\b\u0005aB/Z:u%\u0016l\u0017N\u001d:pe\u0012+G.\u001a;fI\u0012+7\u000f\u001e+pa&\u001c\u0007fA)\u0004\b\u0005AB/Z:u\u001b&\u0014(o\u001c:OK^\u001cv.\u001e:dKR{\u0007/[2)\u0007I\u001b9!\u0001\u000buKN$\u0018\t\u001a3J]\u000edW\u000fZ3GS2$XM\u001d\u0015\u0004'\u000e\u001d\u0011a\u0006;fgR$U\r\\3uK\u0016C8\r\\;eK\u001aKG\u000e^3sQ\r!6qA\u0001\u0018i\u0016\u001cH\u000fR3mKR,\u0017J\\2mk\u0012,g)\u001b7uKJD3!VB\u0004\u0003=\"Xm\u001d;O_\u0012+\b\u000f\\5dCR,7I]3bi\u0016$v\u000e]5dg\u000e\u000bG\u000e\u001c$pe\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dQ\r16qA\u00013i\u0016\u001cH\u000fV8qS\u000e\u001c\u0015M\u001c\"f\u0007J,\u0017\r^3e\u0003\u001a$XM]\"p]\u001ad\u0017n\u0019;j]\u001e$v\u000e]5d\t\u0016dW\r^5p]\"\u001aqka\u0002\u0002MQ,7\u000f\u001e(p\u0007J,\u0017\r^3U_BL7m]\"bY24uN]%oi\u0016\u0014h.\u00197U_BL7\rK\u0002Y\u0007\u000f\tq\u0005^3ti:{7I]3bi\u0016$v\u000e]5dg\u000e\u000bG\u000e\u001c$pe\u000e{gN\u001a7vK:$Hk\u001c9jG\"\u001a\u0011la\u0002\u0002aY,'/\u001b4z\u001d>\u001c%/Z1uKR{\u0007/[2t\r>\u0014\u0018J\u001c;fe:\fGn\u0014:D_:4G.^3oiR{\u0007/[2t)\u0011\tyo!!\t\u000f\r\r%\f1\u0001\u00036\u0006aAo\u001c9jG2K7\u000f^5oO\u0006qB/Z:u\u0007>tg\r\\5di&tw\rR3ti\u000e\u000b7\r[3WC2,Xm\u001d\u0015\u00047\u000e\u001d\u0011!\u000b;fgRtun\u0011:fCR,Gk\u001c9jG^KG\u000f[%oC\u000e$\u0018N^3NSJ\u0014xN\u001d+pa&\u001c7\u000fK\u0002]\u0007\u000f\ta\u0005^3ti6+H\u000e^5qY\u0016<&/\u001b;feNlUM]4f)>\u0004\u0018nY:U_\u000e\u0013X-\u0019;fQ\ri6qA\u00014i\u0016\u001cHoU8ve\u000e,7\t\\;ti\u0016\u00148)\u00198D_:$\u0018-\u001b8NSJ\u0014xN\u001d+pa&\u001c7OU3ukJt7OR1mg\u0016D3AXB\u0004\u0003\u0005#Xm\u001d;T_V\u00148-Z\"mkN$XM]\"b]\u000e{g\u000e^1j]6K'O]8s)>\u0004\u0018nY:SKR,(O\\:FeJ$U/Z!vi\"|'/\u001b>bi&|g\u000eK\u0002`\u0007\u000f\t\u0001\n^3tiN{WO]2f\u00072,8\u000f^3s\u0007\u0006t7i\u001c8uC&tW*\u001b:s_J$v\u000e]5dgJ+G/\u001e:ogR\u0013X/\u001a#vKR{wK]8oO\u0016\u0013(o\u001c:NKN\u001c\u0018mZ3)\u0007\u0001\u001c9!A uKN$8k\\;sG\u0016\u001cE.^:uKJ\u001c\u0015M\\\"p]R\f\u0017N\\'jeJ|'\u000fV8qS\u000e\u001c()Y:jG\u000ecWo\u001d;feJ+G/\u001e:og\u001a\u000bGn]3)\u0007\u0005\u001c9!A\buKN$h)\u001b7uKJ$v\u000e]5dQ\r\u00117q\u0001\u0002\u0010)\u0016\u001cH/\u00113nS:\u001cE.[3oiN\u00191m!+\u0011\t\u0005-11V\u0005\u0005\u0007[\u000biAA\bN_\u000e\\\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0003\u0011qw\u000eZ3\u0011\t\u0005\r41W\u0005\u0005\u0007k\u000b)G\u0001\u0003O_\u0012,G\u0003BB]\u0007{\u00032aa/d\u001b\u0005\u0001\u0001bBBXK\u0002\u00071\u0011W\u000b\u0003\u0007\u0003\u0004b!a\u0012\u0004D\u0006\u0015\u0013\u0002\u0002BJ\u00033\n!\u0002^8qS\u000e\u001cx\fJ3r)\u0011\tyo!3\t\u0013\r-w-!AA\u0002\r\u0005\u0017a\u0001=%c\u00059Ao\u001c9jGN\u0004\u0013\u0001\u00043fY\u0016$XmQ1mY\u0016$WC\u0001B\u0010\u0003A!W\r\\3uK\u000e\u000bG\u000e\\3e?\u0012*\u0017\u000f\u0006\u0003\u0002p\u000e]\u0007\"CBfU\u0006\u0005\t\u0019\u0001B\u0010\u00035!W\r\\3uK\u000e\u000bG\u000e\\3eA\u0005a1M]3bi\u0016$v\u000e]5dgR1!QNBp\u0007sDqa!9m\u0001\u0004\u0019\u0019/A\u0005oK^$v\u000e]5dgB11Q]Bx\u0007gl!aa:\u000b\t\r%81^\u0001\u0005kRLGN\u0003\u0002\u0004n\u0006!!.\u0019<b\u0013\u0011\u0019\tpa:\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u0002\f\rU\u0018\u0002BB|\u0003\u001b\u0011\u0001BT3x)>\u0004\u0018n\u0019\u0005\b\u0007wd\u0007\u0019AB\u007f\u0003\u001dy\u0007\u000f^5p]N\u0004B!a\u0003\u0004\u0000&!A\u0011AA\u0007\u0005M\u0019%/Z1uKR{\u0007/[2t\u001fB$\u0018n\u001c8t\u00031!W\r\\3uKR{\u0007/[2t)\u0011!9\u0001\"\u0004\u0011\t\u0005-A\u0011B\u0005\u0005\t\u0017\tiA\u0001\nEK2,G/\u001a+pa&\u001c7OU3tk2$\bb\u0002BB[\u0002\u0007Aq\u0002\t\u0007\u0007K\u001cy/!\u0012\u0002#\u0005$G\rV8qS\u000e|U\u000f^(g\u0005\u0006tG\r\u0006\u0003\u0002p\u0012U\u0001b\u0002C\f]\u0002\u0007\u0011QI\u0001\u0006i>\u0004\u0018n\u0019")
public class ClusterLinkAutoCreateMirrorTest {
    private final ConfluentAdmin sourceAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ConfluentAdmin destAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
    private final String includeAllFilter;
    private final Uuid linkId = Uuid.randomUuid();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkData linkData = new ClusterLinkData("testLink", this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics("test-link", this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, false, (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$, false);
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler(0, 100);
    private final Option<Throwable> topicExistsException = new Some((Object)new TopicExistsException(""));
    private final Option<Throwable> authorizationException = new Some((Object)new AuthorizationException(""));
    private final Option<Throwable> policyViolationException = new Some((Object)new PolicyViolationException("Violated a policy."));
    private final Option<Throwable> invalidTopicException = new Some((Object)new InvalidTopicException("Invalid topic error."));
    private final Option<Throwable> executionException = new Some((Object)new ExecutionException("", null));
    private final Time time = new MockTime();
    private final ClusterLinkRequestQuota quota = UnboundedClusterLinkRequestQuota$.MODULE$;

    private ConfluentAdmin sourceAdmin() {
        return this.sourceAdmin;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    private String includeAllFilter() {
        return this.includeAllFilter;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private Option<Throwable> topicExistsException() {
        return this.topicExistsException;
    }

    private Option<Throwable> authorizationException() {
        return this.authorizationException;
    }

    private Option<Throwable> policyViolationException() {
        return this.policyViolationException;
    }

    private Option<Throwable> invalidTopicException() {
        return this.invalidTopicException;
    }

    private Option<Throwable> executionException() {
        return this.executionException;
    }

    private Time time() {
        return this.time;
    }

    private ClusterLinkRequestQuota quota() {
        return this.quota;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
    }

    private void resetMock() {
        Mockito.reset((Object[])new ConfluentAdmin[]{this.sourceAdmin()});
        Mockito.reset((Object[])new ConfluentAdmin[]{this.destAdmin()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.reset((Object[])new ClusterLinkDestClientManager[]{this.clientManager()});
    }

    private void setupMock(boolean skipMetadataManagerLinkedTopicsAndReplay) {
        this.resetMock();
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().getAdmin()).thenReturn((Object)this.sourceAdmin());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (!skipMetadataManagerLinkedTopicsAndReplay) {
            Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)Predef$.MODULE$.Map().empty());
            return;
        }
    }

    private boolean setupMock$default$1() {
        return false;
    }

    private void verifyMock(boolean skipMetadataManagerLinkedTopicsAndReplay) {
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).scheduler();
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).getAdmin();
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.atLeastOnce())).isLinkCoordinator(ArgumentMatchers.anyString());
        if (!skipMetadataManagerLinkedTopicsAndReplay) {
            ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.atLeastOnce())).mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any());
            return;
        }
    }

    private boolean verifyMock$default$1() {
        return false;
    }

    private ClusterLinkAutoCreateMirror mirrorTopicsAndVerify(ClusterLinkConfig clusterLinkConfig, Option<Throwable> createTopicsException, Option<Throwable> listTopicsException) {
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)clusterLinkConfig);
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), this.time(), this.quota());
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        if (createTopicsException.isDefined()) {
            Throwable ex;
            Throwable throwable = ex = createTopicsException.get() instanceof ExecutionException ? (Throwable)Option$.MODULE$.apply((Object)((Throwable)createTopicsException.get()).getCause()).getOrElse((Function0 & Serializable)() -> (Throwable)createTopicsException.get()) : (Throwable)createTopicsException.get();
            if (ex instanceof TopicExistsException) {
                Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)TopicExistsTaskErrorCode$.MODULE$, "Topic test-topic already exists on destination cluster. Will not mirror source topic."), (List)Nil$.MODULE$), (Object)taskResult.errs());
            } else if (ex instanceof AuthorizationException) {
                String string = ((AuthorizationException)ex).getMessage();
                String string2 = ClusterLinkUtils$.MODULE$.MirrorTopicCreationReadAccessErrMsg();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)AuthorizationTaskErrorCode$.MODULE$, "Unable to create topic test-topic due to authorization error. Mirror topic creation requires READ access on the source topic."), (List)Nil$.MODULE$), (Object)taskResult.errs());
                } else {
                    Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)BrokerAuthorizationTaskErrorCode$.MODULE$, "Unable to create topic test-topic due to authorization error. Please allow CREATE access on destination cluster to proceed."), (List)Nil$.MODULE$), (Object)taskResult.errs());
                }
            } else if (ex instanceof PolicyViolationException) {
                Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)PolicyViolationTaskErrorCode$.MODULE$, "Failed to create test-topic due to policy violation: Violated a policy."), (List)Nil$.MODULE$), (Object)taskResult.errs());
            } else if (ex instanceof InvalidTopicException) {
                Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InvalidTopicTaskErrorCode$.MODULE$, "Failed to create test-topic due to an invalid topic exception: Invalid topic error."), (List)Nil$.MODULE$), (Object)taskResult.errs());
            } else if (ex instanceof ExecutionException) {
                Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Unable to create topic test-topic on destination cluster."), (List)Nil$.MODULE$), (Object)taskResult.errs());
            }
        } else if (listTopicsException.isDefined()) {
            Throwable ex;
            Throwable throwable = ex = listTopicsException.get() instanceof ExecutionException ? (Throwable)Option$.MODULE$.apply((Object)((Throwable)listTopicsException.get()).getCause()).getOrElse((Function0 & Serializable)() -> (Throwable)listTopicsException.get()) : (Throwable)listTopicsException.get();
            if (ex instanceof AuthorizationException) {
                Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)AuthorizationTaskErrorCode$.MODULE$, "Unable to list topics on the source cluster. Please enable DESCRIBE ACLs on the source cluster to proceed."), (List)Nil$.MODULE$), (Object)taskResult.errs());
            } else if (ex instanceof ExecutionException) {
                Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Unable to list topics on the source cluster due to unexpected execution exception. Topics will not be mirrored."), (List)Nil$.MODULE$), (Object)taskResult.errs());
            }
        } else {
            Assertions.assertTrue((boolean)taskResult.errs().isEmpty());
        }
        this.verifyMock(false);
        return clusterLinkAutoMirroring;
    }

    private Option<Throwable> mirrorTopicsAndVerify$default$2() {
        return Option$.MODULE$.empty();
    }

    private Option<Throwable> mirrorTopicsAndVerify$default$3() {
        return Option$.MODULE$.empty();
    }

    private CreateTopicsResult mockCreateTopics(scala.collection.immutable.Map<String, Option<Throwable>> topicsToEx) {
        HashMap futures = new HashMap();
        KafkaFutureImpl allFuture = new KafkaFutureImpl();
        IntRef numExceptions = IntRef.create((int)0);
        topicsToEx.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                Option ex = (Option)x0$1._2();
                KafkaFutureImpl future = new KafkaFutureImpl();
                if (ex instanceof Some) {
                    Throwable e = (Throwable)((Some)ex).value();
                    future.completeExceptionally(e);
                    ++numExceptions$1.elem;
                } else {
                    future.complete((Object)new CreateTopicsResult.TopicMetadataAndConfig(Uuid.randomUuid(), 1, 1, new Config(Collections.emptyList())));
                }
                return (KafkaFuture)futures.put(topicName, future);
            }
            throw new MatchError(null);
        });
        if (numExceptions.elem > 0) {
            allFuture.completeExceptionally((Throwable)((Option)((Tuple2)topicsToEx.head())._2()).get());
        } else {
            allFuture.complete(null);
        }
        CreateTopicsResult result = (CreateTopicsResult)Mockito.mock(CreateTopicsResult.class);
        Mockito.when((Object)result.values()).thenReturn(futures);
        Mockito.when((Object)result.all()).thenReturn((Object)allFuture);
        return result;
    }

    private CreateTopicsResult mockCreateTopicsSameResult(Set<String> topics, Option<Throwable> ex) {
        return this.mockCreateTopics((scala.collection.immutable.Map<String, Option<Throwable>>)((IterableOnceOps)topics.map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)ex))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private Option<Throwable> mockCreateTopicsSameResult$default$2() {
        return Option$.MODULE$.empty();
    }

    private ListTopicsResult mockNoInternalListTopics(Set<String> topics, Option<Throwable> ex) {
        scala.collection.immutable.Map namesToListings = ((IterableOnceOps)topics.map((Function1 & Serializable)topicName -> new Tuple2(topicName, (Object)new TopicListing(topicName, Uuid.ZERO_UUID, false)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return this.mockListTopics((scala.collection.immutable.Map<String, TopicListing>)namesToListings, ex);
    }

    private Option<Throwable> mockNoInternalListTopics$default$2() {
        return Option$.MODULE$.empty();
    }

    private ListTopicsResult mockListTopics(scala.collection.immutable.Map<String, TopicListing> namesToListings, Option<Throwable> ex) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (ex instanceof Some) {
            Throwable e = (Throwable)((Some)ex).value();
            future.completeExceptionally(e);
        } else {
            future.complete((Object)CollectionConverters$.MODULE$.MapHasAsJava(namesToListings).asJava());
        }
        ListTopicsResult result = (ListTopicsResult)Mockito.mock(ListTopicsResult.class);
        Mockito.when((Object)result.namesToListings()).thenReturn((Object)future);
        KafkaFutureImpl namesFuture = new KafkaFutureImpl();
        namesFuture.complete(CollectionConverters$.MODULE$.MapHasAsJava(namesToListings).asJava().keySet());
        Mockito.when((Object)result.names()).thenReturn((Object)namesFuture);
        return result;
    }

    private Option<Throwable> mockListTopics$default$2() {
        return Option$.MODULE$.empty();
    }

    private ListMirrorsResult mockListMirrors() {
        return this.mockListMirrors((Set<String>)((Set)Set$.MODULE$.empty()));
    }

    private ListMirrorsResult mockListMirrors(Set<String> topics) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)CollectionConverters$.MODULE$.MutableSetHasAsJava(topics).asJava());
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        return result;
    }

    private ClusterLinkConfig config(String topicFilter) {
        return ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)topicFilter)}))).asJava(), (Option)None$.MODULE$, true);
    }

    private void testMirrorTopics(Set<String> sourceTopics, Set<String> sourceMirrorTopics, Set<String> destTopics, Set<String> expectedMirrors, ClusterLinkConfig config) {
        this.setupMock(true);
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        destTopics.foreach((Function1 & Serializable)destTopic -> {
            ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror(destTopic, this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
            return (ClusterLinkTopicState)linkedTopics.put(destTopic, testActiveTopicState);
        });
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics(sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors(sourceMirrorTopics);
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala());
        int numCreateTopicsCall = 0;
        if (expectedMirrors.nonEmpty()) {
            java.util.List mockCreateTopicsResultList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)expectedMirrors.grouped(ClusterLinkAutoCreateMirror$.MODULE$.CREATE_TOPICS_BATCH_SIZE()).map((Function1 & Serializable)batch -> this.mockCreateTopicsSameResult((Set<String>)batch, (Option<Throwable>)Option$.MODULE$.empty())).toList()).asJava();
            Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenAnswer(AdditionalAnswers.returnsElementsOf((Collection)mockCreateTopicsResultList));
            numCreateTopicsCall = mockCreateTopicsResultList.size();
        }
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = this.mirrorTopicsAndVerify(config, (Option<Throwable>)Option$.MODULE$.empty(), (Option<Throwable>)Option$.MODULE$.empty());
        Assertions.assertEquals(expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        if (expectedMirrors.nonEmpty()) {
            ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)numCreateTopicsCall))).createTopics((Collection)ArgumentMatchers.any());
            return;
        }
    }

    private void testMirrorTopics(Set<String> sourceTopics, Set<String> destTopics, Set<String> expectedMirrors, String filter) {
        this.testMirrorTopics(sourceTopics, (Set<String>)((Set)Set$.MODULE$.empty()), destTopics, expectedMirrors, this.config(filter));
    }

    private void testMirrorTopicsException(Option<Throwable> createTopicsException, Option<Throwable> listTopicsException) {
        this.setupMock(false);
        Set sampleSet = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set emptySet = (Set)Set$.MODULE$.empty();
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sampleSet, listTopicsException);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult mockCreateTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sampleSet, createTopicsException);
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)mockCreateTopicsResult);
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = this.mirrorTopicsAndVerify(this.config(this.includeAllFilter()), createTopicsException, listTopicsException);
        Assertions.assertEquals((Object)emptySet, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).listTopics();
    }

    private Option<Throwable> testMirrorTopicsException$default$1() {
        return Option$.MODULE$.empty();
    }

    private Option<Throwable> testMirrorTopicsException$default$2() {
        return Option$.MODULE$.empty();
    }

    @Test
    public void testMirrorOneTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, this.includeAllFilter());
    }

    @Test
    public void testNoCreateTopicsIfTopicExists() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set destTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set expectedMirrors = (Set)Set$.MODULE$.empty();
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, this.includeAllFilter());
    }

    @Test
    public void testCreateTopicsWithPrefix() {
        String prefix = "prefix-";
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        Set sourceMirrorTopics = (Set)Set$.MODULE$.empty();
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        ClusterLinkConfig clConfig = ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllFilter()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)prefix)}))).asJava(), (Option)None$.MODULE$, true);
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)sourceMirrorTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, clConfig);
    }

    @Test
    public void testNoCreateTopicsIfTopicIsMirror() {
        String prefix = "prefix-";
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        Set sourceMirrorTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.empty();
        ClusterLinkConfig clConfig = ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllFilter()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)prefix)}))).asJava(), (Option)None$.MODULE$, true);
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)sourceMirrorTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, clConfig);
    }

    @Test
    public void testInitialize() {
        String prefix = "prefix-";
        Set sourceTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.empty();
        ClusterLinkConfig clConfig = ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllFilter()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)prefix)}))).asJava(), (Option)None$.MODULE$, true);
        this.setupMock(true);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException("The broker does not support LIST_MIRRORS"));
        ListMirrorsResult listMirrorsResult = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)listMirrorsResult.result()).thenReturn((Object)future);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala());
        int numCreateTopicsCall = 0;
        if (expectedMirrors.nonEmpty()) {
            java.util.List mockCreateTopicsResultList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)expectedMirrors.grouped(ClusterLinkAutoCreateMirror$.MODULE$.CREATE_TOPICS_BATCH_SIZE()).map((Function1 & Serializable)batch -> this.mockCreateTopicsSameResult((Set<String>)batch, (Option<Throwable>)Option$.MODULE$.empty())).toList()).asJava();
            Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenAnswer(AdditionalAnswers.returnsElementsOf((Collection)mockCreateTopicsResultList));
            numCreateTopicsCall = mockCreateTopicsResultList.size();
        }
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)clConfig);
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), this.time(), this.quota());
        Assertions.assertFalse((boolean)clusterLinkAutoMirroring.getInitialized());
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        Assertions.assertTrue((boolean)taskResult.errs().isEmpty());
        Assertions.assertTrue((boolean)clusterLinkAutoMirroring.getInitialized());
        ClusterLinkScheduler.TaskResult taskResultTwo = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResultTwo.completed());
        Assertions.assertTrue((boolean)taskResultTwo.errs().isEmpty());
        Assertions.assertTrue((boolean)clusterLinkAutoMirroring.getInitialized());
        this.verifyMock(true);
        ((ListMirrorsResult)Mockito.verify((Object)listMirrorsResult)).result();
        ((ConfluentAdmin)Mockito.verify((Object)this.sourceAdmin())).listMirrors((ListMirrorsOptions)ArgumentMatchers.any());
        if (expectedMirrors.nonEmpty()) {
            ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)numCreateTopicsCall))).createTopics((Collection)ArgumentMatchers.any());
            return;
        }
    }

    @Test
    public void testMirrorOneTopicFromAkCluster() {
        String prefix = "prefix-";
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        ClusterLinkConfig clConfig = ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllFilter()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)prefix)}))).asJava(), (Option)None$.MODULE$, true);
        this.setupMock(true);
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        destTopics.foreach((Function1 & Serializable)destTopic -> {
            ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror(destTopic, this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
            return (ClusterLinkTopicState)linkedTopics.put(destTopic, testActiveTopicState);
        });
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException("The broker does not support LIST_MIRRORS"));
        ListMirrorsResult listMirrorsResult = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)listMirrorsResult.result()).thenReturn((Object)future);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala());
        int numCreateTopicsCall = 0;
        if (expectedMirrors.nonEmpty()) {
            java.util.List mockCreateTopicsResultList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)expectedMirrors.grouped(ClusterLinkAutoCreateMirror$.MODULE$.CREATE_TOPICS_BATCH_SIZE()).map((Function1 & Serializable)batch -> this.mockCreateTopicsSameResult((Set<String>)batch, (Option<Throwable>)Option$.MODULE$.empty())).toList()).asJava();
            Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenAnswer(AdditionalAnswers.returnsElementsOf((Collection)mockCreateTopicsResultList));
            numCreateTopicsCall = mockCreateTopicsResultList.size();
        }
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = this.mirrorTopicsAndVerify(clConfig, (Option<Throwable>)Option$.MODULE$.empty(), (Option<Throwable>)Option$.MODULE$.empty());
        Assertions.assertEquals((Object)expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        ((ListMirrorsResult)Mockito.verify((Object)listMirrorsResult)).result();
        ((ConfluentAdmin)Mockito.verify((Object)this.sourceAdmin())).listMirrors((ListMirrorsOptions)ArgumentMatchers.any());
        if (expectedMirrors.nonEmpty()) {
            ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)numCreateTopicsCall))).createTopics((Collection)ArgumentMatchers.any());
            return;
        }
    }

    @Test
    public void testIncludeLiteralFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"include-topic\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testIncludePrefixedFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"include\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testExcludeLiteralFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"},{\"name\":\"exclude-topic\",\"filterType\":\"EXCLUDE\",\"patternType\":\"LITERAL\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testExcludePrefixedFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"},{\"name\":\"exclude\",\"filterType\":\"EXCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testBatchMirroring() {
        Set sourceTopics = (Set)Set$.MODULE$.empty();
        int numTopicsToCreate = ClusterLinkAutoCreateMirror$.MODULE$.CREATE_TOPICS_BATCH_SIZE() / 2 + ClusterLinkAutoCreateMirror$.MODULE$.CREATE_TOPICS_BATCH_SIZE() * 2;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), numTopicsToCreate).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> sourceTopics.add((Object)new StringBuilder(6).append("topic-").append(i).toString()));
        Set destTopics = (Set)Set$.MODULE$.empty();
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)sourceTopics, this.includeAllFilter());
    }

    @Test
    public void testListTopicsAuthException() {
        Option<Throwable> x$1 = this.authorizationException();
        Option x$2 = Option$.MODULE$.empty();
        this.testMirrorTopicsException((Option<Throwable>)x$2, x$1);
    }

    @Test
    public void testListTopicsExecutionException() {
        Option<Throwable> x$1 = this.executionException();
        Option x$2 = Option$.MODULE$.empty();
        this.testMirrorTopicsException((Option<Throwable>)x$2, x$1);
    }

    @Test
    public void testCreateTopicsExecutionException() {
        this.testMirrorTopicsException(this.executionException(), (Option<Throwable>)Option$.MODULE$.empty());
    }

    @Test
    public void testCreateTopicsAuthException() {
        this.testMirrorTopicsException(this.authorizationException(), (Option<Throwable>)Option$.MODULE$.empty());
    }

    @Test
    public void testCreateTopicsCustomerAuthException() {
        this.testMirrorTopicsException((Option<Throwable>)new Some((Object)new TopicAuthorizationException(ClusterLinkUtils$.MODULE$.MirrorTopicCreationReadAccessErrMsg())), (Option<Throwable>)Option$.MODULE$.empty());
    }

    @Test
    public void testCreateTopicsPolicyViolationException() {
        this.testMirrorTopicsException(this.policyViolationException(), (Option<Throwable>)Option$.MODULE$.empty());
    }

    @Test
    public void testCreateTopicsExistsException() {
        this.testMirrorTopicsException(this.topicExistsException(), (Option<Throwable>)Option$.MODULE$.empty());
    }

    @Test
    public void testCreateInvalidTopicException() {
        this.testMirrorTopicsException(this.invalidTopicException(), (Option<Throwable>)Option$.MODULE$.empty());
    }

    @Test
    public void testDestListTopicsException() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        this.setupMock(false);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.topicExistsException());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult);
        listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, this.authorizationException());
        Mockito.when((Object)this.destAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), this.time(), this.quota());
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)TopicExistsTaskErrorCode$.MODULE$, "Topic test-topic already exists on destination cluster. Will not mirror source topic."), (List)Nil$.MODULE$), (Object)taskResult.errs());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        ClusterLinkScheduler.TaskResult taskResultTwo = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResultTwo.completed());
        Assertions.assertTrue((boolean)taskResultTwo.errs().isEmpty());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.destAdmin())).createTopics((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin())).listTopics();
    }

    @Test
    public void testRemirrorDeletedDestTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        this.setupMock(false);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), this.time(), this.quota());
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        Assertions.assertTrue((boolean)taskResult.errs().isEmpty());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        ClusterLinkScheduler.TaskResult taskResultTwo = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResultTwo.completed());
        Assertions.assertTrue((boolean)taskResultTwo.errs().isEmpty());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
    }

    @Test
    public void testMirrorNewSourceTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set sourceTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic", "test-topic-2"}));
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        ConcurrentHashMap<String, ClusterLinkTopicState.Mirror> linkedTopicsNew = new ConcurrentHashMap<String, ClusterLinkTopicState.Mirror>();
        ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror("test-topic", this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        linkedTopicsNew.put("test-topic", testActiveTopicState);
        this.setupMock(true);
        ListTopicsResult mockSourceTopicsList = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListTopicsResult mockSourceTopicsNewList = this.mockNoInternalListTopics((Set<String>)sourceTopicsNew, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)mockSourceTopicsList).thenReturn((Object)mockSourceTopicsNewList);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala()).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopicsNew).asScala());
        CreateTopicsResult mockSourceCreateTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        CreateTopicsResult mockTestTopics2Result = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-2"}))), (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)mockSourceCreateTopicsResult).thenReturn((Object)mockTestTopics2Result);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), this.time(), this.quota());
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        Assertions.assertTrue((boolean)taskResult.errs().isEmpty());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        ClusterLinkScheduler.TaskResult taskResultTwo = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResultTwo.completed());
        Assertions.assertTrue((boolean)taskResultTwo.errs().isEmpty());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-2"})), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(true);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
    }

    @Test
    public void testAddIncludeFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"old-topic", "new-topic"}));
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        ConcurrentHashMap<String, ClusterLinkTopicState.Mirror> linkedTopicsNew = new ConcurrentHashMap<String, ClusterLinkTopicState.Mirror>();
        ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror("old-topic", this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        linkedTopicsNew.put("old-topic", testActiveTopicState);
        Set destTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"old-topic"}));
        String filterOne = "{\"topicFilters\":[{\"name\":\"old\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        String filterTwo = "{\"topicFilters\":[{\"name\":\"old\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"},{\"name\":\"new\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.setupMock(true);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala()).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopicsNew).asScala());
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"old-topic"}))), (Option<Throwable>)Option$.MODULE$.empty());
        CreateTopicsResult newCreateTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"new-topic"}))), (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult).thenReturn((Object)newCreateTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(filterOne)).thenReturn((Object)this.config(filterTwo));
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), this.time(), this.quota());
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        Assertions.assertTrue((boolean)taskResult.errs().isEmpty());
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        ClusterLinkScheduler.TaskResult taskResultTwo = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResultTwo.completed());
        Assertions.assertTrue((boolean)taskResultTwo.errs().isEmpty());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"new-topic"})), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(true);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)4))).currentConfig();
    }

    @Test
    public void testDeleteExcludeFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filterOne = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"},{\"name\":\"exclude\",\"filterType\":\"EXCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        String filterTwo = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"}]}";
        this.setupMock(false);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        CreateTopicsResult mockIncludeTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}))), (Option<Throwable>)Option$.MODULE$.empty());
        CreateTopicsResult mockExcludeTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"exclude-topic"}))), (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)mockIncludeTopicsResult).thenReturn((Object)mockExcludeTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(filterOne)).thenReturn((Object)this.config(filterTwo));
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), this.time(), this.quota());
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        Assertions.assertTrue((boolean)taskResult.errs().isEmpty());
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        ClusterLinkScheduler.TaskResult taskResultTwo = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResultTwo.completed());
        Assertions.assertTrue((boolean)taskResultTwo.errs().isEmpty());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"exclude-topic"})), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)4))).currentConfig();
    }

    @Test
    public void testDeleteIncludeFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2"}));
        Set sourceTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2", "test-topic-3"}));
        Set destTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2"}));
        String filterOne = "{\"topicFilters\":[{\"name\":\"test\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"},{\"name\":\"include\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        String filterTwo = "{\"topicFilters\":[{\"name\":\"include\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.setupMock(true);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListTopicsResult listTopicsNewResult = this.mockNoInternalListTopics((Set<String>)sourceTopicsNew, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult, (Object[])new ListTopicsResult[]{listTopicsNewResult});
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2"}))), (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(filterOne), (Object[])new ClusterLinkConfig[]{this.config(filterOne), this.config(filterTwo), this.config(filterTwo)});
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        destTopicsNew.foreach((Function1 & Serializable)destTopic -> {
            ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror(destTopic, this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
            return (ClusterLinkTopicState)linkedTopics.put(destTopic, testActiveTopicState);
        });
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)Predef$.MODULE$.Map().empty()).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala());
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), this.time(), this.quota());
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        Assertions.assertTrue((boolean)taskResult.errs().isEmpty());
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        ClusterLinkScheduler.TaskResult taskResultTwo = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResultTwo.completed());
        Assertions.assertTrue((boolean)taskResultTwo.errs().isEmpty());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin())).createTopics((Collection)ArgumentMatchers.any());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)4))).currentConfig();
    }

    @Test
    public void testNoDuplicateCreateTopicsCallForExistingTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set nonMirrorDestTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set expectedMirrors = (Set)Set$.MODULE$.empty();
        this.setupMock(false);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.topicExistsException());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult);
        ListTopicsResult listDestTopicsResult = this.mockNoInternalListTopics((Set<String>)nonMirrorDestTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().listTopics()).thenReturn((Object)listDestTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), this.time(), this.quota());
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)TopicExistsTaskErrorCode$.MODULE$, "Topic test-topic already exists on destination cluster. Will not mirror source topic."), (List)Nil$.MODULE$), (Object)taskResult.errs());
        Assertions.assertEquals((Object)expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        ClusterLinkScheduler.TaskResult taskResultTwo = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResultTwo.completed());
        Assertions.assertTrue((boolean)taskResultTwo.errs().isEmpty());
        Assertions.assertEquals((Object)expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.destAdmin())).listTopics();
    }

    @Test
    public void testTopicCanBeCreatedAfterConflictingTopicDeletion() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set nonMirrorDestTopics = (Set)Set$.MODULE$.empty();
        this.setupMock(false);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResultTopicExists = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.topicExistsException());
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResultTopicExists).thenReturn((Object)createTopicsResult);
        ListTopicsResult nonMirrorDestTopicsResult = this.mockNoInternalListTopics((Set<String>)nonMirrorDestTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().listTopics()).thenReturn((Object)nonMirrorDestTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), this.time(), this.quota());
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)TopicExistsTaskErrorCode$.MODULE$, "Topic test-topic already exists on destination cluster. Will not mirror source topic."), (List)Nil$.MODULE$), (Object)taskResult.errs());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        ClusterLinkScheduler.TaskResult taskResultTwo = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResultTwo.completed());
        Assertions.assertTrue((boolean)taskResultTwo.errs().isEmpty());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin())).listTopics();
    }

    @Test
    public void testNoCreateTopicsCallForInternalTopic() {
        TopicListing internalTopic = new TopicListing("_mock_internal_topic", Uuid.ZERO_UUID, true);
        this.verifyNoCreateTopicsForInternalOrConfluentTopics(internalTopic);
    }

    @Test
    public void testNoCreateTopicsCallForConfluentTopic() {
        TopicListing confluentTopic = new TopicListing("_confluent-metadata-auth", Uuid.ZERO_UUID, false);
        this.verifyNoCreateTopicsForInternalOrConfluentTopics(confluentTopic);
    }

    private void verifyNoCreateTopicsForInternalOrConfluentTopics(TopicListing topicListing) {
        this.setupMock(false);
        ListTopicsResult mockListTopicsResult = this.mockListTopics((scala.collection.immutable.Map<String, TopicListing>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicListing.name()), (Object)topicListing)}))), (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)mockListTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), this.time(), this.quota()).runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        Assertions.assertTrue((boolean)taskResult.errs().isEmpty());
        this.verifyMock(false);
    }

    @Test
    public void testConflictingDestCacheValues() {
        Set sourceTopicsOld = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1"}));
        Set sourceTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1", "test-topic-2"}));
        Set destTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-2"}));
        this.setupMock(false);
        ListTopicsResult listOldTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopicsOld, (Option<Throwable>)Option$.MODULE$.empty());
        ListTopicsResult listNewTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopicsNew, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listOldTopicsResult).thenReturn((Object)listNewTopicsResult);
        ListMirrorsResult mirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)mirrorsResult);
        ListTopicsResult listDestTopicsResult = this.mockNoInternalListTopics((Set<String>)destTopicsNew, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().listTopics()).thenReturn((Object)listDestTopicsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopicsOld, this.topicExistsException());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult).thenReturn((Object)this.mockCreateTopics((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-2"), this.topicExistsException()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-1"), (Object)Option$.MODULE$.empty())})))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), this.time(), this.quota());
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)TopicExistsTaskErrorCode$.MODULE$, "Topic test-topic-1 already exists on destination cluster. Will not mirror source topic."), (List)Nil$.MODULE$), (Object)taskResult.errs());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopicsOld, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        Assertions.assertTrue((boolean)((ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS)).completed());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)TopicExistsTaskErrorCode$.MODULE$, "Topic test-topic-1 already exists on destination cluster. Will not mirror source topic."), (List)Nil$.MODULE$), (Object)taskResult.errs());
        Assertions.assertEquals((Object)sourceTopicsOld, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin())).listTopics();
    }

    @Test
    public void testNoCreateTopicWithInactiveMirrorTopics() {
        this.resetMock();
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().getAdmin()).thenReturn((Object)this.sourceAdmin());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror("testLink", this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        ClusterLinkTopicState.PendingStoppedMirror testPendingStopTopicState = new ClusterLinkTopicState.PendingStoppedMirror("testLink", this.linkId(), this.sourceTopicId(), false, Time.SYSTEM.milliseconds());
        ClusterLinkTopicState.FailedMirror testFailedTopicState = new ClusterLinkTopicState.FailedMirror("testLink", this.linkId(), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, Time.SYSTEM.milliseconds());
        ClusterLinkTopicState.StoppedMirror testStoppedTopicState = new ClusterLinkTopicState.StoppedMirror("testLink", this.linkId(), this.sourceTopicId(), (Seq)package$.MODULE$.Seq().empty(), Time.SYSTEM.milliseconds());
        ClusterLinkTopicState.PausedMirror testPausedTopicState = new ClusterLinkTopicState.PausedMirror("testLink", this.linkId(), this.sourceTopicId(), false, true, (TopicLinkState)TopicLinkMirror$.MODULE$, null, MirrorTopicError.NO_ERROR, Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        ConcurrentHashMap<String, Object> linkedTopics = new ConcurrentHashMap<String, Object>();
        linkedTopics.put("testTopic", testActiveTopicState);
        linkedTopics.put("testTopicPendingStopped", testPendingStopTopicState);
        linkedTopics.put("testTopicFailed", testFailedTopicState);
        linkedTopics.put("testTopicPaused", testPausedTopicState);
        linkedTopics.put("testTopicStopped", testStoppedTopicState);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(linkedTopics.keySet()).asScala(), (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoCreateMirror clusterLinkAutoMirroring = new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), this.time(), this.quota());
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        Assertions.assertTrue((boolean)taskResult.errs().isEmpty());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
    }

    @Test
    public void testMultipleWritersMergeTopicsToCreate() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1"}));
        String outOfBandTopic = "test-topic-2";
        Set expectedTopicsAtEnd = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1", "test-topic-2"}));
        this.setupMock(true);
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(node);
        mockAdminClient.addTopicOutOfBand(outOfBandTopic);
        Assertions.assertEquals((Object)scala.collection.immutable.Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{outOfBandTopic})), mockAdminClient.topics());
        ClusterLinkScheduler.TaskResult taskResult = (ClusterLinkScheduler.TaskResult)new ClusterLinkAutoCreateMirror(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> mockAdminClient, this.metrics(), this.time(), this.quota()).runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)taskResult.completed());
        Assertions.assertTrue((boolean)taskResult.errs().isEmpty());
        this.verifyMock(false);
        Assertions.assertEquals((Object)expectedTopicsAtEnd, mockAdminClient.topics());
        Assertions.assertFalse((boolean)mockAdminClient.deleteCalled());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSourceClusterCanContainMirrorTopicsReturnsFalse() {
        void var5_5;
        void var4_4;
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException("The broker does not support LIST_MIRRORS"));
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Tuple2 tuple2 = SourceCluster$.MODULE$.canContainMirrorTopics(this.metrics(), result.result());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean shouldFilter = tuple2._1$mcZ$sp();
        Option errOpt = (Option)tuple2._2();
        Assertions.assertFalse((boolean)var4_4);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)var5_5);
        ((ListMirrorsResult)Mockito.verify((Object)result)).result();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSourceClusterCanContainMirrorTopicsReturnsErrDueAuthorization() {
        void var5_5;
        void var4_4;
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new ClusterAuthorizationException("Not authorized"));
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Tuple2 tuple2 = SourceCluster$.MODULE$.canContainMirrorTopics(this.metrics(), result.result());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean shouldFilter = tuple2._1$mcZ$sp();
        Option errOpt = (Option)tuple2._2();
        Assertions.assertFalse((boolean)var4_4);
        Assertions.assertEquals((Object)new Some((Object)new TaskErrorCodeAndMsg((TaskErrorCode)AuthorizationTaskErrorCode$.MODULE$, "Unable to list mirrors on the source cluster. Please enable Describe:Cluster ACLs on the source cluster to proceed. org.apache.kafka.common.errors.ClusterAuthorizationException: Not authorized")), (Object)var5_5);
        ((ListMirrorsResult)Mockito.verify((Object)result)).result();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSourceClusterCanContainMirrorTopicsReturnsTrueDueToWrongErrorMessage() {
        void var5_5;
        void var4_4;
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException("The broker does not support LIST_MIRRORS with version..."));
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Tuple2 tuple2 = SourceCluster$.MODULE$.canContainMirrorTopics(this.metrics(), result.result());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean shouldFilter = tuple2._1$mcZ$sp();
        Option errOpt = (Option)tuple2._2();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)var5_5);
        ((ListMirrorsResult)Mockito.verify((Object)result)).result();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSourceClusterCanContainMirrorTopicsBasicClusterReturnsFalse() {
        void var5_5;
        void var4_4;
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new ClusterLinkDisabledException("Cluster linking is disabled"));
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Tuple2 tuple2 = SourceCluster$.MODULE$.canContainMirrorTopics(this.metrics(), result.result());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean shouldFilter = tuple2._1$mcZ$sp();
        Option errOpt = (Option)tuple2._2();
        Assertions.assertFalse((boolean)var4_4);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)var5_5);
        ((ListMirrorsResult)Mockito.verify((Object)result)).result();
    }

    @Test
    public void testFilterTopic() {
        new .colon.colon((Object)"", (List)new .colon.colon((Object)"src_", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)prefix -> {
            ClusterLinkAutoCreateMirrorTest.$anonfun$testFilterTopic$1(prefix);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testFilterTopic$1(String prefix) {
        String topic = new StringBuilder(5).append(prefix).append("topic").toString();
        String confluentBalancerApiStateTopic = new StringBuilder(29).append(prefix).append("_confluent_balancer_api_state").toString();
        String schemaTopic = new StringBuilder(8).append(prefix).append("_schemas").toString();
        String auditLogEventsTopic = new StringBuilder(26).append(prefix).append("confluent-audit-log-events").toString();
        String ksqlProcessingLogEventsTopic = new StringBuilder(27).append(prefix).append("pksqlc-10j25-processing-log").toString();
        String fakeKsqlProcessingLogEventsTopic1 = new StringBuilder(14).append(prefix).append("pksqlc-a10nvvs").toString();
        String fakeKsqlProcessingLogEventsTopic2 = new StringBuilder(21).append(prefix).append("pksqlc-processing-log").toString();
        String fakeKsqlProcessingLogEventsTopic3 = new StringBuilder(12).append(prefix).append("mzxkn21l-log").toString();
        scala.collection.mutable.Map namesToListings = (scala.collection.mutable.Map)Map$.MODULE$.apply(((IterableOnceOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new TopicListing(topic, Uuid.fromString((String)"2Ew1y9BsQYCP6WVAzdKwPw"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)schemaTopic), (Object)new TopicListing(schemaTopic, Uuid.fromString((String)"2Ew1y9BsQYCP6WVAzdKwPw"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)auditLogEventsTopic), (Object)new TopicListing(auditLogEventsTopic, Uuid.fromString((String)"3ww2z11a0ABC7AAAzdzw0w"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)confluentBalancerApiStateTopic), (Object)new TopicListing(confluentBalancerApiStateTopic, Uuid.fromString((String)"QOtODWOVSnufqbbXBMqitw"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ksqlProcessingLogEventsTopic), (Object)new TopicListing(confluentBalancerApiStateTopic, Uuid.fromString((String)"U2U10zesDuLtb0lW1zOJxA"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fakeKsqlProcessingLogEventsTopic1), (Object)new TopicListing(confluentBalancerApiStateTopic, Uuid.fromString((String)"kK5sMF0pRQzrv0xPCJNaBH"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fakeKsqlProcessingLogEventsTopic2), (Object)new TopicListing(confluentBalancerApiStateTopic, Uuid.fromString((String)"kybFGBW7BfwmX3Dc9zAay5"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fakeKsqlProcessingLogEventsTopic3), (Object)new TopicListing(confluentBalancerApiStateTopic, Uuid.fromString((String)"KBiRtzOcFvYOKrKSrQ9k5Z"), false))}))).toSeq());
        Assertions.assertFalse((boolean)ClusterLinkAutoCreateMirror$.MODULE$.filterTopic(namesToListings, prefix.length(), topic));
        Assertions.assertTrue((boolean)ClusterLinkAutoCreateMirror$.MODULE$.filterTopic(namesToListings, prefix.length(), confluentBalancerApiStateTopic));
        Assertions.assertTrue((boolean)ClusterLinkAutoCreateMirror$.MODULE$.filterTopic(namesToListings, prefix.length(), schemaTopic));
        Assertions.assertTrue((boolean)ClusterLinkAutoCreateMirror$.MODULE$.filterTopic(namesToListings, prefix.length(), auditLogEventsTopic));
        Assertions.assertTrue((boolean)ClusterLinkAutoCreateMirror$.MODULE$.filterTopic(namesToListings, prefix.length(), ksqlProcessingLogEventsTopic));
        Assertions.assertFalse((boolean)ClusterLinkAutoCreateMirror$.MODULE$.filterTopic(namesToListings, prefix.length(), fakeKsqlProcessingLogEventsTopic1));
        Assertions.assertFalse((boolean)ClusterLinkAutoCreateMirror$.MODULE$.filterTopic(namesToListings, prefix.length(), fakeKsqlProcessingLogEventsTopic2));
        Assertions.assertFalse((boolean)ClusterLinkAutoCreateMirror$.MODULE$.filterTopic(namesToListings, prefix.length(), fakeKsqlProcessingLogEventsTopic3));
    }

    public ClusterLinkAutoCreateMirrorTest() {
        this.includeAllFilter = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"}]}";
    }

    public class TestAdminClient
    extends MockAdminClient {
        private scala.collection.immutable.Set<String> topics;
        private boolean deleteCalled;

        public scala.collection.immutable.Set<String> topics() {
            return this.topics;
        }

        public void topics_$eq(scala.collection.immutable.Set<String> x$1) {
            this.topics = x$1;
        }

        public boolean deleteCalled() {
            return this.deleteCalled;
        }

        public void deleteCalled_$eq(boolean x$1) {
            this.deleteCalled = x$1;
        }

        public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
            scala.collection.immutable.Map results = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(newTopics).asScala().map((Function1 & Serializable)newTopic -> {
                KafkaFutureImpl future = new KafkaFutureImpl();
                if (this.topics().contains((Object)newTopic.name())) {
                    future.completeExceptionally((Throwable)new TopicExistsException("Topic already exists"));
                } else {
                    this.topics_$eq((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)this.topics().$plus((Object)newTopic.name())));
                    future.complete(null);
                }
                return new Tuple2((Object)newTopic.name(), (Object)future);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            CreateTopicsResult result = (CreateTopicsResult)Mockito.mock(CreateTopicsResult.class);
            Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)results).asJava());
            Mockito.when((Object)result.all()).thenReturn((Object)KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{(KafkaFuture)results.values().head()}));
            return result;
        }

        public DeleteTopicsResult deleteTopics(Collection<String> topics) {
            this.deleteCalled_$eq(true);
            topics.forEach(x -> topics.remove(x));
            return (DeleteTopicsResult)Mockito.mock(DeleteTopicsResult.class);
        }

        public void addTopicOutOfBand(String topic) {
            this.topics_$eq((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)this.topics().$plus((Object)topic)));
        }

        public /* synthetic */ ClusterLinkAutoCreateMirrorTest kafka$server$link$ClusterLinkAutoCreateMirrorTest$TestAdminClient$$$outer() {
            return ClusterLinkAutoCreateMirrorTest.this;
        }

        public TestAdminClient(Node node) {
            if (ClusterLinkAutoCreateMirrorTest.this == null) {
                throw null;
            }
            super(Collections.singletonList(node), node);
            this.topics = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            this.deleteCalled = false;
        }
    }
}

