/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkCCloudToCCloudChannelBuilder;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00154A\u0001D\u0007\u0001)!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0001A!)\u0011\u0007\u0001C\u0005e!)1\t\u0001C\u0001A!)Q\t\u0001C\u0005\r\")\u0001\u000b\u0001C\u0005#\")1\f\u0001C\u0001A!)Q\f\u0001C\u0005=\")\u0011\r\u0001C\u0005E\")1\r\u0001C\u0005E\")A\r\u0001C\u0005E\nY3\t\\;ti\u0016\u0014H*\u001b8l\u0007\u000ecw.\u001e3U_\u000e\u001bEn\\;e\u0007\"\fgN\\3m\u0005VLG\u000eZ3s)\u0016\u001cHO\u0003\u0002\u000f\u001f\u0005!A.\u001b8l\u0015\t\u0001\u0012#\u0001\u0004tKJ4XM\u001d\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011!D\u0001.i\u0016\u001cH/T1zE\u0016\fE\r\u001a(fi^|'o[%e)\u0006<7oU1tY\"\u000bg\u000eZ:iC.,'+Z9vKN$H#A\u0011\u0011\u0005Y\u0011\u0013BA\u0012\u0018\u0005\u0011)f.\u001b;)\u0005\t)\u0003C\u0001\u00140\u001b\u00059#B\u0001\u0015*\u0003\r\t\u0007/\u001b\u0006\u0003U-\nqA[;qSR,'O\u0003\u0002-[\u0005)!.\u001e8ji*\ta&A\u0002pe\u001eL!\u0001M\u0014\u0003\tQ+7\u000f^\u0001\u0015O\u0016$8\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0015\u0005M2\u0004C\u0001\u00105\u0013\t)TBA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001eDQaN\u0002A\u0002a\n\u0001CY8piN$(/\u00199TKJ4XM]:\u0011\u0005e\u0002eB\u0001\u001e?!\tYt#D\u0001=\u0015\ti4#\u0001\u0004=e>|GOP\u0005\u0003\u007f]\ta\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011qhF\u00011i\u0016\u001cH/T1zE\u0016\fE\r\u001a(fi^|'o[%e)\u0006<7oU1tY\u0006+H\u000f[3oi&\u001c\u0017\r^3SKF,Xm\u001d;)\u0005\u0011)\u0013aD4fi\n\u0013xn[3s\u0007>tg-[4\u0015\u0005\u001d[\u0005C\u0001%J\u001b\u0005y\u0011B\u0001&\u0010\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000b1+\u0001\u0019A'\u0002\u00139,Go^8sW&#\u0007c\u0001\fOq%\u0011qj\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001d\u001d,GO\u0011:pW\u0016\u0014\bK]8qgR\u0011!K\u0017\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000bA!\u001e;jY*\tq+\u0001\u0003kCZ\f\u0017BA-U\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0006\u0019\u001a\u0001\r!T\u0001,i\u0016\u001cHoQ8oM&<7o\u0014<feJLG-Z:XSRDW\n\u00167t+NLgnZ*feZ,'oQ3si\"\u0012q!J\u0001%GJ,\u0017\r^3Ce>\\WM]!oI2K7\u000f^3oKJ\u001cuN\u001c4jO^KG\u000f[*tYR\u0011!k\u0018\u0005\u0006A\"\u0001\rAU\u0001\u000eY&\u001cH/\u001a8feB\u0013x\u000e]:\u0002!\u001d,G\u000fT5ti\u0016tWM\u001d)s_B\u001cX#\u0001*\u00023\r\u0014X-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ,ji\"\u001c6\u000f\\\u0001\u0013GJ,\u0017\r^3Ce>\\WM]\"p]\u001aLw\r")
public class ClusterLinkCCloudToCCloudChannelBuilderTest {
    @Test
    public void testMaybeAddNetworkIdTagsSaslHandshakeRequest() {
        ClusterLinkConfig linkConfig = this.getClusterLinkConfig("foo.bar.us-west2.aws.confluent.cloud:9003");
        SaslHandshakeRequestData requestData = new SaslHandshakeRequestData().setMechanism("PLAIN");
        SaslHandshakeRequest request = (SaslHandshakeRequest)new SaslHandshakeRequest.Builder(requestData).build();
        new ClusterLinkCCloudToCCloudChannelBuilder(this.getBrokerConfig((Option<String>)new Some((Object)"nr1")), linkConfig).maybeAddNetworkIdTags((AbstractRequest)request);
        Assertions.assertTrue((boolean)requestData.unknownTaggedFields().isEmpty());
    }

    private ClusterLinkConfig getClusterLinkConfig(String bootstrapServers) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServers);
        return ClusterLinkConfig$.MODULE$.create((Map)properties, (Option)None$.MODULE$, false);
    }

    @Test
    public void testMaybeAddNetworkIdTagsSaslAuthenticateRequest() {
        String bootstrapServers = "foo.bar.us-west2.aws.confluent.cloud:9003";
        Some networkId = new Some((Object)"nr1");
        ClusterLinkConfig linkConfig = this.getClusterLinkConfig(bootstrapServers);
        KafkaConfig brokerConfig = this.getBrokerConfig((Option<String>)networkId);
        SaslAuthenticateRequestData data = new SaslAuthenticateRequestData();
        SaslAuthenticateRequest request = new SaslAuthenticateRequest.Builder(data).build((short)2);
        Assertions.assertNull((Object)data.networkId());
        new ClusterLinkCCloudToCCloudChannelBuilder(brokerConfig, linkConfig).maybeAddNetworkIdTags((AbstractRequest)request);
        Assertions.assertEquals((Object)networkId.get(), (Object)data.networkId());
    }

    private KafkaConfig getBrokerConfig(Option<String> networkId) {
        Properties brokerProps = this.getBrokerProps(networkId);
        return KafkaConfig$.MODULE$.fromProps(brokerProps);
    }

    private Properties getBrokerProps(Option<String> networkId) {
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        networkId.map((Function1 & Serializable)nid -> brokerProps.put("confluent.traffic.network.id", nid));
        return brokerProps;
    }

    @Test
    public void testConfigsOverridesWithMTlsUsingServerCert() {
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(this.createBrokerConfig());
        HashMap mTlsConfigOverrides = new ClusterLinkCCloudToCCloudChannelBuilder(brokerConfig, null).configsOverridesWithMTlsUsingServerCert();
        Assertions.assertTrue((boolean)mTlsConfigOverrides.isEmpty());
        brokerConfig = KafkaConfig$.MODULE$.fromProps(this.createBrokerConfigWithSsl());
        mTlsConfigOverrides = new ClusterLinkCCloudToCCloudChannelBuilder(brokerConfig, null).configsOverridesWithMTlsUsingServerCert();
        Assertions.assertEquals(mTlsConfigOverrides.get("ssl.keystore.type"), (Object)"JKS");
        Assertions.assertEquals((Object)brokerConfig.getString("ssl.keystore.location"), mTlsConfigOverrides.get("ssl.keystore.location"));
        Assertions.assertEquals((Object)brokerConfig.getString("ssl.keystore.type"), mTlsConfigOverrides.get("ssl.keystore.type"));
        Properties listenerProps = this.getListenerProps();
        brokerConfig = KafkaConfig$.MODULE$.fromProps(this.createBrokerAndListenerConfigWithSsl(listenerProps));
        mTlsConfigOverrides = new ClusterLinkCCloudToCCloudChannelBuilder(brokerConfig, null).configsOverridesWithMTlsUsingServerCert();
        Assertions.assertEquals(mTlsConfigOverrides.get("ssl.keystore.type"), (Object)"PKCS12");
        Assertions.assertEquals(mTlsConfigOverrides.get("ssl.keystore.location"), (Object)listenerProps.get("listener.name.external.ssl.keystore.location"));
        Assertions.assertNotNull(mTlsConfigOverrides.get("ssl.keystore.password"));
        Assertions.assertNotEquals((Object)brokerConfig.getString("ssl.keystore.location"), mTlsConfigOverrides.get("ssl.keystore.location"));
        Assertions.assertNotEquals((Object)brokerConfig.getString("ssl.keystore.type"), mTlsConfigOverrides.get("ssl.keystore.type"));
    }

    private Properties createBrokerAndListenerConfigWithSsl(Properties listenerProps) {
        Properties brokerProps = this.createBrokerConfigWithSsl();
        brokerProps.setProperty("confluent.multitenant.listener.names", "EXTERNAL");
        brokerProps.putAll((Map<?, ?>)listenerProps);
        return brokerProps;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getListenerProps() {
        void tempFile_suffix;
        Properties listenerProps = new Properties();
        String string = ".pkcs12";
        String tempFile_prefix = "keystore";
        Object var3_3 = null;
        string = null;
        File keyStoreFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix);
        listenerProps.setProperty("listener.name.external.ssl.keystore.location", keyStoreFile.getAbsolutePath());
        listenerProps.setProperty("listener.name.external.ssl.keystore.type", "PKCS12");
        return listenerProps;
    }

    /*
     * WARNING - void declaration
     */
    private Properties createBrokerConfigWithSsl() {
        void tempFile_suffix;
        Properties props = this.getBrokerProps((Option<String>)Option$.MODULE$.empty());
        String string = ".jks";
        String tempFile_prefix = "truststore";
        Object var3_3 = null;
        string = null;
        File trustStoreFile1 = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix);
        props.putAll((Map<?, ?>)TestUtils$.MODULE$.sslConfigs(Mode.SERVER, false, (Option<File>)new Some((Object)trustStoreFile1), "kafka", "localhost", TestSslUtils.DEFAULT_TLS_PROTOCOL_FOR_TESTS, (Seq<String>)new ArrayBuffer()));
        return props;
    }

    private Properties createBrokerConfig() {
        Properties props = this.getBrokerProps((Option<String>)Option$.MODULE$.empty());
        props.put("confluent.cluster.link.enable", "true");
        props.put("confluent.cluster.link.metadata.topic.enable", "true");
        return props;
    }
}

