/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.KafkaConfig;
import kafka.server.UnboundedClusterLinkRequestQuota$;
import kafka.server.link.AuthenticationErrorUnavailableLinkReason;
import kafka.server.link.ClusterLinkCheckLinkAvailability;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ConnectionMode;
import kafka.server.link.InErrorTaskState$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.RemoteLinkState;
import kafka.server.link.TaskDescription;
import kafka.server.link.UnavailableLinkReason;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.DescribeClusterLinksOptions;
import org.apache.kafka.clients.admin.DescribeClusterLinksResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\teh\u0001B!C\u0001%CQ\u0001\u0015\u0001\u0005\u0002ECq\u0001\u0016\u0001C\u0002\u0013%Q\u000b\u0003\u0004_\u0001\u0001\u0006IA\u0016\u0005\b?\u0002\u0011\r\u0011\"\u0003a\u0011\u0019a\u0007\u0001)A\u0005C\"9Q\u000e\u0001b\u0001\n\u0013q\u0007B\u0002:\u0001A\u0003%q\u000eC\u0004t\u0001\t\u0007I\u0011\u0002;\t\ra\u0004\u0001\u0015!\u0003v\u0011\u001dI\b\u00011A\u0005\niD\u0011\"a\u0002\u0001\u0001\u0004%I!!\u0003\t\u000f\u0005U\u0001\u0001)Q\u0005w\"I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0004\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u001c!I\u00111\u0005\u0001C\u0002\u0013%\u0011Q\u0005\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002(!I\u0011q\u0006\u0001C\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u00024!I\u00111\b\u0001C\u0002\u0013%\u0011Q\b\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002@!Y\u0011Q\n\u0001A\u0002\u0003\u0007I\u0011BA(\u0011-\tI\u0006\u0001a\u0001\u0002\u0004%I!a\u0017\t\u0017\u0005}\u0003\u00011A\u0001B\u0003&\u0011\u0011\u000b\u0005\f\u0003C\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0007C\u0006\u0002l\u0001\u0001\r\u00111A\u0005\n\u00055\u0004bCA9\u0001\u0001\u0007\t\u0011)Q\u0005\u0003KB1\"a\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002v!Y\u0011Q\u0010\u0001A\u0002\u0003\u0007I\u0011BA@\u0011-\t\u0019\t\u0001a\u0001\u0002\u0003\u0006K!a\u001e\t\u0013\u0005\u0015\u0005\u00011A\u0005\n\u0005\u001d\u0005\"CAH\u0001\u0001\u0007I\u0011BAI\u0011!\t)\n\u0001Q!\n\u0005%\u0005bCAL\u0001\u0001\u0007\t\u0019!C\u0005\u00033C1\"a4\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002R\"Y\u0011Q\u001b\u0001A\u0002\u0003\u0005\u000b\u0015BAN\u0011-\t9\u000e\u0001a\u0001\u0002\u0004%I!!7\t\u0017\u0005\u0005\b\u00011AA\u0002\u0013%\u00111\u001d\u0005\f\u0003O\u0004\u0001\u0019!A!B\u0013\tY\u000eC\u0006\u0002j\u0002\u0001\r\u00111A\u0005\u0002\u0005-\bb\u0003B\u0002\u0001\u0001\u0007\t\u0019!C\u0001\u0005\u000bA1B!\u0003\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002n\"9!1\u0002\u0001\u0005\u0002\t5\u0001b\u0002B\u0013\u0001\u0011\u0005!Q\u0002\u0005\b\u0005_\u0001A\u0011\u0001B\u0007\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005\u001bAqA!\u0010\u0001\t\u0003\u0011i\u0001C\u0004\u0003B\u0001!\tA!\u0004\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H!9!Q\n\u0001\u0005\u0002\t5\u0001b\u0002B)\u0001\u0011\u0005!Q\u0002\u0005\b\u0005+\u0002A\u0011\u0001B\u0007\u0011\u001d\u0011I\u0006\u0001C\u0001\u0005\u001bAqA!\u0018\u0001\t\u0013\u0011y\u0006C\u0004\u0003f\u0001!\tA!\u0004\t\u000f\t%\u0004\u0001\"\u0001\u0003\u000e!9!Q\u000e\u0001\u0005\u0002\t5\u0001b\u0002B9\u0001\u0011%!1\u000f\u0005\b\u0005s\u0002A\u0011\u0001B\u0007\u0011\u001d\u0011i\b\u0001C\u0001\u0005\u001bAqA!!\u0001\t\u0013\t9\tC\u0004\u0003\u0004\u0002!IA!\"\t\u000f\t\u001d\u0007\u0001\"\u0003\u0003J\"I!q\u001a\u0001\u0012\u0002\u0013%!\u0011\u001b\u0005\b\u0005O\u0004A\u0011\u0002Bu\u0005\u0011\u001aE.^:uKJd\u0015N\\6DQ\u0016\u001c7\u000eT5oW\u00063\u0018-\u001b7bE&d\u0017\u000e^=UKN$(BA\"E\u0003\u0011a\u0017N\\6\u000b\u0005\u00153\u0015AB:feZ,'OC\u0001H\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u000b\u0005\u0002T\u00015\t!)\u0001\u0005mS:\\g*Y7f+\u00051\u0006CA,]\u001b\u0005A&BA-[\u0003\u0011a\u0017M\\4\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0017\u0002\u0007'R\u0014\u0018N\\4\u0002\u00131Lgn\u001b(b[\u0016\u0004\u0013A\u00027j].LE-F\u0001b!\t\u0011'.D\u0001d\u0015\t!W-\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f\u001aT!a\u001a5\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0017aA8sO&\u00111n\u0019\u0002\u0005+VLG-A\u0004mS:\\\u0017\n\u001a\u0011\u0002\u000f5,GO]5dgV\tq\u000e\u0005\u0002Ta&\u0011\u0011O\u0011\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003%\u00198\r[3ek2,'/F\u0001v!\t\u0019f/\u0003\u0002x\u0005\n!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003-\u0011X-\\8uK\u0006#W.\u001b8\u0016\u0003m\u00042\u0001`A\u0002\u001b\u0005i(B\u0001@\u0000\u0003\u0015\tG-\\5o\u0015\r\t\t!Z\u0001\bG2LWM\u001c;t\u0013\r\t)! \u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u0003=\u0011X-\\8uK\u0006#W.\u001b8`I\u0015\fH\u0003BA\u0006\u0003#\u00012aSA\u0007\u0013\r\ty\u0001\u0014\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0014-\t\t\u00111\u0001|\u0003\rAH%M\u0001\re\u0016lw\u000e^3BI6Lg\u000eI\u0001\u000bY>\u001c\u0017\r\\!e[&tWCAA\u000e!\r\u0019\u0016QD\u0005\u0004\u0003?\u0011%!F\"mkN$XM\u001d'j].dunY1m\u0003\u0012l\u0017N\\\u0001\fY>\u001c\u0017\r\\!e[&t\u0007%\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014XCAA\u0014!\r\u0019\u0016\u0011F\u0005\u0004\u0003W\u0011%AE\"mkN$XM\u001d'j].l\u0015M\\1hKJ\f1c\u00197vgR,'\u000fT5oW6\u000bg.Y4fe\u0002\nq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0003\u0003g\u00012aUA\u001b\u0013\r\t9D\u0011\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0011[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\nA\u0001^5nKV\u0011\u0011q\b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI2\u0002\u000bU$\u0018\u000e\\:\n\t\u0005%\u00131\t\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\u0007ce>\\WM]\"p]\u001aLw-\u0006\u0002\u0002RA!\u00111KA+\u001b\u0005!\u0015bAA,\t\nY1*\u00194lC\u000e{gNZ5h\u0003A\u0011'o\\6fe\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005u\u0003\"CA\n-\u0005\u0005\t\u0019AA)\u00035\u0011'o\\6fe\u000e{gNZ5hA\u0005QA.\u001b8l\u0007>tg-[4\u0016\u0005\u0005\u0015\u0004cA*\u0002h%\u0019\u0011\u0011\u000e\"\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw-\u0001\bmS:\\7i\u001c8gS\u001e|F%Z9\u0015\t\u0005-\u0011q\u000e\u0005\n\u0003'I\u0012\u0011!a\u0001\u0003K\n1\u0002\\5oW\u000e{gNZ5hA\u0005yA.\u001b8l\t\u0016\u001c8M]5qi&|g.\u0006\u0002\u0002xA\u0019A0!\u001f\n\u0007\u0005mTP\u0001\fDYV\u001cH/\u001a:MS:\\G)Z:de&\u0004H/[8o\u0003Ma\u0017N\\6EKN\u001c'/\u001b9uS>tw\fJ3r)\u0011\tY!!!\t\u0013\u0005MA$!AA\u0002\u0005]\u0014\u0001\u00057j].$Um]2sSB$\u0018n\u001c8!\u0003EI7\u000fT5oW\u000e{wN\u001d3j]\u0006$xN]\u000b\u0003\u0003\u0013\u00032aSAF\u0013\r\ti\t\u0014\u0002\b\u0005>|G.Z1o\u0003UI7\u000fT5oW\u000e{wN\u001d3j]\u0006$xN]0%KF$B!a\u0003\u0002\u0014\"I\u00111C\u0010\u0002\u0002\u0003\u0007\u0011\u0011R\u0001\u0013SNd\u0015N\\6D_>\u0014H-\u001b8bi>\u0014\b%A\u000bbm\u0006LG.\u00192jY&$\u0018p\u00115fG.lu\u000eZ3\u0016\u0005\u0005m\u0005\u0003BAO\u0003\u0013tA!a(\u0002D:!\u0011\u0011UA_\u001d\u0011\t\u0019+!/\u000f\t\u0005\u0015\u0016q\u0017\b\u0005\u0003O\u000b)L\u0004\u0003\u0002*\u0006Mf\u0002BAV\u0003ck!!!,\u000b\u0007\u0005=\u0006*\u0001\u0004=e>|GOP\u0005\u0002S&\u0011q\r[\u0005\u0003\u000f\u001aL!\u0001Z3\n\u0007\u0005m6-\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003\u007f\u000b\t-A\u0005j]R,'O\\1mg*\u0019\u00111X2\n\t\u0005\u0015\u0017qY\u0001\u0011\u0007>tg\r\\;f]R\u001cuN\u001c4jONTA!a0\u0002B&!\u00111ZAg\u0005\u0001\u001aE.^:uKJd\u0015N\\6Bm\u0006LG.\u00192jY&$\u0018p\u00115fG.lu\u000eZ3\u000b\t\u0005\u0015\u0017qY\u0001\u001aCZ\f\u0017\u000e\\1cS2LG/_\"iK\u000e\\Wj\u001c3f?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005M\u0007\"CA\nE\u0005\u0005\t\u0019AAN\u0003Y\tg/Y5mC\nLG.\u001b;z\u0007\",7m['pI\u0016\u0004\u0013\u0001\u0002;bg.,\"!a7\u0011\u0007M\u000bi.C\u0002\u0002`\n\u0013\u0001e\u00117vgR,'\u000fT5oW\u000eCWmY6MS:\\\u0017I^1jY\u0006\u0014\u0017\u000e\\5us\u0006AA/Y:l?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005\u0015\b\"CA\nK\u0005\u0005\t\u0019AAn\u0003\u0015!\u0018m]6!\u00039!Wm]2sS\n,g)\u001e;ve\u0016,\"!!<\u0011\r\u0005=\u00181_A|\u001b\t\t\tPC\u0002\u0002@\u000eLA!!>\u0002r\ny1*\u00194lC\u001a+H/\u001e:f\u00136\u0004H\u000e\u0005\u0004\u0002z\u0006}\u0018qO\u0007\u0003\u0003wT1!!@[\u0003\u0011)H/\u001b7\n\t\t\u0005\u00111 \u0002\u000b\u0007>dG.Z2uS>t\u0017A\u00053fg\u000e\u0014\u0018NY3GkR,(/Z0%KF$B!a\u0003\u0003\b!I\u00111\u0003\u0015\u0002\u0002\u0003\u0007\u0011Q^\u0001\u0010I\u0016\u001c8M]5cK\u001a+H/\u001e:fA\u0005)1/\u001a;VaR\u0011\u00111\u0002\u0015\u0004U\tE\u0001\u0003\u0002B\n\u0005Ci!A!\u0006\u000b\t\t]!\u0011D\u0001\u0004CBL'\u0002\u0002B\u000e\u0005;\tqA[;qSR,'OC\u0002\u0003 !\fQA[;oSRLAAa\t\u0003\u0016\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3a\u000bB\u0015!\u0011\u0011\u0019Ba\u000b\n\t\t5\"Q\u0003\u0002\n\u0003\u001a$XM]#bG\"\fq\u0007^3ti\u0006\u001bG/\u001b<f\u0019&t7n\u00148MS:\\7i\\8sI&t\u0017\r^8s\u0007\",7m['pI\u0016d\u0015N\\6D_>\u0014H-\u001b8bi>\u0014\bf\u0001\u0017\u00034A!!1\u0003B\u001b\u0013\u0011\u00119D!\u0006\u0003\tQ+7\u000f^\u0001;i\u0016\u001cH/Q2uSZ,G*\u001b8l\u001f:tuN\u001c'j].\u001cun\u001c:eS:\fGo\u001c:DQ\u0016\u001c7.T8eK2Kgn[\"p_J$\u0017N\\1u_JD3!\fB\u001a\u0003-\"Xm\u001d;BGRLg/\u001a'j].|e\u000eT5oW\u000e{wN\u001d3j]\u0006$xN]\"iK\u000e\\Wj\u001c3f\u00032d\u0007f\u0001\u0018\u00034\u0005qC/Z:u\u0003\u000e$\u0018N^3MS:\\wJ\u001c(p]2Kgn[\"p_J$\u0017N\\1u_J\u001c\u0005.Z2l\u001b>$W-\u00117mQ\ry#1G\u0001\u0011m\u0016\u0014\u0018NZ=BGRLg/\u001a'j].$b!a\u0003\u0003J\t-\u0003bBALa\u0001\u0007\u00111\u0014\u0005\b\u0003\u000b\u0003\u0004\u0019AAE\u0003]\"Xm\u001d;QCV\u001cX\r\u001a'j].|e\u000eT5oW\u000e{wN\u001d3j]\u0006$xN]\"iK\u000e\\Wj\u001c3f\u0019&t7nQ8pe\u0012Lg.\u0019;pe\"\u001a\u0011Ga\r\u0002uQ,7\u000f\u001e)bkN,G\rT5oW>sgj\u001c8MS:\\7i\\8sI&t\u0017\r^8s\u0007\",7m['pI\u0016d\u0015N\\6D_>\u0014H-\u001b8bi>\u0014\bf\u0001\u001a\u00034\u0005YC/Z:u!\u0006,8/\u001a3MS:\\wJ\u001c'j].\u001cun\u001c:eS:\fGo\u001c:DQ\u0016\u001c7.T8eK\u0006cG\u000eK\u00024\u0005g\tQ\u0006^3tiB\u000bWo]3eS:\\wJ\u001c(p]2Kgn[\"p_J$\u0017N\\1u_J\u001c\u0005.Z2l\u001b>$W-\u00117mQ\r!$1G\u0001\u0011m\u0016\u0014\u0018NZ=QCV\u001cX\r\u001a'j].$b!a\u0003\u0003b\t\r\u0004bBALk\u0001\u0007\u00111\u0014\u0005\b\u0003\u000b+\u0004\u0019AAE\u0003q\"Xm\u001d;V]\u00064\u0018-\u001b7bE2,G*\u001b8l\u001f:d\u0015N\\6D_>\u0014H-\u001b8bi>\u00148\t[3dW6{G-\u001a'j].\u001cun\u001c:eS:\fGo\u001c:)\u0007Y\u0012\u0019$\u0001\u0019uKN$XK\\1wC&d\u0017M\u00197f\u0019&t7n\u00148MS:\\7i\\8sI&t\u0017\r^8s\u0007\",7m['pI\u0016\fE\u000e\u001c\u0015\u0004o\tM\u0012a\r;fgR,f.\u0019<bS2\f'\r\\3MS:\\wJ\u001c(p]2Kgn[\"p_J$\u0017N\\1u_J\u001c\u0005.Z2l\u001b>$W-\u00117mQ\rA$1G\u0001'm\u0016\u0014\u0018NZ=Bm\u0006LG.\u00192jY&$\u0018p\u00115fG.,f.\u0019<bS2\f'\r\\3MS:\\GCBA\u0006\u0005k\u00129\bC\u0004\u0002\u0018f\u0002\r!a'\t\u000f\u0005\u0015\u0015\b1\u0001\u0002\n\u00061C/Z:u\u0003Z\f\u0017\u000e\\1cS2LG/\u001f*fMJ,7\u000f[+oCZ\f\u0017\u000e\\1cY\u0016d\u0015N\\6)\u0007i\u0012\u0019$\u0001\u0016uKN$\u0018I^1jY\u0006\u0014\u0017\u000e\\5usJ+gM]3tQ\u0012+7o\u0019:jE\u0016d\u0015N\\6GC&dWO]3)\u0007m\u0012\u0019$\u0001\rdQ\u0016\u001c7n\u001d*f[>$X-\u0011<bS2\f'-\u001b7jif\f\u0011b]3ukBd\u0015N\\6\u0015\u001d\u0005-!q\u0011BL\u00053\u0013YJ!,\u0003>\"1A+\u0010a\u0001\u0005\u0013\u0003BAa#\u0003\u0014:!!Q\u0012BH!\r\tY\u000bT\u0005\u0004\u0005#c\u0015A\u0002)sK\u0012,g-C\u0002^\u0005+S1A!%M\u0011\u001d\t9*\u0010a\u0001\u00037Cq!!\">\u0001\u0004\tI\tC\u0004\u0003\u001ev\u0002\rAa(\u0002\u00131Lgn[*uCR,\u0007\u0003\u0002BQ\u0005Os1\u0001 BR\u0013\r\u0011)+`\u0001\u0017\u00072,8\u000f^3s\u0019&t7\u000eR3tGJL\u0007\u000f^5p]&!!\u0011\u0016BV\u0005%a\u0015N\\6Ti\u0006$XMC\u0002\u0003&vDqAa,>\u0001\u0004\u0011\t,A\u000bv]\u00064\u0018-\u001b7bE2,G*\u001b8l%\u0016\f7o\u001c8\u0011\u000b-\u0013\u0019La.\n\u0007\tUFJ\u0001\u0004PaRLwN\u001c\t\u0004'\ne\u0016b\u0001B^\u0005\n)RK\\1wC&d\u0017M\u00197f\u0019&t7NU3bg>t\u0007b\u0002B`{\u0001\u0007!\u0011Y\u0001\u0010e\u0016lw\u000e^3MS:\\7\u000b^1uKB\u00191Ka1\n\u0007\t\u0015'IA\bSK6|G/\u001a'j].\u001cF/\u0019;f\u0003A)\b\u000fZ1uK2Kgn[\"p]\u001aLw\r\u0006\u0003\u0002\f\t-\u0007\"\u0003Bg}A\u0005\t\u0019AAE\u0003\u0019\u0001\u0018-^:fI\u0006QR\u000f\u001d3bi\u0016d\u0015N\\6D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u001b\u0016\u0005\u0003\u0013\u0013)n\u000b\u0002\u0003XB!!\u0011\u001cBr\u001b\t\u0011YN\u0003\u0003\u0003^\n}\u0017!C;oG\",7m[3e\u0015\r\u0011\t\u000fT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bs\u00057\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003I\u0011X-\\8uKN#\u0018\r^3NCR\u001c\u0007.\u001a:\u0015\t\t-(q\u001f\t\u0007\u0005[\u0014\u0019P!1\u000e\u0005\t=(b\u0001ByQ\u00069Qn\\2lSR|\u0017\u0002\u0002B{\u0005_\u0014q\"\u0011:hk6,g\u000e^'bi\u000eDWM\u001d\u0005\b\u0005\u007f\u0003\u0005\u0019\u0001Ba\u0001")
public class ClusterLinkCheckLinkAvailabilityTest {
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics(this.linkName(), this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, false, (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$, false);
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler(0, 100);
    private ConfluentAdmin remoteAdmin = new MockAdminClient();
    private final ClusterLinkLocalAdmin localAdmin = (ClusterLinkLocalAdmin)Mockito.mock(ClusterLinkLocalAdmin.class);
    private final ClusterLinkManager clusterLinkManager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final Time time = new MockTime();
    private KafkaConfig brokerConfig;
    private ClusterLinkConfig linkConfig;
    private ClusterLinkDescription linkDescription;
    private boolean isLinkCoordinator = false;
    private ConfluentConfigs.ClusterLinkAvailabilityCheckMode availabilityCheckMode;
    private ClusterLinkCheckLinkAvailability task;
    private KafkaFutureImpl<Collection<ClusterLinkDescription>> describeFuture;

    private String linkName() {
        return this.linkName;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin remoteAdmin() {
        return this.remoteAdmin;
    }

    private void remoteAdmin_$eq(ConfluentAdmin x$1) {
        this.remoteAdmin = x$1;
    }

    private ClusterLinkLocalAdmin localAdmin() {
        return this.localAdmin;
    }

    private ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private Time time() {
        return this.time;
    }

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private void brokerConfig_$eq(KafkaConfig x$1) {
        this.brokerConfig = x$1;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private void linkConfig_$eq(ClusterLinkConfig x$1) {
        this.linkConfig = x$1;
    }

    private ClusterLinkDescription linkDescription() {
        return this.linkDescription;
    }

    private void linkDescription_$eq(ClusterLinkDescription x$1) {
        this.linkDescription = x$1;
    }

    private boolean isLinkCoordinator() {
        return this.isLinkCoordinator;
    }

    private void isLinkCoordinator_$eq(boolean x$1) {
        this.isLinkCoordinator = x$1;
    }

    private ConfluentConfigs.ClusterLinkAvailabilityCheckMode availabilityCheckMode() {
        return this.availabilityCheckMode;
    }

    private void availabilityCheckMode_$eq(ConfluentConfigs.ClusterLinkAvailabilityCheckMode x$1) {
        this.availabilityCheckMode = x$1;
    }

    private ClusterLinkCheckLinkAvailability task() {
        return this.task;
    }

    private void task_$eq(ClusterLinkCheckLinkAvailability x$1) {
        this.task = x$1;
    }

    public KafkaFutureImpl<Collection<ClusterLinkDescription>> describeFuture() {
        return this.describeFuture;
    }

    public void describeFuture_$eq(KafkaFutureImpl<Collection<ClusterLinkDescription>> x$1) {
        this.describeFuture = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.metrics().startup();
        this.scheduler().startup();
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.task()).foreach((Function1 & Serializable)x$7 -> {
            x$7.shutdown();
            return BoxedUnit.UNIT;
        });
        this.scheduler().shutdown();
        this.metrics().shutdown();
    }

    @Test
    public void testActiveLinkOnLinkCoordinatorCheckModeLinkCoordinator() {
        this.verifyActiveLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode.LINK_COORDINATOR, true);
    }

    @Test
    public void testActiveLinkOnNonLinkCoordinatorCheckModeLinkCoordinator() {
        this.verifyActiveLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode.LINK_COORDINATOR, false);
    }

    @Test
    public void testActiveLinkOnLinkCoordinatorCheckModeAll() {
        this.verifyActiveLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode.ALL, true);
    }

    @Test
    public void testActiveLinkOnNonLinkCoordinatorCheckModeAll() {
        this.verifyActiveLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode.ALL, false);
    }

    private void verifyActiveLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode availabilityCheckMode, boolean isLinkCoordinator) {
        RemoteLinkState remoteState = new RemoteLinkState(ClusterLinkDescription.LinkState.ACTIVE, ClusterLinkError.NO_ERROR, (Option)None$.MODULE$, -1L);
        this.setupLink(this.linkName(), availabilityCheckMode, isLinkCoordinator, ClusterLinkDescription.LinkState.ACTIVE, (Option<UnavailableLinkReason>)None$.MODULE$, remoteState);
        KafkaFuture taskFuture = this.task().runOnce();
        Assertions.assertFalse((boolean)taskFuture.isDone());
        this.describeFuture().complete(Collections.singleton(this.linkDescription()));
        taskFuture.get(10L, TimeUnit.SECONDS);
        ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.times((int)1))).reportAvailableLink(this.linkName());
        ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.times((int)1))).updateRemoteLinkState((String)ArgumentMatchers.eq((Object)this.linkName()), (RemoteLinkState)ArgumentMatchers.argThat(this.remoteStateMatcher(remoteState)));
        ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.never())).reportUnavailableLink(ArgumentMatchers.anyString(), (UnavailableLinkReason)ArgumentMatchers.any());
    }

    @Test
    public void testPausedLinkOnLinkCoordinatorCheckModeLinkCoordinator() {
        this.verifyPausedLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode.LINK_COORDINATOR, true);
    }

    @Test
    public void testPausedLinkOnNonLinkCoordinatorCheckModeLinkCoordinator() {
        this.verifyPausedLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode.LINK_COORDINATOR, false);
    }

    @Test
    public void testPausedLinkOnLinkCoordinatorCheckModeAll() {
        this.verifyPausedLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode.ALL, true);
    }

    @Test
    public void testPausedinkOnNonLinkCoordinatorCheckModeAll() {
        this.verifyPausedLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode.ALL, false);
    }

    private void verifyPausedLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode availabilityCheckMode, boolean isLinkCoordinator) {
        RemoteLinkState remoteState = new RemoteLinkState(ClusterLinkDescription.LinkState.ACTIVE, ClusterLinkError.NO_ERROR, (Option)None$.MODULE$, -1L);
        this.setupLink(this.linkName(), availabilityCheckMode, isLinkCoordinator, ClusterLinkDescription.LinkState.PAUSED, (Option<UnavailableLinkReason>)None$.MODULE$, remoteState);
        this.updateLinkConfig(true);
        KafkaFuture taskFuture = this.task().runOnce();
        Assertions.assertFalse((boolean)taskFuture.isDone());
        this.describeFuture().complete(Collections.singleton(this.linkDescription()));
        taskFuture.get(10L, TimeUnit.SECONDS);
        ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.never())).reportAvailableLink(ArgumentMatchers.anyString());
        ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.never())).updateRemoteLinkState(ArgumentMatchers.anyString(), (RemoteLinkState)ArgumentMatchers.any());
        ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.never())).reportUnavailableLink(ArgumentMatchers.anyString(), (UnavailableLinkReason)ArgumentMatchers.any());
    }

    @Test
    public void testUnavailableLinkOnLinkCoordinatorCheckModeLinkCoordinator() {
        this.verifyAvailabilityCheckUnavailableLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode.LINK_COORDINATOR, true);
    }

    @Test
    public void testUnavailableLinkOnLinkCoordinatorCheckModeAll() {
        this.verifyAvailabilityCheckUnavailableLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode.ALL, true);
    }

    @Test
    public void testUnavailableLinkOnNonLinkCoordinatorCheckModeAll() {
        this.verifyAvailabilityCheckUnavailableLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode.ALL, false);
    }

    private void verifyAvailabilityCheckUnavailableLink(ConfluentConfigs.ClusterLinkAvailabilityCheckMode availabilityCheckMode, boolean isLinkCoordinator) {
        AuthenticationErrorUnavailableLinkReason localState = new AuthenticationErrorUnavailableLinkReason("Failed to authenticate to the remote cluster. Please check the link credentials in the link config.");
        RemoteLinkState remoteState = new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.UNKNOWN, (Option)new Some((Object)"Failed to obtain remote link state since cluster link is unavailable"), this.time().milliseconds());
        this.setupLink(this.linkName(), availabilityCheckMode, isLinkCoordinator, ClusterLinkDescription.LinkState.UNAVAILABLE, (Option<UnavailableLinkReason>)new Some((Object)localState), remoteState);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            KafkaFuture taskFuture = this.task().runOnce();
            this.describeFuture().complete(Collections.singleton(this.linkDescription()));
            taskFuture.get(10L, TimeUnit.SECONDS);
            ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.times((int)(i == 4 ? 1 : 0)))).reportUnavailableLink(this.linkName(), (UnavailableLinkReason)localState);
            ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.times((int)(i + 1)))).updateRemoteLinkState((String)ArgumentMatchers.eq((Object)this.linkName()), (RemoteLinkState)ArgumentMatchers.argThat(this.remoteStateMatcher(remoteState)));
            ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.never())).reportAvailableLink(ArgumentMatchers.anyString());
        });
    }

    @Test
    public void testAvailabilityRefreshUnavailableLink() {
        AuthenticationErrorUnavailableLinkReason localState = new AuthenticationErrorUnavailableLinkReason("local error");
        RemoteLinkState remoteState = new RemoteLinkState(ClusterLinkDescription.LinkState.UNAVAILABLE, ClusterLinkError.TIMEOUT_ERROR, (Option)new Some((Object)"remote error"), this.time().milliseconds());
        this.setupLink(this.linkName(), ConfluentConfigs.ClusterLinkAvailabilityCheckMode.LINK_COORDINATOR, false, ClusterLinkDescription.LinkState.UNAVAILABLE, (Option<UnavailableLinkReason>)new Some((Object)localState), remoteState);
        KafkaFuture taskFuture = this.task().runOnce();
        Assertions.assertFalse((boolean)taskFuture.isDone());
        this.describeFuture().complete(Collections.singleton(this.linkDescription()));
        taskFuture.get(10L, TimeUnit.SECONDS);
        ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.times((int)1))).reportUnavailableLink(this.linkName(), (UnavailableLinkReason)localState);
        ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.times((int)1))).updateRemoteLinkState((String)ArgumentMatchers.eq((Object)this.linkName()), (RemoteLinkState)ArgumentMatchers.argThat(this.remoteStateMatcher(remoteState)));
        ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.never())).reportAvailableLink(ArgumentMatchers.anyString());
    }

    @Test
    public void testAvailabilityRefreshDescribeLinkFailure() {
        this.setupLink(this.linkName(), ConfluentConfigs.ClusterLinkAvailabilityCheckMode.LINK_COORDINATOR, false, ClusterLinkDescription.LinkState.ACTIVE, (Option<UnavailableLinkReason>)None$.MODULE$, new RemoteLinkState(ClusterLinkDescription.LinkState.ACTIVE, ClusterLinkError.NO_ERROR, (Option)None$.MODULE$, -1L));
        KafkaFuture taskFuture = this.task().runOnce();
        Assertions.assertFalse((boolean)taskFuture.isDone());
        this.describeFuture().completeExceptionally((Throwable)new RuntimeException("Test exception"));
        taskFuture.get(10L, TimeUnit.SECONDS);
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)this.task().taskDescription());
        Assertions.assertEquals((Object)InErrorTaskState$.MODULE$, (Object)((TaskDescription)this.task().taskDescription().get()).state());
        Assertions.assertEquals((Object)new .colon.colon((Object)InternalTaskErrorCode$.MODULE$, (List)Nil$.MODULE$), (Object)((TaskDescription)this.task().taskDescription().get()).errs().map((Function1 & Serializable)x$8 -> x$8.code()));
        ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.never())).reportAvailableLink(ArgumentMatchers.anyString());
        ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.never())).reportUnavailableLink(ArgumentMatchers.anyString(), (UnavailableLinkReason)ArgumentMatchers.any());
        ((ClusterLinkManager)Mockito.verify((Object)this.clusterLinkManager(), (VerificationMode)Mockito.never())).updateRemoteLinkState(ArgumentMatchers.anyString(), (RemoteLinkState)ArgumentMatchers.any());
    }

    private boolean checksRemoteAvailability() {
        ConfluentConfigs.ClusterLinkAvailabilityCheckMode clusterLinkAvailabilityCheckMode = this.availabilityCheckMode();
        ConfluentConfigs.ClusterLinkAvailabilityCheckMode clusterLinkAvailabilityCheckMode2 = ConfluentConfigs.ClusterLinkAvailabilityCheckMode.ALL;
        return !(clusterLinkAvailabilityCheckMode == null ? clusterLinkAvailabilityCheckMode2 != null : !clusterLinkAvailabilityCheckMode.equals(clusterLinkAvailabilityCheckMode2)) || this.isLinkCoordinator();
    }

    private void setupLink(String linkName, ConfluentConfigs.ClusterLinkAvailabilityCheckMode availabilityCheckMode, boolean isLinkCoordinator, ClusterLinkDescription.LinkState linkState, Option<UnavailableLinkReason> unavailableLinkReason, RemoteLinkState remoteLinkState) {
        this.availabilityCheckMode_$eq(availabilityCheckMode);
        this.isLinkCoordinator_$eq(isLinkCoordinator);
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        brokerProps.setProperty("confluent.cluster.link.availability.check.mode", availabilityCheckMode.name());
        this.brokerConfig_$eq(new KafkaConfig((Map)brokerProps));
        this.updateLinkConfig(false);
        if (!this.checksRemoteAvailability()) {
            ClusterLinkDescription.Builder builder = new ClusterLinkDescription.Builder().setLinkName(linkName).setLinkId(Uuid.randomUuid()).setLinkState(linkState).setRemoteLinkState(remoteLinkState.state()).setRemoteLinkError(remoteLinkState.error()).setRemoteLinkErrorMessage((String)remoteLinkState.errorMessage().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setRemoteLinkStateTimeMs(remoteLinkState.stateTimeMs());
            unavailableLinkReason.foreach((Function1 & Serializable)reason -> builder.setClusterLinkError(reason.clusterLinkError()).setLinkErrorMessage(reason.errorMessage()));
            this.linkDescription_$eq(builder.build());
        } else {
            ClusterLinkDescription.LinkState linkState2 = linkState;
            ClusterLinkDescription.LinkState linkState3 = ClusterLinkDescription.LinkState.UNAVAILABLE;
            if (linkState2 == null ? linkState3 != null : !linkState2.equals(linkState3)) {
                NewClusterLink link = new NewClusterLink(linkName, "remote-cluster", this.linkConfig().originalsStrings());
                this.remoteAdmin().createClusterLinks(Collections.singleton(link), new CreateClusterLinksOptions()).all().get();
            } else {
                this.remoteAdmin_$eq((ConfluentAdmin)Mockito.mock(ConfluentAdmin.class));
                KafkaFutureImpl describeFuture = new KafkaFutureImpl();
                describeFuture.completeExceptionally((Throwable)new SaslAuthenticationException("Not authenticated"));
                DescribeClusterResult describeClusterResult = (DescribeClusterResult)Mockito.mock(DescribeClusterResult.class);
                Mockito.when((Object)describeClusterResult.clusterId()).thenReturn((Object)describeFuture);
                Mockito.when((Object)this.remoteAdmin().describeCluster((DescribeClusterOptions)ArgumentMatchers.any())).thenReturn((Object)describeClusterResult);
            }
        }
        Mockito.reset((Object[])new ClusterLinkLocalAdmin[]{this.localAdmin()});
        Mockito.reset((Object[])new ClusterLinkManager[]{this.clusterLinkManager()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)this.metadataManager());
        Mockito.when((Object)this.clusterLinkManager().brokerConfig()).thenReturn((Object)this.brokerConfig());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(linkName))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isLinkCoordinator));
        this.describeFuture_$eq((KafkaFutureImpl<Collection<ClusterLinkDescription>>)new KafkaFutureImpl());
        Mockito.when((Object)this.localAdmin().describeClusterLinks((DescribeClusterLinksOptions)ArgumentMatchers.any())).thenReturn((Object)new DescribeClusterLinksResult(this.describeFuture()));
        this.task_$eq(new ClusterLinkCheckLinkAvailability((Function0 & Serializable)() -> this.linkConfig(), this.metrics(), this.clusterLinkManager(), 10, this.scheduler(), linkName, (Function0 & Serializable)() -> this.remoteAdmin(), (Function0 & Serializable)() -> this.localAdmin(), this.time(), (ClusterLinkRequestQuota)UnboundedClusterLinkRequestQuota$.MODULE$));
    }

    private void updateLinkConfig(boolean paused) {
        Properties linkProps = new Properties();
        linkProps.put("bootstrap.servers", "localhost:0");
        linkProps.put(ClusterLinkConfig$.MODULE$.LinkModeProp(), "BIDIRECTIONAL");
        linkProps.put(ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), Boolean.toString(paused));
        this.linkConfig_$eq(ClusterLinkConfig$.MODULE$.create((Map)linkProps, (Option)new Some((Object)this.brokerConfig()), true));
    }

    private boolean updateLinkConfig$default$1() {
        return false;
    }

    private ArgumentMatcher<RemoteLinkState> remoteStateMatcher(RemoteLinkState remoteLinkState) {
        return arg -> {
            if (this.checksRemoteAvailability()) {
                ClusterLinkDescription.LinkState linkState = arg.state();
                ClusterLinkDescription.LinkState linkState2 = remoteLinkState.state();
                if (!(linkState != null ? !linkState.equals(linkState2) : linkState2 != null)) {
                    ClusterLinkError clusterLinkError = arg.error();
                    ClusterLinkError clusterLinkError2 = remoteLinkState.error();
                    if (!(clusterLinkError != null ? !clusterLinkError.equals(clusterLinkError2) : clusterLinkError2 != null)) {
                        Option option = arg.errorMessage();
                        Option option2 = remoteLinkState.errorMessage();
                        if (!(option != null ? !option.equals(option2) : option2 != null)) {
                            return true;
                        }
                    }
                }
                return false;
            }
            RemoteLinkState remoteLinkState = arg;
            return !(remoteLinkState != null ? !remoteLinkState.equals(remoteLinkState) : remoteLinkState != null);
        };
    }

    public ClusterLinkCheckLinkAvailabilityTest() {
        this.linkName = "test-link";
    }
}

