/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.UnboundedClusterLinkRequestQuota$;
import kafka.server.link.ClusterLinkClearLinkReference;
import kafka.server.link.ClusterLinkClearLinkReference$;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001B\u0017/\u0001UBQ\u0001\u0010\u0001\u0005\u0002uBq\u0001\u0011\u0001C\u0002\u0013%\u0011\t\u0003\u0004K\u0001\u0001\u0006IA\u0011\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0011\u0019A\u0006\u0001)A\u0005\u001b\"9\u0011\f\u0001b\u0001\n\u0013a\u0005B\u0002.\u0001A\u0003%Q\nC\u0004\\\u0001\t\u0007I\u0011\u0002/\t\r\u0001\u0004\u0001\u0015!\u0003^\u0011\u001d\t\u0007A1A\u0005\n\tDaA\u001b\u0001!\u0002\u0013\u0019\u0007bB6\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007a\u0002\u0001\u000b\u0011B7\t\u000fE\u0004!\u0019!C\u0005e\"1\u0011\u0010\u0001Q\u0001\nMDqA\u001f\u0001C\u0002\u0013%1\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u0002?\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\n\u0001\u0001\u0006I!a\u0003\t\u0013\u0005U\u0001A1A\u0005\n\u0005]\u0001\u0002CA\u0013\u0001\u0001\u0006I!!\u0007\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!9\u0011q\t\u0001\u0005\u0002\u0005%\u0002bBA)\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u00037\u0002A\u0011AA\u0015\u0011\u001d\ty\u0006\u0001C\u0001\u0003SAq!a\u0019\u0001\t\u0003\tI\u0003C\u0004\u0002h\u0001!\t!!\u000b\t\u000f\u0005-\u0004\u0001\"\u0001\u0002*!9\u0011q\u000e\u0001\u0005\u0002\u0005%\u0002bBA:\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003o\u0002A\u0011AA\u0015\u0011\u001d\tY\b\u0001C\u0001\u0003SAq!a \u0001\t\u0003\tI\u0003C\u0004\u0002\u0004\u0002!\t!!\u000b\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002*!9\u00111\u0012\u0001\u0005\u0002\u0005%\u0002bBAH\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003'\u0003A\u0011AA\u0015\u0011\u001d\t9\n\u0001C\u0005\u00033Cq!a3\u0001\t\u0013\ti\rC\u0005\u0002\u0000\u0002\t\n\u0011\"\u0003\u0003\u0002!9!q\u0003\u0001\u0005\n\te\u0001\"\u0003B\u0011\u0001E\u0005I\u0011\u0002B\u0001\u0005\u0005\u001aE.^:uKJd\u0015N\\6DY\u0016\f'\u000fT5oWJ+g-\u001a:f]\u000e,G+Z:u\u0015\ty\u0003'\u0001\u0003mS:\\'BA\u00193\u0003\u0019\u0019XM\u001d<fe*\t1'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0004CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002}A\u0011q\bA\u0007\u0002]\u0005AA.\u001b8l\u001d\u0006lW-F\u0001C!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0003mC:<'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0012\u0013aa\u0015;sS:<\u0017!\u00037j].t\u0015-\\3!\u0003\u0019a\u0017N\\6JIV\tQ\n\u0005\u0002O-6\tqJ\u0003\u0002Q#\u000611m\\7n_:T!a\r*\u000b\u0005M#\u0016AB1qC\u000eDWMC\u0001V\u0003\ry'oZ\u0005\u0003/>\u0013A!V;jI\u00069A.\u001b8l\u0013\u0012\u0004\u0013!D:pkJ\u001cW\rV8qS\u000eLE-\u0001\bt_V\u00148-\u001a+pa&\u001c\u0017\n\u001a\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#A/\u0011\u0005}r\u0016BA0/\u0005Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002\u000b\u0005$W.\u001b8\u0016\u0003\r\u0004\"\u0001\u001a5\u000e\u0003\u0015T!!\u00194\u000b\u0005\u001d\f\u0016aB2mS\u0016tGo]\u0005\u0003S\u0016\u0014abQ8oM2,XM\u001c;BI6Lg.\u0001\u0004bI6Lg\u000eI\u0001\u0010[\u0016$\u0018\rZ1uC6\u000bg.Y4feV\tQ\u000e\u0005\u0002@]&\u0011qN\f\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0011[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\n\u0001\u0002\\5oW\u0012\u000bG/Y\u000b\u0002gB\u0011Ao^\u0007\u0002k*\u0011aOM\u0001\u0003u.L!\u0001_;\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0011\u0002\\5oW\u0012\u000bG/\u0019\u0011\u0002\tQLW.Z\u000b\u0002yB\u0019Q0!\u0001\u000e\u0003yT!a`(\u0002\u000bU$\u0018\u000e\\:\n\u0007\u0005\raP\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013!B9v_R\fWCAA\u0006!\u0011\ti!a\u0004\u000e\u0003AJ1!!\u00051\u0005]\u0019E.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-\u0001\u0004rk>$\u0018\rI\u0001\u000fKb\u0004Xm\u0019;fI\u001aKG\u000e^3s+\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\tybT\u0001\u0004C\u000ed\u0017\u0002BA\u0012\u0003;\u0011\u0001$Q2dKN\u001c8i\u001c8ue>dWI\u001c;ss\u001aKG\u000e^3s\u0003=)\u0007\u0010]3di\u0016$g)\u001b7uKJ\u0004\u0013!B:fiV\u0003HCAA\u0016!\r9\u0014QF\u0005\u0004\u0003_A$\u0001B+oSRD3AFA\u001a!\u0011\t)$a\u0011\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\t1!\u00199j\u0015\u0011\ti$a\u0010\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011\t+\u0002\u000b),h.\u001b;\n\t\u0005\u0015\u0013q\u0007\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007]\tY\u0005\u0005\u0003\u00026\u00055\u0013\u0002BA(\u0003o\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u00025Q,7\u000f^\"mK\u0006\u0014X*\u001b:s_J$v\u000e]5dg\u0016k\u0007\u000f^=)\u0007a\t)\u0006\u0005\u0003\u00026\u0005]\u0013\u0002BA-\u0003o\u0011A\u0001V3ti\u0006IB/Z:u\u0011\u0006tG\r\\3t\u000b6\u0004H/\u001f'pG\u0006d\u0017i\u00197tQ\rI\u0012QK\u0001\u001ei\u0016\u001cH\u000fS1oI2,7\u000fT8dC2\f5\r\\:U_6KwM]1uK\"\u001a!$!\u0016\u0002_Q,7\u000f\u001e%b]\u0012dWm\u0011:fCR,\u0017i\u00197t%\u0016\u001cX\u000f\u001c;GkR,(/\u001a+ie><8/\u0012=dKB$\u0018n\u001c8)\u0007m\t)&A\u0018uKN$\b*\u00198eY\u0016$U\r\\3uK\u0006\u001bGn\u001d*fgVdGOR;ukJ,G\u000b\u001b:poN,\u0005pY3qi&|g\u000eK\u0002\u001d\u0003+\n1\u0007^3ti\"\u000bg\u000e\u001a7f\t\u0016dW\r^3BG2\u001c(+Z:vYR\u0014Vm\u001d9p]N,7i\u001c8uC&t7/\u0012=dKB$\u0018n\u001c8)\u0007u\t)&A\u000fuKN$8\t\\3be6K'O]8s)>\u0004\u0018nY:Jg6K'O]8sQ\rq\u0012QK\u0001-i\u0016\u001cHo\u00117fCJl\u0015N\u001d:peR{\u0007/[2t\u0013Nl\u0015N\u001d:pe\u0012KgMZ3sK:$H*\u001b8l\u0013\u0012D3aHA+\u0003\u001d\"Xm\u001d;DY\u0016\f'/T5se>\u0014Hk\u001c9jGNL5/T5se>\u0014XI\u001d:peJ+GO]=)\u0007\u0001\n)&\u0001\u0014uKN$8\t\\3be6K'O]8s)>\u0004\u0018nY:Jg6K'O]8s\u000bJ\u0014xN]*lSBD3!IA+\u0003y!Xm\u001d;DY\u0016\f'/T5se>\u0014Hk\u001c9jGNtu\u000e^'jeJ|'\u000fK\u0002#\u0003+\nA\u0005^3ti\u000ecW-\u0019:NSJ\u0014xN\u001d+pa&\u001c7\u000fT5oW\u0012{Wm\u001d8u\u000bbL7\u000f\u001e\u0015\u0004G\u0005U\u0013A\u000b;fgR\u001cE.Z1s\u001b&\u0014(o\u001c:U_BL7m]\"p]R\u0014x\u000e\u001c7fe6\u000bg._#oiJLWm\u001d\u0015\u0004I\u0005U\u0013!\n;fgR\\%/\u00194u\u001b>$Wm\u00155pk2$7\t\\3be2Kgn\u001b*fM\u0016\u0014XM\\2fQ\r)\u0013QK\u0001#i\u0016\u001cHOW6N_\u0012,7\u000b[8vY\u0012\u001cE.Z1s\u0019&t7NU3gKJ,gnY3)\u0007\u0019\n)&A\u001duKN$H)\u001a7fi\u0016\u001cE.^:uKJd\u0015N\\6NKR\fG-\u0019;b/\",g\u000eT5oW\u000e{wN\u001d3j]\u0006$xN]%t\u000b:\f'\r\\3eQ\r9\u0013QK\u0001\u0016]\u0016<\u0018\t\u001c;fe6K'O]8sgJ+7/\u001e7u)\u0011\tY*!)\u0011\u0007\u0011\fi*C\u0002\u0002 \u0016\u0014!#\u00117uKJl\u0015N\u001d:peN\u0014Vm];mi\"9\u00111\u0015\u0015A\u0002\u0005\u0015\u0016A\u0002;pa&\u001c7\u000f\u0005\u0004\u0002(\u0006]\u0016Q\u0018\b\u0005\u0003S\u000b\u0019L\u0004\u0003\u0002,\u0006EVBAAW\u0015\r\ty\u000bN\u0001\u0007yI|w\u000e\u001e \n\u0003eJ1!!.9\u0003\u001d\u0001\u0018mY6bO\u0016LA!!/\u0002<\n\u00191+Z9\u000b\u0007\u0005U\u0006\b\u0005\u0003\u0002@\u0006\u001dg\u0002BAa\u0003\u0007\u00042!a+9\u0013\r\t)\rO\u0001\u0007!J,G-\u001a4\n\u0007%\u000bIMC\u0002\u0002Fb\n1E\\3x\u00072,\u0017M\u001d'j].\u0014VMZ3sK:\u001cWmV5uQ\u0006+H\u000f[8sSj,'\u000f\u0006\u0005\u0002P\u0006U\u0017q\\A{!\ry\u0014\u0011[\u0005\u0004\u0003't#!H\"mkN$XM\u001d'j].\u001cE.Z1s\u0019&t7NU3gKJ,gnY3\t\u000f\u0005]\u0017\u00061\u0001\u0002Z\u0006\u00112m\\7qY\u0016$\u0018n\u001c8DC2d'-Y2l!\u00159\u00141\\A\u0016\u0013\r\ti\u000e\u000f\u0002\n\rVt7\r^5p]BBq!!9*\u0001\u0004\t\u0019/\u0001\u0006bkRDwN]5{KJ\u0004RaNAs\u0003SL1!a:9\u0005\u0019y\u0005\u000f^5p]B!\u00111^Ay\u001b\t\tiO\u0003\u0003\u0002b\u0006=(BA\u0019R\u0013\u0011\t\u00190!<\u0003\u0015\u0005+H\u000f[8sSj,'\u000fC\u0005\u0002x&\u0002\n\u00111\u0001\u0002z\u0006\u0001Bo\u001c9jGN<%o\\;qgNK'0\u001a\t\u0004o\u0005m\u0018bAA\u007fq\t\u0019\u0011J\u001c;\u0002[9,wo\u00117fCJd\u0015N\\6SK\u001a,'/\u001a8dK^KG\u000f[!vi\"|'/\u001b>fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0004)\"\u0011\u0011 B\u0003W\t\u00119\u0001\u0005\u0003\u0003\n\tMQB\u0001B\u0006\u0015\u0011\u0011iAa\u0004\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\tq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU!1\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00068fo\u000ecW-\u0019:MS:\\'+\u001a4fe\u0016t7-\u001a\u000b\u0007\u0003\u001f\u0014YB!\b\t\u000f\u0005]7\u00061\u0001\u0002Z\"I!qD\u0016\u0011\u0002\u0003\u0007\u0011\u0011`\u0001\u000fi>\u0004\u0018nY$s_V\u00048+\u001b>f\u0003}qWm^\"mK\u0006\u0014H*\u001b8l%\u00164WM]3oG\u0016$C-\u001a4bk2$HE\r")
public class ClusterLinkClearLinkReferenceTest {
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler(0, 100);
    private final ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManagerWithZkSupport.class);
    private final ClusterLinkData linkData = new ClusterLinkData(this.linkName(), this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, true);
    private final Time time = new MockTime();
    private final ClusterLinkRequestQuota quota = UnboundedClusterLinkRequestQuota$.MODULE$;
    private final AccessControlEntryFilter expectedFilter = new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY, Collections.singleton(this.linkId()));

    private String linkName() {
        return this.linkName;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    private Time time() {
        return this.time;
    }

    private ClusterLinkRequestQuota quota() {
        return this.quota;
    }

    private AccessControlEntryFilter expectedFilter() {
        return this.expectedFilter;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
    }

    @AfterEach
    public void tearDown() {
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        this.scheduler().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsEmpty() {
        void newClearLinkReference_topicGroupSize;
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().empty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var3_3 = null;
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, this.time(), this.quota(), (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertTrue((boolean)result.errs().isEmpty());
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandlesEmptyLocalAcls() {
        void newClearLinkReferenceWithAuthorizer_topicsGroupsSize;
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().empty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Authorizer mockAuthorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Some authorizer = new Some((Object)mockAuthorizer);
        AclBindingFilter aclBindingFilter = new AclBindingFilter(ResourcePatternFilter.ANY, this.expectedFilter());
        Mockito.when((Object)mockAuthorizer.acls(aclBindingFilter)).thenReturn((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava());
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReferenceWithAuthorizer_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var7_6 = null;
        ClusterLinkClearLinkReference clearMirrorTopics = new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)authorizer, this.admin(), (Function0)newClearLinkReferenceWithAuthorizer_completionCallback, this.time(), this.quota(), (int)newClearLinkReferenceWithAuthorizer_topicsGroupsSize, 10, 10);
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)clearMirrorTopics.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertTrue((boolean)result.errs().isEmpty());
        done.get();
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
        ((Authorizer)Mockito.verify((Object)mockAuthorizer)).acls(aclBindingFilter);
        Assertions.assertTrue((boolean)clearMirrorTopics.getUpdatedAcls());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandlesLocalAclsToMigrate() {
        void newClearLinkReferenceWithAuthorizer_topicsGroupsSize;
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().empty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Authorizer mockAuthorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Some authorizer = new Some((Object)mockAuthorizer);
        String host = "10.0.0.1";
        String principal = "User:user";
        String resourceName = "foo";
        AclOperation operation = AclOperation.ALL;
        PatternType patternType = PatternType.LITERAL;
        ResourceType resourceType = ResourceType.TOPIC;
        AclPermissionType permissionType = AclPermissionType.ALLOW;
        AclBinding aclBindingWithLink = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType, Collections.singleton(this.linkId())));
        AclBinding aclBindingWithLinkAndLocal = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.linkId(), (List)new .colon.colon((Object)Uuid.ZERO_UUID, (List)Nil$.MODULE$))).asJava()));
        AclBindingFilter aclBindingFilter = new AclBindingFilter(ResourcePatternFilter.ANY, this.expectedFilter());
        Mockito.when((Object)mockAuthorizer.acls(aclBindingFilter)).thenReturn((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBindingWithLink, (List)Nil$.MODULE$)).asJava()).thenReturn((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBindingWithLinkAndLocal, (List)Nil$.MODULE$)).asJava()).thenReturn((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava());
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        KafkaFutureImpl createAclsFuture = new KafkaFutureImpl();
        createAclsFuture.complete(null);
        CreateAclsResult createAclsResult = (CreateAclsResult)Mockito.mock(CreateAclsResult.class);
        AclBinding aclBindingWithoutLink = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType));
        Mockito.when((Object)createAclsResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBindingWithoutLink), (Object)createAclsFuture)}))).asJava());
        Mockito.when((Object)this.admin().createAcls(Collections.singletonList(aclBindingWithoutLink))).thenReturn((Object)createAclsResult);
        DeleteAclsResult.FilterResult filterResult = (DeleteAclsResult.FilterResult)Mockito.mock(DeleteAclsResult.FilterResult.class);
        Mockito.when((Object)filterResult.binding()).thenReturn((Object)aclBindingWithLink);
        Mockito.when((Object)((Object)filterResult.exception())).thenReturn(null);
        DeleteAclsResult.FilterResults filterResults = (DeleteAclsResult.FilterResults)Mockito.mock(DeleteAclsResult.FilterResults.class);
        Mockito.when((Object)filterResults.values()).thenReturn(Collections.singletonList(filterResult));
        KafkaFutureImpl deleteAclsFuture = new KafkaFutureImpl();
        deleteAclsFuture.complete((Object)filterResults);
        DeleteAclsResult deleteAclsResult = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)deleteAclsResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBindingWithLink.toFilter()), (Object)deleteAclsFuture)}))).asJava());
        Mockito.when((Object)this.admin().deleteAcls(Collections.singletonList(aclBindingWithLink.toFilter()))).thenReturn((Object)deleteAclsResult);
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReferenceWithAuthorizer_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var23_22 = null;
        ClusterLinkClearLinkReference clearMirrorTopics = new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)authorizer, this.admin(), (Function0)newClearLinkReferenceWithAuthorizer_completionCallback, this.time(), this.quota(), (int)newClearLinkReferenceWithAuthorizer_topicsGroupsSize, 10, 10);
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)clearMirrorTopics.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertTrue((boolean)result.errs().isEmpty());
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
        ((Authorizer)Mockito.verify((Object)mockAuthorizer, (VerificationMode)Mockito.times((int)3))).acls(aclBindingFilter);
        ((Admin)Mockito.verify((Object)this.admin())).createAcls(Collections.singletonList(aclBindingWithoutLink));
        ((Admin)Mockito.verify((Object)this.admin())).deleteAcls(Collections.singletonList(aclBindingWithLink.toFilter()));
        Assertions.assertTrue((boolean)clearMirrorTopics.getUpdatedAcls());
        ((DeleteAclsResult.FilterResult)Mockito.verify((Object)filterResult)).exception();
        ((DeleteAclsResult.FilterResults)Mockito.verify((Object)filterResults)).values();
    }

    @Test
    public void testHandleCreateAclsResultFutureThrowsException() {
        String host = "10.0.0.1";
        String principal = "User:user";
        String resourceName = "foo";
        AclOperation operation = AclOperation.ALL;
        PatternType patternType = PatternType.LITERAL;
        ResourceType resourceType = ResourceType.TOPIC;
        AclPermissionType permissionType = AclPermissionType.ALLOW;
        KafkaFutureImpl createAclsFuture = new KafkaFutureImpl();
        createAclsFuture.completeExceptionally((Throwable)new Exception("Internal error"));
        CreateAclsResult createAclsResult = (CreateAclsResult)Mockito.mock(CreateAclsResult.class);
        AclBinding aclBinding = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType, Collections.singleton(this.linkId())));
        Mockito.when((Object)createAclsResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding), (Object)createAclsFuture)}))).asJava());
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.handleCreateAclsResult(createAclsResult)._1$mcZ$sp());
        ((CreateAclsResult)Mockito.verify((Object)createAclsResult)).values();
    }

    @Test
    public void testHandleDeleteAclsResultFutureThrowsException() {
        String host = "10.0.0.1";
        String principal = "User:user";
        String resourceName = "foo";
        AclOperation operation = AclOperation.ALL;
        PatternType patternType = PatternType.LITERAL;
        ResourceType resourceType = ResourceType.TOPIC;
        AclPermissionType permissionType = AclPermissionType.ALLOW;
        AclBinding aclBinding = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType));
        KafkaFutureImpl deleteAclsFuture = new KafkaFutureImpl();
        deleteAclsFuture.completeExceptionally((Throwable)new Exception("Internal error"));
        DeleteAclsResult deleteAclsResult = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)deleteAclsResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding.toFilter()), (Object)deleteAclsFuture)}))).asJava());
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.handleDeleteAclsResult(deleteAclsResult));
        ((DeleteAclsResult)Mockito.verify((Object)deleteAclsResult)).values();
    }

    @Test
    public void testHandleDeleteAclsResultResponseContainsException() {
        String host = "10.0.0.1";
        String principal = "User:user";
        String resourceName = "foo";
        AclOperation operation = AclOperation.ALL;
        PatternType patternType = PatternType.LITERAL;
        ResourceType resourceType = ResourceType.TOPIC;
        AclPermissionType permissionType = AclPermissionType.ALLOW;
        AclBinding aclBinding = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType));
        DeleteAclsResult.FilterResult filterResult = (DeleteAclsResult.FilterResult)Mockito.mock(DeleteAclsResult.FilterResult.class);
        Mockito.when((Object)filterResult.binding()).thenReturn((Object)aclBinding);
        Mockito.when((Object)((Object)filterResult.exception())).thenReturn((Object)new ApiException((Throwable)new Exception("Internal error")));
        DeleteAclsResult.FilterResults filterResults = (DeleteAclsResult.FilterResults)Mockito.mock(DeleteAclsResult.FilterResults.class);
        Mockito.when((Object)filterResults.values()).thenReturn(Collections.singletonList(filterResult));
        KafkaFutureImpl deleteAclsFuture = new KafkaFutureImpl();
        deleteAclsFuture.complete((Object)filterResults);
        DeleteAclsResult deleteAclsResult = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)deleteAclsResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding.toFilter()), (Object)deleteAclsFuture)}))).asJava());
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.handleDeleteAclsResult(deleteAclsResult));
        ((DeleteAclsResult.FilterResult)Mockito.verify((Object)filterResult, (VerificationMode)Mockito.times((int)2))).exception();
        ((DeleteAclsResult.FilterResults)Mockito.verify((Object)filterResults)).values();
        ((DeleteAclsResult)Mockito.verify((Object)deleteAclsResult)).values();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirror() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        KafkaFuture future = KafkaFuture.completedFuture(null);
        AlterMirrorsResult ret = new AlterMirrorsResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future)}))).asJava());
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(topic, AlterMirrorOp.CLEAR)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var6_6 = null;
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, this.time(), this.quota(), (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertTrue((boolean)result.errs().isEmpty());
        done.get();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin())).alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(topic, AlterMirrorOp.CLEAR)), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorDifferentLinkId() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        String otherLinkName = "other-link-name";
        Uuid otherLinkId = Uuid.randomUuid();
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(otherLinkName, otherLinkId, this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var6_6 = null;
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, this.time(), this.quota(), (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertTrue((boolean)result.errs().isEmpty());
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorErrorRetry() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        scala.collection.immutable.Map expectedOps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)AlterMirrorOp.CLEAR)}));
        KafkaFutureImpl future1 = new KafkaFutureImpl();
        future1.completeExceptionally((Throwable)new TimeoutException());
        AlterMirrorsResult ret1 = new AlterMirrorsResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future1)}))).asJava());
        AlterMirrorsResult ret2 = this.newAlterMirrorsResult((scala.collection.immutable.Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret1).thenReturn((Object)ret2);
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var8_8 = null;
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, this.time(), this.quota(), (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertTrue((boolean)result.errs().isEmpty());
        done.get();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorErrorSkip() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        scala.collection.immutable.Map expectedOps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)AlterMirrorOp.CLEAR)}));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException());
        AlterMirrorsResult ret = new AlterMirrorsResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future)}))).asJava());
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret);
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var7_7 = null;
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, this.time(), this.quota(), (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertTrue((boolean)result.errs().isEmpty());
        done.get();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin())).alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsNotMirror() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn((Object)Predef$.MODULE$.Map().empty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var4_4 = null;
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, this.time(), this.quota(), (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertTrue((boolean)result.errs().isEmpty());
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsLinkDoesntExist() {
        void newClearLinkReference_topicGroupSize;
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)None$.MODULE$);
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var3_3 = null;
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, this.time(), this.quota(), (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertTrue((boolean)result.errs().isEmpty());
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
    }

    @Test
    public void testClearMirrorTopicsControllerManyEntries() {
        String otherLinkName = "other-link-name";
        Uuid otherLinkId = Uuid.randomUuid();
        int topicGroupSize = 2;
        Set topics = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)idx -> ClusterLinkClearLinkReferenceTest.$anonfun$testClearMirrorTopicsControllerManyEntries$1(BoxesRunTime.unboxToInt((Object)idx))).toSet();
        List topicGroups = topics.grouped(topicGroupSize).toList();
        Assertions.assertEquals((int)3, (int)topicGroups.size());
        Assertions.assertEquals((int)2, (int)((IterableOnceOps)topicGroups.apply(0)).size());
        Assertions.assertEquals((int)2, (int)((IterableOnceOps)topicGroups.apply(1)).size());
        Assertions.assertEquals((int)1, (int)((IterableOnceOps)topicGroups.apply(2)).size());
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)topics);
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.head()).head()), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.head()).last()), (Object)new ClusterLinkTopicState.Mirror(otherLinkName, otherLinkId, this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)topicGroups.head())).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Object[] objectArray2 = new Tuple2[2];
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.apply(1)).head()), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.apply(1)).last()), (Object)new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, Time.SYSTEM.milliseconds()));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)topicGroups.apply(1))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)topicGroups.apply(2))).thenReturn((Object)Predef$.MODULE$.Map().empty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        scala.collection.immutable.Map expectedOps1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.apply(0)).head()), (Object)AlterMirrorOp.CLEAR)}));
        scala.collection.immutable.Map expectedOps2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.apply(1)).head()), (Object)AlterMirrorOp.CLEAR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.apply(1)).last()), (Object)AlterMirrorOp.CLEAR)}));
        AlterMirrorsResult ret1 = this.newAlterMirrorsResult((scala.collection.immutable.Seq<String>)new .colon.colon((Object)((String)((IterableOps)topicGroups.apply(0)).head()), (List)Nil$.MODULE$));
        AlterMirrorsResult ret2 = this.newAlterMirrorsResult((scala.collection.immutable.Seq<String>)new .colon.colon((Object)((String)((IterableOps)topicGroups.apply(1)).head()), (List)new .colon.colon((Object)((String)((IterableOps)topicGroups.apply(1)).last()), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps1).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret1);
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps2).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret2);
        CompletableFuture done = new CompletableFuture();
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var12_11 = null;
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, this.time(), this.quota(), topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertTrue((boolean)result.errs().isEmpty());
        done.get();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin())).alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps1).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ConfluentAdmin)Mockito.verify((Object)this.admin())).alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps2).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).mirrorTopicStatesFromMetadataStore((Set)topicGroups.apply(1));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).mirrorTopicStatesFromMetadataStore((Set)topicGroups.apply(2));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    @Test
    public void testKraftModeShouldClearLinkReference() {
        ClusterLinkMetadataManager kraftMetadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManagerWithKRaftSupport.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)kraftMetadataManager.clusterLinkExists(this.linkId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), kraftMetadataManager));
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{kraftMetadataManager});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)kraftMetadataManager.clusterLinkExists(this.linkId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), kraftMetadataManager));
    }

    @Test
    public void testZkModeShouldClearLinkReference() {
        ClusterLinkMetadataManager zkMetadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManagerWithZkSupport.class);
        ClusterLinkData linkDataIsDeleted = new ClusterLinkData(this.linkName(), this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, true);
        Mockito.when((Object)zkMetadataManager.getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)linkDataIsDeleted));
        Assertions.assertTrue((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), zkMetadataManager));
        ClusterLinkData linkDataIsNotDeleted = new ClusterLinkData(this.linkName(), this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{zkMetadataManager});
        Mockito.when((Object)zkMetadataManager.getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)linkDataIsNotDeleted));
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), zkMetadataManager));
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{zkMetadataManager});
        Mockito.when((Object)zkMetadataManager.getClusterLinkData(this.linkId())).thenReturn((Object)None$.MODULE$);
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), zkMetadataManager));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteClusterLinkMetadataWhenLinkCoordinatorIsEnabled() {
        void newClearLinkReference_topicGroupSize;
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().empty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        KafkaFutureImpl featureCompletedWithEx = new KafkaFutureImpl();
        featureCompletedWithEx.completeExceptionally((Throwable)new InvalidRequestException(""));
        Mockito.when((Object)this.admin().deleteClusterLinks((Collection)ArgumentMatchers.eq(Collections.singletonList(this.linkName())), (DeleteClusterLinksOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{new InvalidRequestException("")}).thenReturn((Object)new DeleteClusterLinksResult(Collections.singletonMap(this.linkName(), featureCompletedWithEx))).thenReturn((Object)new DeleteClusterLinksResult(Collections.singletonMap(this.linkName(), KafkaFuture.completedFuture(null))));
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var3_4 = null;
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, this.time(), this.quota(), (int)newClearLinkReference_topicGroupSize, 10, 10).startup();
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)3))).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)1))).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)3))).isLinkCoordinatorEnabled();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)3))).deleteClusterLinks((Collection)ArgumentMatchers.eq(Collections.singletonList(this.linkName())), (DeleteClusterLinksOptions)ArgumentMatchers.any());
    }

    private AlterMirrorsResult newAlterMirrorsResult(scala.collection.immutable.Seq<String> topics) {
        return new AlterMirrorsResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)topics.map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)KafkaFuture.completedFuture(null)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
    }

    private ClusterLinkClearLinkReference newClearLinkReferenceWithAuthorizer(Function0<BoxedUnit> completionCallback, Option<Authorizer> authorizer, int topicsGroupsSize) {
        return new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), authorizer, this.admin(), completionCallback, this.time(), this.quota(), topicsGroupsSize, 10, 10);
    }

    private ClusterLinkClearLinkReference newClearLinkReference(Function0<BoxedUnit> completionCallback, int topicGroupSize) {
        return new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), completionCallback, this.time(), this.quota(), topicGroupSize, 10, 10);
    }

    private int newClearLinkReferenceWithAuthorizer$default$3() {
        return 10;
    }

    private int newClearLinkReference$default$2() {
        return 10;
    }

    public static final /* synthetic */ String $anonfun$testClearMirrorTopicsControllerManyEntries$1(int idx) {
        return new StringBuilder(6).append("topic-").append(idx).toString();
    }

    public ClusterLinkClearLinkReferenceTest() {
        this.linkName = "link-name";
    }
}

