/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.MockVault;
import kafka.server.link.MockVault$;
import kafka.server.link.SecureLinkConfigEncoder;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001\u0002\b\u0010\u0001YAQ!\b\u0001\u0005\u0002yAQ!\t\u0001\u0005\u0002\tBQa\r\u0001\u0005\u0002\tBQ!\u000e\u0001\u0005\u0002\tBQa\u000e\u0001\u0005\u0002\tBQ!\u000f\u0001\u0005\u0002\tBQa\u000f\u0001\u0005\u0002\tBQ!\u0010\u0001\u0005\u0002yBQa\u0017\u0001\u0005\nqCq\u0001\u001b\u0001\u0012\u0002\u0013%\u0011\u000eC\u0003u\u0001\u0011%Q\u000fC\u0005\u0002\f\u0001\t\n\u0011\"\u0003\u0002\u000e!9\u0011\u0011\u0003\u0001\u0005\n\u0005M!\u0001H\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u0016s7m\u001c3feR+7\u000f\u001e\u0006\u0003!E\tA\u0001\\5oW*\u0011!cE\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Q\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001/A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0010\u0011\u0005\u0001\u0002Q\"A\b\u0002AQ,7\u000f^#oG>$\u0017N\\4XSRD7+\u001a8tSRLg/Z\"p]\u001aLwm\u001d\u000b\u0002GA\u0011\u0001\u0004J\u0005\u0003Ke\u0011A!\u00168ji\"\u0012!a\n\t\u0003QEj\u0011!\u000b\u0006\u0003U-\n1!\u00199j\u0015\taS&A\u0004kkBLG/\u001a:\u000b\u00059z\u0013!\u00026v]&$(\"\u0001\u0019\u0002\u0007=\u0014x-\u0003\u00023S\t!A+Z:u\u0003y!Xm\u001d;F]\u000e|G-\u001b8h\u001d>\u001cVM\\:ji&4XmQ8oM&<7\u000f\u000b\u0002\u0004O\u00059B/Z:u\u000bb$XM\u001d8bY&TX\rZ\"p]\u001aLwm\u001d\u0015\u0003\t\u001d\n\u0011\u0004^3ti\u0016s7M]=qi&|gnS3z%>$\u0018\r^5p]\"\u0012QaJ\u0001\u001fi\u0016\u001cHOU3f]\u000e\u0014\u0018\u0010\u001d;j_:4uN]&fsJ{G/\u0019;j_:D#AB\u0014\u0002QQ,7\u000f^*f]NLG/\u001b<f\u0007>tg-[4DQ\u0006tw-\u001a3U_:{GoU3og&$\u0018N^3)\u0005\u001d9\u0013A\u0005<fe&4\u00170\u00128d_\u0012,G)Z2pI\u0016$BaI J3\")\u0001\t\u0003a\u0001\u0003\u0006)\u0001O]8qgB\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0005kRLGNC\u0001G\u0003\u0011Q\u0017M^1\n\u0005!\u001b%A\u0003)s_B,'\u000f^5fg\")!\n\u0003a\u0001\u0017\u0006\u00012/\u001a8tSRLg/Z\"p]\u001aLwm\u001d\t\u0004\u0019N3fBA'R!\tq\u0015$D\u0001P\u0015\t\u0001V#\u0001\u0004=e>|GOP\u0005\u0003%f\ta\u0001\u0015:fI\u00164\u0017B\u0001+V\u0005\r\u0019V\r\u001e\u0006\u0003%f\u0001\"\u0001T,\n\u0005a+&AB*ue&tw\rC\u0003[\u0011\u0001\u0007\u0011)A\u0007sKN|GN^3e!J|\u0007o]\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\u000b\u0004;\u00064\u0007C\u00010`\u001b\u0005\t\u0012B\u00011\u0012\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000b\tL\u0001\u0019A2\u0002\rM,7M]3u!\rABMV\u0005\u0003Kf\u0011aa\u00149uS>t\u0007bB4\n!\u0003\u0005\raY\u0001\n_2$7+Z2sKR\faC\u0019:pW\u0016\u00148i\u001c8gS\u001e$C-\u001a4bk2$HEM\u000b\u0002U*\u00121m[\u0016\u0002YB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\nk:\u001c\u0007.Z2lK\u0012T!!]\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002t]\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001dY,'/\u001b4z\u000b:\u001cw\u000eZ5oOR1\u0011I\u001e=~}~DQa^\u0006A\u0002u\u000b1b[1gW\u0006\u001cuN\u001c4jO\")\u0011p\u0003a\u0001u\u0006QA.\u001b8l\u0007>tg-[4\u0011\u0005\u0001Z\u0018B\u0001?\u0010\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017n\u001a\u0005\u0006\u0015.\u0001\ra\u0013\u0005\u00065.\u0001\r!\u0011\u0005\n\u0003\u0003Y\u0001\u0013!a\u0001\u0003\u0007\t!\"\u001a8d_\u0012,'o\u00149u!\u0011AB-!\u0002\u0011\u0007\u0001\n9!C\u0002\u0002\n=\u0011qcU3dkJ,G*\u001b8l\u0007>tg-[4F]\u000e|G-\u001a:\u00021Y,'/\u001b4z\u000b:\u001cw\u000eZ5oO\u0012\"WMZ1vYR$S'\u0006\u0002\u0002\u0010)\u001a\u00111A6\u0002\u001dY,'/\u001b4z\t\u0016\u001cw\u000eZ5oOR91%!\u0006\u0002\u0018\u0005m\u0001\"B<\u000e\u0001\u0004i\u0006BBA\r\u001b\u0001\u0007\u0011)\u0001\u0007f]\u000e|G-\u001a3Qe>\u00048\u000fC\u0003[\u001b\u0001\u0007\u0011\t")
public class ClusterLinkConfigEncoderTest {
    @Test
    public void testEncodingWithSensitiveConfigs() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty("security.protocol", "SSL");
        props.setProperty("ssl.keystore.location", "/path/to/keystore.jks");
        props.setProperty("ssl.keystore.password", "keystore-secret");
        props.setProperty("ssl.key.password", "key-secret");
        Set sensitiveConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.password", "ssl.key.password"}));
        this.verifyEncodeDecode(props, (Set<String>)sensitiveConfigs, props);
    }

    @Test
    public void testEncodingNoSensitiveConfigs() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty("security.protocol", "PLAINTEXT");
        this.verifyEncodeDecode(props, (Set<String>)Predef$.MODULE$.Set().empty(), props);
    }

    @Test
    public void testExternalizedConfigs() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty("security.protocol", "SSL");
        props.setProperty("config.providers", "mockvault");
        props.setProperty("config.providers.mockvault.class", MockVault.class.getName());
        props.setProperty("config.providers.mockvault.param.url", MockVault$.MODULE$.Url());
        props.setProperty("ssl.keystore.location", "${mockvault:/clusterlink/test:ssl.keystore.location}");
        props.setProperty("ssl.keystore.password", "${mockvault:/clusterlink/test:ssl.keystore.password}");
        props.setProperty("ssl.key.password", "${mockvault:/clusterlink/test:ssl.key.password}");
        Set sensitiveConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"config.providers", "config.providers.mockvault.class", "config.providers.mockvault.param.url", "ssl.keystore.password", "ssl.key.password"}));
        Set externalizedConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.location", "ssl.keystore.password", "ssl.key.password"}));
        Properties resolvedProps = new Properties();
        CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k;
                return resolvedProps.setProperty(k, externalizedConfigs.contains((Object)(k = (String)x0$1._1())) ? (String)MockVault$.MODULE$.Configs().apply((Object)k) : props.getProperty(k));
            }
            throw new MatchError(null);
        });
        this.verifyEncodeDecode(props, (Set<String>)sensitiveConfigs, resolvedProps);
    }

    @Test
    public void testEncryptionKeyRotation() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty("security.protocol", "SSL");
        props.setProperty("ssl.keystore.location", "/path/to/keystore.jks");
        props.setProperty("ssl.keystore.password", "keystore-secret");
        props.setProperty("ssl.key.password", "key-secret");
        Set sensitiveConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.password", "ssl.key.password"}));
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true);
        KafkaConfig brokerConfig1 = this.brokerConfig((Option<String>)new Some((Object)"secret-v1"), (Option<String>)None$.MODULE$);
        Properties encoded1 = this.verifyEncoding(brokerConfig1, linkConfig, (Set<String>)sensitiveConfigs, props, (Option<SecureLinkConfigEncoder>)None$.MODULE$);
        this.verifyDecoding(brokerConfig1, encoded1, props);
        KafkaConfig brokerConfig2 = this.brokerConfig((Option<String>)new Some((Object)"secret-v2"), (Option<String>)new Some((Object)"secret-v1"));
        Properties encoded2 = this.verifyEncoding(brokerConfig2, linkConfig, (Set<String>)sensitiveConfigs, props, (Option<SecureLinkConfigEncoder>)None$.MODULE$);
        this.verifyDecoding(brokerConfig2, encoded2, props);
        this.verifyDecoding(brokerConfig1, encoded2, props);
        this.verifyDecoding(this.brokerConfig((Option<String>)new Some((Object)"secret-v2"), (Option<String>)None$.MODULE$), encoded2, props);
        KafkaConfig brokerConfig3 = this.brokerConfig((Option<String>)new Some((Object)"secret-v3"), (Option<String>)new Some((Object)"secret-v2"));
        Properties encoded3 = this.verifyEncoding(brokerConfig3, linkConfig, (Set<String>)sensitiveConfigs, props, (Option<SecureLinkConfigEncoder>)None$.MODULE$);
        this.verifyDecoding(brokerConfig3, encoded3, props);
        this.verifyDecoding(brokerConfig2, encoded3, props);
        this.verifyDecoding(this.brokerConfig((Option<String>)new Some((Object)"secret-v3"), (Option<String>)None$.MODULE$), encoded3, props);
    }

    @Test
    public void testReencryptionForKeyRotation() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty("security.protocol", "SSL");
        props.setProperty("ssl.keystore.location", "/path/to/keystore.jks");
        props.setProperty("ssl.keystore.password", "keystore-secret");
        props.setProperty("ssl.key.password", "key-secret");
        Set sensitiveConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.password", "ssl.key.password"}));
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true);
        KafkaConfig brokerConfig1 = this.brokerConfig((Option<String>)new Some((Object)"secret-v1"), (Option<String>)None$.MODULE$);
        Properties encoded1 = this.verifyEncoding(brokerConfig1, linkConfig, (Set<String>)sensitiveConfigs, props, (Option<SecureLinkConfigEncoder>)None$.MODULE$);
        SecureLinkConfigEncoder encoder1 = new SecureLinkConfigEncoder(brokerConfig1);
        Assertions.assertEquals((Object)props, (Object)encoder1.clusterLinkConfig(encoded1).originals());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)encoder1.maybeReencode(encoded1));
        KafkaConfig brokerConfig2 = this.brokerConfig((Option<String>)new Some((Object)"secret-v2"), (Option<String>)new Some((Object)"secret-v1"));
        Properties encoded2 = this.verifyEncoding(brokerConfig2, linkConfig, (Set<String>)sensitiveConfigs, props, (Option<SecureLinkConfigEncoder>)None$.MODULE$);
        SecureLinkConfigEncoder encoder2 = new SecureLinkConfigEncoder(brokerConfig2);
        Assertions.assertEquals((Object)props, (Object)encoder2.clusterLinkConfig(encoded2).originals());
        Assertions.assertEquals((Object)props, (Object)encoder1.clusterLinkConfig(encoded2).originals());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)encoder2.maybeReencode(encoded2));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)encoder1.maybeReencode(encoded2));
        Assertions.assertFalse((boolean)((Hashtable)encoder1.maybeReencode(encoded2).get()).isEmpty());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)encoder2.maybeReencode(encoded1));
        Assertions.assertFalse((boolean)((Hashtable)encoder2.maybeReencode(encoded1).get()).isEmpty());
        KafkaConfig brokerConfig3 = this.brokerConfig((Option<String>)new Some((Object)"secret-v3"), (Option<String>)new Some((Object)"secret-v2"));
        Properties encoded3 = this.verifyEncoding(brokerConfig3, linkConfig, (Set<String>)sensitiveConfigs, props, (Option<SecureLinkConfigEncoder>)None$.MODULE$);
        SecureLinkConfigEncoder encoder3 = new SecureLinkConfigEncoder(brokerConfig3);
        Assertions.assertEquals((Object)props, (Object)encoder3.clusterLinkConfig(encoded3).originals());
        Assertions.assertEquals((Object)props, (Object)encoder2.clusterLinkConfig(encoded3).originals());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)encoder3.maybeReencode(encoded3));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)encoder2.maybeReencode(encoded3));
        Assertions.assertFalse((boolean)((Hashtable)encoder2.maybeReencode(encoded3).get()).isEmpty());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)encoder3.maybeReencode(encoded2));
        Assertions.assertFalse((boolean)((Hashtable)encoder3.maybeReencode(encoded2).get()).isEmpty());
        encoder3.removeOldSecretEncoder();
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)encoder3.maybeReencode(encoded3));
        Properties encoded4 = (Properties)encoder3.maybeReencode(encoded3).get();
        Assertions.assertFalse((boolean)encoded4.isEmpty());
        this.verifyDecoding(this.brokerConfig((Option<String>)new Some((Object)"secret-v3"), (Option<String>)None$.MODULE$), encoded4, props);
        SecureLinkConfigEncoder encoder5 = new SecureLinkConfigEncoder(this.brokerConfig((Option<String>)new Some((Object)"secret-v2"), (Option<String>)None$.MODULE$));
        Assertions.assertThrows(ConfigException.class, () -> encoder5.clusterLinkConfig(encoded4));
    }

    @Test
    public void testSensitiveConfigChangedToNotSensitive() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty("security.protocol", "PLAINTEXT");
        props.setProperty("default.api.timeout.ms", "1000");
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true);
        this.verifyEncodeDecode(props, (Set<String>)Predef$.MODULE$.Set().empty(), props);
        KafkaConfig brokerConfig1 = this.brokerConfig((Option<String>)new Some((Object)"secret-1234"), (Option<String>)None$.MODULE$);
        SecureLinkConfigEncoder oldEncoder = new SecureLinkConfigEncoder(null, brokerConfig1){

            public boolean maybeSensitive(String configName) {
                String string = configName;
                String string2 = "default.api.timeout.ms";
                return string != null && string.equals(string2) || super.maybeSensitive(configName);
            }
        };
        Properties encoded = this.verifyEncoding(brokerConfig1, linkConfig, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"default.api.timeout.ms"}))), props, (Option<SecureLinkConfigEncoder>)new Some((Object)oldEncoder));
        this.verifyDecoding(brokerConfig1, encoded, props);
    }

    public void verifyEncodeDecode(Properties props, Set<String> sensitiveConfigs, Properties resolvedProps) {
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true);
        KafkaConfig brokerConfig1 = this.brokerConfig((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        SecureLinkConfigEncoder encoder1 = new SecureLinkConfigEncoder(brokerConfig1);
        if (sensitiveConfigs.isEmpty()) {
            this.verifyEncoding(brokerConfig1, linkConfig, sensitiveConfigs, resolvedProps, (Option<SecureLinkConfigEncoder>)None$.MODULE$);
        } else {
            Assertions.assertThrows(InvalidConfigurationException.class, () -> encoder1.encode(props));
        }
        KafkaConfig brokerConfig2 = this.brokerConfig((Option<String>)new Some((Object)"secret-1234"), (Option<String>)None$.MODULE$);
        this.verifyEncoding(brokerConfig2, linkConfig, sensitiveConfigs, resolvedProps, (Option<SecureLinkConfigEncoder>)None$.MODULE$);
        KafkaConfig brokerConfig3 = this.brokerConfig((Option<String>)new Some((Object)"secret-new"), (Option<String>)new Some((Object)"secret-old"));
        Properties encoded = this.verifyEncoding(brokerConfig3, linkConfig, sensitiveConfigs, resolvedProps, (Option<SecureLinkConfigEncoder>)None$.MODULE$);
        this.verifyDecoding(this.brokerConfig((Option<String>)new Some((Object)"secret-new"), (Option<String>)None$.MODULE$), encoded, resolvedProps);
        this.verifyDecoding(this.brokerConfig((Option<String>)new Some((Object)"secret-old"), (Option<String>)None$.MODULE$), encoded, resolvedProps);
    }

    private KafkaConfig brokerConfig(Option<String> secret, Option<String> oldSecret) {
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        secret.foreach((Function1 & Serializable)x$1 -> brokerProps.setProperty(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), (String)x$1));
        oldSecret.foreach((Function1 & Serializable)x$2 -> brokerProps.setProperty(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), (String)x$2));
        return new KafkaConfig((Map)brokerProps);
    }

    private Option<String> brokerConfig$default$2() {
        return None$.MODULE$;
    }

    private Properties verifyEncoding(KafkaConfig kafkaConfig, ClusterLinkConfig linkConfig, Set<String> sensitiveConfigs, Properties resolvedProps, Option<SecureLinkConfigEncoder> encoderOpt) {
        SecureLinkConfigEncoder encoder = (SecureLinkConfigEncoder)encoderOpt.getOrElse((Function0 & Serializable)() -> new SecureLinkConfigEncoder(kafkaConfig));
        Properties props = new Properties();
        linkConfig.originalsStrings().forEach((k, v) -> props.setProperty((String)k, (String)v));
        Properties encodedProps = encoder.encode(props);
        sensitiveConfigs.foreach((Function1 & Serializable)name -> {
            ClusterLinkConfigEncoderTest.$anonfun$verifyEncoding$3(linkConfig, encodedProps, name);
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.MapHasAsScala(linkConfig.originals()).asScala().keySet().diff(sensitiveConfigs).foreach((Function1 & Serializable)name -> {
            ClusterLinkConfigEncoderTest.$anonfun$verifyEncoding$4(linkConfig, encodedProps, name);
            return BoxedUnit.UNIT;
        });
        this.verifyDecoding(kafkaConfig, encodedProps, resolvedProps);
        return encodedProps;
    }

    private Option<SecureLinkConfigEncoder> verifyEncoding$default$5() {
        return None$.MODULE$;
    }

    private void verifyDecoding(KafkaConfig kafkaConfig, Properties encodedProps, Properties resolvedProps) {
        ClusterLinkConfig linkConfig = new SecureLinkConfigEncoder(kafkaConfig).clusterLinkConfig(encodedProps);
        Assertions.assertEquals((Object)resolvedProps, (Object)linkConfig.originals());
    }

    public static final /* synthetic */ void $anonfun$verifyEncoding$3(ClusterLinkConfig linkConfig$1, Properties encodedProps$1, String name) {
        Assertions.assertNotEquals(linkConfig$1.originals().get(name), (Object)encodedProps$1.getProperty(name));
    }

    public static final /* synthetic */ void $anonfun$verifyEncoding$4(ClusterLinkConfig linkConfig$1, Properties encodedProps$1, String name) {
        Assertions.assertEquals(linkConfig$1.originals().get(name), (Object)encodedProps$1.getProperty(name));
    }
}

