/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import kafka.server.link.AuthenticationErrorUnavailableLinkReason;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConnectionChecker$;
import kafka.server.link.ClusterLinkConnectionCheckerResult;
import kafka.server.link.InvalidBootstrapInternalEndpointUnavailableLinkReason;
import kafka.server.link.TimeoutUnavailableLinkReason;
import kafka.server.link.UnresolvableBootstrapUnavailableLinkReason;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000594AAF\f\u0001=!)Q\u0005\u0001C\u0001M!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0003BB\u001c\u0001A\u0003%1\u0006C\u00049\u0001\t\u0007I\u0011B\u001d\t\r\t\u0003\u0001\u0015!\u0003;\u0011\u001d\u0019\u0005A1A\u0005\neBa\u0001\u0012\u0001!\u0002\u0013Q\u0004bB#\u0001\u0005\u0004%I!\u000f\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\u001e\t\u000f\u001d\u0003!\u0019!C\u0005s!1\u0001\n\u0001Q\u0001\niBQ!\u0013\u0001\u0005\u0002)CQ!\u0017\u0001\u0005\u0002)CQA\u0018\u0001\u0005\u0002)CQ\u0001\u0019\u0001\u0005\u0002)CQA\u0019\u0001\u0005\u0002)CQ\u0001\u001a\u0001\u0005\u0002)CQA\u001a\u0001\u0005\u0002)CQ\u0001\u001b\u0001\u0005\u0002)CQA\u001b\u0001\u0005\u0002)CQ\u0001\u001c\u0001\u0005\u0002)\u0013\u0001e\u00117vgR,'\u000fT5oW\u000e{gN\\3di&|gn\u00115fG.,'\u000fV3ti*\u0011\u0001$G\u0001\u0005Y&t7N\u0003\u0002\u001b7\u000511/\u001a:wKJT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003]\tQ!\u00193nS:,\u0012a\u000b\t\u0003YUj\u0011!\f\u0006\u0003S9R!a\f\u0019\u0002\u000f\rd\u0017.\u001a8ug*\u0011A$\r\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014x-\u0003\u00027[\tq1i\u001c8gYV,g\u000e^!e[&t\u0017AB1e[&t\u0007%A\tfq\u0006l\u0007\u000f\\3Ve2\fe\u000e\u001a)peR,\u0012A\u000f\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nA\u0001\\1oO*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\u0019\u0019FO]5oO\u0006\u0011R\r_1na2,WK\u001d7B]\u0012\u0004vN\u001d;!\u0003M\u0019wN\u001c4mk\u0016tG/\u0016:m\u0003:$\u0007k\u001c:u\u0003Q\u0019wN\u001c4mk\u0016tG/\u0016:m\u0003:$\u0007k\u001c:uA\u0005\u0019Bn\\2bY\"|7\u000f^+sY\u0006sG\rU8si\u0006!Bn\\2bY\"|7\u000f^+sY\u0006sG\rU8si\u0002\nq\u0002\u001a8t\u0019>|7.\u00169D_:4\u0017nZ\u0001\u0011I:\u001cHj\\8l+B\u001cuN\u001c4jO\u0002\nQa]3ukB$\u0012a\u0013\t\u0003A1K!!T\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0019=\u0003\"\u0001U,\u000e\u0003ES!AU*\u0002\u0007\u0005\u0004\u0018N\u0003\u0002U+\u00069!.\u001e9ji\u0016\u0014(B\u0001,4\u0003\u0015QWO\\5u\u0013\tA\u0016K\u0001\u0006CK\u001a|'/Z#bG\"\fAb\u00195fG.\fE\u000e\u001c)bgND#!D.\u0011\u0005Ac\u0016BA/R\u0005\u0011!Vm\u001d;\u0002=Q,7\u000f^\"iK\u000e\\\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007F\u0001\b\\\u0003u!Xm\u001d;DQ\u0016\u001c7.Q;uQ>\u0014\u0018N_1uS>tg)Y5mkJ,\u0007FA\b\\\u0003A!Xm\u001d;US6,w.\u001e;FeJ|'\u000f\u000b\u0002\u00117\u0006!C/Z:u\t:\u001b&+Z:pYV$\u0018n\u001c8GC&dWO]3Ge>l7\t[3dW\u0006cG\u000e\u000b\u0002\u00127\u0006!B/Z:u\u0013:4\u0018\r\\5e\u0005>|Go\u001d;sCBD#AE.\u0002-Q,7\u000f^\"iK\u000e\\\u0017\t\u001a3sKN\u001cXm\u001d)bgND#aE.\u0002OQ,7\u000f^\"iK\u000e\\\u0017\t\u001a3sKN\u001cXm\u001d$bS2\u001chI]8n\u0013:$XM\u001d8bYB{'\u000f\u001e\u0015\u0003)m\u000bac\u00195fG.$6\r]\"p]:,7\r^5p]B\u000b7o\u001d\u0015\u0003+m\u0003")
public class ClusterLinkConnectionCheckerTest {
    private final ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final String exampleUrlAndPort;
    private final String confluentUrlAndPort;
    private final String localhostUrlAndPort;
    private final String dnsLookUpConfig;

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private String exampleUrlAndPort() {
        return this.exampleUrlAndPort;
    }

    private String confluentUrlAndPort() {
        return this.confluentUrlAndPort;
    }

    private String localhostUrlAndPort() {
        return this.localhostUrlAndPort;
    }

    private String dnsLookUpConfig() {
        return this.dnsLookUpConfig;
    }

    @BeforeEach
    public void setup() {
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
    }

    @Test
    public void checkAllPass() {
        DescribeClusterResult describeClusterResult = (DescribeClusterResult)Mockito.mock(DescribeClusterResult.class);
        KafkaFuture clusterId = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)this.admin().describeCluster((DescribeClusterOptions)ArgumentMatchers.any())).thenReturn((Object)describeClusterResult);
        Mockito.when((Object)describeClusterResult.clusterId()).thenReturn((Object)clusterId);
        Mockito.when((Object)clusterId.get()).thenReturn((Object)"123");
        Properties props = new Properties();
        props.put("bootstrap.servers", new StringBuilder(1).append(this.exampleUrlAndPort()).append(",").append(this.confluentUrlAndPort()).toString());
        props.put("client.dns.lookup", this.dnsLookUpConfig());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConnectionChecker$.MODULE$.checkAll((Admin)this.admin(), ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true)));
    }

    @Test
    public void testCheckAuthenticationFailure() {
        KafkaFutureImpl clusterIdFuture = new KafkaFutureImpl();
        clusterIdFuture.completeExceptionally((Throwable)new SaslAuthenticationException("Not authenticated"));
        DescribeClusterResult describeClusterResult = (DescribeClusterResult)Mockito.mock(DescribeClusterResult.class);
        Mockito.when((Object)describeClusterResult.clusterId()).thenReturn((Object)clusterIdFuture);
        Mockito.when((Object)this.admin().describeCluster((DescribeClusterOptions)ArgumentMatchers.any())).thenReturn((Object)describeClusterResult);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.localhostUrlAndPort());
        props.put("client.dns.lookup", this.dnsLookUpConfig());
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true);
        Assertions.assertEquals((Object)new AuthenticationErrorUnavailableLinkReason(linkConfig), (Object)((ClusterLinkConnectionCheckerResult)ClusterLinkConnectionChecker$.MODULE$.checkAll((Admin)this.admin(), linkConfig).get()).unavailableLinkReason());
    }

    @Test
    public void testCheckAuthorizationFailure() {
        KafkaFutureImpl clusterIdFuture = new KafkaFutureImpl();
        clusterIdFuture.completeExceptionally((Throwable)new ClusterAuthorizationException("Not authorized"));
        DescribeClusterResult describeClusterResult = (DescribeClusterResult)Mockito.mock(DescribeClusterResult.class);
        Mockito.when((Object)describeClusterResult.clusterId()).thenReturn((Object)clusterIdFuture);
        Mockito.when((Object)this.admin().describeCluster((DescribeClusterOptions)ArgumentMatchers.any())).thenReturn((Object)describeClusterResult);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.localhostUrlAndPort());
        props.put("client.dns.lookup", this.dnsLookUpConfig());
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true);
        Assertions.assertEquals((Object)new InvalidBootstrapInternalEndpointUnavailableLinkReason(linkConfig), (Object)((ClusterLinkConnectionCheckerResult)ClusterLinkConnectionChecker$.MODULE$.checkAll((Admin)this.admin(), linkConfig).get()).unavailableLinkReason());
    }

    @Test
    public void testTimeoutError() {
        KafkaFutureImpl clusterIdFuture = new KafkaFutureImpl();
        clusterIdFuture.completeExceptionally((Throwable)new TimeoutException("Timed out"));
        DescribeClusterResult describeClusterResult = (DescribeClusterResult)Mockito.mock(DescribeClusterResult.class);
        Mockito.when((Object)describeClusterResult.clusterId()).thenReturn((Object)clusterIdFuture);
        Mockito.when((Object)this.admin().describeCluster((DescribeClusterOptions)ArgumentMatchers.any())).thenReturn((Object)describeClusterResult);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.confluentUrlAndPort());
        props.put("client.dns.lookup", this.dnsLookUpConfig());
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true);
        Assertions.assertEquals((Object)new TimeoutUnavailableLinkReason(linkConfig), (Object)((ClusterLinkConnectionCheckerResult)ClusterLinkConnectionChecker$.MODULE$.checkAll((Admin)this.admin(), linkConfig).get()).unavailableLinkReason());
    }

    @Test
    public void testDNSResolutionFailureFromCheckAll() {
        KafkaFutureImpl clusterIdFuture = new KafkaFutureImpl();
        clusterIdFuture.completeExceptionally((Throwable)new TimeoutException());
        DescribeClusterResult describeClusterResult = (DescribeClusterResult)Mockito.mock(DescribeClusterResult.class);
        Mockito.when((Object)describeClusterResult.clusterId()).thenReturn((Object)clusterIdFuture);
        Mockito.when((Object)this.admin().describeCluster((DescribeClusterOptions)ArgumentMatchers.any())).thenReturn((Object)describeClusterResult);
        Properties props = new Properties();
        props.put("bootstrap.servers", "www.www.askjdbasdkjsad.com:9");
        props.put("client.dns.lookup", this.dnsLookUpConfig());
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true);
        Assertions.assertEquals((Object)new UnresolvableBootstrapUnavailableLinkReason(linkConfig), (Object)((ClusterLinkConnectionCheckerResult)ClusterLinkConnectionChecker$.MODULE$.checkAll((Admin)this.admin(), linkConfig).get()).unavailableLinkReason());
    }

    @Test
    public void testInvalidBootstrap() {
        KafkaFutureImpl clusterIdFuture = new KafkaFutureImpl();
        clusterIdFuture.completeExceptionally((Throwable)new TimeoutException());
        DescribeClusterResult describeClusterResult = (DescribeClusterResult)Mockito.mock(DescribeClusterResult.class);
        Mockito.when((Object)describeClusterResult.clusterId()).thenReturn((Object)clusterIdFuture);
        Mockito.when((Object)this.admin().describeCluster((DescribeClusterOptions)ArgumentMatchers.any())).thenReturn((Object)describeClusterResult);
        Properties props = new Properties();
        props.put("bootstrap.servers", "999.999.999.999:0000");
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true);
        Assertions.assertEquals((Object)new UnresolvableBootstrapUnavailableLinkReason(linkConfig), (Object)((ClusterLinkConnectionCheckerResult)ClusterLinkConnectionChecker$.MODULE$.checkAll((Admin)this.admin(), linkConfig).get()).unavailableLinkReason());
    }

    @Test
    public void testCheckAddressesPass() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.exampleUrlAndPort());
        props.put("client.dns.lookup", this.dnsLookUpConfig());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConnectionChecker$.MODULE$.checkAddresses(ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true))._1());
    }

    @Test
    public void testCheckAddressesFailsFromInternalPort() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:9071");
        props.put("client.dns.lookup", this.dnsLookUpConfig());
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true);
        InvalidBootstrapInternalEndpointUnavailableLinkReason expected = new InvalidBootstrapInternalEndpointUnavailableLinkReason(linkConfig);
        Assertions.assertEquals((Object)new Some((Object)expected), (Object)ClusterLinkConnectionChecker$.MODULE$.checkAddresses(linkConfig)._1());
    }

    @Test
    public void checkTcpConnectionPass() {
        ArrayList<InetSocketAddress> endpoints = new ArrayList<InetSocketAddress>();
        String hostname = this.exampleUrlAndPort().split(":")[0];
        int port = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.exampleUrlAndPort().split(":")[1]));
        endpoints.add(new InetSocketAddress(hostname, port));
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", new StringBuilder(1).append(hostname).append(":").append(port).toString());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConnectionChecker$.MODULE$.checkTcpConnection(endpoints, ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true)));
    }

    public ClusterLinkConnectionCheckerTest() {
        this.exampleUrlAndPort = "www.example.com:443";
        this.confluentUrlAndPort = "confluent.io:443";
        this.localhostUrlAndPort = "localhost:9092";
        this.dnsLookUpConfig = "use_all_dns_ips";
    }
}

