/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.MetadataCache;
import kafka.server.UnboundedClusterLinkRequestQuota$;
import kafka.server.link.ActiveTaskState$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConvertToMirrorTopicTaskType$;
import kafka.server.link.ClusterLinkConvertTopicToMirror;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNonBatchingAdmin;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.InErrorTaskState$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TaskState;
import kafka.server.link.TaskType;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.DescribeMirrorsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r}c\u0001\u0002-Z\u0001\u0001DQa\u001a\u0001\u0005\u0002!Dqa\u001b\u0001C\u0002\u0013%A\u000e\u0003\u0004v\u0001\u0001\u0006I!\u001c\u0005\bm\u0002\u0011\r\u0011\"\u0003m\u0011\u00199\b\u0001)A\u0005[\"9\u0001\u0010\u0001b\u0001\n\u0013I\bbBA\u0006\u0001\u0001\u0006IA\u001f\u0005\t\u0003\u001b\u0001!\u0019!C\u0005s\"9\u0011q\u0002\u0001!\u0002\u0013Q\b\"CA\t\u0001\t\u0007I\u0011BA\n\u0011!\tY\u0002\u0001Q\u0001\n\u0005U\u0001\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0011!\t9\u0003\u0001Q\u0001\n\u0005\u0005\u0002\"CA\u0015\u0001\t\u0007I\u0011BA\u0016\u0011!\t\u0019\u0004\u0001Q\u0001\n\u00055\u0002\"CA\u001b\u0001\t\u0007I\u0011BA\u001c\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005e\u0002\"CA#\u0001\t\u0007I\u0011BA\u001c\u0011!\t9\u0005\u0001Q\u0001\n\u0005e\u0002\"CA%\u0001\t\u0007I\u0011BA&\u0011!\t\u0019\u0006\u0001Q\u0001\n\u00055\u0003\"CA+\u0001\t\u0007I\u0011BA,\u0011!\ty\u0006\u0001Q\u0001\n\u0005e\u0003\"CA1\u0001\t\u0007I\u0011BA2\u0011!\tY\u0007\u0001Q\u0001\n\u0005\u0015\u0004\"CA7\u0001\t\u0007I\u0011BA8\u0011!\t\t\t\u0001Q\u0001\n\u0005E\u0004\"CAB\u0001\t\u0007I\u0011BA2\u0011!\t)\t\u0001Q\u0001\n\u0005\u0015\u0004\"CAD\u0001\t\u0007I\u0011BAE\u0011!\tI\u000b\u0001Q\u0001\n\u0005-\u0005\"CAV\u0001\t\u0007I\u0011BAW\u0011!\t9\f\u0001Q\u0001\n\u0005=\u0006\"CA]\u0001\t\u0007I\u0011BA^\u0011!\t\u0019\r\u0001Q\u0001\n\u0005u\u0006\"CAc\u0001\t\u0007I\u0011BAd\u0011!\t)\u000e\u0001Q\u0001\n\u0005%\u0007bCAl\u0001\u0001\u0007\t\u0019!C\u0005\u00033D1\"!9\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002d\"Y\u0011q\u001e\u0001A\u0002\u0003\u0005\u000b\u0015BAn\u0011\u001d\t\t\u0010\u0001C\u0001\u0003gDqAa\u0003\u0001\t\u0003\t\u0019\u0010C\u0004\u0003\u0016\u0001!\t!a=\t\u000f\t}\u0001\u0001\"\u0001\u0002t\"9!1\u0005\u0001\u0005\u0002\u0005M\bb\u0002B\u0014\u0001\u0011\u0005\u00111\u001f\u0005\b\u0005W\u0001A\u0011AAz\u0011\u001d\u0011y\u0003\u0001C\u0001\u0003gDqAa\r\u0001\t\u0003\t\u0019\u0010C\u0004\u00038\u0001!\t!a=\t\u000f\tm\u0002\u0001\"\u0001\u0002t\"9!q\b\u0001\u0005\u0002\u0005M\bb\u0002B\"\u0001\u0011\u0005\u00111\u001f\u0005\b\u0005\u000f\u0002A\u0011AAz\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0003gDqAa\u0014\u0001\t\u0003\t\u0019\u0010C\u0004\u0003T\u0001!\t!a=\t\u000f\t]\u0003\u0001\"\u0001\u0002t\"9!1\f\u0001\u0005\u0002\u0005M\bb\u0002B0\u0001\u0011\u0005\u00111\u001f\u0005\b\u0005G\u0002A\u0011AAz\u0011\u001d\u00119\u0007\u0001C\u0001\u0003gDqAa\u001b\u0001\t\u0003\t\u0019\u0010C\u0004\u0003p\u0001!I!a=\t\u000f\tE\u0004\u0001\"\u0003\u0003t!9!1\u0010\u0001\u0005\n\tM\u0004b\u0002B?\u0001\u0011%!q\u0010\u0005\b\u0005\u000f\u0003A\u0011\u0002B:\u0011\u001d\u0011I\t\u0001C\u0005\u0005gBqAa#\u0001\t\u0013\u0011i\tC\u0004\u0003\u001a\u0002!IAa'\t\u000f\t}\u0005\u0001\"\u0003\u0002t\"9!\u0011\u0015\u0001\u0005\n\t\r\u0006b\u0002B\\\u0001\u0011%!\u0011\u0018\u0005\b\u0005{\u0003A\u0011\u0002B`\u0011\u001d\u0011\u0019\r\u0001C\u0005\u0005\u000bDqAa6\u0001\t\u0013\u0011I\u000eC\u0004\u0003^\u0002!IAa8\t\u000f\t-\b\u0001\"\u0003\u0003n\"9!1\u001f\u0001\u0005\n\tU\bbBB\u0006\u0001\u0011%\u00111\u001f\u0005\b\u0007\u001b\u0001A\u0011BB\b\u0011\u001d\u0019I\u0002\u0001C\u0005\u00077Aqaa\b\u0001\t\u0013\u0019\t\u0003C\u0005\u0004<\u0001\t\n\u0011\"\u0003\u0004>!I11\u000b\u0001\u0012\u0002\u0013%1Q\u000b\u0005\n\u00073\u0002\u0011\u0013!C\u0005\u00077\u00121e\u00117vgR,'\u000fT5oW\u000e{gN^3siR{\u0007/[2U_6K'O]8s)\u0016\u001cHO\u0003\u0002[7\u0006!A.\u001b8l\u0015\taV,\u0001\u0004tKJ4XM\u001d\u0006\u0002=\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001b!\t\u0011W-D\u0001d\u0015\u0005!\u0017!B:dC2\f\u0017B\u00014d\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u001b\t\u0003U\u0002i\u0011!W\u0001\u0006i>\u0004\u0018nY\u000b\u0002[B\u0011an]\u0007\u0002_*\u0011\u0001/]\u0001\u0005Y\u0006twMC\u0001s\u0003\u0011Q\u0017M^1\n\u0005Q|'AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\tY&t7NT1nK\u0006IA.\u001b8l\u001d\u0006lW\rI\u0001\u0007Y&t7.\u00133\u0016\u0003i\u00042a_A\u0004\u001b\u0005a(BA?\u007f\u0003\u0019\u0019w.\\7p]*\u0011al \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000b\t1a\u001c:h\u0013\r\tI\u0001 \u0002\u0005+VLG-A\u0004mS:\\\u0017\n\u001a\u0011\u0002\u001bM|WO]2f)>\u0004\u0018nY%e\u00039\u0019x.\u001e:dKR{\u0007/[2JI\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\u0005U\u0001c\u00016\u0002\u0018%\u0019\u0011\u0011D-\u0003)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u000eG2LWM\u001c;NC:\fw-\u001a:\u0016\u0005\u0005\u0005\u0002c\u00016\u0002$%\u0019\u0011QE-\u00039\rcWo\u001d;fe2Kgn\u001b#fgR\u001cE.[3oi6\u000bg.Y4fe\u0006q1\r\\5f]Rl\u0015M\\1hKJ\u0004\u0013aB7fiJL7m]\u000b\u0003\u0003[\u00012A[A\u0018\u0013\r\t\t$\u0017\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u00031\t7\r^5wKN+gn]8s+\t\tI\u0004\u0005\u0003\u0002<\u0005}RBAA\u001f\u0015\r\tI\u0003`\u0005\u0005\u0003\u0003\niD\u0001\u0004TK:\u001cxN]\u0001\u000eC\u000e$\u0018N^3TK:\u001cxN\u001d\u0011\u0002\u001b%tWI\u001d:peN+gn]8s\u00039Ig.\u0012:s_J\u001cVM\\:pe\u0002\nq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0003\u0003\u001b\u00022A[A(\u0013\r\t\t&\u0017\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0011[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\n1\u0004\\8dC2\u001cE.^:uKJd\u0015N\\6BI6Lgn\u00117jK:$XCAA-!\rQ\u00171L\u0005\u0004\u0003;J&!F\"mkN$XM\u001d'j].dunY1m\u0003\u0012l\u0017N\\\u0001\u001dY>\u001c\u0017\r\\\"mkN$XM\u001d'j].\fE-\\5o\u00072LWM\u001c;!\u0003=awnY1m\u0005\u0006$8\r[!e[&tWCAA3!\rQ\u0017qM\u0005\u0004\u0003SJ&!F\"mkN$XM\u001d'j].\u0014\u0015\r^2i\u0003\u0012l\u0017N\\\u0001\u0011Y>\u001c\u0017\r\u001c\"bi\u000eD\u0017\tZ7j]\u0002\n1B]3n_R,\u0017\tZ7j]V\u0011\u0011\u0011\u000f\t\u0005\u0003g\ni(\u0004\u0002\u0002v)!\u0011qOA=\u0003\u0015\tG-\\5o\u0015\r\tYH`\u0001\bG2LWM\u001c;t\u0013\u0011\ty(!\u001e\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u0006a!/Z7pi\u0016\fE-\\5oA\u0005\u0001\"/Z7pi\u0016\u0014\u0015\r^2i\u0003\u0012l\u0017N\\\u0001\u0012e\u0016lw\u000e^3CCR\u001c\u0007.\u00113nS:\u0004\u0013A\u00039beRLG/[8ogV\u0011\u00111\u0012\t\u0007\u0003\u001b\u000bi*a)\u000f\t\u0005=\u0015\u0011\u0014\b\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011QS0\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0017bAANG\u00069\u0001/Y2lC\u001e,\u0017\u0002BAP\u0003C\u0013A\u0001T5ti*\u0019\u00111T2\u0011\u0007m\f)+C\u0002\u0002(r\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0006qCJ$\u0018\u000e^5p]N\u0004\u0013!D7fi\u0006$\u0017\r^1DC\u000eDW-\u0006\u0002\u00020B!\u0011\u0011WAZ\u001b\u0005Y\u0016bAA[7\niQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fa\"\\3uC\u0012\fG/Y\"bG\",\u0007%A\u0003rk>$\u0018-\u0006\u0002\u0002>B!\u0011\u0011WA`\u0013\r\t\tm\u0017\u0002\u0018\u00072,8\u000f^3s\u0019&t7NU3rk\u0016\u001cH/U;pi\u0006\fa!];pi\u0006\u0004\u0013\u0001\u0002;j[\u0016,\"!!3\u0011\t\u0005-\u0017\u0011[\u0007\u0003\u0003\u001bT1!a4}\u0003\u0015)H/\u001b7t\u0013\u0011\t\u0019.!4\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0015G>tg/\u001a:u)>l\u0015N\u001d:peR{\u0007/[2\u0016\u0005\u0005m\u0007c\u00016\u0002^&\u0019\u0011q\\-\u0003?\rcWo\u001d;fe2Kgn[\"p]Z,'\u000f\u001e+pa&\u001cGk\\'jeJ|'/\u0001\rd_:4XM\u001d;U_6K'O]8s)>\u0004\u0018nY0%KF$B!!:\u0002lB\u0019!-a:\n\u0007\u0005%8M\u0001\u0003V]&$\b\"CAwO\u0005\u0005\t\u0019AAn\u0003\rAH%M\u0001\u0016G>tg/\u001a:u)>l\u0015N\u001d:peR{\u0007/[2!\u0003\u0015\u0019X\r^+q)\t\t)\u000fK\u0002*\u0003o\u0004B!!?\u0003\b5\u0011\u00111 \u0006\u0005\u0003{\fy0A\u0002ba&TAA!\u0001\u0003\u0004\u00059!.\u001e9ji\u0016\u0014(\u0002\u0002B\u0003\u0003\u0007\tQA[;oSRLAA!\u0003\u0002|\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3A\u000bB\b!\u0011\tIP!\u0005\n\t\tM\u00111 \u0002\n\u0003\u001a$XM]#bG\"\f\u0001\u0006^3ti\u000ecWo\u001d;fe2Kgn[\"p]Z,'\u000f\u001e+p'R\f'\u000f^'jeJ|'\u000fV8qS\u000eD3a\u000bB\r!\u0011\tIPa\u0007\n\t\tu\u00111 \u0002\u0005)\u0016\u001cH/\u0001\u0015uKN$8\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg/\u001a:u)>\u0004\u0016-^:f\u001b&\u0014(o\u001c:U_BL7\rK\u0002-\u00053\t\u0001\b^3ti\u000ecWo\u001d;fe2Kgn[\"p]Z,'\u000f\u001e+p'R\f'\u000f^'jeJ|'\u000fV8qS\u000e<\u0016\u000e\u001e5EK2,G/\u001a3U_BL7\rK\u0002.\u00053\tA\b^3ti\u000ecWo\u001d;fe2Kgn[\"p]Z,'\u000f\u001e+p'R\f'\u000f^'jeJ|'\u000fV8qS\u000e<\u0016\u000e\u001e5V]N,\b\u000f]8si\u0016$7\u000b^1uK\"\u001aaF!\u0007\u0002iQ,7\u000f^\"mkN$XM\u001d'j].\u001cuN\u001c<feR$v.T5se>\u0014Hk\u001c9jG^KG\u000f\u001b(p\u001b&\u0014(o\u001c:Ti\u0006$X\rK\u00020\u00053\t\u0001\t^3ti\u000ecWo\u001d;fe2Kgn[\"p]Z,'\u000f\u001e+p'R\f'\u000f^'jeJ|'\u000fV8qS\u000e<\u0016\u000e\u001e5Ok2dGk\u001c9jG\u0012+7o\u0019:jaRLwN\u001c\u0015\u0004a\te\u0011\u0001\u0014;fgR\u001cE.^:uKJd\u0015N\\6D_:4XM\u001d;U_N#\u0018M\u001d;NSJ\u0014xN\u001d+pa&\u001cw+\u001b;i\u0013:\u001cwN\u001d:fGR$v\u000e]5d\u0013\u0012$v\u000e]5d\t\u0016\u001c8M]5qi&|g\u000eK\u00022\u00053\tq\u000b^3ti\u000ecWo\u001d;fe2Kgn[\"p]Z,'\u000f\u001e+p'R\f'\u000f^'jeJ|'\u000fV8qS\u000e<\u0016\u000e\u001e5J]\u000e|'O]3di:+XNY3s\u001f\u001a\u0004\u0016M\u001d;ji&|gn\u001d+pa&\u001cG)Z:de&\u0004H/[8oQ\r\u0011$\u0011D\u0001Ii\u0016\u001cHo\u00117vgR,'\u000fT5oW\u000e{gN^3siR{7\u000b^1si6K'O]8s)>\u0004\u0018nY,ji\"\u001cv.\u001e:dKR{\u0007/[2NSJ\u0014xN]*uCR,8\u000fR3mCfD3a\rB\r\u0003\r#Xm\u001d;DYV\u001cH/\u001a:MS:\\7i\u001c8wKJ$Hk\\*uCJ$X*\u001b:s_J$v\u000e]5d/&$\bNT;mY6K'O]8s)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018NY3)\u0007Q\u0012I\"A(uKN$8\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg/\u001a:u)>\u001cF/\u0019:u\u001b&\u0014(o\u001c:U_BL7mV5uQN{WO]2f)>\u0004\u0018nY'jeJ|'oQ8o]\u0016\u001cG/\u001b<jifL5o];fg\"\u001aQG!\u0007\u0002\u0017R,7\u000f^\"mkN$XM\u001d'j].\u001cuN\u001c<feR$vn\u0015;beRl\u0015N\u001d:peR{\u0007/[2XSRD7k\\;sG\u0016$v\u000e]5d\u001b&\u0014(o\u001c:J]\u000e|'O]3diN#\u0018\r^3)\u0007Y\u0012I\"\u0001!uKN$8\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg/\u001a:u)>\u001cF/\u0019:u\u001b&\u0014(o\u001c:U_BL7mV5uQVs7/\u001e9q_J$X\r\u001a(fqR\u001cF/\u0019;fQ\r9$\u0011D\u0001Si\u0016\u001cHo\u00117vgR,'\u000fT5oW\u000e{gN^3siR{7\u000b^1si6K'O]8s)>\u0004\u0018nY,ji\",\u0005pY3qi&|g.\u00138GkR,(/Z%o'>,(oY3U_BL7\rR3tGJL'-\u001a\u0015\u0004q\te\u0011A\u0013;fgR\u001cE.^:uKJd\u0015N\\6D_:4XM\u001d;U_N#\u0018M\u001d;NSJ\u0014xN\u001d+pa&\u001cw+\u001b;i\u000bb\u001cW\r\u001d;j_:LenU8ve\u000e,Gk\u001c9jG\u0012+7o\u0019:jE\u0016D3!\u000fB\r\u0003A#Xm\u001d;DYV\u001cH/\u001a:MS:\\7i\u001c8wKJ$Hk\\*uCJ$X*\u001b:s_J$v\u000e]5d/&$\b.\u0012=dKB$\u0018n\u001c8J]\u001a+H/\u001e:f\u0013:l\u0015N\u001d:peN#\u0018\r^;t\u0007\",7m\u001b\u0015\u0004u\te\u0011\u0001\u0013;fgR\u001cE.^:uKJd\u0015N\\6D_:4XM\u001d;U_N#\u0018M\u001d;NSJ\u0014xN\u001d+pa&\u001cw+\u001b;i\u000bb\u001cW\r\u001d;j_:Le.T5se>\u00148\u000b^1ukN\u001c\u0005.Z2lQ\rY$\u0011D\u0001Pi\u0016\u001cHo\u00117vgR,'\u000fT5oW\u000e{gN^3siR{7\u000b^1si6K'O]8s)>\u0004\u0018nY,ji\",\u0005pY3qi&|g.\u00138GkR,(/Z%o\u001b&\u0014(o\u001c:D_:4XM]:j_:D3\u0001\u0010B\r\u0003=#Xm\u001d;DYV\u001cH/\u001a:MS:\\7i\u001c8wKJ$Hk\u001c)bkN,W*\u001b:s_J$v\u000e]5d/&$\b.\u0012=dKB$\u0018n\u001c8J]\u001a+H/\u001e:f\u0013:l\u0015N\u001d:pe\u000e{gN^3sg&|g\u000eK\u0002>\u00053\tq\t^3ti\u000ecWo\u001d;fe2Kgn[\"p]Z,'\u000f\u001e+p'R\f'\u000f^'jeJ|'\u000fV8qS\u000e<\u0016\u000e\u001e5Fq\u000e,\u0007\u000f^5p]&sW*\u001b:s_J\u001cuN\u001c<feNLwN\u001c\u0015\u0004}\te\u0011a\u0012;fgR\u001cE.^:uKJd\u0015N\\6D_:4XM\u001d;U_B\u000bWo]3NSJ\u0014xN\u001d+pa&\u001cw+\u001b;i\u000bb\u001cW\r\u001d;j_:Le.T5se>\u00148i\u001c8wKJ\u001c\u0018n\u001c8)\u0007}\u0012I\"A\fn_\u000e\\7k\\;sG\u0016$v\u000e]5d\t\u0016\u001c8M]5cK\u0006ARn\\2l\t\u0016\u001c8M]5cKR{\u0007/[2t%\u0016\u001cX\u000f\u001c;\u0015\u0005\tU\u0004\u0003BA:\u0005oJAA!\u001f\u0002v\t!B)Z:de&\u0014W\rV8qS\u000e\u001c(+Z:vYR\f\u0001D\\;mY\u0012+7o\u0019:jE\u0016$v\u000e]5dgJ+7/\u001e7u\u0003aqW\u000f\u001c7NSJ\u0014xN\u001d#fg\u000e\u0014\u0018NY3SKN,H\u000e\u001e\u000b\u0003\u0005\u0003\u0003B!a\u001d\u0003\u0004&!!QQA;\u0005U!Um]2sS\n,W*\u001b:s_J\u001c(+Z:vYR\fA%\u001b8d_J\u0014Xm\u0019;U_BL7-\u00133EKN\u001c'/\u001b2f)>\u0004\u0018nY:SKN,H\u000e^\u00010S:\u001cwN\u001d:fGRtU/\u001c2fe>3\u0007+\u0019:uSRLwN\\:EKN\u001c'/\u001b2f)>\u0004\u0018nY:SKN,H\u000e^\u0001-[>\u001c7nU8ve\u000e,Gk\u001c9jG\u0012+7o\u0019:jE\u0016<\u0016\u000e\u001e5Fq\u000e,\u0007\u000f^5p]&sg)\u001e;ve\u0016$B!!:\u0003\u0010\"9!\u0011\u0013$A\u0002\tM\u0015!A3\u0011\t\u00055%QS\u0005\u0005\u0005/\u000b\tKA\u0005UQJ|w/\u00192mK\u0006!Sn\\2l'>,(oY3U_BL7\rR3tGJL'-Z,ji\",\u0005pY3qi&|g\u000e\u0006\u0003\u0002f\nu\u0005b\u0002BI\u000f\u0002\u0007!1S\u0001\u001f[>\u001c7n\u0015;paB,G-T5se>\u0014Hk\u001c9jG\u0012+7o\u0019:jE\u0016\f\u0011$\\8dW\u0012+7o\u0019:jE\u0016l\u0015N\u001d:peN\u0014Vm];miR!!\u0011\u0011BS\u0011\u001d\u00119+\u0013a\u0001\u0005S\u000b1\"\\5se>\u00148\u000b^1uKB!!1\u0016BY\u001d\u0011\t\u0019H!,\n\t\t=\u0016QO\u0001\u0017\u001b&\u0014(o\u001c:U_BL7\rR3tGJL\u0007\u000f^5p]&!!1\u0017B[\u0005\u0015\u0019F/\u0019;f\u0015\u0011\u0011y+!\u001e\u0002Y5|7m['jeJ|'\u000fV8qS\u000e$Um]2sS\n,w+\u001b;i\u000bb\u001cW\r\u001d;j_:LeNR;ukJ,G\u0003BAs\u0005wCqA!%K\u0001\u0004\u0011\u0019*\u0001\u0013n_\u000e\\W*\u001b:s_J$v\u000e]5d\t\u0016\u001c8M]5cK^KG\u000f[#yG\u0016\u0004H/[8o)\u0011\t)O!1\t\u000f\tE5\n1\u0001\u0003\u0014\u0006aR.\u001b:s_J$v\u000e]5d\t\u0016\u001c8M]5qi&|gNR;ukJ,G\u0003\u0002Bd\u0005'\u0004Ra\u001fBe\u0005\u001bL1Aa3}\u0005-Y\u0015MZ6b\rV$XO]3\u0011\t\u0005M$qZ\u0005\u0005\u0005#\f)H\u0001\fNSJ\u0014xN\u001d+pa&\u001cG)Z:de&\u0004H/[8o\u0011\u001d\u0011)\u000e\u0014a\u0001\u0005\u001b\fa#\\5se>\u0014Hk\u001c9jG\u0012+7o\u0019:jaRLwN\\\u0001,[&\u0014(o\u001c:U_BL7\rR3tGJL\u0007\u000f^5p]^KG\u000f[#yG\u0016\u0004H/[8o\u0013:4U\u000f^;sKR!!q\u0019Bn\u0011\u001d\u0011\t*\u0014a\u0001\u0005'\u000bQ$\\8dWN#\u0018M\u001d;PeB\u000bWo]3QK:$\u0017N\\4NSJ\u0014xN\u001d\u000b\u0005\u0003K\u0014\t\u000fC\u0004\u0003d:\u0003\rA!:\u0002#MDw.\u001e7e'R\f'\u000f^'jeJ|'\u000fE\u0002c\u0005OL1A!;d\u0005\u001d\u0011un\u001c7fC:\f!'\\8dWN#\u0018M\u001d;PeB\u000bWo]3QK:$\u0017N\\4NSJ\u0014xN],ji\",\u0005pY3qi&|g.\u00138GkR,(/\u001a\u000b\u0007\u0003K\u0014yO!=\t\u000f\t\rx\n1\u0001\u0003f\"9!\u0011S(A\u0002\tM\u0015AK7pG.\u001cF/\u0019:u\u001fJ\u0004\u0016-^:f!\u0016tG-\u001b8h\u001b&\u0014(o\u001c:XSRDW\t_2faRLwN\u001c\u000b\t\u0003K\u00149P!?\u0003|\"9!1\u001d)A\u0002\t\u0015\bb\u0002BI!\u0002\u0007!1\u0013\u0005\u0007WB\u0003\rA!@\u0011\t\t}8q\u0001\b\u0005\u0007\u0003\u0019\u0019\u0001E\u0002\u0002\u0012\u000eL1a!\u0002d\u0003\u0019\u0001&/\u001a3fM&\u0019Ao!\u0003\u000b\u0007\r\u00151-\u0001\bn_\u000e\\g)Y5m\u001b&\u0014(o\u001c:\u0002%\u0005dG/\u001a:NSJ\u0014xN]:GkR,(/\u001a\u000b\u0003\u0007#\u0001Ra\u001fBe\u0007'\u00012A\\B\u000b\u0013\r\u00199b\u001c\u0002\u0005->LG-A\u0010bYR,'/T5se>\u00148OR;ukJ,w+\u001b;i\u000bb\u001cW\r\u001d;j_:$Ba!\u0005\u0004\u001e!9!\u0011S*A\u0002\tM\u0015\u0001E1tg\u0016\u0014HoQ8na2,G/[8o)!\t)oa\t\u0004(\rE\u0002\"CB\u0013)B\u0005\t\u0019\u0001Bs\u00035)\u0007\u0010]3di\u0016$g+\u00197vK\"I1\u0011\u0006+\u0011\u0002\u0003\u000711F\u0001\u0012Kb\u0004Xm\u0019;fI\u0016C8-\u001a9uS>t\u0007#\u00022\u0004.\tM\u0015bAB\u0018G\n1q\n\u001d;j_:D\u0011ba\rU!\u0003\u0005\ra!\u000e\u0002!\u0015D\b/Z2uK\u0012$\u0016m]6EKN\u001c\u0007c\u00016\u00048%\u00191\u0011H-\u0003\u001fQ\u000b7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:\f!$Y:tKJ$8i\\7qY\u0016$\u0018n\u001c8%I\u00164\u0017-\u001e7uIE*\"aa\u0010+\t\t\u00158\u0011I\u0016\u0003\u0007\u0007\u0002Ba!\u0012\u0004P5\u00111q\t\u0006\u0005\u0007\u0013\u001aY%A\u0005v]\u000eDWmY6fI*\u00191QJ2\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004R\r\u001d#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Q\u0012m]:feR\u001cu.\u001c9mKRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u000b\u0016\u0005\u0007W\u0019\t%\u0001\u000ebgN,'\u000f^\"p[BdW\r^5p]\u0012\"WMZ1vYR$3'\u0006\u0002\u0004^)\"1QGB!\u0001")
public class ClusterLinkConvertTopicToMirrorTest {
    private final String topic;
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler(0, 100);
    private final ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
    private final ClusterLinkMetrics metrics = (ClusterLinkMetrics)Mockito.mock(ClusterLinkMetrics.class);
    private final Sensor activeSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor inErrorSensor = (Sensor)Mockito.mock(Sensor.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final ClusterLinkLocalAdmin localClusterLinkAdminClient = (ClusterLinkLocalAdmin)Mockito.mock(ClusterLinkLocalAdmin.class);
    private final ClusterLinkBatchAdmin localBatchAdmin = new ClusterLinkNonBatchingAdmin((Function0 & Serializable)() -> this.localClusterLinkAdminClient());
    private final ConfluentAdmin remoteAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkBatchAdmin remoteBatchAdmin = new ClusterLinkNonBatchingAdmin((Function0 & Serializable)() -> this.remoteAdmin());
    private final List<TopicPartition> partitions = new .colon.colon((Object)new TopicPartition(this.topic(), 0), (List)new .colon.colon((Object)new TopicPartition(this.topic(), 1), (List)Nil$.MODULE$));
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final ClusterLinkRequestQuota quota = UnboundedClusterLinkRequestQuota$.MODULE$;
    private final Time time = new MockTime();
    private ClusterLinkConvertTopicToMirror convertToMirrorTopic;

    private String topic() {
        return this.topic;
    }

    private String linkName() {
        return this.linkName;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private Sensor activeSensor() {
        return this.activeSensor;
    }

    private Sensor inErrorSensor() {
        return this.inErrorSensor;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkLocalAdmin localClusterLinkAdminClient() {
        return this.localClusterLinkAdminClient;
    }

    private ClusterLinkBatchAdmin localBatchAdmin() {
        return this.localBatchAdmin;
    }

    private ConfluentAdmin remoteAdmin() {
        return this.remoteAdmin;
    }

    private ClusterLinkBatchAdmin remoteBatchAdmin() {
        return this.remoteBatchAdmin;
    }

    private List<TopicPartition> partitions() {
        return this.partitions;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private ClusterLinkRequestQuota quota() {
        return this.quota;
    }

    private Time time() {
        return this.time;
    }

    private ClusterLinkConvertTopicToMirror convertToMirrorTopic() {
        return this.convertToMirrorTopic;
    }

    private void convertToMirrorTopic_$eq(ClusterLinkConvertTopicToMirror x$1) {
        this.convertToMirrorTopic = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        Mockito.reset((Object[])new ClusterLinkDestClientManager[]{this.clientManager()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.reset((Object[])new ConfluentAdmin[]{this.remoteAdmin()});
        Mockito.reset((Object[])new ClusterLinkMetrics[]{this.metrics()});
        Mockito.reset((Object[])new Sensor[]{this.activeSensor()});
        Mockito.reset((Object[])new Sensor[]{this.inErrorSensor()});
        Mockito.when((Object)this.metrics().clusterLinkTaskActiveSensor((TaskType)ClusterLinkConvertToMirrorTopicTaskType$.MODULE$)).thenReturn((Object)this.activeSensor());
        Mockito.when((Object)this.metrics().clusterLinkTaskInErrorSensor((TaskType)ClusterLinkConvertToMirrorTopicTaskType$.MODULE$, (TaskErrorCode)InternalTaskErrorCode$.MODULE$)).thenReturn((Object)this.inErrorSensor());
        Mockito.when((Object)this.metrics().clusterLinkTaskInErrorSensor((TaskType)ClusterLinkConvertToMirrorTopicTaskType$.MODULE$, (TaskErrorCode)BrokerAuthorizationTaskErrorCode$.MODULE$)).thenReturn((Object)this.inErrorSensor());
        Mockito.when((Object)this.metrics().clusterLinkTaskInErrorSensor((TaskType)ClusterLinkConvertToMirrorTopicTaskType$.MODULE$, (TaskErrorCode)AuthorizationTaskErrorCode$.MODULE$)).thenReturn((Object)this.inErrorSensor());
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().metadataManager()).thenReturn((Object)this.metadataManager());
        Mockito.when((Object)this.clientManager().metrics()).thenReturn((Object)this.metrics());
        Mockito.when((Object)this.metadataManager().topicPartitions(this.topic())).thenReturn((Object)this.partitions().toSet());
        Mockito.when((Object)this.metadataManager().metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)this.clientManager().getAdmin()).thenReturn((Object)this.remoteAdmin());
        this.convertToMirrorTopic_$eq(new ClusterLinkConvertTopicToMirror(this.topic(), this.clientManager(), this.remoteBatchAdmin(), this.localBatchAdmin(), this.time(), this.quota(), 100));
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopic() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap);
        this.mockSourceTopicDescribe();
        this.mockStoppedMirrorTopicDescribe();
        this.mockStartOrPausePendingMirror(true);
        this.assertCompletion(true, (Option<Throwable>)None$.MODULE$, this.assertCompletion$default$3());
    }

    @Test
    public void testClusterLinkConvertToPauseMirrorTopic() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.PAUSED.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap);
        this.mockSourceTopicDescribe();
        this.mockStoppedMirrorTopicDescribe();
        this.mockStartOrPausePendingMirror(false);
        this.assertCompletion(true, (Option<Throwable>)None$.MODULE$, this.assertCompletion$default$3());
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithDeletedTopic() {
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.when((Object)this.metadataManager().topicPartitions(this.topic())).thenReturn((Object)Predef$.MODULE$.Set().empty());
        this.assertCompletion(true, (Option<Throwable>)None$.MODULE$, this.assertCompletion$default$3());
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithUnsupportedState() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        scala.collection.immutable.Map mirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)mirrorTopicMap);
        this.assertCompletion(true, (Option<Throwable>)None$.MODULE$, this.assertCompletion$default$3());
    }

    @Test
    public void testClusterLinkConvertToMirrorTopicWithNoMirrorState() {
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)Predef$.MODULE$.Map().empty());
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithNullTopicDescription() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap, (Object[])new Map[]{pendingMirrorTopicMap});
        Mockito.when((Object)this.remoteAdmin().describeTopics((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)this.nullDescribeTopicsResult());
        this.assertCompletion(false, (Option<Throwable>)None$.MODULE$, this.assertCompletion$default$3());
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithIncorrectTopicIdTopicDescription() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap, (Object[])new Map[]{pendingMirrorTopicMap});
        Mockito.when((Object)this.remoteAdmin().describeTopics((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)this.incorrectTopicIdDescribeTopicsResult());
        this.mockFailMirror();
        None$ x$1 = None$.MODULE$;
        TaskDescription x$2 = new TaskDescription((TaskState)ActiveTaskState$.MODULE$, (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
        boolean x$3 = true;
        this.assertCompletion(x$3, (Option<Throwable>)x$1, x$2);
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithIncorrectNumberOfPartitionsTopicDescription() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap, (Object[])new Map[]{pendingMirrorTopicMap});
        Mockito.when((Object)this.remoteAdmin().describeTopics((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)this.incorrectNumberOfPartitionsDescribeTopicsResult());
        this.assertCompletion(false, (Option<Throwable>)None$.MODULE$, this.assertCompletion$default$3());
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithSourceTopicMirrorStatusDelay() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap, (Object[])new Map[]{pendingMirrorTopicMap});
        Mockito.when((Object)this.remoteAdmin().describeTopics((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockDescribeTopicsResult(), (Object[])new DescribeTopicsResult[]{this.mockDescribeTopicsResult()});
        Mockito.when((Object)this.remoteAdmin().describeMirrors((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockDescribeMirrorsResult(MirrorTopicDescription.State.PENDING_STOPPED), (Object[])new DescribeMirrorsResult[]{this.mockDescribeMirrorsResult(MirrorTopicDescription.State.STOPPED)});
        this.mockStartOrPausePendingMirror(true);
        this.assertCompletion(false, (Option<Throwable>)None$.MODULE$, new TaskDescription((TaskState)InErrorTaskState$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Source topic is not yet in STOPPED mirror state. Will retry task in 100 ms."), (List)Nil$.MODULE$)));
        this.assertCompletion(true, (Option<Throwable>)None$.MODULE$, this.assertCompletion$default$3());
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithNullMirrorTopicDescribe() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap);
        this.mockSourceTopicDescribe();
        Mockito.when((Object)this.remoteAdmin().describeMirrors((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)this.nullMirrorDescribeResult());
        this.assertCompletion(false, (Option<Throwable>)None$.MODULE$, new TaskDescription((TaskState)InErrorTaskState$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Source mirror topic description is null, may be stale metadata. Will retry in 100"), (List)Nil$.MODULE$)));
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithSourceTopicMirrorConnectivityIssues() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap, (Object[])new Map[]{pendingMirrorTopicMap});
        Mockito.when((Object)this.remoteAdmin().describeTopics((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockDescribeTopicsResult(), (Object[])new DescribeTopicsResult[]{this.mockDescribeTopicsResult()});
        Mockito.when((Object)this.remoteAdmin().describeMirrors((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockDescribeMirrorsResult(MirrorTopicDescription.State.SOURCE_UNAVAILABLE), (Object[])new DescribeMirrorsResult[]{this.mockDescribeMirrorsResult(MirrorTopicDescription.State.STOPPED)});
        this.mockStartOrPausePendingMirror(true);
        this.assertCompletion(false, (Option<Throwable>)None$.MODULE$, new TaskDescription((TaskState)InErrorTaskState$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Source topic may have some issues with its link configuration. Will retry task in 100 ms."), (List)Nil$.MODULE$)));
        this.assertCompletion(true, (Option<Throwable>)None$.MODULE$, this.assertCompletion$default$3());
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithSourceTopicMirrorIncorrectState() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap);
        Mockito.when((Object)this.remoteAdmin().describeTopics((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockDescribeTopicsResult(), (Object[])new DescribeTopicsResult[]{this.mockDescribeTopicsResult()});
        Mockito.when((Object)this.remoteAdmin().describeMirrors((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockDescribeMirrorsResult(MirrorTopicDescription.State.FAILED));
        this.assertCompletion(false, (Option<Throwable>)None$.MODULE$, new TaskDescription((TaskState)InErrorTaskState$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Source topic is in unexpected state of FAILED. This may be due to stale metadata, will retry task in 100 ms."), (List)Nil$.MODULE$)));
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithUnsupportedNextState() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.PENDING_STOPPED.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap, (Object[])new Map[]{pendingMirrorTopicMap});
        this.assertCompletion(true, (Option<Throwable>)None$.MODULE$, this.assertCompletion$default$3());
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithExceptionInFutureInSourceTopicDescribe() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap);
        AuthorizationException ex = new AuthorizationException("bad auth");
        this.mockSourceTopicDescribeWithExceptionInFuture((Throwable)ex);
        Some x$1 = new Some((Object)ex);
        TaskDescription x$2 = new TaskDescription((TaskState)InErrorTaskState$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)AuthorizationTaskErrorCode$.MODULE$, "Failed to describe the source topic mirror-topic due to authorization issues."), (List)Nil$.MODULE$));
        boolean x$3 = true;
        this.assertCompletion(x$3, (Option<Throwable>)x$1, x$2);
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithExceptionInSourceTopicDescribe() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap);
        AuthorizationException ex = new AuthorizationException("bad auth");
        this.mockSourceTopicDescribeWithException((Throwable)ex);
        Some x$1 = new Some((Object)ex);
        TaskDescription x$2 = new TaskDescription((TaskState)InErrorTaskState$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Failed to transition the topic to a mirror for an unknown reason."), (List)Nil$.MODULE$));
        boolean x$3 = true;
        this.assertCompletion(x$3, (Option<Throwable>)x$1, x$2);
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithExceptionInFutureInMirrorStatusCheck() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap);
        AuthorizationException ex = new AuthorizationException("bad auth");
        this.mockSourceTopicDescribe();
        this.mockMirrorTopicDescribeWithExceptionInFuture((Throwable)ex);
        Some x$1 = new Some((Object)ex);
        TaskDescription x$2 = new TaskDescription((TaskState)InErrorTaskState$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)AuthorizationTaskErrorCode$.MODULE$, "Failed to check the mirror status of source topic mirror-topic due to authorization issues."), (List)Nil$.MODULE$));
        boolean x$3 = true;
        this.assertCompletion(x$3, (Option<Throwable>)x$1, x$2);
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithExceptionInMirrorStatusCheck() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap);
        AuthorizationException ex = new AuthorizationException("bad auth");
        this.mockSourceTopicDescribe();
        this.mockMirrorTopicDescribeWithException((Throwable)ex);
        Some x$1 = new Some((Object)ex);
        TaskDescription x$2 = new TaskDescription((TaskState)InErrorTaskState$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)AuthorizationTaskErrorCode$.MODULE$, "Failed to check the mirror status of source topic mirror-topic due to authorization issues."), (List)Nil$.MODULE$));
        boolean x$3 = true;
        this.assertCompletion(x$3, (Option<Throwable>)x$1, x$2);
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithExceptionInFutureInMirrorConversion() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap);
        AuthorizationException ex = new AuthorizationException("bad auth");
        this.mockSourceTopicDescribe();
        this.mockStoppedMirrorTopicDescribe();
        this.mockStartOrPausePendingMirrorWithExceptionInFuture(true, (Throwable)ex);
        this.assertCompletion(false, (Option<Throwable>)new Some((Object)ex), new TaskDescription((TaskState)InErrorTaskState$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)BrokerAuthorizationTaskErrorCode$.MODULE$, "Failed to start the local mirror topic mirror-topic due to authorization issues."), (List)Nil$.MODULE$)));
    }

    @Test
    public void testClusterLinkConvertToPauseMirrorTopicWithExceptionInFutureInMirrorConversion() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.PAUSED.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap);
        AuthorizationException ex = new AuthorizationException("bad auth");
        this.mockSourceTopicDescribe();
        this.mockStoppedMirrorTopicDescribe();
        this.mockStartOrPausePendingMirrorWithExceptionInFuture(false, (Throwable)ex);
        this.assertCompletion(false, (Option<Throwable>)new Some((Object)ex), new TaskDescription((TaskState)InErrorTaskState$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)BrokerAuthorizationTaskErrorCode$.MODULE$, "Failed to pause the local mirror topic mirror-topic due to authorization issues."), (List)Nil$.MODULE$)));
    }

    @Test
    public void testClusterLinkConvertToStartMirrorTopicWithExceptionInMirrorConversion() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.MIRROR.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap);
        AuthorizationException ex = new AuthorizationException("bad auth");
        this.mockSourceTopicDescribe();
        this.mockStoppedMirrorTopicDescribe();
        this.mockStartOrPausePendingMirrorWithException(true, (Throwable)ex, this.topic());
        this.assertCompletion(false, (Option<Throwable>)new Some((Object)ex), new TaskDescription((TaskState)InErrorTaskState$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)BrokerAuthorizationTaskErrorCode$.MODULE$, "Failed to start the local mirror topic mirror-topic due to authorization issues."), (List)Nil$.MODULE$)));
    }

    @Test
    public void testClusterLinkConvertToPauseMirrorTopicWithExceptionInMirrorConversion() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopic.State.PAUSED.stateName(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingMirrorTopicMap);
        AuthorizationException ex = new AuthorizationException("bad auth");
        this.mockSourceTopicDescribe();
        this.mockStoppedMirrorTopicDescribe();
        this.mockStartOrPausePendingMirrorWithException(false, (Throwable)ex, this.topic());
        this.assertCompletion(false, (Option<Throwable>)new Some((Object)ex), new TaskDescription((TaskState)InErrorTaskState$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)BrokerAuthorizationTaskErrorCode$.MODULE$, "Failed to pause the local mirror topic mirror-topic due to authorization issues."), (List)Nil$.MODULE$)));
    }

    private void mockSourceTopicDescribe() {
        Mockito.when((Object)this.remoteAdmin().describeTopics((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockDescribeTopicsResult());
    }

    private DescribeTopicsResult mockDescribeTopicsResult() {
        java.util.List<TopicPartitionInfo> topicPartitionInfoList = Arrays.asList(new TopicPartitionInfo(0, Node.noNode(), Collections.singletonList(Node.noNode()), Collections.singletonList(Node.noNode())), new TopicPartitionInfo(1, Node.noNode(), Collections.singletonList(Node.noNode()), Collections.singletonList(Node.noNode())));
        TopicDescription topicDescription = new TopicDescription(this.topic(), false, topicPartitionInfoList, Collections.emptySet(), this.sourceTopicId());
        return AdminClientTestUtils.describeTopicsResult((String)this.topic(), (TopicDescription)topicDescription);
    }

    private DescribeTopicsResult nullDescribeTopicsResult() {
        java.util.List<TopicPartitionInfo> topicPartitionInfoList = Arrays.asList(new TopicPartitionInfo(0, Node.noNode(), Collections.singletonList(Node.noNode()), Collections.singletonList(Node.noNode())), new TopicPartitionInfo(1, Node.noNode(), Collections.singletonList(Node.noNode()), Collections.singletonList(Node.noNode())));
        TopicDescription topicDescription = new TopicDescription(new StringBuilder(2).append(this.topic()).append("-1").toString(), false, topicPartitionInfoList, Collections.emptySet(), this.sourceTopicId());
        return AdminClientTestUtils.describeTopicsResult((String)new StringBuilder(2).append(this.topic()).append("-1").toString(), (TopicDescription)topicDescription);
    }

    private DescribeMirrorsResult nullMirrorDescribeResult() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(null);
        return new DescribeMirrorsResult(Collections.singletonMap(this.topic(), future));
    }

    private DescribeTopicsResult incorrectTopicIdDescribeTopicsResult() {
        java.util.List<TopicPartitionInfo> topicPartitionInfoList = Arrays.asList(new TopicPartitionInfo(0, Node.noNode(), Collections.singletonList(Node.noNode()), Collections.singletonList(Node.noNode())), new TopicPartitionInfo(1, Node.noNode(), Collections.singletonList(Node.noNode()), Collections.singletonList(Node.noNode())));
        TopicDescription topicDescription = new TopicDescription(this.topic(), false, topicPartitionInfoList, Collections.emptySet(), Uuid.randomUuid());
        return AdminClientTestUtils.describeTopicsResult((String)this.topic(), (TopicDescription)topicDescription);
    }

    private DescribeTopicsResult incorrectNumberOfPartitionsDescribeTopicsResult() {
        java.util.List<TopicPartitionInfo> topicPartitionInfoList = Collections.singletonList(new TopicPartitionInfo(0, Node.noNode(), Collections.singletonList(Node.noNode()), Collections.singletonList(Node.noNode())));
        TopicDescription topicDescription = new TopicDescription(this.topic(), false, topicPartitionInfoList, Collections.emptySet(), this.sourceTopicId());
        return AdminClientTestUtils.describeTopicsResult((String)this.topic(), (TopicDescription)topicDescription);
    }

    private void mockSourceTopicDescribeWithExceptionInFuture(Throwable e) {
        DescribeTopicsResult describeTopicsResultWithException = AdminClientTestUtils.describeTopicsResultWithException((String)this.topic(), (Throwable)e);
        Mockito.when((Object)this.remoteAdmin().describeTopics((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)describeTopicsResultWithException);
    }

    private void mockSourceTopicDescribeWithException(Throwable e) {
        Mockito.when((Object)this.remoteAdmin().describeTopics((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeTopicsOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
    }

    private void mockStoppedMirrorTopicDescribe() {
        Mockito.when((Object)this.remoteAdmin().describeMirrors((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockDescribeMirrorsResult(MirrorTopicDescription.State.STOPPED));
    }

    private DescribeMirrorsResult mockDescribeMirrorsResult(MirrorTopicDescription.State mirrorState) {
        MirrorTopicDescription mirrorTopicDescription = new MirrorTopicDescription(this.linkName(), this.linkId(), this.topic(), 2, mirrorState, System.currentTimeMillis(), Collections.emptyList(), this.sourceTopicId(), MirrorTopicError.NO_ERROR);
        return new DescribeMirrorsResult(Collections.singletonMap(this.topic(), this.mirrorTopicDescriptionFuture(mirrorTopicDescription)));
    }

    private void mockMirrorTopicDescribeWithExceptionInFuture(Throwable e) {
        DescribeMirrorsResult describeMirrorsResult = new DescribeMirrorsResult(Collections.singletonMap(this.topic(), this.mirrorTopicDescriptionWithExceptionInFuture(e)));
        Mockito.when((Object)this.remoteAdmin().describeMirrors((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)describeMirrorsResult);
    }

    private void mockMirrorTopicDescribeWithException(Throwable e) {
        HashMap<String, KafkaFutureImpl> map = new HashMap<String, KafkaFutureImpl>();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(e);
        map.put(this.topic(), future);
        DescribeMirrorsResult result = new DescribeMirrorsResult(map);
        Mockito.when((Object)this.remoteAdmin().describeMirrors((Collection)ArgumentMatchers.eq(Collections.singleton(this.topic())), (DescribeMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
    }

    private KafkaFuture<MirrorTopicDescription> mirrorTopicDescriptionFuture(MirrorTopicDescription mirrorTopicDescription) {
        KafkaFutureImpl mirrorTopicDescriptionFuture = new KafkaFutureImpl();
        mirrorTopicDescriptionFuture.complete((Object)mirrorTopicDescription);
        return mirrorTopicDescriptionFuture;
    }

    private KafkaFuture<MirrorTopicDescription> mirrorTopicDescriptionWithExceptionInFuture(Throwable e) {
        KafkaFutureImpl mirrorTopicDescriptionFuture = new KafkaFutureImpl();
        mirrorTopicDescriptionFuture.completeExceptionally(e);
        return mirrorTopicDescriptionFuture;
    }

    private void mockStartOrPausePendingMirror(boolean shouldStartMirror) {
        AlterMirrorsResult alterMirrorsResult = new AlterMirrorsResult(Collections.singletonMap(this.topic(), this.alterMirrorsFuture()));
        if (shouldStartMirror) {
            Mockito.when((Object)this.localClusterLinkAdminClient().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(this.topic(), AlterMirrorOp.START_PENDING_MIRROR)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)alterMirrorsResult);
            return;
        }
        Mockito.when((Object)this.localClusterLinkAdminClient().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(this.topic(), AlterMirrorOp.PAUSE_PENDING_MIRROR)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)alterMirrorsResult);
    }

    private void mockStartOrPausePendingMirrorWithExceptionInFuture(boolean shouldStartMirror, Throwable e) {
        AlterMirrorsResult alterMirrorsResult = new AlterMirrorsResult(Collections.singletonMap(this.topic(), this.alterMirrorsFutureWithException(e)));
        if (shouldStartMirror) {
            Mockito.when((Object)this.localClusterLinkAdminClient().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(this.topic(), AlterMirrorOp.START_PENDING_MIRROR)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)alterMirrorsResult);
            return;
        }
        Mockito.when((Object)this.localClusterLinkAdminClient().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(this.topic(), AlterMirrorOp.PAUSE_PENDING_MIRROR)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)alterMirrorsResult);
    }

    private void mockStartOrPausePendingMirrorWithException(boolean shouldStartMirror, Throwable e, String topic) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(e);
        AlterMirrorsResult res = new AlterMirrorsResult(Collections.singletonMap(topic, future));
        if (shouldStartMirror) {
            Mockito.when((Object)this.localClusterLinkAdminClient().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(topic, AlterMirrorOp.START_PENDING_MIRROR)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)res);
            return;
        }
        Mockito.when((Object)this.localClusterLinkAdminClient().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(topic, AlterMirrorOp.PAUSE_PENDING_MIRROR)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)res);
    }

    private void mockFailMirror() {
        AlterMirrorsResult alterMirrorsResult = new AlterMirrorsResult(Collections.singletonMap(this.topic(), this.alterMirrorsFuture()));
        Mockito.when((Object)this.localClusterLinkAdminClient().failMirrors((Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)MirrorTopicError.SOURCE_TOPIC_ID_CHANGED)}))))).thenReturn((Object)alterMirrorsResult);
    }

    private KafkaFuture<Void> alterMirrorsFuture() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(null);
        return future;
    }

    private KafkaFuture<Void> alterMirrorsFutureWithException(Throwable e) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(e);
        return future;
    }

    private void assertCompletion(boolean expectedValue, Option<Throwable> expectedException, TaskDescription expectedTaskDesc) {
        try {
            ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)this.convertToMirrorTopic().runOnce().get(1L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectedValue), (Object)BoxesRunTime.boxToBoolean((boolean)this.convertToMirrorTopic().isShuttingDown()));
            Assertions.assertTrue((boolean)result.completed());
            Assertions.assertEquals((Object)new Some((Object)expectedTaskDesc), (Object)this.convertToMirrorTopic().taskDescription());
        }
        catch (Throwable ex) {
            Assertions.assertTrue((boolean)expectedException.isDefined(), (String)new StringBuilder(36).append("Exception caught but none expected: ").append(ex).toString());
            Assertions.assertEquals((Object)new Some((Object)expectedTaskDesc), (Object)this.convertToMirrorTopic().taskDescription());
        }
        TaskState taskState = expectedTaskDesc.state();
        if (ActiveTaskState$.MODULE$.equals(taskState)) {
            ((Sensor)Mockito.verify((Object)this.activeSensor(), (VerificationMode)Mockito.times((int)1))).record();
            return;
        }
        if (InErrorTaskState$.MODULE$.equals(taskState)) {
            ((Sensor)Mockito.verify((Object)this.inErrorSensor(), (VerificationMode)Mockito.times((int)1))).record();
            return;
        }
        throw new IllegalStateException(new StringBuilder(17).append("Unexpected state ").append(expectedTaskDesc.state()).toString());
    }

    private boolean assertCompletion$default$1() {
        return true;
    }

    private Option<Throwable> assertCompletion$default$2() {
        return None$.MODULE$;
    }

    private TaskDescription assertCompletion$default$3() {
        return new TaskDescription((TaskState)ActiveTaskState$.MODULE$, (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
    }

    public ClusterLinkConvertTopicToMirrorTest() {
        this.topic = "mirror-topic";
        this.linkName = "link-name";
    }
}

