/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.ClusterLinkQuotas$;
import kafka.server.KafkaConfig;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNonBatchingAdmin;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTaskManager;
import kafka.server.link.ClusterLinkTestUtils$;
import kafka.server.link.IdentityAclBindingFilterTransformer;
import kafka.utils.Implicits;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001B\u0010!\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u00048\u0001\u0001\u0006I\u0001\u000e\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u0011\u0019i\u0004\u0001)A\u0005u!Ia\b\u0001a\u0001\u0002\u0004%\ta\u0010\u0005\n\u0007\u0002\u0001\r\u00111A\u0005\u0002\u0011C\u0011B\u0013\u0001A\u0002\u0003\u0005\u000b\u0015\u0002!\t\u000f-\u0003!\u0019!C\u0001\u0019\"1A\u000b\u0001Q\u0001\n5Cq!\u0016\u0001C\u0002\u0013\u0005a\u000b\u0003\u0004[\u0001\u0001\u0006Ia\u0016\u0005\b7\u0002\u0011\r\u0011\"\u0001]\u0011\u0019\u0001\u0007\u0001)A\u0005;\"9\u0011\r\u0001b\u0001\n\u0003\u0011\u0007B\u00024\u0001A\u0003%1\rC\u0004h\u0001\t\u0007I\u0011\u00025\t\rY\u0004\u0001\u0015!\u0003j\u0011\u00159\b\u0001\"\u0001y\u0011\u0019\tI\u0001\u0001C\u0001q\"1\u0011Q\u0002\u0001\u0005\u0002aDa!!\u0005\u0001\t\u0003A\bbBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\u0007\u0003\u0003\u0002A\u0011\u0001=\t\r\u0005\u0015\u0003\u0001\"\u0001y\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017B\u0011\"a!\u0001#\u0003%I!!\"\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\"9\u0011Q\f\u0001\u0005\n\u0005\r\u0006bBAT\u0001\u0011%\u0011\u0011\u0016\u0002!\u00072,8\u000f^3s\u0019&t7\u000eR3ti\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\"E\u0005!A.\u001b8l\u0015\t\u0019C%\u0001\u0004tKJ4XM\u001d\u0006\u0002K\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001)!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\r\t\u0003c\u0001i\u0011\u0001I\u0001\ng\u000eDW\rZ;mKJ,\u0012\u0001\u000e\t\u0003cUJ!A\u000e\u0011\u0003)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\fi\u0006\u001c8.T1oC\u001e,'/F\u0001;!\t\t4(\u0003\u0002=A\t12\t\\;ti\u0016\u0014H*\u001b8l)\u0006\u001c8.T1oC\u001e,'/\u0001\u0007uCN\\W*\u00198bO\u0016\u0014\b%A\u0007dY&,g\u000e^'b]\u0006<WM]\u000b\u0002\u0001B\u0011\u0011'Q\u0005\u0003\u0005\u0002\u0012Ad\u00117vgR,'\u000fT5oW\u0012+7\u000f^\"mS\u0016tG/T1oC\u001e,'/A\tdY&,g\u000e^'b]\u0006<WM]0%KF$\"!\u0012%\u0011\u0005%2\u0015BA$+\u0005\u0011)f.\u001b;\t\u000f%;\u0011\u0011!a\u0001\u0001\u0006\u0019\u0001\u0010J\u0019\u0002\u001d\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3sA\u0005Q\u0011-\u001e;i_JL'0\u001a:\u0016\u00035\u0003\"A\u0014*\u000e\u0003=S!a\u0013)\u000b\u0005E#\u0013\u0001C:fGV\u0014\u0018\u000e^=\n\u0005M{%!D!dY\u0006+H\u000f[8sSj,'/A\u0006bkRDwN]5{KJ\u0004\u0013AE2mkN$XM\u001d'j].l\u0015M\\1hKJ,\u0012a\u0016\t\u0003caK!!\u0017\u0011\u0003%\rcWo\u001d;fe2Kgn['b]\u0006<WM]\u0001\u0014G2,8\u000f^3s\u0019&t7.T1oC\u001e,'\u000fI\u0001\nI\u0016\u001cH/\u00113nS:,\u0012!\u0018\t\u0003cyK!a\u0018\u0011\u0003+\rcWo\u001d;fe2Kgn\u001b'pG\u0006d\u0017\tZ7j]\u0006QA-Z:u\u0003\u0012l\u0017N\u001c\u0011\u0002\u000f5,GO]5dgV\t1\r\u0005\u00022I&\u0011Q\r\t\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003\u0011!\u0018.\\3\u0016\u0003%\u0004\"A\u001b;\u000e\u0003-T!\u0001\\7\u0002\u000bU$\u0018\u000e\\:\u000b\u00059|\u0017AB2p[6|gN\u0003\u0002&a*\u0011\u0011O]\u0001\u0007CB\f7\r[3\u000b\u0003M\f1a\u001c:h\u0013\t)8N\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013a\u0004;fgR\u0014VmY8oM&<WO]3\u0015\u0003\u0015C#a\u0005>\u0011\u0007m\f)!D\u0001}\u0015\tih0A\u0002ba&T1a`A\u0001\u0003\u001dQW\u000f]5uKJT1!a\u0001s\u0003\u0015QWO\\5u\u0013\r\t9\u0001 \u0002\u0005)\u0016\u001cH/\u0001\u0006uKN$Hk\u001c9jGND#\u0001\u0006>\u0002-Q,7\u000f^!dYNKhn\u0019+bg.\u001cF/\u0019:ukBD#!\u0006>\u0002WQ,7\u000f^!dYNKhn\u0019+bg.\u001cF/\u0019:ukB<\u0016\u000e\u001e5SKN|WO]2f\u0013\u0012,e.\u00192mK\u0012D#A\u0006>\u0002WY,'/\u001b4z\u0003\u000edg)\u001b7uKJ\u001c8i\u001c8gS\u001e<\u0016\u000e\u001e5SKN|WO]2f\u0013\u0012,e.\u00192mK\u0012$r!RA\r\u0003g\ti\u0004C\u0004\u0002\u001c]\u0001\r!!\b\u0002%5LwM]1uK\u0006cG.Q2mg*\u001bxN\u001c\t\u0005\u0003?\tiC\u0004\u0003\u0002\"\u0005%\u0002cAA\u0012U5\u0011\u0011Q\u0005\u0006\u0004\u0003O1\u0013A\u0002\u001fs_>$h(C\u0002\u0002,)\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0018\u0003c\u0011aa\u0015;sS:<'bAA\u0016U!9\u0011QG\fA\u0002\u0005]\u0012!\u0005:fg>,(oY3JI\u001aKG\u000e^3sgB\u0019\u0011&!\u000f\n\u0007\u0005m\"FA\u0004C_>dW-\u00198\t\u000f\u0005}r\u00031\u0001\u00028\u0005yQ\r\u001f9fGR,GMR1jYV\u0014X-\u0001\u0014uKN$\u0018i\u00197Ts:\u001cG+Y:l'R\f'\u000f^;q/&$\bNT8BkRDwN]5{KJD#\u0001\u0007>\u00021Q,7\u000f^!dYNKhn\u0019+bg.tun\u0015;beR,\b\u000f\u000b\u0002\u001au\u0006\u0001b.Z<DY&,g\u000e^'b]\u0006<WM\u001d\u000b\f\u0001\u00065\u0013\u0011KA.\u0003W\ny\bC\u0004\u0002Pi\u0001\r!!\b\u0002\u00111Lgn\u001b(b[\u0016Dq!a\u0015\u001b\u0001\u0004\t)&\u0001\u0004d_:4\u0017n\u001a\t\u0004c\u0005]\u0013bAA-A\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\t\u000f\u0005u#\u00041\u0001\u0002`\u0005a\u0011\rZ7j]\u001a\u000b7\r^8ssB9\u0011&!\u0019\u0002V\u0005\u0015\u0014bAA2U\tIa)\u001e8di&|g.\r\t\u0004c\u0005\u001d\u0014bAA5A\t12\t\\;ti\u0016\u0014H*\u001b8l\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0003\u0004L5\u0001\u0007\u0011Q\u000e\t\u0006S\u0005=\u00141O\u0005\u0004\u0003cR#AB(qi&|g\u000e\u0005\u0003\u0002v\u0005mTBAA<\u0015\rY\u0015\u0011\u0010\u0006\u0003G=LA!! \u0002x\tQ\u0011)\u001e;i_JL'0\u001a:\t\u0013\u0005\u0005%\u0004%AA\u0002\u0005u\u0011\u0001\u0007:fg>,(oY3JIN+\b\u000f]8si\u0016s\u0017M\u00197fI\u0006Qb.Z<DY&,g\u000e^'b]\u0006<WM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\u0011\u0016\u0005\u0003;\tIi\u000b\u0002\u0002\fB!\u0011QRAL\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015!C;oG\",7m[3e\u0015\r\t)JK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAM\u0003\u001f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0019Gn\\:f\u001b\u0006t\u0017mZ3sgR\u0019Q)a(\t\r\u0005\u0005F\u00041\u0001A\u0003a\u0019G.^:uKJd\u0015N\\6DY&,g\u000e^'b]\u0006<WM\u001d\u000b\u0005\u0003K\n)\u000bC\u0004\u0002Tu\u0001\r!!\u0016\u0002\u00139,woQ8oM&<G\u0003BA+\u0003WCq!!,\u001f\u0001\u0004\ty+A\u0004d_:4\u0017nZ:\u0011\u0011\u0005}\u0011\u0011WA\u000f\u0003;IA!a-\u00022\t\u0019Q*\u00199")
public class ClusterLinkDestClientManagerTest {
    private final ClusterLinkScheduler scheduler = (ClusterLinkScheduler)Mockito.mock(ClusterLinkScheduler.class);
    private final ClusterLinkTaskManager taskManager = (ClusterLinkTaskManager)Mockito.mock(ClusterLinkTaskManager.class);
    private ClusterLinkDestClientManager clientManager;
    private final AclAuthorizer authorizer = (AclAuthorizer)Mockito.mock(AclAuthorizer.class);
    private final ClusterLinkManager clusterLinkManager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
    private final ClusterLinkLocalAdmin destAdmin = (ClusterLinkLocalAdmin)Mockito.mock(ClusterLinkLocalAdmin.class);
    private final ClusterLinkMetrics metrics = (ClusterLinkMetrics)Mockito.mock(ClusterLinkMetrics.class);
    private final Time time = new MockTime();

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public ClusterLinkTaskManager taskManager() {
        return this.taskManager;
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public void clientManager_$eq(ClusterLinkDestClientManager x$1) {
        this.clientManager = x$1;
    }

    public AclAuthorizer authorizer() {
        return this.authorizer;
    }

    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public ClusterLinkLocalAdmin destAdmin() {
        return this.destAdmin;
    }

    public ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReconfigure() {
        void newClientManager_adminFactory;
        void newClientManager_authorizer;
        void newClientManager_resourceIdSupportEnabled;
        String linkName = "test-link";
        IntRef factoryCalled = IntRef.create((int)0);
        ObjectRef factoryConfig = ObjectRef.create((Object)this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234")})))));
        ObjectRef factoryAdmin = ObjectRef.create((Object)((KafkaAdminClient)Mockito.mock(KafkaAdminClient.class)));
        String string = "false";
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable intersect = (Function1 & Serializable)config -> ClusterLinkDestClientManagerTest.adminFactoryWithCount$1(config, factoryCalled, factoryConfig, factoryAdmin);
        ClusterLinkConfig newClientManager_config = (ClusterLinkConfig)factoryConfig.elem;
        Mockito.when((Object)this.taskManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)newClientManager_metadataManager);
        Properties newClientManager_brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        newClientManager_brokerConfig.put("multitenant.authorizer.support.resource.ids", (Object)newClientManager_resourceIdSupportEnabled);
        Object var7_8 = null;
        intersect = null;
        some = null;
        string = null;
        Object var11_9 = null;
        Object var12_10 = null;
        Object var13_11 = null;
        Object var14_12 = null;
        ClusterLinkDestClientManager clientManager = new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)newClientManager_brokerConfig), newClientManager_linkData, newClientManager_fetcherManager, this.taskManager(), newClientManager_config, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (ClusterLinkBatchAdmin)new ClusterLinkNonBatchingAdmin((Function0 & Serializable)() -> this.destAdmin()), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), this.time(), ClusterLinkQuotas$.MODULE$.unboundedClusterLinkQuotas());
        Assertions.assertEquals((int)0, (int)factoryCalled.elem);
        clientManager.startup();
        try {
            Assertions.assertEquals((int)1, (int)factoryCalled.elem);
            Assertions.assertTrue(((KafkaAdminClient)factoryAdmin.elem == clientManager.getAdmin() ? 1 : 0) != 0);
            factoryAdmin.elem = (KafkaAdminClient)Mockito.mock(KafkaAdminClient.class);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:2345")}))));
            clientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bootstrap.servers"})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            Assertions.assertTrue(((KafkaAdminClient)factoryAdmin.elem == clientManager.getAdmin() ? 1 : 0) != 0);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:2345"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp()), (Object)"5")}))));
            clientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp()})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:3456"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
            clientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp(), "bootstrap.servers", ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            Assertions$.MODULE$.intercept((Function0 & Serializable)() -> clientManager.getAdmin(), ClassTag$.MODULE$.apply(ClusterLinkPausedException.class), new Position("ClusterLinkDestClientManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:4567"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
            clientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bootstrap.servers"})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            Assertions$.MODULE$.intercept((Function0 & Serializable)() -> clientManager.getAdmin(), ClassTag$.MODULE$.apply(ClusterLinkPausedException.class), new Position("ClusterLinkDestClientManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            factoryAdmin.elem = (KafkaAdminClient)Mockito.mock(KafkaAdminClient.class);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:4567")}))));
            clientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
            Assertions.assertEquals((int)3, (int)factoryCalled.elem);
            Assertions.assertTrue(((KafkaAdminClient)factoryAdmin.elem == clientManager.getAdmin() ? 1 : 0) != 0);
        }
        finally {
            this.closeManagers(clientManager);
        }
        Assertions.assertEquals((int)3, (int)factoryCalled.elem);
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> clientManager.getAdmin(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkDestClientManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopics() {
        void newClientManager_authorizer;
        void newClientManager_resourceIdSupportEnabled;
        String linkName = "test-link";
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234")}))));
        String string = "false";
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable newClientManager_adminFactory = (Function1 & Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        Mockito.when((Object)this.taskManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)newClientManager_metadataManager);
        Properties newClientManager_brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        newClientManager_brokerConfig.put("multitenant.authorizer.support.resource.ids", (Object)newClientManager_resourceIdSupportEnabled);
        Object var6_5 = null;
        some = null;
        string = null;
        Object var9_6 = null;
        Object var10_7 = null;
        Object var11_8 = null;
        Object var12_9 = null;
        ClusterLinkDestClientManager clientManager = new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)newClientManager_brokerConfig), newClientManager_linkData, newClientManager_fetcherManager, this.taskManager(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (ClusterLinkBatchAdmin)new ClusterLinkNonBatchingAdmin((Function0 & Serializable)() -> this.destAdmin()), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), this.time(), ClusterLinkQuotas$.MODULE$.unboundedClusterLinkQuotas());
        .colon.colon topics = new .colon.colon((Object)"topic0", (List)new .colon.colon((Object)"topic1", (List)new .colon.colon((Object)"topic2", (List)Nil$.MODULE$)));
        clientManager.startup();
        try {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)clientManager.getTopics());
            clientManager.addTopicsOwnedAsFirstPartitionLeader((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.head(), (String)topics.apply(1)})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.head(), (String)topics.apply(1)})), (Object)clientManager.getTopics());
            clientManager.addTopicsOwnedAsFirstPartitionLeader((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1), (String)topics.apply(2)})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.head(), (String)topics.apply(1), (String)topics.apply(2)})), (Object)clientManager.getTopics());
            clientManager.removeTopicsOwnedAsFirstPartitionLeader((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(2), (String)topics.head()})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1)})), (Object)clientManager.getTopics());
            clientManager.removeTopicsOwnedAsFirstPartitionLeader((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1), "unknown"})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)clientManager.getTopics());
        }
        finally {
            this.closeManagers(clientManager);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclSyncTaskStartup() {
        void newClientManager_authorizer;
        void newClientManager_resourceIdSupportEnabled;
        String linkName = "test-link";
        String migrateAllAclsJson = ClusterLinkTestUtils$.MODULE$.AllAclsFilter();
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)migrateAllAclsJson)}))));
        String string = "false";
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable newClientManager_adminFactory = (Function1 & Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        Mockito.when((Object)this.taskManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)newClientManager_metadataManager);
        Properties newClientManager_brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        newClientManager_brokerConfig.put("multitenant.authorizer.support.resource.ids", (Object)newClientManager_resourceIdSupportEnabled);
        Object var6_6 = null;
        some = null;
        string = null;
        Object var9_7 = null;
        Object var10_8 = null;
        Object var11_9 = null;
        Object var12_10 = null;
        ClusterLinkDestClientManager clientManager = new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)newClientManager_brokerConfig), newClientManager_linkData, newClientManager_fetcherManager, this.taskManager(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (ClusterLinkBatchAdmin)new ClusterLinkNonBatchingAdmin((Function0 & Serializable)() -> this.destAdmin()), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), this.time(), ClusterLinkQuotas$.MODULE$.unboundedClusterLinkQuotas());
        clientManager.startup();
        try {
            Predef$.MODULE$.assert(clientManager.getSyncAclTask().isDefined());
        }
        finally {
            this.closeManagers(clientManager);
        }
    }

    @Test
    public void testAclSyncTaskStartupWithResourceIdEnabled() {
        String filterWithNullAndResourceId = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:pool-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:spiffe://dummy.trust.domain/test-workload\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:u-4\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }}]\n        | }"));
        this.verifyAclFiltersConfigWithResourceIdEnabled(filterWithNullAndResourceId, false, true);
        String filterWithIntegerAndResourceId = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:4\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:pool-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:group-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:spiffe://dummy.trust.domain/test-workload\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:u-4\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }}]\n        | }"));
        this.verifyAclFiltersConfigWithResourceIdEnabled(filterWithIntegerAndResourceId, false, true);
        String filterWithResourceIdAndPoolId = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"UserV2:*\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:pool-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:group-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:u-4\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }}]\n        | }"));
        this.verifyAclFiltersConfigWithResourceIdEnabled(filterWithResourceIdAndPoolId, true, false);
        String filterWithMixIds = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:pool-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:group-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:spiffe://dummy.trust.domain/test-workload\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:4\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }}]\n        | }"));
        this.verifyAclFiltersConfigWithResourceIdEnabled(filterWithMixIds, false, false);
        this.verifyAclFiltersConfigWithResourceIdEnabled("", false, false);
        String filterWithPoolIdAndGroupId = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:pool-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:group-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:pool-4\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }}]\n        | }"));
        this.verifyAclFiltersConfigWithResourceIdEnabled(filterWithPoolIdAndGroupId, true, false);
        String filterWithPoolIdAndSpiffeId = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:pool-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:pool-4\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:spiffe://dummy.trust.domain/test-workload\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | }]\n        | }"));
        this.verifyAclFiltersConfigWithResourceIdEnabled(filterWithPoolIdAndSpiffeId, true, false);
        String filterWithSpiffeIdAndGroupId = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:spiffe://dummy.trust.domain/test-workload-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:group-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:spiffe://dummy.trust.domain/test-workload-2\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | }]\n        | }"));
        this.verifyAclFiltersConfigWithResourceIdEnabled(filterWithSpiffeIdAndGroupId, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyAclFiltersConfigWithResourceIdEnabled(String migrateAllAclsJson, boolean resourceIdFilters, boolean expectedFailure) {
        void newClientManager_authorizer;
        void newClientManager_resourceIdSupportEnabled;
        String linkName = "test-link";
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)migrateAllAclsJson)}))));
        String string = "true";
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable newClientManager_adminFactory = (Function1 & Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        Mockito.when((Object)this.taskManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)newClientManager_metadataManager);
        Properties newClientManager_brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        newClientManager_brokerConfig.put("multitenant.authorizer.support.resource.ids", (Object)newClientManager_resourceIdSupportEnabled);
        Object var7_8 = null;
        some = null;
        string = null;
        Object var10_9 = null;
        Object var11_10 = null;
        Object var12_11 = null;
        Object var13_12 = null;
        ClusterLinkDestClientManager clientManager = new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)newClientManager_brokerConfig), newClientManager_linkData, newClientManager_fetcherManager, this.taskManager(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (ClusterLinkBatchAdmin)new ClusterLinkNonBatchingAdmin((Function0 & Serializable)() -> this.destAdmin()), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), this.time(), ClusterLinkQuotas$.MODULE$.unboundedClusterLinkQuotas());
        if (!expectedFailure) {
            clientManager.startup();
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)clientManager.aclFilterWithResourceId()), (Object)BoxesRunTime.boxToBoolean((boolean)resourceIdFilters));
        } else {
            Assertions.assertEquals((Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> clientManager.startup())).getMessage(), (Object)new StringBuilder(177).append("If kafka.config.authorizer.resource.id.support.enable flag is enabled, aclFilters in cluster link").append("should contain filters either in old or new format, but got mix of both format. ").append(config2.aclFilters().get()).toString());
        }
        this.closeManagers(clientManager);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclSyncTaskStartupWithNoAuthorizer() {
        void newClientManager_authorizer;
        void newClientManager_resourceIdSupportEnabled;
        String linkName = "test-link";
        String migrateAllAclsJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [{\n        |  \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        |  }]\n        | }"));
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)migrateAllAclsJson)}))));
        String string = "false";
        None$ none$ = None$.MODULE$;
        Function1 & Serializable newClientManager_adminFactory = (Function1 & Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        Mockito.when((Object)this.taskManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)newClientManager_metadataManager);
        Properties newClientManager_brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        newClientManager_brokerConfig.put("multitenant.authorizer.support.resource.ids", (Object)newClientManager_resourceIdSupportEnabled);
        Object var6_6 = null;
        none$ = null;
        string = null;
        Object var9_7 = null;
        Object var10_8 = null;
        Object var11_9 = null;
        Object var12_10 = null;
        ClusterLinkDestClientManager clientManager = new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)newClientManager_brokerConfig), newClientManager_linkData, newClientManager_fetcherManager, this.taskManager(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (ClusterLinkBatchAdmin)new ClusterLinkNonBatchingAdmin((Function0 & Serializable)() -> this.destAdmin()), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), this.time(), ClusterLinkQuotas$.MODULE$.unboundedClusterLinkQuotas());
        try {
            try {
                clientManager.startup();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assertions.assertEquals((Object)illegalArgumentException.getMessage(), (Object)"ACL migration is enabled but authorizer.class.name is not set. Please set authorizer.class.name to proceed with ACL migration.");
            }
        }
        finally {
            this.closeManagers(clientManager);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclSyncTaskNoStartup() {
        void newClientManager_authorizer;
        void newClientManager_resourceIdSupportEnabled;
        String linkName = "test-link";
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"false")}))));
        String string = "false";
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable newClientManager_adminFactory = (Function1 & Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        Mockito.when((Object)this.taskManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)newClientManager_metadataManager);
        Properties newClientManager_brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        newClientManager_brokerConfig.put("multitenant.authorizer.support.resource.ids", (Object)newClientManager_resourceIdSupportEnabled);
        Object var5_5 = null;
        some = null;
        string = null;
        Object var8_6 = null;
        Object var9_7 = null;
        Object var10_8 = null;
        Object var11_9 = null;
        ClusterLinkDestClientManager clientManager = new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)newClientManager_brokerConfig), newClientManager_linkData, newClientManager_fetcherManager, this.taskManager(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (ClusterLinkBatchAdmin)new ClusterLinkNonBatchingAdmin((Function0 & Serializable)() -> this.destAdmin()), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), this.time(), ClusterLinkQuotas$.MODULE$.unboundedClusterLinkQuotas());
        clientManager.startup();
        try {
            Predef$.MODULE$.assert(clientManager.getSyncAclTask().isEmpty());
        }
        finally {
            this.closeManagers(clientManager);
        }
    }

    private ClusterLinkDestClientManager newClientManager(String linkName, ClusterLinkConfig config, Function1<ClusterLinkConfig, ClusterLinkAdminClient> adminFactory, Option<Authorizer> authorizer, String resourceIdSupportEnabled) {
        Mockito.when((Object)this.taskManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)metadataManager);
        Properties brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        brokerConfig.put("multitenant.authorizer.support.resource.ids", resourceIdSupportEnabled);
        return new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)brokerConfig), linkData, fetcherManager, this.taskManager(), config, authorizer, (Option)None$.MODULE$, this.metrics(), adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (ClusterLinkBatchAdmin)new ClusterLinkNonBatchingAdmin((Function0 & Serializable)() -> this.destAdmin()), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), this.time(), ClusterLinkQuotas$.MODULE$.unboundedClusterLinkQuotas());
    }

    private String newClientManager$default$5() {
        return "false";
    }

    private void closeManagers(ClusterLinkDestClientManager clusterLinkClientManager) {
        ((ClusterLinkLocalAdmin)Mockito.doNothing().when((Object)this.destAdmin())).close(Duration.ZERO);
        clusterLinkClientManager.shutdown();
        Mockito.reset((Object[])new ClusterLinkLocalAdmin[]{this.destAdmin()});
        Mockito.reset((Object[])new ClusterLinkManager[]{this.clusterLinkManager()});
        clusterLinkClientManager.scheduler().shutdown();
        Mockito.reset((Object[])new ClusterLinkScheduler[]{this.scheduler()});
    }

    private ClusterLinkAdminClient adminFactory(ClusterLinkConfig config) {
        return (ClusterLinkAdminClient)Mockito.mock(ClusterLinkAdminClient.class);
    }

    private ClusterLinkConfig newConfig(scala.collection.immutable.Map<String, String> configs) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(configs);
        return ClusterLinkConfig$.MODULE$.create((Map)props, (Option)None$.MODULE$, true);
    }

    private static final ClusterLinkAdminClient adminFactoryWithCount$1(ClusterLinkConfig config, IntRef factoryCalled$1, ObjectRef factoryConfig$1, ObjectRef factoryAdmin$1) {
        ++factoryCalled$1.elem;
        Assertions.assertTrue(((ClusterLinkConfig)factoryConfig$1.elem == config ? 1 : 0) != 0);
        return new ClusterLinkAdminClient((ConfluentAdmin)((KafkaAdminClient)factoryAdmin$1.elem), null, null, null, "");
    }
}

