/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.Partition;
import kafka.server.ClusterLinkQuotas$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDisabled;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkSyncOffsetsTaskType$;
import kafka.server.link.TaskType;
import kafka.utils.MethodInvocationTracker;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.ClusterLinkDisabledException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001\u0002\n\u0014\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u00044\u0001\u0001\u0006Ia\n\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019a\u0004\u0001)A\u0005m!IQ\b\u0001a\u0001\u0002\u0004%IA\u0010\u0005\n\r\u0002\u0001\r\u00111A\u0005\n\u001dC\u0011\"\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B \t\u000f9\u0003!\u0019!C\u0005\u001f\"1\u0001\f\u0001Q\u0001\nACQ!\u0017\u0001\u0005\u0002iCQA\u001a\u0001\u0005\u0002iCQa\u001b\u0001\u0005\u0002iCQ!\u001c\u0001\u0005\n9DQ\u0001\u001f\u0001\u0005\neDq!!\t\u0001\t\u0013\t\u0019\u0003C\u0004\u0002*\u0001!I!a\u000b\u0003-\rcWo\u001d;fe2Kgn\u001b$bGR|'/\u001f+fgRT!\u0001F\u000b\u0002\t1Lgn\u001b\u0006\u0003-]\taa]3sm\u0016\u0014(\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005\u0019\u0012aB7fiJL7m]\u000b\u0002OA\u0011\u0001&M\u0007\u0002S)\u0011QE\u000b\u0006\u0003W1\naaY8n[>t'B\u0001\r.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IJ#aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005!A/[7f+\u00051\u0004CA\u001c;\u001b\u0005A$BA\u001d+\u0003\u0015)H/\u001b7t\u0013\tY\u0004H\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0016\u0003}\u0002\"\u0001Q\"\u000f\u0005\u0011\n\u0015B\u0001\"\u0014\u0003I\u0019E.^:uKJd\u0015N\\6GC\u000e$xN]=\n\u0005\u0011+%a\u0003'j].l\u0015M\\1hKJT!AQ\n\u0002-\rdWo\u001d;fe2Kgn['b]\u0006<WM]0%KF$\"\u0001S&\u0011\u0005qI\u0015B\u0001&\u001e\u0005\u0011)f.\u001b;\t\u000f1;\u0011\u0011!a\u0001\u007f\u0005\u0019\u0001\u0010J\u0019\u0002'\rdWo\u001d;fe2Kgn['b]\u0006<WM\u001d\u0011\u0002-\u0011L7/\u00192mK\u0012tu\u000e\u001e+fgR,G-\u0012:s_J,\u0012\u0001\u0015\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000bA\u0001\\1oO*\tQ+\u0001\u0003kCZ\f\u0017BA,S\u0005\u0019\u0019FO]5oO\u00069B-[:bE2,GMT8u)\u0016\u001cH/\u001a3FeJ|'\u000fI\u0001\ti\u0016\f'\u000fR8x]R\t\u0001\n\u000b\u0002\f9B\u0011Q\fZ\u0007\u0002=*\u0011q\fY\u0001\u0004CBL'BA1c\u0003\u001dQW\u000f]5uKJT!aY\u0018\u0002\u000b),h.\u001b;\n\u0005\u0015t&!C!gi\u0016\u0014X)Y2i\u0003\u0019\"Xm\u001d;MS:\\W*\u00198bO\u0016\u0014x+\u001b;i\u00072,8\u000f^3s\u0019&t7\u000eR5tC\ndW\r\u001a\u0015\u0003\u0019!\u0004\"!X5\n\u0005)t&\u0001\u0002+fgR\fq\u0005^3ti\u0006#W.\u001b8NC:\fw-\u001a:XSRD7\t\\;ti\u0016\u0014H*\u001b8l\t&\u001c\u0018M\u00197fI\"\u0012Q\u0002[\u0001\u0013GJ,\u0017\r^3Ce>\\WM]\"p]\u001aLw\r\u0006\u0002pgB\u0011\u0001/]\u0007\u0002+%\u0011!/\u0006\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003u\u001d\u0001\u0007Q/A\tf]\u0006\u0014G.Z\"mkN$XM\u001d'j].\u0004\"\u0001\b<\n\u0005]l\"a\u0002\"p_2,\u0017M\\\u0001\ng\u0016$X\u000f]'pG.$b\u0001\u0013>\u0002\u0006\u0005E\u0001\"B>\u0010\u0001\u0004a\u0018!\u00039beRLG/[8o!\ri\u0018\u0011A\u0007\u0002}*\u0011qpF\u0001\bG2,8\u000f^3s\u0013\r\t\u0019A \u0002\n!\u0006\u0014H/\u001b;j_:Dq!a\u0002\u0010\u0001\u0004\tI!\u0001\u0002uaB!\u00111BA\u0007\u001b\u0005Q\u0013bAA\bU\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA\n\u001f\u0001\u0007\u0011QC\u0001\u0007Y&t7.\u00133\u0011\u000bq\t9\"a\u0007\n\u0007\u0005eQD\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0017\ti\"C\u0002\u0002 )\u0012A!V;jI\u0006A2M]3bi\u0016\u001cE.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0015\u0007}\n)\u0003\u0003\u0004\u0002(A\u0001\ra\\\u0001\rEJ|7.\u001a:D_:4\u0017nZ\u0001\u001am\u0016\u0014\u0018NZ=DYV\u001cH/\u001a:MS:\\G)[:bE2,G\rF\u0002I\u0003[Aq!a\f\u0012\u0001\u0004\t\t$\u0001\u0005sk:t\u0017M\u00197f!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c=\u0006Aa-\u001e8di&|g.\u0003\u0003\u0002<\u0005U\"AC#yK\u000e,H/\u00192mK\u0002")
public class ClusterLinkFactoryTest {
    private final Metrics metrics = new Metrics();
    private final MockTime time = new MockTime();
    private ClusterLinkFactory.LinkManager clusterLinkManager;
    private final String disabledNotTestedError;

    private Metrics metrics() {
        return this.metrics;
    }

    private MockTime time() {
        return this.time;
    }

    private ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    private void clusterLinkManager_$eq(ClusterLinkFactory.LinkManager x$1) {
        this.clusterLinkManager = x$1;
    }

    private String disabledNotTestedError() {
        return this.disabledNotTestedError;
    }

    @AfterEach
    public void tearDown() {
        this.clusterLinkManager().shutdown();
        this.metrics().close();
    }

    @Test
    public void testLinkManagerWithClusterLinkDisabled() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        KafkaConfig brokerConfig = this.createBrokerConfig(false);
        this.clusterLinkManager_$eq(this.createClusterLinkManager(brokerConfig));
        Assertions.assertTrue((boolean)(this.clusterLinkManager() instanceof ClusterLinkDisabled.LinkManager));
        MethodInvocationTracker invocationTracker = new MethodInvocationTracker(this.clusterLinkManager(), ClusterLinkFactory.LinkManager.class);
        ClusterLinkFactory.LinkManager clusterLinkManager = invocationTracker.proxy(this.clusterLinkManager());
        Assertions.assertTrue((boolean)(clusterLinkManager.admin() instanceof ClusterLinkDisabled.AdminManager));
        Assertions.assertTrue((boolean)(clusterLinkManager.admin().clusterLinkManager() instanceof ClusterLinkDisabled.LinkManager));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)clusterLinkManager.createClusterLinkPolicy());
        Executable verifyClusterLinkDisabled_runnable = () -> clusterLinkManager.configEncoder();
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable);
        Object var9_6 = null;
        Executable verifyClusterLinkDisabled_runnable2 = () -> clusterLinkManager.createClusterLink(new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.empty()).asJava(), (Option)None$.MODULE$, true), new Properties());
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable2);
        Object var10_7 = null;
        Executable verifyClusterLinkDisabled_runnable3 = () -> clusterLinkManager.listClusterLinks();
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable3);
        Object var11_8 = null;
        Executable verifyClusterLinkDisabled_runnable4 = () -> clusterLinkManager.updateClusterLinkConfig(linkName, (Function1 & Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFactoryTest.$anonfun$testLinkManagerWithClusterLinkDisabled$5(props)));
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable4);
        Object var12_9 = null;
        Executable verifyClusterLinkDisabled_runnable5 = () -> clusterLinkManager.deleteClusterLink(linkName, linkId);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable5);
        Object var13_10 = null;
        Executable verifyClusterLinkDisabled_runnable6 = () -> clusterLinkManager.fetcherManager(linkId);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable6);
        Object var14_11 = null;
        Executable verifyClusterLinkDisabled_runnable7 = () -> clusterLinkManager.connectionManager(linkId);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable7);
        Object var15_12 = null;
        Executable verifyClusterLinkDisabled_runnable8 = () -> clusterLinkManager.clientManager(linkId);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable8);
        Object var16_13 = null;
        Executable verifyClusterLinkDisabled_runnable9 = () -> clusterLinkManager.destClientManager(linkId);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable9);
        Object var17_14 = null;
        Executable verifyClusterLinkDisabled_runnable10 = () -> clusterLinkManager.resolveLinkId(linkName);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable10);
        Object var18_15 = null;
        Executable verifyClusterLinkDisabled_runnable11 = () -> clusterLinkManager.resolveLinkIdOrThrow(linkName);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable11);
        Object var19_16 = null;
        Executable verifyClusterLinkDisabled_runnable12 = () -> clusterLinkManager.ensureLinkNameDoesntExist(linkName);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable12);
        Object var20_17 = null;
        Executable verifyClusterLinkDisabled_runnable13 = () -> clusterLinkManager.ensureClusterLinkExists(linkId);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable13);
        Object var21_18 = null;
        Executable verifyClusterLinkDisabled_runnable14 = () -> clusterLinkManager.linkConfig(linkId);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable14);
        Object var22_19 = null;
        Executable verifyClusterLinkDisabled_runnable15 = () -> clusterLinkManager.linkConfigFromMetadataProps(linkId);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable15);
        Object var23_20 = null;
        Executable verifyClusterLinkDisabled_runnable16 = () -> clusterLinkManager.getTenantPrefix(linkName);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable16);
        Object var24_21 = null;
        Executable verifyClusterLinkDisabled_runnable17 = () -> clusterLinkManager.linkState(linkName);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable17);
        Object var25_22 = null;
        Executable verifyClusterLinkDisabled_runnable18 = () -> clusterLinkManager.maybeCheckForOverlappingTopicFilters(ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.empty()).asJava(), (Option)None$.MODULE$, true), linkName, Option$.MODULE$.empty());
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable18);
        Object var26_23 = null;
        Executable verifyClusterLinkDisabled_runnable19 = () -> clusterLinkManager.validateLocalListenerName(ClusterLinkConfig$.MODULE$.create(Collections.emptyMap(), (Option)None$.MODULE$, true));
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable19);
        Object var27_24 = null;
        Executable verifyClusterLinkDisabled_runnable20 = () -> clusterLinkManager.taskDescription(linkName, (TaskType)ClusterLinkSyncOffsetsTaskType$.MODULE$);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable20);
        Object var28_25 = null;
        Assertions.assertFalse((boolean)clusterLinkManager.isLinkCoordinator(linkName));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)clusterLinkManager.linkCoordinator(linkName, new ListenerName("EXTERNAL")));
        Assertions.assertTrue((boolean)clusterLinkManager.controllerListener().isEmpty());
        clusterLinkManager.processClusterLinkChanges(linkId, new Properties(), clusterLinkManager.processClusterLinkChanges$default$3());
        Executable verifyClusterLinkDisabled_runnable21 = () -> clusterLinkManager.fetcherManager(linkId);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable21);
        Object var29_26 = null;
        TopicPartition tp0 = new TopicPartition("topic", 0);
        Partition partition0 = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition0, tp0, (Option<Uuid>)new Some((Object)linkId));
        clusterLinkManager.addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
        clusterLinkManager.maybeNotifyReadyForFetch(partition0);
        Executable verifyClusterLinkDisabled_runnable22 = () -> clusterLinkManager.fetcherManager(linkId);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable22);
        Object var30_29 = null;
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = (LeaderAndIsrRequestData.LeaderAndIsrPartitionState)Mockito.mock(LeaderAndIsrRequestData.LeaderAndIsrPartitionState.class);
        clusterLinkManager.removePartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        clusterLinkManager.removePartitionsAndMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0})));
        clusterLinkManager.updateDynamicFetchSize();
        clusterLinkManager.onControllerChange(false);
        clusterLinkManager.onControllerChange(true);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)clusterLinkManager.unavailableLinkReason(linkId));
        clusterLinkManager.onMetadataPartitionLeaderElection(1, 1);
        clusterLinkManager.onMetadataPartitionLeaderResignation(1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
        Assertions.assertNotNull((Object)clusterLinkManager.clusterLinkChangeListener());
        clusterLinkManager.clusterLinkChangeListener().onClusterLinkCoordinatorElection(null);
        clusterLinkManager.clusterLinkChangeListener().onMetadataUpdate(null, null, null);
        clusterLinkManager.clusterLinkChangeListener().onControllerChange(null);
        clusterLinkManager.isAutoMirroredTopic("");
        clusterLinkManager.clusterLinkMetadataManager();
        clusterLinkManager.fetchSourceTopicInfoForMirrors((Map)Map$.MODULE$.empty(), (Map)Map$.MODULE$.empty(), null);
        clusterLinkManager.processControllerMirrorStates((Map)Map$.MODULE$.empty());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)clusterLinkManager.linkConfigFromPersistentProps(linkName, new Properties(), clusterLinkManager.linkConfigFromPersistentProps$default$3()));
        clusterLinkManager.initialize(null, null, (Option)None$.MODULE$, null, null, null, null, null, (Option)None$.MODULE$);
        clusterLinkManager.startup(clusterLinkManager.startup$default$1());
        clusterLinkManager.shutdownIdleFetcherThreads();
        clusterLinkManager.shutdown();
        invocationTracker.verifyAllMethodsTested(this.disabledNotTestedError());
    }

    @Test
    public void testAdminManagerWithClusterLinkDisabled() {
        String linkName = "testLink";
        KafkaConfig brokerConfig = this.createBrokerConfig(false);
        this.clusterLinkManager_$eq(this.createClusterLinkManager(brokerConfig));
        Assertions.assertTrue((boolean)(this.clusterLinkManager().admin() instanceof ClusterLinkDisabled.AdminManager));
        MethodInvocationTracker invocationTracker = new MethodInvocationTracker(this.clusterLinkManager().admin(), ClusterLinkFactory.AdminManager.class);
        ClusterLinkFactory.AdminManager admin = invocationTracker.proxy(this.clusterLinkManager().admin());
        Assertions.assertSame((Object)this.clusterLinkManager(), (Object)admin.clusterLinkManager());
        NewClusterLink newClusterLink = new NewClusterLink(linkName, "cluster1", CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234")}))).asJava());
        Executable verifyClusterLinkDisabled_runnable = () -> admin.createClusterLink(newClusterLink, (Option)None$.MODULE$, new ListenerName("EXTERNAL"), true, false, 10000, 1);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable);
        Object var7_6 = null;
        Executable verifyClusterLinkDisabled_runnable2 = () -> admin.validateLinksWithCreateClusterLinkRequest(new CreateClusterLinksRequest.Builder(Collections.singletonList(newClusterLink), true, true, 10000).build((short)1), Option$.MODULE$.empty(), new ListenerName(""), (Function2 & Serializable)(x$2, x$3) -> {
            ClusterLinkFactoryTest.$anonfun$testAdminManagerWithClusterLinkDisabled$3(x$2, x$3);
            return BoxedUnit.UNIT;
        });
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable2);
        Object var8_7 = null;
        Executable verifyClusterLinkDisabled_runnable3 = () -> admin.preprocessCreateClusterLinkRequest(new CreateClusterLinksRequest.Builder(Collections.singletonList(newClusterLink), true, true, 10000).build((short)1), (Map)Map$.MODULE$.empty(), (Map)Map$.MODULE$.empty(), Option$.MODULE$.empty(), new ListenerName(""));
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable3);
        Object var9_8 = null;
        Executable verifyClusterLinkDisabled_runnable4 = () -> admin.deleteClusterLink(linkName, true, true, true, 1);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable4);
        Object var10_9 = null;
        Executable verifyClusterLinkDisabled_runnable5 = () -> admin.listClusterLinks((Option)None$.MODULE$, false, 3);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable5);
        Object var11_10 = null;
        Executable verifyClusterLinkDisabled_runnable6 = () -> admin.describeClusterLinks((Option)None$.MODULE$, false, false, new ListenerName("EXTERNAL"), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFactoryTest.$anonfun$testAdminManagerWithClusterLinkDisabled$8(x$4)));
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable6);
        Object var12_11 = null;
        Executable verifyClusterLinkDisabled_runnable7 = () -> admin.listMirrors((Option)None$.MODULE$, true, 1);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable7);
        Object var13_12 = null;
        Executable verifyClusterLinkDisabled_runnable8 = () -> admin.describeMirror("topic", (Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty(), 2, false);
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable8);
        Object var14_13 = null;
        Executable verifyClusterLinkDisabled_runnable9 = () -> admin.alterMirror("topic", AlterMirrorOp.PROMOTE, true, 3, admin.alterMirror$default$5(), admin.alterMirror$default$6());
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable9);
        Object var15_14 = null;
        Executable verifyClusterLinkDisabled_runnable10 = () -> admin.setRemoteTopicsInPendingMirrorState(Uuid.randomUuid(), Option$.MODULE$.empty(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic"})), true, (Map)Map$.MODULE$.empty());
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)verifyClusterLinkDisabled_runnable10);
        Object var16_15 = null;
        IntRef callbackCount = IntRef.create((int)0);
        admin.tryCompleteElseWatch(1000L, (Seq)new .colon.colon(CompletableFuture.completedFuture(null), (List)Nil$.MODULE$), (Function0)(JFunction0.mcV.sp & Serializable)() -> ++callbackCount$1.elem);
        Assertions.assertEquals((int)1, (int)callbackCount.elem);
        Assertions.assertThrows(IllegalStateException.class, () -> admin.tryCompleteElseWatch(1000L, (Seq)new .colon.colon(new CompletableFuture(), (List)Nil$.MODULE$), (Function0)(JFunction0.mcV.sp & Serializable)() -> ++callbackCount$1.elem));
        Assertions.assertEquals((int)1, (int)callbackCount.elem);
        admin.clusterLinkingIsDisabled();
        admin.shutdown();
        invocationTracker.verifyAllMethodsTested(this.disabledNotTestedError());
    }

    private KafkaConfig createBrokerConfig(boolean enableClusterLink) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), Boolean.toString(enableClusterLink));
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private void setupMock(Partition partition, TopicPartition tp, Option<Uuid> linkId) {
        Mockito.reset((Object[])new Partition[]{partition});
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)tp);
        Mockito.when((Object)partition.getClusterLinkId()).thenReturn(linkId);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isActiveLinkDestinationLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)linkId.nonEmpty()));
        Mockito.when((Object)partition.getLinkedLeaderEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
    }

    private ClusterLinkFactory.LinkManager createClusterLinkManager(KafkaConfig brokerConfig) {
        boolean isMultiTenant = ConfluentConfigs.buildMultitenantMetadata((java.util.Map)brokerConfig.values(), (Metrics)this.metrics()) != null;
        ClusterLinkFactory.LinkManager manager = ClusterLinkFactory$.MODULE$.createLinkManager(brokerConfig, "clusterId", ClusterLinkQuotas$.MODULE$.unboundedClusterLinkQuotas(), this.metrics(), (Time)this.time(), isMultiTenant, (Option)None$.MODULE$);
        Endpoint brokerEndpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 1234);
        AuthorizerServerInfo serverInfo = (AuthorizerServerInfo)Mockito.mock(AuthorizerServerInfo.class);
        Mockito.when((Object)serverInfo.interBrokerEndpoint()).thenReturn((Object)brokerEndpoint);
        manager.initialize(serverInfo, null, (Option)None$.MODULE$, null, null, null, null, (Option)None$.MODULE$, (Option)None$.MODULE$);
        manager.startup(manager.startup$default$1());
        return manager;
    }

    private void verifyClusterLinkDisabled(Executable runnable) {
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)runnable);
    }

    public static final /* synthetic */ boolean $anonfun$testLinkManagerWithClusterLinkDisabled$5(Properties props) {
        return false;
    }

    public static final /* synthetic */ void $anonfun$testAdminManagerWithClusterLinkDisabled$3(ConfigResource x$2, Map x$3) {
    }

    public static final /* synthetic */ boolean $anonfun$testAdminManagerWithClusterLinkDisabled$8(String x$4) {
        return true;
    }

    public ClusterLinkFactoryTest() {
        this.disabledNotTestedError = "ClusterLinkDisabled methods should not throw exceptions for methods unrelated to cluster linking that may be invoked when cluster linking is disabled. Cluster link and mirror operations that are not expected when cluster linking is disabled should throw ClusterLinkDisabledException.";
    }
}

