/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.FetcherPool;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.UnboundedClusterLinkRequestQuota$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkFetcherThreadPool;
import kafka.server.link.ClusterLinkFetcherWithSharedThread;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkOutboundConnectionManager;
import kafka.server.link.ClusterLinkSelectorMetricsRegistry;
import kafka.server.link.ClusterLinkSharedFetcherThread;
import kafka.server.link.ConnectionMode;
import kafka.server.link.FetcherThreadPoolMode;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001B\u0010!\u0001\u001dBQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004F\u0001\u0001\u0006IA\u000f\u0005\b\r\u0002\u0011\r\u0011\"\u0003H\u0011\u0019\u0001\u0006\u0001)A\u0005\u0011\"9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0006B\u0002,\u0001A\u0003%1\u000bC\u0004X\u0001\t\u0007I\u0011\u0002-\t\rq\u0003\u0001\u0015!\u0003Z\u0011\u001di\u0006A1A\u0005\nyCa\u0001\u001a\u0001!\u0002\u0013y\u0006bB3\u0001\u0005\u0004%IA\u001a\u0005\u0007U\u0002\u0001\u000b\u0011B4\t\u0013-\u0004\u0001\u0019!a\u0001\n\u0013a\u0007\"\u00039\u0001\u0001\u0004\u0005\r\u0011\"\u0003r\u0011%9\b\u00011A\u0001B\u0003&Q\u000eC\u0005y\u0001\u0001\u0007\t\u0019!C\u0005s\"Ia\u0010\u0001a\u0001\u0002\u0004%Ia \u0005\u000b\u0003\u0007\u0001\u0001\u0019!A!B\u0013Q\bbCA\u0003\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000fA1\"a\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0012!Y\u0011Q\u0003\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0005\u0011\u001d\t9\u0002\u0001C\u0001\u00033Aq!!\r\u0001\t\u0003\tI\u0002C\u0004\u0002<\u0001!\t!!\u0007\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002\u001a!9\u0011\u0011\n\u0001\u0005\u0002\u0005e\u0001bBA'\u0001\u0011%\u0011q\n\u0005\b\u0003W\u0002A\u0011BA7\u0011\u001d\tI\b\u0001C\u0005\u0003w\u0012\u0001e\u00117vgR,'\u000fT5oW\u001a+Go\u00195feRC'/Z1e!>|G\u000eV3ti*\u0011\u0011EI\u0001\u0005Y&t7N\u0003\u0002$I\u000511/\u001a:wKJT\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001F\f\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\"\u0013!B;uS2\u001c\u0018BA\u001a1\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u001c\u0011\u0005]\u0002Q\"\u0001\u0011\u0002\r1Lgn[%e+\u0005Q\u0004CA\u001eD\u001b\u0005a$BA\u001f?\u0003\u0019\u0019w.\\7p]*\u0011Qe\u0010\u0006\u0003\u0001\u0006\u000ba!\u00199bG\",'\"\u0001\"\u0002\u0007=\u0014x-\u0003\u0002Ey\t!Q+^5e\u0003\u001da\u0017N\\6JI\u0002\n\u0001\u0002\\5oW:\u000bW.Z\u000b\u0002\u0011B\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\u0005Y\u0006twMC\u0001N\u0003\u0011Q\u0017M^1\n\u0005=S%AB*ue&tw-A\u0005mS:\\g*Y7fA\u00059Q.\u001a;sS\u000e\u001cX#A*\u0011\u0005]\"\u0016BA+!\u0005I\u0019E.^:uKJd\u0015N\\6NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nqc]3mK\u000e$xN]'fiJL7m\u001d*fO&\u001cHO]=\u0016\u0003e\u0003\"a\u000e.\n\u0005m\u0003#AI\"mkN$XM\u001d'j].\u001cV\r\\3di>\u0014X*\u001a;sS\u000e\u001c(+Z4jgR\u0014\u00180\u0001\rtK2,7\r^8s\u001b\u0016$(/[2t%\u0016<\u0017n\u001d;ss\u0002\nA\u0001^5nKV\tq\f\u0005\u0002aE6\t\u0011M\u0003\u00022y%\u00111-\u0019\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005Y1m\u001c8o\u001b\u0006t\u0017mZ3s+\u00059\u0007CA\u001ci\u0013\tI\u0007E\u0001\u0013DYV\u001cH/\u001a:MS:\\w*\u001e;c_VtGmQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s\u00031\u0019wN\u001c8NC:\fw-\u001a:!\u0003)a\u0017N\\6D_:4\u0017nZ\u000b\u0002[B\u0011qG\\\u0005\u0003_\u0002\u0012\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u00039a\u0017N\\6D_:4\u0017nZ0%KF$\"A];\u0011\u0005%\u001a\u0018B\u0001;+\u0005\u0011)f.\u001b;\t\u000fY|\u0011\u0011!a\u0001[\u0006\u0019\u0001\u0010J\u0019\u0002\u00171Lgn[\"p]\u001aLw\rI\u0001\rEJ|7.\u001a:D_:4\u0017nZ\u000b\u0002uB\u00111\u0010`\u0007\u0002E%\u0011QP\t\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\tce>\\WM]\"p]\u001aLwm\u0018\u0013fcR\u0019!/!\u0001\t\u000fY\u0014\u0012\u0011!a\u0001u\u0006i!M]8lKJ\u001cuN\u001c4jO\u0002\n!\u0002\u001e5sK\u0006$\u0007k\\8m+\t\tI\u0001E\u00028\u0003\u0017I1!!\u0004!\u0005q\u0019E.^:uKJd\u0015N\\6GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a)p_2\fa\u0002\u001e5sK\u0006$\u0007k\\8m?\u0012*\u0017\u000fF\u0002s\u0003'A\u0001B^\u000b\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\fi\"\u0014X-\u00193Q_>d\u0007%A\u0003tKR,\u0006\u000fF\u0001sQ\r9\u0012Q\u0004\t\u0005\u0003?\ti#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003\r\t\u0007/\u001b\u0006\u0005\u0003O\tI#A\u0004kkBLG/\u001a:\u000b\u0007\u0005-\u0012)A\u0003kk:LG/\u0003\u0003\u00020\u0005\u0005\"A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\u0019\u0003k\u0001B!a\b\u00028%!\u0011\u0011HA\u0011\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\nuKN$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\u001c\bfA\r\u0002@A!\u0011qDA!\u0013\u0011\t\u0019%!\t\u0003\tQ+7\u000f^\u0001\u0014i\u0016\u001cH\u000fR3bIRC'/Z1e\u0007>,h\u000e\u001e\u0015\u00045\u0005}\u0012\u0001\u0004;fgR\u001c\u0006.\u001e;e_^t\u0007fA\u000e\u0002@\u0005qa-\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\u001cXCAA)!\u0019\t\u0019&!\u0019\u0002h9!\u0011QKA/!\r\t9FK\u0007\u0003\u00033R1!a\u0017'\u0003\u0019a$o\\8u}%\u0019\u0011q\f\u0016\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019'!\u001a\u0003\u0007M+GOC\u0002\u0002`)\u0002B!a\u0015\u0002j%\u0019q*!\u001a\u0002+]\f\u0017\u000e\u001e$pe\u001a+Go\u00195feRC'/Z1egR\u0019!/a\u001c\t\u000f\u0005ET\u00041\u0001\u0002t\u0005)1m\\;oiB\u0019\u0011&!\u001e\n\u0007\u0005]$FA\u0002J]R\faB\\3x\u001b>\u001c7NR3uG\",'\u000f\u0006\u0004\u0002~\u0005\r\u0015q\u0011\t\u0004o\u0005}\u0014bAAAA\t\u00113\t\\;ti\u0016\u0014H*\u001b8l\r\u0016$8\r[3s/&$\bn\u00155be\u0016$G\u000b\u001b:fC\u0012Dq!!\"\u001f\u0001\u0004\t\u0019(A\u0005gKR\u001c\u0007.\u001a:JI\"9\u0011\u0011\u0012\u0010A\u0002\u0005M\u0014AD:pkJ\u001cWM\u0011:pW\u0016\u0014\u0018\n\u001a")
public class ClusterLinkFetcherThreadPoolTest
implements Logging {
    private final Uuid linkId = Uuid.randomUuid();
    private final String linkName;
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics(this.linkName(), this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, false, null, (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$, false);
    private final ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry = (ClusterLinkSelectorMetricsRegistry)Mockito.mock(ClusterLinkSelectorMetricsRegistry.class);
    private final MockTime time = new MockTime();
    private final ClusterLinkOutboundConnectionManager connManager = (ClusterLinkOutboundConnectionManager)Mockito.mock(ClusterLinkOutboundConnectionManager.class);
    private ClusterLinkConfig linkConfig;
    private KafkaConfig brokerConfig;
    private ClusterLinkFetcherThreadPool threadPool;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private String linkName() {
        return this.linkName;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry() {
        return this.selectorMetricsRegistry;
    }

    private MockTime time() {
        return this.time;
    }

    private ClusterLinkOutboundConnectionManager connManager() {
        return this.connManager;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private void linkConfig_$eq(ClusterLinkConfig x$1) {
        this.linkConfig = x$1;
    }

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private void brokerConfig_$eq(KafkaConfig x$1) {
        this.brokerConfig = x$1;
    }

    private ClusterLinkFetcherThreadPool threadPool() {
        return this.threadPool;
    }

    private void threadPool_$eq(ClusterLinkFetcherThreadPool x$1) {
        this.threadPool = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(123, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        this.brokerConfig_$eq(KafkaConfig$.MODULE$.fromProps(brokerProps));
        Properties linkProps = new Properties();
        linkProps.setProperty("bootstrap.servers", "localhost:1234");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.FetcherThreadPoolModeProp(), FetcherThreadPoolMode.Link$.MODULE$.name());
        this.linkConfig_$eq(ClusterLinkConfig$.MODULE$.create((Map)linkProps, (Option)None$.MODULE$, true));
        this.threadPool_$eq(new ClusterLinkFetcherThreadPool(this.brokerConfig(), this.linkName(), this.linkConfig(), (ClusterLinkConnectionManager)this.connManager(), this.metrics(), this.selectorMetricsRegistry(), (ClusterLinkRequestQuota)UnboundedClusterLinkRequestQuota$.MODULE$, (Time)this.time()));
    }

    @AfterEach
    public void tearDown() {
        if (this.threadPool() != null) {
            this.threadPool().shutdown();
        }
        this.waitForFetcherThreads(0);
    }

    @Test
    public void testFetcherThreads() {
        this.waitForFetcherThreads(0);
        ClusterLinkFetcherWithSharedThread fetcher1 = this.newMockFetcher(1, 5);
        ClusterLinkSharedFetcherThread thread1 = this.threadPool().assignThread(1, (FetcherPool)FetcherPool.Default$.MODULE$, 5);
        Assertions.assertEquals((int)1, (int)this.threadPool().threadPool().size());
        thread1.addFetcher(5, fetcher1);
        this.waitForFetcherThreads(1);
        Assertions.assertEquals((int)1, (int)thread1.numFetchers());
        ClusterLinkFetcherWithSharedThread fetcher2 = this.newMockFetcher(1, 6);
        ClusterLinkSharedFetcherThread thread2 = this.threadPool().assignThread(1, (FetcherPool)FetcherPool.Default$.MODULE$, 6);
        Assertions.assertEquals((int)1, (int)this.threadPool().threadPool().size());
        Assertions.assertSame((Object)thread1, (Object)thread2);
        thread2.addFetcher(6, fetcher2);
        Assertions.assertThrows(IllegalStateException.class, () -> thread2.addFetcher(6, this.newMockFetcher(1, 6)));
        this.waitForFetcherThreads(1);
        Assertions.assertEquals((int)2, (int)thread1.numFetchers());
        ClusterLinkFetcherWithSharedThread fetcher3 = this.newMockFetcher(2, 6);
        ClusterLinkSharedFetcherThread thread3 = this.threadPool().assignThread(2, (FetcherPool)FetcherPool.Default$.MODULE$, 6);
        Assertions.assertEquals((int)2, (int)this.threadPool().threadPool().size());
        Assertions.assertNotSame((Object)thread1, (Object)thread3);
        thread3.addFetcher(6, fetcher3);
        this.waitForFetcherThreads(2);
        Assertions.assertEquals((int)1, (int)thread3.numFetchers());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> this.threadPool().removeFetcher(5, fetcher1, thread3));
        Assertions.assertEquals((int)2, (int)this.threadPool().threadPool().size());
        Assertions.assertEquals((int)2, (int)thread1.numFetchers());
        Assertions.assertEquals((int)1, (int)thread3.numFetchers());
        this.threadPool().removeFetcher(5, fetcher1, thread1);
        Assertions.assertEquals((int)2, (int)this.threadPool().threadPool().size());
        Assertions.assertEquals((int)1, (int)thread1.numFetchers());
        this.threadPool().removeFetcher(6, fetcher2, thread2);
        Assertions.assertEquals((int)1, (int)this.threadPool().threadPool().size());
        this.waitForFetcherThreads(1);
        Assertions.assertEquals((int)0, (int)thread1.numFetchers());
        this.threadPool().removeFetcher(6, fetcher3, thread3);
        Assertions.assertEquals((int)0, (int)this.threadPool().threadPool().size());
        this.waitForFetcherThreads(0);
    }

    @Test
    public void testDeadThreadCount() {
        ClusterLinkSharedFetcherThread thread = this.threadPool().assignThread(1, (FetcherPool)FetcherPool.Default$.MODULE$, 5);
        thread.addFetcher(5, this.newMockFetcher(1, 5));
        thread.addFetcher(6, this.newMockFetcher(1, 6));
        Assertions.assertEquals((int)1, (int)this.threadPool().threadPool().size());
        Assertions.assertEquals((int)0, (int)this.threadPool().deadThreadCount());
        ((CountDownLatch)TestUtils.fieldValue((Object)thread, ShutdownableThread.class, (String)"shutdownComplete")).countDown();
        Assertions.assertEquals((int)1, (int)this.threadPool().deadThreadCount());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testShutdown() {
        ClusterLinkSharedFetcherThread thread1 = this.threadPool().assignThread(1, (FetcherPool)FetcherPool.Default$.MODULE$, 5);
        Assertions.assertEquals((int)1, (int)this.threadPool().threadPool().size());
        thread1.addFetcher(5, this.newMockFetcher(1, 5));
        this.waitForFetcherThreads(1);
        this.threadPool().shutdown();
        Assertions.assertTrue((boolean)thread1.isShutdownInitiated());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!thread1.isShutdownComplete()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Thread failed to complete shutdown");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Set<String> fetcherThreads() {
        return (Set)((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(Thread.getAllStackTraces().keySet()).asScala().map((Function1 & Serializable)thread -> thread.getName())).toSet().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith("ClusterLinkSharedFetcherThread")));
    }

    /*
     * WARNING - void declaration
     */
    private void waitForFetcherThreads(int count) {
        void var3_7;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Set computeUntilTrue_result;
            if (ClusterLinkFetcherThreadPoolTest.$anonfun$waitForFetcherThreads$2(count, computeUntilTrue_result = this.fetcherThreads())) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var10_5 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Set threads = (Set)tuple22._1();
        Assertions.assertEquals((int)count, (int)var3_7.size());
    }

    private ClusterLinkFetcherWithSharedThread newMockFetcher(int fetcherId, int sourceBrokerId) {
        ClusterLinkFetcherWithSharedThread fetcher = (ClusterLinkFetcherWithSharedThread)Mockito.mock(ClusterLinkFetcherWithSharedThread.class);
        Mockito.when((Object)fetcher.name()).thenReturn((Object)new StringBuilder(13).append("mockFetcher-").append(fetcherId).append("-").append(sourceBrokerId).toString());
        return fetcher;
    }

    public static final /* synthetic */ boolean $anonfun$testShutdown$1(ClusterLinkSharedFetcherThread thread1$1) {
        return thread1$1.isShutdownComplete();
    }

    public static final /* synthetic */ String $anonfun$testShutdown$2() {
        return "Thread failed to complete shutdown";
    }

    public static final /* synthetic */ boolean $anonfun$waitForFetcherThreads$2(int count$1, Set x$6) {
        return x$6.size() == count$1;
    }

    public ClusterLinkFetcherThreadPoolTest() {
        this.linkName = "testLink";
    }

    public static final /* synthetic */ Object $anonfun$waitForFetcherThreads$2$adapted(int count$1, Set x$6) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherThreadPoolTest.$anonfun$waitForFetcherThreads$2(count$1, x$6));
    }
}

