/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AsyncSend;
import kafka.server.BlockingSend;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.FailedPartitions;
import kafka.server.FetcherPool;
import kafka.server.FollowerThrottler;
import kafka.server.KafkaConfig;
import kafka.server.OffsetTruncationState;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.UnboundedClusterLinkRequestQuota$;
import kafka.server.link.ClusterLinkAsyncLeaderEndPoint;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkFetcherThreadPool;
import kafka.server.link.ClusterLinkFetcherThreadTest;
import kafka.server.link.ClusterLinkFetcherWithSharedThread;
import kafka.server.link.ClusterLinkFollowerFetchThrottler;
import kafka.server.link.ClusterLinkLeaderRequestBuilder;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSharedFetcherThread;
import kafka.server.link.FetchResponseSize;
import kafka.tier.fetcher.TierStateFetcher;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005f\u0001\u0002\"D\u0001)CQa\u0014\u0001\u0005\u0002ACqA\u0015\u0001C\u0002\u0013%1\u000b\u0003\u0004X\u0001\u0001\u0006I\u0001\u0016\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019)\u0007\u0001)A\u00055\"Ia\r\u0001a\u0001\u0002\u0004%Ia\u001a\u0005\f\u0005\u0013\u0002\u0001\u0019!a\u0001\n\u0013\u0011Y\u0005\u0003\u0006\u0003R\u0001\u0001\r\u0011!Q!\n!D\u0011Ba\u0015\u0001\u0005\u0004%IA!\u0016\t\u0011\tu\u0003\u0001)A\u0005\u0005/B1Ba\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003b!Y!q\u001a\u0001A\u0002\u0003\u0007I\u0011\u0002Bi\u0011-\u0011)\u000e\u0001a\u0001\u0002\u0003\u0006KAa\u0019\t\u0013\t]\u0007A1A\u0005\n\te\u0007\u0002\u0003Bt\u0001\u0001\u0006IAa7\t\u000f\t%\b\u0001\"\u0001\u0003\f!91\u0011\u0001\u0001\u0005B\r\r\u0001bBB\u0006\u0001\u0011E3Q\u0002\u0005\n\u0007W\u0001\u0011\u0013!C\t\u0007[A\u0011ba\u0011\u0001#\u0003%\tb!\u0012\t\u000f\r%\u0003\u0001\"\u0015\u0004L!91q\u0012\u0001\u0005\u0002\t-\u0001bBBM\u0001\u0011\u0005!1\u0002\u0005\b\u0007;\u0003A\u0011\u0001B\u0006\r\u0011Q\u0007\u0001A6\t\u0013=L\"\u0011!Q\u0001\nAl\b\u0002\u0003@\u001a\u0005\u0003\u0005\u000b\u0011B@\t\u0015\u0005\u001d\u0011D!A!\u0002\u0013\tI\u0001C\u0005\u0002\u0012e\u0011\t\u0011)A\u0005a\"Q\u00111C\r\u0003\u0002\u0003\u0006I!!\u0006\t\u0015\u0005\u0005\u0012D!A!\u0002\u0013\t\u0019\u0003\u0003\u0006\u0002*e\u0011\t\u0011)A\u0005\u0003WAA\"!\r\u001a\u0005\u0003\u0005\u000b\u0011BA\u001a\u0003sA!\"!\u0011\u001a\u0005\u0003\u0005\u000b\u0011BA\"\u0011)\tI%\u0007B\u0001B\u0003%\u00111\n\u0005\u000b\u0003#J\"\u0011!Q\u0001\n\u0005M\u0003BCA-3\t\u0005\t\u0015!\u0003\u0002\\!Q\u0011\u0011M\r\u0003\u0002\u0003\u0006I!a\u0019\t\u0015\u0005M\u0014D!A!\u0002\u0013\t)\b\u0003\u0006\u0002|e\u0011\t\u0011)A\u0005\u0003{B!\"a!\u001a\u0005\u0003\u0005\u000b\u0011BAC\u0011\u0019y\u0015\u0004\"\u0001\u0002\f\"I\u0011QV\rC\u0002\u0013\u0005\u0011q\u0016\u0005\t\u0003\u0003L\u0002\u0015!\u0003\u00022\"9\u00111Y\r\u0005B\u0005\u0015\u0007bBAr3\u0011\u0005\u0013Q\u001d\u0005\b\u0003gLB\u0011IA{\u0011\u001d\u0011I!\u0007C!\u0005\u0017AqA!\u0004\u001a\t\u0003\u0011Y\u0001C\u0004\u0003\u0010e!\tE!\u0005\t\u000f\tM\u0011\u0004\"\u0015\u0003\u0016!9!\u0011I\r\u0005\n\t\rcA\u0002B3\u0001\u0001\u00119\u0007\u0003\u0007\u0002BU\u0012\t\u0011)A\u0005\u0003\u0007\u0012y\u0007C\u0006\u0003rU\u0012\t\u0011)A\u0005a\nM\u0004\u0002\u0004B;k\t\u0005\t\u0015!\u0003\u0003x\tu\u0004B\u0003B@k\t\u0005\t\u0015!\u0003\u0003\u0002\"Q!1V\u001b\u0003\u0002\u0003\u0006I!!8\t\u0015\t5VG!A!\u0002\u0013\ti\u000e\u0003\u0004Pk\u0011\u0005!q\u0016\u0005\n\u0005{+\u0004\u0019!C\u0005\u0005\u007fC\u0011B!16\u0001\u0004%IAa1\t\u000f\t\u001dW\u0007)Q\u0005\u007f\"9!\u0011Z\u001b\u0005B\t-\u0007b\u0002Bgk\u0011\u0005!q\u0018\u0002'\u00072,8\u000f^3s\u0019&t7NR3uG\",'oV5uQNC\u0017M]3e)\"\u0014X-\u00193UKN$(B\u0001#F\u0003\u0011a\u0017N\\6\u000b\u0005\u0019;\u0015AB:feZ,'OC\u0001I\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A&\u0011\u00051kU\"A\"\n\u00059\u001b%\u0001H\"mkN$XM\u001d'j].4U\r^2iKJ$\u0006N]3bIR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0003\"\u0001\u0014\u0001\u00021\rdWo\u001d;fe2Kgn\u001b(fi^|'o[\"mS\u0016tG/F\u0001U!\taU+\u0003\u0002W\u0007\nA2\t\\;ti\u0016\u0014H*\u001b8l\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u00023\rdWo\u001d;fe2Kgn\u001b(fi^|'o[\"mS\u0016tG\u000fI\u0001\u000e]\u0016$xo\u001c:l\u00072LWM\u001c;\u0016\u0003i\u0003\"aW2\u000e\u0003qS!!\u00180\u0002\u000f\rd\u0017.\u001a8ug*\u0011\u0001j\u0018\u0006\u0003A\u0006\fa!\u00199bG\",'\"\u00012\u0002\u0007=\u0014x-\u0003\u0002e9\nia*\u001a;x_J\\7\t\\5f]R\faB\\3uo>\u00148n\u00117jK:$\b%A\u0007gKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u000b\u0002QB\u0011\u0011.G\u0007\u0002\u0001\t9b)\u001a;dQ\u0016\u0014x+\u001b;i'\"\f'/\u001a3UQJ,\u0017\rZ\n\u000331\u0004\"\u0001T7\n\u00059\u001c%AI\"mkN$XM\u001d'j].4U\r^2iKJ<\u0016\u000e\u001e5TQ\u0006\u0014X\r\u001a+ie\u0016\fG-\u0001\u0003oC6,\u0007CA9{\u001d\t\u0011\b\u0010\u0005\u0002tm6\tAO\u0003\u0002v\u0013\u00061AH]8pizR\u0011a^\u0001\u0006g\u000e\fG.Y\u0005\u0003sZ\fa\u0001\u0015:fI\u00164\u0017BA>}\u0005\u0019\u0019FO]5oO*\u0011\u0011P^\u0005\u0003_6\f\u0011BZ3uG\",'/\u00133\u0011\t\u0005\u0005\u00111A\u0007\u0002m&\u0019\u0011Q\u0001<\u0003\u0007%sG/A\u0006gKR\u001c\u0007.\u001a:Q_>d\u0007\u0003BA\u0006\u0003\u001bi\u0011!R\u0005\u0004\u0003\u001f)%a\u0003$fi\u000eDWM\u001d)p_2\f\u0001b\u00197jK:$\u0018\nZ\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111D$\u0002\u000f\rdWo\u001d;fe&!\u0011qDA\r\u00059\u0011%o\\6fe\u0016sG\rU8j]R\fAb\u001d5be\u0016$G\u000b\u001b:fC\u0012\u00042\u0001TA\u0013\u0013\r\t9c\u0011\u0002\u001f\u00072,8\u000f^3s\u0019&t7n\u00155be\u0016$g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\f1\"Y:z]\u000e\u001cVM\u001c3feB!\u00111BA\u0017\u0013\r\ty#\u0012\u0002\n\u0003NLhnY*f]\u0012\f1\"Y:z]\u000edU-\u00193feB\u0019A*!\u000e\n\u0007\u0005]2I\u0001\u0010DYV\u001cH/\u001a:MS:\\\u0017i]=oG2+\u0017\rZ3s\u000b:$\u0007k\\5oi&!\u00111HA\u001f\u0003\u0019aW-\u00193fe&\u0019\u0011qH#\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\u0006a!M]8lKJ\u001cuN\u001c4jOB!\u00111BA#\u0013\r\t9%\u0012\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\tdYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u00042\u0001TA'\u0013\r\tye\u0011\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0017\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t!\u0011\tY!!\u0016\n\u0007\u0005]SI\u0001\tGC&dW\r\u001a)beRLG/[8og\u0006\u0001\u0002/Y;tK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0005\u0003\u0017\ti&C\u0002\u0002`\u0015\u0013\u0001\u0003U1vg\u0016$\u0007+\u0019:uSRLwN\\:\u0002%\u0015D\bo\u001c8f]RL\u0017\r\u001c\"bG.|gM\u001a\t\u0005\u0003K\ny'\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003\u0015)H/\u001b7t\u0015\r\tiGX\u0001\u0007G>lWn\u001c8\n\t\u0005E\u0014q\r\u0002\u0013\u000bb\u0004xN\\3oi&\fGNQ1dW>4g-\u0001\u0006sKBd\u0017nY1NOJ\u0004B!a\u0003\u0002x%\u0019\u0011\u0011P#\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB!\u00111BA@\u0013\r\t\t)\u0012\u0002\r%\u0016\u0004H.[2b#V|G/Y\u0001\u0005i&lW\r\u0005\u0003\u0002f\u0005\u001d\u0015\u0002BAE\u0003O\u0012A\u0001V5nKR\t\u0003.!$\u0002\u0010\u0006E\u00151SAK\u0003/\u000bI*a'\u0002\u001e\u0006}\u0015\u0011UAR\u0003K\u000b9+!+\u0002,\")qN\u000ba\u0001a\")aP\u000ba\u0001\u007f\"9\u0011q\u0001\u0016A\u0002\u0005%\u0001BBA\tU\u0001\u0007\u0001\u000fC\u0004\u0002\u0014)\u0002\r!!\u0006\t\u000f\u0005\u0005\"\u00061\u0001\u0002$!9\u0011\u0011\u0006\u0016A\u0002\u0005-\u0002bBA\u0019U\u0001\u0007\u00111\u0007\u0005\b\u0003\u0003R\u0003\u0019AA\"\u0011\u001d\tIE\u000ba\u0001\u0003\u0017Bq!!\u0015+\u0001\u0004\t\u0019\u0006C\u0004\u0002Z)\u0002\r!a\u0017\t\u000f\u0005\u0005$\u00061\u0001\u0002d!9\u00111\u000f\u0016A\u0002\u0005U\u0004bBA>U\u0001\u0007\u0011Q\u0010\u0005\b\u0003\u0007S\u0003\u0019AAC\u000351W\r^2iKJ\u001cF/\u0019;fgV\u0011\u0011\u0011\u0017\t\u0006\u0003g\u000bi\f]\u0007\u0003\u0003kSA!a.\u0002:\u00069Q.\u001e;bE2,'bAA^m\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0016Q\u0017\u0002\u0007\u0005V4g-\u001a:\u0002\u001d\u0019,Go\u00195feN#\u0018\r^3tA\u0005I2\r\\3beB\u000b'\u000f^5uS>tG*\u001b8l\r\u0006LG.\u001e:f)\u0019\t9-!4\u0002ZB!\u0011\u0011AAe\u0013\r\tYM\u001e\u0002\u0005+:LG\u000fC\u0004\u0002P6\u0002\r!!5\u0002\u0005Q\u0004\b\u0003BAj\u0003+l!!a\u001b\n\t\u0005]\u00171\u000e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\tY.\fa\u0001\u0003;\f1BZ3uG\"|eMZ:fiB!\u0011\u0011AAp\u0013\r\t\tO\u001e\u0002\u0005\u0019>tw-A\beK2\f\u0017\u0010U1si&$\u0018n\u001c8t)\u0011\t9-a:\t\u000f\u0005%h\u00061\u0001\u0002l\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\r\u00055\u0018q^Ai\u001b\t\tI,\u0003\u0003\u0002r\u0006e&\u0001C%uKJ\f'\r\\3\u00021Y\fG.\u001b3bi\u0016l\u0015N\u001d:peR\u0013XO\\2bi&|g\u000e\u0006\u0004\u0002x\u0006u\u0018q \t\u0005\u0003\u0003\tI0C\u0002\u0002|Z\u0014qAQ8pY\u0016\fg\u000eC\u0004\u0002P>\u0002\r!!5\t\u000f\t\u0005q\u00061\u0001\u0003\u0004\u0005)rN\u001a4tKR$&/\u001e8dCRLwN\\*uCR,\u0007\u0003BA\u0006\u0005\u000bI1Aa\u0002F\u0005UyeMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\fa\u0001Z8X_J\\GCAAd\u0003I!wnV8sW>sW-\u0013;fe\u0006$\u0018n\u001c8\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^tGCAA|\u0003I)\b\u000fZ1uK\u001a+Go\u00195feN#\u0018\r^3\u0015\t\u0005](q\u0003\u0005\b\u00053\u0019\u0004\u0019\u0001B\u000e\u0003A\u0019H/\u0019;f)J\fgn\u001d4pe6,'\u000f\u0005\u0005\u0002\u0002\tu!\u0011\u0005B\u001e\u0013\r\u0011yB\u001e\u0002\n\rVt7\r^5p]F\u0002BAa\t\u000369!!Q\u0005B\u0019\u001d\u0011\u00119Ca\f\u000f\t\t%\"Q\u0006\b\u0004g\n-\u0012\"\u0001%\n\u0005\u0019;\u0015B\u0001#F\u0013\r\u0011\u0019dQ\u0001\u0019\u00072,8\u000f^3s\u0019&t7NR3uG\",'\u000f\u00165sK\u0006$\u0017\u0002\u0002B\u001c\u0005s\u0011ABR3uG\",'o\u0015;bi\u0016T1Aa\rD!\u0019\t\tA!\u0010\u0003\"%\u0019!q\b<\u0003\r=\u0003H/[8o\u0003=\tG\r\u001a$fi\u000eDWM]*uCR,G\u0003BAd\u0005\u000bBqAa\u00125\u0001\u0004\u0011\t#A\u0003ti\u0006$X-A\tgKR\u001c\u0007.\u001a:UQJ,\u0017\rZ0%KF$B!a2\u0003N!A!qJ\u0004\u0002\u0002\u0003\u0007\u0001.A\u0002yIE\naBZ3uG\",'\u000f\u00165sK\u0006$\u0007%\u0001\u0007sKF,Xm\u001d;Rk>$\u0018-\u0006\u0002\u0003XA!\u00111\u0002B-\u0013\r\u0011Y&\u0012\u0002\u0018\u00072,8\u000f^3s\u0019&t7NU3rk\u0016\u001cH/U;pi\u0006\fQB]3rk\u0016\u001cH/U;pi\u0006\u0004\u0013aE2mkN$XM\u001d'j].lU\r^1eCR\fWC\u0001B2!\tIWG\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018MR8s)\u0016\u001cHoE\u00026\u0005S\u00022\u0001\u0014B6\u0013\r\u0011ig\u0011\u0002\u0014\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y\u0005\u0005\u0003\u0003\u0012Y'\u0001\u0005mS:\\g*Y7f\u0013\u0011\u0011\tHa\u001b\u0002\r1Lgn[%e!\u0011\t\u0019N!\u001f\n\t\tm\u00141\u000e\u0002\u0005+VLG-\u0003\u0003\u0003v\t-\u0014\u0001\u00037j].lu\u000eZ3\u0011\t\t\r%Q\u0015\b\u0005\u0005\u000b\u0013yJ\u0004\u0003\u0003\b\nme\u0002\u0002BE\u0005/sAAa#\u0003\u0012:\u00191O!$\n\u0005\t=\u0015AA5p\u0013\u0011\u0011\u0019J!&\u0002\u0013\r|gN\u001a7vK:$(B\u0001BH\u0013\rA%\u0011\u0014\u0006\u0005\u0005'\u0013)*C\u0002E\u0005;S1\u0001\u0013BM\u0013\u0011\u0011\tKa)\u0002#\rcWo\u001d;fe2Kgn[\"p]\u001aLwMC\u0002E\u0005;KAAa*\u0003*\nAA*\u001b8l\u001b>$WM\u0003\u0003\u0003\"\n\r\u0016\u0001G7fi\u0006$\u0017\r^1SK\u001a\u0014Xm\u001d5CC\u000e\\wN\u001a4Ng\u0006\u0001R.\u001a;bI\u0006$\u0018-T1y\u0003\u001e,Wj\u001d\u000b\u000f\u0005G\u0012\tLa-\u00036\n]&\u0011\u0018B^\u0011\u001d\t\t\u0005\u0010a\u0001\u0003\u0007BaA!\u001d=\u0001\u0004\u0001\bb\u0002B;y\u0001\u0007!q\u000f\u0005\b\u0005\u007fb\u0004\u0019\u0001BA\u0011\u001d\u0011Y\u000b\u0010a\u0001\u0003;DqA!,=\u0001\u0004\ti.A\tok6\u0014V-];fgR,\u0006\u000fZ1uKN,\u0012a`\u0001\u0016]Vl'+Z9vKN$X\u000b\u001d3bi\u0016\u001cx\fJ3r)\u0011\t9M!2\t\u0011\t=c(!AA\u0002}\f!C\\;n%\u0016\fX/Z:u+B$\u0017\r^3tA\u0005i!/Z9vKN$X\u000b\u001d3bi\u0016$\u0012a`\u0001\u0014e\u0016\fX/Z:u+B$\u0017\r^3t\u0007>,h\u000e^\u0001\u0018G2,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y0%KF$B!a2\u0003T\"I!q\n\u0007\u0002\u0002\u0003\u0007!1M\u0001\u0015G2,8\u000f^3s\u0019&t7.T3uC\u0012\fG/\u0019\u0011\u0002-\rDWmY6q_&tG/\u001a3QCJ$\u0018\u000e^5p]N,\"Aa7\u0011\r\u0005M&Q\u001cBq\u0013\u0011\u0011y.!.\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0006\u0003[\u0014\u0019\u000f]\u0005\u0005\u0005K\fILA\u0002TKR\fqc\u00195fG.\u0004x.\u001b8uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u000bM,G/\u00169)\u0007A\u0011i\u000f\u0005\u0003\u0003p\nuXB\u0001By\u0015\u0011\u0011\u0019P!>\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0003x\ne\u0018a\u00026va&$XM\u001d\u0006\u0004\u0005w\f\u0017!\u00026v]&$\u0018\u0002\u0002B\u0000\u0005c\u0014!BQ3g_J,W)Y2i\u0003MqWm^'pG.\u0014En\\2lS:<7+\u001a8e)\t\u0019)\u0001\u0005\u0003\u0002\f\r\u001d\u0011bAB\u0005\u000b\na!\t\\8dW&twmU3oI\u0006Q2M]3bi\u0016\u0014V-\\8uK2+\u0017\rZ3s\u000b:$\u0007k\\5oiRq\u00111GB\b\u0007#\u0019\u0019b!\u0006\u0004\u001a\r\u0015\u0002bBA!%\u0001\u0007\u00111\t\u0005\b\u0003g\u0012\u0002\u0019AA;\u0011\u001d\tYH\u0005a\u0001\u0003{Bqaa\u0006\u0013\u0001\u0004\u0019)!\u0001\u000emK\u0006$WM]#oIB|\u0017N\u001c;CY>\u001c7.\u001b8h'\u0016tG\rC\u0005\u0004\u001cI\u0001\n\u00111\u0001\u0004\u001e\u0005iAn\\4D_:$X\r\u001f;PaR\u0004b!!\u0001\u0003>\r}\u0001\u0003BA3\u0007CIAaa\t\u0002h\tQAj\\4D_:$X\r\u001f;\t\u0013\r\u001d\"\u0003%AA\u0002\r%\u0012a\u0002;j[\u0016|\u0005\u000f\u001e\t\u0007\u0003\u0003\u0011i$!\"\u0002I\r\u0014X-\u0019;f%\u0016lw\u000e^3MK\u0006$WM]#oIB{\u0017N\u001c;%I\u00164\u0017-\u001e7uIU*\"aa\f+\t\ru1\u0011G\u0016\u0003\u0007g\u0001Ba!\u000e\u0004@5\u00111q\u0007\u0006\u0005\u0007s\u0019Y$A\u0005v]\u000eDWmY6fI*\u00191Q\b<\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004B\r]\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!3M]3bi\u0016\u0014V-\\8uK2+\u0017\rZ3s\u000b:$\u0007k\\5oi\u0012\"WMZ1vYR$c'\u0006\u0002\u0004H)\"1\u0011FB\u0019\u0003i\u0019'/Z1uKJ+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1e)y\u0019iea\u0015\u0004V\r]3\u0011LB.\u0007;\u001ayf!\u0019\u0004d\rE41OB;\u0007o\u001ai\t\u0005\u0003\u0002\f\r=\u0013bAB)\u000b\n!\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012DQa\\\u000bA\u0002ADQA`\u000bA\u0002}Dq!a\u0005\u0016\u0001\u0004\t)\u0002C\u0004\u0002BU\u0001\r!a\u0011\t\u000f\u0005ES\u00031\u0001\u0002T!9\u0011\u0011L\u000bA\u0002\u0005m\u0003bBA1+\u0001\u0007\u00111\r\u0005\b\u0003g*\u0002\u0019AA;\u0011\u001d\u0019)'\u0006a\u0001\u0007O\nq!\\3ue&\u001c7\u000f\u0005\u0003\u0004j\r5TBAB6\u0015\u0011\u0019)'a\u001b\n\t\r=41\u000e\u0002\b\u001b\u0016$(/[2t\u0011\u001d\t\u0019)\u0006a\u0001\u0003\u000bCq!a\u001f\u0016\u0001\u0004\ti\bC\u0004\u0004\u0018U\u0001\ra!\u0002\t\u000f\reT\u00031\u0001\u0004|\u0005\u0001B/[3s'R\fG/\u001a$fi\u000eDWM\u001d\t\u0007\u0003\u0003\u0011id! \u0011\t\r}4\u0011R\u0007\u0003\u0007\u0003SAaa!\u0004\u0006\u00069a-\u001a;dQ\u0016\u0014(bABD\u000f\u0006!A/[3s\u0013\u0011\u0019Yi!!\u0003!QKWM]*uCR,g)\u001a;dQ\u0016\u0014\b\"CB\u000e+A\u0005\t\u0019AB\u000f\u0003m!Xm\u001d;GKR\u001c\u0007.\u001a:Ti\u0006$X\r\u0016:b]NLG/[8og\"\u001aaca%\u0011\t\t=8QS\u0005\u0005\u0007/\u0013\tP\u0001\u0003UKN$\u0018!\b;fgR\u001c\u0005.Z2la>Lg\u000e\u001e*fG>4XM]=PM\u001a\u001cX\r^:)\u0007]\u0019\u0019*\u0001\u0010uKN$X\t]8dQ\u0016sGm\u00144gg\u0016$(+Z9vKN$XI\u001d:pe\"\u001a\u0001da%")
public class ClusterLinkFetcherWithSharedThreadTest
extends ClusterLinkFetcherThreadTest {
    private final ClusterLinkNetworkClient kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkNetworkClient = (ClusterLinkNetworkClient)Mockito.mock(ClusterLinkNetworkClient.class);
    private final NetworkClient networkClient = (NetworkClient)Mockito.mock(NetworkClient.class);
    private FetcherWithSharedThread fetcherThread;
    private final ClusterLinkRequestQuota requestQuota = UnboundedClusterLinkRequestQuota$.MODULE$;
    private ClusterLinkMetadataForTest kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkMetadata;
    private final ArrayBuffer<Set<String>> kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$checkpointedPartitions = ArrayBuffer$.MODULE$.empty();

    public ClusterLinkNetworkClient kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkNetworkClient() {
        return this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkNetworkClient;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private FetcherWithSharedThread fetcherThread() {
        return this.fetcherThread;
    }

    private void fetcherThread_$eq(FetcherWithSharedThread x$1) {
        this.fetcherThread = x$1;
    }

    private ClusterLinkRequestQuota requestQuota() {
        return this.requestQuota;
    }

    public ClusterLinkMetadataForTest kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkMetadata() {
        return this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkMetadata;
    }

    private void clusterLinkMetadata_$eq(ClusterLinkMetadataForTest x$1) {
        this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkMetadata = x$1;
    }

    public ArrayBuffer<Set<String>> kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$checkpointedPartitions() {
        return this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$checkpointedPartitions;
    }

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkNetworkClient().networkClient()).thenReturn((Object)this.networkClient());
    }

    @Override
    public BlockingSend newMockBlockingSend() {
        return (BlockingSend)Mockito.mock(AsyncSend.class);
    }

    public ClusterLinkAsyncLeaderEndPoint createRemoteLeaderEndPoint(KafkaConfig brokerConfig, ReplicaManager replicaMgr, ReplicaQuota quota, BlockingSend leaderEndpointBlockingSend, Option<LogContext> logContextOpt, Option<Time> timeOpt) {
        LogContext logContext = (LogContext)logContextOpt.getOrElse((Function0 & Serializable)() -> new LogContext());
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, leaderEndpointBlockingSend.brokerEndPoint().id());
        ClusterLinkLeaderRequestBuilder requestBuilder = new ClusterLinkLeaderRequestBuilder(this.clusterLinkConfig(), (Time)timeOpt.getOrElse((Function0 & Serializable)() -> new SystemTime()));
        ClusterLinkFollowerFetchThrottler throttler = new ClusterLinkFollowerFetchThrottler();
        return new ClusterLinkAsyncLeaderEndPoint(this, logContext, leaderEndpointBlockingSend, fetchSessionHandler, requestBuilder, throttler, brokerConfig, replicaMgr, quota){
            private final /* synthetic */ ClusterLinkFetcherWithSharedThreadTest $outer;

            public boolean isReadyForFetch(TopicPartition tp) {
                return true;
            }

            public MetadataResponseData.MetadataResponseTopic fetchTopicMetadata(String topic) {
                this.$outer.leaderEndPointException().foreach((Function1 & Serializable)e -> {
                    throw e;
                });
                return new MetadataResponseData.MetadataResponseTopic().setTopicId(this.$outer.sourceTopicId());
            }

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                this.$outer.leaderEndPointException().foreach((Function1 & Serializable)e -> {
                    throw e;
                });
                if (this.$outer.epochEndOffsets().isEmpty()) {
                    return super.fetchEpochEndOffsets(partitions);
                }
                return this.$outer.epochEndOffsets();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(logContext$1.logPrefix(), (AsyncSend)leaderEndpointBlockingSend$1, $outer.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkNetworkClient(), fetchSessionHandler$1, requestBuilder$1, (FollowerThrottler)throttler$1, brokerConfig$1, $outer.clusterLinkConfig(), replicaMgr$1, quota$1, $outer.clusterLinkMetrics());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetchEpochEndOffsets$1(java.lang.Exception ), $anonfun$fetchTopicMetadata$1(java.lang.Exception )}, serializedLambda);
            }
        };
    }

    @Override
    public Option<LogContext> createRemoteLeaderEndPoint$default$5() {
        return None$.MODULE$;
    }

    @Override
    public Option<Time> createRemoteLeaderEndPoint$default$6() {
        return None$.MODULE$;
    }

    @Override
    public ReplicaFetcherThread createReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, BlockingSend leaderEndpointBlockingSend, Option<TierStateFetcher> tierStateFetcher, Option<LogContext> logContextOpt) {
        ClusterLinkSharedFetcherThread sharedThread = new ClusterLinkFetcherThreadPool(brokerConfig, this.clusterLinkName(), this.clusterLinkConfig(), (ClusterLinkConnectionManager)this.connManager(), this.clusterLinkMetrics(), this.selectorMetricsRegistry(), this.requestQuota(), time).assignThread(fetcherId, (FetcherPool)FetcherPool.Default$.MODULE$, sourceBroker.id());
        AsyncSend asyncSend = (AsyncSend)leaderEndpointBlockingSend;
        ClusterLinkAsyncLeaderEndPoint leader = this.createRemoteLeaderEndPoint(brokerConfig, replicaMgr, quota, (BlockingSend)asyncSend, logContextOpt, (Option<Time>)new Some((Object)time));
        this.clusterLinkMetadata_$eq(new ClusterLinkMetadataForTest(brokerConfig, this.clusterLinkName(), this.clusterLinkId(), ClusterLinkConfig.LinkMode.DESTINATION, 100L, 60000L));
        FetcherWithSharedThread fetcherThread = new FetcherWithSharedThread(this, name, fetcherId, sourceBroker, sharedThread, asyncSend, leader, brokerConfig, failedPartitions, pausedPartitions, exponentialBackoff, replicaMgr, quota, time){
            private final /* synthetic */ ClusterLinkFetcherWithSharedThreadTest $outer;

            public void checkpointRecoveryOffsets(ArrayBuffer<TopicPartition> topicPartitions) {
                super.checkpointRecoveryOffsets(topicPartitions);
                this.$outer.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$checkpointedPartitions().$plus$eq((Object)((IterableOnceOps)topicPartitions.map((Function1 & Serializable)x$3 -> x$3.toString())).toSet());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer, name$1, fetcherId$1, (FetcherPool)FetcherPool.Default$.MODULE$, new StringBuilder(10).append("fetcher-").append(fetcherId$1).append("-").append(sourceBroker$1.id()).append("-").append(FetcherPool.Default$.MODULE$.name()).toString(), sourceBroker$1, sharedThread$1, asyncSend$1, leader$1, brokerConfig$2, $outer.clusterLinkConfig(), failedPartitions$1, pausedPartitions$1, exponentialBackoff$1, replicaMgr$2, quota$2, time$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$checkpointRecoveryOffsets$1(org.apache.kafka.common.TopicPartition )}, serializedLambda);
            }
        };
        this.fetcherThread_$eq(fetcherThread);
        return fetcherThread;
    }

    @Test
    public void testFetcherStateTransitions() {
        super.shouldTruncateToOffsetSpecifiedInEpochOffsetResponse();
        Assertions.assertEquals((Object)new .colon.colon((Object)"MaybeTruncate", (List)new .colon.colon((Object)"AwaitingTruncateOffsetResponse", (List)new .colon.colon((Object)"MaybeCheckpointRecoveryOffsets", (List)new .colon.colon((Object)"MaybeFetch", (List)new .colon.colon((Object)"AwaitingFetchResponse", (List)new .colon.colon((Object)"MaybeTransitionTierStates", (List)new .colon.colon((Object)"MaybeTruncate", (List)Nil$.MODULE$))))))), this.fetcherThread().fetcherStates());
        Assertions.assertEquals((Object)new .colon.colon((Object)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic1-0", "topic2-1"}))), (List)Nil$.MODULE$), (Object)this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$checkpointedPartitions().toSeq());
        this.fetcherThread().fetcherStates().clear();
        this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$checkpointedPartitions().clear();
        this.fetcherThread().removePartitions(this.fetcherThread().partitions());
        this.fetcherThread().doWork();
        Assertions.assertEquals((Object)new .colon.colon((Object)"MaybeTruncate", (List)new .colon.colon((Object)"MaybeCheckpointRecoveryOffsets", (List)new .colon.colon((Object)"MaybeFetch", (List)new .colon.colon((Object)"AwaitingPartitions", (List)Nil$.MODULE$)))), this.fetcherThread().fetcherStates());
        Assertions.assertEquals((Object)new .colon.colon((Object)((Set)Set$.MODULE$.empty()), (List)Nil$.MODULE$), (Object)this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$checkpointedPartitions().toSeq());
        this.fetcherThread().fetcherStates().clear();
        this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$checkpointedPartitions().clear();
        this.fetcherThread().initiateShutdown();
        Assertions.assertEquals((Object)new .colon.colon((Object)"AwaitingPartitions", (List)new .colon.colon((Object)"FetcherShutdown", (List)Nil$.MODULE$)), this.fetcherThread().fetcherStates());
    }

    @Test
    public void testCheckpointRecoveryOffsets() {
        super.setupFetcherThreadAtTruncatingState();
        this.mockNetwork().setExceptionForNextOffsetsForLeaderEpochRequest(new IOException());
        this.fetcherThread().doWorkOneIteration();
        Assertions.assertEquals((Object)new .colon.colon((Object)"MaybeTruncate", (List)new .colon.colon((Object)"AwaitingTruncateOffsetResponse", (List)Nil$.MODULE$)), this.fetcherThread().fetcherStates());
        Assertions.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$checkpointedPartitions().toSeq());
        this.fetcherThread().fetcherStates().clear();
        this.fetcherThread().doWorkOneIteration();
        Assertions.assertEquals((Object)new .colon.colon((Object)"AwaitingTruncateOffsetResponse", (List)new .colon.colon((Object)"MaybeTruncate", (List)new .colon.colon((Object)"AwaitingTruncateOffsetResponse", (List)Nil$.MODULE$))), this.fetcherThread().fetcherStates());
        Assertions.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$checkpointedPartitions().toSeq());
        this.fetcherThread().fetcherStates().clear();
        this.fetcherThread().doWorkOneIteration();
        Assertions.assertEquals((Object)new .colon.colon((Object)"AwaitingTruncateOffsetResponse", (List)new .colon.colon((Object)"MaybeCheckpointRecoveryOffsets", (List)new .colon.colon((Object)"MaybeFetch", (List)new .colon.colon((Object)"AwaitingPartitions", (List)Nil$.MODULE$)))), this.fetcherThread().fetcherStates());
        Assertions.assertEquals((Object)new .colon.colon((Object)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic1-0", "topic1-1"}))), (List)Nil$.MODULE$), (Object)this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$checkpointedPartitions().toSeq());
    }

    @Test
    public void testEpochEndOffsetRequestError() {
        super.setupFetcherThreadAtTruncatingState();
        Assertions.assertEquals((int)this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkMetadata().requestUpdatesCount(), (int)0);
        this.fetcherThread().doWork();
        Assertions.assertEquals((int)this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkMetadata().requestUpdatesCount(), (int)0);
        Assertions.assertEquals((int)this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkMetadata().requestUpdatesCount(), (int)0);
        this.mockNetwork().setExceptionForNextOffsetsForLeaderEpochRequest(new IOException());
        this.fetcherThread().doWork();
        Assertions.assertEquals((int)this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkMetadata().requestUpdatesCount(), (int)1);
        this.mockNetwork().setExceptionForNextOffsetsForLeaderEpochRequest((Throwable)new NetworkException());
        this.fetcherThread().doWork();
        Assertions.assertEquals((int)this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkMetadata().requestUpdatesCount(), (int)2);
        this.mockNetwork().setExceptionForNextOffsetsForLeaderEpochRequest((Throwable)new TimeoutException());
        this.fetcherThread().doWork();
        Assertions.assertEquals((int)this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkMetadata().requestUpdatesCount(), (int)2);
    }

    public class ClusterLinkMetadataForTest
    extends ClusterLinkMetadata {
        private int numRequestUpdates;

        private int numRequestUpdates() {
            return this.numRequestUpdates;
        }

        private void numRequestUpdates_$eq(int x$1) {
            this.numRequestUpdates = x$1;
        }

        public int requestUpdate() {
            this.numRequestUpdates_$eq(this.numRequestUpdates() + 1);
            return super.requestUpdate();
        }

        public int requestUpdatesCount() {
            return this.numRequestUpdates();
        }

        public /* synthetic */ ClusterLinkFetcherWithSharedThreadTest kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$ClusterLinkMetadataForTest$$$outer() {
            return ClusterLinkFetcherWithSharedThreadTest.this;
        }

        public ClusterLinkMetadataForTest(KafkaConfig brokerConfig, String linkName, Uuid linkId, ClusterLinkConfig.LinkMode linkMode, long metadataRefreshBackoffMs, long metadataMaxAgeMs) {
            if (ClusterLinkFetcherWithSharedThreadTest.this == null) {
                throw null;
            }
            super(brokerConfig, linkName, linkId, linkMode, metadataRefreshBackoffMs, metadataMaxAgeMs);
            this.numRequestUpdates = 0;
        }
    }

    public class FetcherWithSharedThread
    extends ClusterLinkFetcherWithSharedThread {
        private final Time time;
        private final Buffer<String> fetcherStates;
        public final /* synthetic */ ClusterLinkFetcherWithSharedThreadTest $outer;

        public Buffer<String> fetcherStates() {
            return this.fetcherStates;
        }

        public void clearPartitionLinkFailure(TopicPartition tp, long fetchOffset) {
        }

        public void delayPartitions(Iterable<TopicPartition> partitions) {
            super.delayPartitions(partitions);
            this.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$FetcherWithSharedThread$$$outer().isDelayed_$eq(true);
        }

        public boolean validateMirrorTruncation(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
            return true;
        }

        public void doWork() {
            do {
                super.doWork();
                ClusterLinkFetcherThread.FetcherState fetcherState = this.fetcherState();
                if (!(fetcherState instanceof ClusterLinkFetcherThread.AwaitingPartitions)) continue;
                long deadlineMs = ((ClusterLinkFetcherThread.AwaitingPartitions)fetcherState).deadlineMs();
                this.time.sleep(Math.max(0L, deadlineMs - this.time.milliseconds()));
            } while (this.fetcherState().isAwaitingResponse());
        }

        public void doWorkOneIteration() {
            super.doWork();
        }

        public boolean initiateShutdown() {
            boolean shutdownInitiated = super.initiateShutdown();
            this.doWork();
            return shutdownInitiated;
        }

        public boolean updateFetcherState(Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>> stateTransformer) {
            if (this.fetcherStates().isEmpty()) {
                this.addFetcherState(this.fetcherState());
            }
            if (super.updateFetcherState(stateTransformer)) {
                this.addFetcherState(this.fetcherState());
                return true;
            }
            return false;
        }

        private void addFetcherState(ClusterLinkFetcherThread.FetcherState state) {
            if (state instanceof ClusterLinkFetcherThread.AwaitingPartitions ? true : (state instanceof ClusterLinkFetcherThread.AwaitingTruncateOffsetResponse ? true : state instanceof ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets)) {
                this.fetcherStates().$plus$eq((Object)state.getClass().getSimpleName());
                return;
            }
            this.fetcherStates().$plus$eq((Object)state.toString());
        }

        public /* synthetic */ ClusterLinkFetcherWithSharedThreadTest kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$FetcherWithSharedThread$$$outer() {
            return this.$outer;
        }

        public FetcherWithSharedThread(ClusterLinkFetcherWithSharedThreadTest $outer, String name, int fetcherId, FetcherPool fetcherPool, String clientId, BrokerEndPoint sourceBroker, ClusterLinkSharedFetcherThread sharedThread, AsyncSend asyncSender, ClusterLinkAsyncLeaderEndPoint asyncLeader, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicaQuota quota, Time time) {
            this.time = time;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(name, $outer.clusterLinkId(), fetcherId, fetcherPool, clientId, sourceBroker, sharedThread, asyncSender, asyncLeader, brokerConfig, clusterLinkConfig, (ClusterLinkMetadata)$outer.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkMetadata(), $outer.createFetcherManager(), failedPartitions, pausedPartitions, exponentialBackoff, replicaMgr, quota, $outer.clusterLinkMetrics(), time, (Function0)new Serializable($outer){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ ClusterLinkFetcherWithSharedThreadTest $outer;

                public final FetchResponseSize apply() {
                    return this.$outer.fetchResponseSize();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, $outer.kafka$server$link$ClusterLinkFetcherWithSharedThreadTest$$clusterLinkNetworkClient(), new LogContext(), (Option)None$.MODULE$);
            this.fetcherStates = (Buffer)Buffer$.MODULE$.empty();
        }
    }
}

