/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkForwardingLocalAdmin;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksResult;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicCollection;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001B\u00181\u0001]BQA\u0010\u0001\u0005\u0002}BqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004M\u0001\u0001\u0006I\u0001\u0012\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003O\u0011\u0019\u0011\u0006\u0001)A\u0005\u001f\"91\u000b\u0001b\u0001\n\u0013!\u0006BB-\u0001A\u0003%Q\u000bC\u0004[\u0001\u0001\u0007I\u0011B.\t\u000f\u001d\u0004\u0001\u0019!C\u0005Q\"1a\u000e\u0001Q!\nqCqa\u001c\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004z\u0001\u0001\u0006I!\u001d\u0005\bu\u0002\u0011\r\u0011\"\u0003q\u0011\u0019Y\b\u0001)A\u0005c\"9A\u0010\u0001b\u0001\n\u0013\u0001\bBB?\u0001A\u0003%\u0011\u000fC\u0004\u007f\u0001\t\u0007I\u0011\u00029\t\r}\u0004\u0001\u0015!\u0003r\u0011-\t\t\u0001\u0001a\u0001\u0002\u0004%I!a\u0001\t\u0017\u0005-\u0001\u00011AA\u0002\u0013%\u0011Q\u0002\u0005\f\u0003#\u0001\u0001\u0019!A!B\u0013\t)\u0001C\u0006\u0002\u0014\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0001bCA\u000b\u0001\u0001\u0007\t\u0019!C\u0005\u0003/A1\"a\u0007\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0006!Y\u0011Q\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u0002\u0011-\ty\u0002\u0001a\u0001\u0002\u0004%I!!\t\t\u0017\u0005\u0015\u0002\u00011A\u0001B\u0003&\u0011Q\u0001\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\t\t\u0005\u0001C\u0001\u0003SAq!a\u0013\u0001\t\u0003\tI\u0003C\u0004\u0002V\u0001!\t!!\u000b\t\u000f\u0005e\u0003\u0001\"\u0001\u0002*!9\u0011Q\f\u0001\u0005\u0002\u0005%\u0002bBA1\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003K\u0002A\u0011AA\u0015\u0011\u001d\tI\u0007\u0001C\u0001\u0003SAq!!\u001c\u0001\t\u0003\tI\u0003C\u0004\u0002r\u0001!\t!!\u000b\t\u000f\u0005U\u0004\u0001\"\u0001\u0002*!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005%\u0002bBA?\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003\u0003\u0003A\u0011AA\u0015\u0011\u001d\t)\t\u0001C\u0001\u0003SAq!!#\u0001\t\u0013\tY\tC\u0004\u0002\u0016\u0002!I!a&\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\nI2\t\\;ti\u0016\u0014H*\u001b8l\u0019>\u001c\u0017\r\\!e[&tG+Z:u\u0015\t\t$'\u0001\u0003mS:\\'BA\u001a5\u0003\u0019\u0019XM\u001d<fe*\tQ'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0004CA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0001B\u0011\u0011\tA\u0007\u0002a\u0005Y!M]8lKJ\u0004&o\u001c9t+\u0005!\u0005CA#K\u001b\u00051%BA$I\u0003\u0011)H/\u001b7\u000b\u0003%\u000bAA[1wC&\u00111J\u0012\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001\u00042s_.,'\u000f\u0015:paN\u0004\u0013aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0016\u0003=\u0003\"!\u0011)\n\u0005E\u0003$AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018\u0001E7fi\u0006$\u0017\r^1NC:\fw-\u001a:!\u00035iW\r^1eCR\f7)Y2iKV\tQ\u000b\u0005\u0002W/6\t!'\u0003\u0002Ye\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fa\"\\3uC\u0012\fG/Y\"bG\",\u0007%\u0001\u0006bkRDwN]5{KJ,\u0012\u0001\u0018\t\u0003;\u0016l\u0011A\u0018\u0006\u00035~S!a\r1\u000b\u0005U\n'B\u00012d\u0003\u0019\t\u0007/Y2iK*\tA-A\u0002pe\u001eL!A\u001a0\u0003\u0015\u0005+H\u000f[8sSj,'/\u0001\bbkRDwN]5{KJ|F%Z9\u0015\u0005%d\u0007CA\u001dk\u0013\tY'H\u0001\u0003V]&$\bbB7\n\u0003\u0003\u0005\r\u0001X\u0001\u0004q\u0012\n\u0014aC1vi\"|'/\u001b>fe\u0002\nQB_6Ce>\\WM]!e[&tW#A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018!B1e[&t'B\u0001<a\u0003\u001d\u0019G.[3oiNL!\u0001_:\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u0006q!p\u001b\"s_.,'/\u00113nS:\u0004\u0013\u0001E6sC\u001a$(I]8lKJ\fE-\\5o\u0003EY'/\u00194u\u0005J|7.\u001a:BI6Lg\u000eI\u0001\u0015WJ\fg\r^\"p]R\u0014x\u000e\u001c7fe\u0006#W.\u001b8\u0002+-\u0014\u0018M\u001a;D_:$(o\u001c7mKJ\fE-\\5oA\u0005)bm\u001c:xCJ$\u0017N\\4Ce>\\WM]!e[&t\u0017A\u00064pe^\f'\u000fZ5oO\n\u0013xn[3s\u0003\u0012l\u0017N\u001c\u0011\u0002!-\u0014\u0018M\u001a;M_\u000e\fGn\u00117jK:$XCAA\u0003!\r\t\u0015qA\u0005\u0004\u0003\u0013\u0001$!F\"mkN$XM\u001d'j].dunY1m\u0003\u0012l\u0017N\\\u0001\u0015WJ\fg\r\u001e'pG\u0006d7\t\\5f]R|F%Z9\u0015\u0007%\fy\u0001\u0003\u0005n)\u0005\u0005\t\u0019AA\u0003\u0003EY'/\u00194u\u0019>\u001c\u0017\r\\\"mS\u0016tG\u000fI\u0001\u000eu.dunY1m\u00072LWM\u001c;\u0002#i\\Gj\\2bY\u000ec\u0017.\u001a8u?\u0012*\u0017\u000fF\u0002j\u00033A\u0001\"\\\f\u0002\u0002\u0003\u0007\u0011QA\u0001\u000fu.dunY1m\u00072LWM\u001c;!\u0003U1wN]<be\u0012Lgn\u001a'pG\u0006d7\t\\5f]R\f\u0011DZ8so\u0006\u0014H-\u001b8h\u0019>\u001c\u0017\r\\\"mS\u0016tGo\u0018\u0013fcR\u0019\u0011.a\t\t\u00115T\u0012\u0011!a\u0001\u0003\u000b\taCZ8so\u0006\u0014H-\u001b8h\u0019>\u001c\u0017\r\\\"mS\u0016tG\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002S\"\u001aA$!\f\u0011\t\u0005=\u0012QH\u0007\u0003\u0003cQA!a\r\u00026\u0005\u0019\u0011\r]5\u000b\t\u0005]\u0012\u0011H\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tYdY\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u007f\t\tD\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004;\u0005\u0015\u0003\u0003BA\u0018\u0003\u000fJA!!\u0013\u00022\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\ni\u0016\u001cHo\u00117pg\u0016D3AHA(!\u0011\ty#!\u0015\n\t\u0005M\u0013\u0011\u0007\u0002\u0005)\u0016\u001cH/\u0001\buKN$H*[:u)>\u0004\u0018nY:)\u0007}\ty%\u0001\tuKN$8I]3bi\u0016$v\u000e]5dg\"\u001a\u0001%a\u0014\u0002)Q,7\u000f^\"sK\u0006$X\rU1si&$\u0018n\u001c8tQ\r\t\u0013qJ\u0001\u0011i\u0016\u001cH/\u00117uKJl\u0015N\u001d:peND3AIA(\u0003Y!Xm\u001d;EK2,G/Z\"mkN$XM\u001d'j].\u001c\bfA\u0012\u0002P\u0005qA/Z:u\u0007J,\u0017\r^3BG2\u001c\bf\u0001\u0013\u0002P\u0005qA/Z:u\t\u0016dW\r^3BG2\u001c\bfA\u0013\u0002P\u0005\u0001B/Z:u\t\u0016\u001c8M]5cK\u0006\u001bGn\u001d\u0015\u0004M\u0005=\u0013!\u0005;fgR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;vg\"\u001aq%a\u0014\u0002-Q,7\u000f\u001e'jgR\u001cuN\\:v[\u0016\u0014xI]8vaND3\u0001KA(\u0003q!Xm\u001d;MSN$8i\u001c8tk6,'o\u0012:pkB|eMZ:fiND3!KA(\u0003u!Xm\u001d;BYR,'oQ8ogVlWM]$s_V\u0004xJ\u001a4tKR\u001c\bf\u0001\u0016\u0002P\u0005\u0019B/Z:u+:D\u0017M\u001c3mK\u0012lU\r\u001e5pI\"\u001a1&a\u0014\u0002#\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\\\"mS\u0016tG\u000f\u0006\u0004\u0002\u0006\u00055\u0015\u0011\u0013\u0005\u0007\u0003\u001fc\u0003\u0019A9\u0002\u0017\t\u0014xn[3s\u0003\u0012l\u0017N\u001c\u0005\u0007\u0003'c\u0003\u0019A9\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00113nS:\fac\u0019:fCR,gi\u001c:xCJ$\u0017N\\4DY&,g\u000e\u001e\u000b\u0005\u00033\u000by\nE\u0002B\u00037K1!!(1\u0005}\u0019E.^:uKJd\u0015N\\6G_J<\u0018M\u001d3j]\u001edunY1m\u0003\u0012l\u0017N\u001c\u0005\u0007\u0003\u001fk\u0003\u0019A9\u0002\u0019Y,'/\u001b4z\u001b\u0016$\bn\u001c3\u0016\t\u0005\u0015\u0016Q\u0017\u000b\nS\u0006\u001d\u0016qYAf\u0003\u001fDq!!+/\u0001\u0004\tY+\u0001\u0004nKRDw\u000e\u001a\t\u0007s\u00055\u0016/!-\n\u0007\u0005=&HA\u0005Gk:\u001cG/[8ocA!\u00111WA[\u0019\u0001!q!a./\u0005\u0004\tILA\u0001U#\u0011\tY,!1\u0011\u0007e\ni,C\u0002\u0002@j\u0012qAT8uQ&tw\rE\u0002:\u0003\u0007L1!!2;\u0005\r\te.\u001f\u0005\b\u0003\u0013t\u0003\u0019AAY\u0003\u0019\u0011Xm];mi\"9\u0011Q\u001a\u0018A\u0002\u0005\u0015\u0011A\u00037pG\u0006d\u0017\tZ7j]\"1\u0011\u0011\u001b\u0018A\u0002E\f\u0011BY1tK\u0006#W.\u001b8")
public class ClusterLinkLocalAdminTest {
    private final Properties brokerProps;
    private final ClusterLinkMetadataManager metadataManager;
    private final MetadataCache metadataCache;
    private Authorizer authorizer;
    private final ConfluentAdmin zkBrokerAdmin;
    private final ConfluentAdmin kraftBrokerAdmin;
    private final ConfluentAdmin kraftControllerAdmin;
    private final ConfluentAdmin forwardingBrokerAdmin;
    private ClusterLinkLocalAdmin kraftLocalClient;
    private ClusterLinkLocalAdmin zkLocalClient;
    private ClusterLinkLocalAdmin forwardingLocalClient;

    private Properties brokerProps() {
        return this.brokerProps;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private Authorizer authorizer() {
        return this.authorizer;
    }

    private void authorizer_$eq(Authorizer x$1) {
        this.authorizer = x$1;
    }

    private ConfluentAdmin zkBrokerAdmin() {
        return this.zkBrokerAdmin;
    }

    private ConfluentAdmin kraftBrokerAdmin() {
        return this.kraftBrokerAdmin;
    }

    private ConfluentAdmin kraftControllerAdmin() {
        return this.kraftControllerAdmin;
    }

    private ConfluentAdmin forwardingBrokerAdmin() {
        return this.forwardingBrokerAdmin;
    }

    private ClusterLinkLocalAdmin kraftLocalClient() {
        return this.kraftLocalClient;
    }

    private void kraftLocalClient_$eq(ClusterLinkLocalAdmin x$1) {
        this.kraftLocalClient = x$1;
    }

    private ClusterLinkLocalAdmin zkLocalClient() {
        return this.zkLocalClient;
    }

    private void zkLocalClient_$eq(ClusterLinkLocalAdmin x$1) {
        this.zkLocalClient = x$1;
    }

    private ClusterLinkLocalAdmin forwardingLocalClient() {
        return this.forwardingLocalClient;
    }

    private void forwardingLocalClient_$eq(ClusterLinkLocalAdmin x$1) {
        this.forwardingLocalClient = x$1;
    }

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.metadataManager().metadataCache()).thenReturn((Object)this.metadataCache());
        this.zkLocalClient_$eq(this.createLocalClient(this.zkBrokerAdmin(), this.zkBrokerAdmin()));
        this.kraftLocalClient_$eq(this.createLocalClient(this.kraftBrokerAdmin(), this.kraftControllerAdmin()));
        this.forwardingLocalClient_$eq((ClusterLinkLocalAdmin)this.createForwardingClient(this.forwardingBrokerAdmin()));
    }

    @AfterEach
    public void tearDown() {
        if (this.kraftLocalClient() != null) {
            this.kraftLocalClient().close(Duration.ZERO);
        }
        if (this.zkLocalClient() != null) {
            this.zkLocalClient().close(Duration.ZERO);
        }
        if (this.forwardingLocalClient() != null) {
            this.forwardingLocalClient().close(Duration.ZERO);
            return;
        }
    }

    @Test
    public void testClose() {
        this.kraftLocalClient().close(Duration.ofHours(10L));
        ((Admin)Mockito.verify((Object)this.kraftBrokerAdmin(), (VerificationMode)Mockito.times((int)1))).close(Duration.ZERO);
        ((Admin)Mockito.verify((Object)this.kraftControllerAdmin(), (VerificationMode)Mockito.times((int)1))).close(Duration.ZERO);
        this.zkLocalClient().close(Duration.ofHours(10L));
        ((Admin)Mockito.verify((Object)this.zkBrokerAdmin(), (VerificationMode)Mockito.times((int)1))).close(Duration.ZERO);
        this.forwardingLocalClient().close(Duration.ofHours(10L));
        ((Admin)Mockito.verify((Object)this.forwardingBrokerAdmin(), (VerificationMode)Mockito.times((int)1))).close(Duration.ZERO);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopics() {
        void verifyMethod_baseAdmin;
        Mockito.when((Object)this.metadataCache().getAllTopics((Option)None$.MODULE$)).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic1", "__consumer_offsets"})));
        Uuid topicId = Uuid.randomUuid();
        Mockito.when((Object)this.metadataCache().getTopicId("topic1")).thenReturn((Object)topicId);
        ListTopicsOptions options = new ListTopicsOptions();
        scala.collection.immutable.Set expectedListing = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new TopicListing("topic1", topicId, false).toString()}));
        Collection resultKRaft = (Collection)this.kraftLocalClient().listTopics(options).listings().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedListing, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resultKRaft).asScala().map((Function1 & Serializable)x$4 -> x$4.toString())).toSet());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.kraftBrokerAdmin(), this.kraftControllerAdmin()});
        Collection resultZk = (Collection)this.zkLocalClient().listTopics(options).listings().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedListing, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resultZk).asScala().map((Function1 & Serializable)x$5 -> x$5.toString())).toSet());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.zkBrokerAdmin()});
        ListTopicsResult resultForwarding = (ListTopicsResult)Mockito.mock(ListTopicsResult.class);
        ConfluentAdmin confluentAdmin = this.forwardingBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin = this.forwardingLocalClient();
        .colon.colon verifyMethod_allBaseAdmins = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin.listTopics(options)).thenReturn((Object)resultForwarding);
        Assertions.assertSame((Object)resultForwarding, (Object)verifyMethod_localAdmin.listTopics(options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin, (VerificationMode)Mockito.times((int)1))).listTopics(options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateTopics() {
        void verifyMethod_baseAdmin;
        void verifyMethod_baseAdmin2;
        void verifyMethod_baseAdmin3;
        Set<NewTopic> topic = Collections.singleton(new NewTopic("topic1", 1, (short)2));
        CreateTopicsOptions options = new CreateTopicsOptions();
        CreateTopicsResult result = (CreateTopicsResult)Mockito.mock(CreateTopicsResult.class);
        ConfluentAdmin confluentAdmin = this.kraftControllerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin3.createTopics(topic, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin.createTopics(topic, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin3, (VerificationMode)Mockito.times((int)1))).createTopics(topic, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin3});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin3, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var4_5 = null;
        confluentAdmin = null;
        Object var6_6 = null;
        ConfluentAdmin confluentAdmin2 = this.zkBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin2 = this.zkLocalClient();
        .colon.colon verifyMethod_allBaseAdmins2 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins2.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin2.createTopics(topic, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin2.createTopics(topic, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin2, (VerificationMode)Mockito.times((int)1))).createTopics(topic, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin2});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins2.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin2, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var7_8 = null;
        confluentAdmin2 = null;
        Object var9_9 = null;
        ConfluentAdmin confluentAdmin3 = this.forwardingBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin3 = this.forwardingLocalClient();
        .colon.colon verifyMethod_allBaseAdmins3 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins3.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin.createTopics(topic, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin3.createTopics(topic, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin, (VerificationMode)Mockito.times((int)1))).createTopics(topic, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins3.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreatePartitions() {
        void verifyMethod_baseAdmin;
        void verifyMethod_baseAdmin2;
        void verifyMethod_baseAdmin3;
        Map<String, NewPartitions> partitions = Collections.singletonMap("topic", NewPartitions.increaseTo((int)5));
        CreatePartitionsOptions options = new CreatePartitionsOptions();
        CreatePartitionsResult result = (CreatePartitionsResult)Mockito.mock(CreatePartitionsResult.class);
        ConfluentAdmin confluentAdmin = this.kraftControllerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin3.createPartitions(partitions, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin.createPartitions(partitions, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin3, (VerificationMode)Mockito.times((int)1))).createPartitions(partitions, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin3});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin3, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var4_5 = null;
        confluentAdmin = null;
        Object var6_6 = null;
        ConfluentAdmin confluentAdmin2 = this.zkBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin2 = this.zkLocalClient();
        .colon.colon verifyMethod_allBaseAdmins2 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins2.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin2.createPartitions(partitions, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin2.createPartitions(partitions, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin2, (VerificationMode)Mockito.times((int)1))).createPartitions(partitions, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin2});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins2.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin2, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var7_8 = null;
        confluentAdmin2 = null;
        Object var9_9 = null;
        ConfluentAdmin confluentAdmin3 = this.forwardingBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin3 = this.forwardingLocalClient();
        .colon.colon verifyMethod_allBaseAdmins3 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins3.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin.createPartitions(partitions, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin3.createPartitions(partitions, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin, (VerificationMode)Mockito.times((int)1))).createPartitions(partitions, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins3.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterMirrors() {
        void verifyMethod_baseAdmin;
        void verifyMethod_baseAdmin2;
        void verifyMethod_baseAdmin3;
        void verifyMethod_baseAdmin4;
        Map<String, AlterMirrorOp> mirrors = Collections.singletonMap("topic", AlterMirrorOp.PAUSE);
        AlterMirrorsOptions options = new AlterMirrorsOptions();
        AlterMirrorsResult result = (AlterMirrorsResult)Mockito.mock(AlterMirrorsResult.class);
        ConfluentAdmin confluentAdmin = this.kraftControllerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin4.alterMirrors(mirrors, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin.alterMirrors(mirrors, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin4, (VerificationMode)Mockito.times((int)1))).alterMirrors(mirrors, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin4});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin4, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var4_5 = null;
        confluentAdmin = null;
        Object var6_6 = null;
        ConfluentAdmin confluentAdmin2 = this.zkBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin2 = this.zkLocalClient();
        .colon.colon verifyMethod_allBaseAdmins2 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins2.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin3.alterMirrors(mirrors, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin2.alterMirrors(mirrors, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin3, (VerificationMode)Mockito.times((int)1))).alterMirrors(mirrors, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin3});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins2.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin3, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var7_8 = null;
        confluentAdmin2 = null;
        Object var9_9 = null;
        ConfluentAdmin confluentAdmin3 = this.forwardingBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin3 = this.forwardingLocalClient();
        .colon.colon verifyMethod_allBaseAdmins3 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins3.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin2.alterMirrors(mirrors, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin3.alterMirrors(mirrors, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin2, (VerificationMode)Mockito.times((int)1))).alterMirrors(mirrors, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin2});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins3.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin2, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var10_11 = null;
        confluentAdmin3 = null;
        Object var12_12 = null;
        this.kraftLocalClient().close();
        this.brokerProps().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "3.0");
        this.kraftLocalClient_$eq(this.createLocalClient(this.kraftBrokerAdmin(), this.kraftControllerAdmin()));
        ConfluentAdmin confluentAdmin4 = this.kraftBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin4 = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins4 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins4.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin.alterMirrors(mirrors, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin4.alterMirrors(mirrors, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin, (VerificationMode)Mockito.times((int)1))).alterMirrors(mirrors, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins4.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteClusterLinks() {
        void verifyMethod_baseAdmin;
        void verifyMethod_baseAdmin2;
        void verifyMethod_baseAdmin3;
        Set<String> linkNames = Collections.singleton("link");
        DeleteClusterLinksOptions options = new DeleteClusterLinksOptions();
        DeleteClusterLinksResult result = (DeleteClusterLinksResult)Mockito.mock(DeleteClusterLinksResult.class);
        ConfluentAdmin confluentAdmin = this.kraftControllerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin3.deleteClusterLinks(linkNames, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin.deleteClusterLinks(linkNames, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin3, (VerificationMode)Mockito.times((int)1))).deleteClusterLinks(linkNames, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin3});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin3, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var4_5 = null;
        confluentAdmin = null;
        Object var6_6 = null;
        ConfluentAdmin confluentAdmin2 = this.zkBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin2 = this.zkLocalClient();
        .colon.colon verifyMethod_allBaseAdmins2 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins2.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin2.deleteClusterLinks(linkNames, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin2.deleteClusterLinks(linkNames, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin2, (VerificationMode)Mockito.times((int)1))).deleteClusterLinks(linkNames, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin2});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins2.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin2, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var7_8 = null;
        confluentAdmin2 = null;
        Object var9_9 = null;
        ConfluentAdmin confluentAdmin3 = this.forwardingBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin3 = this.forwardingLocalClient();
        .colon.colon verifyMethod_allBaseAdmins3 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins3.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin.deleteClusterLinks(linkNames, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin3.deleteClusterLinks(linkNames, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin, (VerificationMode)Mockito.times((int)1))).deleteClusterLinks(linkNames, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins3.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateAcls() {
        void verifyMethod_baseAdmin;
        void verifyMethod_baseAdmin2;
        void verifyMethod_baseAdmin3;
        void verifyMethod_baseAdmin4;
        Set<AclBinding> acls = Collections.singleton((AclBinding)Mockito.mock(AclBinding.class));
        CreateAclsOptions options = new CreateAclsOptions();
        CreateAclsResult result = (CreateAclsResult)Mockito.mock(CreateAclsResult.class);
        ConfluentAdmin confluentAdmin = this.kraftBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin4.createAcls(acls, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin.createAcls(acls, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin4, (VerificationMode)Mockito.times((int)1))).createAcls(acls, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin4});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin4, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var4_5 = null;
        confluentAdmin = null;
        Object var6_6 = null;
        ConfluentAdmin confluentAdmin2 = this.zkBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin2 = this.zkLocalClient();
        .colon.colon verifyMethod_allBaseAdmins2 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins2.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin3.createAcls(acls, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin2.createAcls(acls, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin3, (VerificationMode)Mockito.times((int)1))).createAcls(acls, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin3});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins2.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin3, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var7_8 = null;
        confluentAdmin2 = null;
        Object var9_9 = null;
        ConfluentAdmin confluentAdmin3 = this.forwardingBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin3 = this.forwardingLocalClient();
        .colon.colon verifyMethod_allBaseAdmins3 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins3.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin2.createAcls(acls, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin3.createAcls(acls, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin2, (VerificationMode)Mockito.times((int)1))).createAcls(acls, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin2});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins3.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin2, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var10_11 = null;
        confluentAdmin3 = null;
        Object var12_12 = null;
        this.kraftLocalClient().close();
        this.authorizer_$eq((Authorizer)Mockito.mock(StandardAuthorizer.class));
        this.kraftLocalClient_$eq(this.createLocalClient(this.kraftBrokerAdmin(), this.kraftControllerAdmin()));
        ConfluentAdmin confluentAdmin4 = this.kraftControllerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin4 = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins4 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins4.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin.createAcls(acls, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin4.createAcls(acls, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin, (VerificationMode)Mockito.times((int)1))).createAcls(acls, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins4.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteAcls() {
        void verifyMethod_baseAdmin;
        void verifyMethod_baseAdmin2;
        void verifyMethod_baseAdmin3;
        void verifyMethod_baseAdmin4;
        Set<AclBindingFilter> acls = Collections.singleton((AclBindingFilter)Mockito.mock(AclBindingFilter.class));
        DeleteAclsOptions options = new DeleteAclsOptions();
        DeleteAclsResult result = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        ConfluentAdmin confluentAdmin = this.kraftBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin4.deleteAcls(acls, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin.deleteAcls(acls, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin4, (VerificationMode)Mockito.times((int)1))).deleteAcls(acls, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin4});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin4, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var4_5 = null;
        confluentAdmin = null;
        Object var6_6 = null;
        ConfluentAdmin confluentAdmin2 = this.zkBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin2 = this.zkLocalClient();
        .colon.colon verifyMethod_allBaseAdmins2 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins2.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin3.deleteAcls(acls, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin2.deleteAcls(acls, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin3, (VerificationMode)Mockito.times((int)1))).deleteAcls(acls, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin3});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins2.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin3, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var7_8 = null;
        confluentAdmin2 = null;
        Object var9_9 = null;
        ConfluentAdmin confluentAdmin3 = this.forwardingBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin3 = this.forwardingLocalClient();
        .colon.colon verifyMethod_allBaseAdmins3 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins3.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin2.deleteAcls(acls, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin3.deleteAcls(acls, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin2, (VerificationMode)Mockito.times((int)1))).deleteAcls(acls, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin2});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins3.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin2, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var10_11 = null;
        confluentAdmin3 = null;
        Object var12_12 = null;
        this.kraftLocalClient().close();
        this.authorizer_$eq((Authorizer)Mockito.mock(StandardAuthorizer.class));
        this.kraftLocalClient_$eq(this.createLocalClient(this.kraftBrokerAdmin(), this.kraftControllerAdmin()));
        ConfluentAdmin confluentAdmin4 = this.kraftControllerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin4 = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins4 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins4.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin.deleteAcls(acls, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin4.deleteAcls(acls, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin, (VerificationMode)Mockito.times((int)1))).deleteAcls(acls, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins4.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
    }

    @Test
    public void testDescribeAcls() {
        java.util.List<AclBinding> acls = Arrays.asList((AclBinding)Mockito.mock(AclBinding.class), (AclBinding)Mockito.mock(AclBinding.class));
        AclBindingFilter filter = (AclBindingFilter)Mockito.mock(AclBindingFilter.class);
        DescribeAclsOptions options = new DescribeAclsOptions();
        Mockito.when((Object)this.authorizer().acls(filter)).thenReturn(acls);
        Assertions.assertEquals(acls, (Object)this.kraftLocalClient().describeAcls(filter, options).values().get(5L, TimeUnit.SECONDS));
        Assertions.assertEquals(acls, (Object)this.zkLocalClient().describeAcls(filter, options).values().get(5L, TimeUnit.SECONDS));
        Assertions.assertEquals(acls, (Object)this.forwardingLocalClient().describeAcls(filter, options).values().get(5L, TimeUnit.SECONDS));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.kraftBrokerAdmin(), this.kraftControllerAdmin(), this.zkBrokerAdmin(), this.forwardingBrokerAdmin()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaStatus() {
        void verifyMethod_baseAdmin;
        void verifyMethod_baseAdmin2;
        void verifyMethod_baseAdmin3;
        Set<TopicPartition> partitions = Collections.singleton(new TopicPartition("topic", 0));
        ReplicaStatusOptions options = new ReplicaStatusOptions();
        ReplicaStatusResult result = (ReplicaStatusResult)Mockito.mock(ReplicaStatusResult.class);
        ConfluentAdmin confluentAdmin = this.kraftBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin3.replicaStatus(partitions, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin.replicaStatus(partitions, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin3, (VerificationMode)Mockito.times((int)1))).replicaStatus(partitions, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin3});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin3, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var4_5 = null;
        confluentAdmin = null;
        Object var6_6 = null;
        ConfluentAdmin confluentAdmin2 = this.zkBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin2 = this.zkLocalClient();
        .colon.colon verifyMethod_allBaseAdmins2 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins2.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin2.replicaStatus(partitions, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin2.replicaStatus(partitions, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin2, (VerificationMode)Mockito.times((int)1))).replicaStatus(partitions, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin2});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins2.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin2, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var7_8 = null;
        confluentAdmin2 = null;
        Object var9_9 = null;
        ConfluentAdmin confluentAdmin3 = this.forwardingBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin3 = this.forwardingLocalClient();
        .colon.colon verifyMethod_allBaseAdmins3 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins3.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin.replicaStatus(partitions, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin3.replicaStatus(partitions, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin, (VerificationMode)Mockito.times((int)1))).replicaStatus(partitions, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins3.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListConsumerGroups() {
        void verifyMethod_baseAdmin;
        void verifyMethod_baseAdmin2;
        void verifyMethod_baseAdmin3;
        ListConsumerGroupsOptions options = new ListConsumerGroupsOptions();
        ListConsumerGroupsResult result = (ListConsumerGroupsResult)Mockito.mock(ListConsumerGroupsResult.class);
        ConfluentAdmin confluentAdmin = this.kraftBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin3.listConsumerGroups(options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin.listConsumerGroups(options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin3, (VerificationMode)Mockito.times((int)1))).listConsumerGroups(options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin3});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin3, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var3_4 = null;
        confluentAdmin = null;
        Object var5_5 = null;
        ConfluentAdmin confluentAdmin2 = this.zkBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin2 = this.zkLocalClient();
        .colon.colon verifyMethod_allBaseAdmins2 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins2.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin2.listConsumerGroups(options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin2.listConsumerGroups(options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin2, (VerificationMode)Mockito.times((int)1))).listConsumerGroups(options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin2});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins2.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin2, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var6_7 = null;
        confluentAdmin2 = null;
        Object var8_8 = null;
        ConfluentAdmin confluentAdmin3 = this.forwardingBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin3 = this.forwardingLocalClient();
        .colon.colon verifyMethod_allBaseAdmins3 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins3.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin.listConsumerGroups(options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin3.listConsumerGroups(options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin, (VerificationMode)Mockito.times((int)1))).listConsumerGroups(options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins3.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListConsumerGroupOffsets() {
        void verifyMethod_baseAdmin;
        void verifyMethod_baseAdmin2;
        void verifyMethod_baseAdmin3;
        Map<String, ListConsumerGroupOffsetsSpec> groups = Collections.singletonMap("group", new ListConsumerGroupOffsetsSpec());
        ListConsumerGroupOffsetsOptions options = new ListConsumerGroupOffsetsOptions();
        ListConsumerGroupOffsetsResult result = (ListConsumerGroupOffsetsResult)Mockito.mock(ListConsumerGroupOffsetsResult.class);
        ConfluentAdmin confluentAdmin = this.kraftBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin3.listConsumerGroupOffsets(groups, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin.listConsumerGroupOffsets(groups, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin3, (VerificationMode)Mockito.times((int)1))).listConsumerGroupOffsets(groups, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin3});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin3, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var4_5 = null;
        confluentAdmin = null;
        Object var6_6 = null;
        ConfluentAdmin confluentAdmin2 = this.zkBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin2 = this.zkLocalClient();
        .colon.colon verifyMethod_allBaseAdmins2 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins2.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin2.listConsumerGroupOffsets(groups, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin2.listConsumerGroupOffsets(groups, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin2, (VerificationMode)Mockito.times((int)1))).listConsumerGroupOffsets(groups, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin2});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins2.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin2, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var7_8 = null;
        confluentAdmin2 = null;
        Object var9_9 = null;
        ConfluentAdmin confluentAdmin3 = this.forwardingBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin3 = this.forwardingLocalClient();
        .colon.colon verifyMethod_allBaseAdmins3 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins3.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin.listConsumerGroupOffsets(groups, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin3.listConsumerGroupOffsets(groups, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin, (VerificationMode)Mockito.times((int)1))).listConsumerGroupOffsets(groups, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins3.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterConsumerGroupOffsets() {
        void verifyMethod_baseAdmin;
        void verifyMethod_baseAdmin2;
        void verifyMethod_baseAdmin3;
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(new TopicPartition("topic", 1), new OffsetAndMetadata(10L));
        AlterConsumerGroupOffsetsOptions options = new AlterConsumerGroupOffsetsOptions();
        AlterConsumerGroupOffsetsResult result = (AlterConsumerGroupOffsetsResult)Mockito.mock(AlterConsumerGroupOffsetsResult.class);
        ConfluentAdmin confluentAdmin = this.kraftBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin3.alterConsumerGroupOffsets("group", offsets, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin.alterConsumerGroupOffsets("group", offsets, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin3, (VerificationMode)Mockito.times((int)1))).alterConsumerGroupOffsets("group", offsets, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin3});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin3, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var4_5 = null;
        confluentAdmin = null;
        Object var6_6 = null;
        ConfluentAdmin confluentAdmin2 = this.zkBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin2 = this.zkLocalClient();
        .colon.colon verifyMethod_allBaseAdmins2 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins2.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin2.alterConsumerGroupOffsets("group", offsets, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin2.alterConsumerGroupOffsets("group", offsets, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin2, (VerificationMode)Mockito.times((int)1))).alterConsumerGroupOffsets("group", offsets, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin2});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins2.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin2, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var7_8 = null;
        confluentAdmin2 = null;
        Object var9_9 = null;
        ConfluentAdmin confluentAdmin3 = this.forwardingBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin3 = this.forwardingLocalClient();
        .colon.colon verifyMethod_allBaseAdmins3 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins3.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin.alterConsumerGroupOffsets("group", offsets, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin3.alterConsumerGroupOffsets("group", offsets, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin, (VerificationMode)Mockito.times((int)1))).alterConsumerGroupOffsets("group", offsets, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins3.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnhandledMethod() {
        void verifyMethod_baseAdmin;
        void verifyMethod_baseAdmin2;
        void verifyMethod_baseAdmin3;
        TopicCollection.TopicNameCollection topics = TopicCollection.ofTopicNames(Collections.singleton("topic"));
        DescribeTopicsOptions options = new DescribeTopicsOptions();
        DescribeTopicsResult result = (DescribeTopicsResult)Mockito.mock(DescribeTopicsResult.class);
        ConfluentAdmin confluentAdmin = this.kraftBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin = this.kraftLocalClient();
        .colon.colon verifyMethod_allBaseAdmins = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin3.describeTopics((TopicCollection)topics, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin.describeTopics((TopicCollection)topics, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin3, (VerificationMode)Mockito.times((int)1))).describeTopics((TopicCollection)topics, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin3});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin3, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var4_5 = null;
        confluentAdmin = null;
        Object var6_6 = null;
        ConfluentAdmin confluentAdmin2 = this.zkBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin2 = this.zkLocalClient();
        .colon.colon verifyMethod_allBaseAdmins2 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins2.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin2.describeTopics((TopicCollection)topics, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin2.describeTopics((TopicCollection)topics, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin2, (VerificationMode)Mockito.times((int)1))).describeTopics((TopicCollection)topics, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin2});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins2.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin2, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Object var7_8 = null;
        confluentAdmin2 = null;
        Object var9_9 = null;
        ConfluentAdmin confluentAdmin3 = this.forwardingBrokerAdmin();
        ClusterLinkLocalAdmin verifyMethod_localAdmin3 = this.forwardingLocalClient();
        .colon.colon verifyMethod_allBaseAdmins3 = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])verifyMethod_allBaseAdmins3.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)verifyMethod_baseAdmin.describeTopics((TopicCollection)topics, options)).thenReturn((Object)result);
        Assertions.assertSame((Object)result, (Object)verifyMethod_localAdmin3.describeTopics((TopicCollection)topics, options));
        ((ConfluentAdmin)Mockito.verify((Object)verifyMethod_baseAdmin, (VerificationMode)Mockito.times((int)1))).describeTopics((TopicCollection)topics, options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{verifyMethod_baseAdmin});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)verifyMethod_allBaseAdmins3.diff((Seq)new .colon.colon((Object)verifyMethod_baseAdmin, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkLocalAdmin createLocalClient(ConfluentAdmin brokerAdmin, ConfluentAdmin controllerAdmin) {
        void apply_doLog;
        boolean bl = true;
        Properties apply_props = this.brokerProps();
        Object var3_4 = null;
        return new ClusterLinkLocalAdmin(new KafkaConfig((Map)apply_props, (boolean)apply_doLog), (Option)new Some((Object)this.metadataManager()), (Option)new Some((Object)this.authorizer()), brokerAdmin, controllerAdmin);
    }

    private ClusterLinkForwardingLocalAdmin createForwardingClient(ConfluentAdmin brokerAdmin) {
        boolean apply_doLog = true;
        Properties apply_props = this.brokerProps();
        Object var2_3 = null;
        return new ClusterLinkForwardingLocalAdmin(new KafkaConfig((Map)apply_props, apply_doLog), (Option)new Some((Object)this.authorizer()), brokerAdmin);
    }

    private <T> void verifyMethod(Function1<ConfluentAdmin, T> method, T result, ClusterLinkLocalAdmin localAdmin, ConfluentAdmin baseAdmin) {
        .colon.colon allBaseAdmins = new .colon.colon((Object)this.kraftControllerAdmin(), (List)new .colon.colon((Object)this.kraftBrokerAdmin(), (List)new .colon.colon((Object)this.zkBrokerAdmin(), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])((Object[])allBaseAdmins.toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
        Mockito.when((Object)method.apply((Object)baseAdmin)).thenReturn(result);
        Assertions.assertSame(result, (Object)method.apply((Object)localAdmin));
        method.apply(Mockito.verify((Object)baseAdmin, (VerificationMode)Mockito.times((int)1)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{baseAdmin});
        Mockito.verifyNoInteractions((Object[])((Object[])((IterableOnceOps)allBaseAdmins.diff((Seq)new .colon.colon((Object)baseAdmin, (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(ConfluentAdmin.class))));
    }

    public static final /* synthetic */ ListTopicsResult $anonfun$testListTopics$3(ListTopicsOptions options$1, ConfluentAdmin x$6) {
        return x$6.listTopics(options$1);
    }

    public static final /* synthetic */ CreateTopicsResult $anonfun$testCreateTopics$1(Set topic$1, CreateTopicsOptions options$2, ConfluentAdmin x$7) {
        return x$7.createTopics((Collection)topic$1, options$2);
    }

    public static final /* synthetic */ CreateTopicsResult $anonfun$testCreateTopics$2(Set topic$1, CreateTopicsOptions options$2, ConfluentAdmin x$8) {
        return x$8.createTopics((Collection)topic$1, options$2);
    }

    public static final /* synthetic */ CreateTopicsResult $anonfun$testCreateTopics$3(Set topic$1, CreateTopicsOptions options$2, ConfluentAdmin x$9) {
        return x$9.createTopics((Collection)topic$1, options$2);
    }

    public static final /* synthetic */ CreatePartitionsResult $anonfun$testCreatePartitions$1(Map partitions$1, CreatePartitionsOptions options$3, ConfluentAdmin x$10) {
        return x$10.createPartitions(partitions$1, options$3);
    }

    public static final /* synthetic */ CreatePartitionsResult $anonfun$testCreatePartitions$2(Map partitions$1, CreatePartitionsOptions options$3, ConfluentAdmin x$11) {
        return x$11.createPartitions(partitions$1, options$3);
    }

    public static final /* synthetic */ CreatePartitionsResult $anonfun$testCreatePartitions$3(Map partitions$1, CreatePartitionsOptions options$3, ConfluentAdmin x$12) {
        return x$12.createPartitions(partitions$1, options$3);
    }

    public static final /* synthetic */ AlterMirrorsResult $anonfun$testAlterMirrors$1(Map mirrors$1, AlterMirrorsOptions options$4, ConfluentAdmin x$13) {
        return x$13.alterMirrors(mirrors$1, options$4);
    }

    public static final /* synthetic */ AlterMirrorsResult $anonfun$testAlterMirrors$2(Map mirrors$1, AlterMirrorsOptions options$4, ConfluentAdmin x$14) {
        return x$14.alterMirrors(mirrors$1, options$4);
    }

    public static final /* synthetic */ AlterMirrorsResult $anonfun$testAlterMirrors$3(Map mirrors$1, AlterMirrorsOptions options$4, ConfluentAdmin x$15) {
        return x$15.alterMirrors(mirrors$1, options$4);
    }

    public static final /* synthetic */ AlterMirrorsResult $anonfun$testAlterMirrors$4(Map mirrors$1, AlterMirrorsOptions options$4, ConfluentAdmin x$16) {
        return x$16.alterMirrors(mirrors$1, options$4);
    }

    public static final /* synthetic */ DeleteClusterLinksResult $anonfun$testDeleteClusterLinks$1(Set linkNames$1, DeleteClusterLinksOptions options$5, ConfluentAdmin x$17) {
        return x$17.deleteClusterLinks((Collection)linkNames$1, options$5);
    }

    public static final /* synthetic */ DeleteClusterLinksResult $anonfun$testDeleteClusterLinks$2(Set linkNames$1, DeleteClusterLinksOptions options$5, ConfluentAdmin x$18) {
        return x$18.deleteClusterLinks((Collection)linkNames$1, options$5);
    }

    public static final /* synthetic */ DeleteClusterLinksResult $anonfun$testDeleteClusterLinks$3(Set linkNames$1, DeleteClusterLinksOptions options$5, ConfluentAdmin x$19) {
        return x$19.deleteClusterLinks((Collection)linkNames$1, options$5);
    }

    public static final /* synthetic */ CreateAclsResult $anonfun$testCreateAcls$1(Set acls$1, CreateAclsOptions options$6, ConfluentAdmin x$20) {
        return x$20.createAcls((Collection)acls$1, options$6);
    }

    public static final /* synthetic */ CreateAclsResult $anonfun$testCreateAcls$2(Set acls$1, CreateAclsOptions options$6, ConfluentAdmin x$21) {
        return x$21.createAcls((Collection)acls$1, options$6);
    }

    public static final /* synthetic */ CreateAclsResult $anonfun$testCreateAcls$3(Set acls$1, CreateAclsOptions options$6, ConfluentAdmin x$22) {
        return x$22.createAcls((Collection)acls$1, options$6);
    }

    public static final /* synthetic */ CreateAclsResult $anonfun$testCreateAcls$4(Set acls$1, CreateAclsOptions options$6, ConfluentAdmin x$23) {
        return x$23.createAcls((Collection)acls$1, options$6);
    }

    public static final /* synthetic */ DeleteAclsResult $anonfun$testDeleteAcls$1(Set acls$2, DeleteAclsOptions options$7, ConfluentAdmin x$24) {
        return x$24.deleteAcls((Collection)acls$2, options$7);
    }

    public static final /* synthetic */ DeleteAclsResult $anonfun$testDeleteAcls$2(Set acls$2, DeleteAclsOptions options$7, ConfluentAdmin x$25) {
        return x$25.deleteAcls((Collection)acls$2, options$7);
    }

    public static final /* synthetic */ DeleteAclsResult $anonfun$testDeleteAcls$3(Set acls$2, DeleteAclsOptions options$7, ConfluentAdmin x$26) {
        return x$26.deleteAcls((Collection)acls$2, options$7);
    }

    public static final /* synthetic */ DeleteAclsResult $anonfun$testDeleteAcls$4(Set acls$2, DeleteAclsOptions options$7, ConfluentAdmin x$27) {
        return x$27.deleteAcls((Collection)acls$2, options$7);
    }

    public static final /* synthetic */ ReplicaStatusResult $anonfun$testReplicaStatus$1(Set partitions$2, ReplicaStatusOptions options$8, ConfluentAdmin x$28) {
        return x$28.replicaStatus(partitions$2, options$8);
    }

    public static final /* synthetic */ ReplicaStatusResult $anonfun$testReplicaStatus$2(Set partitions$2, ReplicaStatusOptions options$8, ConfluentAdmin x$29) {
        return x$29.replicaStatus(partitions$2, options$8);
    }

    public static final /* synthetic */ ReplicaStatusResult $anonfun$testReplicaStatus$3(Set partitions$2, ReplicaStatusOptions options$8, ConfluentAdmin x$30) {
        return x$30.replicaStatus(partitions$2, options$8);
    }

    public static final /* synthetic */ ListConsumerGroupsResult $anonfun$testListConsumerGroups$1(ListConsumerGroupsOptions options$9, ConfluentAdmin x$31) {
        return x$31.listConsumerGroups(options$9);
    }

    public static final /* synthetic */ ListConsumerGroupsResult $anonfun$testListConsumerGroups$2(ListConsumerGroupsOptions options$9, ConfluentAdmin x$32) {
        return x$32.listConsumerGroups(options$9);
    }

    public static final /* synthetic */ ListConsumerGroupsResult $anonfun$testListConsumerGroups$3(ListConsumerGroupsOptions options$9, ConfluentAdmin x$33) {
        return x$33.listConsumerGroups(options$9);
    }

    public static final /* synthetic */ ListConsumerGroupOffsetsResult $anonfun$testListConsumerGroupOffsets$1(Map groups$1, ListConsumerGroupOffsetsOptions options$10, ConfluentAdmin x$34) {
        return x$34.listConsumerGroupOffsets(groups$1, options$10);
    }

    public static final /* synthetic */ ListConsumerGroupOffsetsResult $anonfun$testListConsumerGroupOffsets$2(Map groups$1, ListConsumerGroupOffsetsOptions options$10, ConfluentAdmin x$35) {
        return x$35.listConsumerGroupOffsets(groups$1, options$10);
    }

    public static final /* synthetic */ ListConsumerGroupOffsetsResult $anonfun$testListConsumerGroupOffsets$3(Map groups$1, ListConsumerGroupOffsetsOptions options$10, ConfluentAdmin x$36) {
        return x$36.listConsumerGroupOffsets(groups$1, options$10);
    }

    public static final /* synthetic */ AlterConsumerGroupOffsetsResult $anonfun$testAlterConsumerGroupOffsets$1(Map offsets$1, AlterConsumerGroupOffsetsOptions options$11, ConfluentAdmin x$37) {
        return x$37.alterConsumerGroupOffsets("group", offsets$1, options$11);
    }

    public static final /* synthetic */ AlterConsumerGroupOffsetsResult $anonfun$testAlterConsumerGroupOffsets$2(Map offsets$1, AlterConsumerGroupOffsetsOptions options$11, ConfluentAdmin x$38) {
        return x$38.alterConsumerGroupOffsets("group", offsets$1, options$11);
    }

    public static final /* synthetic */ AlterConsumerGroupOffsetsResult $anonfun$testAlterConsumerGroupOffsets$3(Map offsets$1, AlterConsumerGroupOffsetsOptions options$11, ConfluentAdmin x$39) {
        return x$39.alterConsumerGroupOffsets("group", offsets$1, options$11);
    }

    public static final /* synthetic */ DescribeTopicsResult $anonfun$testUnhandledMethod$1(TopicCollection.TopicNameCollection topics$1, DescribeTopicsOptions options$12, ConfluentAdmin x$40) {
        return x$40.describeTopics((TopicCollection)topics$1, options$12);
    }

    public static final /* synthetic */ DescribeTopicsResult $anonfun$testUnhandledMethod$2(TopicCollection.TopicNameCollection topics$1, DescribeTopicsOptions options$12, ConfluentAdmin x$41) {
        return x$41.describeTopics((TopicCollection)topics$1, options$12);
    }

    public static final /* synthetic */ DescribeTopicsResult $anonfun$testUnhandledMethod$3(TopicCollection.TopicNameCollection topics$1, DescribeTopicsOptions options$12, ConfluentAdmin x$42) {
        return x$42.describeTopics((TopicCollection)topics$1, options$12);
    }

    public ClusterLinkLocalAdminTest() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var20_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var21_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var22_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        this.brokerProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        this.metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        this.metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        this.authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        this.zkBrokerAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        this.kraftBrokerAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        this.kraftControllerAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        this.forwardingBrokerAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    }
}

