/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.ClusterLinkState;
import kafka.cluster.Partition;
import kafka.cluster.PartitionState;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.network.SocketServer;
import kafka.server.BrokerEpochManager;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.ClusterLinkQuotas;
import kafka.server.ClusterLinkQuotas$;
import kafka.server.FetcherPool;
import kafka.server.FetcherTag;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.MetadataSupport;
import kafka.server.ReplicaManager;
import kafka.server.ZkSupport;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConfigDefaults$;
import kafka.server.link.ClusterLinkConfigEncoder;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkControllerListener;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFailed;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkInboundConnectionManager;
import kafka.server.link.ClusterLinkInfo;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkOutboundConnectionManager;
import kafka.server.link.ClusterLinkRetryState;
import kafka.server.link.ClusterLinkRetryState$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ConnectionMode;
import kafka.server.link.FailedClusterLink$;
import kafka.server.link.FailedLinkReason;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import kafka.server.link.TestCreateClusterLinkPolicy;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.UnauthorizedBootstrapFailedLinkReason$;
import kafka.server.link.UnavailableClusterLink$;
import kafka.server.link.UnavailableLinkReason;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.ClusterLinkExistsException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r=d\u0001B(Q\u0001]CQA\u0018\u0001\u0005\u0002}CqA\u0019\u0001C\u0002\u0013%1\r\u0003\u0004i\u0001\u0001\u0006I\u0001\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u00199\b\u0001)A\u0005W\"9\u0001\u0010\u0001b\u0001\n\u0013I\bbBA\u0001\u0001\u0001\u0006IA\u001f\u0005\n\u0003\u0007\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"!\u0004\u0001A\u0003%\u0011q\u0001\u0005\n\u0003\u001f\u0001!\u0019!C\u0005\u0003#A\u0001\"!\b\u0001A\u0003%\u00111\u0003\u0005\n\u0003?\u0001!\u0019!C\u0005\u0003CA\u0001\"!\u000b\u0001A\u0003%\u00111\u0005\u0005\n\u0003W\u0001!\u0019!C\u0005\u0003[A\u0001\"a\u000f\u0001A\u0003%\u0011q\u0006\u0005\n\u0003{\u0001!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0012\u0001A\u0003%\u0011\u0011\t\u0005\f\u0003\u0013\u0002\u0001\u0019!a\u0001\n\u0013\tY\u0005C\u0006\u0002T\u0001\u0001\r\u00111A\u0005\n\u0005U\u0003bCA1\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001bB1\"a\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002f!Y\u0011Q\u000e\u0001A\u0002\u0003\u0007I\u0011BA8\u0011-\t\u0019\b\u0001a\u0001\u0002\u0003\u0006K!a\u001a\t\u0013\u0005U\u0004A1A\u0005\n\u0005]\u0004\u0002CAH\u0001\u0001\u0006I!!\u001f\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u00111\u0016\u0001\u0005\u0002\u0005M\u0005bBA[\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003\u007f\u0003A\u0011AAJ\u0011\u001d\t\u0019\r\u0001C\u0001\u0003'Cq!a2\u0001\t\u0003\t\u0019\nC\u0004\u0002L\u0002!\t!a%\t\u000f\u0005=\u0007\u0001\"\u0001\u0002\u0014\"9\u00111\u001b\u0001\u0005\n\u0005M\u0005bBAk\u0001\u0011%\u00111\u0013\u0005\b\u0003/\u0004A\u0011BAJ\u0011\u001d\tI\u000e\u0001C\u0005\u0003'Cq!a7\u0001\t\u0013\t\u0019\nC\u0004\u0002^\u0002!\t!a8\t\u000f\tM\u0001\u0001\"\u0001\u0002\u0014\"9!q\u0003\u0001\u0005\u0002\u0005M\u0005b\u0002B\u000e\u0001\u0011\u0005\u00111\u0013\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u0011\u001d\u0011i\u0003\u0001C\u0001\u0003'CqA!\r\u0001\t\u0003\t\u0019\nC\u0004\u00036\u0001!\t!a%\t\u000f\te\u0002\u0001\"\u0001\u0002\u0014\"9!\u0011\n\u0001\u0005\u0002\u0005M\u0005b\u0002B'\u0001\u0011\u0005\u00111\u0013\u0005\b\u0005#\u0002A\u0011AAJ\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005/BqA!\u0018\u0001\t\u0003\t\u0019\nC\u0004\u0003b\u0001!\t!a%\t\u000f\t\u0015\u0004\u0001\"\u0001\u0002\u0014\"9!\u0011\u000e\u0001\u0005\u0002\u0005M\u0005b\u0002B7\u0001\u0011\u0005\u00111\u0013\u0005\b\u0005c\u0002A\u0011AAJ\u0011\u001d\u0011)\b\u0001C\u0001\u0003'CqA!\u001f\u0001\t\u0003\t\u0019\nC\u0004\u0003~\u0001!IAa \t\u000f\t%\u0007\u0001\"\u0001\u0002\u0014\"9!Q\u001a\u0001\u0005\u0002\u0005M\u0005b\u0002Bi\u0001\u0011\u0005\u00111\u0013\u0005\b\u0005+\u0004A\u0011AAJ\u0011\u001d\u0011I\u000e\u0001C\u0005\u00057DqA!:\u0001\t\u0013\u00119\u000fC\u0004\u0003j\u0002!\tAa;\t\u000f\t]\b\u0001\"\u0003\u0003z\"9!1 \u0001\u0005\n\tu\bbBB\u0003\u0001\u0011%1q\u0001\u0005\b\u0007W\u0001A\u0011BB\u0017\u0011\u001d\u0019Y\u0004\u0001C\u0005\u0007{Aqaa\u0013\u0001\t\u0013\u0019ieB\u0004\u0004TAC\ta!\u0016\u0007\r=\u0003\u0006\u0012AB,\u0011\u0019q6\n\"\u0001\u0004Z!911L&\u0005\u0002\u0005M\u0005bBB3\u0017\u0012\u0005\u00111\u0013\u0002\u0017\u00072,8\u000f^3s\u0019&t7.T1oC\u001e,'\u000fV3ti*\u0011\u0011KU\u0001\u0005Y&t7N\u0003\u0002T)\u000611/\u001a:wKJT\u0011!V\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\f\u0005\u0002Z96\t!LC\u0001\\\u0003\u0015\u00198-\u00197b\u0013\ti&L\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0004\"!\u0019\u0001\u000e\u0003A\u000bAB\u0019:pW\u0016\u00148i\u001c8gS\u001e,\u0012\u0001\u001a\t\u0003K\u001al\u0011AU\u0005\u0003OJ\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006i!M]8lKJ\u001cuN\u001c4jO\u0002\nq!\\3ue&\u001c7/F\u0001l!\taW/D\u0001n\u0015\tIgN\u0003\u0002pa\u000611m\\7n_:T!!V9\u000b\u0005I\u001c\u0018AB1qC\u000eDWMC\u0001u\u0003\ry'oZ\u0005\u0003m6\u0014q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003\u0011!\u0018.\\3\u0016\u0003i\u0004\"a\u001f@\u000e\u0003qT!! 8\u0002\u000bU$\u0018\u000e\\:\n\u0005}d(\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011q\u0001\t\u0004K\u0006%\u0011bAA\u0006%\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0006\u0002\u0002\u0014A!\u0011QCA\r\u001b\t\t9BC\u0002\u0002\u0010QKA!a\u0007\u0002\u0018\ty1*\u00194lC\u000e{g\u000e\u001e:pY2,'/A\u0006d_:$(o\u001c7mKJ\u0004\u0013!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiV\u0011\u00111\u0005\t\u0005\u0003+\t)#\u0003\u0003\u0002(\u0005]!!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\u0006\u00112m\u001c8ue>dG.\u001a:D_:$X\r\u001f;!\u0003!Q8n\u00117jK:$XCAA\u0018!\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001b)\u0006\u0011!p[\u0005\u0005\u0003s\t\u0019DA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\nu.\u001cE.[3oi\u0002\nQ\"\\3uC\u0012\fG/Y\"bG\",WCAA!!\r)\u00171I\u0005\u0004\u0003\u000b\u0012&!D'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002%\rdWo\u001d;fe2Kgn['b]\u0006<WM]\u000b\u0003\u0003\u001b\u00022!YA(\u0013\r\t\t\u0006\u0015\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T1oC\u001e,'/\u0001\fdYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014x\fJ3r)\u0011\t9&!\u0018\u0011\u0007e\u000bI&C\u0002\u0002\\i\u0013A!\u00168ji\"I\u0011qL\n\u0002\u0002\u0003\u0007\u0011QJ\u0001\u0004q\u0012\n\u0014aE2mkN$XM\u001d'j].l\u0015M\\1hKJ\u0004\u0013!\u0003>l'V\u0004\bo\u001c:u+\t\t9\u0007E\u0002f\u0003SJ1!a\u001bS\u0005%Q6nU;qa>\u0014H/A\u0007{WN+\b\u000f]8si~#S-\u001d\u000b\u0005\u0003/\n\t\bC\u0005\u0002`Y\t\t\u00111\u0001\u0002h\u0005Q!p[*vaB|'\u000f\u001e\u0011\u0002;Q|\u0007/[2D_:4\u0017nZ*z]\u000eLen\u00197vI\u0016$UMZ1vYR,\"!!\u001f\u0011\t\u0005m\u0014\u0011\u0012\b\u0005\u0003{\n)\tE\u0002\u0002\u0000ik!!!!\u000b\u0007\u0005\re+\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000fS\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00065%AB*ue&twMC\u0002\u0002\bj\u000ba\u0004^8qS\u000e\u001cuN\u001c4jONKhnY%oG2,H-\u001a#fM\u0006,H\u000e\u001e\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005]\u0003f\u0001\u000e\u0002\u0018B!\u0011\u0011TAT\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015aA1qS*!\u0011\u0011UAR\u0003\u001dQW\u000f]5uKJT1!!*t\u0003\u0015QWO\\5u\u0013\u0011\tI+a'\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\rY\u0012q\u0016\t\u0005\u00033\u000b\t,\u0003\u0003\u00024\u0006m%!C!gi\u0016\u0014X)Y2i\u0003A!Xm\u001d;DYV\u001cH/\u001a:MS:\\7\u000fK\u0002\u001d\u0003s\u0003B!!'\u0002<&!\u0011QXAN\u0005\u0011!Vm\u001d;\u0002/R,7\u000f^\"sK\u0006$Xm\u00117vgR,'\u000fT5oWJ+'.Z2ugJ+\u0017/^3ti&3G+\u001a8b]R\u0004&/\u001a4jq&\u001bh*\u001e7m\u0003:$7I]3bi\u0016\u001cE.^:uKJd\u0015N\\6Q_2L7-_#ySN$8\u000fK\u0002\u001e\u0003s\u000bq\u0002^3tiJ+7m\u001c8gS\u001e,(/\u001a\u0015\u0004=\u0005e\u0016!\u0006;fgR\u001cuN\u001c8fGRLwN\\'b]\u0006<WM\u001d\u0015\u0004?\u0005e\u0016a\u0006;fgR\u0014V\r^3oi&|gnQ8oM&<7+\u001f8dQ\r\u0001\u0013\u0011X\u0001(i\u0016\u001cH\u000fV8qS\u000e\u001cuN\u001c4jONKhnY%oG2,H-Z\"p[B\fG/\u001b2jY&$\u0018\u0010K\u0002\"\u0003s\u000bQB^3sS\u001aLH)\u001a4bk2$\u0018a\u0007<fe&4\u0017PW&ICNl\u0015\r\u001c4pe6,GmQ8oM&<7/A\rwKJLg-\u001f.L\u0011\u0006\u001cXK\\6o_^t7i\u001c8gS\u001e\u001c\u0018a\u0007<fe&4\u0017PW&NSN\u001cXm]!mo\u0006L8oQ8oM&<7/A\u000fwKJLg-\u001f.L\u0011\u0006\u001c\u0018J\u001c3fa\u0016tG-\u001a8u\u0007>tg-[4t\u0003E\u0019'/Z1uK\u000ecWo\u001d;fe2Kgn\u001b\u000b\t\u0003C\fy/a=\u0002\u0000B!\u00111]Au\u001d\r\t\u0017Q]\u0005\u0004\u0003O\u0004\u0016AE\"mkN$XM\u001d'j].4\u0015m\u0019;pefLA!a;\u0002n\nqa)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014(bAAt!\"9\u0011\u0011_\u0014A\u0002\u0005e\u0014\u0001\u00037j].t\u0015-\\3\t\u000f\u0005Ux\u00051\u0001\u0002x\u00061A.\u001b8l\u0013\u0012\u0004B!!?\u0002|6\ta.C\u0002\u0002~:\u0014A!V;jI\"9!\u0011A\u0014A\u0002\t\r\u0011\u0001E2mkN$XM\u001d'j].\u0004&o\u001c9t!\u0011\u0011)Aa\u0004\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0005\u0017\tA!\u001e;jY*\u0011!QB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0012\t\u001d!A\u0003)s_B,'\u000f^5fg\u0006AB/Z:u\r\u0006LG.\u001a3BI\u0012\u001cE.^:uKJd\u0015N\\6)\u0007!\nI,\u0001\u0012uKN$(+Z2p]\u001aLw-\u001e:f\u001d>t'+\u001a;sS\u0006\u0014G.\u001a$bS2,(/\u001a\u0015\u0004S\u0005e\u0016!\r;fgR\u0014V\r\u001e:z%\u0016\u001cwN\u001c4jOV\u0014XMU3ue&\f'\r\\3GC&dWO]3P]2Kgn\u001b*v]:Lgn\u001a\u0015\u0004U\u0005e\u0016AD2p]R\f\u0017N\\:NKR\u0014\u0018n\u0019\u000b\u0005\u0005G\u0011I\u0003E\u0002Z\u0005KI1Aa\n[\u0005\u001d\u0011un\u001c7fC:DqAa\u000b,\u0001\u0004\tI(\u0001\u0003oC6,\u0017!\r;fgR\u0014V\r\u001e:z%\u0016\u001cwN\u001c4jOV\u0014XMU3ue&\f'\r\\3GC&dWO]3P]2Kgn[*uCJ$X\u000f\u001d\u0015\u0004Y\u0005e\u0016!\u0006;fgR$U\r\\3uK\u000ecWo\u001d;fe2Kgn\u001b\u0015\u0004[\u0005e\u0016A\t;fgR\u001cuN\u001c;s_2dWM\u001d'jgR,g.\u001a:NSJ\u0014xN]*uCR,7\u000fK\u0002/\u0003s\u000b1\u0004^3ti2K7\u000f^\"mkN$XM\u001d'j].\u001cHj\\2lS:<\u0007fA\u0018\u0002:\":qFa\u0010\u0003F\t\u001d\u0003\u0003BAM\u0005\u0003JAAa\u0011\u0002\u001c\n9A+[7f_V$\u0018!\u0002<bYV,g$\u0001\u000b\u0002!Q,7\u000f\u001e*fiJLHj\\2lS:<\u0007f\u0001\u0019\u0002:\u0006)C/Z:u\u001d>tw\n\u001d;j[&TX\r\u001a(p]\ncwnY6j]\u001edunY1m\u0003\u0012l\u0017N\u001c\u0015\u0004c\u0005e\u0016A\t;fgR|\u0005\u000f^5nSj,GMT8o\u00052|7m[5oO2{7-\u00197BI6Lg\u000eK\u00023\u0003s\u000b1D^3sS\u001aLhj\u001c8CY>\u001c7.\u001b8h\u0019>\u001c\u0017\r\\!e[&tG\u0003BA,\u00053BqAa\u00174\u0001\u0004\u0011\u0019#A\u000bf]\u0006\u0014G.Z(qi&l\u0017N_3e\u00072LWM\u001c;\u00025Q,7\u000f\u001e+f[B|'/\u0019:z\u0003\u0012l\u0017N\\%t\u00072|7/\u001a3)\u0007Q\nI,\u0001\u0011uKN$hj\u001c8UK6\u0004xN]1ss\u0006#W.\u001b8Jg:{Go\u00117pg\u0016$\u0007fA\u001b\u0002:\u00069B/Z:u)\u0016l\u0007o\u001c:bef\fE-\\5o\u0013:$W\r\u001f\u0015\u0004m\u0005e\u0016\u0001\u0006;fgR$\u0015P\\1nS\u000e4U\r^2i'&TX\rK\u00028\u0003s\u000b\u0011\u0005^3ti\u000ecWo\u001d;fe2Kgn[\"p]\u001aLwMU3f]\u000e\u0014\u0018\u0010\u001d;j_:D3\u0001OA]\u0003u!Xm\u001d;TG\",G-\u001e7fe^KG\u000f\u001b'j].\feMZ5oSRL\bfA\u001d\u0002:\u0006AC/Z:u\u001bVdG/\u001b+f]\u0006tGoU2iK\u0012,H.\u001a:XSRDG*\u001b8l\u0003\u001a4\u0017N\\5us\"\u001a!(!/\u0002UQ,7\u000f^'vYRLG+\u001a8b]R\u001c6\r[3ek2,'oV5uQR+g.\u00198u\u0003\u001a4\u0017N\\5us\"\u001a1(!/\u0002'Y,'/\u001b4z\u0019&t7nU2iK\u0012,H.\u001a:\u0015\r\u0005]#\u0011\u0011BZ\u0011\u001d\u0011\u0019\t\u0010a\u0001\u0005\u000b\u000ba\u0002\u001e5sK\u0006$\u0017I\u001a4j]&$\u0018\u0010\u0005\u0003\u0003\b\n5f\u0002\u0002BE\u0005OsAAa#\u0003\":!!Q\u0012BO\u001d\u0011\u0011yIa'\u000f\t\tE%\u0011\u0014\b\u0005\u0005'\u00139J\u0004\u0003\u0002\u0000\tU\u0015\"\u0001;\n\u0005I\u001c\u0018BA+r\u0013\ty\u0007/C\u0002\u0003 :\faaY8oM&<\u0017\u0002\u0002BR\u0005K\u000b\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0007\t}e.\u0003\u0003\u0003*\n-\u0016\u0001E\"p]\u001adW/\u001a8u\u0007>tg-[4t\u0015\u0011\u0011\u0019K!*\n\t\t=&\u0011\u0017\u0002\u001a\u00072,8\u000f^3s\u0019&t7\u000e\u00165sK\u0006$\u0017I\u001a4j]&$\u0018P\u0003\u0003\u0003*\n-\u0006b\u0002B[y\u0001\u0007!qW\u0001\u000fY&t7nU2iK\u0012,H.\u001a:t!!\tYH!/\u0003>\n\r\u0017\u0002\u0002B^\u0003\u001b\u00131!T1q!\u0011\t\tDa0\n\t\t\u0005\u00171\u0007\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uCB\u0019\u0011L!2\n\u0007\t\u001d'LA\u0002J]R\f\u0001\u0005^3ti2+\u0017\rZ3s\u0003:$\u0017j\u001d:CK\u001a|'/\u001a'j].,\u0006\u000fZ1uK\"\u001aQ(!/\u0002]Q,7\u000f^!eIJ+Wn\u001c<f!\u0006\u0014H/\u001b;j_:\u001cH*\u001b8l\u0007>|'\u000fZ5oCR|'\u000fR5tC\ndW\r\u001a\u0015\u0004}\u0005e\u0016A\n;fgR\fE\r\u001a*f[>4X\rU1si&$\u0018n\u001c8t\u0019&t7nQ8pe\u0012Lg.\u0019;pe\"\u001aq(!/\u0002SQ,7\u000f^!eIJ+Wn\u001c<f!\u0006\u0014H/\u001b;j_:\u001chj\u001c;MS:\\7i\\8sI&t\u0017\r^8sQ\r\u0001\u0015\u0011X\u0001\u001am\u0016\u0014\u0018NZ=BI\u0012\u0014V-\\8wKB\u000b'\u000f^5uS>t7\u000f\u0006\u0004\u0002X\tu'\u0011\u001d\u0005\b\u0005?\f\u0005\u0019\u0001B\u0012\u0003Ya\u0017N\\6D_>\u0014H-\u001b8bi>\u0014XI\\1cY\u0016$\u0007b\u0002Br\u0003\u0002\u0007!1E\u0001\u0012SNd\u0015N\\6D_>\u0014H-\u001b8bi>\u0014\u0018AE2sK\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e$\u0012\u0001Z\u0001\u001dO\u0016$8\t\\;ti\u0016\u0014H*\u001b8l\r\u0006LG.\u001a3BiR,W\u000e\u001d;t)\u0019\u0011iOa=\u0003vB\u0019\u0011La<\n\u0007\tE(L\u0001\u0003M_:<\u0007bBA%\u0007\u0002\u0007\u0011Q\n\u0005\b\u0003k\u001c\u0005\u0019AA|\u0003i\u0019G.^:uKJd\u0015N\\6QKJ\u001c\u0018n\u001d;f]R\u0004&o\u001c9t+\t\u0011\u0019!A\tdYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e,\"Aa@\u0011\u0007\u0005\u001c\t!C\u0002\u0004\u0004A\u0013\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003%\u0019X\r^;q\u001b>\u001c7\u000e\u0006\u0005\u0002X\r%1\u0011DB\u0012\u0011\u001d\u0019YA\u0012a\u0001\u0007\u001b\t\u0011\u0002]1si&$\u0018n\u001c8\u0011\t\r=1QC\u0007\u0003\u0007#Q1aa\u0005U\u0003\u001d\u0019G.^:uKJLAaa\u0006\u0004\u0012\tI\u0001+\u0019:uSRLwN\u001c\u0005\b\u000771\u0005\u0019AB\u000f\u0003\t!\b\u000f\u0005\u0003\u0002z\u000e}\u0011bAB\u0011]\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA{\r\u0002\u00071Q\u0005\t\u00063\u000e\u001d\u0012q_\u0005\u0004\u0007SQ&AB(qi&|g.\u0001\rde\u0016\fG/Z\"mkN$XM\u001d'j].l\u0015M\\1hKJ$b!!\u0014\u00040\rE\u0002\"\u00022H\u0001\u0004!\u0007bBB\u001a\u000f\u0002\u00071QG\u0001\u0010[\u0016$\u0018\rZ1uCN+\b\u000f]8siB\u0019Qma\u000e\n\u0007\re\"KA\bNKR\fG-\u0019;b'V\u0004\bo\u001c:u\u0003]\u0019H/\u0019:u\u00072,8\u000f^3s\u0019&t7.T1oC\u001e,'\u000f\u0006\u0004\u0002X\r}2\u0011\n\u0005\b\u0007\u0003B\u0005\u0019AB\"\u0003\u001di\u0017M\\1hKJ\u0004B!a9\u0004F%!1qIAw\u0005-a\u0015N\\6NC:\fw-\u001a:\t\u000f\rM\u0002\n1\u0001\u00046\u0005ISM\\:ve\u0016dunY6O_R\f5-];je\u0016$')\u001a4pe\u0016LeN^8lS:<W*\u001a;i_\u0012$B!a\u0016\u0004P!91\u0011K%A\u0002\u0005e\u0014AC7fi\"|GMT1nK\u000612\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s)\u0016\u001cH\u000f\u0005\u0002b\u0017N\u00111\n\u0017\u000b\u0003\u0007+\n!b]3u+B\u001cE.Y:tQ\ri5q\f\t\u0005\u00033\u001b\t'\u0003\u0003\u0004d\u0005m%!\u0003\"fM>\u0014X-\u00117m\u00035!X-\u0019:E_^t7\t\\1tg\"\u001aaj!\u001b\u0011\t\u0005e51N\u0005\u0005\u0007[\nYJ\u0001\u0005BMR,'/\u00117m\u0001")
public class ClusterLinkManagerTest {
    private final KafkaConfig kafka$server$link$ClusterLinkManagerTest$$brokerConfig = this.createBrokerConfig();
    private final Metrics kafka$server$link$ClusterLinkManagerTest$$metrics = new Metrics();
    private final MockTime kafka$server$link$ClusterLinkManagerTest$$time = new MockTime();
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
    private final ControllerContext controllerContext = (ControllerContext)Mockito.mock(ControllerContext.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
    private final MetadataCache metadataCache;
    private ClusterLinkManager clusterLinkManager;
    private ZkSupport zkSupport;
    private final String topicConfigSyncIncludeDefault;

    @AfterAll
    public static void tearDownClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@AfterAll");
    }

    @BeforeAll
    public static void setUpClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@BeforeAll");
    }

    public KafkaConfig kafka$server$link$ClusterLinkManagerTest$$brokerConfig() {
        return this.kafka$server$link$ClusterLinkManagerTest$$brokerConfig;
    }

    public Metrics kafka$server$link$ClusterLinkManagerTest$$metrics() {
        return this.kafka$server$link$ClusterLinkManagerTest$$metrics;
    }

    public MockTime kafka$server$link$ClusterLinkManagerTest$$time() {
        return this.kafka$server$link$ClusterLinkManagerTest$$time;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    private void clusterLinkManager_$eq(ClusterLinkManager x$1) {
        this.clusterLinkManager = x$1;
    }

    private ZkSupport zkSupport() {
        return this.zkSupport;
    }

    private void zkSupport_$eq(ZkSupport x$1) {
        this.zkSupport = x$1;
    }

    private String topicConfigSyncIncludeDefault() {
        return this.topicConfigSyncIncludeDefault;
    }

    @BeforeEach
    public void setUp() {
        ((ReplicaManager)Mockito.doReturn((Object)this.metadataCache(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.replicaManager())).metadataCache();
        ((ReplicaManager)Mockito.doReturn((Object)new Some((Object)this.zkClient()), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.replicaManager())).zkClient();
        ((ReplicaManager)Mockito.doReturn((Object)Predef$.MODULE$.Set().empty().iterator(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.replicaManager())).leaderPartitionsIterator();
        ((KafkaController)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.controller())).isActive();
        ((KafkaZkClient)Mockito.doReturn((Object)package$.MODULE$.Seq().empty(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getChildren("/cluster_links");
        ((KafkaZkClient)Mockito.doReturn((Object)Predef$.MODULE$.Map().empty(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getClusterLinks(Predef$.MODULE$.Set().empty());
        ((KafkaZkClient)Mockito.doNothing().when((Object)this.zkClient())).transformEntityConfigs((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any());
        this.zkSupport_$eq(new ZkSupport(null, this.controller(), this.zkClient(), (Option)None$.MODULE$, (ZkMetadataCache)this.metadataCache(), new BrokerEpochManager(null){

            public long get() {
                return 1L;
            }

            public boolean isBrokerEpochStale(long brokerEpochInRequest, boolean isKRaftControllerRequest) {
                return false;
            }
        }));
        this.clusterLinkManager_$eq(this.createClusterLinkManager(this.kafka$server$link$ClusterLinkManagerTest$$brokerConfig(), (MetadataSupport)this.zkSupport()));
    }

    @AfterEach
    public void tearDown() {
        this.clusterLinkManager().shutdown();
        this.kafka$server$link$ClusterLinkManagerTest$$metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClusterLinks() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        String topic = "testTopic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        Partition partition0 = (Partition)Mockito.mock(Partition.class);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().clientManager(linkId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> this.clusterLinkManager().resolveLinkIdOrThrow(linkName), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.clusterLinkManager().ensureLinkNameDoesntExist(linkName);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.clusterLinkManager().listClusterLinks());
        this.setupMock(partition0, tp0, (Option<Uuid>)None$.MODULE$);
        this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
        this.setupMock(partition0, tp0, (Option<Uuid>)new Some((Object)linkId));
        Assertions.assertEquals((int)0, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        this.setupMock(partition0, tp0, (Option<Uuid>)new Some((Object)linkId));
        ((KafkaZkClient)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).clusterLinkExists(linkId);
        this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().clientManager(linkId));
        Assertions.assertEquals((Object)new Some((Object)linkId), (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions.assertEquals((Object)new .colon.colon((Object)clusterLinkData, (List)Nil$.MODULE$), (Object)this.clusterLinkManager().listClusterLinks());
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
        ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)this.clusterLinkManager().clientManager(linkId).get();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.clusterLinkManager().createClusterLink(new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false), this.clusterLinkConfig(), this.clusterLinkPersistentProps()), ClassTag$.MODULE$.apply(ClusterLinkExistsException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        Assertions.assertTrue((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds()), (String)"Topic not added to metadata");
        Assertions.assertTrue((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic not added to client manager");
        Assertions.assertFalse((boolean)fetcherManager.isEmpty(), (String)"Fetcher not recording active topic");
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = (LeaderAndIsrRequestData.LeaderAndIsrPartitionState)Mockito.mock(LeaderAndIsrRequestData.LeaderAndIsrPartitionState.class);
        ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)Mockito.doReturn((Object)javaLinkId.toString(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partitionState)).clusterLinkId();
        ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)Mockito.doReturn((Object)"Mirror", (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partitionState)).clusterLinkTopicState();
        ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)Mockito.doReturn((Object)BoxesRunTime.boxToInteger((int)1), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partitionState)).linkedLeaderEpoch();
        ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)Mockito.doReturn((Object)Uuid.randomUuid(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partitionState)).clusterLinkSourceTopicId();
        this.clusterLinkManager().removePartitions((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        Assertions.assertTrue((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds()), (String)"Topic removed from metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic not removed from client manager");
        Mockito.reset((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{partitionState});
        ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)Mockito.doReturn(null, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partitionState)).clusterLinkId();
        ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)Mockito.doReturn((Object)Uuid.randomUuid(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partitionState)).clusterLinkSourceTopicId();
        this.clusterLinkManager().removePartitions((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        Assertions.assertFalse((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds()), (String)"Topic not removed from metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be in client manager");
        Mockito.reset((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{partitionState});
        ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)Mockito.doReturn((Object)javaLinkId.toString(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partitionState)).clusterLinkId();
        ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)Mockito.doReturn((Object)Uuid.randomUuid(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partitionState)).clusterLinkSourceTopicId();
        ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)Mockito.doReturn((Object)"FailedMirror", (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partitionState)).clusterLinkTopicState();
        ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)Mockito.doReturn((Object)BoxesRunTime.boxToInteger((int)-1), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partitionState)).linkedLeaderEpoch();
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        this.clusterLinkManager().removePartitions((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        Assertions.assertFalse((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds()), (String)"Topic not removed from metadata for failed mirror");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be in client manager for failed mirror");
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Partition partition1 = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition1, tp1, (Option<Uuid>)new Some((Object)linkId));
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1}))));
        Assertions.assertTrue((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds()), (String)"Topic not added to metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be added to client manager");
        this.clusterLinkManager().removePartitionsAndMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Assertions.assertFalse((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds()), (String)"Topic not removed from metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be in to client manager");
        Object object = this.clusterLinkManager().fetcherManager(linkId).get();
        Assertions.assertTrue((object != null && object.equals(fetcherManager) ? 1 : 0) != 0, (String)"Unexpected fetcher manager");
        Object object2 = this.clusterLinkManager().clientManager(linkId).get();
        Assertions.assertTrue((object2 != null && object2.equals(clientManager) ? 1 : 0) != 0, (String)"Unexpected client manager");
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
        ClusterLinkData cldIsDeleted = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, true);
        ((KafkaZkClient)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).clusterLinkExists(linkId);
        ((KafkaZkClient)Mockito.doReturn((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)cldIsDeleted)})), (Object[])new Object[]{Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)}).when((Object)this.zkClient())).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})));
        int controllerEpochVersion = 0;
        ((ControllerContext)Mockito.doReturn((Object)BoxesRunTime.boxToInteger((int)controllerEpochVersion), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.controllerContext())).epochZkVersion();
        ((KafkaController)Mockito.doReturn((Object)this.controllerContext(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.controller())).controllerContext();
        ((KafkaZkClient)Mockito.doNothing().when((Object)this.zkClient())).setClusterLink(cldIsDeleted, controllerEpochVersion);
        this.clusterLinkManager().deleteClusterLink(linkName, linkId);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().resolveLinkId(linkName));
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.clusterLinkManager().deleteClusterLink(linkName, linkId), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinks$4(this, linkId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinks$5(linkId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient(), (VerificationMode)Mockito.times((int)3))).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})));
    }

    @Test
    public void testCreateClusterLinkRejectsRequestIfTenantPrefixIsNullAndCreateClusterLinkPolicyExists() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        props.put(KafkaConfig$.MODULE$.CreateClusterLinkPolicyClassNameProp(), TestCreateClusterLinkPolicy.class);
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(props);
        this.clusterLinkManager().shutdown();
        ClusterLinkManager clusterLinkManager = this.createClusterLinkManager(brokerConfig, (MetadataSupport)this.zkSupport());
        InvalidRequestException ex = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> clusterLinkManager.createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps()));
        Assertions.assertEquals((Object)"Tenant prefix cannot be null if a CreateClusterLinkPolicy is set.", (Object)ex.getMessage());
    }

    @Test
    public void testReconfigure() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$testReconfigure$2(props))), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        ((KafkaZkClient)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).clusterLinkExists(linkId);
        ((KafkaZkClient)Mockito.doReturn((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false))})), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        this.clusterLinkManager().createClusterLink(new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        ClusterLinkFactory.FetcherManager fetcherManager = (ClusterLinkFactory.FetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
        ((KafkaZkClient)Mockito.doReturn((Object)newProps, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getEntityConfigs("cluster-links", javaLinkId.toString());
        this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$testReconfigure$3(props)));
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).getEntityConfigs("cluster-links", javaLinkId.toString());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
        ((KafkaZkClient)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).clusterLinkExists(linkId);
        ((KafkaZkClient)Mockito.doReturn((Object)newProps, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getEntityConfigs("cluster-links", javaLinkId.toString());
        ((KafkaZkClient)Mockito.doReturn((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false))})), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})));
        ((KafkaZkClient)Mockito.doNothing().when((Object)this.zkClient())).setOrCreateEntityConfigs((String)ArgumentMatchers.eq((Object)"cluster-links"), (String)ArgumentMatchers.eq((Object)linkId.toString()), (Properties)ArgumentMatchers.any(Properties.class));
        this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$testReconfigure$4(props)));
        ArgumentCaptor capturedProps = ArgumentCaptor.forClass(Properties.class);
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).setOrCreateEntityConfigs((String)ArgumentMatchers.eq((Object)"cluster-links"), (String)ArgumentMatchers.eq((Object)javaLinkId.toString()), (Properties)capturedProps.capture());
        ClusterLinkManager qual$2 = this.clusterLinkManager();
        Properties x$5 = (Properties)capturedProps.getValue();
        boolean x$6 = qual$2.processClusterLinkChanges$default$3();
        qual$2.processClusterLinkChanges(linkId, x$5, x$6);
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).getEntityConfigs("cluster-links", javaLinkId.toString());
    }

    @Test
    public void testConnectionManager() {
        ((KafkaZkClient)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).clusterLinkExists((Uuid)ArgumentMatchers.any());
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Option)None$.MODULE$, ClusterLinkOutboundConnectionManager.class, false);
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, (Option)None$.MODULE$, ClusterLinkInboundConnectionManager.class, true);
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.SOURCE, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Option)None$.MODULE$, ClusterLinkOutboundConnectionManager.class, true);
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Option)new Some((Object)ConnectionMode.Outbound$.MODULE$), ClusterLinkOutboundConnectionManager.class, false);
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Option)new Some((Object)ConnectionMode.Inbound$.MODULE$), ClusterLinkOutboundConnectionManager.class, true);
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Option)None$.MODULE$, ClusterLinkOutboundConnectionManager.class, false);
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, (Option)None$.MODULE$, ClusterLinkInboundConnectionManager.class, true);
    }

    @Test
    public void testRetentionConfigSync() {
        String linkName = "test-retention";
        Uuid linkId = Uuid.randomUuid();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Assertions.assertFalse((boolean)fetcherManager.currentConfig().useIndependentRetention());
        Properties newProps = new Properties();
        scala.collection.immutable.Set syncInclude = (scala.collection.immutable.Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"retention.ms", "retention.bytes"})));
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), syncInclude.mkString(","));
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals((Object)syncInclude, (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Assertions.assertFalse((boolean)fetcherManager.currentConfig().useIndependentRetention());
        syncInclude = (scala.collection.immutable.Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"segment.index.bytes"})));
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), syncInclude.mkString(","));
        ClusterLinkManager qual$2 = this.clusterLinkManager();
        boolean x$6 = qual$2.processClusterLinkChanges$default$3();
        qual$2.processClusterLinkChanges(linkId, newProps, x$6);
        Assertions.assertEquals((Object)syncInclude, (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Assertions.assertTrue((boolean)fetcherManager.currentConfig().useIndependentRetention());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
    }

    @Test
    public void testTopicConfigSyncIncludeCompatibility() {
        this.verifyDefault();
        this.verifyZKHasMalformedConfigs();
        this.verifyZKHasUnknownConfigs();
        this.verifyZKMissesAlwaysConfigs();
        this.verifyZKHasIndependentConfigs();
    }

    private void verifyDefault() {
        String linkName = "test-default";
        Uuid linkId = Uuid.randomUuid();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala(MirrorTopicConfigSyncRules$.MODULE$.SyncIncludeDefault()).asScala().toSet(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
    }

    private void verifyZKHasMalformedConfigs() {
        String linkName = "test-malformed";
        Uuid linkId = Uuid.randomUuid();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), new StringBuilder(23).append(this.topicConfigSyncIncludeDefault()).append(",\u001fmin.compaction.lag.ms").toString());
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala(MirrorTopicConfigSyncRules$.MODULE$.SyncIncludeDefault()).asScala().toSet(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
    }

    private void verifyZKHasUnknownConfigs() {
        String linkName = "test-unknown";
        Uuid linkId = Uuid.randomUuid();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), new StringBuilder(21).append(this.topicConfigSyncIncludeDefault()).append(",unknown.topic.config").toString());
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala(MirrorTopicConfigSyncRules$.MODULE$.SyncIncludeDefault()).asScala().toSet(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
    }

    private void verifyZKMissesAlwaysConfigs() {
        String linkName = "test-always";
        Uuid linkId = Uuid.randomUuid();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        String topicConfigSyncIncludeOverride = "min.compaction.lag.ms";
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncIncludeOverride);
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"min.compaction.lag.ms"}))), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
    }

    private void verifyZKHasIndependentConfigs() {
        String linkName = "test-independent";
        Uuid linkId = Uuid.randomUuid();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        String topicConfigSyncIncludeOverride = MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.tier.enable"}))).mkString(",");
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncIncludeOverride);
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
    }

    public ClusterLinkFactory.FetcherManager createClusterLink(String linkName, Uuid linkId, Properties clusterLinkProps) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$createClusterLink$2(props))), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        ((KafkaZkClient)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).clusterLinkExists(linkId);
        ((KafkaZkClient)Mockito.doReturn((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false))})), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        this.clusterLinkManager().createClusterLink(new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), this.clusterLinkConfig(), clusterLinkProps);
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        return (ClusterLinkFactory.FetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
    }

    @Test
    public void testFailedAddClusterLink() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        Assertions.assertTrue((boolean)this.clusterLinkManager().resolveLinkId(linkName).isEmpty());
        Assertions.assertTrue((boolean)this.clusterLinkManager().listClusterLinks().isEmpty());
        ((KafkaZkClient)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).clusterLinkExists(linkId);
        ((KafkaZkClient)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("")}).when((Object)this.zkClient())).createClusterLink(clusterLinkData);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps()), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
        Assertions.assertTrue((boolean)this.clusterLinkManager().resolveLinkId(linkName).isEmpty());
        Assertions.assertTrue((boolean)this.clusterLinkManager().listClusterLinks().isEmpty());
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).createClusterLink(clusterLinkData);
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
        ((KafkaZkClient)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).clusterLinkExists(linkId);
        this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        Assertions.assertEquals((Object)new Some((Object)linkId), (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions.assertEquals((Object)new .colon.colon((Object)clusterLinkData, (List)Nil$.MODULE$), (Object)this.clusterLinkManager().listClusterLinks());
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
    }

    @Test
    public void testReconfigureNonRetriableFailure() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        String clusterId = "testClusterId";
        KafkaException testException = new KafkaException("Test exception");
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        ((KafkaZkClient)Mockito.doReturn((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)clusterLinkData)})), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})));
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "");
        this.clusterLinkManager().configEncoder_$eq((ClusterLinkConfigEncoder)Mockito.mock(ClusterLinkConfigEncoder.class));
        ((ClusterLinkConfigEncoder)Mockito.doThrow((Throwable[])new Throwable[]{testException}).when((Object)this.clusterLinkManager().configEncoder())).encode((Properties)ArgumentMatchers.any());
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals((Object)FailedClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryReconfigureRetriableFailureOnLinkRunning() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        this.clusterLinkManager().metadataManager().shutdown();
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        this.clusterLinkManager().metadataManager_$eq((ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class));
        ((ClusterLinkMetadataManager)Mockito.doReturn((Object)Option$.MODULE$.apply((Object)clusterLinkData), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.clusterLinkManager().metadataManager())).getClusterLinkData(linkId);
        ((ClusterLinkMetadataManager)Mockito.doReturn((Object)metadataCache, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.clusterLinkManager().metadataManager())).metadataCache();
        ((MetadataCache)Mockito.doReturn((Object)MetadataVersion.MINIMUM_BOOTSTRAP_VERSION, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)metadataCache)).metadataVersion();
        ((KafkaController)Mockito.doReturn((Object)this.controllerContext(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.controller())).controllerContext();
        ((ControllerContext)Mockito.doReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.controllerContext())).linkedTopics();
        this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "");
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        this.increaseElapsedTimeAndWaitForRetry$1(2L, "", "after increasing the elapsed time", 0L, linkId, linkName);
        this.increaseElapsedTimeAndWaitForRetry$1(3L, "", "after increasing the elapsed time", ClusterLinkRetryState$.MODULE$.RETRY_BACKOFF_MAX_MS(), linkId, linkName);
        this.increaseElapsedTimeAndWaitForRetry$1(4L, "", "after increasing the elapsed time second time", ClusterLinkRetryState$.MODULE$.RETRY_BACKOFF_MAX_MS(), linkId, linkName);
        this.kafka$server$link$ClusterLinkManagerTest$$time().setCurrentTimeMs(this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds() + 1L);
        newProps.put("bootstrap.servers", "invalid-bootstrap-server:9093");
        ClusterLinkManager qual$2 = this.clusterLinkManager();
        boolean x$6 = qual$2.processClusterLinkChanges$default$3();
        qual$2.processClusterLinkChanges(linkId, newProps, x$6);
        this.increaseElapsedTimeAndWaitForRetry$1(2L, "invalid-bootstrap-server:9093", "after updating link config", 0L, linkId, linkName);
        this.increaseElapsedTimeAndWaitForRetry$1(3L, "invalid-bootstrap-server:9093", "after updating link config and increasing elapsed time", ClusterLinkRetryState$.MODULE$.RETRY_BACKOFF_MAX_MS(), linkId, linkName);
        newProps.put("bootstrap.servers", "localhost:2222");
        this.clusterLinkManager().updateLinkPropertiesCache(linkId, newProps);
        this.kafka$server$link$ClusterLinkManagerTest$$time().setCurrentTimeMs(this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds() + ClusterLinkRetryState$.MODULE$.RETRY_BACKOFF_MAX_MS());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testRetryReconfigureRetriableFailureOnLinkRunning$5(this, linkId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Cluster link retry candidate not removed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)ActiveClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
        Assertions.assertFalse((boolean)this.containsMetric("broker-failed-link-count"));
        Assertions.assertFalse((boolean)this.containsMetric("link-failure-retry-attempts-rate"));
        Assertions.assertFalse((boolean)this.containsMetric("link-failure-retry-attempts-total"));
    }

    private boolean containsMetric(String name) {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.kafka$server$link$ClusterLinkManagerTest$$metrics().metrics()).asScala().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$containsMetric$1(name, x0$1)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryReconfigureRetriableFailureOnLinkStartup() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        ClusterLinkMetadataManager oldMetaManager = this.clusterLinkManager().metadataManager();
        this.clusterLinkManager().metadataManager_$eq((ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class));
        ((KafkaZkClient)Mockito.doReturn((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)clusterLinkData)})), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})));
        ((KafkaZkClient)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).clusterLinkExists(linkId);
        ((ClusterLinkMetadataManager)Mockito.doReturn((Object)Option$.MODULE$.apply((Object)clusterLinkData), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.clusterLinkManager().metadataManager())).getClusterLinkData(linkId);
        ((ClusterLinkMetadataManager)Mockito.doReturn((Object)metadataCache, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.clusterLinkManager().metadataManager())).metadataCache();
        ((MetadataCache)Mockito.doReturn((Object)MetadataVersion.MINIMUM_BOOTSTRAP_VERSION, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)metadataCache)).metadataVersion();
        Properties props = new Properties();
        props.put("bootstrap.servers", "");
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, props, x$3);
        Assertions.assertEquals((Object)FailedClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
        Assertions.assertEquals((Object)ClusterLinkError.UNRESOLVABLE_BOOTSTRAP_ERROR, (Object)((UnavailableLinkReason)((ClusterLinkInfo)this.clusterLinkManager().clusterLinkInfo(linkName).get()).linkStateInfo().unavailableLinkReason().get()).clusterLinkError());
        Assertions.assertTrue((boolean)this.clusterLinkManager().linkPropertiesCache().get((Object)linkId).nonEmpty());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:1234");
        this.clusterLinkManager().updateLinkPropertiesCache(linkId, newProps);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testRetryReconfigureRetriableFailureOnLinkStartup$1(this, linkId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Cluster link retry candidate not removed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)ActiveClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
        this.clusterLinkManager().metadataManager_$eq(oldMetaManager);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteClusterLink() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, true);
        ((KafkaZkClient)Mockito.doReturn((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)clusterLinkData)})), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})));
        ((KafkaZkClient)Mockito.doReturn((Object)Predef$.MODULE$.Set().empty(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getAllTopicsInCluster(false);
        ((KafkaController)Mockito.doReturn((Object)this.controllerContext(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.controller())).controllerContext();
        ((ControllerContext)Mockito.doReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.controllerContext())).linkedTopics();
        Assertions.assertEquals((Object)UnavailableClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)this.clusterLinkManager().clearMirrorTopics().keySet());
        scala.collection.mutable.Map managers = (scala.collection.mutable.Map)TestUtils.fieldValue((Object)this.clusterLinkManager(), ClusterLinkManager.class, (String)"managers");
        Assertions.assertEquals((Object)Map$.MODULE$.empty(), (Object)managers);
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        Properties x$2 = new Properties();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, x$2, x$3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{linkId})), (Object)this.clusterLinkManager().clearMirrorTopics().keySet());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testDeleteClusterLink$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Cluster link not removed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testControllerListenerMirrorStates() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        String topic = "testTopic";
        ((KafkaZkClient)Mockito.doReturn((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)clusterLinkData)})), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})));
        ((KafkaZkClient)Mockito.doReturn((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getAllTopicsInCluster(false);
        ((KafkaController)Mockito.doReturn((Object)this.controllerContext(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.controller())).controllerContext();
        ClusterLinkTopicState.PendingStoppedMirror mirrorState = new ClusterLinkTopicState.PendingStoppedMirror(linkName, linkId, Uuid.randomUuid(), true, Time.SYSTEM.milliseconds());
        ((ControllerContext)Mockito.doReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.controllerContext())).linkedTopics();
        this.controllerContext().linkedTopics().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)mirrorState));
        ((ClusterLinkControllerListener)this.clusterLinkManager().controllerListener().get()).onStateChange("testTopic", (Option)None$.MODULE$, (Option)new Some((Object)mirrorState));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().clientManager(linkId));
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        Properties x$2 = this.clusterLinkPersistentProps();
        boolean x$32 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, x$2, x$32);
        Assertions.assertEquals((Object)new Some(ClusterLinkDestClientManager.class), (Object)this.clusterLinkManager().clientManager(linkId).map((Function1 & Serializable)x$3 -> x$3.getClass()));
        ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)this.clusterLinkManager().clientManager(linkId).get();
        Assertions.assertEquals((int)0, (int)clientManager.taskManager().clusterLinkStopMirrors().subTaskCount());
        this.clusterLinkManager().processControllerMirrorStates((Map)this.controllerContext().linkedTopics());
        Assertions.assertEquals((int)1, (int)clientManager.taskManager().clusterLinkStopMirrors().subTaskCount());
    }

    @Test
    @Timeout(value=20L)
    public void testListClusterLinksLocking() {
        Object updateLock = TestUtils.fieldValue((Object)this.clusterLinkManager(), ClusterLinkManager.class, (String)"updateLock");
        CountDownLatch latch = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Semaphore semaphore = new Semaphore(0);
        try {
            executor.submit(() -> {
                synchronized (updateLock) {
                    latch.countDown();
                    semaphore.tryAcquire(30L, TimeUnit.SECONDS);
                    return;
                }
            }, BoxesRunTime.boxToInteger((int)0));
            latch.await(10L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.clusterLinkManager().listClusterLinks());
            semaphore.release();
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testRetryLocking() {
        this.clusterLinkManager().shutdown();
        ClusterLinkQuotas quotas = ClusterLinkQuotas$.MODULE$.unboundedClusterLinkQuotas();
        this.clusterLinkManager_$eq(new ClusterLinkManager(this, quotas){
            private final /* synthetic */ ClusterLinkManagerTest $outer;

            public void processClusterLinkChanges(Uuid linkId, Properties persistentProps, boolean retry) {
                this.$outer.kafka$server$link$ClusterLinkManagerTest$$ensureLockNotAcquiredBeforeInvokingMethod("processClusterLinkChanges");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$server$link$ClusterLinkManagerTest$$brokerConfig(), "clusterId", quotas$1, $outer.kafka$server$link$ClusterLinkManagerTest$$metrics(), (Time)$outer.kafka$server$link$ClusterLinkManagerTest$$time(), false, (Option)None$.MODULE$);
            }
        });
        ClusterLinkData linkData = new ClusterLinkData("link1", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        this.clusterLinkManager().linkPropertiesCache().put((Object)linkData.linkId(), (Object)this.clusterLinkPersistentProps());
        ClusterLinkFailed.FailedClusterLinkMetrics failedMetrics = new ClusterLinkFailed.FailedClusterLinkMetrics(linkData.linkName(), this.kafka$server$link$ClusterLinkManagerTest$$metrics(), (Option)None$.MODULE$, (FailedLinkReason)UnauthorizedBootstrapFailedLinkReason$.MODULE$);
        this.clusterLinkManager().linkRetryCandidates().put((Object)linkData.linkId(), (Object)new ClusterLinkRetryState(this.clusterLinkManager(), this.clusterLinkManager().scheduler(linkData.linkName(), (Option)None$.MODULE$), linkData, quotas, (Time)this.kafka$server$link$ClusterLinkManagerTest$$time(), failedMetrics));
        this.clusterLinkManager().retryConfigUpdate(linkData.linkId(), this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds());
    }

    @Test
    public void testNonOptimizedNonBlockingLocalAdmin() {
        this.verifyNonBlockingLocalAdmin(false);
    }

    @Test
    public void testOptimizedNonBlockingLocalAdmin() {
        this.verifyNonBlockingLocalAdmin(true);
    }

    public void verifyNonBlockingLocalAdmin(boolean enableOptimizedClient) {
        this.clusterLinkManager().shutdown();
        ClusterLinkQuotas quotas = ClusterLinkQuotas$.MODULE$.unboundedClusterLinkQuotas();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        props.put("confluent.cluster.link.enable.local.admin", Boolean.toString(enableOptimizedClient));
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(props);
        AtomicReference lastAdmin = new AtomicReference();
        Buffer adminIndices = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.clusterLinkManager_$eq(new ClusterLinkManager(this, brokerConfig, quotas, lastAdmin, adminIndices){
            private final /* synthetic */ ClusterLinkManagerTest $outer;
            private final AtomicReference lastAdmin$1;
            private final Buffer adminIndices$1;

            public ClusterLinkLocalAdmin createLocalAdmin(ClusterLinkScheduler scheduler, int adminIndex) {
                ClusterLinkLocalAdmin admin = (ClusterLinkLocalAdmin)Mockito.mock(ClusterLinkLocalAdmin.class);
                this.lastAdmin$1.set(admin);
                this.adminIndices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)adminIndex));
                return admin;
            }

            public void processClusterLinkChanges(Uuid linkId, Properties persistentProps, boolean retry) {
                this.$outer.kafka$server$link$ClusterLinkManagerTest$$ensureLockNotAcquiredBeforeInvokingMethod("processClusterLinkChanges");
                super.processClusterLinkChanges(linkId, persistentProps, retry);
            }

            public void createClusterLink(ClusterLinkData clusterLinkData, ClusterLinkConfig clusterLinkConfig, Properties persistentProps) {
                this.$outer.kafka$server$link$ClusterLinkManagerTest$$ensureLockNotAcquiredBeforeInvokingMethod("createClusterLink");
                super.createClusterLink(clusterLinkData, clusterLinkConfig, persistentProps);
            }

            public void updateClusterLinkConfig(String linkName, Function1<Properties, Object> updateCallback) {
                this.$outer.kafka$server$link$ClusterLinkManagerTest$$ensureLockNotAcquiredBeforeInvokingMethod("updateClusterLinkConfig");
                super.updateClusterLinkConfig(linkName, updateCallback);
            }

            public void deleteClusterLink(String linkName, Uuid linkId) {
                this.$outer.kafka$server$link$ClusterLinkManagerTest$$ensureLockNotAcquiredBeforeInvokingMethod("deleteClusterLink");
                super.deleteClusterLink(linkName, linkId);
            }

            public void reportUnavailableLink(String linkName, UnavailableLinkReason unavailableLinkReason) {
                this.$outer.kafka$server$link$ClusterLinkManagerTest$$ensureLockNotAcquiredBeforeInvokingMethod("reportUnavailableLink");
                super.reportUnavailableLink(linkName, unavailableLinkReason);
            }

            public void reportAvailableLink(String linkName) {
                this.$outer.kafka$server$link$ClusterLinkManagerTest$$ensureLockNotAcquiredBeforeInvokingMethod("reportAvailableLink");
                super.reportAvailableLink(linkName);
            }

            public void purgeClusterLink(Uuid linkId, String linkName, boolean isLinkCoordinator) {
                this.$outer.kafka$server$link$ClusterLinkManagerTest$$ensureLockNotAcquiredBeforeInvokingMethod("purgeClusterLink");
                super.purgeClusterLink(linkId, linkName, isLinkCoordinator);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.lastAdmin$1 = lastAdmin$1;
                this.adminIndices$1 = adminIndices$1;
                super(brokerConfig$1, "clusterId", quotas$2, $outer.kafka$server$link$ClusterLinkManagerTest$$metrics(), (Time)$outer.kafka$server$link$ClusterLinkManagerTest$$time(), false, (Option)None$.MODULE$);
            }
        });
        this.startClusterLinkManager((ClusterLinkFactory.LinkManager)this.clusterLinkManager(), (MetadataSupport)this.zkSupport());
        Assertions.assertNull(lastAdmin.getAndSet(null));
        ClusterLinkLocalAdmin sharedLocalAdmin = this.clusterLinkManager().sharedLocalAdmin();
        Assertions.assertNotNull((Object)sharedLocalAdmin);
        Assertions.assertSame((Object)sharedLocalAdmin, lastAdmin.getAndSet(null));
        Assertions.assertSame((Object)sharedLocalAdmin, (Object)this.clusterLinkManager().sharedLocalAdmin());
        Assertions.assertNull(lastAdmin.getAndSet(null));
        CountDownLatch done = new CountDownLatch(1);
        AtomicReference nonBlockingAdmin = new AtomicReference();
        this.clusterLinkManager().withNonBlockingLocalAdmin("name", this.clusterLinkManager().taskManager("", (Option)None$.MODULE$), (Function1 & Serializable)admin -> {
            nonBlockingAdmin.set(admin);
            return KafkaFuture.completedFuture(null);
        }, (Function1 & Serializable)x$4 -> {
            done.countDown();
            return BoxedUnit.UNIT;
        });
        done.await(10L, TimeUnit.SECONDS);
        ClusterLinkLocalAdmin actualAdmin = (ClusterLinkLocalAdmin)nonBlockingAdmin.get();
        Assertions.assertNotNull((Object)actualAdmin);
        if (enableOptimizedClient) {
            Assertions.assertNull(lastAdmin.get());
            Assertions.assertSame((Object)sharedLocalAdmin, (Object)actualAdmin);
        } else {
            ClusterLinkLocalAdmin expectedAdmin = lastAdmin.getAndSet(null);
            Assertions.assertNotNull((Object)expectedAdmin);
            Assertions.assertSame((Object)expectedAdmin, (Object)actualAdmin);
            Assertions.assertNotSame((Object)sharedLocalAdmin, (Object)actualAdmin);
        }
        this.clusterLinkManager().withNonBlockingLocalAdmin("name", this.clusterLinkManager().taskManager("", (Option)None$.MODULE$), (Function1 & Serializable)x$5 -> KafkaFuture.completedFuture(null), (Function1 & Serializable)x$6 -> {
            ClusterLinkManagerTest.$anonfun$verifyNonBlockingLocalAdmin$4(x$6);
            return BoxedUnit.UNIT;
        });
        if (enableOptimizedClient) {
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)adminIndices.toSeq());
            return;
        }
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 0x7FFFFFFE, 0x7FFFFFFD})), (Object)adminIndices.toSeq());
    }

    @Test
    public void testTemporaryAdminIsClosed() {
        ClusterLinkLocalAdmin admin = (ClusterLinkLocalAdmin)Mockito.mock(ClusterLinkLocalAdmin.class);
        KafkaFuture.completedFuture(null);
        admin.close(Duration.ZERO);
        ((ClusterLinkLocalAdmin)Mockito.verify((Object)admin, (VerificationMode)Mockito.times((int)1))).close((Duration)ArgumentMatchers.any());
    }

    @Test
    public void testNonTemporaryAdminIsNotClosed() {
        ClusterLinkLocalAdmin admin = (ClusterLinkLocalAdmin)Mockito.mock(ClusterLinkLocalAdmin.class);
        KafkaFuture.completedFuture(null);
        ((ClusterLinkLocalAdmin)Mockito.verify((Object)admin, (VerificationMode)Mockito.never())).close((Duration)ArgumentMatchers.any());
    }

    @Test
    public void testTemporaryAdminIndex() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$9 -> {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((int)(Integer.MAX_VALUE - i), (int)this.clusterLinkManager().temporaryAdminIndex(0x7FFFFFF5)));
            Assertions.assertEquals((int)Integer.MAX_VALUE, (int)this.clusterLinkManager().temporaryAdminIndex(0x7FFFFFF5));
        });
    }

    @Test
    public void testDynamicFetchSize() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        FetchResponseSize defaultSize = new FetchResponseSize(Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchMaxBytes()), Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchResponseMaxBytes()));
        Assertions.assertEquals((Object)defaultSize, (Object)this.clusterLinkManager().fetchResponseSize(this.clusterLinkConfig()));
        Uuid linkId = Uuid.randomUuid();
        ((KafkaZkClient)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).clusterLinkExists(linkId);
        this.clusterLinkManager().createClusterLink(new ClusterLinkData("link", linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
        Assertions.assertEquals((int)0, (int)fetcherManager.fetcherCount());
        this.verifyFetchSize$1(defaultSize, props);
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", "10000");
        this.verifyFetchSize$1(new FetchResponseSize(5000, 10000), props);
        props.setProperty("confluent.cluster.link.fetch.response.min.bytes", "6000");
        this.verifyFetchSize$1(new FetchResponseSize(6000, 10000), props);
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", Integer.toString(Integer.MAX_VALUE));
        this.verifyFetchSize$1(defaultSize, props);
        ClusterLinkFetcherThread thread = (ClusterLinkFetcherThread)Mockito.mock(ClusterLinkFetcherThread.class);
        IntRef numThreads = IntRef.create((int)0);
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", Integer.toString(Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchResponseMaxBytes()) * 6));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> {
            ++numThreads$1.elem;
            fetcherManager.fetcherThreadMap().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new FetcherTag(0, numThreads$1.elem, (FetcherPool)FetcherPool.Default$.MODULE$)), (Object)thread));
            this.verifyFetchSize$1(new FetchResponseSize(Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchMaxBytes()), Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchResponseMaxBytes())), props);
        });
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", "10000");
        props.setProperty("confluent.cluster.link.fetch.response.min.bytes", "1");
        this.verifyFetchSize$1(new FetchResponseSize(1000, 2000), props);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$11 -> ClusterLinkManagerTest.addFetcherThread$1(numThreads, fetcherManager, thread));
        this.verifyFetchSize$1(new FetchResponseSize(500, 1000), props);
        fetcherManager.fetcherThreadMap().clear();
        this.verifyFetchSize$1(new FetchResponseSize(5000, 10000), props);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClusterLinkConfigReencryption() {
        String linkName = "link1";
        UUID linkId = UUID.randomUUID();
        KafkaException testException = new KafkaException("Test exception");
        this.setupZkClient$1(linkId, linkName);
        this.clusterLinkManager().shutdown();
        ((KafkaZkClient)Mockito.doThrow((Throwable[])new Throwable[]{testException}).when((Object)this.zkClient())).transformEntityConfigs((String)ArgumentMatchers.eq((Object)"cluster-links"), (String)ArgumentMatchers.eq((Object)linkId.toString()), (Function1)ArgumentMatchers.any());
        ClusterLinkManager clm1 = this.recreateClusterLinkManager$1(Long.MAX_VALUE);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$1(clm1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Retry not scheduled after failure");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        clm1.shutdown();
        this.setupZkClient$1(linkId, linkName);
        ((KafkaZkClient)Mockito.doNothing().when((Object)this.zkClient())).transformEntityConfigs((String)ArgumentMatchers.eq((Object)"cluster-links"), (String)ArgumentMatchers.eq((Object)linkId.toString()), (Function1)ArgumentMatchers.any());
        ClusterLinkManager clm2 = this.recreateClusterLinkManager$1(Long.MAX_VALUE);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$3(clm2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Unnecessary retry scheduled");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        clm2.shutdown();
        this.setupZkClient$1(linkId, linkName);
        ((KafkaZkClient)Mockito.doNothing().when((Object)this.zkClient())).transformEntityConfigs((String)ArgumentMatchers.eq((Object)"cluster-links"), (String)ArgumentMatchers.eq((Object)linkId.toString()), (Function1)ArgumentMatchers.any());
        ClusterLinkManager clm3 = this.recreateClusterLinkManager$1(30000L);
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$5(clm3)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Old encoder delete not scheduled");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        clm3.shutdown();
        this.setupZkClient$1(linkId, linkName);
        ((KafkaZkClient)Mockito.doNothing().when((Object)this.zkClient())).transformEntityConfigs((String)ArgumentMatchers.eq((Object)"cluster-links"), (String)ArgumentMatchers.eq((Object)linkId.toString()), (Function1)ArgumentMatchers.any());
        ClusterLinkManager clm4 = this.recreateClusterLinkManager$1(1L);
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$7(clm4)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Unnecessary delete retry scheduled");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        clm4.shutdown();
        this.setupZkClient$1(linkId, linkName);
        ((KafkaZkClient)Mockito.doNothing().doThrow(new Throwable[]{testException}).when((Object)this.zkClient())).transformEntityConfigs((String)ArgumentMatchers.eq((Object)"cluster-links"), (String)ArgumentMatchers.eq((Object)linkId.toString()), (Function1)ArgumentMatchers.any());
        ClusterLinkManager clm5 = this.recreateClusterLinkManager$1(1L);
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$9(clm5)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"Delete retry not scheduled");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        clm5.shutdown();
    }

    @Test
    public void testSchedulerWithLinkAffinity() {
        scala.collection.immutable.Map links = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("link1", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("link2", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("link3", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("link4", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("link5", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)), (Object)BoxesRunTime.boxToInteger((int)0))}));
        this.verifyLinkScheduler(ConfluentConfigs.ClusterLinkThreadAffinity.LINK, (scala.collection.immutable.Map<ClusterLinkData, Object>)links);
    }

    @Test
    public void testMultiTenantSchedulerWithLinkAffinity() {
        scala.collection.immutable.Map links = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("link1", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)new Some((Object)"tenant1_"), false)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("link2", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("link3", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)new Some((Object)"tenant2"), false)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("link4", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)new Some((Object)"tenant3"), false)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("link5", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)new Some((Object)"tenant1"), false)), (Object)BoxesRunTime.boxToInteger((int)0))}));
        this.verifyLinkScheduler(ConfluentConfigs.ClusterLinkThreadAffinity.LINK, (scala.collection.immutable.Map<ClusterLinkData, Object>)links);
    }

    @Test
    public void testMultiTenantSchedulerWithTenantAffinity() {
        scala.collection.immutable.Map links = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("tenant1_link1", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)new Some((Object)"tenant1_"), false)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("tenant2_link2", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("tenant2_link3", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)new Some((Object)"tenant2_"), false)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("tenant3_link4", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)new Some((Object)"tenant3_"), false)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("tenant1_link5", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)new Some((Object)"tenant1_"), false)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("tenant1_link6", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)new Some((Object)"tenant1_"), false)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ClusterLinkData("tenant1_link7", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)new Some((Object)"tenant1_"), false)), (Object)BoxesRunTime.boxToInteger((int)2))}));
        this.verifyLinkScheduler(ConfluentConfigs.ClusterLinkThreadAffinity.TENANT, (scala.collection.immutable.Map<ClusterLinkData, Object>)links);
    }

    private void verifyLinkScheduler(ConfluentConfigs.ClusterLinkThreadAffinity threadAffinity, scala.collection.immutable.Map<ClusterLinkData, Object> linkSchedulers) {
        this.clusterLinkManager().shutdown();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        props.put("confluent.cluster.link.num.background.threads", "3");
        props.put("confluent.cluster.link.background.thread.affinity", threadAffinity.name());
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(props);
        this.clusterLinkManager_$eq(new ClusterLinkManager(brokerConfig, "clusterId", ClusterLinkQuotas$.MODULE$.unboundedClusterLinkQuotas(), this.kafka$server$link$ClusterLinkManagerTest$$metrics(), (Time)this.kafka$server$link$ClusterLinkManagerTest$$time(), false, (Option)None$.MODULE$));
        this.startClusterLinkManager((ClusterLinkFactory.LinkManager)this.clusterLinkManager(), (MetadataSupport)this.zkSupport());
        Buffer expectedThreadUsage = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 0}));
        Buffer expectedThreadTenants = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.collection.mutable.Set[]{(scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)}));
        Assertions.assertEquals((Object)expectedThreadUsage, (Object)this.actualThreadUsage$1());
        Assertions.assertEquals((Object)((IterableOnceOps)expectedThreadTenants.map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.size()))).toSeq(), (Object)this.actualThreadTenants$1());
        ClusterLinkManager.Managers managers = (ClusterLinkManager.Managers)Mockito.mock(ClusterLinkManager.Managers.class);
        ClusterLinkOutboundConnectionManager connectionManager = (ClusterLinkOutboundConnectionManager)Mockito.mock(ClusterLinkOutboundConnectionManager.class);
        ((ClusterLinkManager.Managers)Mockito.doReturn((Object)connectionManager, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)managers)).connectionManager();
        ((ClusterLinkConnectionManager)Mockito.doReturn((Object)this.clusterLinkConfig(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)connectionManager)).currentConfig();
        linkSchedulers.foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkManagerTest.$anonfun$verifyLinkScheduler$4(this, managers, expectedThreadUsage, expectedThreadTenants, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLeaderAndIsrBeforeLinkUpdate() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        String topic = "testTopic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        Partition partition0 = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition0, tp0, (Option<Uuid>)new Some((Object)linkId));
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        ((ReplicaManager)Mockito.doReturn((Object)this.metadataCache(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.replicaManager())).metadataCache();
        ((ReplicaManager)Mockito.doReturn((Object)new Some((Object)this.zkClient()), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.replicaManager())).zkClient();
        ((ReplicaManager)Mockito.doReturn((Object)((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))).iterator(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.replicaManager())).leaderPartitionsIterator();
        Assertions.assertEquals((int)0, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ((ClusterLinkFetcherManager)Mockito.doNothing().when((Object)fetcherManager)).addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
        ((ClusterLinkFetcherManager)Mockito.doNothing().when((Object)fetcherManager)).shutdown();
        ((ClusterLinkFetcherManager)Mockito.doReturn((Object)package$.MODULE$.Seq().empty(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)fetcherManager)).lazyResources();
        ClusterLinkOutboundConnectionManager connectionManager = (ClusterLinkOutboundConnectionManager)Mockito.mock(ClusterLinkOutboundConnectionManager.class);
        ((ClusterLinkConnectionManager)Mockito.doReturn((Object)this.clusterLinkConfig(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)connectionManager)).currentConfig();
        ((ClusterLinkOutboundConnectionManager)Mockito.doReturn((Object)package$.MODULE$.Seq().empty(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)connectionManager)).lazyResources();
        ((ClusterLinkConnectionManager)Mockito.doReturn((Object)new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)connectionManager)).linkData();
        ((ClusterLinkConnectionManager)Mockito.doNothing().when((Object)connectionManager)).shutdown();
        ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
        ((ClusterLinkDestClientManager)Mockito.doNothing().when((Object)clientManager)).shutdown();
        ClusterLinkManager.Managers managers = new ClusterLinkManager.Managers((Option)new Some((Object)fetcherManager), (ClusterLinkFactory.ClientManager)clientManager, (ClusterLinkFactory.ConnectionManager)connectionManager, null);
        this.clusterLinkManager().commitAddClusterLink(clusterLinkData, managers, ClusterLinkConfig.LinkMode.DESTINATION);
        ((ClusterLinkFetcherManager)Mockito.verify((Object)fetcherManager)).addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
    }

    @Test
    public void testAddRemovePartitionsLinkCoordinatorDisabled() {
        this.verifyAddRemovePartitions(false, false);
    }

    @Test
    public void testAddRemovePartitionsLinkCoordinator() {
        this.verifyAddRemovePartitions(true, true);
    }

    @Test
    public void testAddRemovePartitionsNotLinkCoordinator() {
        this.verifyAddRemovePartitions(true, false);
    }

    private void verifyAddRemovePartitions(boolean linkCoordinatorEnabled, boolean isLinkCoordinator) {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)"remoteClusterId"), (Option)None$.MODULE$, false);
        ((KafkaZkClient)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).clusterLinkExists(linkId);
        this.clusterLinkManager().metadataManager().shutdown();
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        this.clusterLinkManager().metadataManager_$eq((ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class));
        ((ClusterLinkMetadataManager)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)linkCoordinatorEnabled), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.clusterLinkManager().metadataManager())).isLinkCoordinatorEnabled();
        ((ClusterLinkMetadataManager)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)isLinkCoordinator), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.clusterLinkManager().metadataManager())).isLinkCoordinator(linkName);
        ((ClusterLinkMetadataManager)Mockito.doReturn((Object)Option$.MODULE$.apply((Object)clusterLinkData), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.clusterLinkManager().metadataManager())).getClusterLinkData(linkId);
        ((ClusterLinkMetadataManager)Mockito.doReturn((Object)metadataCache, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.clusterLinkManager().metadataManager())).metadataCache();
        ClusterLinkTopicState mirrorState = (ClusterLinkTopicState)Mockito.mock(ClusterLinkTopicState.class);
        ((ClusterLinkTopicState)Mockito.doReturn((Object)TopicLinkMirror$.MODULE$, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)mirrorState)).state();
        ((ClusterLinkMetadataManager)Mockito.doReturn((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"testTopic"), (Object)mirrorState), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"anotherTopic"), (Object)mirrorState)})), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.clusterLinkManager().metadataManager())).mirrorTopicStatesFromMetadataCache(linkId);
        ((MetadataCache)Mockito.doReturn((Object)MetadataVersion.MINIMUM_BOOTSTRAP_VERSION, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)metadataCache)).metadataVersion();
        this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        Assertions.assertEquals((Object)new .colon.colon((Object)clusterLinkData, (List)Nil$.MODULE$), (Object)this.clusterLinkManager().listClusterLinks());
        ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)this.clusterLinkManager().clientManager(linkId).get();
        scala.collection.immutable.Set expectedTopics = linkCoordinatorEnabled ? (isLinkCoordinator ? (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testTopic", "anotherTopic"})) : Predef$.MODULE$.Set().empty()) : (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testTopic"}));
        TopicPartition tp0 = new TopicPartition("testTopic", 0);
        Partition partition0 = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition0, tp0, (Option<Uuid>)new Some((Object)linkId));
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        Assertions.assertEquals((Object)expectedTopics, (Object)clientManager.getTopics());
        TopicPartition tp1 = new TopicPartition("anotherTopic", 1);
        Partition partition1 = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition1, tp1, (Option<Uuid>)new Some((Object)linkId));
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1}))));
        Assertions.assertEquals((Object)expectedTopics, (Object)clientManager.getTopics());
        TopicPartition tp2 = new TopicPartition("anotherLinkTopic", 0);
        Partition partition2 = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition2, tp2, (Option<Uuid>)new Some((Object)Uuid.randomUuid()));
        Assertions.assertEquals((int)0, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition2}))));
        Assertions.assertEquals((Object)expectedTopics, (Object)clientManager.getTopics());
        this.clusterLinkManager().removePartitionsAndMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Assertions.assertEquals((Object)expectedTopics, (Object)clientManager.getTopics());
        this.clusterLinkManager().removePartitionsAndMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0})));
        if (isLinkCoordinator) {
            Assertions.assertEquals((Object)expectedTopics, (Object)clientManager.getTopics());
            ((ClusterLinkMetadataManager)Mockito.doReturn((Object)Predef$.MODULE$.Map().empty(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.clusterLinkManager().metadataManager())).mirrorTopicStatesFromMetadataCache(linkId);
        }
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)clientManager.getTopics());
    }

    private KafkaConfig createBrokerConfig() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public long getClusterLinkFailedAttempts(ClusterLinkManager clusterLinkManager, Uuid linkId) {
        Option option = clusterLinkManager.linkRetryCandidates().get((Object)linkId);
        if (option instanceof Some) {
            return ((ClusterLinkRetryState)((Some)option).value()).getFailedAttempts();
        }
        if (None$.MODULE$.equals(option)) {
            return 0L;
        }
        throw new MatchError((Object)option);
    }

    private Properties clusterLinkPersistentProps() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        return props;
    }

    private ClusterLinkConfig clusterLinkConfig() {
        return ClusterLinkConfig$.MODULE$.create((java.util.Map)this.clusterLinkPersistentProps(), (Option)None$.MODULE$, true);
    }

    private void setupMock(Partition partition, TopicPartition tp, Option<Uuid> linkId) {
        Mockito.reset((Object[])new Partition[]{partition});
        ((Partition)Mockito.doReturn((Object)tp, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partition)).topicPartition();
        ((Partition)Mockito.doReturn(linkId, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partition)).getClusterLinkId();
        ((Partition)Mockito.doReturn((Object)BoxesRunTime.boxToBoolean((boolean)linkId.nonEmpty()), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partition)).isActiveLinkDestinationLeader();
        ((Partition)Mockito.doReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partition)).getLinkedLeaderEpoch();
        PartitionState partitionState = (PartitionState)Mockito.mock(PartitionState.class);
        ((PartitionState)Mockito.doReturn((Object)linkId.map((Function1 & Serializable)id -> new ClusterLinkState(id, (TopicLinkState)TopicLinkMirror$.MODULE$, null)), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partitionState)).clusterLink();
        ((Partition)Mockito.doReturn((Object)partitionState, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)partition)).partitionState();
    }

    private ClusterLinkManager createClusterLinkManager(KafkaConfig brokerConfig, MetadataSupport metadataSupport) {
        boolean isMultiTenant = ConfluentConfigs.buildMultitenantMetadata((java.util.Map)brokerConfig.values(), (Metrics)this.kafka$server$link$ClusterLinkManagerTest$$metrics()) != null;
        ClusterLinkFactory.LinkManager manager = ClusterLinkFactory$.MODULE$.createLinkManager(brokerConfig, "clusterId", ClusterLinkQuotas$.MODULE$.unboundedClusterLinkQuotas(), this.kafka$server$link$ClusterLinkManagerTest$$metrics(), (Time)this.kafka$server$link$ClusterLinkManagerTest$$time(), isMultiTenant, (Option)None$.MODULE$);
        this.startClusterLinkManager(manager, metadataSupport);
        return (ClusterLinkManager)manager;
    }

    private void startClusterLinkManager(ClusterLinkFactory.LinkManager manager, MetadataSupport metadataSupport) {
        Endpoint brokerEndpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 1234);
        AuthorizerServerInfo serverInfo = (AuthorizerServerInfo)Mockito.mock(AuthorizerServerInfo.class);
        ((AuthorizerServerInfo)Mockito.doReturn((Object)brokerEndpoint, (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)serverInfo)).interBrokerEndpoint();
        ((AuthorizerServerInfo)Mockito.doReturn(Collections.singleton(brokerEndpoint), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)serverInfo)).endpoints();
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        ((SocketServer)Mockito.doReturn((Object)BoxesRunTime.boxToInteger((int)1234), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)socketServer)).boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        manager.initialize(serverInfo, socketServer, (Option)None$.MODULE$, metadataSupport, null, this.replicaManager(), null, (Option)None$.MODULE$, (Option)None$.MODULE$);
        manager.startup(true);
    }

    public void kafka$server$link$ClusterLinkManagerTest$$ensureLockNotAcquiredBeforeInvokingMethod(String methodName) {
        Assertions.assertFalse((boolean)Thread.holdsLock(TestUtils.fieldValue((Object)this.clusterLinkManager(), ClusterLinkManager.class, (String)"lock")), (String)new StringBuilder(53).append("Invalid locking order, `lock` is held while invoking ").append(methodName).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinks$4(ClusterLinkManagerTest $this, Uuid linkId$1) {
        return $this.clusterLinkManager().fetcherManager(linkId$1).isEmpty() && $this.clusterLinkManager().clientManager(linkId$1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinks$5(Uuid linkId$1) {
        return new StringBuilder(38).append("Linked fetcher/client for ").append(linkId$1).append(" not removed").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$2(Properties props) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$3(Properties props) {
        props.put("bootstrap.servers", "localhost:1234");
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$4(Properties props) {
        props.put("bootstrap.servers", "localhost:1234");
        return true;
    }

    private final void verifyConnectionManager$1(ClusterLinkConfig.LinkMode linkMode, ConnectionMode connectionMode, Option remoteConnectionMode, Class expectedClass, boolean reverseEnabled) {
        Properties linkProps = new Properties();
        linkProps.put("bootstrap.servers", "localhost:1234");
        linkProps.put(ClusterLinkConfig$.MODULE$.LinkModeProp(), linkMode.name());
        linkProps.put(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), connectionMode.name());
        remoteConnectionMode.foreach((Function1 & Serializable)mode -> linkProps.put(ClusterLinkConfig$.MODULE$.RemoteLinkConnectionModeProp(), mode.name()));
        linkProps.put(ClusterLinkConfig$.MODULE$.LocalListenerNameProp(), "PLAINTEXT");
        ClusterLinkData linkData = new ClusterLinkData(new StringBuilder(7).append("link-").append(linkMode).append("-").append(connectionMode).append("-").append(remoteConnectionMode).toString(), Uuid.randomUuid(), (Option)new Some((Object)"testClusterId"), (Option)None$.MODULE$, false);
        this.clusterLinkManager().createClusterLink(linkData, ClusterLinkConfig$.MODULE$.create((java.util.Map)linkProps, (Option)None$.MODULE$, true), linkProps);
        ClusterLinkFactory.ConnectionManager connManager = (ClusterLinkFactory.ConnectionManager)this.clusterLinkManager().connectionManager(linkData.linkId()).get();
        Assertions.assertEquals((Object)expectedClass, connManager.getClass());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)reverseEnabled), (Object)BoxesRunTime.boxToBoolean((boolean)((ClusterLinkConnectionManager)connManager).reverseConnectionEnabled()));
    }

    public static final /* synthetic */ boolean $anonfun$createClusterLink$2(Properties props) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testRetryReconfigureRetriableFailureOnLinkRunning$1(ClusterLinkManagerTest $this, LongRef retryCount$1, Uuid linkId$2, long expectedRetryCount$1) {
        retryCount$1.elem = $this.getClusterLinkFailedAttempts($this.clusterLinkManager(), linkId$2);
        return retryCount$1.elem == expectedRetryCount$1;
    }

    public static final /* synthetic */ String $anonfun$testRetryReconfigureRetriableFailureOnLinkRunning$2(LongRef retryCount$1, long expectedRetryCount$1, String message$1) {
        return new StringBuilder(81).append("processing cluster link config retry count ").append(retryCount$1.elem).append(" doesn't match expected value of ").append(expectedRetryCount$1).append(" for ").append(message$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testRetryReconfigureRetriableFailureOnLinkRunning$3(ClusterLinkManagerTest $this, LongRef stateMs$1, String linkName$4) {
        stateMs$1.elem = ((ClusterLinkInfo)$this.clusterLinkManager().clusterLinkInfo(linkName$4).get()).linkStateInfo().stateMs();
        return stateMs$1.elem == $this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds();
    }

    public static final /* synthetic */ String $anonfun$testRetryReconfigureRetriableFailureOnLinkRunning$4(ClusterLinkManagerTest $this, LongRef stateMs$1, String message$1) {
        return new StringBuilder(31).append("expected stateMs is ").append($this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds()).append(", got ").append(stateMs$1.elem).append(" for ").append(message$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void increaseElapsedTimeAndWaitForRetry$1(long expectedRetryCount, String expectedBootstrapServer, String message, long elapsedTimeMs, Uuid linkId$2, String linkName$4) {
        long l;
        long l2;
        this.kafka$server$link$ClusterLinkManagerTest$$time().setCurrentTimeMs(this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds() + elapsedTimeMs);
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((l2 = this.getClusterLinkFailedAttempts(this.clusterLinkManager(), linkId$2)) == expectedRetryCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(81).append("processing cluster link config retry count ").append(l2).append(" doesn't match expected value of ").append(expectedRetryCount).append(" for ").append(message).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!((l = ((ClusterLinkInfo)this.clusterLinkManager().clusterLinkInfo(linkName$4).get()).linkStateInfo().stateMs()) == this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)new StringBuilder(31).append("expected stateMs is ").append(this.kafka$server$link$ClusterLinkManagerTest$$time().milliseconds()).append(", got ").append(l).append(" for ").append(message).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)FailedClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName$4), (String)String.valueOf(message));
        Assertions.assertEquals((Object)ClusterLinkError.UNRESOLVABLE_BOOTSTRAP_ERROR, (Object)((UnavailableLinkReason)((ClusterLinkInfo)this.clusterLinkManager().clusterLinkInfo(linkName$4).get()).linkStateInfo().unavailableLinkReason().get()).clusterLinkError(), (String)String.valueOf(message));
        Option linkConfig = this.clusterLinkManager().linkPropertiesCache().get((Object)linkId$2);
        Assertions.assertTrue((boolean)linkConfig.isDefined(), (String)String.valueOf(message));
        String bootstrapServer = ((Properties)linkConfig.get()).getProperty("bootstrap.servers");
        Assertions.assertEquals((Object)expectedBootstrapServer, (Object)bootstrapServer, (String)String.valueOf(message));
        Assertions.assertTrue((boolean)this.containsMetric("broker-failed-link-count"));
        Assertions.assertTrue((boolean)this.containsMetric("link-failure-retry-attempts-rate"));
        Assertions.assertTrue((boolean)this.containsMetric("link-failure-retry-attempts-total"));
    }

    private static final long increaseElapsedTimeAndWaitForRetry$default$4$1() {
        return ClusterLinkRetryState$.MODULE$.RETRY_BACKOFF_MAX_MS();
    }

    public static final /* synthetic */ boolean $anonfun$testRetryReconfigureRetriableFailureOnLinkRunning$5(ClusterLinkManagerTest $this, Uuid linkId$2) {
        return $this.clusterLinkManager().linkRetryCandidates().get((Object)linkId$2).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testRetryReconfigureRetriableFailureOnLinkRunning$6() {
        return "Cluster link retry candidate not removed";
    }

    public static final /* synthetic */ boolean $anonfun$containsMetric$1(String name$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).name();
            return !(string != null ? !string.equals(name$1) : name$1 != null);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testRetryReconfigureRetriableFailureOnLinkStartup$1(ClusterLinkManagerTest $this, Uuid linkId$3) {
        return $this.clusterLinkManager().linkRetryCandidates().get((Object)linkId$3).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testRetryReconfigureRetriableFailureOnLinkStartup$2() {
        return "Cluster link retry candidate not removed";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteClusterLink$1(ClusterLinkManagerTest $this) {
        return $this.clusterLinkManager().clearMirrorTopics().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDeleteClusterLink$2() {
        return "Cluster link not removed";
    }

    public static final /* synthetic */ void $anonfun$verifyNonBlockingLocalAdmin$4(KafkaFuture x$6) {
    }

    public static final /* synthetic */ void $anonfun$testTemporaryAdminIsClosed$1(KafkaFuture x$7) {
    }

    public static final /* synthetic */ void $anonfun$testNonTemporaryAdminIsNotClosed$1(KafkaFuture x$8) {
    }

    private final void verifyFetchSize$1(FetchResponseSize expectedSize, Properties props$1) {
        this.kafka$server$link$ClusterLinkManagerTest$$brokerConfig().updateCurrentConfig(KafkaConfig$.MODULE$.fromProps(props$1));
        this.clusterLinkManager().updateDynamicFetchSize();
        Assertions.assertEquals((Object)expectedSize, (Object)this.clusterLinkManager().fetchResponseSize(this.clusterLinkConfig()));
    }

    private static final void addFetcherThread$1(IntRef numThreads$1, ClusterLinkFetcherManager fetcherManager$1, ClusterLinkFetcherThread thread$1) {
        ++numThreads$1.elem;
        fetcherManager$1.fetcherThreadMap().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new FetcherTag(0, numThreads$1.elem, (FetcherPool)FetcherPool.Default$.MODULE$)), (Object)thread$1));
    }

    private final void setupZkClient$1(UUID linkId$4, String linkName$5) {
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
        ((KafkaZkClient)Mockito.doReturn((Object)new .colon.colon((Object)linkId$4.toString(), (List)Nil$.MODULE$), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getChildren("/cluster_links");
        ((KafkaZkClient)Mockito.doReturn((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId$4), (Object)new ClusterLinkData(linkName$5, CoreUtils$.MODULE$.toKafkaUUID(linkId$4), (Option)None$.MODULE$, (Option)None$.MODULE$, false))})), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)this.zkClient())).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId$4})));
    }

    private final ClusterLinkManager recreateClusterLinkManager$1(long oldSecretTtl) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        props.put("confluent.password.encoder.old.secret.ttl.ms", Long.toString(oldSecretTtl));
        return this.createClusterLinkManager(KafkaConfig$.MODULE$.fromProps(props), (MetadataSupport)this.zkSupport());
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$1(ClusterLinkManager clm1$1) {
        return clm1$1.scheduledTasks().size() == 1 && BoxesRunTime.unboxToInt((Object)clm1$1.scheduledTasks().apply((Object)"Re-encryptCredentials")) == 1;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$2() {
        return "Retry not scheduled after failure";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$3(ClusterLinkManager clm2$1) {
        return clm2$1.scheduledTasks().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$4() {
        return "Unnecessary retry scheduled";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$5(ClusterLinkManager clm3$1) {
        return clm3$1.scheduledTasks().size() == 1 && BoxesRunTime.unboxToInt((Object)clm3$1.scheduledTasks().apply((Object)"DeleteCredentialsEncryptedUsingOldSecret")) == 1;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$6() {
        return "Old encoder delete not scheduled";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$7(ClusterLinkManager clm4$1) {
        return clm4$1.scheduledTasks().size() == 1 && BoxesRunTime.unboxToInt((Object)clm4$1.scheduledTasks().apply((Object)"DeleteCredentialsEncryptedUsingOldSecret")) == 1;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$8() {
        return "Unnecessary delete retry scheduled";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$9(ClusterLinkManager clm5$1) {
        return clm5$1.scheduledTasks().size() == 1 && BoxesRunTime.unboxToInt((Object)clm5$1.scheduledTasks().apply((Object)"DeleteCredentialsEncryptedUsingOldSecret")) == 2;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$10() {
        return "Delete retry not scheduled";
    }

    public static final /* synthetic */ int $anonfun$verifyLinkScheduler$1(ClusterLinkManager eta$0$1$1, int index) {
        return eta$0$1$1.backgroundThreadUsage(index);
    }

    private final IndexedSeq actualThreadUsage$1() {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).map((Function1)((JFunction1.mcII.sp & Serializable)arg_0 -> ClusterLinkManagerTest.$anonfun$verifyLinkScheduler$1(this.clusterLinkManager(), arg_0)));
    }

    public static final /* synthetic */ int $anonfun$verifyLinkScheduler$2(ClusterLinkManager eta$0$1$2, int index) {
        return eta$0$1$2.backgroundThreadTenants(index);
    }

    private final IndexedSeq actualThreadTenants$1() {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).map((Function1)((JFunction1.mcII.sp & Serializable)arg_0 -> ClusterLinkManagerTest.$anonfun$verifyLinkScheduler$2(this.clusterLinkManager(), arg_0)));
    }

    public static final /* synthetic */ void $anonfun$verifyLinkScheduler$4(ClusterLinkManagerTest $this, ClusterLinkManager.Managers managers$1, Buffer expectedThreadUsage$1, Buffer expectedThreadTenants$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClusterLinkData linkData = (ClusterLinkData)x0$1._1();
            int schedulerIndex = x0$1._2$mcI$sp();
            $this.clusterLinkManager().commitAddClusterLink(linkData, managers$1, ClusterLinkConfig.LinkMode.DESTINATION);
            expectedThreadUsage$1.update(schedulerIndex, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)expectedThreadUsage$1.apply(schedulerIndex)) + 1)));
            Assertions.assertEquals((Object)expectedThreadUsage$1, (Object)$this.actualThreadUsage$1());
            linkData.tenantPrefix().foreach((Function1 & Serializable)tenantPrefix -> (scala.collection.mutable.Set)((Growable)expectedThreadTenants$1.apply(schedulerIndex)).$plus$eq(tenantPrefix));
            Assertions.assertEquals((Object)((IterableOnceOps)expectedThreadTenants$1.map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.size()))).toSeq(), (Object)$this.actualThreadTenants$1());
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkManagerTest() {
        void zkMetadataCache_zkMigrationEnabled;
        void zkMetadataCache_isMultiTenant;
        void zkMetadataCache_kraftControllerNodes;
        void zkMetadataCache_brokerFeatures;
        boolean bl = false;
        boolean bl2 = false;
        Seq seq = (Seq)Seq$.MODULE$.empty();
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        MetadataVersion zkMetadataCache_metadataVersion = this.kafka$server$link$ClusterLinkManagerTest$$brokerConfig().interBrokerProtocolVersion();
        int zkMetadataCache_brokerId = 0;
        Object var2_5 = null;
        brokerFeatures = null;
        seq = null;
        this.metadataCache = new ZkMetadataCache(zkMetadataCache_brokerId, zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures, (Seq)zkMetadataCache_kraftControllerNodes, (boolean)zkMetadataCache_isMultiTenant, (boolean)zkMetadataCache_zkMigrationEnabled);
        this.topicConfigSyncIncludeDefault = CollectionConverters$.MODULE$.ListHasAsScala(ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncIncludeDefault()).asScala().mkString(",");
    }

    public static final /* synthetic */ Object $anonfun$testTemporaryAdminIsClosed$1$adapted(KafkaFuture x$7) {
        ClusterLinkManagerTest.$anonfun$testTemporaryAdminIsClosed$1(x$7);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testNonTemporaryAdminIsNotClosed$1$adapted(KafkaFuture x$8) {
        ClusterLinkManagerTest.$anonfun$testNonTemporaryAdminIsNotClosed$1(x$8);
        return BoxedUnit.UNIT;
    }
}

