/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import kafka.server.link.AbstractClusterLinkMetadataManagerTest;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005!4AAD\b\u0001-!)1\u0004\u0001C\u00019!9a\u0004\u0001b\u0001\n\u0013y\u0002BB\u0016\u0001A\u0003%\u0001\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\t\rU\u0002\u0001\u0015!\u0003/\u0011\u001d1\u0004A1A\u0005\n]BaA\u0010\u0001!\u0002\u0013A\u0004\"B \u0001\t\u0003\u0001\u0005\"B,\u0001\t\u0003A\u0006\"B/\u0001\t\u0003A\u0006\"\u00022\u0001\t\u0003A\u0006\"\u00023\u0001\t\u0003A\u0006\"\u00024\u0001\t\u0003A&AL\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014x+\u001b;i\u0017J\fg\r^*vaB|'\u000f\u001e+fgRT!\u0001E\t\u0002\t1Lgn\u001b\u0006\u0003%M\taa]3sm\u0016\u0014(\"\u0001\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0006\t\u00031ei\u0011aD\u0005\u00035=\u0011a%\u00112tiJ\f7\r^\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014H+Z:u\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u0019\u0001\u0005q!M]8lKJ,e\u000e\u001a9pS:$X#\u0001\u0011\u0011\u0005\u0005JS\"\u0001\u0012\u000b\u0005\r\"\u0013AB2p[6|gN\u0003\u0002\u0015K)\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0013\tQ#E\u0001\u0005F]\u0012\u0004x.\u001b8u\u0003=\u0011'o\\6fe\u0016sG\r]8j]R\u0004\u0013AC:feZ,'/\u00138g_V\ta\u0006\u0005\u00020g5\t\u0001G\u0003\u00022e\u0005Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0005I!\u0013B\u0001\u001b1\u0005Q\tU\u000f\u001e5pe&TXM]*feZ,'/\u00138g_\u0006Y1/\u001a:wKJLeNZ8!\u00035iW\r^1eCR\f7)Y2iKV\t\u0001\b\u0005\u0002:y5\t!H\u0003\u0002<#\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0002>u\t\u00112JU1gi6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00039iW\r^1eCR\f7)Y2iK\u0002\nQa]3u+B$\"!Q$\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0011\"\u0001\r!S\u0001\u0005S:4w\u000e\u0005\u0002K#6\t1J\u0003\u0002M\u001b\u0006\u0019\u0011\r]5\u000b\u00059{\u0015a\u00026va&$XM\u001d\u0006\u0003!\u001e\nQA[;oSRL!AU&\u0003\u0011Q+7\u000f^%oM>D#\u0001\u0003+\u0011\u0005)+\u0016B\u0001,L\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]R\t\u0011\t\u000b\u0002\n5B\u0011!jW\u0005\u00039.\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002oQ,7\u000f^'fi\u0006$\u0017\r^1U_BL7m\u0011:fCRLwN\u001c$bS2,(/Z:XSRDW\t\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u00144gQ\tQq\f\u0005\u0002KA&\u0011\u0011m\u0013\u0002\u0005)\u0016\u001cH/\u0001\u0016uKN$X*\u001a;bI\u0006$\u0018\rV8qS\u000e\u001c%/Z1uS>tw+\u001b;i\r\u0006LG.\u001a3BiR,W\u000e\u001d;)\u0005-y\u0016!\r;fgRlU\r^1eCR\fGk\u001c9jG\u000e\u0013X-\u0019;j_:<\u0016\u000e\u001e5U_BL7-\u0012=jgR\u001cX\t_2faRLwN\u001c\u0015\u0003\u0019}\u000b1\u0005^3tiB\u000b'\u000f^5uS>tW\t\\3di&|g.\u00118e%\u0016\u001c\u0018n\u001a8bi&|g\u000e\u000b\u0002\u000e?\u0002")
public class ClusterLinkMetadataManagerWithKraftSupportTest
extends AbstractClusterLinkMetadataManagerTest {
    private final Endpoint brokerEndpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 1234);
    private final AuthorizerServerInfo serverInfo = (AuthorizerServerInfo)Mockito.mock(AuthorizerServerInfo.class);
    private final KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);

    private Endpoint brokerEndpoint() {
        return this.brokerEndpoint;
    }

    private AuthorizerServerInfo serverInfo() {
        return this.serverInfo;
    }

    private KRaftMetadataCache metadataCache() {
        return this.metadataCache;
    }

    @BeforeEach
    public void setUp(TestInfo info) {
        this.scheduler().startup();
        Mockito.reset((Object[])new Object[]{this.destAdmin(), this.serverInfo(), this.metadataCache()});
        Mockito.when((Object)this.serverInfo().interBrokerEndpoint()).thenReturn((Object)this.brokerEndpoint());
        Mockito.when((Object)this.metadataCache().currentImage()).thenReturn((Object)MetadataImage.EMPTY);
        if (info.getDisplayName().startsWith("testMetadataTopicCreation")) {
            this.metadataManager_$eq((ClusterLinkMetadataManager)new ClusterLinkMetadataManagerWithKRaftSupport(this.brokerConfig(), this.scheduler(), this.metadataCache(), null, (Function0 & Serializable)() -> this.destAdmin(), this.serverInfo()));
            return;
        }
        Mockito.when((Object)this.metadataCache().numPartitions("_confluent-link-metadata")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)50)));
        this.metadataManager_$eq((ClusterLinkMetadataManager)new ClusterLinkMetadataManagerWithKRaftSupport(this.brokerConfig(), this.scheduler(), this.metadataCache(), null, (Function0 & Serializable)() -> this.destAdmin(), this.serverInfo()));
        this.metadataManager().startup();
        this.waitAndCreateMetadataTopic(this.waitAndCreateMetadataTopic$default$1());
    }

    @AfterEach
    public void tearDown() {
        if (this.metadataManager() != null) {
            this.metadataManager().shutdown();
        }
        this.scheduler().shutdown();
        this.metadataManager_$eq(null);
    }

    @Test
    public void testMetadataTopicCreationFailuresWithExponentialBackOff() {
        Mockito.when((Object)this.metadataCache().numPartitions("_confluent-link-metadata")).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)new Some((Object)new TopicAuthorizationException("")))).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)new Some((Object)new TopicAuthorizationException("")))).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)new Some((Object)new TopicAuthorizationException("")))).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)new Some((Object)new TopicAuthorizationException("")))).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)new Some((Object)new TopicAuthorizationException("")))).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)new Some((Object)new TopicAuthorizationException("")))).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)new Some((Object)new TopicAuthorizationException("")))).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)None$.MODULE$));
        Long retryDelayMs = this.brokerConfig().clusterLinkMetadataTopicCreateRetryDelayMs();
        double maxRetryDelayMs = 32000.0;
        double multiplier = 2.0;
        double jitter = 0.2;
        DoubleRef minTotalTimeMs = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 7).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ii -> minTotalTimeMs$1.elem += RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper((double)Predef$.MODULE$.Long2long(retryDelayMs) * package$.MODULE$.pow(multiplier, (double)ii) * (1.0 - jitter)), maxRetryDelayMs));
        long nowMs = System.currentTimeMillis();
        this.metadataManager().startup();
        this.waitAndCreateMetadataTopic((long)(minTotalTimeMs.elem * (double)2));
        long totalDelayMs = System.currentTimeMillis() - nowMs;
        ((KRaftMetadataCache)Mockito.verify((Object)this.metadataCache(), (VerificationMode)Mockito.times((int)8))).numPartitions((String)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)8))).createTopics((Collection)ArgumentMatchers.any());
        Assertions.assertTrue(((double)totalDelayMs >= minTotalTimeMs.elem ? 1 : 0) != 0, (String)new StringBuilder(35).append("Min time needed = ").append(minTotalTimeMs.elem).append(". Elapsed time = ").append(totalDelayMs).toString());
    }

    @Test
    public void testMetadataTopicCreationWithFailedAttempt() {
        Mockito.reset((Object[])new KRaftMetadataCache[]{this.metadataCache()});
        Mockito.when((Object)this.metadataCache().numPartitions("_confluent-link-metadata")).thenReturn((Object)None$.MODULE$);
        Mockito.reset((Object[])new Admin[]{this.destAdmin()});
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)new Some((Object)new TopicAuthorizationException("")))).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)None$.MODULE$));
        this.metadataManager().startup();
        this.waitAndCreateMetadataTopic(this.waitAndCreateMetadataTopic$default$1());
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((KRaftMetadataCache)Mockito.verify((Object)this.metadataCache(), (VerificationMode)Mockito.times((int)2))).numPartitions("_confluent-link-metadata");
    }

    @Test
    public void testMetadataTopicCreationWithTopicExistsException() {
        Mockito.when((Object)this.metadataCache().numPartitions("_confluent-link-metadata")).thenReturn((Object)None$.MODULE$, (Object[])new Option[]{None$.MODULE$, new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(this.brokerConfig().clusterLinkMetadataTopicPartitions())))});
        Mockito.reset((Object[])new Admin[]{this.destAdmin()});
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)new Some((Object)new TopicExistsException(""))));
        this.metadataManager().startup();
        this.waitAndCreateMetadataTopic(this.waitAndCreateMetadataTopic$default$1());
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)1))).createTopics((Collection)ArgumentMatchers.any());
        ((KRaftMetadataCache)Mockito.verify((Object)this.metadataCache(), (VerificationMode)Mockito.times((int)3))).numPartitions("_confluent-link-metadata");
    }

    @Test
    public void testPartitionElectionAndResignation() {
        String clusterLinkName = "testLink";
        int partition = (Utils.murmur2((byte[])clusterLinkName.getBytes()) & Integer.MAX_VALUE) % Predef$.MODULE$.Integer2int(this.brokerConfig().clusterLinkMetadataTopicPartitions());
        this.metadataManager().onElection(partition, 10);
        Assertions.assertTrue((boolean)this.metadataManager().isLinkCoordinator(clusterLinkName), (String)"Broker is not leader for cluster link");
        Assertions.assertFalse((boolean)this.metadataManager().isLinkCoordinator("testLink2"), (String)"Broker is leader for cluster link");
        this.metadataManager().onResignation(partition, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)9)));
        Assertions.assertTrue((boolean)this.metadataManager().isLinkCoordinator(clusterLinkName), (String)"Broker is not leader for cluster link");
        this.metadataManager().onResignation(partition, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)11)));
        Assertions.assertFalse((boolean)this.metadataManager().isLinkCoordinator(clusterLinkName), (String)"Broker is leader for cluster link");
        this.metadataManager().onElection(partition, 9);
        Assertions.assertFalse((boolean)this.metadataManager().isLinkCoordinator(clusterLinkName), (String)"Broker is leader for cluster link");
        this.metadataManager().onElection(partition, 12);
        Assertions.assertTrue((boolean)this.metadataManager().isLinkCoordinator(clusterLinkName), (String)"Broker is not leader for cluster link");
        this.metadataManager().onResignation(partition, (Option)None$.MODULE$);
        Assertions.assertFalse((boolean)this.metadataManager().isLinkCoordinator(clusterLinkName), (String)"Broker is leader for cluster link");
    }
}

