/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.File;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LinkRequestQuotaUsageType;
import kafka.server.link.ClusterLinkClientType;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetadataThread;
import kafka.server.link.ClusterLinkMetadataThread$;
import kafka.server.link.ClusterLinkMetadataThreadTest$;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkOutboundConnectionManager;
import kafka.server.link.ClusterLinkSelectorMetricsRegistry;
import kafka.server.link.CoordinatorListener;
import kafka.server.link.FindCoordinatorResponseResult;
import kafka.server.link.MetadataListener;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DescribeClusterLinksResponseData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DescribeClusterLinksResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0005\tua\u0001B\u0015+\u0001EBQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004J\u0001\u0001\u0006IA\u0010\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u0019!\u0006\u0001)A\u0005\u0019\"9Q\u000b\u0001b\u0001\n\u00131\u0006BB.\u0001A\u0003%q\u000bC\u0004]\u0001\t\u0007I\u0011B/\t\r\u0005\u0004\u0001\u0015!\u0003_\u0011\u001d\u0011\u0007A1A\u0005\n\rDa!\u001b\u0001!\u0002\u0013!\u0007b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007e\u0002\u0001\u000b\u0011\u00027\t\u000fM\u0004!\u0019!C\u0005i\"1\u0001\u0010\u0001Q\u0001\nUDq!\u001f\u0001C\u0002\u0013%!\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011B>\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013%\u0011q\u0001\u0005\f\u0003\u001f\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0002C\u0006\u0002\u001e\u0001\u0001\r\u0011!Q!\n\u0005%\u0001\"CA\u0010\u0001\t\u0007I\u0011BA\u0011\u0011!\tI\u0004\u0001Q\u0001\n\u0005\r\u0002\"CA\u001e\u0001\t\u0007I\u0011BA\u001f\u0011!\t)\u0005\u0001Q\u0001\n\u0005}\u0002bBA$\u0001\u0011%\u0011\u0011\n\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\tI\u0006\u0001C\u0005\u00037Bq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002z\u0001!\t!!\u0019\t\u000f\u0005u\u0004\u0001\"\u0001\u0002b!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\u0005\u0004bBAC\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003\u0013\u0003A\u0011AA1\u0011\u001d\ti\t\u0001C\u0001\u0003CBq!!%\u0001\t\u0003\t\t\u0007C\u0004\u0002\u0016\u0002!\t!!\u0019\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\u001a\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006bBA_\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0005\u0013\u0001A\u0011\u0001B\u0006\u0005u\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b)\"\u0014X-\u00193UKN$(BA\u0016-\u0003\u0011a\u0017N\\6\u000b\u00055r\u0013AB:feZ,'OC\u00010\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\b\u0005\u0002<\u00015\t!&\u0001\u0004mS:\\\u0017\nZ\u000b\u0002}A\u0011qhR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0007G>lWn\u001c8\u000b\u0005=\u001a%B\u0001#F\u0003\u0019\t\u0007/Y2iK*\ta)A\u0002pe\u001eL!\u0001\u0013!\u0003\tU+\u0018\u000eZ\u0001\bY&t7.\u00133!\u0003!a\u0017N\\6OC6,W#\u0001'\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016\u0001\u00027b]\u001eT\u0011!U\u0001\u0005U\u00064\u0018-\u0003\u0002T\u001d\n11\u000b\u001e:j]\u001e\f\u0011\u0002\\5oW:\u000bW.\u001a\u0011\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0016\u0003]\u0003\"\u0001W-\u000e\u00031J!A\u0017\u0017\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000eEJ|7.\u001a:D_:4\u0017n\u001a\u0011\u0002\u00115,G/\u00193bi\u0006,\u0012A\u0018\t\u0003w}K!\u0001\u0019\u0016\u0003'\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1\u0002\u00135,G/\u00193bi\u0006\u0004\u0013aB7fiJL7m]\u000b\u0002IB\u0011QmZ\u0007\u0002M*\u0011!\rQ\u0005\u0003Q\u001a\u0014q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003\u0011!\u0018.\\3\u0016\u00031\u0004\"!\u001c9\u000e\u00039T!a\u001c!\u0002\u000bU$\u0018\u000e\\:\n\u0005Et'\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002/M,G.Z2u_JlU\r\u001e:jGN\u0014VmZ5tiJLX#A;\u0011\u0005m2\u0018BA<+\u0005\t\u001aE.^:uKJd\u0015N\\6TK2,7\r^8s\u001b\u0016$(/[2t%\u0016<\u0017n\u001d;ss\u0006A2/\u001a7fGR|'/T3ue&\u001c7OU3hSN$(/\u001f\u0011\u0002\u00155|7m[\"mS\u0016tG/F\u0001|!\tax0D\u0001~\u0015\tq()A\u0004dY&,g\u000e^:\n\u0007\u0005\u0005QP\u0001\u0006N_\u000e\\7\t\\5f]R\f1\"\\8dW\u000ec\u0017.\u001a8uA\u0005qQ.\u001a;bI\u0006$\u0018\r\u00165sK\u0006$WCAA\u0005!\rY\u00141B\u0005\u0004\u0003\u001bQ#!G\"mkN$XM\u001d'j].lU\r^1eCR\fG\u000b\u001b:fC\u0012\f!#\\3uC\u0012\fG/\u0019+ie\u0016\fGm\u0018\u0013fcR!\u00111CA\r!\r\u0019\u0014QC\u0005\u0004\u0003/!$\u0001B+oSRD\u0011\"a\u0007\u0014\u0003\u0003\u0005\r!!\u0003\u0002\u0007a$\u0013'A\bnKR\fG-\u0019;b)\"\u0014X-\u00193!\u0003%)\u0007p\u00195b]\u001e,'/\u0006\u0002\u0002$A1\u0011QEA\u0018\u0003gi!!a\n\u000b\t\u0005%\u00121F\u0001\u000bG>t7-\u001e:sK:$(bAA\u0017!\u0006!Q\u000f^5m\u0013\u0011\t\t$a\n\u0003\u0013\u0015C8\r[1oO\u0016\u0014\bcA'\u00026%\u0019\u0011q\u0007(\u0003\u000f%sG/Z4fe\u0006QQ\r_2iC:<WM\u001d\u0011\u0002\u0017QLW.\u001a+p'2,W\r]\u000b\u0003\u0003\u007f\u00012aMA!\u0013\r\t\u0019\u0005\u000e\u0002\u0004\u0013:$\u0018\u0001\u0004;j[\u0016$vn\u00157fKB\u0004\u0013AD3yG\"\fgnZ3FqB,7\r\u001e\u000b\u0007\u0003'\tY%a\u0014\t\u000f\u00055\u0013\u00041\u0001\u00024\u0005)a/\u00197vK\"9\u0011\u0011K\rA\u0002\u0005M\u0012AB3ya\u0016\u001cG/\u0001\u0006uKN$hj\u001c;jMf$B!a\u0005\u0002X!9\u0011Q\n\u000eA\u0002\u0005M\u0012\u0001\u0003;fgR<\u0016-\u001b;\u0015\t\u0005M\u0011Q\f\u0005\b\u0003\u001bZ\u0002\u0019AA\u001a\u0003I!Xm\u001d;NKR\fG-\u0019;b)\"\u0014X-\u00193\u0015\u0005\u0005M\u0001f\u0001\u000f\u0002fA!\u0011qMA;\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014aA1qS*!\u0011qNA9\u0003\u001dQW\u000f]5uKJT1!a\u001dF\u0003\u0015QWO\\5u\u0013\u0011\t9(!\u001b\u0003\tQ+7\u000f^\u0001&i\u0016\u001cH/T3uC\u0012\fG/\u0019+ie\u0016\fG-V:fg\u001aKg\u000eZ\"p_J$\u0017N\\1u_JD3!HA3\u0003\r#Xm\u001d;NKR\fG-\u0019;b)\"\u0014X-\u00193Vg\u0016\u001cH)Z:de&\u0014Wm\u00117vgR,'\u000fT5oWN\fe\r^3s\r&tGmQ8pe\u0012Lg.\u0019;pe\u001a\u000b\u0017\u000e\\:)\u0007y\t)'\u0001\u0015uKN$\b*\u00198eY\u00164\u0015N\u001c3D_>\u0014H-\u001b8bi>\u0014(+Z:q_:\u001cXmU;dG\u0016\u001c8\u000fK\u0002 \u0003K\n\u0011\t^3ti\"\u000bg\u000e\u001a7f\r&tGmQ8pe\u0012Lg.\u0019;peJ+7\u000f]8og\u0016\u001c\u0006n\\;mI:{GOU3uef$U/\u001a+p)>\u0004H*\u001a<fY\u0016\u0013(o\u001c:)\u0007\u0001\n)'A%uKN$\b*\u00198eY\u00164\u0015N\u001c3D_>\u0014H-\u001b8bi>\u0014(+Z:q_:\u001cXm\u00155pk2$gj\u001c;SKR\u0014\u0018\u0010R;f)>\u001cun\u001c:eS:\fGo\u001c:MKZ,G.\u0012:s_JD3!IA3\u0003)#Xm\u001d;IC:$G.\u001a$j]\u0012\u001cun\u001c:eS:\fGo\u001c:SKN\u0004xN\\:f'\"|W\u000f\u001c3O_R\u0014V\r\u001e:z\tV,Gk\u001c(p\u0007>|'\u000fZ5oCR|'o\u001d*fiV\u0014h.\u001a3)\u0007\t\n)'\u0001*uKN$\b*\u00198eY\u00164\u0015N\u001c3D_>\u0014H-\u001b8bi>\u0014(+Z:q_:\u001cXm\u00155pk2$gj\u001c;SKR\u0014\u0018\u0010R;f)>tUmZ1uSZ,wJ\\3D_>\u0014H-\u001b8bi>\u0014(+\u001a;ve:,G\rK\u0002$\u0003K\nA\u0006^3ti\"\u000bg\u000e\u001a7f\r&tGmQ8pe\u0012Lg.\u0019;peJ+7\u000f]8og\u0016\u001c\u0006n\\;mIJ+GO]=)\u0007\u0011\n)\u0007\u0006\u0005\u0002\n\u0005m\u0015QUAX\u0011\u001d\ti*\na\u0001\u0003?\u000b\u0011c\u00197vgR,'\u000fT5oW\u000e{gNZ5h!\rY\u0014\u0011U\u0005\u0004\u0003GS#!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\"9\u0011qU\u0013A\u0002\u0005%\u0016aC2p]:l\u0015M\\1hKJ\u00042aOAV\u0013\r\tiK\u000b\u0002%\u00072,8\u000f^3s\u0019&t7nT;uE>,h\u000eZ\"p]:,7\r^5p]6\u000bg.Y4fe\"9\u0011\u0011W\u0013A\u0002\u0005M\u0016!B9v_R\f\u0007c\u0001-\u00026&\u0019\u0011q\u0017\u0017\u0003/\rcWo\u001d;fe2Kgn\u001b*fcV,7\u000f^)v_R\f\u0017a\u00048paJ+\u0017/^3tiF+x\u000e^1\u0016\u0005\u0005M\u0016A\b9sKB\f'/\u001a$j]\u0012\u001cun\u001c:eS:\fGo\u001c:SKN\u0004xN\\:f))\t\t-!4\u0002^\u0006\u0005\u0018\u0011 \t\u0005\u0003\u0007\fI-\u0004\u0002\u0002F*\u0019\u0011q\u0019!\u0002\u0011I,\u0017/^3tiNLA!a3\u0002F\n9b)\u001b8e\u0007>|'\u000fZ5oCR|'OU3ta>t7/\u001a\u0005\b\u0003\u001f<\u0003\u0019AAi\u00035!x\u000e\u001d'fm\u0016dWI\u001d:peB!\u00111[Am\u001b\t\t)NC\u0002\u0002X\u0002\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u00037\f)N\u0001\u0004FeJ|'o\u001d\u0005\b\u0003?<\u0003\u0019AAi\u0003Qa\u0017N\\6D_>\u0014H-\u001b8bi>\u0014XI\u001d:pe\"9\u00111]\u0014A\u0002\u0005\u0015\u0018aA6fsB!\u0011q]A{\u001d\u0011\tI/!=\u0011\u0007\u0005-H'\u0004\u0002\u0002n*\u0019\u0011q\u001e\u0019\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019\u0010N\u0001\u0007!J,G-\u001a4\n\u0007M\u000b9PC\u0002\u0002tRBq!a?(\u0001\u0004\ti0A\u0004o_\u0012,w\n\u001d;\u0011\u000bM\nyPa\u0001\n\u0007\t\u0005AG\u0001\u0004PaRLwN\u001c\t\u0004\u007f\t\u0015\u0011b\u0001B\u0004\u0001\n!aj\u001c3f\u0003\r\u0002(/\u001a9be\u0016$Um]2sS\n,7\t\\;ti\u0016\u0014H*\u001b8lgJ+7\u000f]8og\u0016$\u0002B!\u0004\u0003\u0014\t]!\u0011\u0004\t\u0005\u0003\u0007\u0014y!\u0003\u0003\u0003\u0012\u0005\u0015'\u0001\b#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:MS:\\7OU3ta>t7/\u001a\u0005\b\u0005+A\u0003\u0019AAi\u0003\u0015)'O]8s\u0011\u0019Q\u0005\u00061\u0001\u0002f\"9!1\u0004\u0015A\u0002\t\r\u0011\u0001\u00028pI\u0016\u0004")
public class ClusterLinkMetadataThreadTest {
    private final Uuid linkId = Uuid.randomUuid();
    private final String linkName;
    private final KafkaConfig kafka$server$link$ClusterLinkMetadataThreadTest$$brokerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
    private final ClusterLinkMetadata kafka$server$link$ClusterLinkMetadataThreadTest$$metadata = new ClusterLinkMetadata(this.kafka$server$link$ClusterLinkMetadataThreadTest$$brokerConfig(), this.linkName(), this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, 100L, 60000L);
    private final Metrics kafka$server$link$ClusterLinkMetadataThreadTest$$metrics = new Metrics();
    private final MockTime kafka$server$link$ClusterLinkMetadataThreadTest$$time = new MockTime();
    private final ClusterLinkSelectorMetricsRegistry kafka$server$link$ClusterLinkMetadataThreadTest$$selectorMetricsRegistry = new ClusterLinkSelectorMetricsRegistry(this.kafka$server$link$ClusterLinkMetadataThreadTest$$brokerConfig(), this.kafka$server$link$ClusterLinkMetadataThreadTest$$metrics(), (Time)this.kafka$server$link$ClusterLinkMetadataThreadTest$$time());
    private final MockClient kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient = new MockClient((Time)this.kafka$server$link$ClusterLinkMetadataThreadTest$$time(), (Metadata)this.kafka$server$link$ClusterLinkMetadataThreadTest$$metadata());
    private ClusterLinkMetadataThread metadataThread;
    private final Exchanger<Integer> exchanger = new Exchanger();
    private final int kafka$server$link$ClusterLinkMetadataThreadTest$$timeToSleep;

    private Uuid linkId() {
        return this.linkId;
    }

    private String linkName() {
        return this.linkName;
    }

    public KafkaConfig kafka$server$link$ClusterLinkMetadataThreadTest$$brokerConfig() {
        return this.kafka$server$link$ClusterLinkMetadataThreadTest$$brokerConfig;
    }

    public ClusterLinkMetadata kafka$server$link$ClusterLinkMetadataThreadTest$$metadata() {
        return this.kafka$server$link$ClusterLinkMetadataThreadTest$$metadata;
    }

    public Metrics kafka$server$link$ClusterLinkMetadataThreadTest$$metrics() {
        return this.kafka$server$link$ClusterLinkMetadataThreadTest$$metrics;
    }

    public MockTime kafka$server$link$ClusterLinkMetadataThreadTest$$time() {
        return this.kafka$server$link$ClusterLinkMetadataThreadTest$$time;
    }

    public ClusterLinkSelectorMetricsRegistry kafka$server$link$ClusterLinkMetadataThreadTest$$selectorMetricsRegistry() {
        return this.kafka$server$link$ClusterLinkMetadataThreadTest$$selectorMetricsRegistry;
    }

    public MockClient kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient() {
        return this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient;
    }

    private ClusterLinkMetadataThread metadataThread() {
        return this.metadataThread;
    }

    private void metadataThread_$eq(ClusterLinkMetadataThread x$1) {
        this.metadataThread = x$1;
    }

    private Exchanger<Integer> exchanger() {
        return this.exchanger;
    }

    public int kafka$server$link$ClusterLinkMetadataThreadTest$$timeToSleep() {
        return this.kafka$server$link$ClusterLinkMetadataThreadTest$$timeToSleep;
    }

    private void exchangeExpect(Integer value, Integer expect) {
        Assertions.assertEquals((Integer)expect, (Integer)this.exchanger().exchange(value, 1L, TimeUnit.SECONDS));
    }

    public void kafka$server$link$ClusterLinkMetadataThreadTest$$testNotify(Integer value) {
        this.exchangeExpect(value, null);
    }

    private void testWait(Integer value) {
        this.exchangeExpect(null, value);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetadataThread() {
        void metadataUpdateWith_topicPartitionCounts;
        void metadataUpdateWith_topicPartitionCounts2;
        void metadataUpdateWith_topicPartitionCounts3;
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        ClusterLinkConfig clusterLinkConfig = ClusterLinkConfig$.MODULE$.create((java.util.Map)props, (Option)None$.MODULE$, true);
        ClusterLinkOutboundConnectionManager connManager = (ClusterLinkOutboundConnectionManager)Mockito.mock(ClusterLinkOutboundConnectionManager.class);
        this.metadataThread_$eq(this.metadataThread(clusterLinkConfig, connManager, new ClusterLinkRequestQuota(this){
            private final /* synthetic */ ClusterLinkMetadataThreadTest $outer;

            public void record(long nanos, LinkRequestQuotaUsageType usageType) {
                Assertions.assertEquals((Object)LinkRequestQuotaUsageType.Metadata$.MODULE$, (Object)usageType);
                Assertions.assertEquals((long)TimeUnit.MILLISECONDS.toNanos(this.$outer.kafka$server$link$ClusterLinkMetadataThreadTest$$timeToSleep()), (long)nanos);
            }

            public boolean isQuotaExceeded() {
                return true;
            }

            public int getThrottleTimeMs(long value) {
                return 0;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        java.util.Map map = Collections.emptyMap();
        int metadataUpdateWith_numNodes = 1;
        map = null;
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient().updateMetadata(RequestTestUtils.metadataUpdateWith((String)"kafka-cluster", (int)metadataUpdateWith_numNodes, (java.util.Map)metadataUpdateWith_topicPartitionCounts3));
        Assertions.assertTrue((boolean)this.metadataThread().isRunning());
        VolatileObjectRef cluster = VolatileObjectRef.create(null);
        AtomicInteger updateCount = new AtomicInteger();
        MetadataListener metadataListener = new MetadataListener(this, cluster, updateCount){
            private final /* synthetic */ ClusterLinkMetadataThreadTest $outer;
            private final VolatileObjectRef cluster$1;
            private final AtomicInteger updateCount$1;

            public void onMetadataFailure(Exception e) {
                MetadataListener.onMetadataFailure$((MetadataListener)this, (Exception)e);
            }

            public void onNewMetadata(Cluster newCluster) {
                this.cluster$1.elem = newCluster;
                this.updateCount$1.incrementAndGet();
                this.$outer.kafka$server$link$ClusterLinkMetadataThreadTest$$testNotify(Predef$.MODULE$.int2Integer(this.updateCount$1.get()));
                this.$outer.kafka$server$link$ClusterLinkMetadataThreadTest$$time().sleep((long)this.$outer.kafka$server$link$ClusterLinkMetadataThreadTest$$timeToSleep());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cluster$1 = cluster$1;
                this.updateCount$1 = updateCount$1;
            }
        };
        this.metadataThread().addListener(metadataListener);
        this.metadataThread().start();
        Assertions.assertEquals((int)0, (int)updateCount.get());
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$metadata().requestUpdate();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkMetadataThreadTest.$anonfun$testMetadataThread$1(updateCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Metadata listener not invoked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)updateCount.get());
        Assertions.assertEquals(Collections.emptySet(), (Object)((Cluster)cluster.elem).topics());
        java.util.Map<String, Integer> map2 = Collections.singletonMap("testTopic", Predef$.MODULE$.int2Integer(2));
        int metadataUpdateWith_numNodes2 = 1;
        map2 = null;
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith((String)"kafka-cluster", (int)metadataUpdateWith_numNodes2, (java.util.Map)metadataUpdateWith_topicPartitionCounts2);
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient().prepareMetadataUpdate(metadataResponse);
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$metadata().setTopics((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testTopic"})));
        this.testWait(Predef$.MODULE$.int2Integer(1));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkMetadataThreadTest.$anonfun$testMetadataThread$3(updateCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"ClusterLinkMetadataThreadTest listener not invoked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)2, (int)updateCount.get());
        Assertions.assertEquals(Collections.singleton("testTopic"), (Object)((Cluster)cluster.elem).topics());
        Assertions.assertEquals((int)2, (Integer)((Cluster)cluster.elem).partitionCountForTopic("testTopic"));
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient().prepareMetadataUpdate(metadataResponse);
        this.testWait(Predef$.MODULE$.int2Integer(2));
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$metadata().requestUpdate();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkMetadataThreadTest.$anonfun$testMetadataThread$5(updateCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Metadata listener not invoked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)3, (int)updateCount.get());
        java.util.Map<String, Integer> map3 = Collections.singletonMap("testTopic2", Predef$.MODULE$.int2Integer(3));
        int metadataUpdateWith_numNodes3 = 1;
        map3 = null;
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient().prepareMetadataUpdate(RequestTestUtils.metadataUpdateWith((String)"kafka-cluster", (int)metadataUpdateWith_numNodes3, (java.util.Map)metadataUpdateWith_topicPartitionCounts));
        this.testWait(Predef$.MODULE$.int2Integer(3));
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$metadata().setTopics((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testTopic2"})));
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ClusterLinkMetadataThreadTest.$anonfun$testMetadataThread$7(updateCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Metadata listener not invoked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)4, (int)updateCount.get());
        Assertions.assertEquals(Collections.singleton("testTopic2"), (Object)((Cluster)cluster.elem).topics());
        Assertions.assertEquals((int)3, (Integer)((Cluster)cluster.elem).partitionCountForTopic("testTopic2"));
        this.testWait(Predef$.MODULE$.int2Integer(4));
        this.metadataThread().shutdown();
        Assertions.assertFalse((boolean)this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient().active());
        this.metadataThread().shutdown();
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$metadata().close();
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetadataThreadUsesFindCoordinator() {
        void metadataUpdateWith_topicPartitionCounts;
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        ClusterLinkConfig clusterLinkConfig = ClusterLinkConfig$.MODULE$.create((java.util.Map)props, (Option)None$.MODULE$, true);
        ClusterLinkOutboundConnectionManager connManager = (ClusterLinkOutboundConnectionManager)Mockito.mock(ClusterLinkOutboundConnectionManager.class);
        this.metadataThread_$eq(this.metadataThread(clusterLinkConfig, connManager, this.nopRequestQuota()));
        java.util.Map map = Collections.emptyMap();
        int metadataUpdateWith_numNodes = 1;
        map = null;
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient().updateMetadata(RequestTestUtils.metadataUpdateWith((String)"kafka-cluster", (int)metadataUpdateWith_numNodes, (java.util.Map)metadataUpdateWith_topicPartitionCounts));
        Assertions.assertTrue((boolean)this.metadataThread().isRunning());
        VolatileObjectRef linkCoordinator = VolatileObjectRef.create(null);
        CoordinatorListener coordinatorListener = new CoordinatorListener(null, linkCoordinator){
            private final VolatileObjectRef linkCoordinator$1;

            public void onNewRemoteLinkCoordinator(Node coordinator) {
                this.linkCoordinator$1.elem = coordinator;
            }
            {
                this.linkCoordinator$1 = linkCoordinator$1;
            }
        };
        this.metadataThread().addCoordinatorListener(coordinatorListener);
        Node node = new Node(1, "linkCoordinator", 9092);
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient().prepareResponse((AbstractResponse)this.prepareFindCoordinatorResponse(Errors.NONE, Errors.NONE, this.linkName(), (Option<Node>)new Some((Object)node)));
        this.metadataThread().start();
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$metadata().requestUpdate();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((Node)linkCoordinator.elem != null && ((Node)linkCoordinator.elem).equals((Object)node))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to set link coordinator");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.metadataThread().shutdown();
        Assertions.assertFalse((boolean)this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient().active());
        this.metadataThread().shutdown();
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$metadata().close();
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetadataThreadUsesDescribeClusterLinksAfterFindCoordinatorFails() {
        void metadataUpdateWith_topicPartitionCounts;
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        ClusterLinkConfig clusterLinkConfig = ClusterLinkConfig$.MODULE$.create((java.util.Map)props, (Option)None$.MODULE$, true);
        ClusterLinkOutboundConnectionManager connManager = (ClusterLinkOutboundConnectionManager)Mockito.mock(ClusterLinkOutboundConnectionManager.class);
        this.metadataThread_$eq(this.metadataThread(clusterLinkConfig, connManager, this.nopRequestQuota()));
        java.util.Map map = Collections.emptyMap();
        int metadataUpdateWith_numNodes = 1;
        map = null;
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient().updateMetadata(RequestTestUtils.metadataUpdateWith((String)"kafka-cluster", (int)metadataUpdateWith_numNodes, (java.util.Map)metadataUpdateWith_topicPartitionCounts));
        Assertions.assertTrue((boolean)this.metadataThread().isRunning());
        VolatileObjectRef linkCoordinator = VolatileObjectRef.create(null);
        CoordinatorListener coordinatorListener = new CoordinatorListener(null, linkCoordinator){
            private final VolatileObjectRef linkCoordinator$2;

            public void onNewRemoteLinkCoordinator(Node coordinator) {
                this.linkCoordinator$2.elem = coordinator;
            }
            {
                this.linkCoordinator$2 = linkCoordinator$2;
            }
        };
        this.metadataThread().addCoordinatorListener(coordinatorListener);
        Node node = new Node(1, "linkCoordinator", 9092);
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient().prepareResponse((AbstractResponse)this.prepareFindCoordinatorResponse(Errors.NONE, Errors.INVALID_REQUEST, this.linkName(), (Option<Node>)new Some((Object)node)));
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient().prepareResponse((AbstractResponse)this.prepareFindCoordinatorResponse(Errors.NONE, Errors.INVALID_REQUEST, this.linkName(), (Option<Node>)new Some((Object)node)));
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient().prepareResponse((AbstractResponse)this.prepareDescribeClusterLinksResponse(Errors.NONE, this.linkName(), node));
        this.metadataThread().start();
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$metadata().requestUpdate();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((Node)linkCoordinator.elem != null && ((Node)linkCoordinator.elem).equals((Object)node))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to set link coordinator");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.metadataThread().shutdown();
        Assertions.assertFalse((boolean)this.kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient().active());
        this.metadataThread().shutdown();
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$metadata().close();
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$metrics().close();
    }

    @Test
    public void testHandleFindCoordinatorResponseSuccess() {
        Node node = new Node(1, "linkCoordinator", 9092);
        FindCoordinatorResponseResult response = ClusterLinkMetadataThread$.MODULE$.handleFindCoordinatorResponse(this.linkName(), (Logging)Mockito.mock(Logging.class), this.prepareFindCoordinatorResponse(Errors.NONE, Errors.NONE, this.linkName(), (Option<Node>)new Some((Object)node)).data());
        Assertions.assertEquals((Object)new Some((Object)node), (Object)response.coordinator());
        Assertions.assertFalse((boolean)response.retry());
    }

    @Test
    public void testHandleFindCoordinatorResponseShouldNotRetryDueToTopLevelError() {
        Node node = new Node(1, "linkCoordinator", 9092);
        FindCoordinatorResponseResult response = ClusterLinkMetadataThread$.MODULE$.handleFindCoordinatorResponse(this.linkName(), (Logging)Mockito.mock(Logging.class), this.prepareFindCoordinatorResponse(Errors.UNKNOWN_SERVER_ERROR, Errors.NONE, this.linkName(), (Option<Node>)new Some((Object)node)).data());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)response.coordinator());
        Assertions.assertFalse((boolean)response.retry());
    }

    @Test
    public void testHandleFindCoordinatorResponseShouldNotRetryDueToCoordinatorLevelError() {
        Node node = new Node(1, "linkCoordinator", 9092);
        FindCoordinatorResponseResult response = ClusterLinkMetadataThread$.MODULE$.handleFindCoordinatorResponse(this.linkName(), (Logging)Mockito.mock(Logging.class), this.prepareFindCoordinatorResponse(Errors.NONE, Errors.UNKNOWN_SERVER_ERROR, this.linkName(), (Option<Node>)new Some((Object)node)).data());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)response.coordinator());
        Assertions.assertFalse((boolean)response.retry());
    }

    @Test
    public void testHandleFindCoordinatorResponseShouldNotRetryDueToNoCoordinatorsReturned() {
        FindCoordinatorResponseResult response = ClusterLinkMetadataThread$.MODULE$.handleFindCoordinatorResponse(this.linkName(), (Logging)Mockito.mock(Logging.class), this.prepareFindCoordinatorResponse(Errors.NONE, Errors.NONE, this.linkName(), (Option<Node>)None$.MODULE$).data());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)response.coordinator());
        Assertions.assertFalse((boolean)response.retry());
    }

    @Test
    public void testHandleFindCoordinatorResponseShouldNotRetryDueToNegativeOneCoordinatorReturned() {
        Node node = Node.noNode();
        FindCoordinatorResponseResult response = ClusterLinkMetadataThread$.MODULE$.handleFindCoordinatorResponse(this.linkName(), (Logging)Mockito.mock(Logging.class), this.prepareFindCoordinatorResponse(Errors.NONE, Errors.NONE, this.linkName(), (Option<Node>)new Some((Object)node)).data());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)response.coordinator());
        Assertions.assertFalse((boolean)response.retry());
    }

    @Test
    public void testHandleFindCoordinatorResponseShouldRetry() {
        Node node = new Node(1, "linkCoordinator", 9092);
        FindCoordinatorResponseResult response = ClusterLinkMetadataThread$.MODULE$.handleFindCoordinatorResponse(this.linkName(), (Logging)Mockito.mock(Logging.class), this.prepareFindCoordinatorResponse(Errors.NONE, Errors.INVALID_REQUEST, this.linkName(), (Option<Node>)new Some((Object)node)).data());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)response.coordinator());
        Assertions.assertTrue((boolean)response.retry());
    }

    public ClusterLinkMetadataThread metadataThread(ClusterLinkConfig clusterLinkConfig, ClusterLinkOutboundConnectionManager connManager, ClusterLinkRequestQuota quota) {
        return new ClusterLinkMetadataThread(this, clusterLinkConfig, connManager, quota){
            private final /* synthetic */ ClusterLinkMetadataThreadTest $outer;

            public ClusterLinkNetworkClient createNetworkClient(ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata) {
                return new ClusterLinkNetworkClient(this, clusterLinkConfig, clusterLinkMetadata){
                    private final /* synthetic */ $anon$5 $outer;

                    public KafkaClient createNetworkClient(Selector selector) {
                        return this.$outer.kafka$server$link$ClusterLinkMetadataThreadTest$$anon$$$outer().kafka$server$link$ClusterLinkMetadataThreadTest$$mockClient();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.kafka$server$link$ClusterLinkMetadataThreadTest$$anon$$$outer().kafka$server$link$ClusterLinkMetadataThreadTest$$brokerConfig(), clusterLinkConfig$2, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(clusterLinkMetadata$1.linkName()), (Option)new Some((Object)$outer.kafka$server$link$ClusterLinkMetadataThreadTest$$anon$$$outer().kafka$server$link$ClusterLinkMetadataThreadTest$$metadata()), (Option)None$.MODULE$, $outer.kafka$server$link$ClusterLinkMetadataThreadTest$$anon$$$outer().kafka$server$link$ClusterLinkMetadataThreadTest$$metrics(), $outer.kafka$server$link$ClusterLinkMetadataThreadTest$$anon$$$outer().kafka$server$link$ClusterLinkMetadataThreadTest$$selectorMetricsRegistry(), (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link-name"), (Object)clusterLinkMetadata$1.linkName())})), (Time)$outer.kafka$server$link$ClusterLinkMetadataThreadTest$$anon$$$outer().kafka$server$link$ClusterLinkMetadataThreadTest$$time(), new StringBuilder(29).append("cluster-link-metadata-").append(clusterLinkMetadata$1.linkName()).append("-broker").toString(), (ClusterLinkClientType)ClusterLinkClientType.Metadata$.MODULE$, new LogContext(), null);
                    }
                };
            }

            public /* synthetic */ ClusterLinkMetadataThreadTest kafka$server$link$ClusterLinkMetadataThreadTest$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$server$link$ClusterLinkMetadataThreadTest$$brokerConfig(), clusterLinkConfig$1, (Option)new Some((Object)connManager$1), $outer.kafka$server$link$ClusterLinkMetadataThreadTest$$metadata(), $outer.kafka$server$link$ClusterLinkMetadataThreadTest$$metrics(), $outer.kafka$server$link$ClusterLinkMetadataThreadTest$$selectorMetricsRegistry(), (ClusterLinkClientType)ClusterLinkClientType.Metadata$.MODULE$, quota$1, (Time)$outer.kafka$server$link$ClusterLinkMetadataThreadTest$$time());
            }
        };
    }

    public ClusterLinkRequestQuota nopRequestQuota() {
        return new ClusterLinkRequestQuota(null){

            public void record(long nanos, LinkRequestQuotaUsageType usageType) {
            }

            public boolean isQuotaExceeded() {
                return true;
            }

            public int getThrottleTimeMs(long value) {
                return 0;
            }
        };
    }

    public FindCoordinatorResponse prepareFindCoordinatorResponse(Errors topLevelError, Errors linkCoordinatorError, String key, Option<Node> nodeOpt) {
        FindCoordinatorResponseData data = new FindCoordinatorResponseData();
        data.setErrorCode(topLevelError.code());
        if (nodeOpt.isDefined()) {
            Node node = (Node)nodeOpt.get();
            data.setCoordinators(Collections.singletonList(new FindCoordinatorResponseData.Coordinator().setErrorCode(linkCoordinatorError.code()).setErrorMessage(linkCoordinatorError.message()).setKey(key).setHost(node.host()).setPort(node.port()).setNodeId(node.id())));
        }
        return new FindCoordinatorResponse(data);
    }

    public DescribeClusterLinksResponse prepareDescribeClusterLinksResponse(Errors error, String linkName, Node node) {
        DescribeClusterLinksResponseData.EntryData entryData = new DescribeClusterLinksResponseData.EntryData().setLinkName(linkName).setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1").setTopics(Collections.emptyList()).setLinkCoordinatorId(node.id()).setLinkCoordinatorHost(node.host()).setLinkCoordinatorPort(node.port());
        DescribeClusterLinksResponseData responseData = new DescribeClusterLinksResponseData().setEntries(Collections.singletonList(entryData)).setThrottleTimeMs(0);
        return new DescribeClusterLinksResponse(responseData);
    }

    private final ClusterLinkRequestQuota getRequestQuota$1() {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataThread$1(AtomicInteger updateCount$1) {
        return updateCount$1.get() > 0;
    }

    public static final /* synthetic */ String $anonfun$testMetadataThread$2() {
        return "Metadata listener not invoked";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataThread$3(AtomicInteger updateCount$1) {
        return updateCount$1.get() > 1;
    }

    public static final /* synthetic */ String $anonfun$testMetadataThread$4() {
        return "ClusterLinkMetadataThreadTest listener not invoked";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataThread$5(AtomicInteger updateCount$1) {
        return updateCount$1.get() > 2;
    }

    public static final /* synthetic */ String $anonfun$testMetadataThread$6() {
        return "Metadata listener not invoked";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataThread$7(AtomicInteger updateCount$1) {
        return updateCount$1.get() > 3;
    }

    public static final /* synthetic */ String $anonfun$testMetadataThread$8() {
        return "Metadata listener not invoked";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataThreadUsesFindCoordinator$1(VolatileObjectRef linkCoordinator$1, Node node$1) {
        return (Node)linkCoordinator$1.elem != null && ((Node)linkCoordinator$1.elem).equals((Object)node$1);
    }

    public static final /* synthetic */ String $anonfun$testMetadataThreadUsesFindCoordinator$2() {
        return "Failed to set link coordinator";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataThreadUsesDescribeClusterLinksAfterFindCoordinatorFails$1(VolatileObjectRef linkCoordinator$2, Node node$2) {
        return (Node)linkCoordinator$2.elem != null && ((Node)linkCoordinator$2.elem).equals((Object)node$2);
    }

    public static final /* synthetic */ String $anonfun$testMetadataThreadUsesDescribeClusterLinksAfterFindCoordinatorFails$2() {
        return "Failed to set link coordinator";
    }

    public ClusterLinkMetadataThreadTest() {
        this.linkName = "testLink";
        this.kafka$server$link$ClusterLinkMetadataThreadTest$$timeToSleep = 5;
    }
}

