/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.ClusterLinkBrokerMetrics;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkOutboundConnectionManager;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ConnectionMode;
import kafka.server.link.LinkType;
import kafka.server.link.LinkType$;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkPendingMirror$;
import kafka.server.link.TopicLinkPendingRepairMirror$;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkPendingSynchronizeMirror$;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001\u0002\u0012$\u0001)BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013%a\u0007\u0003\u0004@\u0001\u0001\u0006Ia\u000e\u0005\b\u0001\u0002\u0011\r\u0011\"\u00037\u0011\u0019\t\u0005\u0001)A\u0005o!9!\t\u0001b\u0001\n\u0013\u0019\u0005B\u0002*\u0001A\u0003%A\tC\u0004T\u0001\t\u0007I\u0011\u0002+\t\r\u0001\u0004\u0001\u0015!\u0003V\u0011\u001d\t\u0007A1A\u0005\n\tDaA\u001b\u0001!\u0002\u0013\u0019\u0007bB6\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007c\u0002\u0001\u000b\u0011B7\t\u000fI\u0004!\u0019!C\u0005g\"9\u00111\u0001\u0001!\u0002\u0013!\b\"CA\u0003\u0001\t\u0007I\u0011BA\u0004\u0011!\tY\u0003\u0001Q\u0001\n\u0005%\u0001\"CA\u0017\u0001\t\u0007I\u0011BA\u0018\u0011!\tY\u0004\u0001Q\u0001\n\u0005E\u0002\"CA\u001f\u0001\t\u0007I\u0011BA \u0011!\t9\u0005\u0001Q\u0001\n\u0005\u0005\u0003\"CA%\u0001\t\u0007I\u0011BA&\u0011!\t\u0019\u0006\u0001Q\u0001\n\u00055\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0003k\u0002A\u0011AA<\u0011\u001d\t\t\u000b\u0001C\u0001\u0003GCq!!,\u0001\t\u0003\ty\u000bC\u0004\u0002:\u0002!\t!a/\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002X!9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0007bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005\u0013\u0001A\u0011BA,\u0011\u001d\u0011Y\u0001\u0001C\u0005\u0005\u001b\u0011ac\u00117vgR,'\u000fT5oW6+GO]5dgR+7\u000f\u001e\u0006\u0003I\u0015\nA\u0001\\5oW*\u0011aeJ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003!\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001a\u0011\u0005Q\u0002Q\"A\u0012\u0002\rQ,g.\u00198u+\u00059\u0004C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0011a\u0017M\\4\u000b\u0003q\nAA[1wC&\u0011a(\u000f\u0002\u0007'R\u0014\u0018N\\4\u0002\u000fQ,g.\u00198uA\u0005aA/\u001a8b]R\u0004&/\u001a4jq\u0006iA/\u001a8b]R\u0004&/\u001a4jq\u0002\n\u0001\u0002\\5oW\u0012\u000bG/Y\u000b\u0002\tB\u0019QI\u0013'\u000e\u0003\u0019S!a\u0012%\u0002\u0013%lW.\u001e;bE2,'BA%.\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0017\u001a\u00131aU3r!\ti\u0005+D\u0001O\u0015\tyu%\u0001\u0002{W&\u0011\u0011K\u0014\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC\u0006IA.\u001b8l\t\u0006$\u0018\rI\u0001\u000eg>,(oY3U_BL7-\u00133\u0016\u0003U\u0003\"A\u00160\u000e\u0003]S!\u0001W-\u0002\r\r|W.\\8o\u0015\tA#L\u0003\u0002\\9\u00061\u0011\r]1dQ\u0016T\u0011!X\u0001\u0004_J<\u0017BA0X\u0005\u0011)V/\u001b3\u0002\u001dM|WO]2f)>\u0004\u0018nY%eA\u0005Q\u0001/\u0019:uSRLwN\\:\u0016\u0003\r\u00042!\u0012&e!\u0011aSmZ4\n\u0005\u0019l#A\u0002+va2,'\u0007\u0005\u0002-Q&\u0011\u0011.\f\u0002\u0004\u0013:$\u0018a\u00039beRLG/[8og\u0002\na\u0001]1vg\u0016$W#A7\u0011\u0007\u0015Se\u000e\u0005\u0002-_&\u0011\u0001/\f\u0002\b\u0005>|G.Z1o\u0003\u001d\u0001\u0018-^:fI\u0002\n\u0011\u0002\\5oW6{G-Z:\u0016\u0003Q\u00042!\u0012&v!\t1x0D\u0001x\u0015\tA\u00180A\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001eT!\u0001\n>\u000b\u0005!Z(B\u0001?~\u0003%\u0019wN\u001c4mk\u0016tGOC\u0001\u007f\u0003\tIw.C\u0002\u0002\u0002]\u0014\u0001\u0002T5oW6{G-Z\u0001\u000bY&t7.T8eKN\u0004\u0013A\u0002;pa&\u001c7/\u0006\u0002\u0002\nA1Q)a\u00038\u0003\u001fI1!!\u0004G\u0005\ri\u0015\r\u001d\n\t\u0003#\t)\"a\u0007\u0002\"\u00191\u00111\u0003\u0001\u0001\u0003\u001f\u0011A\u0002\u0010:fM&tW-\\3oiz\u00022\u0001LA\f\u0013\r\tI\"\f\u0002\b!J|G-^2u!\r!\u0014QD\u0005\u0004\u0003?\u0019#!F\"mkN$XM\u001d'j].$v\u000e]5d'R\fG/\u001a\t\u0005\u0003G\t9#\u0004\u0002\u0002&)\u0011apO\u0005\u0005\u0003S\t)C\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004u_BL7m\u001d\u0011\u0002\u000f5,GO]5dgV\u0011\u0011\u0011\u0007\t\u0005\u0003g\t9$\u0004\u0002\u00026)\u0019\u0011QF,\n\t\u0005e\u0012Q\u0007\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013aB7b]\u0006<WM]\u000b\u0003\u0003\u0003\u00022\u0001NA\"\u0013\r\t)e\t\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T1oC\u001e,'/\u0001\u0005nC:\fw-\u001a:!\u0003=iW\r^1eCR\fW*\u00198bO\u0016\u0014XCAA'!\r!\u0014qJ\u0005\u0004\u0003#\u001a#AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018\u0001E7fi\u0006$\u0017\r^1NC:\fw-\u001a:!\u0003!!X-\u0019:E_^tGCAA-!\ra\u00131L\u0005\u0004\u0003;j#\u0001B+oSRD3\u0001GA1!\u0011\t\u0019'!\u001d\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\n1!\u00199j\u0015\u0011\tY'!\u001c\u0002\u000f),\b/\u001b;fe*\u0019\u0011q\u000e/\u0002\u000b),h.\u001b;\n\t\u0005M\u0014Q\r\u0002\n\u0003\u001a$XM]#bG\"\f1\u0002^3ti6+GO]5dgR!\u0011\u0011LA=\u0011\u0019\tY(\u0007a\u0001]\u00061RM\\1cY\u0016lU\r\u001e:jGN\u0014V\rZ;di&|g\u000eK\u0002\u001a\u0003\u007f\u0002B!!!\u0002\b6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000bI'\u0001\u0004qCJ\fWn]\u0005\u0005\u0003\u0013\u000b\u0019IA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDs!GAG\u00033\u000bY\n\u0005\u0003\u0002\u0010\u0006UUBAAI\u0015\u0011\t\u0019*a!\u0002\u0011A\u0014xN^5eKJLA!a&\u0002\u0012\nYa+\u00197vKN{WO]2f\u0003!\u0011wn\u001c7fC:\u001cH\u0006BAO\u0003?K\u0012!A\r\u0002\u0001\u0005\u0001C/Z:u\r\u0006LG.\u001a3NSJ\u0014xN\u001d+pa&\u001c7i\\;oi6+GO]5d)\u0011\tI&!*\t\r\u0005m$\u00041\u0001oQ\rQ\u0012q\u0010\u0015\b5\u00055\u0015\u0011TAVY\u0011\ti*a(\u0002-Q,7\u000f\u001e)bkN,G\rV8qS\u000elU\r\u001e:jGN$B!!\u0017\u00022\"1\u00111P\u000eA\u00029D3aGA@Q\u001dY\u0012QRAM\u0003ocC!!(\u0002 \u0006QB/Z:u\u0019&t7nQ8pe\u0012Lg.\u0019;pe6+GO]5dgR!\u0011\u0011LA_\u0011\u0019\tY\b\ba\u0001]\"\u001aA$a )\u000fq\ti)!'\u0002D2\"\u0011QTAP\u00031!Xm\u001d;MS:\\G+\u001f9fQ\ri\u0012\u0011\u001a\t\u0005\u0003G\nY-\u0003\u0003\u0002N\u0006\u0015$\u0001\u0002+fgR\fa\u0005^3ti\u000e{g\u000e\u001e:pY2,'OU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o\u001b\u0016$(/[2t)\u0011\tI&a5\t\r\u0005md\u00041\u0001oQ\rq\u0012q\u0010\u0015\b=\u00055\u0015\u0011TAmY\u0011\ti*a(\u0002gQ,7\u000f^\"p]R\u0014x\u000e\u001c7feJ+g/\u001a:tK\u000e{gN\\3di&|g.T3ue&\u001c7OR1jY\u0016$7+\u001a8t_J\u001cHCBA-\u0003?\f\t\u000f\u0003\u0004\u0002|}\u0001\rA\u001c\u0005\b\u0003G|\u0002\u0019AAs\u00039\u0019wN\u001c8fGRLwN\\'pI\u0016\u00042\u0001NAt\u0013\r\tIo\t\u0002\u000f\u0007>tg.Z2uS>tWj\u001c3fQ\ry\u0012q\u0010\u0015\b?\u0005=\u0018Q_A|!\u0011\ty)!=\n\t\u0005M\u0018\u0011\u0013\u0002\n\u0007N48k\\;sG\u0016\fQA^1mk\u0016d\u0003\"!?\u0002~\n\u0005!QA\u0011\u0003\u0003w\fA\u0002\u001e:vK2JgNY8v]\u0012\f#!a@\u0002\u001b\u0019\fGn]3-S:\u0014w.\u001e8eC\t\u0011\u0019!A\u0007ueV,Gf\\;uE>,h\u000eZ\u0011\u0003\u0005\u000f\taBZ1mg\u0016ds.\u001e;c_VtG-A\u0005tKR,\b/T8dW\u0006\u0011\u0012m]:feRlU\r\u001e:jG\u0016\u000bX/\u00197t)!\tIFa\u0004\u0003\u0012\tm\u0001BBA>C\u0001\u0007a\u000eC\u0004\u0003\u0014\u0005\u0002\rA!\u0006\u0002\t9\fW.\u001a\t\u0004-\n]\u0011b\u0001B\r/\nQQ*\u001a;sS\u000et\u0015-\\3\t\u000f\tu\u0011\u00051\u0001\u0003 \u0005iQ\r\u001f9fGR,GMV1mk\u0016\u00042\u0001\fB\u0011\u0013\r\u0011\u0019#\f\u0002\u0007\t>,(\r\\3")
public class ClusterLinkMetricsTest {
    private final String tenant;
    private final String tenantPrefix = new StringBuilder(1).append(this.tenant()).append("_").toString();
    private final scala.collection.immutable.Seq<ClusterLinkData> linkData = new .colon.colon((Object)new ClusterLinkData(new StringBuilder(11).append(this.tenantPrefix()).append("test-link-1").toString(), Uuid.randomUuid(), (Option)None$.MODULE$, (Option)new Some((Object)this.tenantPrefix()), false), (List)new .colon.colon((Object)new ClusterLinkData("test-link-2", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false), (List)new .colon.colon((Object)new ClusterLinkData("test-failed-link-3", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false), (List)Nil$.MODULE$)));
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final scala.collection.immutable.Seq<Tuple2<Object, Object>> partitions = new .colon.colon((Object)new Tuple2.mcII.sp(4, 1), (List)new .colon.colon((Object)new Tuple2.mcII.sp(6, 2), (List)Nil$.MODULE$));
    private final scala.collection.immutable.Seq<Object> paused = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true, false}));
    private final scala.collection.immutable.Seq<ClusterLinkConfig.LinkMode> linkModes = new .colon.colon((Object)ClusterLinkConfig.LinkMode.DESTINATION, (List)new .colon.colon((Object)ClusterLinkConfig.LinkMode.SOURCE, (List)Nil$.MODULE$));
    private final Map<String, Product> topics;
    private final Metrics metrics;
    private final ClusterLinkManager manager;
    private final ClusterLinkMetadataManager metadataManager;

    private String tenant() {
        return this.tenant;
    }

    private String tenantPrefix() {
        return this.tenantPrefix;
    }

    private scala.collection.immutable.Seq<ClusterLinkData> linkData() {
        return this.linkData;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private scala.collection.immutable.Seq<Tuple2<Object, Object>> partitions() {
        return this.partitions;
    }

    private scala.collection.immutable.Seq<Object> paused() {
        return this.paused;
    }

    private scala.collection.immutable.Seq<ClusterLinkConfig.LinkMode> linkModes() {
        return this.linkModes;
    }

    private Map<String, Product> topics() {
        return this.topics;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ClusterLinkManager manager() {
        return this.manager;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    @AfterEach
    public void tearDown() {
        this.metrics().close();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMetrics(boolean enableMetricsReduction) {
        this.setupMock();
        ClusterLinkBrokerMetrics brokerMetrics = new ClusterLinkBrokerMetrics(this.metrics(), 1, (Function1)(JFunction1.mcII.sp & Serializable)x$1 -> 1, (Option)None$.MODULE$);
        brokerMetrics.startup();
        scala.collection.immutable.Seq brokerSensors = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Sensor[]{brokerMetrics.linkedTopicPartitionAdditionSensor(), brokerMetrics.linkedLeaderEpochChangeSensor(), brokerMetrics.aclsAddedSensor(), brokerMetrics.aclsAddFailedSensor(), brokerMetrics.aclsDeletedSensor(), brokerMetrics.aclsDeleteFailedSensor(), brokerMetrics.describeAclsFromSourceFailedSensor(), brokerMetrics.consumerOffsetCommitSensor(), brokerMetrics.consumerOffsetCommitFailedSensor(), brokerMetrics.topicConfigUpdateSensor(), brokerMetrics.topicConfigUpdateFailedSensor(), brokerMetrics.autoMirrorCreateSensor(), brokerMetrics.autoMirrorCreateFailedSensor(), brokerMetrics.autoMirrorListTopicsFromSourceFailedSensor(), brokerMetrics.autoMirrorListTopicsFromDestinationFailedSensor(), brokerMetrics.autoMirrorListMirrorsFromSourceFailedSensor(), brokerMetrics.listConsumerOffsetsFromSourceFailedSensor(), brokerMetrics.listConsumerOffsetsFromDestinationFailedSensor(), brokerMetrics.listConsumerGroupsFromSourceFailedSensor(), brokerMetrics.prefixedAutoMirrorCreateSensor(), brokerMetrics.prefixedAutoMirrorCreateFailedSensor(), brokerMetrics.prefixedAutoMirrorTopicFilteredSensor(), brokerMetrics.deprecatedSourceReverseConnectionCreatedSensor(), brokerMetrics.deprecatedDestReverseConnectionCreatedSensor(), brokerMetrics.deprecatedSourceReverseConnectionClosedSensor(), brokerMetrics.deprecatedDestReverseConnectionClosedSensor(), brokerMetrics.deprecatedSourceReverseConnectionFailedSensor(), brokerMetrics.outboundReverseConnectionCreatedSensor(), brokerMetrics.inboundReverseConnectionCreatedSensor(), brokerMetrics.outboundReverseConnectionClosedSensor(), brokerMetrics.inboundReverseConnectionClosedSensor(), brokerMetrics.outboundReverseConnectionFailedSensor(), brokerMetrics.activeClientConnectionsCountSensor(), brokerMetrics.clientConnectionsThrottleSensor(), brokerMetrics.destinationLagLinkFetcherThrottleSensor(), brokerMetrics.linkFetcherProduceThrottleSensor(), brokerMetrics.linkFetcherRequestThrottleSensor(), brokerMetrics.timeToStopMirrorTopicFailoverSensor(), brokerMetrics.timeToStopMirrorTopicPromoteSensor()}));
        brokerSensors.foreach((Function1 & Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$2(this, s);
            return BoxedUnit.UNIT;
        });
        String linkName = ((ClusterLinkData)this.linkData().head()).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().head()).linkId(), ClusterLinkConfig.LinkMode.SOURCE, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, false, this.manager(), (Option)new Some((Object)brokerMetrics), this.metrics(), (Option)new Some((Object)this.tenant()), enableMetricsReduction);
        linkMetrics.startup();
        scala.collection.immutable.Seq linkSensors = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Sensor[]{linkMetrics.activeLinkCountSensor(), linkMetrics.throttleTimeSensor(), linkMetrics.linkedTopicPartitionAdditionSensor(), linkMetrics.linkedLeaderEpochChangeSensor(), linkMetrics.aclsAddedSensor(), linkMetrics.aclsAddFailedSensor(), linkMetrics.aclsDeletedSensor(), linkMetrics.aclsDeleteFailedSensor(), linkMetrics.describeAclsFromSourceFailedSensor(), linkMetrics.consumerOffsetCommitSensor(), linkMetrics.consumerOffsetCommitFailedSensor(), linkMetrics.topicConfigUpdateSensor(), linkMetrics.topicConfigUpdateFailedSensor(), linkMetrics.autoMirrorCreateSensor(), linkMetrics.autoMirrorCreateFailedSensor(), linkMetrics.autoMirrorListTopicsFromSourceFailedSensor(), linkMetrics.autoMirrorListTopicsFromDestinationFailedSensor(), linkMetrics.autoMirrorListMirrorsFromSourceFailedSensor(), linkMetrics.listConsumerGroupOffsetsFromSourceFailedSensor(), linkMetrics.listConsumerGroupOffsetsFromDestinationFailedSensor(), linkMetrics.listConsumerGroupsFromSourceFailedSensor(), linkMetrics.prefixedAutoMirrorCreateSensor(), linkMetrics.prefixedAutoMirrorCreateFailedSensor(), linkMetrics.prefixedAutoMirrorTopicFilteredSensor(), linkMetrics.linkUnavailableSensor(), linkMetrics.deprecatedReverseConnectionCreatedSensor(), linkMetrics.deprecatedReverseConnectionClosedSensor(), linkMetrics.deprecatedSourceReverseConnectionFailedSensor(), linkMetrics.reverseConnectionCreatedSensor(), linkMetrics.reverseConnectionClosedSensor(), linkMetrics.outboundReverseConnectionFailedSensor(), linkMetrics.destinationLagLinkFetcherThrottleSensor(), linkMetrics.linkFetcherProduceThrottleSensor(), linkMetrics.linkFetcherRequestThrottleSensor(), linkMetrics.timeToStopMirrorTopicFailoverSensor()}));
        linkSensors.foreach((Function1 & Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$3(this, s);
            return BoxedUnit.UNIT;
        });
        this.assertMetricEquals(enableMetricsReduction, linkMetrics.mirrorPartitionCountMetricName(), 4.0);
        linkMetrics.mirrorTopicCountMetricNames().foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$4(this, enableMetricsReduction, x0$1);
            return BoxedUnit.UNIT;
        });
        linkMetrics.failedMirrorTopicCountMetricNames().foreach((Function1 & Serializable)x0$2 -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$5(this, enableMetricsReduction, x0$2);
            return BoxedUnit.UNIT;
        });
        linkMetrics.shutdown();
        linkSensors.foreach((Function1 & Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$6(this, s);
            return BoxedUnit.UNIT;
        });
        brokerSensors.foreach((Function1 & Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$7(this, s);
            return BoxedUnit.UNIT;
        });
        Map taskSensors = linkMetrics.taskSensorsManager().sensors();
        Assertions.assertEquals((int)13, (int)taskSensors.keySet().size());
        scala.collection.immutable.Seq allSensors = (scala.collection.immutable.Seq)taskSensors.values().toSeq().flatMap((Function1 & Serializable)s -> (scala.collection.immutable.Seq)new .colon.colon((Object)s.activeSensor(), (List)Nil$.MODULE$).$plus$plus((IterableOnce)s.inErrorSensors().values().toSeq()));
        Assertions.assertEquals((int)119, (int)allSensors.toSet().size());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testFailedMirrorTopicCountMetric(boolean enableMetricsReduction) {
        this.setupMock();
        String linkName = ((ClusterLinkData)this.linkData().apply(2)).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().apply(2)).linkId(), (ClusterLinkConfig.LinkMode)this.linkModes().apply(1), (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, false, this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$, enableMetricsReduction);
        linkMetrics.startup();
        this.assertMetricEquals(enableMetricsReduction, (MetricName)((Tuple2)linkMetrics.linkCountMetricNames().head())._2(), 1.0);
        linkMetrics.mirrorTopicCountMetricNames().foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkMetricsTest.$anonfun$testFailedMirrorTopicCountMetric$1(this, enableMetricsReduction, x0$1);
            return BoxedUnit.UNIT;
        });
        linkMetrics.failedMirrorTopicCountMetricNames().foreach((Function1 & Serializable)x0$2 -> {
            ClusterLinkMetricsTest.$anonfun$testFailedMirrorTopicCountMetric$2(this, enableMetricsReduction, x0$2);
            return BoxedUnit.UNIT;
        });
        linkMetrics.shutdown();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPausedTopicMetrics(boolean enableMetricsReduction) {
        this.setupMock();
        String linkName = ((ClusterLinkData)this.linkData().apply(1)).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().apply(1)).linkId(), (ClusterLinkConfig.LinkMode)this.linkModes().apply(1), (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, false, this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$, enableMetricsReduction);
        linkMetrics.startup();
        this.assertMetricEquals(enableMetricsReduction, (MetricName)((Tuple2)linkMetrics.linkCountMetricNames().head())._2(), 1.0);
        this.assertMetricEquals(enableMetricsReduction, linkMetrics.mirrorPartitionCountMetricName(), 6.0);
        linkMetrics.mirrorTopicCountMetricNames().foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkMetricsTest.$anonfun$testPausedTopicMetrics$1(this, enableMetricsReduction, x0$1);
            return BoxedUnit.UNIT;
        });
        linkMetrics.failedMirrorTopicCountMetricNames().foreach((Function1 & Serializable)x0$2 -> {
            ClusterLinkMetricsTest.$anonfun$testPausedTopicMetrics$2(this, enableMetricsReduction, x0$2);
            return BoxedUnit.UNIT;
        });
        linkMetrics.shutdown();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLinkCoordinatorMetrics(boolean enableMetricsReduction) {
        this.setupMock();
        String linkName = ((ClusterLinkData)this.linkData().head()).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().head()).linkId(), (ClusterLinkConfig.LinkMode)this.linkModes().head(), (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, false, this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$, enableMetricsReduction);
        linkMetrics.startup();
        this.assertMetricEquals(enableMetricsReduction, (MetricName)((Tuple2)linkMetrics.linkCountMetricNames().head())._2(), 1.0);
        linkMetrics.shutdown();
    }

    @Test
    public void testLinkType() {
        Assertions.assertEquals((Object)LinkType.Cloud$.MODULE$, (Object)LinkType$.MODULE$.determineLinkType(true, (Option)new Some((Object)"tenant")));
        Assertions.assertEquals((Object)LinkType.Hybrid$.MODULE$, (Object)LinkType$.MODULE$.determineLinkType(false, (Option)new Some((Object)"tenant")));
        Assertions.assertEquals((Object)LinkType.None$.MODULE$, (Object)LinkType$.MODULE$.determineLinkType(false, (Option)None$.MODULE$));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testControllerReverseConnectionMetrics(boolean enableMetricsReduction) {
        Mockito.reset((Object[])new ClusterLinkManager[]{this.manager()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        ClusterLinkOutboundConnectionManager connectionManager = (ClusterLinkOutboundConnectionManager)Mockito.mock(ClusterLinkOutboundConnectionManager.class);
        Mockito.when((Object)this.manager().metadataManager()).thenReturn((Object)this.metadataManager());
        this.linkData().foreach((Function1 & Serializable)data -> {
            Mockito.when((Object)this.manager().resolveLinkId(data.linkName())).thenReturn((Object)new Some((Object)data.linkId()));
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)connectionManager.persistentConnectionCount())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
            return Mockito.when((Object)this.manager().connectionManager(data.linkId())).thenReturn((Object)new Some((Object)connectionManager));
        });
        String linkName = ((ClusterLinkData)this.linkData().head()).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().head()).linkId(), (ClusterLinkConfig.LinkMode)this.linkModes().apply(1), (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, true, this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)new Some((Object)this.tenant()), enableMetricsReduction);
        linkMetrics.startup();
        this.assertMetricEquals(enableMetricsReduction, linkMetrics.controllerReverseConnectionMetricName(), 1.0);
        Assertions.assertTrue((boolean)linkMetrics.controllerReverseConnectionMetricName().tags().containsKey("mode"));
        Assertions.assertEquals((Object)"source", linkMetrics.controllerReverseConnectionMetricName().tags().get("mode"));
        Assertions.assertTrue((boolean)linkMetrics.controllerReverseConnectionMetricName().tags().containsKey("connection-mode"));
        Assertions.assertEquals((Object)"outbound", linkMetrics.controllerReverseConnectionMetricName().tags().get("connection-mode"));
        Assertions.assertTrue((boolean)linkMetrics.controllerReverseConnectionMetricName().tags().containsKey("remote-link-connection-mode"));
        Assertions.assertEquals((Object)"inbound", linkMetrics.controllerReverseConnectionMetricName().tags().get("remote-link-connection-mode"));
        Assertions.assertTrue((boolean)linkMetrics.controllerReverseConnectionMetricName().tags().containsKey("deployed-link-type"));
        Assertions.assertEquals((Object)"cloud", linkMetrics.controllerReverseConnectionMetricName().tags().get("deployed-link-type"));
        this.assertMetricEquals(enableMetricsReduction, linkMetrics.deprecatedControllerReverseConnectionMetricName(), 1.0);
        Assertions.assertTrue((boolean)linkMetrics.deprecatedControllerReverseConnectionMetricName().tags().containsKey("mode"));
        Assertions.assertEquals((Object)"source", linkMetrics.deprecatedControllerReverseConnectionMetricName().tags().get("mode"));
        Assertions.assertTrue((boolean)linkMetrics.deprecatedControllerReverseConnectionMetricName().tags().containsKey("connection-mode"));
        Assertions.assertEquals((Object)"outbound", linkMetrics.deprecatedControllerReverseConnectionMetricName().tags().get("connection-mode"));
        Assertions.assertFalse((boolean)linkMetrics.deprecatedControllerReverseConnectionMetricName().tags().containsKey("remote-link-connection-mode"));
        Assertions.assertTrue((boolean)linkMetrics.deprecatedControllerReverseConnectionMetricName().tags().containsKey("deployed-link-type"));
        Assertions.assertEquals((Object)"cloud", linkMetrics.deprecatedControllerReverseConnectionMetricName().tags().get("deployed-link-type"));
        Assertions.assertTrue((boolean)linkMetrics.deprecatedControllerReverseConnectionMetricName().description().contains("deprecated"));
        linkMetrics.shutdown();
    }

    @ParameterizedTest
    @CsvSource(value={"true,inbound", "false,inbound", "true,outbound", "false,outbound"})
    public void testControllerReverseConnectionMetricsFailedSensors(boolean enableMetricsReduction, ConnectionMode connectionMode) {
        Mockito.reset((Object[])new ClusterLinkManager[]{this.manager()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        ClusterLinkOutboundConnectionManager connectionManager = (ClusterLinkOutboundConnectionManager)Mockito.mock(ClusterLinkOutboundConnectionManager.class);
        Mockito.when((Object)this.manager().metadataManager()).thenReturn((Object)this.metadataManager());
        this.linkData().foreach((Function1 & Serializable)data -> {
            Mockito.when((Object)this.manager().resolveLinkId(data.linkName())).thenReturn((Object)new Some((Object)data.linkId()));
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)connectionManager.persistentConnectionCount())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
            return Mockito.when((Object)this.manager().connectionManager(data.linkId())).thenReturn((Object)new Some((Object)connectionManager));
        });
        String linkName = ((ClusterLinkData)this.linkData().head()).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().head()).linkId(), (ClusterLinkConfig.LinkMode)this.linkModes().apply(1), connectionMode, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, true, this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)new Some((Object)this.tenant()), enableMetricsReduction);
        linkMetrics.startup();
        ConnectionMode connectionMode2 = connectionMode;
        ConnectionMode.Outbound$ outbound$ = ConnectionMode.Outbound$.MODULE$;
        if (connectionMode2 != null && connectionMode2.equals(outbound$)) {
            Assertions.assertNotNull((Object)linkMetrics.outboundReverseConnectionFailedSensor());
            Assertions.assertNotNull((Object)linkMetrics.deprecatedSourceReverseConnectionFailedSensor());
        } else {
            Assertions.assertNull((Object)linkMetrics.outboundReverseConnectionFailedSensor());
            Assertions.assertNull((Object)linkMetrics.deprecatedSourceReverseConnectionFailedSensor());
        }
        linkMetrics.shutdown();
    }

    private void setupMock() {
        Mockito.reset((Object[])new ClusterLinkManager[]{this.manager()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.when((Object)this.manager().listClusterLinks()).thenReturn(this.linkData());
        ((IterableOps)this.partitions().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Tuple2 data = (Tuple2)x0$1._1();
                int index = x0$1._2$mcI$sp();
                ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
                Mockito.when((Object)BoxesRunTime.boxToInteger((int)fetcherManager.mirrorPartitionCount())).thenReturn((Object)BoxesRunTime.boxToInteger((int)data._1$mcI$sp()));
                return Mockito.when((Object)this.manager().fetcherManager(((ClusterLinkData)this.linkData().apply(index)).linkId())).thenReturn((Object)new Some((Object)fetcherManager));
            }
            throw new MatchError(null);
        });
        ((IterableOnceOps)this.paused().zipWithIndex()).foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                boolean paused = x0$2._1$mcZ$sp();
                int index = x0$2._2$mcI$sp();
                ClusterLinkConfig config = (ClusterLinkConfig)Mockito.mock(ClusterLinkConfig.class);
                Mockito.when((Object)config.clusterLinkPaused()).thenReturn((Object)Predef$.MODULE$.boolean2Boolean(paused));
                ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
                Mockito.when((Object)clientManager.currentConfig()).thenReturn((Object)config);
                Mockito.when((Object)this.manager().clientManager(((ClusterLinkData)this.linkData().apply(index)).linkId())).thenReturn((Object)new Some((Object)clientManager));
                return Mockito.when((Object)this.manager().destClientManager(((ClusterLinkData)this.linkData().apply(index)).linkId())).thenReturn((Object)new Some((Object)clientManager));
            }
            throw new MatchError(null);
        });
        Mockito.when((Object)this.manager().metadataManager()).thenReturn((Object)this.metadataManager());
        this.linkData().foreach((Function1 & Serializable)data -> {
            Mockito.when((Object)this.manager().resolveLinkId(data.linkName())).thenReturn((Object)new Some((Object)data.linkId()));
            return Mockito.when((Object)this.manager().linkState(data.linkName())).thenReturn((Object)ActiveClusterLink$.MODULE$);
        });
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache(((ClusterLinkData)this.linkData().head()).linkId())).thenReturn(this.topics().filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsTest.$anonfun$setupMock$4(this, t))));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache(((ClusterLinkData)this.linkData().apply(1)).linkId())).thenReturn(this.topics().filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsTest.$anonfun$setupMock$5(this, t))));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache(((ClusterLinkData)this.linkData().apply(2)).linkId())).thenReturn(this.topics().filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsTest.$anonfun$setupMock$6(this, t))));
    }

    private void assertMetricEquals(boolean enableMetricsReduction, MetricName name, double expectedValue) {
        if (enableMetricsReduction && expectedValue == 0.0) {
            Option option = CollectionConverters$.MODULE$.MapHasAsScala(this.metrics().metrics()).asScala().get((Object)name);
            if (option instanceof Some) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(24).append("Metric ").append(name).append(" should not exist").toString());
                return;
            }
            if (None$.MODULE$.equals(option)) {
                return;
            }
            throw new MatchError((Object)option);
        }
        Option option = CollectionConverters$.MODULE$.MapHasAsScala(this.metrics().metrics()).asScala().get((Object)name);
        if (option instanceof Some) {
            KafkaMetric metric = (KafkaMetric)((Some)option).value();
            Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)expectedValue), (Object)metric.metricValue());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Metric ").append(name).append(" not found").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$testMetrics$2(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)s, (String)"Sensor should be initialized");
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(22).append("Sensor ").append(s.name()).append(" not registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$3(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)s, (String)"Sensor should be initialized");
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(22).append("Sensor ").append(s.name()).append(" not registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$4(ClusterLinkMetricsTest $this, boolean enableMetricsReduction$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            boolean bl;
            String state = (String)x0$1._1();
            MetricName name = (MetricName)x0$1._2();
            String string = TopicLinkMirror$.MODULE$.name();
            if (!(string != null ? !string.equals(state) : state != null)) {
                bl = true;
            } else {
                String string2 = TopicLinkPausedMirror$.MODULE$.name();
                if (!(string2 != null ? !string2.equals(state) : state != null)) {
                    bl = false;
                } else {
                    String string3 = TopicLinkPendingStoppedMirror$.MODULE$.name();
                    if (!(string3 != null ? !string3.equals(state) : state != null)) {
                        bl = false;
                    } else {
                        String string4 = TopicLinkStoppedMirror$.MODULE$.name();
                        if (!(string4 != null ? !string4.equals(state) : state != null)) {
                            bl = true;
                        } else {
                            String string5 = TopicLinkFailedMirror$.MODULE$.name();
                            if (!(string5 != null ? !string5.equals(state) : state != null)) {
                                bl = true;
                            } else {
                                String string6 = TopicLinkPendingRepairMirror$.MODULE$.name();
                                if (!(string6 != null ? !string6.equals(state) : state != null)) {
                                    bl = false;
                                } else {
                                    String string7 = TopicLinkPendingSynchronizeMirror$.MODULE$.name();
                                    if (!(string7 != null ? !string7.equals(state) : state != null)) {
                                        bl = false;
                                    } else {
                                        String string8 = TopicLinkPendingMirror$.MODULE$.name();
                                        if (!(string8 != null ? !string8.equals(state) : state != null)) {
                                            bl = false;
                                        } else {
                                            throw new AssertionError((Object)new StringBuilder(17).append("Unexpected state ").append(state).toString());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            boolean expectedValue = bl;
            $this.assertMetricEquals(enableMetricsReduction$1, name, (double)expectedValue);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testMetrics$5(ClusterLinkMetricsTest $this, boolean enableMetricsReduction$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            MirrorTopicError error = (MirrorTopicError)x0$2._1();
            MetricName name = (MetricName)x0$2._2();
            boolean expectedValue = MirrorTopicError.SOURCE_TOPIC_ID_CHANGED.equals(error);
            $this.assertMetricEquals(enableMetricsReduction$1, name, (double)expectedValue);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testMetrics$6(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNull((Object)$this.metrics().getSensor(s.name()), (String)new StringBuilder(32).append("Sensor ").append(s.name()).append(" should not be registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$7(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(34).append("Sensor ").append(s.name()).append(" should still be registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testFailedMirrorTopicCountMetric$1(ClusterLinkMetricsTest $this, boolean enableMetricsReduction$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            int n;
            String state = (String)x0$1._1();
            MetricName name = (MetricName)x0$1._2();
            String string = TopicLinkMirror$.MODULE$.name();
            if (!(string != null ? !string.equals(state) : state != null)) {
                n = 1;
            } else {
                String string2 = TopicLinkPausedMirror$.MODULE$.name();
                if (!(string2 != null ? !string2.equals(state) : state != null)) {
                    n = 0;
                } else {
                    String string3 = TopicLinkPendingStoppedMirror$.MODULE$.name();
                    if (!(string3 != null ? !string3.equals(state) : state != null)) {
                        n = 0;
                    } else {
                        String string4 = TopicLinkStoppedMirror$.MODULE$.name();
                        if (!(string4 != null ? !string4.equals(state) : state != null)) {
                            n = 0;
                        } else {
                            String string5 = TopicLinkFailedMirror$.MODULE$.name();
                            if (!(string5 != null ? !string5.equals(state) : state != null)) {
                                n = 5;
                            } else {
                                String string6 = TopicLinkPendingRepairMirror$.MODULE$.name();
                                if (!(string6 != null ? !string6.equals(state) : state != null)) {
                                    n = 0;
                                } else {
                                    String string7 = TopicLinkPendingSynchronizeMirror$.MODULE$.name();
                                    if (!(string7 != null ? !string7.equals(state) : state != null)) {
                                        n = 0;
                                    } else {
                                        String string8 = TopicLinkPendingMirror$.MODULE$.name();
                                        if (!(string8 != null ? !string8.equals(state) : state != null)) {
                                            n = 0;
                                        } else {
                                            throw new AssertionError((Object)new StringBuilder(17).append("Unexpected state ").append(state).toString());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            int expectedValue = n;
            $this.assertMetricEquals(enableMetricsReduction$2, name, expectedValue);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testFailedMirrorTopicCountMetric$2(ClusterLinkMetricsTest $this, boolean enableMetricsReduction$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            MirrorTopicError error = (MirrorTopicError)x0$2._1();
            MetricName name = (MetricName)x0$2._2();
            int expectedValue = MirrorTopicError.UNSUPPORTED_MESSAGE_FORMAT.equals(error) ? 1 : (MirrorTopicError.NON_MONOTONIC_LOG_APPEND_EPOCH.equals(error) ? 2 : (MirrorTopicError.UNKNOWN.equals(error) ? 1 : (MirrorTopicError.NOT_SET.equals(error) ? 1 : 0)));
            $this.assertMetricEquals(enableMetricsReduction$2, name, expectedValue);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testPausedTopicMetrics$1(ClusterLinkMetricsTest $this, boolean enableMetricsReduction$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            int n;
            String state = (String)x0$1._1();
            MetricName name = (MetricName)x0$1._2();
            String string = TopicLinkMirror$.MODULE$.name();
            if (!(string != null ? !string.equals(state) : state != null)) {
                n = 2;
            } else {
                String string2 = TopicLinkPausedMirror$.MODULE$.name();
                if (!(string2 != null ? !string2.equals(state) : state != null)) {
                    n = 2;
                } else {
                    String string3 = TopicLinkPendingStoppedMirror$.MODULE$.name();
                    if (!(string3 != null ? !string3.equals(state) : state != null)) {
                        n = 0;
                    } else {
                        String string4 = TopicLinkStoppedMirror$.MODULE$.name();
                        if (!(string4 != null ? !string4.equals(state) : state != null)) {
                            n = 0;
                        } else {
                            String string5 = TopicLinkFailedMirror$.MODULE$.name();
                            if (!(string5 != null ? !string5.equals(state) : state != null)) {
                                n = 0;
                            } else {
                                String string6 = TopicLinkPendingRepairMirror$.MODULE$.name();
                                if (!(string6 != null ? !string6.equals(state) : state != null)) {
                                    n = 0;
                                } else {
                                    String string7 = TopicLinkPendingSynchronizeMirror$.MODULE$.name();
                                    if (!(string7 != null ? !string7.equals(state) : state != null)) {
                                        n = 0;
                                    } else {
                                        String string8 = TopicLinkPendingMirror$.MODULE$.name();
                                        if (!(string8 != null ? !string8.equals(state) : state != null)) {
                                            n = 0;
                                        } else {
                                            throw new AssertionError((Object)new StringBuilder(17).append("Unexpected state ").append(state).toString());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            int expectedValue = n;
            $this.assertMetricEquals(enableMetricsReduction$3, name, expectedValue);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testPausedTopicMetrics$2(ClusterLinkMetricsTest $this, boolean enableMetricsReduction$3, Tuple2 x0$2) {
        if (x0$2 != null) {
            MetricName name = (MetricName)x0$2._2();
            $this.assertMetricEquals(enableMetricsReduction$3, name, 0.0);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$setupMock$4(ClusterLinkMetricsTest $this, Tuple2 t) {
        return ((ClusterLinkTopicState)t._2()).linkName().equals(((ClusterLinkData)$this.linkData().head()).linkName());
    }

    public static final /* synthetic */ boolean $anonfun$setupMock$5(ClusterLinkMetricsTest $this, Tuple2 t) {
        return ((ClusterLinkTopicState)t._2()).linkName().equals(((ClusterLinkData)$this.linkData().apply(1)).linkName());
    }

    public static final /* synthetic */ boolean $anonfun$setupMock$6(ClusterLinkMetricsTest $this, Tuple2 t) {
        return ((ClusterLinkTopicState)t._2()).linkName().equals(((ClusterLinkData)$this.linkData().apply(2)).linkName());
    }

    public ClusterLinkMetricsTest() {
        this.tenant = "test-tenant";
        Object[] objectArray = new Tuple2[11];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new ClusterLinkTopicState.StoppedMirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), (Seq)package$.MODULE$.List().empty(), Time.SYSTEM.milliseconds()));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)new ClusterLinkTopicState.FailedMirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, Time.SYSTEM.milliseconds()));
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-4"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().apply(1)).linkName(), ((ClusterLinkData)this.linkData().apply(1)).linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-5"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().apply(1)).linkName(), ((ClusterLinkData)this.linkData().apply(1)).linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-60"), (Object)new ClusterLinkTopicState.FailedMirror(((ClusterLinkData)this.linkData().apply(2)).linkName(), ((ClusterLinkData)this.linkData().apply(2)).linkId(), this.sourceTopicId(), MirrorTopicError.NON_MONOTONIC_LOG_APPEND_EPOCH, Time.SYSTEM.milliseconds()));
        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-61"), (Object)new ClusterLinkTopicState.FailedMirror(((ClusterLinkData)this.linkData().apply(2)).linkName(), ((ClusterLinkData)this.linkData().apply(2)).linkId(), this.sourceTopicId(), MirrorTopicError.UNSUPPORTED_MESSAGE_FORMAT, Time.SYSTEM.milliseconds()));
        objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-62"), (Object)new ClusterLinkTopicState.FailedMirror(((ClusterLinkData)this.linkData().apply(2)).linkName(), ((ClusterLinkData)this.linkData().apply(2)).linkId(), this.sourceTopicId(), MirrorTopicError.NON_MONOTONIC_LOG_APPEND_EPOCH, Time.SYSTEM.milliseconds()));
        objectArray[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-63"), (Object)new ClusterLinkTopicState.FailedMirror(((ClusterLinkData)this.linkData().apply(2)).linkName(), ((ClusterLinkData)this.linkData().apply(2)).linkId(), this.sourceTopicId(), MirrorTopicError.NOT_SET, Time.SYSTEM.milliseconds()));
        objectArray[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-64"), (Object)new ClusterLinkTopicState.FailedMirror(((ClusterLinkData)this.linkData().apply(2)).linkName(), ((ClusterLinkData)this.linkData().apply(2)).linkId(), this.sourceTopicId(), MirrorTopicError.UNKNOWN, Time.SYSTEM.milliseconds()));
        objectArray[10] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-65"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().apply(2)).linkName(), ((ClusterLinkData)this.linkData().apply(2)).linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        this.topics = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.metrics = new Metrics();
        this.manager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
        this.metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    }
}

