/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkClientType;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSelectorMetricsRegistry;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005u4AAD\b\u0001-!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0003B\u0002\u0018\u0001A\u0003%1\u0005C\u00040\u0001\t\u0007I\u0011\u0002\u0019\t\re\u0002\u0001\u0015!\u00032\u0011\u001dQ\u0004A1A\u0005\nmBaA\u0011\u0001!\u0002\u0013a\u0004bB\"\u0001\u0005\u0004%I\u0001\u0012\u0005\u0007\u0011\u0002\u0001\u000b\u0011B#\t\u000b%\u0003A\u0011\u0001&\t\u000be\u0003A\u0011\u0001&\t\u000bm\u0003A\u0011\u0002/\t\u000fE\u0004\u0011\u0013!C\u0005e\na2\t\\;ti\u0016\u0014H*\u001b8l\u001d\u0016$xo\u001c:l\u00072LWM\u001c;UKN$(B\u0001\t\u0012\u0003\u0011a\u0017N\\6\u000b\u0005I\u0019\u0012AB:feZ,'OC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\tq\"\u0001\u0004mS:\\\u0017\nZ\u000b\u0002GA\u0011A\u0005L\u0007\u0002K)\u0011aeJ\u0001\u0007G>lWn\u001c8\u000b\u0005QA#BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001eL!!L\u0013\u0003\tU+\u0018\u000eZ\u0001\bY&t7.\u00133!\u0003!a\u0017N\\6OC6,W#A\u0019\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014\u0001\u00027b]\u001eT\u0011AN\u0001\u0005U\u00064\u0018-\u0003\u00029g\t11\u000b\u001e:j]\u001e\f\u0011\u0002\\5oW:\u000bW.\u001a\u0011\u0002\tQLW.Z\u000b\u0002yA\u0011Q\bQ\u0007\u0002})\u0011q(J\u0001\u0006kRLGn]\u0005\u0003\u0003z\u0012\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0018g\u0016dWm\u0019;pe6+GO]5dgJ+w-[:uef,\u0012!\u0012\t\u0003A\u0019K!aR\b\u0003E\rcWo\u001d;fe2Kgn[*fY\u0016\u001cGo\u001c:NKR\u0014\u0018nY:SK\u001eL7\u000f\u001e:z\u0003a\u0019X\r\\3di>\u0014X*\u001a;sS\u000e\u001c(+Z4jgR\u0014\u0018\u0010I\u0001\u001ai\u0016\u001cH\u000fT5oW&#\u0017J\u001c*fcV,7\u000f\u001e%fC\u0012,'\u000fF\u0001L!\tAB*\u0003\u0002N3\t!QK\\5uQ\tQq\n\u0005\u0002Q/6\t\u0011K\u0003\u0002S'\u0006\u0019\u0011\r]5\u000b\u0005Q+\u0016a\u00026va&$XM\u001d\u0006\u0003-*\nQA[;oSRL!\u0001W)\u0003\tQ+7\u000f^\u0001\u0017i\u0016\u001cH/S:DY>,H\rV8DY>,H\rT5oW\"\u00121bT\u0001\rGJ,\u0017\r^3DY&,g\u000e\u001e\u000b\u0004;\u0002d\u0007C\u0001\u0011_\u0013\tyvB\u0001\rDYV\u001cH/\u001a:MS:\\g*\u001a;x_J\\7\t\\5f]RDQ!\u0019\u0007A\u0002\t\f\u0001CY8piN$(/\u00199TKJ4XM]:\u0011\u0005\rTgB\u00013i!\t)\u0017$D\u0001g\u0015\t9W#\u0001\u0004=e>|GOP\u0005\u0003Sf\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001dl\u0015\tI\u0017\u0004C\u0004n\u0019A\u0005\t\u0019\u00018\u0002\u00139,Go^8sW&#\u0007c\u0001\rpE&\u0011\u0001/\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0002-\r\u0014X-\u0019;f\u00072LWM\u001c;%I\u00164\u0017-\u001e7uII*\u0012a\u001d\u0016\u0003]R\\\u0013!\u001e\t\u0003mnl\u0011a\u001e\u0006\u0003qf\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005iL\u0012AC1o]>$\u0018\r^5p]&\u0011Ap\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ClusterLinkNetworkClientTest {
    private final Uuid linkId = Uuid.randomUuid();
    private final String linkName;
    private final MockTime time = new MockTime();
    private final ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry = (ClusterLinkSelectorMetricsRegistry)Mockito.mock(ClusterLinkSelectorMetricsRegistry.class);

    private Uuid linkId() {
        return this.linkId;
    }

    private String linkName() {
        return this.linkName;
    }

    private MockTime time() {
        return this.time;
    }

    private ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry() {
        return this.selectorMetricsRegistry;
    }

    @Test
    public void testLinkIdInRequestHeader() {
        ClusterLinkNetworkClient client = this.createClient("localhost:1234", (Option<String>)Option$.MODULE$.empty());
        Assertions.assertNotNull((Object)client.networkClient());
        ((NetworkClient)client.networkClient()).enableClusterLinkRequests(this.linkId(), null, null);
        MetadataRequest.Builder builder = new MetadataRequest.Builder(Collections.emptyList(), false);
        RequestHeader header = client.networkClient().newClientRequest("0", (AbstractRequest.Builder)builder, this.time().milliseconds(), true, 30000, null).makeHeader(ApiKeys.METADATA.latestVersion());
        Assertions.assertEquals(Optional.of(this.linkId()), (Object)header.clusterLinkId());
    }

    @Test
    public void testIsCloudToCloudLink() {
        this.testIsCloudToCloudLink$1("foo.bar.us-west2.aws.confluent.cloud:9003", (Option)new Some((Object)"nr1"), true);
        this.testIsCloudToCloudLink$1("localhost:9003", (Option)new Some((Object)"nr1"), false);
        this.testIsCloudToCloudLink$1("foo.bar.us-west2.aws.confluent.cloud:9003", (Option)new Some((Object)""), false);
        this.testIsCloudToCloudLink$1("foo.bar.us-west2.aws.confluent.cloud:9003", Option$.MODULE$.empty(), false);
        this.testIsCloudToCloudLink$1("localhost:9003", Option$.MODULE$.empty(), false);
    }

    private ClusterLinkNetworkClient createClient(String bootstrapServers, Option<String> networkId) {
        Properties testBrokerProps = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        networkId.foreach((Function1 & Serializable)nid -> testBrokerProps.put("confluent.traffic.network.id", nid));
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(testBrokerProps);
        ClusterLinkMetadata metadata = new ClusterLinkMetadata(brokerConfig, this.linkName(), this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, 100L, 60000L);
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((java.util.Map)new Properties(null, bootstrapServers){
            {
                this.put("bootstrap.servers", bootstrapServers$1);
            }
        }, (Option)new Some((Object)brokerConfig), true);
        return new ClusterLinkNetworkClient(brokerConfig, linkConfig, "", (Option)new Some((Object)metadata), (Option)None$.MODULE$, new Metrics(), this.selectorMetricsRegistry(), (Map)Map$.MODULE$.empty(), (Time)this.time(), "clientId", (ClusterLinkClientType)ClusterLinkClientType.Fetcher$.MODULE$, new LogContext(), null);
    }

    private Option<String> createClient$default$2() {
        return Option$.MODULE$.empty();
    }

    private final void testIsCloudToCloudLink$1(String bootstrapServers, Option networkId, boolean expectedResult) {
        ClusterLinkNetworkClient client = this.createClient(bootstrapServers, (Option<String>)networkId);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectedResult), (Object)BoxesRunTime.boxToBoolean((boolean)client.isCloudToCloudLink()));
    }

    public ClusterLinkNetworkClientTest() {
        this.linkName = "testLink";
    }
}

