/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.UnboundedClusterLinkRequestQuota$;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkPauseMirrorTopicsTaskType$;
import kafka.server.link.ClusterLinkPauseMirrors;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.InErrorTaskState$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TaskState;
import kafka.server.link.TaskType;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkState;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t%e\u0001\u0002\u001d:\u0001\u0001CQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001C\u0002\u0013%A\n\u0003\u0004V\u0001\u0001\u0006I!\u0014\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019\u0019\u0007\u0001)A\u00051\"9A\r\u0001b\u0001\n\u00139\u0006BB3\u0001A\u0003%\u0001\fC\u0004g\u0001\t\u0007I\u0011\u0002'\t\r\u001d\u0004\u0001\u0015!\u0003N\u0011\u001dA\u0007A1A\u0005\n]Ca!\u001b\u0001!\u0002\u0013A\u0006b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007_\u0002\u0001\u000b\u0011\u00027\t\u000fA\u0004!\u0019!C\u0005c\"1\u0011\u0010\u0001Q\u0001\nIDqA\u001f\u0001C\u0002\u0013%1\u0010\u0003\u0004\u0000\u0001\u0001\u0006I\u0001 \u0005\n\u0003\u0003\u0001!\u0019!C\u0005\u0003\u0007A\u0001\"a\u0003\u0001A\u0003%\u0011Q\u0001\u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"!\b\u0001A\u0003%\u0011\u0011\u0003\u0005\n\u0003?\u0001!\u0019!C\u0005\u0003CA\u0001\"a\u000b\u0001A\u0003%\u00111\u0005\u0005\n\u0003[\u0001!\u0019!C\u0005\u0003_A\u0001\"a\u000e\u0001A\u0003%\u0011\u0011\u0007\u0005\n\u0003s\u0001!\u0019!C\u0005\u0003wA\u0001\"a\u0012\u0001A\u0003%\u0011Q\b\u0005\n\u0003\u0013\u0002!\u0019!C\u0005\u0003wA\u0001\"a\u0013\u0001A\u0003%\u0011Q\b\u0005\b\u0003\u001b\u0002A\u0011AA(\u0011\u001d\ti\u0007\u0001C\u0001\u0003\u001fBq!a\u001e\u0001\t\u0003\ty\u0005C\u0004\u0002\u0002\u0002!\t!a\u0014\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002P!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005=\u0003bBAG\u0001\u0011\u0005\u0011q\n\u0005\b\u0003#\u0003A\u0011AA(\u0011\u001d\t)\n\u0001C\u0001\u0003\u001fBq!!'\u0001\t\u0003\ty\u0005C\u0004\u0002\u001e\u0002!I!a(\t\u000f\u0005-\u0006\u0001\"\u0003\u0002P!9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006bBA`\u0001\u0011%\u0011\u0011\u0019\u0005\b\u0003\u000f\u0004A\u0011BAe\u0011\u001d\ti\r\u0001C\u0005\u0003\u001fDq!!7\u0001\t\u0013\tY\u000eC\u0004\u0002l\u0002!I!!<\t\u000f\u0005E\b\u0001\"\u0003\u0002t\"9\u0011q\u001f\u0001\u0005\n\u0005e\bbBA\u007f\u0001\u0011%\u0011q \u0005\b\u0005#\u0001A\u0011\u0002B\n\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{AqAa\u0013\u0001\t\u0013\u0011i\u0005C\u0004\u0003Z\u0001!IAa\u0017\t\u000f\tU\u0004\u0001\"\u0003\u0003x\tY2\t\\;ti\u0016\u0014H*\u001b8l!\u0006,8/Z'jeJ|'o\u001d+fgRT!AO\u001e\u0002\t1Lgn\u001b\u0006\u0003yu\naa]3sm\u0016\u0014(\"\u0001 \u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0005C\u0001&\u0001\u001b\u0005I\u0014\u0001\u00037j].t\u0015-\\3\u0016\u00035\u0003\"AT*\u000e\u0003=S!\u0001U)\u0002\t1\fgn\u001a\u0006\u0002%\u0006!!.\u0019<b\u0013\t!vJ\u0001\u0004TiJLgnZ\u0001\nY&t7NT1nK\u0002\na\u0001\\5oW&#W#\u0001-\u0011\u0005e\u000bW\"\u0001.\u000b\u0005mc\u0016AB2p[6|gN\u0003\u0002?;*\u0011alX\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\f1a\u001c:h\u0013\t\u0011'L\u0001\u0003Vk&$\u0017a\u00027j].LE\rI\u0001\u000eg>,(oY3U_BL7-\u00133\u0002\u001dM|WO]2f)>\u0004\u0018nY%eA\u0005iq\u000e\u001e5fe2Kgn\u001b(b[\u0016\fab\u001c;iKJd\u0015N\\6OC6,\u0007%A\u0006pi\",'\u000fT5oW&#\u0017\u0001D8uQ\u0016\u0014H*\u001b8l\u0013\u0012\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\u0005a\u0007C\u0001&n\u0013\tq\u0017H\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013!B1e[&tW#\u0001:\u0011\u0005M<X\"\u0001;\u000b\u0005A,(B\u0001<]\u0003\u001d\u0019G.[3oiNL!\u0001\u001f;\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u00061\u0011\rZ7j]\u0002\nq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0002yB\u0011!*`\u0005\u0003}f\u0012!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\f\u0001#\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0011\u0002+5\f\u0007\u0010V8qS\u000e\u001c\b+\u001a:Ji\u0016\u0014\u0018\r^5p]V\u0011\u0011Q\u0001\t\u0004\u0005\u0006\u001d\u0011bAA\u0005\u0007\n\u0019\u0011J\u001c;\u0002-5\f\u0007\u0010V8qS\u000e\u001c\b+\u001a:Ji\u0016\u0014\u0018\r^5p]\u0002\nA\u0001^5nKV\u0011\u0011\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003.\u0002\u000bU$\u0018\u000e\\:\n\t\u0005m\u0011Q\u0003\u0002\u0005)&lW-A\u0003uS6,\u0007%A\u0003rk>$\u0018-\u0006\u0002\u0002$A!\u0011QEA\u0014\u001b\u0005Y\u0014bAA\u0015w\t92\t\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\u0001\u0007cV|G/\u0019\u0011\u0002\u000f5,GO]5dgV\u0011\u0011\u0011\u0007\t\u0004\u0015\u0006M\u0012bAA\u001bs\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001E1di&4X\rV1tWN+gn]8s+\t\ti\u0004\u0005\u0003\u0002@\u0005\rSBAA!\u0015\r\tiCW\u0005\u0005\u0003\u000b\n\tE\u0001\u0004TK:\u001cxN]\u0001\u0012C\u000e$\u0018N^3UCN\\7+\u001a8t_J\u0004\u0013!E5o\u000bJ\u0014xN\u001d+bg.\u001cVM\\:pe\u0006\u0011\u0012N\\#se>\u0014H+Y:l'\u0016t7o\u001c:!\u0003\u0015\u0019X\r^+q)\t\t\t\u0006E\u0002C\u0003'J1!!\u0016D\u0005\u0011)f.\u001b;)\u0007y\tI\u0006\u0005\u0003\u0002\\\u0005%TBAA/\u0015\u0011\ty&!\u0019\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002d\u0005\u0015\u0014a\u00026va&$XM\u001d\u0006\u0004\u0003Oz\u0016!\u00026v]&$\u0018\u0002BA6\u0003;\u0012!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\u0010\u0002rA!\u00111LA:\u0013\u0011\t)(!\u0018\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0007;fgR\u0004\u0016-^:f\u001b&\u0014(o\u001c:U_BL7m]#naRL\bf\u0001\u0011\u0002|A!\u00111LA?\u0013\u0011\ty(!\u0018\u0003\tQ+7\u000f^\u0001\u001bi\u0016\u001cH\u000fU1vg\u0016l\u0015N\u001d:peR{\u0007/[2t!\u0006,8/\u001a\u0015\u0004C\u0005m\u0014\u0001\b;fgR\u0004\u0016-^:f\u001b&\u0014(o\u001c:U_BL7m]+oa\u0006,8/\u001a\u0015\u0004E\u0005m\u0014A\t;fgR\u0004\u0016-^:f\u001b&\u0014(o\u001c:U_BL7m\u001d(pi\u000e{g\u000e\u001e:pY2,'\u000fK\u0002$\u0003w\n1\u0005^3tiB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7\u000fU1vg\u0016,\u0005pY3qi&|g\u000eK\u0002%\u0003w\nA\u0004^3tiB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7/\u00112peR,G\rK\u0002&\u0003w\n!\u0006^3tiB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7\u000fS1oI2,7/T;mi&\u0004H.Z#se>\u00148\u000fK\u0002'\u0003w\nq\u0006^3tiB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7\u000fS1oI2,7/\u00168fqB,7\r^3e\u000bb\u001cW\r\u001d;j_:D3aJA>\u0003%\u0019X\r^;q\u001b>\u001c7\u000e\u0006\u0003\u0002R\u0005\u0005\u0006bBARQ\u0001\u0007\u0011QU\u0001\tSNdU-\u00193feB\u0019!)a*\n\u0007\u0005%6IA\u0004C_>dW-\u00198\u0002\u0015I,\u0007\u000f\\1z\u001b>\u001c7.\u0001\u0006wKJLg-_'pG.$b!!\u0015\u00022\u0006m\u0006bBAZU\u0001\u0007\u0011QW\u0001 Kb\u0004Xm\u0019;fI\u0006\u001bG/\u001b<f'\u0016t7o\u001c:J]Z|7-\u0019;j_:\u001c\bc\u0001(\u00028&\u0019\u0011\u0011X(\u0003\u000f%sG/Z4fe\"9\u0011Q\u0018\u0016A\u0002\u0005U\u0016\u0001I3ya\u0016\u001cG/\u001a3J]\u0016\u0013(o\u001c:TK:\u001cxN]%om>\u001c\u0017\r^5p]N\f!\u0002^8MS:\\g*Y7f)\ri\u00151\u0019\u0005\b\u0003\u000b\\\u0003\u0019AAS\u0003\u001dI7o\u0014;iKJ\f\u0001\u0002^8MS:\\\u0017\n\u001a\u000b\u00041\u0006-\u0007bBAcY\u0001\u0007\u0011QU\u0001\fC\u000e$\u0018N^3Ti\u0006$X\r\u0006\u0003\u0002R\u0006]\u0007c\u0001&\u0002T&\u0019\u0011Q[\u001d\u0003+\rcWo\u001d;fe2Kgn\u001b+pa&\u001c7\u000b^1uK\"9\u0011QY\u0017A\u0002\u0005\u0015\u0016a\u00039bkN,Gm\u0015;bi\u0016$\"\"!5\u0002^\u0006}\u00171]At\u0011\u001d\t)M\fa\u0001\u0003KCq!!9/\u0001\u0004\t)+A\u0005mS:\\G*\u001a<fY\"9\u0011Q\u001d\u0018A\u0002\u0005\u0015\u0016A\u0003;pa&\u001cG*\u001a<fY\"9\u0011\u0011\u001e\u0018A\u0002\u0005\u0015\u0016!C<bg\u001a\u000b\u0017\u000e\\3e\u0003-1\u0017-\u001b7fIN#\u0018\r^3\u0015\t\u0005E\u0017q\u001e\u0005\b\u0003\u000b|\u0003\u0019AAS\u0003M\u0001XM\u001c3j]\u001e\u001cFo\u001c9qK\u0012\u001cF/\u0019;f)\u0011\t\t.!>\t\u000f\u0005\u0015\u0007\u00071\u0001\u0002&\u0006a1\u000f^8qa\u0016$7\u000b^1uKR!\u0011\u0011[A~\u0011\u001d\t)-\ra\u0001\u0003K\u000bAC\\3x!\u0006,8/Z'jeJ|'\u000fV8qS\u000e\u001cH\u0003\u0002B\u0001\u0005\u000f\u00012A\u0013B\u0002\u0013\r\u0011)!\u000f\u0002\u0018\u00072,8\u000f^3s\u0019&t7\u000eU1vg\u0016l\u0015N\u001d:peNDqA!\u00033\u0001\u0004\u0011Y!\u0001\u0007mS:\\\u0017j\u001d)bkN,G\rE\u0003C\u0005\u001b\t)+C\u0002\u0003\u0010\r\u0013\u0011BR;oGRLwN\u001c\u0019\u0002\u000fI,hn\u00148dKR1\u0011\u0011\u000bB\u000b\u00053AqAa\u00064\u0001\u0004\u0011\t!\u0001\u0003uCN\\\u0007b\u0002B\u000eg\u0001\u0007!QD\u0001\rKb\u0004Xm\u0019;fI\u0016\u0013(o\u001d\t\u0007\u0005?\u0011yC!\u000e\u000f\t\t\u0005\"1\u0006\b\u0005\u0005G\u0011I#\u0004\u0002\u0003&)\u0019!qE \u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0015b\u0001B\u0017\u0007\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0019\u0005g\u00111aU3r\u0015\r\u0011ic\u0011\t\u0004\u0015\n]\u0012b\u0001B\u001ds\t\u0019B+Y:l\u000bJ\u0014xN]\"pI\u0016\fe\u000eZ'tO\u0006)b.Z<QCV\u001cXmU;dG\u0016\u001c8OR;ukJ,GC\u0001B !\u0015I&\u0011\tB#\u0013\r\u0011\u0019E\u0017\u0002\f\u0017\u000647.\u0019$viV\u0014X\rE\u0002O\u0005\u000fJ1A!\u0013P\u0005\u00111v.\u001b3\u0002+9,w\u000fU1vg\u00164\u0015-\u001b7ve\u00164U\u000f^;sKR!!q\bB(\u0011\u001d\u0011\t&\u000ea\u0001\u0005'\n!!\u001a=\u0011\t\t}!QK\u0005\u0005\u0005/\u0012\u0019DA\u0005UQJ|w/\u00192mK\u0006\u0011R\r\u001f9fGRd\u0015N\\6fIR{\u0007/[2t)\u0011\t\tF!\u0018\t\u000f\t}c\u00071\u0001\u0003b\u0005aA.\u001b8lK\u0012$v\u000e]5dgBA!1\rB6\u0005c\n\tN\u0004\u0003\u0003f\t\u001d\u0004c\u0001B\u0012\u0007&\u0019!\u0011N\"\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011iGa\u001c\u0003\u00075\u000b\u0007OC\u0002\u0003j\r\u0003BAa\u0019\u0003t%\u0019AKa\u001c\u0002%\u0015D\b/Z2u!\u0006,8/Z'jeJ|'o\u001d\u000b\u0007\u0003#\u0012IH!\"\t\u000f\tmt\u00071\u0001\u0003~\u00051a/\u00197vKN\u0004\u0002Ba\u0019\u0003l\tE$q\u0010\t\u0006\u0005\n\u0005%1K\u0005\u0004\u0005\u0007\u001b%AB(qi&|g\u000eC\u0004\u0003\b^\u0002\r!!*\u0002\r\u0015t\u0017M\u00197f\u0001")
public class ClusterLinkPauseMirrorsTest {
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final String otherLinkName;
    private final Uuid otherLinkId = Uuid.randomUuid();
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler(0, 100);
    private final ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final int maxTopicsPerIteration;
    private final Time time = new MockTime();
    private final ClusterLinkRequestQuota quota = UnboundedClusterLinkRequestQuota$.MODULE$;
    private final ClusterLinkMetrics metrics = (ClusterLinkMetrics)Mockito.mock(ClusterLinkMetrics.class);
    private final Sensor activeTaskSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor inErrorTaskSensor = (Sensor)Mockito.mock(Sensor.class);

    private String linkName() {
        return this.linkName;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private String otherLinkName() {
        return this.otherLinkName;
    }

    private Uuid otherLinkId() {
        return this.otherLinkId;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private int maxTopicsPerIteration() {
        return this.maxTopicsPerIteration;
    }

    private Time time() {
        return this.time;
    }

    private ClusterLinkRequestQuota quota() {
        return this.quota;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private Sensor activeTaskSensor() {
        return this.activeTaskSensor;
    }

    private Sensor inErrorTaskSensor() {
        return this.inErrorTaskSensor;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
    }

    @Test
    public void testPauseMirrorTopicsEmpty() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)isPaused -> {
            ClusterLinkPauseMirrorsTest.$anonfun$testPauseMirrorTopicsEmpty$1(this, BoxesRunTime.unboxToBoolean((Object)isPaused));
            return BoxedUnit.UNIT;
        });
        this.verifyMock(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0));
    }

    @Test
    public void testPauseMirrorTopicsPause() {
        scala.collection.immutable.Map linkedTopics = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic"), (Object)this.pausedState(false, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both"), (Object)this.pausedState(false, true, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic-failed"), (Object)this.pausedState(false, false, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link-failed"), (Object)this.pausedState(false, true, false, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both-failed"), (Object)this.pausedState(false, true, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)this.failedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pending-stopped"), (Object)this.pendingStoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stopped"), (Object)this.stoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-active"), (Object)this.activeState(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-topic"), (Object)this.pausedState(true, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-link"), (Object)this.pausedState(true, true, false, false))}));
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)linkedTopics);
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic-failed"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)None$.MODULE$)}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> true;
        Object var2_2 = null;
        this.runOnce(new ClusterLinkPauseMirrors(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.time(), this.quota(), this.metrics(), this.maxTopicsPerIteration(), 10, 10), (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
        this.verifyMock(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0));
    }

    @Test
    public void testPauseMirrorTopicsUnpause() {
        scala.collection.immutable.Map linkedTopics = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic"), (Object)this.pausedState(false, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both"), (Object)this.pausedState(false, true, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic-failed"), (Object)this.pausedState(false, false, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link-failed"), (Object)this.pausedState(false, true, false, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both-failed"), (Object)this.pausedState(false, true, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)this.failedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pending-stopped"), (Object)this.pendingStoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stopped"), (Object)this.stoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-active"), (Object)this.activeState(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-topic"), (Object)this.pausedState(true, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-link"), (Object)this.pausedState(true, true, false, false))}));
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)linkedTopics);
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link-failed"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both-failed"), (Object)None$.MODULE$)}))), false);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> false;
        Object var2_2 = null;
        this.runOnce(new ClusterLinkPauseMirrors(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.time(), this.quota(), this.metrics(), this.maxTopicsPerIteration(), 10, 10), (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
        this.verifyMock(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0));
    }

    @Test
    public void testPauseMirrorTopicsNotController() {
        this.setupMock(false);
        Function0 & Serializable newPauseMirrorTopics_linkIsPaused = (Function0 & Serializable)() -> {
            throw new RuntimeException("unexpected");
        };
        Object var1_1 = null;
        this.runOnce(new ClusterLinkPauseMirrors(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.time(), this.quota(), this.metrics(), this.maxTopicsPerIteration(), 10, 10), (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
        this.verifyMock(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(0));
    }

    @Test
    public void testPauseMirrorTopicsPauseException() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)None$.MODULE$)}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.pausedState(false, true, false, false))}))));
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> true;
        Object var1_1 = null;
        this.runOnce(new ClusterLinkPauseMirrors(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.time(), this.quota(), this.metrics(), this.maxTopicsPerIteration(), 10, 10), (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
        this.verifyMock(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0));
    }

    @Test
    public void testPauseMirrorTopicsAborted() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.activeState(false))}))));
        IntRef check = IntRef.create((int)0);
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> {
            ++check$1.elem;
            return check$1.elem < 3;
        };
        Object var2_2 = null;
        this.runOnce(new ClusterLinkPauseMirrors(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.time(), this.quota(), this.metrics(), this.maxTopicsPerIteration(), 10, 10), (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Encountered error while pausing mirror topics"), (List)Nil$.MODULE$));
        this.verifyMock(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
    }

    @Test
    public void testPauseMirrorTopicsHandlesMultipleErrors() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)new Some((Object)new TimeoutException(""))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> true;
        Object var1_1 = null;
        this.runOnce(new ClusterLinkPauseMirrors(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.time(), this.quota(), this.metrics(), this.maxTopicsPerIteration(), 10, 10), (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Encountered error while pausing mirror topics"), (List)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Encountered error while pausing mirror topics"), (List)Nil$.MODULE$)));
        this.verifyMock(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(2));
    }

    @Test
    public void testPauseMirrorTopicsHandlesUnexpectedException() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.activeState(false))}))));
        AlterMirrorOp pauseOp = AlterMirrorOp.PAUSE_LINK;
        scala.collection.immutable.Map ops = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)pauseOp)}));
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)ops).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{new NullPointerException("NPE")});
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> true;
        Object var5_3 = null;
        ClusterLinkPauseMirrors task = new ClusterLinkPauseMirrors(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.time(), this.quota(), this.metrics(), this.maxTopicsPerIteration(), 10, 10);
        ExecutionException ex = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> task.runOnce().get(5L, TimeUnit.SECONDS));
        Assertions.assertEquals(NullPointerException.class, ex.getCause().getClass());
        Assertions.assertFalse((boolean)task.isShuttingDown());
        Assertions.assertEquals((Object)new Some((Object)new TaskDescription((TaskState)InErrorTaskState$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Failed to run the pause mirror topics task for an unknown reason."), (List)Nil$.MODULE$))), (Object)task.taskDescription());
        this.verifyMock(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
    }

    private void setupMock(boolean isLeader) {
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.reset((Object[])new ClusterLinkMetrics[]{this.metrics()});
        Mockito.reset((Object[])new Sensor[]{this.activeTaskSensor()});
        Mockito.reset((Object[])new Sensor[]{this.inErrorTaskSensor()});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isLeader));
        Mockito.when((Object)this.metrics().clusterLinkTaskActiveSensor((TaskType)ClusterLinkPauseMirrorTopicsTaskType$.MODULE$)).thenReturn((Object)this.activeTaskSensor());
        Mockito.when((Object)this.metrics().clusterLinkTaskInErrorSensor((TaskType)ClusterLinkPauseMirrorTopicsTaskType$.MODULE$, (TaskErrorCode)InternalTaskErrorCode$.MODULE$)).thenReturn((Object)this.inErrorTaskSensor());
    }

    private void replayMock() {
    }

    private void verifyMock(Integer expectedActiveSensorInvocations, Integer expectedInErrorSensorInvocations) {
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.atLeastOnce())).isLinkCoordinator(ArgumentMatchers.anyString());
        ((Sensor)Mockito.verify((Object)this.activeTaskSensor(), (VerificationMode)Mockito.times((int)Predef$.MODULE$.Integer2int(expectedActiveSensorInvocations)))).record();
        ((Sensor)Mockito.verify((Object)this.inErrorTaskSensor(), (VerificationMode)Mockito.times((int)Predef$.MODULE$.Integer2int(expectedInErrorSensorInvocations)))).record();
    }

    private String toLinkName(boolean isOther) {
        if (isOther) {
            return this.otherLinkName();
        }
        return this.linkName();
    }

    private Uuid toLinkId(boolean isOther) {
        if (isOther) {
            return this.otherLinkId();
        }
        return this.linkId();
    }

    private ClusterLinkTopicState activeState(boolean isOther) {
        return new ClusterLinkTopicState.Mirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), 111111111L, (Seq)Seq$.MODULE$.empty());
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkTopicState pausedState(boolean isOther, boolean linkLevel, boolean topicLevel, boolean wasFailed) {
        void var5_6;
        MirrorTopicError mirrorTopicError;
        TopicLinkFailedMirror$ topicLinkFailedMirror$;
        if (wasFailed) {
            topicLinkFailedMirror$ = TopicLinkFailedMirror$.MODULE$;
            mirrorTopicError = MirrorTopicError.SOURCE_TOPIC_ID_CHANGED;
        } else {
            topicLinkFailedMirror$ = TopicLinkMirror$.MODULE$;
            mirrorTopicError = MirrorTopicError.NO_ERROR;
        }
        MirrorTopicError mirrorTopicError2 = mirrorTopicError;
        TopicLinkState prevState = (TopicLinkState)topicLinkFailedMirror$;
        return new ClusterLinkTopicState.PausedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), linkLevel, topicLevel, (TopicLinkState)var5_6, null, mirrorTopicError2, 22222222L, (Seq)Seq$.MODULE$.empty());
    }

    private ClusterLinkTopicState failedState(boolean isOther) {
        return new ClusterLinkTopicState.FailedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, 33333333L);
    }

    private ClusterLinkTopicState pendingStoppedState(boolean isOther) {
        return new ClusterLinkTopicState.PendingStoppedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), false, 44444444L);
    }

    private ClusterLinkTopicState stoppedState(boolean isOther) {
        return new ClusterLinkTopicState.StoppedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), (Seq)package$.MODULE$.Seq().empty(), 555555555L);
    }

    private ClusterLinkPauseMirrors newPauseMirrorTopics(Function0<Object> linkIsPaused) {
        return new ClusterLinkPauseMirrors(this.linkId(), this.linkName(), linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.time(), this.quota(), this.metrics(), this.maxTopicsPerIteration(), 10, 10);
    }

    private void runOnce(ClusterLinkPauseMirrors task, scala.collection.immutable.Seq<TaskErrorCodeAndMsg> expectedErrs) {
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)task.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)task.isShuttingDown());
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertEquals(expectedErrs, (Object)result.errs());
    }

    private KafkaFuture<Void> newPauseSuccessFuture() {
        return KafkaFuture.completedFuture(null);
    }

    private KafkaFuture<Void> newPauseFailureFuture(Throwable ex) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(ex);
        return future;
    }

    private void expectLinkedTopics(scala.collection.immutable.Map<String, ClusterLinkTopicState> linkedTopics) {
        TrieMap map = new TrieMap();
        map.$plus$plus$eq(linkedTopics);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)map.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private void expectPauseMirrors(scala.collection.immutable.Map<String, Option<Throwable>> values, boolean enable) {
        AlterMirrorOp pauseOp = enable ? AlterMirrorOp.PAUSE_LINK : AlterMirrorOp.RESUME_LINK;
        scala.collection.immutable.Map ops = ((IterableOnceOps)values.keys().map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)pauseOp))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map results = (scala.collection.immutable.Map)values.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String t = (String)x0$1._1();
                Option option = (Option)x0$1._2();
                if (option instanceof Some) {
                    Throwable ex = (Throwable)((Some)option).value();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), this.newPauseFailureFuture(ex));
                }
            }
            if (x0$1 != null) {
                String t = (String)x0$1._1();
                Option option = (Option)x0$1._2();
                if (None$.MODULE$.equals(option)) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), (Object)KafkaFuture.completedFuture(null));
                }
            }
            throw new MatchError(x0$1);
        });
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)ops).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)new AlterMirrorsResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)results).asJava()));
    }

    public static final /* synthetic */ void $anonfun$testPauseMirrorTopicsEmpty$1(ClusterLinkPauseMirrorsTest $this, boolean isPaused) {
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> isPaused;
        Object var3_2 = null;
        ClusterLinkPauseMirrors pauseMirrorTopics = new ClusterLinkPauseMirrors($this.linkId(), $this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, $this.scheduler(), $this.metadataManager(), (Function0 & Serializable)() -> this.admin(), $this.time(), $this.quota(), $this.metrics(), $this.maxTopicsPerIteration(), 10, 10);
        $this.runOnce(pauseMirrorTopics, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
    }

    public ClusterLinkPauseMirrorsTest() {
        this.linkName = "link-name";
        this.otherLinkName = "other-link-name";
        this.maxTopicsPerIteration = 5;
    }
}

