/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.UnboundedClusterLinkRequestQuota$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNonBatchingAdmin;
import kafka.server.link.ClusterLinkRepairMirror;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ConnectionMode;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tMg\u0001\u0002\u001b6\u0001qBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013%\u0001\n\u0003\u0004R\u0001\u0001\u0006I!\u0013\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0011\u0019y\u0006\u0001)A\u0005)\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007B\u00025\u0001A\u0003%!\rC\u0004j\u0001\t\u0007I\u0011\u00016\t\r9\u0004\u0001\u0015!\u0003l\u0011\u001dy\u0007A1A\u0005\nADa\u0001\u001e\u0001!\u0002\u0013\t\bbB;\u0001\u0005\u0004%IA\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B<\t\u000fm\u0004!\u0019!C\u0005y\"9\u00111\u0002\u0001!\u0002\u0013i\b\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011!\t9\u0002\u0001Q\u0001\n\u0005E\u0001\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011!\t\u0019\u0003\u0001Q\u0001\n\u0005u\u0001\"CA\u0013\u0001\t\u0007I\u0011BA\u0014\u0011!\t)\u0004\u0001Q\u0001\n\u0005%\u0002\u0002CA\u001c\u0001\t\u0007I\u0011\u0002%\t\u000f\u0005e\u0002\u0001)A\u0005\u0013\"A\u00111\b\u0001C\u0002\u0013%\u0001\nC\u0004\u0002>\u0001\u0001\u000b\u0011B%\t\u0011\u0005}\u0002A1A\u0005\n!Cq!!\u0011\u0001A\u0003%\u0011\nC\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002F!A\u00111\u000f\u0001!\u0002\u0013\t9\u0005C\u0005\u0002v\u0001\u0011\r\u0011\"\u0003\u0002x!A\u00111\u0010\u0001!\u0002\u0013\tI\bC\u0005\u0002~\u0001\u0011\r\u0011\"\u0003\u0002\u0000!A\u0011Q\u0013\u0001!\u0002\u0013\t\t\tC\u0006\u0002\u0018\u0002\u0001\r\u00111A\u0005\n\u0005e\u0005bCAQ\u0001\u0001\u0007\t\u0019!C\u0005\u0003GC1\"a,\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001c\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0006bBAf\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003+\u0004A\u0011AAZ\u0011\u001d\ty\u000e\u0001C\u0001\u0003gCq!a9\u0001\t\u0003\t\u0019\fC\u0004\u0002h\u0002!I!!;\t\u000f\t=\u0003\u0001\"\u0003\u0003R!I!q\u000b\u0001\u0012\u0002\u0013%!\u0011\f\u0005\b\u0005_\u0002A\u0011\u0002B9\u0011\u001d\u0011y\b\u0001C\u0005\u0005\u0003CqA!\"\u0001\t\u0013\u00119\tC\u0004\u0003\"\u0002!\tAa)\t\u000f\t\u0015\u0006\u0001\"\u0003\u0003(\"9!q\u0016\u0001\u0005\n\tE\u0006b\u0002Bc\u0001\u0011%!q\u0019\u0002\u001c\u00072,8\u000f^3s\u0019&t7NU3qC&\u0014X*\u001b:s_J$Vm\u001d;\u000b\u0005Y:\u0014\u0001\u00027j].T!\u0001O\u001d\u0002\rM,'O^3s\u0015\u0005Q\u0014!B6bM.\f7\u0001A\n\u0003\u0001u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001F!\t1\u0005!D\u00016\u0003!a\u0017N\\6OC6,W#A%\u0011\u0005){U\"A&\u000b\u00051k\u0015\u0001\u00027b]\u001eT\u0011AT\u0001\u0005U\u00064\u0018-\u0003\u0002Q\u0017\n11\u000b\u001e:j]\u001e\f\u0011\u0002\\5oW:\u000bW.\u001a\u0011\u0002\r1Lgn[%e+\u0005!\u0006CA+^\u001b\u00051&BA,Y\u0003\u0019\u0019w.\\7p]*\u0011!(\u0017\u0006\u00035n\u000ba!\u00199bG\",'\"\u0001/\u0002\u0007=\u0014x-\u0003\u0002_-\n!Q+^5e\u0003\u001da\u0017N\\6JI\u0002\n\u0001\u0002\\5oW\u0012\u000bG/Y\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011Q-O\u0001\u0003u.L!a\u001a3\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0011\u0002\\5oW\u0012\u000bG/\u0019\u0011\u0002\u000f5,GO]5dgV\t1\u000e\u0005\u0002GY&\u0011Q.\u000e\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003%\u00198\r[3ek2,'/F\u0001r!\t1%/\u0003\u0002tk\t!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u00035\u0019G.[3oi6\u000bg.Y4feV\tq\u000f\u0005\u0002Gq&\u0011\u00110\u000e\u0002\u001d\u00072,8\u000f^3s\u0019&t7\u000eR3ti\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s\u00039\u0019G.[3oi6\u000bg.Y4fe\u0002\n\u0011\u0002Z3ti\u0006#W.\u001b8\u0016\u0003u\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tQ!\u00193nS:T1!!\u0002Y\u0003\u001d\u0019G.[3oiNL1!!\u0003\u0000\u00059\u0019uN\u001c4mk\u0016tG/\u00113nS:\f!\u0002Z3ti\u0006#W.\u001b8!\u0003=awnY1m\u0005\u0006$8\r[!e[&tWCAA\t!\r1\u00151C\u0005\u0004\u0003+)$aG\"mkN$XM\u001d'j].tuN\u001c\"bi\u000eD\u0017N\\4BI6Lg.\u0001\tm_\u000e\fGNQ1uG\"\fE-\\5oA\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0006\u0002\u0002\u001eA\u0019a)a\b\n\u0007\u0005\u0005RG\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\tnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA\u0005!A/[7f+\t\tI\u0003\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\tyCV\u0001\u0006kRLGn]\u0005\u0005\u0003g\tiC\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u0002;pa&\u001c\u0017'A\u0004u_BL7-\r\u0011\u0002\rQ|\u0007/[23\u0003\u001d!x\u000e]5de\u0001\na\u0001^8qS\u000e\u001c\u0014a\u0002;pa&\u001c7\u0007I\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001cXCAA$!\u001d\tI%a\u0015J\u0003/j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\nS6lW\u000f^1cY\u0016T1!!\u0015@\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003+\nYEA\u0002NCB\u0004b!!\u0017\u0002h\u00055d\u0002BA.\u0003G\u00022!!\u0018@\u001b\t\tyFC\u0002\u0002bm\na\u0001\u0010:p_Rt\u0014bAA3\u007f\u00051\u0001K]3eK\u001aLA!!\u001b\u0002l\t\u00191+\u001a;\u000b\u0007\u0005\u0015t\bE\u0002V\u0003_J1!!\u001dW\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0002]1si&$\u0018n\u001c8tA\u0005q1o\\;sG\u0016$v\u000e]5d\u0013\u0012\u001cXCAA=!\u0019\tI%a\u0015J)\u0006y1o\\;sG\u0016$v\u000e]5d\u0013\u0012\u001c\b%\u0001\u0007nSJ\u0014xN]*uCR,7/\u0006\u0002\u0002\u0002BA\u00111QAE\u0003\u0017\u000by)\u0004\u0002\u0002\u0006*!\u0011qQA(\u0003\u001diW\u000f^1cY\u0016LA!!\u0016\u0002\u0006B!\u0011\u0011LAG\u0013\r\u0001\u00161\u000e\t\u0004\r\u0006E\u0015bAAJk\t)2\t\\;ti\u0016\u0014H*\u001b8l)>\u0004\u0018nY*uCR,\u0017!D7jeJ|'o\u0015;bi\u0016\u001c\b%\u0001\u0007sKB\f\u0017N]'jeJ|'/\u0006\u0002\u0002\u001cB\u0019a)!(\n\u0007\u0005}UGA\fDYV\u001cH/\u001a:MS:\\'+\u001a9bSJl\u0015N\u001d:pe\u0006\u0001\"/\u001a9bSJl\u0015N\u001d:pe~#S-\u001d\u000b\u0005\u0003K\u000bY\u000bE\u0002?\u0003OK1!!+@\u0005\u0011)f.\u001b;\t\u0013\u000556%!AA\u0002\u0005m\u0015a\u0001=%c\u0005i!/\u001a9bSJl\u0015N\u001d:pe\u0002\nQa]3u+B$\"!!*)\u0007\u0015\n9\f\u0005\u0003\u0002:\u0006\u001dWBAA^\u0015\u0011\ti,a0\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002B\u0006\r\u0017a\u00026va&$XM\u001d\u0006\u0004\u0003\u000b\\\u0016!\u00026v]&$\u0018\u0002BAe\u0003w\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u0014\u0002PB!\u0011\u0011XAi\u0013\u0011\t\u0019.a/\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\u0005;fgR\u0014V\r]1je6K'O]8sQ\r9\u0013\u0011\u001c\t\u0005\u0003s\u000bY.\u0003\u0003\u0002^\u0006m&\u0001\u0002+fgR\f\u0011\u0004^3tiJ+\u0007\u000f\\5dCN#\u0018\r^;t\r\u0006LG.\u001e:fg\"\u001a\u0001&!7\u0002/Q,7\u000f^!mi\u0016\u0014X*\u001b:s_J4\u0015-\u001b7ve\u0016\u001c\bfA\u0015\u0002Z\u00069!/\u001e8P]\u000e,GCCAv\u0003s\fiP!\u0001\u0003FA!\u0011Q^Az\u001d\r1\u0015q^\u0005\u0004\u0003c,\u0014\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0003\u0003\u0002v\u0006](A\u0003+bg.\u0014Vm];mi*\u0019\u0011\u0011_\u001b\t\u000f\u0005m(\u00061\u0001\u0002\f\u0006)Ao\u001c9jG\"9\u0011q \u0016A\u0002\u0005]\u0013a\u0005:f[\u0006Lg.\u001b8h!\u0006\u0014H/\u001b;j_:\u001c\bb\u0002B\u0002U\u0001\u0007!QA\u0001\te\u0016\u0004H.[2bgB1!q\u0001B\t\u0005/qAA!\u0003\u0003\u000e9!\u0011Q\fB\u0006\u0013\u0005\u0001\u0015b\u0001B\b\u007f\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\n\u0005+\u00111aU3r\u0015\r\u0011ya\u0010\t\u0005\u00053\u0011yD\u0004\u0003\u0003\u001c\teb\u0002\u0002B\u000f\u0005gqAAa\b\u000309!!\u0011\u0005B\u0017\u001d\u0011\u0011\u0019Ca\u000b\u000f\t\t\u0015\"\u0011\u0006\b\u0005\u0003;\u00129#C\u0001]\u0013\tQ6,\u0003\u0002;3&\u0011q\u000bW\u0005\u0004\u0005c1\u0016a\u0002:fa2L7-Y\u0005\u0005\u0005k\u00119$A\u0007SKBd\u0017nY1Ti\u0006$Xo\u001d\u0006\u0004\u0005c1\u0016\u0002\u0002B\u001e\u0005{\t!\"T5se>\u0014\u0018J\u001c4p\u0015\u0011\u0011)Da\u000e\n\t\t\u0005#1\t\u0002\u0006'R\fG/\u001a\u0006\u0005\u0005w\u0011i\u0004C\u0004\u0003H)\u0002\rA!\u0013\u0002\u001dI,\u0007/Y5s\u0007>l\u0007\u000f\\3uKB\u0019aHa\u0013\n\u0007\t5sHA\u0004C_>dW-\u00198\u0002\u0015M,G/\u001e9N_\u000e\\7\u000f\u0006\u0003\u0002&\nM\u0003\"\u0003B+WA\u0005\t\u0019\u0001B%\u0003EI7\u000fT5oW\u000e{wN\u001d3j]\u0006$xN]\u0001\u0015g\u0016$X\u000f]'pG.\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tm#\u0006\u0002B%\u0005;Z#Aa\u0018\u0011\t\t\u0005$1N\u0007\u0003\u0005GRAA!\u001a\u0003h\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005Sz\u0014AC1o]>$\u0018\r^5p]&!!Q\u000eB2\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogR1\u0011q\u000bB:\u0005kBq!a?.\u0001\u0004\tY\tC\u0004\u0003x5\u0002\rA!\u001f\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t!\rq$1P\u0005\u0004\u0005{z$aA%oi\u0006\u0019\u0002/\u001a8eS:<'+\u001a9bSJ\u001cF/\u0019;fgR!!Q\u0001BB\u0011\u001d\tYP\fa\u0001\u0003\u0017\u000bAC]3qY&\u001c\u0017m\u0015;biV\u001ch)\u001e;ve\u0016\u001cH\u0003\u0002BE\u0005?\u0003\u0002Ba#\u0003\u0012\u00065$1S\u0007\u0003\u0005\u001bS1Aa$N\u0003\u0011)H/\u001b7\n\t\u0005U#Q\u0012\t\u0006+\nU%\u0011T\u0005\u0004\u0005/3&aC&bM.\fg)\u001e;ve\u0016\u00042A BN\u0013\r\u0011ij \u0002\u0010!\u0006\u0014H/\u001b;j_:\u0014Vm];mi\"9\u00111`\u0018A\u0002\u0005-\u0015\u0001\u00078foB\u000b'\u000f^5uS>t'+Z:vYR4U\u000f^;sKV\u0011!1S\u0001\u0016G>l\u0007\u000f\\3uKJ+\u0007\u000f\\5dCN#\u0018\r^;t)\u0019\t)K!+\u0003.\"9!1V\u0019A\u0002\t%\u0015a\u00024viV\u0014Xm\u001d\u0005\b\u0005\u0007\t\u0004\u0019\u0001B\u0003\u00035\u0011X\r\u001d7jG\u0006\u001cF/\u0019;vgR!!1\u0017Ba!\u0019\u0011YI!.\u0003:&!!q\u0017BG\u0005\u0011a\u0015n\u001d;\u0011\t\tm&QX\u0007\u0003\u0005oIAAa0\u00038\ti!+\u001a9mS\u000e\f7\u000b^1ukNDqAa13\u0001\u0004\u00119\"A\u0003ti\u0006$X-A\u0006va\u0012\fG/Z*uCR,GCBAS\u0005\u0013\u0014Y\rC\u0004\u0002|N\u0002\r!a#\t\u000f\t\r7\u00071\u0001\u0003NB)aHa4\u0002\u0010&\u0019!\u0011[ \u0003\r=\u0003H/[8o\u0001")
public class ClusterLinkRepairMirrorTest {
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final ClusterLinkData linkData = new ClusterLinkData(this.linkName(), this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics(this.linkData().linkName(), this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, false, (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$, false);
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler(0, 100);
    private final ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
    private final ConfluentAdmin destAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkNonBatchingAdmin localBatchAdmin = new ClusterLinkNonBatchingAdmin((Function0 & Serializable)() -> this.destAdmin());
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final Time time = new MockTime();
    private final String topic1;
    private final String topic2;
    private final String topic3;
    private final scala.collection.immutable.Map<String, scala.collection.immutable.Set<TopicPartition>> partitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), this.topicPartitions(this.topic1(), 2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2()), this.topicPartitions(this.topic2(), 20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic3()), this.topicPartitions(this.topic3(), 30))}));
    private final scala.collection.immutable.Map<String, Uuid> sourceTopicIds = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2()), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic3()), (Object)Uuid.randomUuid())}));
    private final scala.collection.mutable.Map<String, ClusterLinkTopicState> mirrorStates = (scala.collection.mutable.Map)Map$.MODULE$.empty();
    private ClusterLinkRepairMirror repairMirror;

    private String linkName() {
        return this.linkName;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    private ClusterLinkNonBatchingAdmin localBatchAdmin() {
        return this.localBatchAdmin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private Time time() {
        return this.time;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    private String topic3() {
        return this.topic3;
    }

    private scala.collection.immutable.Map<String, scala.collection.immutable.Set<TopicPartition>> partitions() {
        return this.partitions;
    }

    private scala.collection.immutable.Map<String, Uuid> sourceTopicIds() {
        return this.sourceTopicIds;
    }

    private scala.collection.mutable.Map<String, ClusterLinkTopicState> mirrorStates() {
        return this.mirrorStates;
    }

    private ClusterLinkRepairMirror repairMirror() {
        return this.repairMirror;
    }

    private void repairMirror_$eq(ClusterLinkRepairMirror x$1) {
        this.repairMirror = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
        this.setupMocks(true);
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
        this.repairMirror().shutdown();
    }

    @Test
    public void testRepairMirror() {
        Some state = new Some((Object)new ClusterLinkTopicState.PendingRepairMirror(this.linkName(), this.linkId(), (Uuid)this.sourceTopicIds().apply((Object)this.topic1()), MirrorTopicError.UNSUPPORTED_MESSAGE_FORMAT, Time.SYSTEM.milliseconds()));
        this.updateState(this.topic1(), (Option<ClusterLinkTopicState>)state);
        this.repairMirror_$eq(new ClusterLinkRepairMirror(this.topic1(), this.clientManager(), (ClusterLinkBatchAdmin)this.localBatchAdmin(), this.time(), (ClusterLinkRequestQuota)UnboundedClusterLinkRequestQuota$.MODULE$, 100));
        ClusterLinkScheduler.TaskResult result = this.runOnce(this.topic1(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)this.partitions().apply((Object)this.topic1())), (Seq<ReplicaStatus.MirrorInfo.State>)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.FAILED, (List)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.FAILED, (List)Nil$.MODULE$)), false);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)result.errs());
        result = this.runOnce(this.topic1(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)this.partitions().apply((Object)this.topic1())), (Seq<ReplicaStatus.MirrorInfo.State>)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.PENDING_REPAIR, (List)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.FAILED, (List)Nil$.MODULE$)), false);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)result.errs());
        this.runOnce(this.topic1(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic1(), 1)}))), (Seq<ReplicaStatus.MirrorInfo.State>)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.PENDING_REPAIR, (List)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.PENDING_REPAIR, (List)Nil$.MODULE$)), true);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)result.errs());
    }

    @Test
    public void testReplicaStatusFailures() {
        Some state = new Some((Object)new ClusterLinkTopicState.PendingRepairMirror(this.linkName(), this.linkId(), (Uuid)this.sourceTopicIds().apply((Object)this.topic1()), MirrorTopicError.UNSUPPORTED_MESSAGE_FORMAT, Time.SYSTEM.milliseconds()));
        this.updateState(this.topic1(), (Option<ClusterLinkTopicState>)state);
        this.repairMirror_$eq(new ClusterLinkRepairMirror(this.topic1(), this.clientManager(), (ClusterLinkBatchAdmin)this.localBatchAdmin(), this.time(), (ClusterLinkRequestQuota)UnboundedClusterLinkRequestQuota$.MODULE$, 100));
        java.util.Map<TopicPartition, KafkaFuture<PartitionResult>> statusFutures = this.replicaStatusFutures(this.topic1());
        Mockito.when((Object)this.destAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().apply((Object)this.topic1())).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)new ReplicaStatusResult(statusFutures));
        ((ConfluentAdmin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.never())).alterMirrors((java.util.Map)ArgumentMatchers.any(), (AlterMirrorsOptions)ArgumentMatchers.any());
        KafkaFuture future = this.repairMirror().runOnce();
        statusFutures.values().forEach(f -> ((KafkaFutureImpl)f).completeExceptionally((Throwable)new RuntimeException("Test exception")));
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)future.get(15L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Failed to get replicas status of mirror partitions for an unknown reason."), (List)Nil$.MODULE$), (Object)result.errs());
        this.runOnce(this.topic1(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)this.partitions().apply((Object)this.topic1())), (Seq<ReplicaStatus.MirrorInfo.State>)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.FAILED, (List)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.FAILED, (List)Nil$.MODULE$)), false);
        this.runOnce(this.topic1(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)this.partitions().apply((Object)this.topic1())), (Seq<ReplicaStatus.MirrorInfo.State>)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.PENDING_REPAIR, (List)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.PENDING_REPAIR, (List)Nil$.MODULE$)), true);
    }

    @Test
    public void testAlterMirrorFailures() {
        Some state = new Some((Object)new ClusterLinkTopicState.PendingRepairMirror(this.linkName(), this.linkId(), (Uuid)this.sourceTopicIds().apply((Object)this.topic1()), MirrorTopicError.UNSUPPORTED_MESSAGE_FORMAT, Time.SYSTEM.milliseconds()));
        this.updateState(this.topic1(), (Option<ClusterLinkTopicState>)state);
        this.repairMirror_$eq(new ClusterLinkRepairMirror(this.topic1(), this.clientManager(), (ClusterLinkBatchAdmin)this.localBatchAdmin(), this.time(), (ClusterLinkRequestQuota)UnboundedClusterLinkRequestQuota$.MODULE$, 100));
        Seq<ReplicaStatus.MirrorInfo.State> replicas = this.pendingRepairStates(this.topic1());
        java.util.Map<TopicPartition, KafkaFuture<PartitionResult>> statusFutures = this.replicaStatusFutures(this.topic1());
        this.completeReplicaStatus(statusFutures, replicas);
        Mockito.when((Object)this.destAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().apply((Object)this.topic1())).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)new ReplicaStatusResult(statusFutures));
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        AlterMirrorsResult alterResult = new AlterMirrorsResult(Collections.singletonMap(this.topic1(), alterFuture));
        Mockito.when((Object)this.destAdmin().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(this.topic1(), AlterMirrorOp.COMPLETE_REPAIR)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)alterResult);
        KafkaFuture future = this.repairMirror().runOnce();
        alterFuture.completeExceptionally((Throwable)new RuntimeException("Test exception"));
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)future.get(15L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Failed to complete repair of failed mirror topic mirror-topic1"), (List)Nil$.MODULE$), (Object)result.errs());
        this.runOnce(this.topic1(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)this.partitions().apply((Object)this.topic1())), replicas, true);
    }

    private ClusterLinkScheduler.TaskResult runOnce(String topic, scala.collection.immutable.Set<TopicPartition> remainingPartitions, Seq<ReplicaStatus.MirrorInfo.State> replicas, boolean repairComplete) {
        None$ none$;
        java.util.Map<TopicPartition, KafkaFuture<PartitionResult>> statusFutures = this.replicaStatusFutures(topic);
        Mockito.when((Object)this.destAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava(remainingPartitions).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)new ReplicaStatusResult(statusFutures));
        if (repairComplete) {
            KafkaFutureImpl alterFuture2 = new KafkaFutureImpl();
            AlterMirrorsResult alterResult = new AlterMirrorsResult(Collections.singletonMap(topic, alterFuture2));
            Mockito.when((Object)this.destAdmin().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(topic, AlterMirrorOp.COMPLETE_REPAIR)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)alterResult).thenThrow(new Throwable[]{new RuntimeException("Alter mirrors invoked multiple times")});
            none$ = new Some((Object)alterFuture2);
        } else {
            ((ConfluentAdmin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.never())).alterMirrors((java.util.Map)ArgumentMatchers.any(), (AlterMirrorsOptions)ArgumentMatchers.any());
            none$ = None$.MODULE$;
        }
        None$ alterMirrorFuture = none$;
        KafkaFuture future = this.repairMirror().runOnce();
        Assertions.assertFalse((boolean)future.isDone());
        this.completeReplicaStatus(statusFutures, replicas);
        alterMirrorFuture.foreach((Function1 & Serializable)alterFuture -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkRepairMirrorTest.$anonfun$runOnce$1(future, alterFuture)));
        ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)future.get(15L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)result.completed());
        return result;
    }

    private void setupMocks(boolean isLinkCoordinator) {
        Mockito.reset((Object[])new ConfluentAdmin[]{this.destAdmin()});
        Mockito.reset((Object[])new ClusterLinkDestClientManager[]{this.clientManager()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.when((Object)this.clientManager().metadataManager()).thenReturn((Object)this.metadataManager());
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().linkData()).thenReturn((Object)this.linkData());
        Mockito.when((Object)this.clientManager().metrics()).thenReturn((Object)this.metrics());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(this.linkName()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isLinkCoordinator));
        ArgumentCaptor capturedTopics = ArgumentCaptor.forClass(scala.collection.immutable.Set.class);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)capturedTopics.capture())).thenAnswer(x$2 -> ((IterableOnceOps)((IterableOps)((scala.collection.immutable.Set)capturedTopics.getValue()).map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), this.mirrorStates().get(topic).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkRepairMirrorTest.$anonfun$setupMocks$3(x$3)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Mockito.when((Object)this.metadataManager().topicPartitions(ArgumentMatchers.anyString())).thenAnswer(inv -> (scala.collection.immutable.Set)this.partitions().apply(inv.getArgument(0)));
    }

    private boolean setupMocks$default$1() {
        return true;
    }

    private scala.collection.immutable.Set<TopicPartition> topicPartitions(String topic, int numPartitions) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable)i -> ClusterLinkRepairMirrorTest.$anonfun$topicPartitions$1(topic, BoxesRunTime.unboxToInt((Object)i))).toSet();
    }

    private Seq<ReplicaStatus.MirrorInfo.State> pendingRepairStates(String topic) {
        return (Seq)((IterableOnceOps)this.partitions().apply((Object)topic)).toSeq().map((Function1 & Serializable)x$4 -> ReplicaStatus.MirrorInfo.State.PENDING_REPAIR);
    }

    private java.util.Map<TopicPartition, KafkaFuture<PartitionResult>> replicaStatusFutures(String topic) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)((IterableOps)this.partitions().apply((Object)topic)).map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), this.newPartitionResultFuture()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public KafkaFuture<PartitionResult> newPartitionResultFuture() {
        return new KafkaFutureImpl();
    }

    private void completeReplicaStatus(java.util.Map<TopicPartition, KafkaFuture<PartitionResult>> futures, Seq<ReplicaStatus.MirrorInfo.State> replicas) {
        futures.forEach((tp, future) -> {
            PartitionResult result = new PartitionResult(1, 1, this.replicaStatus((ReplicaStatus.MirrorInfo.State)replicas.apply(tp.partition())));
            ((KafkaFutureImpl)future).complete((Object)result);
            Assertions.assertTrue((boolean)future.isDone());
        });
    }

    private java.util.List<ReplicaStatus> replicaStatus(ReplicaStatus.MirrorInfo.State state) {
        ReplicaStatus.MirrorInfo mirrorInfo = new ReplicaStatus.MirrorInfo(state, -1L, -1L);
        return Collections.singletonList(new ReplicaStatus(0, true, false, true, false, false, 10L, 20L, 0L, 0L, Optional.of(this.linkName()), Optional.of(mirrorInfo), Optional.of("pull"), OptionalLong.of(-1L)));
    }

    private void updateState(String topic, Option<ClusterLinkTopicState> state) {
        if (state instanceof Some) {
            ClusterLinkTopicState mirrorState = (ClusterLinkTopicState)((Some)state).value();
            this.mirrorStates().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)mirrorState));
            return;
        }
        if (None$.MODULE$.equals(state)) {
            this.mirrorStates().remove((Object)topic);
            return;
        }
        throw new MatchError(state);
    }

    public static final /* synthetic */ boolean $anonfun$runOnce$1(KafkaFuture future$1, KafkaFutureImpl alterFuture) {
        Assertions.assertFalse((boolean)future$1.isDone());
        return alterFuture.complete(null);
    }

    public static final /* synthetic */ boolean $anonfun$setupMocks$3(Tuple2 x$3) {
        return x$3._2() == null;
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(String topic$1, int i) {
        return new TopicPartition(topic$1, i);
    }

    public ClusterLinkRepairMirrorTest() {
        this.linkName = "link-name";
        this.topic1 = "mirror-topic1";
        this.topic2 = "mirror-topic2";
        this.topic3 = "mirror-topic3";
    }
}

