/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import kafka.server.UnboundedClusterLinkRequestQuota$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNonBatchingAdmin;
import kafka.server.link.ClusterLinkRepairMirrors;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTaskManager;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ConnectionMode;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkState;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t5h\u0001B\u001d;\u0001\u0005CQ\u0001\u0013\u0001\u0005\u0002%Cq\u0001\u0014\u0001C\u0002\u0013%Q\n\u0003\u0004W\u0001\u0001\u0006IA\u0014\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u0011\u0019!\u0007\u0001)A\u00053\"9Q\r\u0001b\u0001\n\u00131\u0007BB7\u0001A\u0003%q\rC\u0004o\u0001\t\u0007I\u0011B8\t\rM\u0004\u0001\u0015!\u0003q\u0011\u001d!\bA1A\u0005\nUDaA \u0001!\u0002\u00131\b\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u001fA\u0011\"a\u0006\u0001\u0005\u0004%I!!\u0007\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u00037A\u0011\"a\t\u0001\u0005\u0004%I!!\n\t\u0011\u00055\u0002\u0001)A\u0005\u0003OA\u0011\"a\f\u0001\u0005\u0004%I!!\r\t\u0011\u0005e\u0002\u0001)A\u0005\u0003gA\u0011\"a\u000f\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005-\u0003\u0001)A\u0005\u0003\u007fA\u0011\"!\u0014\u0001\u0005\u0004%I!a\u0014\t\u0011\u0005e\u0003\u0001)A\u0005\u0003#B\u0001\"a\u0017\u0001\u0005\u0004%I!\u0014\u0005\b\u0003;\u0002\u0001\u0015!\u0003O\u0011!\ty\u0006\u0001b\u0001\n\u0013i\u0005bBA1\u0001\u0001\u0006IA\u0014\u0005\t\u0003G\u0002!\u0019!C\u0005\u001b\"9\u0011Q\r\u0001!\u0002\u0013q\u0005\"CA4\u0001\t\u0007I\u0011BA5\u0011!\t9\n\u0001Q\u0001\n\u0005-\u0004\"CAM\u0001\t\u0007I\u0011BAN\u0011!\ty\n\u0001Q\u0001\n\u0005u\u0005\"CAQ\u0001\t\u0007I\u0011BAR\u0011!\tI\f\u0001Q\u0001\n\u0005\u0015\u0006bCA^\u0001\u0001\u0007\t\u0019!C\u0005\u0003{C1\"!2\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002H\"Y\u00111\u001b\u0001A\u0002\u0003\u0005\u000b\u0015BA`\u0011\u001d\t)\u000e\u0001C\u0001\u0003/Dq!a<\u0001\t\u0003\t9\u000eC\u0004\u0002z\u0002!\t!a6\t\u000f\t\r\u0001\u0001\"\u0001\u0002X\"9!q\u0001\u0001\u0005\u0002\u0005]\u0007b\u0002B\u0006\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0005\u001f\u0001A\u0011\u0002B\t\u0011\u001d\u0011I\u0007\u0001C\u0005\u0005WBqA!\u001f\u0001\t\u0013\u0011Y\bC\u0005\u0003\u0002\u0002\t\n\u0011\"\u0003\u0003\u0004\"9!\u0011\u0014\u0001\u0005\n\tm\u0005b\u0002BU\u0001\u0011%!1\u0016\u0005\b\u0005_\u0003A\u0011\u0002BY\u0011\u001d\u0011Y\r\u0001C\u0001\u0005\u001bDqAa4\u0001\t\u0013\u0011\t\u000eC\u0004\u0003Z\u0002!IAa7\u00039\rcWo\u001d;fe2Kgn\u001b*fa\u0006L'/T5se>\u00148\u000fV3ti*\u00111\bP\u0001\u0005Y&t7N\u0003\u0002>}\u000511/\u001a:wKJT\u0011aP\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\t\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0003\"a\u0013\u0001\u000e\u0003i\n\u0001\u0002\\5oW:\u000bW.Z\u000b\u0002\u001dB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0005Y\u0006twMC\u0001T\u0003\u0011Q\u0017M^1\n\u0005U\u0003&AB*ue&tw-A\u0005mS:\\g*Y7fA\u00051A.\u001b8l\u0013\u0012,\u0012!\u0017\t\u00035\nl\u0011a\u0017\u0006\u00039v\u000baaY8n[>t'BA _\u0015\ty\u0006-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0006\u0019qN]4\n\u0005\r\\&\u0001B+vS\u0012\fq\u0001\\5oW&#\u0007%\u0001\u0005mS:\\G)\u0019;b+\u00059\u0007C\u00015l\u001b\u0005I'B\u00016?\u0003\tQ8.\u0003\u0002mS\ny1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-A\u0005mS:\\G)\u0019;bA\u0005I1o\u00195fIVdWM]\u000b\u0002aB\u00111*]\u0005\u0003ej\u0012Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005IA-Z:u\u0003\u0012l\u0017N\\\u000b\u0002mB\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003wv\u000bqa\u00197jK:$8/\u0003\u0002~q\nq1i\u001c8gYV,g\u000e^!e[&t\u0017A\u00033fgR\fE-\\5oA\u0005yAn\\2bY\n\u000bGo\u00195BI6Lg.\u0006\u0002\u0002\u0004A\u00191*!\u0002\n\u0007\u0005\u001d!HA\u000eDYV\u001cH/\u001a:MS:\\gj\u001c8CCR\u001c\u0007.\u001b8h\u0003\u0012l\u0017N\\\u0001\u0011Y>\u001c\u0017\r\u001c\"bi\u000eD\u0017\tZ7j]\u0002\n1\u0002\\5oW6\u000bg.Y4feV\u0011\u0011q\u0002\t\u0004\u0017\u0006E\u0011bAA\nu\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s\u00031a\u0017N\\6NC:\fw-\u001a:!\u0003=iW\r^1eCR\fW*\u00198bO\u0016\u0014XCAA\u000e!\rY\u0015QD\u0005\u0004\u0003?Q$AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018\u0001E7fi\u0006$\u0017\r^1NC:\fw-\u001a:!\u00035\u0019G.[3oi6\u000bg.Y4feV\u0011\u0011q\u0005\t\u0004\u0017\u0006%\u0012bAA\u0016u\ta2\t\\;ti\u0016\u0014H*\u001b8l\t\u0016\u001cHo\u00117jK:$X*\u00198bO\u0016\u0014\u0018AD2mS\u0016tG/T1oC\u001e,'\u000fI\u0001\b[\u0016$(/[2t+\t\t\u0019\u0004E\u0002L\u0003kI1!a\u000e;\u0005I\u0019E.^:uKJd\u0015N\\6NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nA\u0001^5nKV\u0011\u0011q\b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI.\u0002\u000bU$\u0018\u000e\\:\n\t\u0005%\u00131\t\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\u0007ce>\\WM]\"p]\u001aLw-\u0006\u0002\u0002RA!\u00111KA+\u001b\u0005a\u0014bAA,y\tY1*\u00194lC\u000e{gNZ5h\u00035\u0011'o\\6fe\u000e{gNZ5hA\u00051Ao\u001c9jGF\nq\u0001^8qS\u000e\f\u0004%\u0001\u0004u_BL7MM\u0001\bi>\u0004\u0018n\u0019\u001a!\u0003\u0019!x\u000e]5dg\u00059Ao\u001c9jGN\u0002\u0013A\u00039beRLG/[8ogV\u0011\u00111\u000e\t\b\u0003[\n9HTA>\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014!C5n[V$\u0018M\u00197f\u0015\r\t)\bR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA=\u0003_\u00121!T1q!\u0019\ti(a#\u0002\u0012:!\u0011qPAD!\r\t\t\tR\u0007\u0003\u0003\u0007S1!!\"A\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0012#\u0002\rA\u0013X\rZ3g\u0013\u0011\ti)a$\u0003\u0007M+GOC\u0002\u0002\n\u0012\u00032AWAJ\u0013\r\t)j\u0017\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\u0002\u001dM|WO]2f)>\u0004\u0018nY%egV\u0011\u0011Q\u0014\t\u0007\u0003[\n9HT-\u0002\u001fM|WO]2f)>\u0004\u0018nY%eg\u0002\nA\"\\5se>\u00148\u000b^1uKN,\"!!*\u0011\u0011\u0005\u001d\u0016QVAX\u0003gk!!!+\u000b\t\u0005-\u00161O\u0001\b[V$\u0018M\u00197f\u0013\u0011\tI(!+\u0011\t\u0005u\u0014\u0011W\u0005\u0004+\u0006=\u0005cA&\u00026&\u0019\u0011q\u0017\u001e\u0003+\rcWo\u001d;fe2Kgn\u001b+pa&\u001c7\u000b^1uK\u0006iQ.\u001b:s_J\u001cF/\u0019;fg\u0002\nQB]3qC&\u0014X*\u001b:s_J\u001cXCAA`!\rY\u0015\u0011Y\u0005\u0004\u0003\u0007T$\u0001G\"mkN$XM\u001d'j].\u0014V\r]1je6K'O]8sg\u0006\t\"/\u001a9bSJl\u0015N\u001d:peN|F%Z9\u0015\t\u0005%\u0017q\u001a\t\u0004\u0007\u0006-\u0017bAAg\t\n!QK\\5u\u0011%\t\tnJA\u0001\u0002\u0004\ty,A\u0002yIE\naB]3qC&\u0014X*\u001b:s_J\u001c\b%A\u0003tKR,\u0006\u000f\u0006\u0002\u0002J\"\u001a\u0011&a7\u0011\t\u0005u\u00171^\u0007\u0003\u0003?TA!!9\u0002d\u0006\u0019\u0011\r]5\u000b\t\u0005\u0015\u0018q]\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tI\u000fY\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003[\fyN\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004U\u0005M\b\u0003BAo\u0003kLA!a>\u0002`\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0012i\u0016\u001cHOU3qC&\u0014X*\u001b:s_J\u001c\bfA\u0016\u0002~B!\u0011Q\\A\u0000\u0013\u0011\u0011\t!a8\u0003\tQ+7\u000f^\u0001+i\u0016\u001cH\u000fV8qS\u000e\u001cx+\u001b;i!\u0006\u0014H/\u001b;j_:\u001cX\t_2fK\u0012Lgn\u001a\"bi\u000eD7+\u001b>fQ\ra\u0013Q`\u0001\fi\u0016\u001cHOT8FeJ|'\u000fK\u0002.\u0003{\fa\u0003^3ti:{G\u000fT5oW\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0004]\u0005u\u0018a\u0002:v]>s7-\u001a\u000b\u000b\u0003\u0013\u0014\u0019Ba\u0006\u0003\u001c\t}\u0003b\u0002B\u000b_\u0001\u0007\u0011qV\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u00053y\u0003\u0019AA>\u0003M\u0011X-\\1j]&tw\rU1si&$\u0018n\u001c8t\u0011\u001d\u0011ib\fa\u0001\u0005?\t\u0001B]3qY&\u001c\u0017m\u001d\t\u0007\u0005C\u0011YC!\r\u000f\t\t\r\"q\u0005\b\u0005\u0003\u0003\u0013)#C\u0001F\u0013\r\u0011I\u0003R\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iCa\f\u0003\u0007M+\u0017OC\u0002\u0003*\u0011\u0003BAa\r\u0003Z9!!Q\u0007B*\u001d\u0011\u00119D!\u0014\u000f\t\te\"\u0011\n\b\u0005\u0005w\u00119E\u0004\u0003\u0003>\t\u0015c\u0002\u0002B \u0005\u0007rA!!!\u0003B%\t\u0011-\u0003\u0002`A&\u0011qHX\u0005\u00039vK1Aa\u0013\\\u0003\u001d\u0011X\r\u001d7jG\u0006LAAa\u0014\u0003R\u0005i!+\u001a9mS\u000e\f7\u000b^1ukNT1Aa\u0013\\\u0013\u0011\u0011)Fa\u0016\u0002\u00155K'O]8s\u0013:4wN\u0003\u0003\u0003P\tE\u0013\u0002\u0002B.\u0005;\u0012Qa\u0015;bi\u0016TAA!\u0016\u0003X!9!\u0011M\u0018A\u0002\t\r\u0014A\u0004:fa\u0006L'oQ8na2,G/\u001a\t\u0004\u0007\n\u0015\u0014b\u0001B4\t\n9!i\\8mK\u0006t\u0017aC;qI\u0006$Xm\u0015;bi\u0016$b!!3\u0003n\t=\u0004b\u0002B\u000ba\u0001\u0007\u0011q\u0016\u0005\b\u0005c\u0002\u0004\u0019\u0001B:\u0003\u0015\u0019H/\u0019;f!\u0015\u0019%QOAZ\u0013\r\u00119\b\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0015M,G/\u001e9N_\u000e\\7\u000f\u0006\u0003\u0002J\nu\u0004\"\u0003B@cA\u0005\t\u0019\u0001B2\u0003EI7\u000fT5oW\u000e{wN\u001d3j]\u0006$xN]\u0001\u0015g\u0016$X\u000f]'pG.\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u0015%\u0006\u0002B2\u0005\u000f[#A!#\u0011\t\t-%QS\u0007\u0003\u0005\u001bSAAa$\u0003\u0012\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005'#\u0015AC1o]>$\u0018\r^5p]&!!q\u0013BG\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogR1\u00111\u0010BO\u0005?CqA!\u00064\u0001\u0004\ty\u000bC\u0004\u0003\"N\u0002\rAa)\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t!\r\u0019%QU\u0005\u0004\u0005O#%aA%oi\u0006\u0019\u0002/\u001a8eS:<'+\u001a9bSJ\u001cF/\u0019;fgR!!q\u0004BW\u0011\u001d\u0011)\u0002\u000ea\u0001\u0003_\u000bAC]3qY&\u001c\u0017m\u0015;biV\u001ch)\u001e;ve\u0016\u001cH\u0003\u0002BZ\u0005\u0013\u0004\u0002B!.\u0003<\u0006E%QX\u0007\u0003\u0005oS1A!/S\u0003\u0011)H/\u001b7\n\t\u0005e$q\u0017\t\u00065\n}&1Y\u0005\u0004\u0005\u0003\\&aC&bM.\fg)\u001e;ve\u0016\u00042a\u001eBc\u0013\r\u00119\r\u001f\u0002\u0010!\u0006\u0014H/\u001b;j_:\u0014Vm];mi\"9!QC\u001bA\u0002\u0005=\u0016\u0001\u00078foB\u000b'\u000f^5uS>t'+Z:vYR4U\u000f^;sKV\u0011!QX\u0001\u0016G>l\u0007\u000f\\3uKJ+\u0007\u000f\\5dCN#\u0018\r^;t)\u0019\tIMa5\u0003X\"9!Q[\u001cA\u0002\tM\u0016a\u00024viV\u0014Xm\u001d\u0005\b\u0005;9\u0004\u0019\u0001B\u0010\u00035\u0011X\r\u001d7jG\u0006\u001cF/\u0019;vgR!!Q\u001cBv!\u0019\u0011)La8\u0003d&!!\u0011\u001dB\\\u0005\u0011a\u0015n\u001d;\u0011\t\t\u0015(q]\u0007\u0003\u0005#JAA!;\u0003R\ti!+\u001a9mS\u000e\f7\u000b^1ukNDqA!\u001d9\u0001\u0004\u0011\t\u0004")
public class ClusterLinkRepairMirrorsTest {
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final ClusterLinkData linkData = new ClusterLinkData(this.linkName(), this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler(0, 100);
    private final ConfluentAdmin destAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkNonBatchingAdmin localBatchAdmin = new ClusterLinkNonBatchingAdmin((Function0 & Serializable)() -> this.destAdmin());
    private final ClusterLinkManager linkManager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics(this.linkData().linkName(), this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, false, this.linkManager(), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$, false);
    private final Time time = new MockTime();
    private final KafkaConfig brokerConfig = (KafkaConfig)Mockito.mock(KafkaConfig.class);
    private final String topic1;
    private final String topic2;
    private final String topic3;
    private final scala.collection.immutable.Map<String, scala.collection.immutable.Set<TopicPartition>> partitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), this.topicPartitions(this.topic1(), 2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2()), this.topicPartitions(this.topic2(), 20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic3()), this.topicPartitions(this.topic3(), 30))}));
    private final scala.collection.immutable.Map<String, Uuid> sourceTopicIds = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2()), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic3()), (Object)Uuid.randomUuid())}));
    private final scala.collection.mutable.Map<String, ClusterLinkTopicState> mirrorStates = (scala.collection.mutable.Map)Map$.MODULE$.empty();
    private ClusterLinkRepairMirrors repairMirrors;

    private String linkName() {
        return this.linkName;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    private ClusterLinkNonBatchingAdmin localBatchAdmin() {
        return this.localBatchAdmin;
    }

    private ClusterLinkManager linkManager() {
        return this.linkManager;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    private String topic3() {
        return this.topic3;
    }

    private scala.collection.immutable.Map<String, scala.collection.immutable.Set<TopicPartition>> partitions() {
        return this.partitions;
    }

    private scala.collection.immutable.Map<String, Uuid> sourceTopicIds() {
        return this.sourceTopicIds;
    }

    private scala.collection.mutable.Map<String, ClusterLinkTopicState> mirrorStates() {
        return this.mirrorStates;
    }

    private ClusterLinkRepairMirrors repairMirrors() {
        return this.repairMirrors;
    }

    private void repairMirrors_$eq(ClusterLinkRepairMirrors x$1) {
        this.repairMirrors = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
        this.setupMocks(true);
        this.repairMirrors_$eq(new ClusterLinkRepairMirrors(this.brokerConfig(), this.linkManager(), this.scheduler(), (ClusterLinkBatchAdmin)this.localBatchAdmin(), this.time(), 100));
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.repairMirrors().shutdown();
        this.metrics().shutdown();
    }

    @Test
    public void testRepairMirrors() {
        Some state = new Some((Object)new ClusterLinkTopicState.PendingRepairMirror(this.linkName(), this.linkId(), (Uuid)this.sourceTopicIds().apply((Object)this.topic1()), MirrorTopicError.UNSUPPORTED_MESSAGE_FORMAT, Time.SYSTEM.milliseconds()));
        this.updateState(this.topic1(), (Option<ClusterLinkTopicState>)state);
        this.runOnce(this.topic1(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)this.partitions().apply((Object)this.topic1())), (scala.collection.immutable.Seq<ReplicaStatus.MirrorInfo.State>)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.FAILED, (List)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.FAILED, (List)Nil$.MODULE$)), false);
        this.runOnce(this.topic1(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)this.partitions().apply((Object)this.topic1())), (scala.collection.immutable.Seq<ReplicaStatus.MirrorInfo.State>)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.PENDING_REPAIR, (List)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.FAILED, (List)Nil$.MODULE$)), false);
        this.runOnce(this.topic1(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic1(), 1)}))), (scala.collection.immutable.Seq<ReplicaStatus.MirrorInfo.State>)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.PENDING_REPAIR, (List)new .colon.colon((Object)ReplicaStatus.MirrorInfo.State.PENDING_REPAIR, (List)Nil$.MODULE$)), true);
    }

    @Test
    public void testTopicsWithPartitionsExceedingBatchSize() {
        Some state = new Some((Object)new ClusterLinkTopicState.PendingRepairMirror(this.linkName(), this.linkId(), (Uuid)this.sourceTopicIds().apply((Object)this.topic2()), MirrorTopicError.RECORD_TOO_LARGE, Time.SYSTEM.milliseconds()));
        this.updateState(this.topic2(), (Option<ClusterLinkTopicState>)state);
        this.runOnce(this.topic2(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)this.partitions().apply((Object)this.topic2())), this.pendingRepairStates(this.topic2()), true);
    }

    @Test
    public void testNoError() {
        this.setupMocks(true);
        ClusterLinkScheduler.TaskResult result = this.repairMirrors().run();
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertTrue((boolean)result.errs().isEmpty());
        Uuid sourceTopicId = (Uuid)this.sourceTopicIds().apply((Object)this.topic1());
        this.verifyState$1((Option)None$.MODULE$);
        this.verifyState$1((Option)new Some((Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), sourceTopicId, Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty())));
        this.verifyState$1((Option)new Some((Object)new ClusterLinkTopicState.PendingStoppedMirror(this.linkName(), this.linkId(), sourceTopicId, false, Time.SYSTEM.milliseconds())));
        this.verifyState$1((Option)new Some((Object)new ClusterLinkTopicState.StoppedMirror(this.linkName(), this.linkId(), sourceTopicId, (Seq)package$.MODULE$.Seq().empty(), Time.SYSTEM.milliseconds())));
        this.verifyState$1((Option)new Some((Object)new ClusterLinkTopicState.PausedMirror(this.linkName(), this.linkId(), sourceTopicId, false, false, (TopicLinkState)TopicLinkMirror$.MODULE$, null, MirrorTopicError.NO_ERROR, Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty())));
        this.verifyState$1((Option)new Some((Object)new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), sourceTopicId, MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, Time.SYSTEM.milliseconds())));
    }

    @Test
    public void testNotLinkCoordinator() {
        this.setupMocks(false);
        ClusterLinkTaskManager taskManager = new ClusterLinkTaskManager(0, this.linkManager(), this.brokerConfig(), this.time());
        ClusterLinkRepairMirrors repairMirrors = taskManager.clusterLinkRepairMirrors();
        Assertions.assertTrue((boolean)repairMirrors.run().completed());
        ClusterLinkTopicState.PendingRepairMirror state = new ClusterLinkTopicState.PendingRepairMirror(this.linkName(), this.linkId(), (Uuid)this.sourceTopicIds().apply((Object)this.topic1()), MirrorTopicError.RECORD_TOO_LARGE, Time.SYSTEM.milliseconds());
        this.mirrorStates().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)state));
        taskManager.processMirrorStateChange(this.topic1(), (ClusterLinkTopicState)state, (Option)None$.MODULE$, this.clientManager());
        Assertions.assertEquals((int)0, (int)repairMirrors.subTaskCount());
        Assertions.assertTrue((boolean)repairMirrors.run().completed());
    }

    private void runOnce(String topic, scala.collection.immutable.Set<TopicPartition> remainingPartitions, scala.collection.immutable.Seq<ReplicaStatus.MirrorInfo.State> replicas, boolean repairComplete) {
        None$ none$;
        java.util.Map<TopicPartition, KafkaFuture<PartitionResult>> statusFutures = this.replicaStatusFutures(topic);
        Mockito.when((Object)this.destAdmin().replicaStatus((Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava(remainingPartitions).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)new ReplicaStatusResult(statusFutures));
        if (repairComplete) {
            KafkaFutureImpl alterFuture2 = new KafkaFutureImpl();
            AlterMirrorsResult alterResult = new AlterMirrorsResult(Collections.singletonMap(topic, alterFuture2));
            Mockito.when((Object)this.destAdmin().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(topic, AlterMirrorOp.COMPLETE_REPAIR)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)alterResult).thenThrow(new Throwable[]{new RuntimeException("Alter mirrors invoked multiple times")});
            none$ = new Some((Object)alterFuture2);
        } else {
            ((ConfluentAdmin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.never())).alterMirrors((java.util.Map)ArgumentMatchers.any(), (AlterMirrorsOptions)ArgumentMatchers.any());
            none$ = None$.MODULE$;
        }
        None$ alterMirrorFuture = none$;
        KafkaFuture future = this.repairMirrors().runOnce();
        Assertions.assertFalse((boolean)future.isDone());
        this.completeReplicaStatus(statusFutures, replicas);
        alterMirrorFuture.foreach((Function1 & Serializable)alterFuture -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkRepairMirrorsTest.$anonfun$runOnce$1(future, alterFuture)));
        Assertions.assertTrue((boolean)((ClusterLinkScheduler.TaskResult)future.get(15L, TimeUnit.SECONDS)).completed());
    }

    private void updateState(String topic, Option<ClusterLinkTopicState> state) {
        if (state instanceof Some) {
            ClusterLinkTopicState mirrorState = (ClusterLinkTopicState)((Some)state).value();
            this.mirrorStates().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)mirrorState));
            this.repairMirrors().maybeAddTask(topic, mirrorState, (Option)None$.MODULE$, this.clientManager());
            return;
        }
        if (None$.MODULE$.equals(state)) {
            this.mirrorStates().remove((Object)topic);
            return;
        }
        throw new MatchError(state);
    }

    private void setupMocks(boolean isLinkCoordinator) {
        Mockito.reset((Object[])new ConfluentAdmin[]{this.destAdmin()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(this.linkName()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isLinkCoordinator));
        ArgumentCaptor capturedTopics = ArgumentCaptor.forClass(scala.collection.immutable.Set.class);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)capturedTopics.capture())).thenAnswer(x$2 -> ((IterableOnceOps)((IterableOps)((scala.collection.immutable.Set)capturedTopics.getValue()).map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), this.mirrorStates().get(topic).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkRepairMirrorsTest.$anonfun$setupMocks$3(x$3)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Mockito.when((Object)this.metadataManager().topicPartitions(ArgumentMatchers.anyString())).thenAnswer(inv -> (scala.collection.immutable.Set)this.partitions().apply(inv.getArgument(0)));
        Mockito.when((Object)this.linkManager().metadataManager()).thenReturn((Object)this.metadataManager());
        Mockito.when((Object)this.clientManager().metadataManager()).thenReturn((Object)this.metadataManager());
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().linkData()).thenReturn((Object)this.linkData());
        Mockito.when((Object)this.clientManager().metrics()).thenReturn((Object)this.metrics());
        Mockito.when((Object)this.clientManager().requestQuota()).thenReturn((Object)UnboundedClusterLinkRequestQuota$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.clientManager().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.brokerConfig().clusterLinkMirrorTransitionBatchSize()).thenReturn((Object)Predef$.MODULE$.int2Integer(1));
    }

    private boolean setupMocks$default$1() {
        return true;
    }

    private scala.collection.immutable.Set<TopicPartition> topicPartitions(String topic, int numPartitions) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable)i -> ClusterLinkRepairMirrorsTest.$anonfun$topicPartitions$1(topic, BoxesRunTime.unboxToInt((Object)i))).toSet();
    }

    private scala.collection.immutable.Seq<ReplicaStatus.MirrorInfo.State> pendingRepairStates(String topic) {
        return (scala.collection.immutable.Seq)((IterableOnceOps)this.partitions().apply((Object)topic)).toSeq().map((Function1 & Serializable)x$4 -> ReplicaStatus.MirrorInfo.State.PENDING_REPAIR);
    }

    private java.util.Map<TopicPartition, KafkaFuture<PartitionResult>> replicaStatusFutures(String topic) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)((IterableOps)this.partitions().apply((Object)topic)).map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), this.newPartitionResultFuture()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public KafkaFuture<PartitionResult> newPartitionResultFuture() {
        return new KafkaFutureImpl();
    }

    private void completeReplicaStatus(java.util.Map<TopicPartition, KafkaFuture<PartitionResult>> futures, scala.collection.immutable.Seq<ReplicaStatus.MirrorInfo.State> replicas) {
        futures.forEach((tp, future) -> {
            PartitionResult result = new PartitionResult(1, 1, this.replicaStatus((ReplicaStatus.MirrorInfo.State)replicas.apply(tp.partition())));
            ((KafkaFutureImpl)future).complete((Object)result);
            Assertions.assertTrue((boolean)future.isDone());
        });
    }

    private java.util.List<ReplicaStatus> replicaStatus(ReplicaStatus.MirrorInfo.State state) {
        ReplicaStatus.MirrorInfo mirrorInfo = new ReplicaStatus.MirrorInfo(state, -1L, -1L);
        return Collections.singletonList(new ReplicaStatus(0, true, false, true, false, false, 10L, 20L, 0L, 0L, Optional.of(this.linkName()), Optional.of(mirrorInfo), Optional.of("pull"), OptionalLong.of(-1L)));
    }

    private final void verifyState$1(Option state) {
        this.updateState(this.topic1(), (Option<ClusterLinkTopicState>)state);
        ClusterLinkScheduler.TaskResult result = this.repairMirrors().run();
        Assertions.assertTrue((boolean)result.completed());
        Assertions.assertTrue((boolean)result.errs().isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$runOnce$1(KafkaFuture future$1, KafkaFutureImpl alterFuture) {
        Assertions.assertFalse((boolean)future$1.isDone());
        return alterFuture.complete(null);
    }

    public static final /* synthetic */ boolean $anonfun$setupMocks$3(Tuple2 x$3) {
        return x$3._2() == null;
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(String topic$1, int i) {
        return new TopicPartition(topic$1, i);
    }

    public ClusterLinkRepairMirrorsTest() {
        this.linkName = "link-name";
        this.topic1 = "mirror-topic1";
        this.topic2 = "mirror-topic2";
        this.topic3 = "mirror-topic3";
    }
}

