/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.MetadataCache;
import kafka.server.UnboundedClusterLinkRequestQuota$;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNonBatchingAdmin;
import kafka.server.link.ClusterLinkReverseAndSwapMirror;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TaskType;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkState;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r]f\u0001B-[\u0001\u0005DQ\u0001\u001b\u0001\u0005\u0002%Dq\u0001\u001c\u0001C\u0002\u0013%Q\u000e\u0003\u0004w\u0001\u0001\u0006IA\u001c\u0005\bo\u0002\u0011\r\u0011\"\u0003n\u0011\u0019A\b\u0001)A\u0005]\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bbBA\u0007\u0001\u0001\u0006Ia\u001f\u0005\t\u0003\u001f\u0001!\u0019!C\u0005u\"9\u0011\u0011\u0003\u0001!\u0002\u0013Y\b\"CA\n\u0001\t\u0007I\u0011BA\u000b\u0011!\ti\u0002\u0001Q\u0001\n\u0005]\u0001\"CA\u0010\u0001\t\u0007I\u0011BA\u0011\u0011!\tI\u0003\u0001Q\u0001\n\u0005\r\u0002\"CA\u0016\u0001\t\u0007I\u0011BA\u0017\u0011!\t)\u0004\u0001Q\u0001\n\u0005=\u0002\"CA\u001c\u0001\t\u0007I\u0011BA\u001d\u0011!\tY\u0005\u0001Q\u0001\n\u0005m\u0002\"CA'\u0001\t\u0007I\u0011BA(\u0011!\t9\u0006\u0001Q\u0001\n\u0005E\u0003\"CA-\u0001\t\u0007I\u0011BA\u001d\u0011!\tY\u0006\u0001Q\u0001\n\u0005m\u0002\"CA/\u0001\t\u0007I\u0011BA(\u0011!\ty\u0006\u0001Q\u0001\n\u0005E\u0003\"CA1\u0001\t\u0007I\u0011BA2\u0011!\t\u0019\t\u0001Q\u0001\n\u0005\u0015\u0004\"CAC\u0001\t\u0007I\u0011BAD\u0011!\t\t\n\u0001Q\u0001\n\u0005%\u0005\"CAJ\u0001\t\u0007I\u0011BAK\u0011!\ti\n\u0001Q\u0001\n\u0005]\u0005\"CAP\u0001\t\u0007I\u0011BAQ\u0011!\ty\u000b\u0001Q\u0001\n\u0005\r\u0006\"CAY\u0001\t\u0007I\u0011BAZ\u0011!\tY\f\u0001Q\u0001\n\u0005U\u0006\"CA_\u0001\t\u0007I\u0011BA`\u0011!\tY\r\u0001Q\u0001\n\u0005\u0005\u0007\"CAg\u0001\t\u0007I\u0011BAh\u0011!\ti\u000e\u0001Q\u0001\n\u0005E\u0007bCAp\u0001\u0001\u0007\t\u0019!C\u0005\u0003CD1\"!;\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002l\"Y\u0011q\u001f\u0001A\u0002\u0003\u0005\u000b\u0015BAr\u0011\u001d\tI\u0010\u0001C\u0001\u0003wDqAa\u0005\u0001\t\u0003\tY\u0010C\u0004\u0003\u001e\u0001!\t!a?\t\u000f\t\u001d\u0002\u0001\"\u0001\u0002|\"9!1\u0006\u0001\u0005\u0002\u0005m\bb\u0002B\u0018\u0001\u0011\u0005\u00111 \u0005\b\u0005g\u0001A\u0011AA~\u0011\u001d\u00119\u0004\u0001C\u0001\u0003wDqAa\u000f\u0001\t\u0003\tY\u0010C\u0004\u0003@\u0001!\t!a?\t\u000f\t\r\u0003\u0001\"\u0001\u0002|\"9!q\t\u0001\u0005\u0002\u0005m\bb\u0002B&\u0001\u0011\u0005\u00111 \u0005\b\u0005\u001f\u0002A\u0011AA~\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0003wDqAa\u0016\u0001\t\u0003\tY\u0010C\u0004\u0003\\\u0001!\t!a?\t\u000f\t}\u0003\u0001\"\u0001\u0002|\"9!1\r\u0001\u0005\u0002\u0005m\bb\u0002B4\u0001\u0011\u0005\u00111 \u0005\b\u0005W\u0002A\u0011BA~\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005_BqAa\u001f\u0001\t\u0013\u0011i\bC\u0004\u0003\u0002\u0002!IAa!\t\u000f\tE\u0005\u0001\"\u0003\u0003\u0014\"9!q\u0017\u0001\u0005\n\te\u0006\"\u0003Bj\u0001E\u0005I\u0011\u0002Bk\u0011\u001d\u0011Y\u000f\u0001C\u0005\u0005[D\u0011ba\u0004\u0001#\u0003%IA!6\t\u000f\rE\u0001\u0001\"\u0003\u0004\u0014!91q\u0003\u0001\u0005\n\re\u0001bBB\u0018\u0001\u0011%1\u0011\u0007\u0005\n\u0007k\u0001\u0011\u0013!C\u0005\u0005+Dqaa\u000e\u0001\t\u0013\u0019I\u0004C\u0005\u0004>\u0001\t\n\u0011\"\u0003\u0003V\"91q\b\u0001\u0005\n\r\u0005\u0003\"CB#\u0001E\u0005I\u0011\u0002Bk\u0011\u001d\u00199\u0005\u0001C\u0005\u0007\u0013Bqa!\u0014\u0001\t\u0013\u0019y\u0005C\u0004\u0004T\u0001!Ia!\u0016\t\u000f\re\u0003\u0001\"\u0003\u0002|\"911\f\u0001\u0005\n\ru\u0003bBB1\u0001\u0011%11\r\u0005\b\u0007O\u0002A\u0011BB5\u0011%\u0019\u0019\u000bAI\u0001\n\u0013\u0019)\u000bC\u0005\u0004*\u0002\t\n\u0011\"\u0003\u0004,\"I1q\u0016\u0001\u0012\u0002\u0013%1\u0011\u0017\u0005\n\u0007k\u0003\u0011\u0013!C\u0005\u0005+\u00141e\u00117vgR,'\u000fT5oWJ+g/\u001a:tK\u0006sGmU<ba6K'O]8s)\u0016\u001cHO\u0003\u0002\\9\u0006!A.\u001b8l\u0015\tif,\u0001\u0004tKJ4XM\u001d\u0006\u0002?\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001c!\t\u0019g-D\u0001e\u0015\u0005)\u0017!B:dC2\f\u0017BA4e\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u001b\t\u0003W\u0002i\u0011AW\u0001\u0006i>\u0004\u0018nY\u000b\u0002]B\u0011q\u000e^\u0007\u0002a*\u0011\u0011O]\u0001\u0005Y\u0006twMC\u0001t\u0003\u0011Q\u0017M^1\n\u0005U\u0004(AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\tY&t7NT1nK\u0006IA.\u001b8l\u001d\u0006lW\rI\u0001\u0007Y&t7.\u00133\u0016\u0003m\u00042\u0001`A\u0005\u001b\u0005i(B\u0001@\u0000\u0003\u0019\u0019w.\\7p]*\u0019q,!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u001d\u0011aA8sO&\u0019\u00111B?\u0003\tU+\u0018\u000eZ\u0001\bY&t7.\u00133!\u00035\u0019x.\u001e:dKR{\u0007/[2JI\u0006q1o\\;sG\u0016$v\u000e]5d\u0013\u0012\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\t\t9\u0002E\u0002l\u00033I1!a\u0007[\u0005Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002\u001b\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3s+\t\t\u0019\u0003E\u0002l\u0003KI1!a\n[\u0005q\u0019E.^:uKJd\u0015N\\6EKN$8\t\\5f]Rl\u0015M\\1hKJ\fab\u00197jK:$X*\u00198bO\u0016\u0014\b%A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s+\t\ty\u0003E\u0002l\u0003cI1!a\r[\u0005i\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u0003AiW\r^1eCR\fW*\u00198bO\u0016\u0014\b%\u0001\u0006m_\u000e\fG.\u00113nS:,\"!a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005)\u0011\rZ7j]*\u0019\u0011QI@\u0002\u000f\rd\u0017.\u001a8ug&!\u0011\u0011JA \u00059\u0019uN\u001c4mk\u0016tG/\u00113nS:\f1\u0002\\8dC2\fE-\\5oA\u0005yAn\\2bY\n\u000bGo\u00195BI6Lg.\u0006\u0002\u0002RA\u00191.a\u0015\n\u0007\u0005U#LA\u000bDYV\u001cH/\u001a:MS:\\')\u0019;dQ\u0006#W.\u001b8\u0002!1|7-\u00197CCR\u001c\u0007.\u00113nS:\u0004\u0013a\u0003:f[>$X-\u00113nS:\fAB]3n_R,\u0017\tZ7j]\u0002\n\u0001C]3n_R,')\u0019;dQ\u0006#W.\u001b8\u0002#I,Wn\u001c;f\u0005\u0006$8\r[!e[&t\u0007%\u0001\u0006qCJ$\u0018\u000e^5p]N,\"!!\u001a\u0011\r\u0005\u001d\u0014qOA?\u001d\u0011\tI'a\u001d\u000f\t\u0005-\u0014\u0011O\u0007\u0003\u0003[R1!a\u001ca\u0003\u0019a$o\\8u}%\tQ-C\u0002\u0002v\u0011\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002z\u0005m$\u0001\u0002'jgRT1!!\u001ee!\ra\u0018qP\u0005\u0004\u0003\u0003k(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b%A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003\u0013\u0003B!a#\u0002\u000e6\tA,C\u0002\u0002\u0010r\u0013Q\"T3uC\u0012\fG/Y\"bG\",\u0017AD7fi\u0006$\u0017\r^1DC\u000eDW\rI\u0001\u0006cV|G/Y\u000b\u0003\u0003/\u0003B!a#\u0002\u001a&\u0019\u00111\u0014/\u0003/\rcWo\u001d;fe2Kgn\u001b*fcV,7\u000f^)v_R\f\u0017AB9v_R\f\u0007%\u0001\u0003uS6,WCAAR!\u0011\t)+a+\u000e\u0005\u0005\u001d&bAAU{\u0006)Q\u000f^5mg&!\u0011QVAT\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u000f5,GO]5dgV\u0011\u0011Q\u0017\t\u0004W\u0006]\u0016bAA]5\n\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013AB:f]N|'/\u0006\u0002\u0002BB!\u00111YAd\u001b\t\t)MC\u0002\u00022vLA!!3\u0002F\n11+\u001a8t_J\fqa]3og>\u0014\b%\u0001\u0005mS:\\G)\u0019;b+\t\t\t\u000e\u0005\u0003\u0002T\u0006eWBAAk\u0015\r\t9NX\u0001\u0003u.LA!a7\u0002V\ny1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-A\u0005mS:\\G)\u0019;bA\u0005I\"/\u001a<feN,\u0017I\u001c3To\u0006\u0004X*\u001b:s_J$v\u000e]5d+\t\t\u0019\u000fE\u0002l\u0003KL1!a:[\u0005}\u0019E.^:uKJd\u0015N\\6SKZ,'o]3B]\u0012\u001cv/\u00199NSJ\u0014xN]\u0001\u001ee\u00164XM]:f\u0003:$7k^1q\u001b&\u0014(o\u001c:U_BL7m\u0018\u0013fcR!\u0011Q^Az!\r\u0019\u0017q^\u0005\u0004\u0003c$'\u0001B+oSRD\u0011\"!>(\u0003\u0003\u0005\r!a9\u0002\u0007a$\u0013'\u0001\u000esKZ,'o]3B]\u0012\u001cv/\u00199NSJ\u0014xN\u001d+pa&\u001c\u0007%A\u0003tKR,\u0006\u000f\u0006\u0002\u0002n\"\u001a\u0011&a@\u0011\t\t\u0005!qB\u0007\u0003\u0005\u0007QAA!\u0002\u0003\b\u0005\u0019\u0011\r]5\u000b\t\t%!1B\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\u0011i!!\u0002\u0002\u000b),h.\u001b;\n\t\tE!1\u0001\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007)\u00129\u0002\u0005\u0003\u0003\u0002\te\u0011\u0002\u0002B\u000e\u0005\u0007\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002IQ,7\u000f\u001e*fm\u0016\u00148/Z!oIN#\u0018M\u001d;SK6|G/Z'jeJ|'\u000fV8qS\u000eD3a\u000bB\u0011!\u0011\u0011\tAa\t\n\t\t\u0015\"1\u0001\u0002\u0005)\u0016\u001cH/\u0001\u0013uKN$(+\u001a<feN,\u0017I\u001c3QCV\u001cXMU3n_R,W*\u001b:s_J$v\u000e]5dQ\ra#\u0011E\u0001Ei\u0016\u001cHOU3wKJ\u001cX-\u00118e'R\f'\u000f\u001e*f[>$X-T5se>\u0014Hk\u001c9jG^KG\u000f\u001b#fY\u0006L\u0018J\u001c'pG\u0006dW*\u001b:s_J\u001c\u0015\r^2iS:<W\u000b\u001d\u0015\u0004[\t\u0005\u0012a\u0017;fgR\u0014VM^3sg\u0016\fe\u000eZ*uCJ$(+Z7pi\u0016l\u0015N\u001d:peR{\u0007/[2XSRDG)\u001a7bs&sGj\\2bY6K'O]8s\u0007\u0006$8\r[5oOV\u0003x+\u001b;i\t&4g-\u001a:f]R\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004]\t\u0005\u0012A\u0014;fgR\u0014VM^3sg\u0016\fe\u000eZ*uCJ$(+Z7pi\u0016l\u0015N\u001d:peR{\u0007/[2XSRD'+Z7pi\u0016dunZ#oI>3gm]3u\u0007\"\fgnZ3e\u0003\u001a$XM]\"bk\u001eDG/\u00169)\u0007=\u0012\t#\u0001\u001cuKN$(+\u001a<feN,\u0017I\u001c3Ti\u0006\u0014HOU3n_R,W*\u001b:s_J$v\u000e]5d/&$\bNU3qCJ$\u0018\u000e^5p]&tw\rK\u00021\u0005C\t\u0001\b^3ti\u000ecWo\u001d;fe2Kgn\u001b*fm\u0016\u00148/Z!oIN;\u0018\r]'jeJ|'\u000fV8qS\u000e<\u0016\u000e\u001e5EK2,G/\u001a3U_BL7\rK\u00022\u0005C\tA\b^3ti\u000ecWo\u001d;fe2Kgn\u001b*fm\u0016\u00148/Z!oIN;\u0018\r]'jeJ|'\u000fV8qS\u000e<\u0016\u000e\u001e5V]N,\b\u000f]8si\u0016$7\u000b^1uK\"\u001a!G!\t\u0002sQ,7\u000f^\"mkN$XM\u001d'j].\u0014VM^3sg\u0016\fe\u000eZ*xCBl\u0015N\u001d:peR{\u0007/[2XSRDgj\\'jeJ|'o\u0015;bi\u0016D3a\rB\u0011\u0003!#Xm\u001d;DYV\u001cH/\u001a:MS:\\'+\u001a<feN,\u0017I\u001c3To\u0006\u0004X*\u001b:s_J$v\u000e]5d/&$\bNU3n_R,W*\u001b:s_J\u001cF/\u0019;vg:{G\u000f\u0015:fg\u0016tG\u000fK\u00025\u0005C\tq\t^3ti\u000ecWo\u001d;fe2Kgn\u001b*fm\u0016\u00148/Z!oIN;\u0018\r]'jeJ|'\u000fV8qS\u000e<\u0016\u000e\u001e5M_\u000e\fG.T5se>\u00148\u000b^1ukNtu\u000e\u001e)sKN,g\u000e\u001e\u0015\u0004k\t\u0005\u0012\u0001\u0012;fgR\u0014VM^3sg\u0016\fe\u000eZ*uCJ$(+Z7pi\u0016l\u0015N\u001d:peR{\u0007/[2XSRD'+Z7pi\u0016\u0014V\r\u001d7jG\u0006\u001cF/\u0019;vg\u0016C8-\u001a9uS>t\u0007f\u0001\u001c\u0003\"\u0005aE/Z:u%\u00164XM]:f\u0003:$7\u000b^1siJ+Wn\u001c;f\u001b&\u0014(o\u001c:U_BL7mV5uQJ+Wn\u001c;f%\u0016\u0004H.[2b'R\fG/^:Fq\u000e,\u0007\u000f^5p]&sg)\u001e;ve\u0016D3a\u000eB\u0011\u0003i#Xm\u001d;SKZ,'o]3B]\u0012\u001cF/\u0019:u%\u0016lw\u000e^3NSJ\u0014xN\u001d+pa&\u001cw+\u001b;i%\u0016lw\u000e^3SKBd\u0017nY1Ti\u0006$Xo]!vi\",g\u000e^5dCRLwN\\#yG\u0016\u0004H/[8o\u0013:4U\u000f^;sK\"\u001a\u0001H!\t\u0002\u0007R,7\u000f\u001e*fm\u0016\u00148/Z!oIN#\u0018M\u001d;SK6|G/Z'jeJ|'\u000fV8qS\u000e<\u0016\u000e\u001e5M_\u000e\fGNU3qY&\u001c\u0017m\u0015;biV\u001cX\t_2faRLwN\u001c\u0015\u0004s\t\u0005\u0012a\u0013;fgR\u0014VM^3sg\u0016\fe\u000eZ*uCJ$(+Z7pi\u0016l\u0015N\u001d:peR{\u0007/[2XSRDGj\\2bYJ+\u0007\u000f\\5dCN#\u0018\r^;t\u000bb\u001cW\r\u001d;j_:LeNR;ukJ,\u0007f\u0001\u001e\u0003\"\u0005iE/Z:u%\u00164XM]:f\u0003:$7\u000b^1siJ+Wn\u001c;f\u001b&\u0014(o\u001c:U_BL7mV5uQ2{7-\u00197NSJ\u0014xN\u001d)s_6|G/[8o\u000bb\u001cW\r\u001d;j_:LeNR;ukJ,\u0007fA\u001e\u0003\"\u0005)E/Z:u%\u00164XM]:f\u0003:$7\u000b^1siJ+Wn\u001c;f\u001b&\u0014(o\u001c:U_BL7mV5uQ2{7-\u00197NSJ\u0014xN\u001d)s_6|G/[8o\u000bb\u001cW\r\u001d;j_:D3\u0001\u0010B\u0011\u0003YiwnY6M_\u000e\fG\u000e\u0015:p[>$X-T5se>\u0014\u0018aK7pG.dunY1m!J|Wn\u001c;f\u001b&\u0014(o\u001c:XSRDW\t_2faRLwN\\%o\rV$XO]3\u0015\t\u00055(\u0011\u000f\u0005\b\u0005gr\u0004\u0019\u0001B;\u0003\u0005)\u0007\u0003BA4\u0005oJAA!\u001f\u0002|\tIA\u000b\u001b:po\u0006\u0014G.Z\u0001$[>\u001c7\u000eT8dC2\u0004&o\\7pi\u0016l\u0015N\u001d:pe^KG\u000f[#yG\u0016\u0004H/[8o)\u0011\tiOa \t\u000f\tMt\b1\u0001\u0003v\u0005\u0011\u0012\r\u001c;fe6K'O]8sg\u001a+H/\u001e:f)\t\u0011)\tE\u0003}\u0005\u000f\u0013Y)C\u0002\u0003\nv\u00141bS1gW\u00064U\u000f^;sKB\u0019qN!$\n\u0007\t=\u0005O\u0001\u0003W_&$\u0017\u0001\u0006;p%\u0016\u0004H.[2b'R\fG/^:F]R\u0014\u0018\u0010\u0006\u0003\u0003\u0016\nu\u0005#\u0002?\u0003\b\n]\u0005\u0003BA\u001f\u00053KAAa'\u0002@\ty\u0001+\u0019:uSRLwN\u001c*fgVdG\u000fC\u0004\u0003 \u0006\u0003\rA!)\u0002\u0005I\u001c\bC\u0002BR\u0005S\u0013Y+\u0004\u0002\u0003&*\u0019!q\u0015:\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003s\u0012)\u000b\u0005\u0003\u0003.\nMVB\u0001BX\u0015\r\u0011\t,`\u0001\be\u0016\u0004H.[2b\u0013\u0011\u0011)La,\u0003\u001bI+\u0007\u000f\\5dCN#\u0018\r^;t\u0003ijwnY6M_\u000e\fGNU3qY&\u001c\u0017m\u0015;biV\u001c(+Z:vYR<\u0016\u000e\u001e5ES\u001a4WM]3oi2\u000bwmZ5oOB\u000b'\u000f^5uS>t7\u000f\u0006\u0005\u0003<\n\u0005'1\u001aBh!\u0011\tiD!0\n\t\t}\u0016q\b\u0002\u0014%\u0016\u0004H.[2b'R\fG/^:SKN,H\u000e\u001e\u0005\b\u0005\u0007\u0014\u0005\u0019\u0001Bc\u0003MawnZ#oI>3gm]3u!\u0006\u0014Ho\u00148f!\r\u0019'qY\u0005\u0004\u0005\u0013$'\u0001\u0002'p]\u001eDqA!4C\u0001\u0004\u0011)-A\nm_\u001e,e\u000eZ(gMN,G\u000fU1siR;x\u000eC\u0005\u0003R\n\u0003\n\u00111\u0001\u0003F\u0006aB.Y:u\r\u0016$8\r[*pkJ\u001cW\rS5hQ^\u000bG/\u001a:nCJ\\\u0017\u0001R7pG.dunY1m%\u0016\u0004H.[2b'R\fG/^:SKN,H\u000e^,ji\"$\u0015N\u001a4fe\u0016tG\u000fT1hO&tw\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012\u001aTC\u0001BlU\u0011\u0011)M!7,\u0005\tm\u0007\u0003\u0002Bo\u0005Ol!Aa8\u000b\t\t\u0005(1]\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!:e\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005S\u0014yNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq#\\8dWJ+\u0007\u000f\\5dCN#\u0018\r^;t%\u0016\u001cX\u000f\u001c;\u0015\u0011\tm&q\u001eBz\u0007\u001bAqA!=E\u0001\u0004\u0011)-\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000fC\u0004\u0003v\u0012\u0003\rAa>\u0002\u00175L'O]8s'R\fG/\u001a\t\u0005\u0005s\u001c9A\u0004\u0003\u0003|\u000e\u0005a\u0002\u0002BW\u0005{LAAa@\u00030\u0006i!+\u001a9mS\u000e\f7\u000b^1ukNLAaa\u0001\u0004\u0006\u0005QQ*\u001b:s_JLeNZ8\u000b\t\t}(qV\u0005\u0005\u0007\u0013\u0019YAA\u0003Ti\u0006$XM\u0003\u0003\u0004\u0004\r\u0015\u0001\"\u0003Bi\tB\u0005\t\u0019\u0001Bc\u0003\u0005jwnY6SKBd\u0017nY1Ti\u0006$Xo\u001d*fgVdG\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003\u001djwnY6SKBd\u0017nY1Ti\u0006$Xo\u001d*fgVdGoV5uQ:{W*\u001b:s_JLeNZ8\u0015\t\tm6Q\u0003\u0005\b\u0005c4\u0005\u0019\u0001Bc\u00035jwnY6SK6|G/\u001a*fa2L7-Y*uCR,8oV5uQ\u0012KgMZ3sK:$\b+\u0019:uSRLwN\u001c\u000b\u0005\u0003[\u001cY\u0002C\u0004\u0004\u001e\u001d\u0003\raa\b\u0002\u0013A\f'\u000f^5uS>t\u0007CBB\u0011\u0007S\tiH\u0004\u0003\u0004$\r\u0015\u0002cAA6I&\u00191q\u00053\u0002\rA\u0013X\rZ3g\u0013\u0011\u0019Yc!\f\u0003\u0007M+GOC\u0002\u0004(\u0011\fq#\\8dWJ+Wn\u001c;f%\u0016\u0004H.[2b'R\fG/^:\u0015\t\u0005581\u0007\u0005\n\u0005cD\u0005\u0013!a\u0001\u0005\u000b\f\u0011%\\8dWJ+Wn\u001c;f%\u0016\u0004H.[2b'R\fG/^:%I\u00164\u0017-\u001e7uIE\nq%\\8dWJ+Wn\u001c;f%\u0016\u0004H.[2b'R\fG/^:XSRDgj\\'jeJ|'/\u00138g_R!\u0011Q^B\u001e\u0011%\u0011\tP\u0013I\u0001\u0002\u0004\u0011)-A\u0019n_\u000e\\'+Z7pi\u0016\u0014V\r\u001d7jG\u0006\u001cF/\u0019;vg^KG\u000f\u001b(p\u001b&\u0014(o\u001c:J]\u001a|G\u0005Z3gCVdG\u000fJ\u0019\u0002M5|7m\u001b'pG\u0006d'+\u001a9mS\u000e\f7\u000b^1ukN<\u0016\u000e\u001e5O_6K'O]8s\u0013:4w\u000e\u0006\u0003\u0002n\u000e\r\u0003\"\u0003By\u0019B\u0005\t\u0019\u0001Bc\u0003AjwnY6M_\u000e\fGNU3qY&\u001c\u0017m\u0015;biV\u001cx+\u001b;i\u001d>l\u0015N\u001d:pe&sgm\u001c\u0013eK\u001a\fW\u000f\u001c;%c\u0005!Sn\\2l%\u0016lw\u000e^3SKBd\u0017nY1Ti\u0006$Xo],ji\",\u0005pY3qi&|g\u000e\u0006\u0003\u0002n\u000e-\u0003b\u0002B:\u001d\u0002\u0007!QO\u0001-[>\u001c7NU3n_R,'+\u001a9mS\u000e\f7\u000b^1ukN<\u0016\u000e\u001e5Fq\u000e,\u0007\u000f^5p]&sg)\u001e;ve\u0016$B!!<\u0004R!9!1O(A\u0002\tU\u0014\u0001L7pG.dunY1m%\u0016\u0004H.[2b'R\fG/^:XSRDG)\u001b4gKJ,g\u000e\u001e)beRLG/[8o)\u0011\tioa\u0016\t\u000f\ru\u0001\u000b1\u0001\u0004 \u00051Rn\\2l\u0019>\u001c\u0017\r\u001c*fa2L7-Y*uCR,8/A\u0012n_\u000e\\Gj\\2bYJ+\u0007\u000f\\5dCN#\u0018\r^;t/&$\b.\u0012=dKB$\u0018n\u001c8\u0015\t\u000558q\f\u0005\b\u0005g\u0012\u0006\u0019\u0001B;\u0003-jwnY6M_\u000e\fGNU3qY&\u001c\u0017m\u0015;biV\u001cx+\u001b;i\u000bb\u001cW\r\u001d;j_:LeNR;ukJ,G\u0003BAw\u0007KBqAa\u001dT\u0001\u0004\u0011)(\u0001\tbgN,'\u000f^\"p[BdW\r^5p]RQ\u0011Q^B6\u0007k\u001ayha(\t\u0013\r5D\u000b%AA\u0002\r=\u0014!D3ya\u0016\u001cG/\u001a3WC2,X\rE\u0002d\u0007cJ1aa\u001de\u0005\u001d\u0011un\u001c7fC:D\u0011ba\u001eU!\u0003\u0005\ra!\u001f\u0002#\u0015D\b/Z2uK\u0012,\u0005pY3qi&|g\u000eE\u0003d\u0007w\u0012)(C\u0002\u0004~\u0011\u0014aa\u00149uS>t\u0007\"CBA)B\u0005\t\u0019ABB\u0003I)\u0007\u0010]3di\u0016$G+Y:l%\u0016\u001cX\u000f\u001c;\u0011\u000b\r\u001cYh!\"\u0011\t\r\u001d5\u0011\u0014\b\u0005\u0007\u0013\u001b)J\u0004\u0003\u0004\f\u000eMe\u0002BBG\u0007#sA!a\u001b\u0004\u0010&\tq,\u0003\u0002^=&\u00111\fX\u0005\u0004\u0007/S\u0016\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0003\u0003\u0004\u001c\u000eu%A\u0003+bg.\u0014Vm];mi*\u00191q\u0013.\t\u0013\r\u0005F\u000b%AA\u0002\t\u0015\u0017a\u0002;j[\u0016|W\u000f^\u0001\u001bCN\u001cXM\u001d;D_6\u0004H.\u001a;j_:$C-\u001a4bk2$H%M\u000b\u0003\u0007OSCaa\u001c\u0003Z\u0006Q\u0012m]:feR\u001cu.\u001c9mKRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0016\u0016\u0005\u0007s\u0012I.\u0001\u000ebgN,'\u000f^\"p[BdW\r^5p]\u0012\"WMZ1vYR$3'\u0006\u0002\u00044*\"11\u0011Bm\u0003i\t7o]3si\u000e{W\u000e\u001d7fi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00135\u0001")
public class ClusterLinkReverseAndSwapMirrorTest {
    private final String topic;
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler(0, 100);
    private final ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final ConfluentAdmin localAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkBatchAdmin localBatchAdmin = new ClusterLinkNonBatchingAdmin((Function0 & Serializable)() -> this.localAdmin());
    private final ConfluentAdmin remoteAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkBatchAdmin remoteBatchAdmin = new ClusterLinkNonBatchingAdmin((Function0 & Serializable)() -> this.remoteAdmin());
    private final List<TopicPartition> partitions = new .colon.colon((Object)new TopicPartition(this.topic(), 0), (List)new .colon.colon((Object)new TopicPartition(this.topic(), 1), (List)Nil$.MODULE$));
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final ClusterLinkRequestQuota quota = UnboundedClusterLinkRequestQuota$.MODULE$;
    private final Time time = new MockTime();
    private final ClusterLinkMetrics metrics = (ClusterLinkMetrics)Mockito.mock(ClusterLinkMetrics.class);
    private final Sensor sensor = (Sensor)Mockito.mock(Sensor.class);
    private final ClusterLinkData linkData = new ClusterLinkData("test-link", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
    private ClusterLinkReverseAndSwapMirror reverseAndSwapMirrorTopic;

    private String topic() {
        return this.topic;
    }

    private String linkName() {
        return this.linkName;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ConfluentAdmin localAdmin() {
        return this.localAdmin;
    }

    private ClusterLinkBatchAdmin localBatchAdmin() {
        return this.localBatchAdmin;
    }

    private ConfluentAdmin remoteAdmin() {
        return this.remoteAdmin;
    }

    private ClusterLinkBatchAdmin remoteBatchAdmin() {
        return this.remoteBatchAdmin;
    }

    private List<TopicPartition> partitions() {
        return this.partitions;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private ClusterLinkRequestQuota quota() {
        return this.quota;
    }

    private Time time() {
        return this.time;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private Sensor sensor() {
        return this.sensor;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    private ClusterLinkReverseAndSwapMirror reverseAndSwapMirrorTopic() {
        return this.reverseAndSwapMirrorTopic;
    }

    private void reverseAndSwapMirrorTopic_$eq(ClusterLinkReverseAndSwapMirror x$1) {
        this.reverseAndSwapMirrorTopic = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        Mockito.reset((Object[])new ClusterLinkDestClientManager[]{this.clientManager()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.reset((Object[])new ConfluentAdmin[]{this.localAdmin()});
        Mockito.reset((Object[])new ConfluentAdmin[]{this.remoteAdmin()});
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().metadataManager()).thenReturn((Object)this.metadataManager());
        Mockito.when((Object)this.metadataManager().topicPartitions(this.topic())).thenReturn((Object)this.partitions().toSet());
        Mockito.when((Object)this.metadataManager().metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)this.clientManager().getAdmin()).thenReturn((Object)this.remoteAdmin());
        Mockito.when((Object)this.clientManager().metrics()).thenReturn((Object)this.metrics());
        Mockito.when((Object)this.metrics().clusterLinkTaskActiveSensor((TaskType)ArgumentMatchers.any())).thenReturn((Object)this.sensor());
        Mockito.when((Object)this.metrics().clusterLinkTaskInErrorSensor((TaskType)ArgumentMatchers.any(), (TaskErrorCode)ArgumentMatchers.any())).thenReturn((Object)this.sensor());
        ((Sensor)Mockito.doNothing().when((Object)this.sensor())).record();
        Mockito.when((Object)this.clientManager().linkData()).thenReturn((Object)this.linkData());
        this.reverseAndSwapMirrorTopic_$eq(new ClusterLinkReverseAndSwapMirror(this.topic(), this.clientManager(), this.remoteBatchAdmin(), this.localBatchAdmin(), this.time(), this.quota(), 100));
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
    }

    @Test
    public void testReverseAndStartRemoteMirrorTopic() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.StoppedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (Seq)package$.MODULE$.Seq().empty(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map stoppedMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap, (Object[])new Map[]{stoppedMirrorTopicMap});
        this.mockRemoteReplicaStatus(0L);
        this.mockLocalReplicaStatus();
        this.mockLocalPromoteMirror();
        Some x$1 = new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$3, (Option<ClusterLinkScheduler.TaskResult>)x$1, x$4);
    }

    @Test
    public void testReverseAndPauseRemoteMirrorTopic() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkPausedMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.StoppedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (Seq)package$.MODULE$.Seq().empty(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map stoppedMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap, (Object[])new Map[]{stoppedMirrorTopicMap});
        this.mockRemoteReplicaStatus(0L);
        this.mockLocalReplicaStatus();
        this.mockLocalPromoteMirror();
        Some x$1 = new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$3, (Option<ClusterLinkScheduler.TaskResult>)x$1, x$4);
    }

    @Test
    public void testReverseAndStartRemoteMirrorTopicWithDelayInLocalMirrorCatchingUp() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.StoppedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (Seq)package$.MODULE$.Seq().empty(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map stoppedMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap, (Object[])new Map[]{pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, stoppedMirrorTopicMap});
        this.mockRemoteReplicaStatus(5L);
        ReplicaStatusResult replicaStatusResult0 = this.mockReplicaStatusResult(0L, ReplicaStatus.MirrorInfo.State.PENDING_SYNCHRONIZE, 5L);
        ReplicaStatusResult replicaStatusResult1 = this.mockReplicaStatusResult(3L, ReplicaStatus.MirrorInfo.State.PENDING_SYNCHRONIZE, 5L);
        ReplicaStatusResult replicaStatusResult2 = this.mockReplicaStatusResult(5L, ReplicaStatus.MirrorInfo.State.PENDING_SYNCHRONIZE, 5L);
        Mockito.when((Object)this.localAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)replicaStatusResult0, (Object[])new ReplicaStatusResult[]{replicaStatusResult1, replicaStatusResult2});
        this.mockLocalPromoteMirror();
        this.reverseAndSwapMirrorTopic().runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.reverseAndSwapMirrorTopic().isShuttingDown()));
        this.reverseAndSwapMirrorTopic().runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.reverseAndSwapMirrorTopic().isShuttingDown()));
        this.reverseAndSwapMirrorTopic().runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.reverseAndSwapMirrorTopic().isShuttingDown()));
    }

    @Test
    public void testReverseAndStartRemoteMirrorTopicWithDelayInLocalMirrorCatchingUpWithDifferentPartitions() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.StoppedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (Seq)package$.MODULE$.Seq().empty(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map stoppedMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap, (Object[])new Map[]{pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, stoppedMirrorTopicMap});
        this.mockRemoteReplicaStatus(5L);
        ReplicaStatusResult replicaStatusResult0 = this.mockLocalReplicaStatusResultWithDifferentLaggingPartitions(0L, 3L, 5L);
        ReplicaStatusResult replicaStatusResult1 = this.mockLocalReplicaStatusResultWithDifferentLaggingPartitions(5L, 3L, 5L);
        ReplicaStatusResult replicaStatusResult2 = this.mockLocalReplicaStatusResultWithDifferentLaggingPartitions(5L, 5L, 5L);
        Mockito.when((Object)this.localAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)replicaStatusResult0, (Object[])new ReplicaStatusResult[]{replicaStatusResult1, replicaStatusResult2});
        List laggingPartition = (List)this.partitions().tail();
        Mockito.when((Object)this.localAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)laggingPartition.toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)replicaStatusResult2);
        this.mockLocalPromoteMirror();
        this.reverseAndSwapMirrorTopic().runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.reverseAndSwapMirrorTopic().isShuttingDown()));
        this.reverseAndSwapMirrorTopic().runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.reverseAndSwapMirrorTopic().isShuttingDown()));
        this.reverseAndSwapMirrorTopic().runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.reverseAndSwapMirrorTopic().isShuttingDown()));
    }

    @Test
    public void testReverseAndStartRemoteMirrorTopicWithRemoteLogEndOffsetChangedAfterCaughtUp() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.StoppedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (Seq)package$.MODULE$.Seq().empty(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map stoppedMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap, (Object[])new Map[]{pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, stoppedMirrorTopicMap});
        this.mockRemoteReplicaStatus(0L);
        this.mockLocalReplicaStatus();
        this.mockRemoteReplicaStatus(5L);
        ReplicaStatusResult replicaStatusResult0 = this.mockLocalReplicaStatusResultWithDifferentLaggingPartitions(0L, 3L, 5L);
        ReplicaStatusResult replicaStatusResult1 = this.mockLocalReplicaStatusResultWithDifferentLaggingPartitions(5L, 3L, 5L);
        ReplicaStatusResult replicaStatusResult2 = this.mockLocalReplicaStatusResultWithDifferentLaggingPartitions(5L, 5L, 5L);
        Mockito.when((Object)this.localAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)replicaStatusResult0, (Object[])new ReplicaStatusResult[]{replicaStatusResult1, replicaStatusResult2});
        List laggingPartition = (List)this.partitions().tail();
        Mockito.when((Object)this.localAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)laggingPartition.toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)replicaStatusResult2);
        this.mockRemoteReplicaStatus(5L);
        this.mockLocalPromoteMirror();
        this.reverseAndSwapMirrorTopic().runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.reverseAndSwapMirrorTopic().isShuttingDown()));
        this.reverseAndSwapMirrorTopic().runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.reverseAndSwapMirrorTopic().isShuttingDown()));
        this.reverseAndSwapMirrorTopic().runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.reverseAndSwapMirrorTopic().isShuttingDown()));
    }

    @Test
    public void testReverseAndStartRemoteMirrorTopicWithRepartitioning() {
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.StoppedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (Seq)package$.MODULE$.Seq().empty(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map stoppedMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap, (Object[])new Map[]{pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, pendingSynchronizeTopicMap, stoppedMirrorTopicMap});
        scala.collection.immutable.Set originalPartition = Option$.MODULE$.option2Iterable(this.partitions().headOption()).toSet();
        Mockito.when((Object)this.metadataManager().metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)this.metadataManager().topicPartitions(this.topic())).thenReturn((Object)originalPartition);
        this.mockRemoteReplicaStatusWithDifferentPartition((scala.collection.immutable.Set<TopicPartition>)originalPartition);
        this.mockLocalReplicaStatusWithDifferentPartition((scala.collection.immutable.Set<TopicPartition>)originalPartition);
        Mockito.when((Object)this.metadataManager().topicPartitions(this.topic())).thenReturn((Object)this.partitions().toSet());
        this.mockRemoteReplicaStatus(5L);
        ReplicaStatusResult replicaStatusResult0 = this.mockLocalReplicaStatusResultWithDifferentLaggingPartitions(0L, 3L, 5L);
        ReplicaStatusResult replicaStatusResult1 = this.mockLocalReplicaStatusResultWithDifferentLaggingPartitions(5L, 3L, 5L);
        ReplicaStatusResult replicaStatusResult2 = this.mockLocalReplicaStatusResultWithDifferentLaggingPartitions(5L, 5L, 5L);
        Mockito.when((Object)this.localAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)replicaStatusResult0, (Object[])new ReplicaStatusResult[]{replicaStatusResult1, replicaStatusResult2});
        List laggingPartition = (List)this.partitions().tail();
        Mockito.when((Object)this.localAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)laggingPartition.toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)replicaStatusResult2);
        this.mockRemoteReplicaStatus(5L);
        this.mockLocalPromoteMirror();
        this.reverseAndSwapMirrorTopic().runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.reverseAndSwapMirrorTopic().isShuttingDown()));
        this.reverseAndSwapMirrorTopic().runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.reverseAndSwapMirrorTopic().isShuttingDown()));
        this.reverseAndSwapMirrorTopic().runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.reverseAndSwapMirrorTopic().isShuttingDown()));
    }

    @Test
    public void testClusterLinkReverseAndSwapMirrorTopicWithDeletedTopic() {
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.when((Object)this.metadataManager().topicPartitions(this.topic())).thenReturn((Object)Predef$.MODULE$.Set().empty());
        Some x$1 = new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$3, (Option<ClusterLinkScheduler.TaskResult>)x$1, x$4);
    }

    @Test
    public void testClusterLinkReverseAndSwapMirrorTopicWithUnsupportedState() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopicError.UNKNOWN, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map failedMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)failedMirrorTopicMap);
        Some x$1 = new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$3, (Option<ClusterLinkScheduler.TaskResult>)x$1, x$4);
    }

    @Test
    public void testClusterLinkReverseAndSwapMirrorTopicWithNoMirrorState() {
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)Predef$.MODULE$.Map().empty());
        Some x$1 = new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$3, (Option<ClusterLinkScheduler.TaskResult>)x$1, x$4);
    }

    @Test
    public void testClusterLinkReverseAndSwapMirrorTopicWithRemoteMirrorStatusNotPresent() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.StoppedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (Seq)package$.MODULE$.Seq().empty(), Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map stoppedMirrorTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap, (Object[])new Map[]{stoppedMirrorTopicMap});
        this.mockRemoteReplicaStatusWithNoMirrorInfo(0L);
        this.mockRemoteReplicaStatus(0L);
        this.mockLocalReplicaStatus();
        this.mockLocalPromoteMirror();
        Some x$1 = new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$3, (Option<ClusterLinkScheduler.TaskResult>)x$1, x$4);
    }

    @Test
    public void testClusterLinkReverseAndSwapMirrorTopicWithLocalMirrorStatusNotPresent() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap);
        this.mockRemoteReplicaStatus(0L);
        this.mockLocalReplicaStatusWithNoMirrorInfo(0L);
        Some x$1 = new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$3, (Option<ClusterLinkScheduler.TaskResult>)x$1, x$4);
    }

    @Test
    public void testReverseAndStartRemoteMirrorTopicWithRemoteReplicaStatusException() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap);
        TimeoutException ex = new TimeoutException("took too long");
        this.mockRemoteReplicaStatusWithException((Throwable)ex);
        Some x$1 = new Some((Object)ex);
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$1, (Option<ClusterLinkScheduler.TaskResult>)x$3, x$4);
    }

    @Test
    public void testReverseAndStartRemoteMirrorTopicWithRemoteReplicaStatusExceptionInFuture() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap);
        TimeoutException ex = new TimeoutException("took too long");
        this.mockRemoteReplicaStatusWithExceptionInFuture((Throwable)ex);
        Some x$1 = new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Failed to get the remote replicas statuses for topic mirror-topic for an unknown reason."), (List)Nil$.MODULE$)));
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$3, (Option<ClusterLinkScheduler.TaskResult>)x$1, x$4);
    }

    @Test
    public void testReverseAndStartRemoteMirrorTopicWithRemoteReplicaStatusAuthenticationExceptionInFuture() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap);
        AuthenticationException ex = new AuthenticationException("auth issue");
        this.mockRemoteReplicaStatusWithExceptionInFuture((Throwable)ex);
        Some x$1 = new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)AuthenticationTaskErrorCode$.MODULE$, "Failed to get the remote replicas statuses for topic mirror-topic due to authentication issues."), (List)Nil$.MODULE$)));
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$3, (Option<ClusterLinkScheduler.TaskResult>)x$1, x$4);
    }

    @Test
    public void testReverseAndStartRemoteMirrorTopicWithLocalReplicaStatusException() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap);
        TimeoutException ex = new TimeoutException("took too long");
        this.mockRemoteReplicaStatus(0L);
        this.mockLocalReplicaStatusWithException((Throwable)ex);
        Some x$1 = new Some((Object)ex);
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$1, (Option<ClusterLinkScheduler.TaskResult>)x$3, x$4);
    }

    @Test
    public void testReverseAndStartRemoteMirrorTopicWithLocalReplicaStatusExceptionInFuture() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap);
        TimeoutException ex = new TimeoutException("took too long");
        this.mockRemoteReplicaStatus(0L);
        this.mockLocalReplicaStatusWithExceptionInFuture((Throwable)ex);
        Some x$1 = new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Failed to get the local replicas statuses for topic mirror-topic for an unknown reason."), (List)Nil$.MODULE$)));
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$3, (Option<ClusterLinkScheduler.TaskResult>)x$1, x$4);
    }

    @Test
    public void testReverseAndStartRemoteMirrorTopicWithLocalMirrorPromotionExceptionInFuture() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap);
        AuthorizationException ex = new AuthorizationException("bad auth");
        this.mockRemoteReplicaStatus(0L);
        this.mockLocalReplicaStatus();
        this.mockLocalPromoteMirrorWithExceptionInFuture((Throwable)ex);
        Some x$1 = new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)BrokerAuthorizationTaskErrorCode$.MODULE$, "Failed to promote the local mirror topic mirror-topic due to authorization issues."), (List)Nil$.MODULE$)));
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$3, (Option<ClusterLinkScheduler.TaskResult>)x$1, x$4);
    }

    @Test
    public void testReverseAndStartRemoteMirrorTopicWithLocalMirrorPromotionException() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)TopicLinkMirror$.MODULE$, Time.SYSTEM.milliseconds()));
        scala.collection.immutable.Map pendingSynchronizeTopicMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).thenReturn((Object)pendingSynchronizeTopicMap);
        AuthorizationException ex = new AuthorizationException("bad auth");
        this.mockRemoteReplicaStatus(0L);
        this.mockLocalReplicaStatus();
        this.mockLocalPromoteMirrorWithException((Throwable)ex);
        Some x$1 = new Some((Object)ex);
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        long x$4 = 1L;
        this.assertCompletion(x$2, (Option<Throwable>)x$1, (Option<ClusterLinkScheduler.TaskResult>)x$3, x$4);
    }

    private void mockLocalPromoteMirror() {
        Mockito.when((Object)this.localAdmin().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(this.topic(), AlterMirrorOp.PROMOTE)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)new AlterMirrorsResult(Collections.singletonMap(this.topic(), this.alterMirrorsFuture())));
    }

    private void mockLocalPromoteMirrorWithExceptionInFuture(Throwable e) {
        KafkaFutureImpl localPromoteMirrorFuture = new KafkaFutureImpl();
        localPromoteMirrorFuture.completeExceptionally(e);
        Mockito.when((Object)this.localAdmin().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(this.topic(), AlterMirrorOp.PROMOTE)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)new AlterMirrorsResult(Collections.singletonMap(this.topic(), localPromoteMirrorFuture)));
    }

    private void mockLocalPromoteMirrorWithException(Throwable e) {
        Mockito.when((Object)this.localAdmin().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(this.topic(), AlterMirrorOp.PROMOTE)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
    }

    private KafkaFuture<Void> alterMirrorsFuture() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(null);
        return future;
    }

    private KafkaFuture<PartitionResult> toReplicaStatusEntry(java.util.List<ReplicaStatus> rs) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)new PartitionResult(rs));
        return future;
    }

    private ReplicaStatusResult mockLocalReplicaStatusResultWithDifferentLaggingPartitions(long logEndOffsetPartOne, long logEndOffsetPartTwo, long lastFetchSourceHighWatermark) {
        ReplicaStatus replicaStatusPart0 = new ReplicaStatus(0, true, false, true, true, true, 0L, logEndOffsetPartOne, 0L, 0L, Optional.of(this.linkName()), Optional.of(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.PENDING_SYNCHRONIZE, 0L, lastFetchSourceHighWatermark)), Optional.of("pull"), OptionalLong.of(-1L));
        ReplicaStatus replicaStatusPart1 = new ReplicaStatus(1, true, false, true, true, true, 0L, logEndOffsetPartTwo, 0L, 0L, Optional.of(this.linkName()), Optional.of(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.PENDING_SYNCHRONIZE, 0L, lastFetchSourceHighWatermark)), Optional.of("pull"), OptionalLong.of(-1L));
        KafkaFuture<PartitionResult> partitionResultFuture0 = this.toReplicaStatusEntry(Collections.singletonList(replicaStatusPart0));
        KafkaFuture<PartitionResult> partitionResultFuture1 = this.toReplicaStatusEntry(Collections.singletonList(replicaStatusPart1));
        scala.collection.immutable.Map replicaStatusMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.partitions().head()), partitionResultFuture0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.partitions().apply(1)), partitionResultFuture1)}));
        return new ReplicaStatusResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)replicaStatusMap).asJava());
    }

    private ReplicaStatusResult mockReplicaStatusResult(long logEndOffset, ReplicaStatus.MirrorInfo.State mirrorState, long lastFetchSourceHighWatermark) {
        ReplicaStatus replicaStatusPart0 = new ReplicaStatus(0, true, false, true, true, true, 0L, logEndOffset, 0L, 0L, Optional.of(this.linkName()), Optional.of(new ReplicaStatus.MirrorInfo(mirrorState, 0L, lastFetchSourceHighWatermark)), Optional.of("pull"), OptionalLong.of(-1L));
        ReplicaStatus replicaStatusPart1 = new ReplicaStatus(1, true, false, true, true, true, 0L, logEndOffset, 0L, 0L, Optional.of(this.linkName()), Optional.of(new ReplicaStatus.MirrorInfo(mirrorState, 0L, lastFetchSourceHighWatermark)), Optional.of("pull"), OptionalLong.of(-1L));
        KafkaFuture<PartitionResult> partitionResultFuture0 = this.toReplicaStatusEntry(Collections.singletonList(replicaStatusPart0));
        KafkaFuture<PartitionResult> partitionResultFuture1 = this.toReplicaStatusEntry(Collections.singletonList(replicaStatusPart1));
        scala.collection.immutable.Map replicaStatusMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.partitions().head()), partitionResultFuture0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.partitions().apply(1)), partitionResultFuture1)}));
        return new ReplicaStatusResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)replicaStatusMap).asJava());
    }

    private long mockReplicaStatusResult$default$3() {
        return 0L;
    }

    private ReplicaStatusResult mockReplicaStatusResultWithNoMirrorInfo(long logEndOffset) {
        ReplicaStatus replicaStatusPart0 = new ReplicaStatus(0, true, false, true, true, true, 0L, logEndOffset, 0L, 0L, Optional.empty(), Optional.empty(), Optional.of("pull"), OptionalLong.of(-1L));
        ReplicaStatus replicaStatusPart1 = new ReplicaStatus(1, true, false, true, true, true, 0L, logEndOffset, 0L, 0L, Optional.empty(), Optional.empty(), Optional.of("pull"), OptionalLong.of(-1L));
        KafkaFuture<PartitionResult> partitionResultFuture0 = this.toReplicaStatusEntry(Collections.singletonList(replicaStatusPart0));
        KafkaFuture<PartitionResult> partitionResultFuture1 = this.toReplicaStatusEntry(Collections.singletonList(replicaStatusPart1));
        scala.collection.immutable.Map replicaStatusMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.partitions().head()), partitionResultFuture0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.partitions().apply(1)), partitionResultFuture1)}));
        return new ReplicaStatusResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)replicaStatusMap).asJava());
    }

    private void mockRemoteReplicaStatusWithDifferentPartition(scala.collection.immutable.Set<TopicPartition> partition) {
        Mockito.when((Object)this.remoteAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava(partition).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockReplicaStatusResult(0L, ReplicaStatus.MirrorInfo.State.PENDING_MIRROR, 0L));
    }

    private void mockRemoteReplicaStatus(long logEndOffset) {
        Mockito.when((Object)this.remoteAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockReplicaStatusResult(logEndOffset, ReplicaStatus.MirrorInfo.State.PENDING_MIRROR, 0L));
    }

    private long mockRemoteReplicaStatus$default$1() {
        return 0L;
    }

    private void mockRemoteReplicaStatusWithNoMirrorInfo(long logEndOffset) {
        Mockito.when((Object)this.remoteAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockReplicaStatusResultWithNoMirrorInfo(logEndOffset));
    }

    private long mockRemoteReplicaStatusWithNoMirrorInfo$default$1() {
        return 0L;
    }

    private void mockLocalReplicaStatusWithNoMirrorInfo(long logEndOffset) {
        Mockito.when((Object)this.localAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockReplicaStatusResultWithNoMirrorInfo(logEndOffset));
    }

    private void mockRemoteReplicaStatusWithException(Throwable e) {
        Mockito.when((Object)this.remoteAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
    }

    private void mockRemoteReplicaStatusWithExceptionInFuture(Throwable e) {
        HashMap map = new HashMap();
        this.partitions().foreach((Function1 & Serializable)p -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally(e);
            return (KafkaFuture)map.put(p, future);
        });
        ReplicaStatusResult res = new ReplicaStatusResult(map);
        Mockito.when((Object)this.remoteAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)res);
    }

    private void mockLocalReplicaStatusWithDifferentPartition(scala.collection.immutable.Set<TopicPartition> partition) {
        Mockito.when((Object)this.localAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava(partition).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockReplicaStatusResult(0L, ReplicaStatus.MirrorInfo.State.PENDING_MIRROR, 0L));
    }

    private void mockLocalReplicaStatus() {
        Mockito.when((Object)this.localAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)this.mockReplicaStatusResult(0L, ReplicaStatus.MirrorInfo.State.PENDING_SYNCHRONIZE, 0L));
    }

    private long mockLocalReplicaStatusResultWithDifferentLaggingPartitions$default$3() {
        return 5L;
    }

    private long mockLocalReplicaStatusWithNoMirrorInfo$default$1() {
        return 0L;
    }

    private void mockLocalReplicaStatusWithException(Throwable e) {
        Mockito.when((Object)this.localAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
    }

    private void mockLocalReplicaStatusWithExceptionInFuture(Throwable e) {
        HashMap map = new HashMap();
        this.partitions().foreach((Function1 & Serializable)p -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally(e);
            return (KafkaFuture)map.put(p, future);
        });
        ReplicaStatusResult res = new ReplicaStatusResult(map);
        Mockito.when((Object)this.localAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.partitions().toSet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)res);
    }

    private void assertCompletion(boolean expectedValue, Option<Throwable> expectedException, Option<ClusterLinkScheduler.TaskResult> expectedTaskResult, long timeout) {
        try {
            ClusterLinkScheduler.TaskResult result = (ClusterLinkScheduler.TaskResult)this.reverseAndSwapMirrorTopic().runOnce().get(timeout, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectedValue), (Object)BoxesRunTime.boxToBoolean((boolean)result.completed()));
            Assertions.assertEquals(expectedTaskResult, (Object)new Some((Object)result));
            return;
        }
        catch (Throwable ex) {
            Assertions.assertTrue((boolean)expectedException.isDefined(), (String)new StringBuilder(36).append("Exception caught but none expected: ").append(ex).toString());
            return;
        }
    }

    private boolean assertCompletion$default$1() {
        return true;
    }

    private Option<Throwable> assertCompletion$default$2() {
        return None$.MODULE$;
    }

    private Option<ClusterLinkScheduler.TaskResult> assertCompletion$default$3() {
        return None$.MODULE$;
    }

    private long assertCompletion$default$4() {
        return 1L;
    }

    public ClusterLinkReverseAndSwapMirrorTest() {
        this.topic = "mirror-topic";
        this.linkName = "link-name";
    }
}

