/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.LinkRequestQuotaUsageType;
import kafka.server.UnboundedClusterLinkRequestQuota$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.SuppressedErrorsErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001\u0002\u000f\u001e\u0001\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u00045\u0001\u0001\u0006I!\r\u0005\bk\u0001\u0001\r\u0011\"\u00017\u0011\u001dq\u0004\u00011A\u0005\u0002}Ba!\u0012\u0001!B\u00139\u0004b\u0002$\u0001\u0005\u0004%Ia\u0012\u0005\u0007+\u0002\u0001\u000b\u0011\u0002%\t\u000fY\u0003!\u0019!C\u0005/\"11\f\u0001Q\u0001\naCq\u0001\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004o\u0001\u0001\u0006IA\u0018\u0005\u0006_\u0002!I\u0001\u001d\u0005\u0006k\u0002!IA\u001e\u0005\u0006q\u0002!I!\u001f\u0005\u0006w\u0002!I\u0001 \u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\ti\u0003\u0001C\u0001\u0003+Aq!a\u000e\u0001\t\u0003\t)\u0002C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011\u001d\tY\n\u0001C\u0001\u0003;Cq!a*\u0001\t\u0003\tI\u000bC\u0004\u00024\u0002!\t!!\u0006\u00031\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s)\u0016\u001cHO\u0003\u0002\u001f?\u0005!A.\u001b8l\u0015\t\u0001\u0013%\u0001\u0004tKJ4XM\u001d\u0006\u0002E\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001&!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\f\t\u0003]\u0001i\u0011!H\u0001\ng\u000eDW\rZ;mKJ,\u0012!\r\t\u0003]IJ!aM\u000f\u0003)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0005i\u0006\u001c8.F\u00018!\tA4H\u0004\u0002/s%\u0011!(H\u0001\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\u0005qj$\u0001\u0004)fe&|G-[2UCN\\'B\u0001\u001e\u001e\u0003!!\u0018m]6`I\u0015\fHC\u0001!D!\t1\u0013)\u0003\u0002CO\t!QK\\5u\u0011\u001d!U!!AA\u0002]\n1\u0001\u001f\u00132\u0003\u0015!\u0018m]6!\u0003\u0011!\u0018.\\3\u0016\u0003!\u0003\"!S*\u000e\u0003)S!a\u0013'\u0002\u000bU$\u0018\u000e\\:\u000b\u00055s\u0015AB2p[6|gN\u0003\u0002#\u001f*\u0011\u0001+U\u0001\u0007CB\f7\r[3\u000b\u0003I\u000b1a\u001c:h\u0013\t!&J\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u00031!\bN]8ui2,G+[7f+\u0005A\u0006C\u0001\u0014Z\u0013\tQvEA\u0002J]R\fQ\u0002\u001e5s_R$H.\u001a+j[\u0016\u0004\u0013!C3yG\"\fgnZ3s+\u0005q\u0006cA0gQ6\t\u0001M\u0003\u0002bE\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\r$\u0017\u0001B;uS2T\u0011!Z\u0001\u0005U\u00064\u0018-\u0003\u0002hA\nIQ\t_2iC:<WM\u001d\t\u0003S2l\u0011A\u001b\u0006\u0003W\u0012\fA\u0001\\1oO&\u0011QN\u001b\u0002\b\u0013:$XmZ3s\u0003))\u0007p\u00195b]\u001e,'\u000fI\u0001\u000fKb\u001c\u0007.\u00198hK\u0016C\b/Z2u)\r\u0001\u0015o\u001d\u0005\u0006e6\u0001\r\u0001[\u0001\u0006m\u0006dW/\u001a\u0005\u0006i6\u0001\r\u0001[\u0001\u0007Kb\u0004Xm\u0019;\u0002\u0015Q,7\u000f\u001e(pi&4\u0017\u0010\u0006\u0002Ao\")!O\u0004a\u0001Q\u0006AA/Z:u/\u0006LG\u000f\u0006\u0002Au\")!o\u0004a\u0001Q\u0006yq-\u001a;SKF,Xm\u001d;Rk>$\u0018\rF\u0002~\u0003\u0013\u0011BA`\u0013\u0002\u0002\u0019!q\u0010\u0005\u0001~\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0011\t\u0019!!\u0002\u000e\u0003}I1!a\u0002 \u0005]\u0019E.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018\rC\u0004\u0002\fA\u0001\r!!\u0004\u0002\u001dUt'm\\;oI\u0016$\u0017+^8uCB\u0019a%a\u0004\n\u0007\u0005EqEA\u0004C_>dW-\u00198\u0002\u000bM,G/\u00169\u0015\u0003\u0001C3!EA\r!\u0011\tY\"!\u000b\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\t1!\u00199j\u0015\u0011\t\u0019#!\n\u0002\u000f),\b/\u001b;fe*\u0019\u0011qE)\u0002\u000b),h.\u001b;\n\t\u0005-\u0012Q\u0004\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007I\t\t\u0004\u0005\u0003\u0002\u001c\u0005M\u0012\u0002BA\u001b\u0003;\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u00021Q,7\u000f^*dQ\u0016$W\u000f\\3XQ\u0016t7i\\7qY\u0016$X\rK\u0002\u0014\u0003w\u0001B!a\u0007\u0002>%!\u0011qHA\u000f\u0005\u0011!Vm\u001d;\u0002-Q,7\u000f\u001e)fe&|G-[2UCN\\\u0007+\u001a:j_\u0012$2\u0001QA#\u0011\u001d\tY\u0001\u0006a\u0001\u0003\u001bA3\u0001FA%!\u0011\tY%!\u0015\u000e\u0005\u00055#\u0002BA(\u0003C\ta\u0001]1sC6\u001c\u0018\u0002BA*\u0003\u001b\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001d!\u0012qKA2\u0003K\u0002B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0005\u0003;\ni%\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\t\t'a\u0017\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\tE>|G.Z1og2\"\u0011qMA53\u0005\t\u0011$\u0001\u0001\u00021Q,7\u000f\u001e)fe&|G-[2UCN\\7k\u00195fIVdW\rF\u0002A\u0003_Bq!a\u0003\u0016\u0001\u0004\ti\u0001K\u0002\u0016\u0003\u0013Bs!FA,\u0003G\n)\b\f\u0003\u0002h\u0005%\u0014!\u0007;fgR\u0004VM]5pI&\u001cG+Y:l\u000bb\u001cW\r\u001d;j_:$2\u0001QA>\u0011\u001d\tYA\u0006a\u0001\u0003\u001bA3AFA%Q\u001d1\u0012qKA2\u0003\u0003cC!a\u001a\u0002j\u0005YA/Z:u%VtwJ\\2f)\r\u0001\u0015q\u0011\u0005\b\u0003\u00179\u0002\u0019AA\u0007Q\r9\u0012\u0011\n\u0015\b/\u0005]\u00131MAGY\u0011\t9'!\u001b\u0002)Q,7\u000f\u001e*v]>s7-Z#yG\u0016\u0004H/[8o)\r\u0001\u00151\u0013\u0005\b\u0003\u0017A\u0002\u0019AA\u0007Q\rA\u0012\u0011\n\u0015\b1\u0005]\u00131MAMY\u0011\t9'!\u001b\u0002IQ,7\u000f\u001e)fe&|G-[2UCN\\W\t_3dkR,7o\u00148D_6\u0004H.\u001a;j_:$2\u0001QAP\u0011\u001d\tY!\u0007a\u0001\u0003\u001bA3!GA%Q\u001dI\u0012qKA2\u0003KcC!a\u001a\u0002j\u0005\u0011D/Z:u!\u0016\u0014\u0018n\u001c3jGR\u000b7o[#yK\u000e,H/Z:P]\u000e{W\u000e\u001d7fi&|g.\u00114uKJ,\u0005pY3qi&|g\u000eF\u0002A\u0003WCq!a\u0003\u001b\u0001\u0004\ti\u0001K\u0002\u001b\u0003\u0013BsAGA,\u0003G\n\t\f\f\u0003\u0002h\u0005%\u0014a\u0006;fgR\u001c6\r[3ek2,'\u000f\u00165sK\u0006$g*Y7fQ\rY\u00121\b")
public class ClusterLinkSchedulerTest {
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler(0, 2);
    private ClusterLinkScheduler.PeriodicTask task = null;
    private final MockTime kafka$server$link$ClusterLinkSchedulerTest$$time = new MockTime();
    private final int kafka$server$link$ClusterLinkSchedulerTest$$throttleTime;
    private final Exchanger<Integer> exchanger = new Exchanger();

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public ClusterLinkScheduler.PeriodicTask task() {
        return this.task;
    }

    public void task_$eq(ClusterLinkScheduler.PeriodicTask x$1) {
        this.task = x$1;
    }

    public MockTime kafka$server$link$ClusterLinkSchedulerTest$$time() {
        return this.kafka$server$link$ClusterLinkSchedulerTest$$time;
    }

    public int kafka$server$link$ClusterLinkSchedulerTest$$throttleTime() {
        return this.kafka$server$link$ClusterLinkSchedulerTest$$throttleTime;
    }

    private Exchanger<Integer> exchanger() {
        return this.exchanger;
    }

    private void exchangeExpect(Integer value, Integer expect) {
        Assertions.assertEquals((Integer)expect, (Integer)this.exchanger().exchange(value, 1L, TimeUnit.SECONDS));
    }

    public void kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Integer value) {
        this.exchangeExpect(value, null);
    }

    public void kafka$server$link$ClusterLinkSchedulerTest$$testWait(Integer value) {
        this.exchangeExpect(null, value);
    }

    private ClusterLinkRequestQuota getRequestQuota(boolean unboundedQuota) {
        if (unboundedQuota) {
            return UnboundedClusterLinkRequestQuota$.MODULE$;
        }
        return new ClusterLinkRequestQuota(this){
            private final /* synthetic */ ClusterLinkSchedulerTest $outer;

            public void record(long nanos, LinkRequestQuotaUsageType usageType) {
                Assertions.assertEquals((Object)LinkRequestQuotaUsageType.Scheduler$.MODULE$, (Object)usageType);
            }

            public boolean isQuotaExceeded() {
                return true;
            }

            public int getThrottleTimeMs(long value) {
                return this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$throttleTime();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
    }

    @AfterEach
    public void tearDown() {
        if (this.task() != null) {
            this.task().shutdown();
        }
        this.scheduler().shutdown();
    }

    @Test
    public void testScheduleWhenComplete() {
        KafkaFutureImpl future1 = new KafkaFutureImpl();
        this.scheduler().scheduleWhenComplete("test", (KafkaFuture)future1, () -> this.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(1)));
        Thread.sleep(10L);
        future1.complete(null);
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(1));
        KafkaFutureImpl future2 = new KafkaFutureImpl();
        this.scheduler().scheduleWhenComplete("test", (KafkaFuture)future2, () -> this.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(2)));
        Thread.sleep(10L);
        future2.completeExceptionally((Throwable)new InvalidRequestException(""));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(2));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPeriodicTaskPeriod(boolean unboundedQuota) {
        int rescheduleDelayMs = 10;
        ClusterLinkRequestQuota quota = this.getRequestQuota(unboundedQuota);
        this.task_$eq(new ClusterLinkScheduler.PeriodicTask(this, rescheduleDelayMs, quota){
            private boolean first;
            private final /* synthetic */ ClusterLinkSchedulerTest $outer;

            private boolean first() {
                return this.first;
            }

            private void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public ClusterLinkScheduler.TaskResult run() {
                if (this.first()) {
                    this.first_$eq(false);
                    this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(1));
                } else {
                    this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(2));
                }
                Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
                return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
            }

            public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
            }

            public Option<TaskDescription> taskDescription() {
                return None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.scheduler(), "TestTask", rescheduleDelayMs$1, (Time)$outer.kafka$server$link$ClusterLinkSchedulerTest$$time(), quota$1);
                this.first = true;
            }
        });
        long start = System.nanoTime();
        this.task().startup();
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(1));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(2));
        Assertions.assertTrue(((double)(System.nanoTime() - start) / 1000000.0 >= (double)(Math.max(rescheduleDelayMs, quota.getThrottleTimeMs(System.currentTimeMillis())) * 2) ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPeriodicTaskSchedule(boolean unboundedQuota) {
        int rescheduleDelayMs = 10;
        KafkaFutureImpl future = new KafkaFutureImpl();
        .colon.colon expectedErrs = new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Internal error 1."), (List)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Internal error 2."), (List)Nil$.MODULE$));
        .colon.colon expectedFinalErrs = new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Internal error 1."), (List)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Internal error 2."), (List)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)SuppressedErrorsErrorCode$.MODULE$, "Suppressed additional error(s)."), (List)Nil$.MODULE$)));
        .colon.colon taskErrorsT1 = new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Internal error 1."), (List)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Internal error 1."), (List)new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Internal error 2."), (List)Nil$.MODULE$)));
        .colon.colon taskErrorsT2 = new .colon.colon((Object)new TaskErrorCodeAndMsg((TaskErrorCode)InternalTaskErrorCode$.MODULE$, "Internal error 3."), (List)Nil$.MODULE$);
        ClusterLinkRequestQuota quota = this.getRequestQuota(unboundedQuota);
        this.task_$eq(new ClusterLinkScheduler.PeriodicTask(this, rescheduleDelayMs, quota, (Seq)expectedFinalErrs, future, (Seq)taskErrorsT1, (Seq)expectedErrs, (Seq)taskErrorsT2){
            private boolean running;
            private boolean done;
            private Seq<TaskErrorCodeAndMsg> finalErrs;
            private final /* synthetic */ ClusterLinkSchedulerTest $outer;
            private final Seq expectedFinalErrs$1;
            private final KafkaFutureImpl future$1;
            private final Seq taskErrorsT1$1;
            private final Seq expectedErrs$1;
            private final Seq taskErrorsT2$1;

            private boolean running() {
                return this.running;
            }

            private void running_$eq(boolean x$1) {
                this.running = x$1;
            }

            private boolean done() {
                return this.done;
            }

            private void done_$eq(boolean x$1) {
                this.done = x$1;
            }

            private Seq<TaskErrorCodeAndMsg> finalErrs() {
                return this.finalErrs;
            }

            private void finalErrs_$eq(Seq<TaskErrorCodeAndMsg> x$1) {
                this.finalErrs = x$1;
            }

            public ClusterLinkScheduler.TaskResult run() {
                Assertions.assertFalse((boolean)this.running());
                if (this.done()) {
                    Assertions.assertEquals((int)3, (int)this.finalErrs().size());
                    Assertions.assertEquals((Object)this.expectedFinalErrs$1, this.finalErrs());
                    this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(6));
                    Seq<TaskErrorCodeAndMsg> completedTask_errs = this.finalErrs();
                    return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
                }
                this.running_$eq(true);
                this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(1));
                this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(2));
                this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1 & Serializable)tc -> this.next((Seq<TaskErrorCodeAndMsg>)tc.errs()), new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty())), 0L);
                Seq inProgressTask_errs = (Seq)package$.MODULE$.Seq().empty();
                return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
            }

            private ClusterLinkScheduler.TaskResult next(Seq<TaskErrorCodeAndMsg> errs) {
                Assertions.assertTrue((boolean)errs.isEmpty());
                Assertions.assertTrue((boolean)this.running());
                Assertions.assertFalse((boolean)this.done());
                this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(3));
                this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(4));
                this.scheduleWhenComplete((KafkaFuture)this.future$1, new ClusterLinkScheduler.TaskExecutionState((Function1 & Serializable)tc -> this.finish((Seq<TaskErrorCodeAndMsg>)tc.errs()), new ClusterLinkScheduler.TaskContext(this.taskErrorsT1$1)));
                Seq inProgressTask_errs = this.taskErrorsT1$1;
                return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
            }

            private ClusterLinkScheduler.TaskResult finish(Seq<TaskErrorCodeAndMsg> errs) {
                Assertions.assertTrue((boolean)this.running());
                Assertions.assertFalse((boolean)this.done());
                Assertions.assertEquals((int)2, (int)errs.size());
                Assertions.assertEquals((Object)this.expectedErrs$1.take(2), errs);
                this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(5));
                this.running_$eq(false);
                this.done_$eq(true);
                Seq completedTask_errs = (Seq)errs.$plus$plus((IterableOnce)this.taskErrorsT2$1);
                return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
            }

            public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
                this.finalErrs_$eq((Seq<TaskErrorCodeAndMsg>)result.errs());
            }

            public Option<TaskDescription> taskDescription() {
                return None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedFinalErrs$1 = expectedFinalErrs$1;
                this.future$1 = future$1;
                this.taskErrorsT1$1 = taskErrorsT1$1;
                this.expectedErrs$1 = expectedErrs$1;
                this.taskErrorsT2$1 = taskErrorsT2$1;
                super($outer.scheduler(), "TestTask", rescheduleDelayMs$2, (Time)$outer.kafka$server$link$ClusterLinkSchedulerTest$$time(), quota$2);
                this.running = false;
                this.done = false;
                this.finalErrs = (Seq)package$.MODULE$.Seq().empty();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$next$1(kafka.server.link.ClusterLinkSchedulerTest$$anon$3 kafka.server.link.ClusterLinkScheduler$TaskContext ), $anonfun$run$1(kafka.server.link.ClusterLinkSchedulerTest$$anon$3 kafka.server.link.ClusterLinkScheduler$TaskContext )}, serializedLambda);
            }
        });
        long start = System.nanoTime();
        this.task().startup();
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(1));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(2));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(3));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(4));
        Thread.sleep(rescheduleDelayMs);
        future.complete(null);
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(5));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(6));
        Assertions.assertTrue(((double)(System.nanoTime() - start) / 1000000.0 >= (double)(Math.max(rescheduleDelayMs, quota.getThrottleTimeMs(System.currentTimeMillis())) * 3) ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPeriodicTaskException(boolean unboundedQuota) {
        ClusterLinkRequestQuota quota = this.getRequestQuota(unboundedQuota);
        int rescheduleDelayMs = 10;
        this.task_$eq(new ClusterLinkScheduler.PeriodicTask(this, rescheduleDelayMs, quota){
            private boolean first;
            private final /* synthetic */ ClusterLinkSchedulerTest $outer;

            private boolean first() {
                return this.first;
            }

            private void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public ClusterLinkScheduler.TaskResult run() {
                if (this.first()) {
                    this.first_$eq(false);
                    this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(1));
                    throw new InvalidRequestException("");
                }
                this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(2));
                Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
                return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
            }

            public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
            }

            public Option<TaskDescription> taskDescription() {
                return None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.scheduler(), "TestTask", rescheduleDelayMs$3, (Time)$outer.kafka$server$link$ClusterLinkSchedulerTest$$time(), quota$3);
                this.first = true;
            }
        });
        long start = System.nanoTime();
        this.task().startup();
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(1));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(2));
        Assertions.assertTrue(((double)(System.nanoTime() - start) / 1000000.0 >= (double)(Math.max(rescheduleDelayMs, quota.getThrottleTimeMs(System.currentTimeMillis())) * 2) ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRunOnce(boolean unboundedQuota) {
        ClusterLinkRequestQuota quota = this.getRequestQuota(unboundedQuota);
        this.task_$eq(new ClusterLinkScheduler.PeriodicTask(this, quota){
            private boolean first;
            private final /* synthetic */ ClusterLinkSchedulerTest $outer;

            private boolean first() {
                return this.first;
            }

            private void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public ClusterLinkScheduler.TaskResult run() {
                if (this.first()) {
                    this.first_$eq(false);
                    this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(1));
                } else {
                    this.isShuttingDown_$eq(true);
                    this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(2));
                }
                Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
                return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
            }

            public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
            }

            public Option<TaskDescription> taskDescription() {
                return None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.scheduler(), "TestTask", 10, (Time)$outer.kafka$server$link$ClusterLinkSchedulerTest$$time(), quota$4);
                this.first = true;
            }
        });
        KafkaFuture result1 = this.task().runOnce();
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(1));
        Assertions.assertFalse((boolean)this.task().isShuttingDown());
        Assertions.assertTrue((boolean)((ClusterLinkScheduler.TaskResult)result1.get()).completed());
        KafkaFuture result2 = this.task().runOnce();
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(2));
        Assertions.assertTrue((boolean)this.task().isShuttingDown());
        Assertions.assertTrue((boolean)((ClusterLinkScheduler.TaskResult)result2.get()).completed());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRunOnceException(boolean unboundedQuota) {
        ClusterLinkRequestQuota quota = this.getRequestQuota(unboundedQuota);
        this.task_$eq(new ClusterLinkScheduler.PeriodicTask(this, quota){

            public ClusterLinkScheduler.TaskResult run() {
                throw new InvalidRequestException("");
            }

            public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
            }

            public Option<TaskDescription> taskDescription() {
                return None$.MODULE$;
            }
        });
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.task().runOnce().get());
        Assertions.assertEquals(InvalidRequestException.class, e.getCause().getClass());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPeriodicTaskExecutesOnCompletion(boolean unboundedQuota) {
        int rescheduleDelayMs = 10;
        BooleanRef ranOnCompletion = BooleanRef.create((boolean)false);
        ClusterLinkRequestQuota quota = this.getRequestQuota(unboundedQuota);
        this.task_$eq(new ClusterLinkScheduler.PeriodicTask(this, rescheduleDelayMs, quota, ranOnCompletion){
            private final BooleanRef ranOnCompletion$1;

            public ClusterLinkScheduler.TaskResult run() {
                Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
                return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
            }

            public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
                this.ranOnCompletion$1.elem = true;
            }

            public Option<TaskDescription> taskDescription() {
                return None$.MODULE$;
            }
            {
                this.ranOnCompletion$1 = ranOnCompletion$1;
                super($outer.scheduler(), "TestTask", rescheduleDelayMs$4, (Time)$outer.kafka$server$link$ClusterLinkSchedulerTest$$time(), quota$6);
            }
        });
        Assertions.assertFalse((boolean)ranOnCompletion.elem);
        Assertions.assertTrue((boolean)((ClusterLinkScheduler.TaskResult)this.task().runOnce().get()).completed());
        Assertions.assertTrue((boolean)ranOnCompletion.elem);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPeriodicTaskExecutesOnCompletionAfterException(boolean unboundedQuota) {
        int rescheduleDelayMs = 10;
        BooleanRef ranOnCompletion = BooleanRef.create((boolean)false);
        ClusterLinkRequestQuota quota = this.getRequestQuota(unboundedQuota);
        this.task_$eq(new ClusterLinkScheduler.PeriodicTask(this, rescheduleDelayMs, quota, ranOnCompletion){
            private final BooleanRef ranOnCompletion$2;

            public ClusterLinkScheduler.TaskResult run() {
                throw new RuntimeException("Runtime error");
            }

            public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
                this.ranOnCompletion$2.elem = true;
            }

            public Option<TaskDescription> taskDescription() {
                return None$.MODULE$;
            }
            {
                this.ranOnCompletion$2 = ranOnCompletion$2;
                super($outer.scheduler(), "TestTask", rescheduleDelayMs$5, (Time)$outer.kafka$server$link$ClusterLinkSchedulerTest$$time(), quota$7);
            }
        });
        Assertions.assertFalse((boolean)ranOnCompletion.elem);
        Assertions.assertThrows(ExecutionException.class, () -> this.task().runOnce().get());
        Assertions.assertTrue((boolean)ranOnCompletion.elem);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSchedulerThreadName() {
        void newTask$1_expectedThreadName;
        String string = "cluster-link-scheduler0-0";
        ClusterLinkScheduler newTask$1_scheduler = this.scheduler();
        Object var3_2 = null;
        string = null;
        this.task_$eq(new ClusterLinkScheduler.PeriodicTask(this, newTask$1_scheduler, (String)newTask$1_expectedThreadName){
            private final String expectedThreadName$1;

            public ClusterLinkScheduler.TaskResult run() {
                Assertions.assertEquals((Object)this.expectedThreadName$1, (Object)Thread.currentThread().getName());
                Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
                return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
            }

            public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
            }

            public Option<TaskDescription> taskDescription() {
                return None$.MODULE$;
            }
            {
                this.expectedThreadName$1 = expectedThreadName$1;
                super(scheduler$1, "TestTask", -1, (Time)$outer.kafka$server$link$ClusterLinkSchedulerTest$$time(), (ClusterLinkRequestQuota)UnboundedClusterLinkRequestQuota$.MODULE$);
            }
        });
        this.task().runOnce().get(10L, TimeUnit.SECONDS);
        ClusterLinkScheduler scheduler2 = new ClusterLinkScheduler(2, 100);
        try {
            scheduler2.startup();
            String newTask$1_expectedThreadName2 = "cluster-link-scheduler2-0";
            Object var5_4 = null;
            this.task_$eq(new /* invalid duplicate definition of identical inner class */);
            this.task().runOnce().get(10L, TimeUnit.SECONDS);
        }
        finally {
            scheduler2.shutdown();
        }
    }

    private final ClusterLinkScheduler.PeriodicTask newTask$1(ClusterLinkScheduler scheduler, String expectedThreadName) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public ClusterLinkSchedulerTest() {
        this.kafka$server$link$ClusterLinkSchedulerTest$$throttleTime = 50;
    }
}

