/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkClearStartOffsetsForMirrors;
import kafka.server.link.ClusterLinkConvertTopicsToMirrors;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkRepairMirrors;
import kafka.server.link.ClusterLinkReverseAndSwapMirrors;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkStopMirrors;
import kafka.server.link.ClusterLinkTaskManager;
import kafka.server.link.ClusterLinkTaskManagerTest$Link$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTransitionMirrors;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkState;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t}g\u0001\u0002 @\u0001\u0019CQ!\u0014\u0001\u0005\u00029Cq!\u0015\u0001C\u0002\u0013%!\u000b\u0003\u0004X\u0001\u0001\u0006Ia\u0015\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u00199\u0007\u0001)A\u00055\"9\u0001\u000e\u0001b\u0001\n\u0013I\u0007BB7\u0001A\u0003%!\u000eC\u0004o\u0001\t\u0007I\u0011B8\t\rM\u0004\u0001\u0015!\u0003q\u0011%!\b\u00011AA\u0002\u0013%Q\u000fC\u0005z\u0001\u0001\u0007\t\u0019!C\u0005u\"Q\u0011\u0011\u0001\u0001A\u0002\u0003\u0005\u000b\u0015\u0002<\t\u0017\u0005\r\u0001\u00011AA\u0002\u0013%\u0011Q\u0001\u0005\f\u0003\u001b\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0001C\u0006\u0002\u0014\u0001\u0001\r\u0011!Q!\n\u0005\u001daABA\u000b\u0001\u0011\u000b9\u0002\u0003\u0006\u00028A\u0011)\u001a!C\u0001\u0003sA!\"a\u0013\u0011\u0005#\u0005\u000b\u0011BA\u001e\u0011)\ti\u0005\u0005BK\u0002\u0013\u0005\u0011q\n\u0005\u000b\u00033\u0002\"\u0011#Q\u0001\n\u0005E\u0003BCA.!\tU\r\u0011\"\u0001\u0002^!Q\u0011Q\r\t\u0003\u0012\u0003\u0006I!a\u0018\t\u0015\u0005\u001d\u0004C!f\u0001\n\u0003\tI\u0007\u0003\u0006\u0002rA\u0011\t\u0012)A\u0005\u0003WBa!\u0014\t\u0005\u0002\u0005M\u0004\"CAA!\u0005\u0005I\u0011AAB\u0011%\ti\tEI\u0001\n\u0003\ty\tC\u0005\u0002&B\t\n\u0011\"\u0001\u0002(\"I\u00111\u0016\t\u0012\u0002\u0013\u0005\u0011Q\u0016\u0005\n\u0003c\u0003\u0012\u0013!C\u0001\u0003gC\u0011\"a.\u0011\u0003\u0003%\t%!/\t\u0013\u0005%\u0007#!A\u0005\u0002\u0005-\u0007\"CAj!\u0005\u0005I\u0011AAk\u0011%\ty\u000eEA\u0001\n\u0003\n\t\u000fC\u0005\u0002pB\t\t\u0011\"\u0001\u0002r\"I\u0011Q\u001f\t\u0002\u0002\u0013\u0005\u0013q\u001f\u0005\n\u0003w\u0004\u0012\u0011!C!\u0003{D\u0011\"a@\u0011\u0003\u0003%\tE!\u0001\t\u0013\t\r\u0001#!A\u0005B\t\u0015q!\u0003B\u0005\u0001\u0005\u0005\t\u0012\u0002B\u0006\r%\t)\u0002AA\u0001\u0012\u0013\u0011i\u0001\u0003\u0004NS\u0011\u0005!Q\u0005\u0005\n\u0003\u007fL\u0013\u0011!C#\u0005\u0003A\u0011Ba\n*\u0003\u0003%\tI!\u000b\t\u0013\tM\u0012&!A\u0005\u0002\nU\u0002\"\u0003B$\u0001\t\u0007I\u0011\u0002B%\u0011!\u00119\u0006\u0001Q\u0001\n\t-\u0003b\u0002B-\u0001\u0011\u0005!1\f\u0005\b\u0005g\u0002A\u0011\u0001B.\u0011\u001d\u0011i\b\u0001C\u0001\u00057BqAa\"\u0001\t\u0003\u0011Y\u0006C\u0004\u0003\f\u0002!\tAa\u0017\t\u000f\t=\u0005\u0001\"\u0001\u0003\\!9!1\u0013\u0001\u0005\u0002\tm\u0003b\u0002BL\u0001\u0011\u0005!1\f\u0005\b\u00057\u0003A\u0011\u0001B.\u0011\u001d\u0011y\n\u0001C\u0001\u00057BqAa)\u0001\t\u0013\u0011)\u000bC\u0004\u0003F\u0002!IAa\u0017\t\u000f\t\u001d\u0007\u0001\"\u0003\u0003J\"9!q\u001a\u0001\u0005\n\tE'AG\"mkN$XM\u001d'j].$\u0016m]6NC:\fw-\u001a:UKN$(B\u0001!B\u0003\u0011a\u0017N\\6\u000b\u0005\t\u001b\u0015AB:feZ,'OC\u0001E\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A$\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\n\u0005\u0002Q\u00015\tq(\u0001\u0007ce>\\WM]\"p]\u001aLw-F\u0001T!\t!V+D\u0001B\u0013\t1\u0016IA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00042s_.,'oQ8oM&<\u0007%\u0001\u0003uS6,W#\u0001.\u0011\u0005m+W\"\u0001/\u000b\u0005us\u0016!B;uS2\u001c(BA0a\u0003\u0019\u0019w.\\7p]*\u0011A)\u0019\u0006\u0003E\u000e\fa!\u00199bG\",'\"\u00013\u0002\u0007=\u0014x-\u0003\u0002g9\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003-a\u0017N\\6NC:\fw-\u001a:\u0016\u0003)\u0004\"\u0001U6\n\u00051|$AE\"mkN$XM\u001d'j].l\u0015M\\1hKJ\fA\u0002\\5oW6\u000bg.Y4fe\u0002\nq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0002aB\u0011\u0001+]\u0005\u0003e~\u0012!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\f\u0001#\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0011\u0002\u0017Q\f7o['b]\u0006<WM]\u000b\u0002mB\u0011\u0001k^\u0005\u0003q~\u0012ac\u00117vgR,'\u000fT5oWR\u000b7o['b]\u0006<WM]\u0001\u0010i\u0006\u001c8.T1oC\u001e,'o\u0018\u0013fcR\u00111P \t\u0003\u0011rL!!`%\u0003\tUs\u0017\u000e\u001e\u0005\b\u007f.\t\t\u00111\u0001w\u0003\rAH%M\u0001\ri\u0006\u001c8.T1oC\u001e,'\u000fI\u0001\u000bY>\u001c\u0017\r\\!e[&tWCAA\u0004!\r\u0001\u0016\u0011B\u0005\u0004\u0003\u0017y$!F\"mkN$XM\u001d'j].dunY1m\u0003\u0012l\u0017N\\\u0001\u000fY>\u001c\u0017\r\\!e[&tw\fJ3r)\rY\u0018\u0011\u0003\u0005\t\u007f:\t\t\u00111\u0001\u0002\b\u0005YAn\\2bY\u0006#W.\u001b8!\u0005\u0011a\u0015N\\6\u0014\rA9\u0015\u0011DA\u0010!\rA\u00151D\u0005\u0004\u0003;I%a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003C\t\tD\u0004\u0003\u0002$\u00055b\u0002BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%R)\u0001\u0004=e>|GOP\u0005\u0002\u0015&\u0019\u0011qF%\u0002\u000fA\f7m[1hK&!\u00111GA\u001b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\ty#S\u0001\tY&t7NT1nKV\u0011\u00111\b\t\u0005\u0003{\t)E\u0004\u0003\u0002@\u0005\u0005\u0003cAA\u0013\u0013&\u0019\u00111I%\u0002\rA\u0013X\rZ3g\u0013\u0011\t9%!\u0013\u0003\rM#(/\u001b8h\u0015\r\t\u0019%S\u0001\nY&t7NT1nK\u0002\na\u0001\\5oW&#WCAA)!\u0011\t\u0019&!\u0016\u000e\u0003yK1!a\u0016_\u0005\u0011)V/\u001b3\u0002\u000f1Lgn[%eA\u0005i1\r\\5f]Rl\u0015M\\1hKJ,\"!a\u0018\u0011\u0007A\u000b\t'C\u0002\u0002d}\u0012Ad\u00117vgR,'\u000fT5oW\u0012+7\u000f^\"mS\u0016tG/T1oC\u001e,'/\u0001\bdY&,g\u000e^'b]\u0006<WM\u001d\u0011\u0002#%\u001cH*\u001b8l\u0007>|'\u000fZ5oCR|'/\u0006\u0002\u0002lA\u0019\u0001*!\u001c\n\u0007\u0005=\u0014JA\u0004C_>dW-\u00198\u0002%%\u001cH*\u001b8l\u0007>|'\u000fZ5oCR|'\u000f\t\u000b\u000b\u0003k\nI(a\u001f\u0002~\u0005}\u0004cAA<!5\t\u0001\u0001C\u0004\u00028e\u0001\r!a\u000f\t\u000f\u00055\u0013\u00041\u0001\u0002R!9\u00111L\rA\u0002\u0005}\u0003bBA43\u0001\u0007\u00111N\u0001\u0005G>\u0004\u0018\u0010\u0006\u0006\u0002v\u0005\u0015\u0015qQAE\u0003\u0017C\u0011\"a\u000e\u001b!\u0003\u0005\r!a\u000f\t\u0013\u00055#\u0004%AA\u0002\u0005E\u0003\"CA.5A\u0005\t\u0019AA0\u0011%\t9G\u0007I\u0001\u0002\u0004\tY'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E%\u0006BA\u001e\u0003'[#!!&\u0011\t\u0005]\u0015\u0011U\u0007\u0003\u00033SA!a'\u0002\u001e\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003?K\u0015AC1o]>$\u0018\r^5p]&!\u00111UAM\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tIK\u000b\u0003\u0002R\u0005M\u0015AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003_SC!a\u0018\u0002\u0014\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAA[U\u0011\tY'a%\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\f\u0005\u0003\u0002>\u0006\u001dWBAA`\u0015\u0011\t\t-a1\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000b\fAA[1wC&!\u0011qIA`\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\rE\u0002I\u0003\u001fL1!!5J\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9.!8\u0011\u0007!\u000bI.C\u0002\u0002\\&\u00131!\u00118z\u0011!y\u0018%!AA\u0002\u00055\u0017a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\bCBAs\u0003W\f9.\u0004\u0002\u0002h*\u0019\u0011\u0011^%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002n\u0006\u001d(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u001b\u0002t\"AqpIA\u0001\u0002\u0004\t9.\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA^\u0003sD\u0001b \u0013\u0002\u0002\u0003\u0007\u0011QZ\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QZ\u0001\ti>\u001cFO]5oOR\u0011\u00111X\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005-$q\u0001\u0005\t\u007f\u001e\n\t\u00111\u0001\u0002X\u0006!A*\u001b8l!\r\t9(K\n\u0006S\t=!1\u0004\t\u000f\u0005#\u00119\"a\u000f\u0002R\u0005}\u00131NA;\u001b\t\u0011\u0019BC\u0002\u0003\u0016%\u000bqA];oi&lW-\u0003\u0003\u0003\u001a\tM!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!!Q\u0004B\u0012\u001b\t\u0011yB\u0003\u0003\u0003\"\u0005\r\u0017AA5p\u0013\u0011\t\u0019Da\b\u0015\u0005\t-\u0011!B1qa2LHCCA;\u0005W\u0011iCa\f\u00032!9\u0011q\u0007\u0017A\u0002\u0005m\u0002bBA'Y\u0001\u0007\u0011\u0011\u000b\u0005\b\u00037b\u0003\u0019AA0\u0011\u001d\t9\u0007\fa\u0001\u0003W\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u00038\t\r\u0003#\u0002%\u0003:\tu\u0012b\u0001B\u001e\u0013\n1q\n\u001d;j_:\u00042\u0002\u0013B \u0003w\t\t&a\u0018\u0002l%\u0019!\u0011I%\u0003\rQ+\b\u000f\\35\u0011%\u0011)%LA\u0001\u0002\u0004\t)(A\u0002yIA\nQ\u0001\\5oWN,\"Aa\u0013\u0011\u0011\t5#1KA\u001e\u0003kj!Aa\u0014\u000b\t\tE\u0013q]\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011)Fa\u0014\u0003\u00075\u000b\u0007/\u0001\u0004mS:\\7\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002w\"\u001a\u0001Ga\u0018\u0011\t\t\u0005$qN\u0007\u0003\u0005GRAA!\u001a\u0003h\u0005\u0019\u0011\r]5\u000b\t\t%$1N\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\u0011igY\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005c\u0012\u0019G\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004c\t]\u0004\u0003\u0002B1\u0005sJAAa\u001f\u0003d\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\ti\u0016\u001cH/\u00133mK\"\u001a!G!!\u0011\t\t\u0005$1Q\u0005\u0005\u0005\u000b\u0013\u0019G\u0001\u0003UKN$\u0018!\u0004;fgR\u001c6\r[3ek2,'\u000fK\u00024\u0005\u0003\u000ba\u0002^3ti2{7-\u00197BI6Lg\u000eK\u00025\u0005\u0003\u000ba\u0002^3tiN#x\u000e]'jeJ|'\u000fK\u00026\u0005\u0003\u000b\u0001\u0004^3tiJ+g/\u001a:tK\u0006sGmU<ba6K'O]8sQ\r1$\u0011Q\u0001\u0014i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8NSJ\u0014xN\u001d\u0015\u0004o\t\u0005\u0015\u0001\u0005;fgR\u0014V\r]1je6K'O]8sQ\rA$\u0011Q\u0001\u001ci\u0016\u001cHo\u00117fCJl\u0015N\u001d:peN#\u0018M\u001d;PM\u001a\u001cX\r^:)\u0007e\u0012\t)A\twKJLg-_'jeJ|'o\u0015;bi\u0016$ra\u001fBT\u0005o\u0013Y\fC\u0004\u0003*j\u0002\rAa+\u0002\u000bM$\u0018\r^3\u0011\u000f!\u0013i+!\u001e\u00032&\u0019!qV%\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u0001)\u00034&\u0019!QW \u0003+\rcWo\u001d;fe2Kgn\u001b+pa&\u001c7\u000b^1uK\"9!\u0011\u0018\u001eA\u0002\t-\u0016\u0001C8mIN#\u0018\r^3\t\u000f\tu&\b1\u0001\u0003@\u0006I!-\u0019;dQR\u000b7o\u001b\t\u0004!\n\u0005\u0017b\u0001Bb\u007f\ta2\t\\;ti\u0016\u0014H*\u001b8l)J\fgn]5uS>tW*\u001b:s_J\u001c\u0018AC:fiV\u0004Xj\\2lg\u0006Q1M]3bi\u0016d\u0015N\\6\u0015\r\u0005U$1\u001aBg\u0011\u001d\t9\u0004\u0010a\u0001\u0003wAq!a\u001a=\u0001\u0004\tY'A\bue\u0006t7/\u001b;j_:$\u0016m]6t)\u0019\u0011\u0019N!7\u0003\\B1\u0011Q\bBk\u0005\u007fKAAa6\u0002J\t\u00191+\u001a;\t\u000bQl\u0004\u0019\u0001<\t\u000f\tuW\b1\u0001\u0003T\u00061\u0011n\u001a8pe\u0016\u0004")
public class ClusterLinkTaskManagerTest {
    private volatile ClusterLinkTaskManagerTest$Link$ Link$module;
    private final KafkaConfig brokerConfig = (KafkaConfig)Mockito.mock(KafkaConfig.class);
    private final Time time = new MockTime();
    private final ClusterLinkManager linkManager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private ClusterLinkTaskManager taskManager;
    private ClusterLinkLocalAdmin localAdmin;
    private final Map<String, Link> links = (Map)Map$.MODULE$.empty();

    private ClusterLinkTaskManagerTest$Link$ Link() {
        if (this.Link$module == null) {
            this.Link$lzycompute$1();
        }
        return this.Link$module;
    }

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private Time time() {
        return this.time;
    }

    private ClusterLinkManager linkManager() {
        return this.linkManager;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkTaskManager taskManager() {
        return this.taskManager;
    }

    private void taskManager_$eq(ClusterLinkTaskManager x$1) {
        this.taskManager = x$1;
    }

    private ClusterLinkLocalAdmin localAdmin() {
        return this.localAdmin;
    }

    private void localAdmin_$eq(ClusterLinkLocalAdmin x$1) {
        this.localAdmin = x$1;
    }

    private Map<String, Link> links() {
        return this.links;
    }

    @BeforeEach
    public void setUp() {
        this.taskManager_$eq(new ClusterLinkTaskManager(1, this.linkManager(), this.brokerConfig(), this.time()));
        this.setupMocks();
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.taskManager()).foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testIdle() {
        Assertions.assertFalse((boolean)this.taskManager().scheduler().isStarted());
        Assertions.assertNull((Object)this.localAdmin());
        this.taskManager().shutdown();
        Assertions.assertFalse((boolean)this.taskManager().scheduler().isStarted());
        Assertions.assertNull((Object)this.localAdmin());
    }

    @Test
    public void testScheduler() {
        Assertions.assertFalse((boolean)this.taskManager().scheduler().isStarted());
        this.taskManager().maybeStartScheduler();
        Assertions.assertTrue((boolean)this.taskManager().scheduler().isStarted());
        this.taskManager().maybeStartScheduler();
        Assertions.assertTrue((boolean)this.taskManager().scheduler().isStarted());
        ScheduledFuture future = this.taskManager().scheduler().scheduleOnce("testShutdown", () -> Thread.sleep(30000L), 30000L);
        Assertions.assertFalse((boolean)future.isDone());
        this.taskManager().shutdown();
        Assertions.assertThrows(CancellationException.class, () -> future.get(10L, TimeUnit.SECONDS));
        Assertions.assertNull((Object)this.localAdmin());
    }

    @Test
    public void testLocalAdmin() {
        Assertions.assertNull((Object)this.localAdmin());
        ClusterLinkLocalAdmin admin = this.taskManager().getOrCreateLocalAdmin();
        Assertions.assertNotNull((Object)this.localAdmin());
        ClusterLinkLocalAdmin admin1 = this.localAdmin();
        Assertions.assertSame((Object)admin1, (Object)admin);
        Assertions.assertSame((Object)admin1, (Object)this.taskManager().getOrCreateLocalAdmin());
        Assertions.assertSame((Object)admin1, (Object)this.localAdmin());
        this.taskManager().shutdown();
        Assertions.assertNull((Object)this.localAdmin());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStopMirror() {
        void verifyMirrorState_batchTask;
        ClusterLinkStopMirrors clusterLinkStopMirrors = this.taskManager().clusterLinkStopMirrors();
        Function1 & Serializable verifyMirrorState_oldState = (Function1 & Serializable)link -> new ClusterLinkTopicState.Mirror(link.linkName(), link.linkId(), Uuid.randomUuid(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        Function1 & Serializable verifyMirrorState_state = (Function1 & Serializable)link -> new ClusterLinkTopicState.PendingStoppedMirror(link.linkName(), link.linkId(), Uuid.randomUuid(), true, Time.SYSTEM.milliseconds());
        Link verifyMirrorState_link1 = this.createLink("link1", true);
        this.taskManager().processMirrorStateChange("topic1", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testStopMirror$1(verifyMirrorState_link1), (Option)new Some((Object)ClusterLinkTaskManagerTest.$anonfun$testStopMirror$1(verifyMirrorState_link1)), verifyMirrorState_link1.clientManager());
        Assertions.assertEquals((int)0, (int)verifyMirrorState_batchTask.subTaskCount());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> ClusterLinkTaskManagerTest.$anonfun$verifyMirrorState$1(this, verifyMirrorState_state, verifyMirrorState_link1, verifyMirrorState_oldState, (ClusterLinkTransitionMirrors)verifyMirrorState_batchTask, arg_0)));
        Link verifyMirrorState_link2 = this.createLink("link2", true);
        this.taskManager().processMirrorStateChange("topic2", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testStopMirror$1(verifyMirrorState_link2), Option$.MODULE$.apply((Object)ClusterLinkTaskManagerTest.$anonfun$testStopMirror$2(verifyMirrorState_link2)), verifyMirrorState_link2.clientManager());
        Assertions.assertEquals((int)2, (int)verifyMirrorState_batchTask.subTaskCount());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic1"));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic2"));
        Link verifyMirrorState_link3 = this.createLink("link3", false);
        this.taskManager().processMirrorStateChange("topic3", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testStopMirror$1(verifyMirrorState_link3), (Option)None$.MODULE$, verifyMirrorState_link3.clientManager());
        Assertions.assertEquals((int)2, (int)verifyMirrorState_batchTask.subTaskCount());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic3"));
        this.transitionTasks(this.taskManager(), (Set<ClusterLinkTransitionMirrors>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkTransitionMirrors[]{verifyMirrorState_batchTask})))).foreach((Function1 & Serializable)task -> {
            ClusterLinkTaskManagerTest.$anonfun$verifyMirrorState$2(task);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReverseAndSwapMirror() {
        void verifyMirrorState_batchTask;
        ClusterLinkReverseAndSwapMirrors clusterLinkReverseAndSwapMirrors = this.taskManager().clusterLinkReverseAndSwapMirrors();
        Function1 & Serializable verifyMirrorState_oldState = (Function1 & Serializable)link -> new ClusterLinkTopicState.Mirror(link.linkName(), link.linkId(), Uuid.randomUuid(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        Function1 & Serializable verifyMirrorState_state = (Function1 & Serializable)link -> new ClusterLinkTopicState.PendingSynchronizeMirror(link.linkName(), link.linkId(), Uuid.randomUuid(), (TopicLinkState)TopicLinkPausedMirror$.MODULE$, Time.SYSTEM.milliseconds());
        Link verifyMirrorState_link1 = this.createLink("link1", true);
        this.taskManager().processMirrorStateChange("topic1", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testReverseAndSwapMirror$1(verifyMirrorState_link1), (Option)new Some((Object)ClusterLinkTaskManagerTest.$anonfun$testReverseAndSwapMirror$1(verifyMirrorState_link1)), verifyMirrorState_link1.clientManager());
        Assertions.assertEquals((int)0, (int)verifyMirrorState_batchTask.subTaskCount());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> ClusterLinkTaskManagerTest.$anonfun$verifyMirrorState$1(this, verifyMirrorState_state, verifyMirrorState_link1, verifyMirrorState_oldState, (ClusterLinkTransitionMirrors)verifyMirrorState_batchTask, arg_0)));
        Link verifyMirrorState_link2 = this.createLink("link2", true);
        this.taskManager().processMirrorStateChange("topic2", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testReverseAndSwapMirror$1(verifyMirrorState_link2), Option$.MODULE$.apply((Object)ClusterLinkTaskManagerTest.$anonfun$testReverseAndSwapMirror$2(verifyMirrorState_link2)), verifyMirrorState_link2.clientManager());
        Assertions.assertEquals((int)2, (int)verifyMirrorState_batchTask.subTaskCount());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic1"));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic2"));
        Link verifyMirrorState_link3 = this.createLink("link3", false);
        this.taskManager().processMirrorStateChange("topic3", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testReverseAndSwapMirror$1(verifyMirrorState_link3), (Option)None$.MODULE$, verifyMirrorState_link3.clientManager());
        Assertions.assertEquals((int)2, (int)verifyMirrorState_batchTask.subTaskCount());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic3"));
        this.transitionTasks(this.taskManager(), (Set<ClusterLinkTransitionMirrors>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkTransitionMirrors[]{verifyMirrorState_batchTask})))).foreach((Function1 & Serializable)task -> {
            ClusterLinkTaskManagerTest.$anonfun$verifyMirrorState$2(task);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConvertToMirror() {
        void verifyMirrorState_batchTask;
        ClusterLinkConvertTopicsToMirrors clusterLinkConvertTopicsToMirrors = this.taskManager().clusterLinkConvertToMirrors();
        Function1 & Serializable verifyMirrorState_oldState = (Function1 & Serializable)link -> new ClusterLinkTopicState.Mirror(link.linkName(), link.linkId(), Uuid.randomUuid(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        Function1 & Serializable verifyMirrorState_state = (Function1 & Serializable)link -> new ClusterLinkTopicState.PendingMirror(link.linkName(), link.linkId(), Uuid.randomUuid(), TopicLinkPausedMirror$.MODULE$.name(), Time.SYSTEM.milliseconds());
        Link verifyMirrorState_link1 = this.createLink("link1", true);
        this.taskManager().processMirrorStateChange("topic1", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testConvertToMirror$1(verifyMirrorState_link1), (Option)new Some((Object)ClusterLinkTaskManagerTest.$anonfun$testConvertToMirror$1(verifyMirrorState_link1)), verifyMirrorState_link1.clientManager());
        Assertions.assertEquals((int)0, (int)verifyMirrorState_batchTask.subTaskCount());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> ClusterLinkTaskManagerTest.$anonfun$verifyMirrorState$1(this, verifyMirrorState_state, verifyMirrorState_link1, verifyMirrorState_oldState, (ClusterLinkTransitionMirrors)verifyMirrorState_batchTask, arg_0)));
        Link verifyMirrorState_link2 = this.createLink("link2", true);
        this.taskManager().processMirrorStateChange("topic2", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testConvertToMirror$1(verifyMirrorState_link2), Option$.MODULE$.apply((Object)ClusterLinkTaskManagerTest.$anonfun$testConvertToMirror$2(verifyMirrorState_link2)), verifyMirrorState_link2.clientManager());
        Assertions.assertEquals((int)2, (int)verifyMirrorState_batchTask.subTaskCount());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic1"));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic2"));
        Link verifyMirrorState_link3 = this.createLink("link3", false);
        this.taskManager().processMirrorStateChange("topic3", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testConvertToMirror$1(verifyMirrorState_link3), (Option)None$.MODULE$, verifyMirrorState_link3.clientManager());
        Assertions.assertEquals((int)2, (int)verifyMirrorState_batchTask.subTaskCount());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic3"));
        this.transitionTasks(this.taskManager(), (Set<ClusterLinkTransitionMirrors>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkTransitionMirrors[]{verifyMirrorState_batchTask})))).foreach((Function1 & Serializable)task -> {
            ClusterLinkTaskManagerTest.$anonfun$verifyMirrorState$2(task);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRepairMirror() {
        void verifyMirrorState_batchTask;
        ClusterLinkRepairMirrors clusterLinkRepairMirrors = this.taskManager().clusterLinkRepairMirrors();
        Function1 & Serializable verifyMirrorState_oldState = (Function1 & Serializable)link -> new ClusterLinkTopicState.FailedMirror(link.linkName(), link.linkId(), Uuid.randomUuid(), MirrorTopicError.RECORD_TOO_LARGE, Time.SYSTEM.milliseconds());
        Function1 & Serializable verifyMirrorState_state = (Function1 & Serializable)link -> new ClusterLinkTopicState.PendingRepairMirror(link.linkName(), link.linkId(), Uuid.randomUuid(), MirrorTopicError.RECORD_TOO_LARGE, Time.SYSTEM.milliseconds());
        Link verifyMirrorState_link1 = this.createLink("link1", true);
        this.taskManager().processMirrorStateChange("topic1", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testRepairMirror$1(verifyMirrorState_link1), (Option)new Some((Object)ClusterLinkTaskManagerTest.$anonfun$testRepairMirror$1(verifyMirrorState_link1)), verifyMirrorState_link1.clientManager());
        Assertions.assertEquals((int)0, (int)verifyMirrorState_batchTask.subTaskCount());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> ClusterLinkTaskManagerTest.$anonfun$verifyMirrorState$1(this, verifyMirrorState_state, verifyMirrorState_link1, verifyMirrorState_oldState, (ClusterLinkTransitionMirrors)verifyMirrorState_batchTask, arg_0)));
        Link verifyMirrorState_link2 = this.createLink("link2", true);
        this.taskManager().processMirrorStateChange("topic2", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testRepairMirror$1(verifyMirrorState_link2), Option$.MODULE$.apply((Object)ClusterLinkTaskManagerTest.$anonfun$testRepairMirror$2(verifyMirrorState_link2)), verifyMirrorState_link2.clientManager());
        Assertions.assertEquals((int)2, (int)verifyMirrorState_batchTask.subTaskCount());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic1"));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic2"));
        Link verifyMirrorState_link3 = this.createLink("link3", false);
        this.taskManager().processMirrorStateChange("topic3", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testRepairMirror$1(verifyMirrorState_link3), (Option)None$.MODULE$, verifyMirrorState_link3.clientManager());
        Assertions.assertEquals((int)2, (int)verifyMirrorState_batchTask.subTaskCount());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic3"));
        this.transitionTasks(this.taskManager(), (Set<ClusterLinkTransitionMirrors>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkTransitionMirrors[]{verifyMirrorState_batchTask})))).foreach((Function1 & Serializable)task -> {
            ClusterLinkTaskManagerTest.$anonfun$verifyMirrorState$2(task);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorStartOffsets() {
        void verifyMirrorState_batchTask;
        ClusterLinkClearStartOffsetsForMirrors clusterLinkClearStartOffsetsForMirrors = this.taskManager().clusterLinkClearStartOffsetsForMirrors();
        Function1 & Serializable verifyMirrorState_oldState = (Function1 & Serializable)link -> new ClusterLinkTopicState.Mirror(link.linkName(), link.linkId(), Uuid.randomUuid(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        Function1 & Serializable verifyMirrorState_state = (Function1 & Serializable)link -> {
            String x$1 = link.linkName();
            Uuid x$2 = link.linkId();
            Uuid x$3 = Uuid.randomUuid();
            ArraySeq.ofLong x$4 = Predef$.MODULE$.wrapLongArray(new long[]{10L, 20L});
            long x$5 = Time.SYSTEM.milliseconds();
            return new ClusterLinkTopicState.Mirror(x$1, x$2, x$3, x$5, (Seq)x$4);
        };
        Link verifyMirrorState_link1 = this.createLink("link1", true);
        this.taskManager().processMirrorStateChange("topic1", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testClearMirrorStartOffsets$1(verifyMirrorState_link1), (Option)new Some((Object)ClusterLinkTaskManagerTest.$anonfun$testClearMirrorStartOffsets$1(verifyMirrorState_link1)), verifyMirrorState_link1.clientManager());
        Assertions.assertEquals((int)0, (int)verifyMirrorState_batchTask.subTaskCount());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> ClusterLinkTaskManagerTest.$anonfun$verifyMirrorState$1(this, verifyMirrorState_state, verifyMirrorState_link1, verifyMirrorState_oldState, (ClusterLinkTransitionMirrors)verifyMirrorState_batchTask, arg_0)));
        Link verifyMirrorState_link2 = this.createLink("link2", true);
        this.taskManager().processMirrorStateChange("topic2", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testClearMirrorStartOffsets$1(verifyMirrorState_link2), Option$.MODULE$.apply((Object)ClusterLinkTaskManagerTest.$anonfun$testClearMirrorStartOffsets$2(verifyMirrorState_link2)), verifyMirrorState_link2.clientManager());
        Assertions.assertEquals((int)2, (int)verifyMirrorState_batchTask.subTaskCount());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic1"));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic2"));
        Link verifyMirrorState_link3 = this.createLink("link3", false);
        this.taskManager().processMirrorStateChange("topic3", (ClusterLinkTopicState)ClusterLinkTaskManagerTest.$anonfun$testClearMirrorStartOffsets$1(verifyMirrorState_link3), (Option)None$.MODULE$, verifyMirrorState_link3.clientManager());
        Assertions.assertEquals((int)2, (int)verifyMirrorState_batchTask.subTaskCount());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)verifyMirrorState_batchTask.subTask("topic3"));
        this.transitionTasks(this.taskManager(), (Set<ClusterLinkTransitionMirrors>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkTransitionMirrors[]{verifyMirrorState_batchTask})))).foreach((Function1 & Serializable)task -> {
            ClusterLinkTaskManagerTest.$anonfun$verifyMirrorState$2(task);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyMirrorState(Function1<Link, ClusterLinkTopicState> state, Function1<Link, ClusterLinkTopicState> oldState, ClusterLinkTransitionMirrors batchTask) {
        Link link1 = this.createLink("link1", true);
        this.taskManager().processMirrorStateChange("topic1", (ClusterLinkTopicState)state.apply((Object)link1), (Option)new Some(state.apply((Object)link1)), link1.clientManager());
        Assertions.assertEquals((int)0, (int)batchTask.subTaskCount());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            this.taskManager().processMirrorStateChange("topic1", (ClusterLinkTopicState)state.apply((Object)link1), Option$.MODULE$.apply(oldState.apply((Object)link1)), link1.clientManager());
            Assertions.assertEquals((int)1, (int)batchTask.subTaskCount());
            Assertions.assertNotEquals((Object)None$.MODULE$, (Object)batchTask.subTask("topic1"));
        });
        Link link2 = this.createLink("link2", true);
        this.taskManager().processMirrorStateChange("topic2", (ClusterLinkTopicState)state.apply((Object)link2), Option$.MODULE$.apply(oldState.apply((Object)link2)), link2.clientManager());
        Assertions.assertEquals((int)2, (int)batchTask.subTaskCount());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)batchTask.subTask("topic1"));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)batchTask.subTask("topic2"));
        Link link3 = this.createLink("link3", false);
        this.taskManager().processMirrorStateChange("topic3", (ClusterLinkTopicState)state.apply((Object)link3), (Option)None$.MODULE$, link3.clientManager());
        Assertions.assertEquals((int)2, (int)batchTask.subTaskCount());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)batchTask.subTask("topic3"));
        this.transitionTasks(this.taskManager(), (Set<ClusterLinkTransitionMirrors>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkTransitionMirrors[]{batchTask})))).foreach((Function1 & Serializable)task -> {
            ClusterLinkTaskManagerTest.$anonfun$verifyMirrorState$2(task);
            return BoxedUnit.UNIT;
        });
    }

    private void setupMocks() {
        Mockito.when((Object)this.linkManager().metadataManager()).thenReturn((Object)this.metadataManager());
        Mockito.when((Object)this.linkManager().createLocalAdmin((ClusterLinkScheduler)ArgumentMatchers.any(), ArgumentMatchers.eq((int)1))).thenAnswer(x$5 -> {
            this.localAdmin_$eq((ClusterLinkLocalAdmin)Mockito.mock(ClusterLinkLocalAdmin.class));
            this.localAdmin().close(Duration.ZERO);
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$6 -> {
                this.localAdmin_$eq(null);
                return BoxedUnit.UNIT;
            });
            return this.localAdmin();
        });
    }

    private Link createLink(String linkName, boolean isLinkCoordinator) {
        ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
        Link link = new Link(this, linkName, Uuid.randomUuid(), clientManager, isLinkCoordinator);
        Mockito.when((Object)clientManager.metadataManager()).thenReturn((Object)this.metadataManager());
        Mockito.when((Object)clientManager.linkData()).thenAnswer(x$7 -> new ClusterLinkData(linkName, link.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)clientManager.isActive())).thenAnswer(x$8 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkTaskManagerTest.$anonfun$createLink$2(x$8)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(linkName))).thenAnswer(x$9 -> BoxesRunTime.boxToBoolean((boolean)link.isLinkCoordinator()));
        this.links().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName), (Object)link));
        return link;
    }

    private Set<ClusterLinkTransitionMirrors> transitionTasks(ClusterLinkTaskManager taskManager, Set<ClusterLinkTransitionMirrors> ignore) {
        return (Set)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkTransitionMirrors[]{taskManager.clusterLinkStopMirrors(), taskManager.clusterLinkConvertToMirrors(), taskManager.clusterLinkReverseAndSwapMirrors(), taskManager.clusterLinkRepairMirrors(), taskManager.clusterLinkClearStartOffsetsForMirrors()}))).$minus$minus(ignore);
    }

    private final void Link$lzycompute$1() {
        synchronized (this) {
            if (this.Link$module == null) {
                this.Link$module = new ClusterLinkTaskManagerTest$Link$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$verifyMirrorState$2(ClusterLinkTransitionMirrors task) {
        Assertions.assertEquals((int)0, (int)task.subTaskCount());
    }

    public static final /* synthetic */ boolean $anonfun$createLink$2(InvocationOnMock x$8) {
        return true;
    }

    private class Link
    implements Product,
    Serializable {
        private final String linkName;
        private final Uuid linkId;
        private final ClusterLinkDestClientManager clientManager;
        private final boolean isLinkCoordinator;
        public final /* synthetic */ ClusterLinkTaskManagerTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String linkName() {
            return this.linkName;
        }

        public Uuid linkId() {
            return this.linkId;
        }

        public ClusterLinkDestClientManager clientManager() {
            return this.clientManager;
        }

        public boolean isLinkCoordinator() {
            return this.isLinkCoordinator;
        }

        public Link copy(String linkName, Uuid linkId, ClusterLinkDestClientManager clientManager, boolean isLinkCoordinator) {
            return new Link(this.kafka$server$link$ClusterLinkTaskManagerTest$Link$$$outer(), linkName, linkId, clientManager, isLinkCoordinator);
        }

        public String copy$default$1() {
            return this.linkName();
        }

        public Uuid copy$default$2() {
            return this.linkId();
        }

        public ClusterLinkDestClientManager copy$default$3() {
            return this.clientManager();
        }

        public boolean copy$default$4() {
            return this.isLinkCoordinator();
        }

        public String productPrefix() {
            return "Link";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.linkName();
                }
                case 1: {
                    return this.linkId();
                }
                case 2: {
                    return this.clientManager();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isLinkCoordinator());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Link;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "linkName";
                }
                case 1: {
                    return "linkId";
                }
                case 2: {
                    return "clientManager";
                }
                case 3: {
                    return "isLinkCoordinator";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.linkName())), (int)Statics.anyHash((Object)this.linkId())), (int)Statics.anyHash((Object)this.clientManager())), (int)(this.isLinkCoordinator() ? 1231 : 1237)), (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof Link && ((Link)x$1).kafka$server$link$ClusterLinkTaskManagerTest$Link$$$outer() == this.kafka$server$link$ClusterLinkTaskManagerTest$Link$$$outer())) break block3;
                    Link link = (Link)x$1;
                    if (this.isLinkCoordinator() != link.isLinkCoordinator()) break block3;
                    String string = this.linkName();
                    String string2 = link.linkName();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    Uuid uuid = this.linkId();
                    Uuid uuid2 = link.linkId();
                    if (uuid != null ? !uuid.equals(uuid2) : uuid2 != null) break block3;
                    ClusterLinkDestClientManager clusterLinkDestClientManager = this.clientManager();
                    ClusterLinkDestClientManager clusterLinkDestClientManager2 = link.clientManager();
                    if ((clusterLinkDestClientManager != null ? !clusterLinkDestClientManager.equals(clusterLinkDestClientManager2) : clusterLinkDestClientManager2 != null) || !link.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ClusterLinkTaskManagerTest kafka$server$link$ClusterLinkTaskManagerTest$Link$$$outer() {
            return this.$outer;
        }

        public Link(ClusterLinkTaskManagerTest $outer, String linkName, Uuid linkId, ClusterLinkDestClientManager clientManager, boolean isLinkCoordinator) {
            this.linkName = linkName;
            this.linkId = linkId;
            this.clientManager = clientManager;
            this.isLinkCoordinator = isLinkCoordinator;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

