/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import java.util.stream.Stream;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.link.ClusterLinkTopicStateTest$;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkPendingMirror$;
import kafka.server.link.TopicLinkPendingRepairMirror$;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkPendingSynchronizeMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkState$;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MirrorTopic;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055e\u0001\u0002\u0011\"\u0001!BQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013\u0005A\u0007\u0003\u0004>\u0001\u0001\u0006I!\u000e\u0005\b}\u0001\u0011\r\u0011\"\u0001@\u0011\u0019Y\u0005\u0001)A\u0005\u0001\"9A\n\u0001b\u0001\n\u0003y\u0004BB'\u0001A\u0003%\u0001\tC\u0004O\u0001\t\u0007I\u0011A(\t\rm\u0003\u0001\u0015!\u0003Q\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u0015a\u0007\u0001\"\u0001^\u0011\u0015q\u0007\u0001\"\u0001^\u0011\u0015\u0001\b\u0001\"\u0001^\u0011\u0015\u0011\b\u0001\"\u0001^\u0011\u0015!\b\u0001\"\u0001^\u0011\u00151\b\u0001\"\u0001^\u0011\u0015A\b\u0001\"\u0001^\u0011\u0015Q\b\u0001\"\u0001^\u0011\u0015a\b\u0001\"\u0001^\u0011\u0015q\b\u0001\"\u0001^\u0011\u0019\t\t\u0001\u0001C\u0001;\"1\u0011Q\u0001\u0001\u0005\u0002uCa!!\u0003\u0001\t\u0003i\u0006BBA\u0007\u0001\u0011\u0005Q\f\u0003\u0004\u0002\u0012\u0001!\t!\u0018\u0005\b\u0003+\u0001A\u0011BA\f\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003K9q!!\u001c\"\u0011\u0003\tyG\u0002\u0004!C!\u0005\u0011\u0011\u000f\u0005\u0007_u!\t!a\u001d\t\u000f\u0005-T\u0004\"\u0001\u0002v\tI2\t\\;ti\u0016\u0014H*\u001b8l)>\u0004\u0018nY*uCR,G+Z:u\u0015\t\u00113%\u0001\u0003mS:\\'B\u0001\u0013&\u0003\u0019\u0019XM\u001d<fe*\ta%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002cA\u0011!\u0007A\u0007\u0002C\u0005AA.\u001b8l\u001d\u0006lW-F\u00016!\t14(D\u00018\u0015\tA\u0014(\u0001\u0003mC:<'\"\u0001\u001e\u0002\t)\fg/Y\u0005\u0003y]\u0012aa\u0015;sS:<\u0017!\u00037j].t\u0015-\\3!\u0003\u0019a\u0017N\\6JIV\t\u0001\t\u0005\u0002B\u00136\t!I\u0003\u0002D\t\u000611m\\7n_:T!AJ#\u000b\u0005\u0019;\u0015AB1qC\u000eDWMC\u0001I\u0003\ry'oZ\u0005\u0003\u0015\n\u0013A!V;jI\u00069A.\u001b8l\u0013\u0012\u0004\u0013!D:pkJ\u001cW\rV8qS\u000eLE-\u0001\bt_V\u00148-\u001a+pa&\u001c\u0017\n\u001a\u0011\u0002%5L'O]8s'R\f'\u000f^(gMN,Go]\u000b\u0002!B\u0019\u0011K\u0016-\u000e\u0003IS!a\u0015+\u0002\u0013%lW.\u001e;bE2,'BA+,\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003/J\u00131aU3r!\tQ\u0013,\u0003\u0002[W\t!Aj\u001c8h\u0003Mi\u0017N\u001d:peN#\u0018M\u001d;PM\u001a\u001cX\r^:!\u0003I!Xm\u001d;Ge>l'j]8o'R\u0014\u0018N\\4\u0015\u0003y\u0003\"AK0\n\u0005\u0001\\#\u0001B+oSRD#A\u00032\u0011\u0005\rTW\"\u00013\u000b\u0005\u00154\u0017aA1qS*\u0011q\r[\u0001\bUV\u0004\u0018\u000e^3s\u0015\tIw)A\u0003kk:LG/\u0003\u0002lI\n!A+Z:u\u0003A!Xm\u001d;U_*\u001bxN\\*ue&tw\r\u000b\u0002\fE\u0006QA/Z:u\u001b&\u0014(o\u001c:)\u00051\u0011\u0017\u0001\u0005;fgR\u0004\u0016-^:fI6K'O]8sQ\ti!-\u0001\tuKN$h)Y5mK\u0012l\u0015N\u001d:pe\"\u0012aBY\u0001\u0018i\u0016\u001cH\u000fU3oI&twMU3qC&\u0014X*\u001b:s_JD#a\u00042\u00021Q,7\u000f\u001e)f]\u0012LgnZ*u_B\u0004X\rZ'jeJ|'\u000f\u000b\u0002\u0011E\u0006\tB/Z:u'R|\u0007\u000f]3e\u001b&\u0014(o\u001c:)\u0005E\u0011\u0017!\u0005;fgR\u0004VM\u001c3j]\u001el\u0015N\u001d:pe\"\u0012!CY\u0001\u001di\u0016\u001cH\u000fU3oI&twmU=oG\"\u0014xN\\5{K6K'O]8sQ\t\u0019\"-\u0001\u0007uKN$()\u00193F]R\u0014\u0018\u0010\u000b\u0002\u0015E\u0006qA/Z:u\u0005\u0006$g+\u001a:tS>t\u0007FA\u000bc\u0003M!Xm\u001d;Nk2$\u0018\u000e\u001d7f\u000b:$(/[3tQ\t1\"-\u0001\u0010uKN$8\t\\;ti\u0016\u0014H*\u001b8l)>\u0004\u0018nY*uCR,\u0017\t\u001d9ms\"\u0012qCY\u0001\u0017i\u0016\u001cH/T5se>\u00148\u000b^1si>3gm]3ug\"\u0012\u0001DY\u0001\u0015i\u0016\u001cH/T5se>\u0014Hk\u001c9jG\u0016\u0013(o\u001c:)\u0005e\u0011\u0017A\u0003<fe&4\u0017PS:p]R\u0019a,!\u0007\t\u000f\u0005m!\u00041\u0001\u0002\u001e\u0005)1\u000f^1uKB\u0019!'a\b\n\u0007\u0005\u0005\u0012EA\u000bDYV\u001cH/\u001a:MS:\\Gk\u001c9jGN#\u0018\r^3\u0002YQ,7\u000f^\"mkN$XM\u001d'j].$v\u000e]5d'R\fG/\u001a+p\u001b&\u0014(o\u001c:U_BL7MU3d_J$G#\u00020\u0002(\u0005}\u0002bBA\u00157\u0001\u0007\u00111F\u0001\ri\u0016t\u0017M\u001c;Qe\u00164\u0017\u000e\u001f\t\u0005\u0003[\tYD\u0004\u0003\u00020\u0005]\u0002cAA\u0019W5\u0011\u00111\u0007\u0006\u0004\u0003k9\u0013A\u0002\u001fs_>$h(C\u0002\u0002:-\na\u0001\u0015:fI\u00164\u0017b\u0001\u001f\u0002>)\u0019\u0011\u0011H\u0016\t\u000f\u0005\u00053\u00041\u0001\u0002,\u0005QA.\u001b8l!J,g-\u001b=)\u000fm\t)%!\u0015\u0002TA!\u0011qIA'\u001b\t\tIEC\u0002\u0002L\u0019\fa\u0001]1sC6\u001c\u0018\u0002BA(\u0003\u0013\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\u0005U\u0013!L>eSN\u0004H.Y=OC6,WP\f;f]\u0006tG\u000f\u0015:fM&DXh\u001f\u0019~]1Lgn\u001b)sK\u001aL\u00070P>2{\":1$!\u0017\u0002f\u0005\u001d\u0004\u0003BA.\u0003Cj!!!\u0018\u000b\t\u0005}\u0013\u0011J\u0001\taJ|g/\u001b3fe&!\u00111MA/\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\t\tI'\t\u0002\u0002l\u0005A\u0001O]3gSb,7/A\rDYV\u001cH/\u001a:MS:\\Gk\u001c9jGN#\u0018\r^3UKN$\bC\u0001\u001a\u001e'\ti\u0012\u0006\u0006\u0002\u0002pU\u0011\u0011q\u000f\t\u0007\u0003s\n\u0019)a\"\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\naa\u001d;sK\u0006l'bAAAs\u0005!Q\u000f^5m\u0013\u0011\t))a\u001f\u0003\rM#(/Z1n!\u0011\tY&!#\n\t\u0005-\u0015Q\f\u0002\n\u0003J<W/\\3oiN\u0004")
public class ClusterLinkTopicStateTest {
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final scala.collection.immutable.Seq<Object> mirrorStartOffsets = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 20L, Long.MAX_VALUE}));

    public static Stream<Arguments> prefixes() {
        return ClusterLinkTopicStateTest$.MODULE$.prefixes();
    }

    public String linkName() {
        return this.linkName;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    public Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    public scala.collection.immutable.Seq<Object> mirrorStartOffsets() {
        return this.mirrorStartOffsets;
    }

    @Test
    public void testFromJsonString() {
        int timeMs = 123456789;
        ClusterLinkTopicState result = ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(173).append("|{\n          |  \"Mirror\": {\n          |    \"version\": 1,\n          |    \"time_ms\": ").append(timeMs).append(",\n          |    \"link_name\": \"").append(this.linkName()).append("\",\n          |    \"link_id\": \"").append(CoreUtils$.MODULE$.toJavaUUID(this.linkId())).append("\"\n          |  }\n          |}").toString())));
        Assertions.assertEquals((Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), Uuid.ZERO_UUID, (long)timeMs, (Seq)Seq$.MODULE$.empty()), (Object)result);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)result.mirrorStartOffsets());
        ClusterLinkTopicState mirrorWithSourceTopicId = ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(211).append("|{\n          |  \"Mirror\": {\n          |    \"version\": 1,\n          |    \"time_ms\": ").append(timeMs).append(",\n          |    \"link_name\": \"").append(this.linkName()).append("\",\n          |    \"link_id\": \"").append(CoreUtils$.MODULE$.toJavaUUID(this.linkId())).append("\",\n          |    \"source_topic_id\": \"").append(this.sourceTopicId()).append("\"\n          |  }\n          |}").toString())));
        Assertions.assertEquals((Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), (long)timeMs, (Seq)Seq$.MODULE$.empty()), (Object)mirrorWithSourceTopicId);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)mirrorWithSourceTopicId.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)mirrorWithSourceTopicId.clearMirrorStartOffsets());
        ClusterLinkTopicState mirrorWithStartOffsets = ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(290).append("|{\n          |  \"Mirror\": {\n          |    \"version\": 1,\n          |    \"time_ms\": ").append(timeMs).append(",\n          |    \"link_name\": \"").append(this.linkName()).append("\",\n          |    \"link_id\": \"").append(CoreUtils$.MODULE$.toJavaUUID(this.linkId())).append("\",\n          |    \"source_topic_id\": \"").append(this.sourceTopicId()).append("\",\n          |    \"mirror_start_offsets\": [0, 20, ").append(Long.MAX_VALUE).append("]\n          |  }\n          |}").toString())));
        Assertions.assertEquals((Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), (long)timeMs, this.mirrorStartOffsets()), (Object)mirrorWithStartOffsets);
        Assertions.assertEquals(this.mirrorStartOffsets(), (Object)mirrorWithStartOffsets.mirrorStartOffsets());
        Assertions.assertEquals((Object)new Some((Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), (long)timeMs, (Seq)Seq$.MODULE$.empty())), (Object)mirrorWithStartOffsets.clearMirrorStartOffsets());
        this.verifyJson(mirrorWithStartOffsets);
        ClusterLinkTopicState failedMirrorWithoutReason = ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(217).append("|{\n          |  \"FailedMirror\": {\n          |    \"version\": 1,\n          |    \"time_ms\": ").append(timeMs).append(",\n          |    \"link_name\": \"").append(this.linkName()).append("\",\n          |    \"link_id\": \"").append(CoreUtils$.MODULE$.toJavaUUID(this.linkId())).append("\",\n          |    \"source_topic_id\": \"").append(this.sourceTopicId()).append("\"\n          |  }\n          |}").toString())));
        Assertions.assertEquals((Object)new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_MAY_BE_DELETED, (long)timeMs), (Object)failedMirrorWithoutReason);
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_MAY_BE_DELETED, (Object)failedMirrorWithoutReason.mirrorTopicError());
        this.verifyJson(failedMirrorWithoutReason);
        ClusterLinkTopicState failedMirrorWithReason = ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(256).append("|{\n          |  \"FailedMirror\": {\n          |    \"version\": 1,\n          |    \"time_ms\": ").append(timeMs).append(",\n          |    \"link_name\": \"").append(this.linkName()).append("\",\n          |    \"link_id\": \"").append(CoreUtils$.MODULE$.toJavaUUID(this.linkId())).append("\",\n          |    \"source_topic_id\": \"").append(this.sourceTopicId()).append("\",\n          |    \"mirror_topic_error\": ").append(MirrorTopicError.SOURCE_TOPIC_ID_CHANGED.code()).append("\n          |  }\n          |}").toString())));
        Assertions.assertEquals((Object)new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, (long)timeMs), (Object)failedMirrorWithReason);
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, (Object)failedMirrorWithReason.mirrorTopicError());
        this.verifyJson(failedMirrorWithReason);
    }

    @Test
    public void testToJsonString() {
        int timeMs = 123456789;
        ClusterLinkTopicState.Mirror mirror = new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), (long)timeMs, (Seq)Seq$.MODULE$.empty());
        Assertions.assertEquals((Object)mirror, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(mirror.toJsonString()));
        ClusterLinkTopicState.Mirror mirrorWithSourceTopicId = new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), Uuid.ZERO_UUID, (long)timeMs, (Seq)Seq$.MODULE$.empty());
        Assertions.assertEquals((Object)mirrorWithSourceTopicId, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(mirrorWithSourceTopicId.toJsonString()));
        scala.collection.immutable.Seq mirrorStartOffsets = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 20L, Long.MAX_VALUE}));
        ClusterLinkTopicState.Mirror mirrorWithStartOffsets = new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), Uuid.ZERO_UUID, (long)timeMs, (Seq)mirrorStartOffsets);
        Assertions.assertEquals((Object)mirrorWithStartOffsets, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(mirrorWithStartOffsets.toJsonString()));
    }

    @Test
    public void testMirror() {
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.Mirror state = new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), timeMs, (Seq)Seq$.MODULE$.empty());
        ClusterLinkTopicState.Mirror data = (ClusterLinkTopicState.Mirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertTrue((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)data.mirrorTopicError());
        Assertions.assertEquals((short)MirrorTopicError.NO_ERROR.code(), (short)data.toMirrorTopicState().mirrorTopicError());
    }

    @Test
    public void testPausedMirror() {
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)linkLevel -> {
            ClusterLinkTopicStateTest.$anonfun$testPausedMirror$3(this, BoxesRunTime.unboxToBoolean((Object)linkLevel));
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFailedMirror() {
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.FailedMirror state = new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, timeMs);
        ClusterLinkTopicState.FailedMirror data = (ClusterLinkTopicState.FailedMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, (Object)data.mirrorTopicError());
        Assertions.assertEquals((short)MirrorTopicError.SOURCE_TOPIC_ID_CHANGED.code(), (short)data.toMirrorTopicState().mirrorTopicError());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)state.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)state.clearMirrorStartOffsets());
        this.verifyJson((ClusterLinkTopicState)state);
    }

    @Test
    public void testPendingRepairMirror() {
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.PendingRepairMirror state = new ClusterLinkTopicState.PendingRepairMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopicError.RECORD_TOO_LARGE, timeMs);
        ClusterLinkTopicState.PendingRepairMirror data = (ClusterLinkTopicState.PendingRepairMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertEquals((Object)MirrorTopicError.RECORD_TOO_LARGE, (Object)data.mirrorTopicError());
        Assertions.assertEquals((short)MirrorTopicError.RECORD_TOO_LARGE.code(), (short)data.toMirrorTopicState().mirrorTopicError());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)state.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)state.clearMirrorStartOffsets());
        this.verifyJson((ClusterLinkTopicState)state);
    }

    @Test
    public void testPendingStoppedMirror() {
        boolean synchronize = true;
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.PendingStoppedMirror state = new ClusterLinkTopicState.PendingStoppedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), synchronize, timeMs);
        ClusterLinkTopicState.PendingStoppedMirror data = (ClusterLinkTopicState.PendingStoppedMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)synchronize), (Object)BoxesRunTime.boxToBoolean((boolean)data.synchronize()));
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)state.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)state.clearMirrorStartOffsets());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)data.mirrorTopicError());
        Assertions.assertEquals((short)MirrorTopicError.NO_ERROR.code(), (short)data.toMirrorTopicState().mirrorTopicError());
    }

    @Test
    public void testStoppedMirror() {
        List logEndOffsets = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{12345L, 23456L, 34567L}));
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.StoppedMirror state = new ClusterLinkTopicState.StoppedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (Seq)logEndOffsets, timeMs);
        ClusterLinkTopicState.StoppedMirror data = (ClusterLinkTopicState.StoppedMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((Object)logEndOffsets, (Object)data.logEndOffsets());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertFalse((boolean)data.state().readOnly());
        Assertions.assertFalse((boolean)data.mirrorIsEstablished());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)state.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)state.clearMirrorStartOffsets());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)data.mirrorTopicError());
        Assertions.assertEquals((short)MirrorTopicError.NO_ERROR.code(), (short)data.toMirrorTopicState().mirrorTopicError());
    }

    @Test
    public void testPendingMirror() {
        long timeMs = Time.SYSTEM.milliseconds();
        String nextState = MirrorTopic.State.MIRROR.stateName();
        ClusterLinkTopicState.PendingMirror state = new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), this.sourceTopicId(), nextState, timeMs);
        ClusterLinkTopicState.PendingMirror data = (ClusterLinkTopicState.PendingMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)state.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)state.clearMirrorStartOffsets());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)data.mirrorTopicError());
        Assertions.assertEquals((short)MirrorTopicError.NO_ERROR.code(), (short)data.toMirrorTopicState().mirrorTopicError());
        Assertions.assertEquals((Object)nextState, (Object)data.nextState());
    }

    @Test
    public void testPendingSynchronizeMirror() {
        long timeMs = Time.SYSTEM.milliseconds();
        TopicLinkMirror$ remoteMirrorNextState = TopicLinkMirror$.MODULE$;
        ClusterLinkTopicState.PendingSynchronizeMirror state = new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (TopicLinkState)remoteMirrorNextState, timeMs);
        ClusterLinkTopicState.PendingSynchronizeMirror data = (ClusterLinkTopicState.PendingSynchronizeMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertTrue((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)state.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)state.clearMirrorStartOffsets());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)data.mirrorTopicError());
        Assertions.assertEquals((short)MirrorTopicError.NO_ERROR.code(), (short)data.toMirrorTopicState().mirrorTopicError());
        Assertions.assertEquals((Object)remoteMirrorNextState, (Object)data.remoteMirrorNextState());
    }

    @Test
    public void testBadEntry() {
        Assertions.assertThrows(IllegalStateException.class, () -> ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(200).append("|{\n            |  \"Unexpected\": {\n            |    \"version\": 1,\n            |    \"time_ms\": 123456789,\n            |    \"link_name\": \"").append(this.linkName()).append("\",\n            |    \"link_id\": \"").append(this.linkId()).append("\"\n            |  }\n            |}").toString()))));
    }

    @Test
    public void testBadVersion() {
        Assertions.assertThrows(IllegalStateException.class, () -> ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(196).append("|{\n            |  \"Mirror\": {\n            |    \"version\": 0,\n            |    \"time_ms\": 123456789,\n            |    \"link_name\": \"").append(this.linkName()).append("\",\n            |    \"link_id\": \"").append(this.linkId()).append("\"\n            |  }\n            |}").toString()))));
    }

    @Test
    public void testMultipleEntries() {
        Assertions.assertThrows(IllegalStateException.class, () -> ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(404).append("|{\n            |  \"Mirror\": {\n            |    \"version\": 1,\n            |    \"time_ms\": 123456789,\n            |    \"link_name\": \"test-link-1\",\n            |    \"link_id\": \"").append(UUID.randomUUID()).append("\"\n            |  },\n            |  \"FailedMirror\": {\n            |    \"version\": 1,\n            |    \"time_ms\": 123456789,\n            |    \"link_name\": \"test-link-2\",\n            |    \"link_id\": \"").append(UUID.randomUUID()).append("\"\n            |  }\n            |}").toString()))));
    }

    @Test
    public void testClusterLinkTopicStateApply() {
        Uuid linkId = Uuid.randomUuid();
        String linkName = "testLink";
        Uuid topicId = Uuid.randomUuid();
        String topicName = "mirrorTopic";
        Uuid sourceTopicId = Uuid.randomUuid();
        String sourceTopicName = "sourceMirrorTopic";
        ArrayList mirrorStartOffsets = new ArrayList();
        MirrorTopic.State active = MirrorTopic.State.MIRROR;
        MirrorTopic.State paused = MirrorTopic.State.PAUSED;
        MirrorTopic.State failed = MirrorTopic.State.FAILED;
        MirrorTopic.State pendingMirror = MirrorTopic.State.PENDING_MIRROR;
        MirrorTopic.State pendingSynchronize = MirrorTopic.State.PENDING_SYNCHRONIZE;
        MirrorTopic.State pendingStopped = MirrorTopic.State.PENDING_STOPPED;
        MirrorTopic.State stopped = MirrorTopic.State.STOPPED;
        long timeMs = System.currentTimeMillis();
        MirrorTopic.PendingMirrorTopic pendingMirrorTopic = new MirrorTopic.PendingMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, timeMs, MirrorTopic.State.MIRROR);
        ClusterLinkTopicState.PendingMirror clusterLinkPendingMirrorTopic = (ClusterLinkTopicState.PendingMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingMirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkPendingMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkPendingMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkPendingMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)MirrorTopic.State.MIRROR.stateName(), (Object)clusterLinkPendingMirrorTopic.nextState());
        Assertions.assertEquals((Object)pendingMirror.stateName(), (Object)clusterLinkPendingMirrorTopic.state().name());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkPendingMirrorTopic.timeMs());
        MirrorTopic.ActiveMirrorTopic mirrorTopic = new MirrorTopic.ActiveMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, mirrorStartOffsets, timeMs);
        ClusterLinkTopicState.Mirror clusterLinkMirrorTopic = (ClusterLinkTopicState.Mirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)mirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)active.stateName(), (Object)clusterLinkMirrorTopic.state().name());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkMirrorTopic.timeMs());
        Assertions.assertEquals((int)mirrorStartOffsets.size(), (int)clusterLinkMirrorTopic.mirrorStartOffsets().size());
        MirrorTopic.ActiveMirrorTopic mirrorTopicWithoutStartOffsets = new MirrorTopic.ActiveMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, null, timeMs);
        ClusterLinkTopicState.Mirror clusterLinkMirrorTopicWithoutStartOffsets = (ClusterLinkTopicState.Mirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)mirrorTopicWithoutStartOffsets);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkMirrorTopicWithoutStartOffsets.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkMirrorTopicWithoutStartOffsets.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkMirrorTopicWithoutStartOffsets.sourceTopicId());
        Assertions.assertEquals((Object)active.stateName(), (Object)clusterLinkMirrorTopicWithoutStartOffsets.state().name());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkMirrorTopicWithoutStartOffsets.timeMs());
        Assertions.assertEquals((int)mirrorStartOffsets.size(), (int)clusterLinkMirrorTopicWithoutStartOffsets.mirrorStartOffsets().size());
        boolean topicLevelPause = false;
        boolean linkLevelPause = true;
        MirrorTopicError mirrorTopicError = MirrorTopicError.NO_ERROR;
        MirrorTopic.PausedMirrorTopic pausedMirrorTopic = new MirrorTopic.PausedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, mirrorStartOffsets, timeMs, topicLevelPause, linkLevelPause, active, MirrorTopicError.NO_ERROR, null);
        ClusterLinkTopicState.PausedMirror clusterLinkPausedMirrorTopic = (ClusterLinkTopicState.PausedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pausedMirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkPausedMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkPausedMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkPausedMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)paused.stateName(), (Object)clusterLinkPausedMirrorTopic.state().name());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkPausedMirrorTopic.timeMs());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)topicLevelPause), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPausedMirrorTopic.topicLevel()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)linkLevelPause), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPausedMirrorTopic.linkLevel()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((active.equals(failed) ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPausedMirrorTopic.wasFailed()));
        Assertions.assertEquals((Object)mirrorTopicError, (Object)clusterLinkPausedMirrorTopic.mirrorTopicError());
        Assertions.assertEquals(null, (Object)clusterLinkPausedMirrorTopic.pendingSynchronizeNextState());
        Assertions.assertEquals((int)mirrorStartOffsets.size(), (int)clusterLinkPausedMirrorTopic.mirrorStartOffsets().size());
        MirrorTopic.PausedMirrorTopic pausedMirrorTopicWithoutStartOffsets = new MirrorTopic.PausedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, null, timeMs, topicLevelPause, linkLevelPause, active, MirrorTopicError.NO_ERROR, null);
        ClusterLinkTopicState.PausedMirror clusterLinkPausedMirrorTopicWithoutStartOffsets = (ClusterLinkTopicState.PausedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pausedMirrorTopicWithoutStartOffsets);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkPausedMirrorTopicWithoutStartOffsets.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkPausedMirrorTopicWithoutStartOffsets.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkPausedMirrorTopicWithoutStartOffsets.sourceTopicId());
        Assertions.assertEquals((Object)paused.stateName(), (Object)clusterLinkPausedMirrorTopicWithoutStartOffsets.state().name());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkPausedMirrorTopicWithoutStartOffsets.timeMs());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)topicLevelPause), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPausedMirrorTopicWithoutStartOffsets.topicLevel()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)linkLevelPause), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPausedMirrorTopicWithoutStartOffsets.linkLevel()));
        MirrorTopic.State state = active;
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!(state != null ? !state.equals(failed) : failed != null) ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPausedMirrorTopicWithoutStartOffsets.wasFailed()));
        Assertions.assertEquals((Object)mirrorTopicError, (Object)clusterLinkPausedMirrorTopic.mirrorTopicError());
        Assertions.assertEquals(null, (Object)clusterLinkPausedMirrorTopic.pendingSynchronizeNextState());
        Assertions.assertEquals((int)mirrorStartOffsets.size(), (int)clusterLinkPausedMirrorTopicWithoutStartOffsets.mirrorStartOffsets().size());
        boolean promoted = true;
        MirrorTopic.PendingStoppedMirrorTopic pendingStoppedMirrorTopic = new MirrorTopic.PendingStoppedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, timeMs, promoted);
        ClusterLinkTopicState.PendingStoppedMirror clusterLinkPendingStoppedMirrorTopic = (ClusterLinkTopicState.PendingStoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingStoppedMirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkPendingStoppedMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkPendingStoppedMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkPendingStoppedMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)pendingStopped.stateName(), (Object)clusterLinkPendingStoppedMirrorTopic.state().name());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)promoted), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPendingStoppedMirrorTopic.synchronize()));
        Assertions.assertEquals((long)timeMs, (long)clusterLinkPendingStoppedMirrorTopic.timeMs());
        TopicLinkPausedMirror$ remoteMirrorNextState = TopicLinkPausedMirror$.MODULE$;
        MirrorTopic.PendingSynchronizeMirrorTopic pendingSynchronizeMirrorTopic = new MirrorTopic.PendingSynchronizeMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, timeMs, MirrorTopic.State.PAUSED);
        ClusterLinkTopicState.PendingSynchronizeMirror clusterLinkPendingSynchronizeMirrorTopic = (ClusterLinkTopicState.PendingSynchronizeMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingSynchronizeMirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkPendingSynchronizeMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkPendingSynchronizeMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkPendingSynchronizeMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)pendingSynchronize.stateName(), (Object)clusterLinkPendingSynchronizeMirrorTopic.state().name());
        Assertions.assertEquals((Object)remoteMirrorNextState, (Object)clusterLinkPendingSynchronizeMirrorTopic.remoteMirrorNextState());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkPendingSynchronizeMirrorTopic.timeMs());
        ArrayList stoppedLogEndOffsets = new ArrayList();
        MirrorTopic.StoppedMirrorTopic stoppedMirrorTopic = new MirrorTopic.StoppedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, timeMs, stoppedLogEndOffsets);
        ClusterLinkTopicState.StoppedMirror clusterLinkStoppedMirrorTopic = (ClusterLinkTopicState.StoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)stoppedMirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkStoppedMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkStoppedMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkStoppedMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)stopped.stateName(), (Object)clusterLinkStoppedMirrorTopic.state().name());
        Assertions.assertEquals((int)stoppedLogEndOffsets.size(), (int)clusterLinkStoppedMirrorTopic.logEndOffsets().size());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkStoppedMirrorTopic.timeMs());
        MirrorTopic.StoppedMirrorTopic stoppedMirrorTopicWithoutStoppedLogEndOffsets = new MirrorTopic.StoppedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, timeMs, null);
        ClusterLinkTopicState.StoppedMirror clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets = (ClusterLinkTopicState.StoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)stoppedMirrorTopicWithoutStoppedLogEndOffsets);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets.sourceTopicId());
        Assertions.assertEquals((Object)stopped.stateName(), (Object)clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets.state().name());
        Assertions.assertEquals((int)stoppedLogEndOffsets.size(), (int)clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets.logEndOffsets().size());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets.timeMs());
        MirrorTopic.FailedMirrorTopic failedMirrorTopic = new MirrorTopic.FailedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, timeMs, MirrorTopicError.SOURCE_TOPIC_ID_CHANGED);
        ClusterLinkTopicState.FailedMirror clusterLinkFailedMirrorTopic = (ClusterLinkTopicState.FailedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)failedMirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkFailedMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkFailedMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkFailedMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)failed.stateName(), (Object)clusterLinkFailedMirrorTopic.state().name());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkFailedMirrorTopic.timeMs());
    }

    @Test
    public void testMirrorStartOffsets() {
        Uuid linkId = Uuid.randomUuid();
        String linkName = "testLink";
        Uuid topicId = Uuid.randomUuid();
        String topicName = "mirrorTopic";
        Uuid sourceTopicId = Uuid.randomUuid();
        String sourceTopicName = "sourceTopic";
        java.util.List<Long> mirrorStartOffsets = Arrays.asList(Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(11L));
        java.util.List emptyStartOffsets = Collections.emptyList();
        long timeMs = System.currentTimeMillis();
        MirrorTopicRecord mirrorTopicRecord = new MirrorTopicRecord().setMirrorTopicState(MirrorTopic.State.MIRROR.stateName()).setClusterLinkId(linkId).setClusterLinkName(linkName).setTopicId(topicId).setTopicName(topicName).setSourceTopicId(sourceTopicId).setSourceTopicName(sourceTopicName).setMirrorStartOffsets(mirrorStartOffsets).setTimeMs(timeMs);
        MirrorTopic.ActiveMirrorTopic mirrorTopic = (MirrorTopic.ActiveMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.Mirror mirrorState = (ClusterLinkTopicState.Mirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)mirrorTopic);
        Assertions.assertEquals(mirrorStartOffsets, (Object)mirrorTopic.mirrorStartOffsets());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala(mirrorStartOffsets).asScala(), (Object)mirrorState.mirrorStartOffsets());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)((ClusterLinkTopicState)mirrorState.clearMirrorStartOffsets().get()).mirrorStartOffsets());
        MirrorTopicChangeRecord changeRecord = new MirrorTopicChangeRecord().setMirrorTopicState(MirrorTopic.State.MIRROR.stateName()).setMirrorStartOffsets(emptyStartOffsets).setTimeMs(System.currentTimeMillis());
        MirrorTopic mirrorTopicWithoutOffsets = MirrorTopic.fromChangeRecord((MirrorTopic)mirrorTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals(emptyStartOffsets, (Object)mirrorTopicWithoutOffsets.mirrorStartOffsets());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setPreviousToPausedState(MirrorTopic.State.MIRROR.stateName());
        MirrorTopic.PausedMirrorTopic pausedMirrorTopic = (MirrorTopic.PausedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.PausedMirror pausedMirrorState = (ClusterLinkTopicState.PausedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pausedMirrorTopic);
        Assertions.assertEquals(mirrorStartOffsets, (Object)pausedMirrorTopic.mirrorStartOffsets());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala(mirrorStartOffsets).asScala(), (Object)pausedMirrorState.mirrorStartOffsets());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)((ClusterLinkTopicState)pausedMirrorState.clearMirrorStartOffsets().get()).mirrorStartOffsets());
        changeRecord.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setPreviousToPausedState(MirrorTopic.State.MIRROR.stateName());
        MirrorTopic pausedMirrorTopicWithoutOffsets = MirrorTopic.fromChangeRecord((MirrorTopic)pausedMirrorTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals(emptyStartOffsets, (Object)pausedMirrorTopicWithoutOffsets.mirrorStartOffsets());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.FAILED.stateName());
        MirrorTopic.FailedMirrorTopic failedMirrorTopic = (MirrorTopic.FailedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.FailedMirror failedMirrorState = (ClusterLinkTopicState.FailedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)failedMirrorTopic);
        if (failedMirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals(emptyStartOffsets, Collections.emptyList());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)failedMirrorState.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)failedMirrorState.clearMirrorStartOffsets());
        changeRecord.setMirrorTopicState(MirrorTopic.State.FAILED.stateName()).setMirrorStartOffsets(mirrorStartOffsets);
        MirrorTopic failedMirrorTopicWithoutOffsets = MirrorTopic.fromChangeRecord((MirrorTopic)failedMirrorTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals(emptyStartOffsets, (Object)failedMirrorTopicWithoutOffsets.mirrorStartOffsets());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName());
        MirrorTopic.PendingStoppedMirrorTopic pendingStoppedMirrorTopic = (MirrorTopic.PendingStoppedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirrorState = (ClusterLinkTopicState.PendingStoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingStoppedMirrorTopic);
        if (pendingStoppedMirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals(emptyStartOffsets, Collections.emptyList());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)pendingStoppedMirrorState.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)pendingStoppedMirrorState.clearMirrorStartOffsets());
        changeRecord.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName());
        MirrorTopic pendingStoppedMirrorTopicWithoutOffsets = MirrorTopic.fromChangeRecord((MirrorTopic)pendingStoppedMirrorTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals(emptyStartOffsets, (Object)pendingStoppedMirrorTopicWithoutOffsets.mirrorStartOffsets());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName());
        MirrorTopic.StoppedMirrorTopic stoppedMirrorTopic = (MirrorTopic.StoppedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.StoppedMirror stoppedMirrorState = (ClusterLinkTopicState.StoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)stoppedMirrorTopic);
        if (stoppedMirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals(emptyStartOffsets, Collections.emptyList());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)stoppedMirrorState.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)stoppedMirrorState.clearMirrorStartOffsets());
        changeRecord.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName());
        MirrorTopic stoppedMirrorTopicWithoutOffsets = MirrorTopic.fromChangeRecord((MirrorTopic)stoppedMirrorTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals(emptyStartOffsets, (Object)stoppedMirrorTopicWithoutOffsets.mirrorStartOffsets());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.PENDING_MIRROR.stateName());
        mirrorTopicRecord.setNextState(MirrorTopic.State.MIRROR.stateName());
        changeRecord.setNextState(MirrorTopic.State.MIRROR.stateName());
        MirrorTopic.PendingMirrorTopic pendingMirrorTopic = (MirrorTopic.PendingMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.PendingMirror pendingMirrorState = (ClusterLinkTopicState.PendingMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingMirrorTopic);
        if (pendingMirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals(emptyStartOffsets, Collections.emptyList());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)pendingMirrorState.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)pendingMirrorState.clearMirrorStartOffsets());
        changeRecord.setMirrorTopicState(MirrorTopic.State.PENDING_MIRROR.stateName());
        MirrorTopic pendingMirrorTopicWithoutOffsets = MirrorTopic.fromChangeRecord((MirrorTopic)pendingMirrorTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals(emptyStartOffsets, (Object)pendingMirrorTopicWithoutOffsets.mirrorStartOffsets());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.PENDING_SYNCHRONIZE.stateName());
        MirrorTopic.PendingSynchronizeMirrorTopic pendingSynchronizeTopic = (MirrorTopic.PendingSynchronizeMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.PendingSynchronizeMirror pendingSynchronizeMirrorState = (ClusterLinkTopicState.PendingSynchronizeMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingSynchronizeTopic);
        if (pendingSynchronizeTopic == null) {
            throw null;
        }
        Assertions.assertEquals(emptyStartOffsets, Collections.emptyList());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)pendingSynchronizeMirrorState.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)pendingSynchronizeMirrorState.clearMirrorStartOffsets());
        changeRecord.setMirrorTopicState(MirrorTopic.State.PENDING_MIRROR.stateName());
        MirrorTopic pendingSynchronizeMirrorTopicWithoutOffsets = MirrorTopic.fromChangeRecord((MirrorTopic)pendingSynchronizeTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals(emptyStartOffsets, (Object)pendingSynchronizeMirrorTopicWithoutOffsets.mirrorStartOffsets());
    }

    @Test
    public void testMirrorTopicError() {
        Uuid linkId = Uuid.randomUuid();
        String linkName = "testLink";
        Uuid topicId = Uuid.randomUuid();
        String topicName = "mirrorTopic";
        Uuid sourceTopicId = Uuid.randomUuid();
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        MirrorTopicRecord mirrorTopicRecord = new MirrorTopicRecord().setMirrorTopicState(MirrorTopic.State.MIRROR.stateName()).setClusterLinkId(linkId).setClusterLinkName(linkName).setTopicId(topicId).setTopicName(topicName).setSourceTopicId(sourceTopicId).setSourceTopicName(sourceTopicName).setTimeMs(timeMs);
        MirrorTopic.ActiveMirrorTopic mirrorTopic = (MirrorTopic.ActiveMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.Mirror mirrorState = (ClusterLinkTopicState.Mirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)mirrorTopic);
        if (mirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopicError.NO_ERROR);
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)mirrorState.mirrorTopicError());
        MirrorTopicChangeRecord changeRecord = new MirrorTopicChangeRecord().setMirrorTopicState(MirrorTopic.State.MIRROR.stateName()).setTimeMs(System.currentTimeMillis());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopic.fromChangeRecord((MirrorTopic)mirrorTopic, (MirrorTopicChangeRecord)changeRecord).mirrorTopicError());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setPreviousToPausedState(MirrorTopic.State.FAILED.stateName()).setMirrorTopicError(MirrorTopicError.SOURCE_TOPIC_ID_CHANGED.code());
        MirrorTopic.PausedMirrorTopic pausedMirrorTopic = (MirrorTopic.PausedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.PausedMirror pausedMirrorState = (ClusterLinkTopicState.PausedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pausedMirrorTopic);
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, (Object)pausedMirrorTopic.mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, (Object)pausedMirrorState.mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(pausedMirrorState.toJsonString()).mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_MAY_BE_DELETED, (Object)ClusterLinkTopicStateTest.stateWithoutError$1((ClusterLinkTopicState)pausedMirrorState).mirrorTopicError());
        changeRecord.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setPreviousToPausedState(MirrorTopic.State.MIRROR.stateName()).setMirrorTopicError((short)-1);
        MirrorTopic pausedMirror2 = MirrorTopic.fromChangeRecord((MirrorTopic)pausedMirrorTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)pausedMirror2.mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)ClusterLinkTopicStateTest.stateWithoutError$1(ClusterLinkTopicState$.MODULE$.apply(pausedMirror2)).mirrorTopicError());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.FAILED.stateName()).setMirrorTopicError(MirrorTopicError.NON_MONOTONIC_LOG_APPEND_EPOCH.code());
        MirrorTopic.FailedMirrorTopic failedMirrorTopic = (MirrorTopic.FailedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.FailedMirror failedMirrorState = (ClusterLinkTopicState.FailedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)failedMirrorTopic);
        Assertions.assertEquals((Object)MirrorTopicError.NON_MONOTONIC_LOG_APPEND_EPOCH, (Object)failedMirrorTopic.mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.NON_MONOTONIC_LOG_APPEND_EPOCH, (Object)failedMirrorState.mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.NON_MONOTONIC_LOG_APPEND_EPOCH, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(failedMirrorState.toJsonString()).mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_MAY_BE_DELETED, (Object)ClusterLinkTopicStateTest.stateWithoutError$1((ClusterLinkTopicState)failedMirrorState).mirrorTopicError());
        changeRecord.setMirrorTopicState(MirrorTopic.State.FAILED.stateName()).setMirrorTopicError(MirrorTopicError.UNEXPECTED_TRUNCATION.code());
        Assertions.assertEquals((Object)MirrorTopicError.UNEXPECTED_TRUNCATION, (Object)MirrorTopic.fromChangeRecord((MirrorTopic)failedMirrorTopic, (MirrorTopicChangeRecord)changeRecord).mirrorTopicError());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName());
        MirrorTopic.PendingStoppedMirrorTopic pendingStoppedMirrorTopic = (MirrorTopic.PendingStoppedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirrorState = (ClusterLinkTopicState.PendingStoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingStoppedMirrorTopic);
        if (pendingStoppedMirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopicError.NO_ERROR);
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)pendingStoppedMirrorState.mirrorTopicError());
        changeRecord.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopic.fromChangeRecord((MirrorTopic)pendingStoppedMirrorTopic, (MirrorTopicChangeRecord)changeRecord).mirrorTopicError());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName());
        MirrorTopic.StoppedMirrorTopic stoppedMirrorTopic = (MirrorTopic.StoppedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.StoppedMirror stoppedMirrorState = (ClusterLinkTopicState.StoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)stoppedMirrorTopic);
        if (stoppedMirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopicError.NO_ERROR);
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)stoppedMirrorState.mirrorTopicError());
        changeRecord.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopic.fromChangeRecord((MirrorTopic)stoppedMirrorTopic, (MirrorTopicChangeRecord)changeRecord).mirrorTopicError());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.PENDING_MIRROR.stateName());
        mirrorTopicRecord.setNextState(MirrorTopic.State.MIRROR.stateName());
        changeRecord.setNextState(MirrorTopic.State.MIRROR.stateName());
        MirrorTopic.PendingMirrorTopic pendingMirrorTopic = (MirrorTopic.PendingMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.PendingMirror pendingMirrorState = (ClusterLinkTopicState.PendingMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingMirrorTopic);
        if (pendingMirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopicError.NO_ERROR);
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)pendingMirrorState.mirrorTopicError());
        changeRecord.setMirrorTopicState(MirrorTopic.State.PENDING_MIRROR.stateName());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopic.fromChangeRecord((MirrorTopic)pendingMirrorTopic, (MirrorTopicChangeRecord)changeRecord).mirrorTopicError());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.PENDING_SYNCHRONIZE.stateName());
        MirrorTopic.PendingSynchronizeMirrorTopic pendingSynchronizeMirrorTopic = (MirrorTopic.PendingSynchronizeMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.PendingSynchronizeMirror pendingSynchronizeMirrorState = (ClusterLinkTopicState.PendingSynchronizeMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingSynchronizeMirrorTopic);
        if (pendingSynchronizeMirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopicError.NO_ERROR);
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)pendingSynchronizeMirrorState.mirrorTopicError());
        changeRecord.setMirrorTopicState(MirrorTopic.State.PENDING_MIRROR.stateName());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopic.fromChangeRecord((MirrorTopic)pendingSynchronizeMirrorTopic, (MirrorTopicChangeRecord)changeRecord).mirrorTopicError());
    }

    private void verifyJson(ClusterLinkTopicState state) {
        Assertions.assertEquals((Object)state, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString()));
    }

    @ParameterizedTest(name="{displayName}.tenantPrefix={0}.linkPrefix={1}")
    @MethodSource(value={"prefixes"})
    public void testClusterLinkTopicStateToMirrorTopicRecord(String tenantPrefix, String linkPrefix) {
        Assertions.assertEquals((Object)TopicLinkState$.MODULE$.states().toSet(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicLinkState[]{TopicLinkMirror$.MODULE$, TopicLinkPausedMirror$.MODULE$, TopicLinkFailedMirror$.MODULE$, TopicLinkPendingStoppedMirror$.MODULE$, TopicLinkStoppedMirror$.MODULE$, TopicLinkPendingMirror$.MODULE$, TopicLinkPendingSynchronizeMirror$.MODULE$, TopicLinkPendingRepairMirror$.MODULE$})), (String)"If a new state is added to the mirror topics, please add a test case for it here.");
        Option tenantPrefixOpt = Option$.MODULE$.apply((Object)tenantPrefix);
        Option linkPrefixOpt = Option$.MODULE$.apply((Object)linkPrefix);
        Uuid linkId = Uuid.randomUuid();
        String linkName = "testLink";
        Uuid topicId = Uuid.randomUuid();
        String sourceTopicName = new StringBuilder(11).append((String)tenantPrefixOpt.getOrElse((Function0 & Serializable)() -> "")).append("sourceTopic").toString();
        String topicName = new StringBuilder(11).append((String)tenantPrefixOpt.getOrElse((Function0 & Serializable)() -> "")).append(linkPrefixOpt.getOrElse((Function0 & Serializable)() -> "")).append("sourceTopic").toString();
        Uuid sourceTopicId = Uuid.randomUuid();
        long timeMs = System.currentTimeMillis();
        MirrorTopicError mirrorTopicNoError = MirrorTopicError.NO_ERROR;
        MirrorTopicError mirrorTopicError = MirrorTopicError.ILLEGAL_STATE;
        scala.collection.immutable.Seq logEndOffsets = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{10L, 20L, 30L}));
        TopicLinkState$.MODULE$.states().foreach((Function1 & Serializable)state -> {
            ClusterLinkTopicStateTest.$anonfun$testClusterLinkTopicStateToMirrorTopicRecord$4(this, linkName, linkId, sourceTopicId, timeMs, mirrorTopicNoError, mirrorTopicError, logEndOffsets, topicName, topicId, tenantPrefixOpt, linkPrefixOpt, sourceTopicName, state);
            return BoxedUnit.UNIT;
        });
    }

    private final void verifyState$1(ClusterLinkTopicState state, boolean linkLevel, boolean topicLevel, TopicLinkState prevState, TopicLinkState pendingSynchronizeNextState, boolean wasFailed, MirrorTopicError failReason, long timeMs) {
        ClusterLinkTopicState.PausedMirror data = (ClusterLinkTopicState.PausedMirror)state;
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)linkLevel), (Object)BoxesRunTime.boxToBoolean((boolean)data.linkLevel()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)topicLevel), (Object)BoxesRunTime.boxToBoolean((boolean)data.topicLevel()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)wasFailed), (Object)BoxesRunTime.boxToBoolean((boolean)data.wasFailed()));
        Assertions.assertEquals((Object)prevState, (Object)data.previousState());
        Assertions.assertEquals((Object)pendingSynchronizeNextState, (Object)data.pendingSynchronizeNextState());
        Assertions.assertEquals((Object)failReason, (Object)data.mirrorTopicError());
        Assertions.assertEquals((short)failReason.code(), (short)data.toMirrorTopicState().mirrorTopicError());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)state.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)state.clearMirrorStartOffsets());
        ClusterLinkTopicState.PausedMirror stateWithStartOffsets = new ClusterLinkTopicState.PausedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), linkLevel, topicLevel, prevState, pendingSynchronizeNextState, failReason, timeMs, this.mirrorStartOffsets());
        Assertions.assertEquals(this.mirrorStartOffsets(), (Object)stateWithStartOffsets.mirrorStartOffsets());
        Assertions.assertEquals((Object)new Some((Object)state), (Object)stateWithStartOffsets.clearMirrorStartOffsets());
        this.verifyJson((ClusterLinkTopicState)stateWithStartOffsets);
    }

    public static final /* synthetic */ boolean $anonfun$testPausedMirror$1(Tuple2 x$1) {
        Object object = x$1._1();
        String string = "previous_state";
        return object == null || !object.equals(string);
    }

    public static final /* synthetic */ Object $anonfun$testPausedMirror$2(HashMap oldVersionMap$1, Tuple2 e) {
        return oldVersionMap$1.put(e._1(), e._2());
    }

    /*
     * Unable to fully structure code
     */
    private final void runTest$1(boolean linkLevel, boolean topicLevel, TopicLinkState prevState, TopicLinkState pendingSynchronizeNextState) {
        timeMs = Time.SYSTEM.milliseconds();
        v0 = prevState;
        var8_6 = TopicLinkFailedMirror$.MODULE$;
        if (v0 != null && v0.equals(var8_6)) ** GOTO lbl-1000
        v1 = prevState;
        var9_7 = TopicLinkPendingRepairMirror$.MODULE$;
        if (v1 != null && v1.equals(var9_7)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        wasFailed = v2;
        failReason = wasFailed != false ? MirrorTopicError.SOURCE_TOPIC_ID_CHANGED : MirrorTopicError.NO_ERROR;
        state = new ClusterLinkTopicState.PausedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), linkLevel, topicLevel, prevState, pendingSynchronizeNextState, failReason, timeMs, (Seq)Seq$.MODULE$.empty());
        result = ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        this.verifyState$1(result, linkLevel, topicLevel, prevState, pendingSynchronizeNextState, wasFailed, failReason, timeMs);
        oldVersionMap = new HashMap<K, V>();
        ((IterableOnceOps)state.toMap().filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testPausedMirror$1$adapted(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)())).foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testPausedMirror$2(java.util.HashMap scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)(oldVersionMap));
        oldStyleJson = Json$.MODULE$.encodeAsString(Collections.singletonMap(state.state().name(), oldVersionMap));
        this.verifyState$1(ClusterLinkTopicState$.MODULE$.fromJsonString(oldStyleJson), linkLevel, topicLevel, (TopicLinkState)(wasFailed != false ? TopicLinkFailedMirror$.MODULE$ : TopicLinkMirror$.MODULE$), pendingSynchronizeNextState, wasFailed, failReason, timeMs);
    }

    public static final /* synthetic */ void $anonfun$testPausedMirror$5(ClusterLinkTopicStateTest $this, boolean linkLevel$1, boolean topicLevel$1, TopicLinkState prevState) {
        new .colon.colon((Object)TopicLinkMirror$.MODULE$, (List)new .colon.colon((Object)TopicLinkPausedMirror$.MODULE$, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)pendingSynchronizeNextState -> {
            $this.runTest$1(linkLevel$1, topicLevel$1, prevState, pendingSynchronizeNextState);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testPausedMirror$4(ClusterLinkTopicStateTest $this, boolean linkLevel$1, boolean topicLevel) {
        new .colon.colon((Object)TopicLinkMirror$.MODULE$, (List)new .colon.colon((Object)TopicLinkFailedMirror$.MODULE$, (List)new .colon.colon((Object)TopicLinkPendingRepairMirror$.MODULE$, (List)Nil$.MODULE$))).foreach((Function1 & Serializable)prevState -> {
            ClusterLinkTopicStateTest.$anonfun$testPausedMirror$5($this, linkLevel$1, topicLevel, prevState);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testPausedMirror$3(ClusterLinkTopicStateTest $this, boolean linkLevel) {
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)topicLevel -> {
            ClusterLinkTopicStateTest.$anonfun$testPausedMirror$4($this, linkLevel, BoxesRunTime.unboxToBoolean((Object)topicLevel));
            return BoxedUnit.UNIT;
        });
    }

    private static final ClusterLinkTopicState stateWithoutError$1(ClusterLinkTopicState state) {
        String jsonWithoutError = state.toJsonString().replace(new StringBuilder(22).append(",\"mirror_topic_error\":").append(state.mirrorTopicError().code()).toString(), "");
        return ClusterLinkTopicState$.MODULE$.fromJsonString(jsonWithoutError);
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkTopicStateToMirrorTopicRecord$4(ClusterLinkTopicStateTest $this, String linkName$1, Uuid linkId$1, Uuid sourceTopicId$1, long timeMs$1, MirrorTopicError mirrorTopicNoError$1, MirrorTopicError mirrorTopicError$1, scala.collection.immutable.Seq logEndOffsets$1, String topicName$1, Uuid topicId$1, Option tenantPrefixOpt$1, Option linkPrefixOpt$1, String sourceTopicName$1, TopicLinkState state) {
        ClusterLinkTopicState.Mirror mirrorState = TopicLinkMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.Mirror(linkName$1, linkId$1, sourceTopicId$1, timeMs$1, $this.mirrorStartOffsets()) : (TopicLinkPausedMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.PausedMirror(linkName$1, linkId$1, sourceTopicId$1, true, false, (TopicLinkState)TopicLinkMirror$.MODULE$, null, mirrorTopicNoError$1, timeMs$1, $this.mirrorStartOffsets()) : (TopicLinkFailedMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.FailedMirror(linkName$1, linkId$1, sourceTopicId$1, mirrorTopicError$1, timeMs$1) : (TopicLinkPendingStoppedMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.PendingStoppedMirror(linkName$1, linkId$1, sourceTopicId$1, true, timeMs$1) : (TopicLinkStoppedMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.StoppedMirror(linkName$1, linkId$1, sourceTopicId$1, (Seq)logEndOffsets$1, timeMs$1) : (TopicLinkPendingMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.PendingMirror(linkName$1, linkId$1, sourceTopicId$1, MirrorTopic.State.PAUSED.stateName(), timeMs$1) : (TopicLinkPendingSynchronizeMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.PendingSynchronizeMirror(linkName$1, linkId$1, sourceTopicId$1, (TopicLinkState)TopicLinkMirror$.MODULE$, timeMs$1) : (TopicLinkPendingRepairMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.PendingRepairMirror(linkName$1, linkId$1, sourceTopicId$1, mirrorTopicError$1, timeMs$1) : (Product)Assertions.fail((String)new StringBuilder(40).append("Unknown mirror state ").append(state).append(", please add a test").toString()))))))));
        MirrorTopicRecord record = ((ClusterLinkTopicState)mirrorState).toMirrorTopicRecord(topicName$1, topicId$1, linkPrefixOpt$1, tenantPrefixOpt$1);
        Assertions.assertEquals((Object)topicName$1, (Object)record.topicName());
        Assertions.assertEquals((Object)topicId$1, (Object)record.topicId());
        Assertions.assertEquals((Object)sourceTopicName$1, (Object)record.sourceTopicName());
        Assertions.assertEquals((Object)sourceTopicId$1, (Object)record.sourceTopicId());
        MirrorTopic mirrorTopic = MirrorTopic.fromRecord((MirrorTopicRecord)record);
        Assertions.assertEquals((Object)mirrorState, (Object)ClusterLinkTopicState$.MODULE$.apply(mirrorTopic));
    }

    public ClusterLinkTopicStateTest() {
        this.linkName = "test-link";
    }

    public static final /* synthetic */ Object $anonfun$testPausedMirror$1$adapted(Tuple2 x$1) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkTopicStateTest.$anonfun$testPausedMirror$1(x$1));
    }
}

