/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.KafkaConfig;
import kafka.server.UnboundedClusterLinkRequestQuota$;
import kafka.server.link.ClusterLinkClearStartOffsetsForMirrors;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConvertTopicsToMirrors;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNonBatchingAdmin;
import kafka.server.link.ClusterLinkRepairMirrors;
import kafka.server.link.ClusterLinkReverseAndSwapMirrors;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkStopMirrors;
import kafka.server.link.ClusterLinkTestUtils$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTransitionMirrors;
import kafka.server.link.ClusterLinkTransitionMirrorsTest$RetriableFuture$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011eb\u0001\u00021b\u0001!DQa\u001c\u0001\u0005\u0002ADqa\u001d\u0001C\u0002\u0013%A\u000f\u0003\u0004~\u0001\u0001\u0006I!\u001e\u0005\b}\u0002\u0011\r\u0011\"\u0003\u0000\u0011!\t9\u0002\u0001Q\u0001\n\u0005\u0005\u0001\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011!\tI\u0003\u0001Q\u0001\n\u0005u\u0001\"CA\u0016\u0001\t\u0007I\u0011BA\u0017\u0011!\t)\u0004\u0001Q\u0001\n\u0005=\u0002\"CA\u001c\u0001\t\u0007I\u0011BA\u001d\u0011!\t\t\u0005\u0001Q\u0001\n\u0005m\u0002\"CA\"\u0001\t\u0007I\u0011BA#\u0011!\t9\u0006\u0001Q\u0001\n\u0005\u001d\u0003\"CA-\u0001\t\u0007I\u0011BA.\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005u\u0003\"CA3\u0001\t\u0007I\u0011BA4\u0011!\ty\u0007\u0001Q\u0001\n\u0005%\u0004\"CA9\u0001\t\u0007I\u0011BA:\u0011!\tY\b\u0001Q\u0001\n\u0005U\u0004\"CA?\u0001\t\u0007I\u0011BA@\u0011!\t9\t\u0001Q\u0001\n\u0005\u0005\u0005\"CAE\u0001\t\u0007I\u0011BAF\u0011!\tI\n\u0001Q\u0001\n\u00055\u0005\"CAN\u0001\t\u0007I\u0011BAO\u0011!\t9\u000b\u0001Q\u0001\n\u0005}\u0005\"CAU\u0001\t\u0007I\u0011BAV\u0011!\t\u0019\f\u0001Q\u0001\n\u00055\u0006\"CA[\u0001\u0001\u0007I\u0011BA\\\u0011%\ty\f\u0001a\u0001\n\u0013\t\t\r\u0003\u0005\u0002N\u0002\u0001\u000b\u0015BA]\u0011-\ty\r\u0001a\u0001\u0002\u0004%I!!5\t\u0017\u0005e\u0007\u00011AA\u0002\u0013%\u00111\u001c\u0005\f\u0003?\u0004\u0001\u0019!A!B\u0013\t\u0019\u000eC\u0005\u0002b\u0002\u0011\r\u0011\"\u0003\u0002d\"A!\u0011\u001c\u0001!\u0002\u0013\t)\u000fC\u0005\u0003\\\u0002\u0011\r\u0011\"\u0003\u0003^\"A!1\u001e\u0001!\u0002\u0013\u0011y\u000eC\u0004\u0003n\u0002!\tAa<\t\u000f\r\u001d\u0001\u0001\"\u0001\u0003p\"91\u0011\u0003\u0001\u0005\u0002\t=\bbBB\u000e\u0001\u0011\u0005!q\u001e\u0005\b\u0007?\u0001A\u0011\u0001Bx\u0011\u001d\u0019\u0019\u0003\u0001C\u0001\u0005_Dqaa\n\u0001\t\u0003\u0011y\u000fC\u0004\u0004,\u0001!\tAa<\t\u000f\r=\u0002\u0001\"\u0001\u0003p\"911\u0007\u0001\u0005\u0002\t=\bbBB\u001c\u0001\u0011\u0005!q\u001e\u0005\b\u0007w\u0001A\u0011\u0001Bx\u0011\u001d\u0019y\u0004\u0001C\u0001\u0005_Dqaa\u0011\u0001\t\u0013\u0019)\u0005C\u0004\u0004\\\u0001!Ia!\u0018\t\u0013\r\r\u0004!%A\u0005\n\r\u0015\u0004bBB5\u0001\u0011%11\u000e\u0005\b\u0007{\u0002A\u0011BB@\u0011\u001d\u0019y\t\u0001C\u0005\u0007#Cqa!'\u0001\t\u0013\u0019Y\nC\u0004\u0004 \u0002!Ia!)\t\u000f\r\u0015\u0006\u0001\"\u0003\u0004(\"911\u0016\u0001\u0005\n\r5\u0006bBBY\u0001\u0011%11\u0017\u0005\b\u0007s\u0003A\u0011BB^\u0011\u001d\u0019y\f\u0001C\u0005\u0007\u0003Dqa!2\u0001\t\u0013\u00199\rC\u0004\u0004L\u0002!Ia!4\t\u000f\rE\u0007\u0001\"\u0003\u0004T\"I11\u001c\u0001\u0012\u0002\u0013%1Q\u001c\u0005\b\u0007C\u0004A\u0011BBr\u0011\u001d\u0019Y\u000f\u0001C\u0005\u0007[Dqa!@\u0001\t\u0013\u0019yP\u0002\u0004\u0003\u0010\u0001\u0001%\u0011\u0003\u0005\u000b\u0005[9%Q3A\u0005\u0002\t=\u0002B\u0003B$\u000f\nE\t\u0015!\u0003\u00032!1qn\u0012C\u0001\u0005\u0013B\u0011Ba\u0014H\u0001\u0004%\tA!\u0015\t\u0013\tes\t1A\u0005\u0002\tm\u0003\u0002\u0003B0\u000f\u0002\u0006KAa\u0015\t\u000f\t%t\t\"\u0001\u0003l!I!1O$\u0002\u0002\u0013\u0005!Q\u000f\u0005\n\u0005\u0003;\u0015\u0013!C\u0001\u0005\u0007C\u0001B!(H\u0003\u0003%\t\u0005\u001e\u0005\n\u0005?;\u0015\u0011!C\u0001\u0005#B\u0011B!)H\u0003\u0003%\tAa)\t\u0013\t\u001dv)!A\u0005B\t%\u0006\"\u0003BZ\u000f\u0006\u0005I\u0011\u0001B[\u0011%\u0011ylRA\u0001\n\u0003\u0012\t\rC\u0005\u0003F\u001e\u000b\t\u0011\"\u0011\u0003H\"I!\u0011Z$\u0002\u0002\u0013\u0005#1\u001a\u0005\n\u0005\u001b<\u0015\u0011!C!\u0005\u001f<\u0011\u0002b\u0001\u0001\u0003\u0003E\t\u0001\"\u0002\u0007\u0013\t=\u0001!!A\t\u0002\u0011\u001d\u0001BB8\\\t\u0003!\u0019\u0002C\u0005\u0003Jn\u000b\t\u0011\"\u0012\u0003L\"IAQC.\u0002\u0002\u0013\u0005Eq\u0003\u0005\n\tGY\u0016\u0011!CA\tK\u0011\u0001e\u00117vgR,'\u000fT5oWR\u0013\u0018M\\:ji&|g.T5se>\u00148\u000fV3ti*\u0011!mY\u0001\u0005Y&t7N\u0003\u0002eK\u000611/\u001a:wKJT\u0011AZ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u000e\u0005\u0002k[6\t1NC\u0001m\u0003\u0015\u00198-\u00197b\u0013\tq7N\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0004\"A\u001d\u0001\u000e\u0003\u0005\f\u0001\u0002\\5oW:\u000bW.Z\u000b\u0002kB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0005Y\u0006twMC\u0001{\u0003\u0011Q\u0017M^1\n\u0005q<(AB*ue&tw-A\u0005mS:\\g*Y7fA\u00051A.\u001b8l\u0013\u0012,\"!!\u0001\u0011\t\u0005\r\u00111C\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u000511m\\7n_:T1AZA\u0006\u0015\u0011\ti!a\u0004\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\t\"A\u0002pe\u001eLA!!\u0006\u0002\u0006\t!Q+^5e\u0003\u001da\u0017N\\6JI\u0002\n\u0001\u0002\\5oW\u0012\u000bG/Y\u000b\u0003\u0003;\u0001B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G)\u0017A\u0001>l\u0013\u0011\t9#!\t\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0011\u0002\\5oW\u0012\u000bG/\u0019\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA\u0018!\r\u0011\u0018\u0011G\u0005\u0004\u0003g\t'\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\n!\u0002\\8dC2\fE-\\5o+\t\tY\u0004E\u0002s\u0003{I1!a\u0010b\u0005U\u0019E.^:uKJd\u0015N\\6M_\u000e\fG.\u00113nS:\f1\u0002\\8dC2\fE-\\5oA\u0005Y!/Z7pi\u0016\fE-\\5o+\t\t9\u0005\u0005\u0003\u0002J\u0005MSBAA&\u0015\u0011\ti%a\u0014\u0002\u000b\u0005$W.\u001b8\u000b\t\u0005E\u0013\u0011B\u0001\bG2LWM\u001c;t\u0013\u0011\t)&a\u0013\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u0006a!/Z7pi\u0016\fE-\\5oA\u0005YA.\u001b8l\u001b\u0006t\u0017mZ3s+\t\ti\u0006E\u0002s\u0003?J1!!\u0019b\u0005I\u0019E.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0002\u00191Lgn['b]\u0006<WM\u001d\u0011\u0002\u001b\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3s+\t\tI\u0007E\u0002s\u0003WJ1!!\u001cb\u0005q\u0019E.^:uKJd\u0015N\\6EKN$8\t\\5f]Rl\u0015M\\1hKJ\fab\u00197jK:$X*\u00198bO\u0016\u0014\b%A\u0006mS:\\W*\u001a;sS\u000e\u001cXCAA;!\r\u0011\u0018qO\u0005\u0004\u0003s\n'AE\"mkN$XM\u001d'j].lU\r\u001e:jGN\fA\u0002\\5oW6+GO]5dg\u0002\nq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0003\u0003\u0003\u00032A]AB\u0013\r\t))\u0019\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0011[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\nA\u0001^5nKV\u0011\u0011Q\u0012\t\u0005\u0003\u001f\u000b)*\u0004\u0002\u0002\u0012*!\u00111SA\u0003\u0003\u0015)H/\u001b7t\u0013\u0011\t9*!%\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0006cV|G/Y\u000b\u0003\u0003?\u0003B!!)\u0002$6\t1-C\u0002\u0002&\u000e\u0014qc\u00117vgR,'\u000fT5oWJ+\u0017/^3tiF+x\u000e^1\u0002\rE,x\u000e^1!\u00031\u0011'o\\6fe\u000e{gNZ5h+\t\ti\u000b\u0005\u0003\u0002\"\u0006=\u0016bAAYG\nY1*\u00194lC\u000e{gNZ5h\u00035\u0011'o\\6fe\u000e{gNZ5hA\u0005QA.\u001b8l\u0007>tg-[4\u0016\u0005\u0005e\u0006c\u0001:\u0002<&\u0019\u0011QX1\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw-\u0001\bmS:\\7i\u001c8gS\u001e|F%Z9\u0015\t\u0005\r\u0017\u0011\u001a\t\u0004U\u0006\u0015\u0017bAAdW\n!QK\\5u\u0011%\tY-HA\u0001\u0002\u0004\tI,A\u0002yIE\n1\u0002\\5oW\u000e{gNZ5hA\u0005Y1\u000f^8q\u001b&\u0014(o\u001c:t+\t\t\u0019\u000eE\u0002s\u0003+L1!a6b\u0005Y\u0019E.^:uKJd\u0015N\\6Ti>\u0004X*\u001b:s_J\u001c\u0018aD:u_Bl\u0015N\u001d:peN|F%Z9\u0015\t\u0005\r\u0017Q\u001c\u0005\n\u0003\u0017\u0004\u0013\u0011!a\u0001\u0003'\fAb\u001d;pa6K'O]8sg\u0002\n1\u0004Z3tGJL'-\u001a+pa&\u001c7i\u001c8gS\u001e\u001ch)\u001e;ve\u0016\u001cXCAAs!!\t9/!=\u0002v\n%QBAAu\u0015\u0011\tY/!<\u0002\u000f5,H/\u00192mK*\u0019\u0011q^6\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002t\u0006%(aA'baB!\u0011q\u001fB\u0003\u001d\u0011\tIP!\u0001\u0011\u0007\u0005m8.\u0004\u0002\u0002~*\u0019\u0011q`4\u0002\rq\u0012xn\u001c;?\u0013\r\u0011\u0019a[\u0001\u0007!J,G-\u001a4\n\u0007q\u00149AC\u0002\u0003\u0004-\u0004DAa\u0003\u0003VB)!QB$\u0003T6\t\u0001AA\bSKR\u0014\u0018.\u00192mK\u001a+H/\u001e:f+\u0011\u0011\u0019B!\u000e\u0014\r\u001dK'Q\u0003B\u000e!\rQ'qC\u0005\u0004\u00053Y'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0005;\u00119C\u0004\u0003\u0003 \t\rb\u0002BA~\u0005CI\u0011\u0001\\\u0005\u0004\u0005KY\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005S\u0011YC\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0003&-\f1BZ5oC2\u0014Vm];miV\u0011!\u0011\u0007\t\u0005\u0005g\u0011)\u0004\u0004\u0001\u0005\u000f\t]rI1\u0001\u0003:\t\tA+\u0005\u0003\u0003<\t\u0005\u0003c\u00016\u0003>%\u0019!qH6\u0003\u000f9{G\u000f[5oOB\u0019!Na\u0011\n\u0007\t\u00153NA\u0002B]f\fABZ5oC2\u0014Vm];mi\u0002\"BAa\u0013\u0003NA)!QB$\u00032!9!Q\u0006&A\u0002\tE\u0012!\u00054bS2,(/Z:SK6\f\u0017N\\5oOV\u0011!1\u000b\t\u0004U\nU\u0013b\u0001B,W\n\u0019\u0011J\u001c;\u0002+\u0019\f\u0017\u000e\\;sKN\u0014V-\\1j]&twm\u0018\u0013fcR!\u00111\u0019B/\u0011%\tY\rTA\u0001\u0002\u0004\u0011\u0019&\u0001\ngC&dWO]3t%\u0016l\u0017-\u001b8j]\u001e\u0004\u0003fA'\u0003dA\u0019!N!\u001a\n\u0007\t\u001d4N\u0001\u0005w_2\fG/\u001b7f\u0003)qW\r\u001f;GkR,(/\u001a\u000b\u0003\u0005[\u0002b!a\u0001\u0003p\tE\u0012\u0002\u0002B9\u0003\u000b\u00111bS1gW\u00064U\u000f^;sK\u0006!1m\u001c9z+\u0011\u00119H! \u0015\t\te$q\u0010\t\u0006\u0005\u001b9%1\u0010\t\u0005\u0005g\u0011i\bB\u0004\u00038=\u0013\rA!\u000f\t\u0013\t5r\n%AA\u0002\tm\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0005\u0005\u000b\u0013Y*\u0006\u0002\u0003\b*\"!\u0011\u0007BEW\t\u0011Y\t\u0005\u0003\u0003\u000e\n]UB\u0001BH\u0015\u0011\u0011\tJa%\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BKW\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\te%q\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,Ga\u0002B\u001c!\n\u0007!\u0011H\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\tBS\u0011%\tYmUA\u0001\u0002\u0004\u0011\u0019&A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\u000b\u0005\u0004\u0003.\n=&\u0011I\u0007\u0003\u0003[LAA!-\u0002n\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u00119L!0\u0011\u0007)\u0014I,C\u0002\u0003<.\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002LV\u000b\t\u00111\u0001\u0003B\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\r)(1\u0019\u0005\n\u0003\u00174\u0016\u0011!a\u0001\u0005'\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005'\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002k\u00061Q-];bYN$BAa.\u0003R\"I\u00111Z-\u0002\u0002\u0003\u0007!\u0011\t\t\u0005\u0005g\u0011)\u000eB\u0006\u0003X\u000e\n\t\u0011!A\u0003\u0002\te\"aA0%c\u0005aB-Z:de&\u0014W\rV8qS\u000e\u001cuN\u001c4jON4U\u000f^;sKN\u0004\u0013aG1mi\u0016\u00148i\u001c8tk6,'o\u00144gg\u0016$8OR;ukJ,7/\u0006\u0002\u0003`BA\u0011q]Ay\u0003k\u0014\t\u000f\r\u0003\u0003d\n\u001d\b#\u0002B\u0007\u000f\n\u0015\b\u0003\u0002B\u001a\u0005O$1B!;&\u0003\u0003\u0005\tQ!\u0001\u0003:\t\u0019q\f\n\u001a\u00029\u0005dG/\u001a:D_:\u001cX/\\3s\u001f\u001a47/\u001a;t\rV$XO]3tA\u0005)1/\u001a;VaR\u0011\u00111\u0019\u0015\u0004M\tM\b\u0003\u0002B{\u0007\u0007i!Aa>\u000b\t\te(1`\u0001\u0004CBL'\u0002\u0002B\u007f\u0005\u007f\fqA[;qSR,'O\u0003\u0003\u0004\u0002\u0005=\u0011!\u00026v]&$\u0018\u0002BB\u0003\u0005o\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\u0014\u0004\fA!!Q_B\u0007\u0013\u0011\u0019yAa>\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\u0007;fgR4\u0015-\u001b7pm\u0016\u0014hj\\(gMN,GoU=oG\"\u001a\u0001f!\u0006\u0011\t\tU8qC\u0005\u0005\u00073\u00119P\u0001\u0003UKN$\u0018\u0001\u0004;fgR4\u0015-\u001b7pm\u0016\u0014\bfA\u0015\u0004\u0016\u0005)B/Z:u\u001bVdG/\u001b9mK\u001a\u000b\u0017\u000e\\8wKJ\u001c\bf\u0001\u0016\u0004\u0016\u0005YA/Z:u!J|Wn\u001c;fQ\rY3QC\u0001\u0015i\u0016\u001cH/T;mi&\u0004H.\u001a)s_6|G/Z:)\u00071\u001a)\"A\u0010uKN$X*\u001e7uSBdW\r\u0015:p[>$X-\u00118e\r\u0006LGn\u001c<feND3!LB\u000b\u00039!Xm\u001d;Ti>\u0004X*\u001b:s_JD3ALB\u000b\u0003a!Xm\u001d;SKZ,'o]3B]\u0012\u001cv/\u00199NSJ\u0014xN\u001d\u0015\u0004_\rU\u0011a\u0005;fgR\u001cuN\u001c<feR$v.T5se>\u0014\bf\u0001\u0019\u0004\u0016\u0005\u0001B/Z:u%\u0016\u0004\u0018-\u001b:NSJ\u0014xN\u001d\u0015\u0004c\rU\u0011!\u0006;fgR\u001cE.Z1s'R\f'\u000f^(gMN,Go\u001d\u0015\u0004e\rU\u0011\u0001\u0006<fe&4\u0017\u0010\u0016:b]NLG/[8o)\u0006\u001c8\u000e\u0006\u0004\u0002D\u000e\u001d3\u0011\u000b\u0005\b\u0007\u0013\u001a\u0004\u0019AB&\u0003%\u0011\u0017\r^2i)\u0006\u001c8\u000eE\u0002s\u0007\u001bJ1aa\u0014b\u0005q\u0019E.^:uKJd\u0015N\\6Ue\u0006t7/\u001b;j_:l\u0015N\u001d:peNDqaa\u00154\u0001\u0004\u0019)&A\u0003ti\u0006$X\rE\u0002s\u0007/J1a!\u0017b\u0005U\u0019E.^:uKJd\u0015N\\6U_BL7m\u0015;bi\u0016\f\u0011c\u00197vgR,'\u000fT5oW\u000e{gNZ5h)\u0011\tIla\u0018\t\u0013\r\u0005D\u0007%AA\u0002\t]\u0016\u0001D3oC\ndWm\u0012:pkB\u001c\u0018aG2mkN$XM\u001d'j].\u001cuN\u001c4jO\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004h)\"!q\u0017BE\u00035!x\u000e]5d%\u0016\u001cx.\u001e:dKR!1QNB=!\u0011\u0019yg!\u001e\u000e\u0005\rE$\u0002BB:\u0003\u000b\taaY8oM&<\u0017\u0002BB<\u0007c\u0012abQ8oM&<'+Z:pkJ\u001cW\rC\u0004\u0004|Y\u0002\r!!>\u0002\u000bQ|\u0007/[2\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0006\u0003\u0004\u0002\u000e5\u0005C\u0002B\u000f\u0007\u0007\u001b9)\u0003\u0003\u0004\u0006\n-\"aA*fcB!\u00111ABE\u0013\u0011\u0019Y)!\u0002\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"911P\u001cA\u0002\u0005U\u0018!E7pG.$v\u000e]5d\u001b\u0016$\u0018\rZ1uCR1\u00111YBJ\u0007+Cqaa\u001f9\u0001\u0004\t)\u0010C\u0004\u0004\u0018b\u0002\rAa.\u0002\u0017MLhn\u00195s_:L'0Z\u0001\u0012[>\u001c7NU3qY&\u001c\u0017m\u0015;biV\u001cH\u0003BAb\u0007;Cqaa\u001f:\u0001\u0004\t)0\u0001\rn_\u000e\\G)Z:de&\u0014W\rV8qS\u000e\u001cuN\u001c4jON$B!a1\u0004$\"911\u0010\u001eA\u0002\u0005U\u0018!F7pG.\fE\u000e^3s)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\u0005\u0003\u0007\u001cI\u000bC\u0004\u0004|m\u0002\r!!>\u0002-5|7m\u001b'jgR\u001cuN\\:v[\u0016\u0014xI]8vaN$B!a1\u00040\"9\u0011Q\n\u001fA\u0002\u0005\u001d\u0013\u0001H7pG.d\u0015n\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f](gMN,Go\u001d\u000b\u0007\u0003\u0007\u001c)la.\t\u000f\u00055S\b1\u0001\u0002H!911P\u001fA\u0002\u0005U\u0018!H7pG.\fE\u000e^3s\u0007>t7/^7fe\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:\u0015\t\u0005\r7Q\u0018\u0005\b\u0007wr\u0004\u0019AA{\u0003AiwnY6BYR,'/T5se>\u00148\u000f\u0006\u0003\u0002D\u000e\r\u0007bBB>\u007f\u0001\u0007\u0011Q_\u0001\u0015g\u0016$X\u000f]'pG.4uN\u001d$bS2|g/\u001a:\u0015\t\u0005\r7\u0011\u001a\u0005\b\u0007w\u0002\u0005\u0019AA{\u0003M\u0019X\r^;q\u001b>\u001c7NR8s!J|Wn\u001c;f)\u0011\t\u0019ma4\t\u000f\rm\u0014\t1\u0001\u0002v\u0006\u0001r/Y5u\r>\u0014H+Y:l\u0007>,h\u000e\u001e\u000b\u0007\u0003\u0007\u001c)n!7\t\u000f\r]'\t1\u0001\u0003T\u0005)1m\\;oi\"I1\u0011\n\"\u0011\u0002\u0003\u000711J\u0001\u001bo\u0006LGOR8s)\u0006\u001c8nQ8v]R$C-\u001a4bk2$HEM\u000b\u0003\u0007?TCaa\u0013\u0003\n\u0006y2\u000f^8q\u001b&\u0014(o\u001c:t\u0003:$w+Y5u\r>\u00148i\\7qY\u0016$\u0018n\u001c8\u0015\t\u0005\r7Q\u001d\u0005\b\u0007O$\u0005\u0019ABu\u0003\u0019!x\u000e]5dgB1!QDBB\u0003k\f!c\u001d;pa6K'O]8sg6\u000bGo\u00195feR!1q^B~!!\u0011ik!=\u0002v\u000eM\u0018\u0002BAz\u0003[\u0004bA!\b\u0004\u0004\u000eU\bc\u00016\u0004x&\u00191\u0011`6\u0003\t1{gn\u001a\u0005\b\u0007w*\u0005\u0019AA{\u0003-i\u0017N\u001d:peN#\u0018\r^3\u0015\t\rUC\u0011\u0001\u0005\b\u0007w2\u0005\u0019AA{\u0003=\u0011V\r\u001e:jC\ndWMR;ukJ,\u0007c\u0001B\u00077N!1,\u001bC\u0005!\u0011!Y\u0001\"\u0005\u000e\u0005\u00115!b\u0001C\bs\u0006\u0011\u0011n\\\u0005\u0005\u0005S!i\u0001\u0006\u0002\u0005\u0006\u0005)\u0011\r\u001d9msV!A\u0011\u0004C\u0010)\u0011!Y\u0002\"\t\u0011\u000b\t5q\t\"\b\u0011\t\tMBq\u0004\u0003\b\u0005oq&\u0019\u0001B\u001d\u0011\u001d\u0011iC\u0018a\u0001\t;\tq!\u001e8baBd\u00170\u0006\u0003\u0005(\u0011EB\u0003\u0002C\u0015\tg\u0001RA\u001bC\u0016\t_I1\u0001\"\fl\u0005\u0019y\u0005\u000f^5p]B!!1\u0007C\u0019\t\u001d\u00119d\u0018b\u0001\u0005sA\u0011\u0002\"\u000e`\u0003\u0003\u0005\r\u0001b\u000e\u0002\u0007a$\u0003\u0007E\u0003\u0003\u000e\u001d#y\u0003")
public class ClusterLinkTransitionMirrorsTest {
    private volatile ClusterLinkTransitionMirrorsTest$RetriableFuture$ RetriableFuture$module;
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final ClusterLinkData linkData = new ClusterLinkData(this.linkName(), this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler(0, 100);
    private final ClusterLinkLocalAdmin localAdmin = (ClusterLinkLocalAdmin)Mockito.mock(ClusterLinkLocalAdmin.class);
    private final ConfluentAdmin remoteAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkManager linkManager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
    private final ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
    private final ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(this.linkName(), this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, false, (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$, false);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final Time time = new MockTime();
    private final ClusterLinkRequestQuota quota = (ClusterLinkRequestQuota)Mockito.mock(ClusterLinkRequestQuota.class);
    private final KafkaConfig brokerConfig = (KafkaConfig)Mockito.mock(KafkaConfig.class);
    private ClusterLinkConfig linkConfig = this.clusterLinkConfig(true);
    private ClusterLinkStopMirrors stopMirrors;
    private final scala.collection.mutable.Map<String, RetriableFuture<?>> describeTopicConfigsFutures = (scala.collection.mutable.Map)Map$.MODULE$.empty();
    private final scala.collection.mutable.Map<String, RetriableFuture<?>> alterConsumerOffsetsFutures = (scala.collection.mutable.Map)Map$.MODULE$.empty();

    public ClusterLinkTransitionMirrorsTest$RetriableFuture$ RetriableFuture() {
        if (this.RetriableFuture$module == null) {
            this.RetriableFuture$lzycompute$1();
        }
        return this.RetriableFuture$module;
    }

    private String linkName() {
        return this.linkName;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ClusterLinkLocalAdmin localAdmin() {
        return this.localAdmin;
    }

    private ConfluentAdmin remoteAdmin() {
        return this.remoteAdmin;
    }

    private ClusterLinkManager linkManager() {
        return this.linkManager;
    }

    private ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    private ClusterLinkMetrics linkMetrics() {
        return this.linkMetrics;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private Time time() {
        return this.time;
    }

    private ClusterLinkRequestQuota quota() {
        return this.quota;
    }

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private void linkConfig_$eq(ClusterLinkConfig x$1) {
        this.linkConfig = x$1;
    }

    private ClusterLinkStopMirrors stopMirrors() {
        return this.stopMirrors;
    }

    private void stopMirrors_$eq(ClusterLinkStopMirrors x$1) {
        this.stopMirrors = x$1;
    }

    private scala.collection.mutable.Map<String, RetriableFuture<?>> describeTopicConfigsFutures() {
        return this.describeTopicConfigsFutures;
    }

    private scala.collection.mutable.Map<String, RetriableFuture<?>> alterConsumerOffsetsFutures() {
        return this.alterConsumerOffsetsFutures;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.linkMetrics().startup();
        Mockito.when((Object)this.brokerConfig().clusterLinkMirrorTransitionBatchSize()).thenReturn((Object)Predef$.MODULE$.int2Integer(2));
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().metadataManager()).thenReturn((Object)this.metadataManager());
        Mockito.when((Object)this.clientManager().localAdminFactory()).thenReturn((Function0 & Serializable)() -> this.localAdmin());
        Mockito.when((Object)this.clientManager().getAdmin()).thenReturn((Object)this.remoteAdmin());
        Function0 & Serializable apply_admin = (Function0 & Serializable)() -> this.remoteAdmin();
        if (true > true) {
            throw new IllegalArgumentException("Scheduler must be provided for batching admin");
        }
        Object var1_1 = null;
        Mockito.when((Object)this.clientManager().remoteBatchAdmin()).thenReturn((Object)new ClusterLinkNonBatchingAdmin((Function0)apply_admin));
        Function0 & Serializable apply_admin2 = (Function0 & Serializable)() -> this.localAdmin();
        if (true > true) {
            throw new IllegalArgumentException("Scheduler must be provided for batching admin");
        }
        Object var2_2 = null;
        Mockito.when((Object)this.clientManager().localBatchAdmin()).thenReturn((Object)new ClusterLinkNonBatchingAdmin((Function0)apply_admin2));
        Mockito.when((Object)this.clientManager().metrics()).thenReturn((Object)this.linkMetrics());
        Mockito.when((Object)this.clientManager().time()).thenReturn((Object)this.time());
        Mockito.when((Object)this.clientManager().linkData()).thenReturn((Object)this.linkData());
        Mockito.when((Object)this.clientManager().alterConfigPolicy()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.clientManager().currentConfig()).thenAnswer(x$2 -> this.linkConfig());
        Mockito.when((Object)this.clientManager().requestQuota()).thenReturn((Object)this.quota());
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenAnswer(x$3 -> this.linkConfig().topicConfigSyncRules());
        this.stopMirrors_$eq(new ClusterLinkStopMirrors(this.brokerConfig(), this.linkManager(), this.scheduler(), this.time(), 100));
        this.stopMirrors().startup();
    }

    @AfterEach
    public void tearDown() {
        this.stopMirrors().shutdown();
        this.scheduler().shutdown();
        this.linkMetrics().shutdown();
    }

    @Test
    public void testFailoverNoOffsetSync() {
        this.linkConfig_$eq(this.clusterLinkConfig(false));
        String topic = "topic";
        this.mockTopicMetadata(topic, false);
        this.mockReplicaStatus(topic);
        this.mockAlterMirrors(topic);
        this.stopMirrorsAndWaitForCompletion((scala.collection.immutable.Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
    }

    @Test
    public void testFailover() {
        String topic = "topic";
        this.setupMockForFailover(topic);
        this.stopMirrorsAndWaitForCompletion((scala.collection.immutable.Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
    }

    @Test
    public void testMultipleFailovers() {
        IndexedSeq topics = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> ClusterLinkTransitionMirrorsTest.$anonfun$testMultipleFailovers$1(this, BoxesRunTime.unboxToInt((Object)i)));
        this.stopMirrorsAndWaitForCompletion((scala.collection.immutable.Seq<String>)topics);
    }

    @Test
    public void testPromote() {
        String topic = "topic";
        this.setupMockForPromote(topic);
        this.stopMirrorsAndWaitForCompletion((scala.collection.immutable.Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
    }

    @Test
    public void testMultiplePromotes() {
        IndexedSeq topics = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> ClusterLinkTransitionMirrorsTest.$anonfun$testMultiplePromotes$1(this, BoxesRunTime.unboxToInt((Object)i)));
        this.stopMirrorsAndWaitForCompletion((scala.collection.immutable.Seq<String>)topics);
    }

    @Test
    public void testMultiplePromoteAndFailovers() {
        IndexedSeq failoverTopics = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> ClusterLinkTransitionMirrorsTest.$anonfun$testMultiplePromoteAndFailovers$1(this, BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq promoteTopics = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 40).map((Function1 & Serializable)i -> ClusterLinkTransitionMirrorsTest.$anonfun$testMultiplePromoteAndFailovers$2(this, BoxesRunTime.unboxToInt((Object)i)));
        ((IterableOnceOps)failoverTopics.take(5)).foreach((Function1 & Serializable)topic -> {
            ClusterLinkTransitionMirrorsTest.$anonfun$testMultiplePromoteAndFailovers$3(this, topic);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)promoteTopics.slice(0, 10)).foreach((Function1 & Serializable)topic -> {
            ClusterLinkTransitionMirrorsTest.$anonfun$testMultiplePromoteAndFailovers$4(this, topic);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)promoteTopics.slice(10, 20)).foreach((Function1 & Serializable)topic -> {
            ClusterLinkTransitionMirrorsTest.$anonfun$testMultiplePromoteAndFailovers$5(this, topic);
            return BoxedUnit.UNIT;
        });
        promoteTopics.foreach((Function1 & Serializable)topic -> {
            ClusterLinkTransitionMirrorsTest.$anonfun$testMultiplePromoteAndFailovers$6(this, topic);
            return BoxedUnit.UNIT;
        });
        failoverTopics.foreach((Function1 & Serializable)topic -> {
            ClusterLinkTransitionMirrorsTest.$anonfun$testMultiplePromoteAndFailovers$7(this, topic);
            return BoxedUnit.UNIT;
        });
        this.waitForTaskCount(20, this.waitForTaskCount$default$2());
        this.alterConsumerOffsetsFutures().$minus$minus$eq((IterableOnce)failoverTopics);
        ((IterableOnceOps)promoteTopics.slice(5, 10)).foreach((Function1 & Serializable)topic -> {
            ClusterLinkTransitionMirrorsTest.$anonfun$testMultiplePromoteAndFailovers$8(this, topic);
            return BoxedUnit.UNIT;
        });
        this.describeTopicConfigsFutures().values().foreach((Function1 & Serializable)x$4 -> {
            x$4.failuresRemaining_$eq(0);
            return BoxedUnit.UNIT;
        });
        this.waitForTaskCount(15, this.waitForTaskCount$default$2());
        ((IterableOnceOps)((IterableOps)this.alterConsumerOffsetsFutures().values().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkTransitionMirrorsTest.$anonfun$testMultiplePromoteAndFailovers$10(x$5)))).take(5)).foreach((Function1 & Serializable)x$6 -> {
            x$6.failuresRemaining_$eq(0);
            return BoxedUnit.UNIT;
        });
        this.waitForTaskCount(10, this.waitForTaskCount$default$2());
        this.alterConsumerOffsetsFutures().values().foreach((Function1 & Serializable)x$7 -> {
            x$7.failuresRemaining_$eq(0);
            return BoxedUnit.UNIT;
        });
        this.waitForTaskCount(0, this.waitForTaskCount$default$2());
        failoverTopics.foreach((Function1 & Serializable)topic -> ((ClusterLinkLocalAdmin)Mockito.verify((Object)this.localAdmin(), (VerificationMode)Mockito.times((int)1))).stopMirrors(this.stopMirrorsMatcher((String)topic)));
        promoteTopics.foreach((Function1 & Serializable)topic -> ((ClusterLinkLocalAdmin)Mockito.verify((Object)this.localAdmin(), (VerificationMode)Mockito.times((int)1))).stopMirrors(this.stopMirrorsMatcher((String)topic)));
    }

    @Test
    public void testStopMirror() {
        new .colon.colon((Object)"topic1", (List)new .colon.colon((Object)"topic2", (List)new .colon.colon((Object)"topic3", (List)new .colon.colon((Object)"topic4", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)topic -> {
            ClusterLinkTransitionMirrorsTest.$anonfun$testStopMirror$1(this, topic);
            return BoxedUnit.UNIT;
        });
        this.verifyTransitionTask((ClusterLinkTransitionMirrors)this.stopMirrors(), this.mirrorState("topic1"));
    }

    @Test
    public void testReverseAndSwapMirror() {
        ClusterLinkReverseAndSwapMirrors reverseAndSwap = new ClusterLinkReverseAndSwapMirrors(this.brokerConfig(), this.linkManager(), this.scheduler(), this.time(), 100);
        reverseAndSwap.startup();
        this.verifyTransitionTask((ClusterLinkTransitionMirrors)reverseAndSwap, (ClusterLinkTopicState)new ClusterLinkTopicState.PendingSynchronizeMirror(this.linkName(), this.linkId(), Uuid.randomUuid(), (TopicLinkState)TopicLinkStoppedMirror$.MODULE$, Time.SYSTEM.milliseconds()));
    }

    @Test
    public void testConvertToMirror() {
        ClusterLinkConvertTopicsToMirrors convertToMirror = new ClusterLinkConvertTopicsToMirrors(this.brokerConfig(), this.linkManager(), this.scheduler(), this.time(), 100);
        convertToMirror.startup();
        this.verifyTransitionTask((ClusterLinkTransitionMirrors)convertToMirror, (ClusterLinkTopicState)new ClusterLinkTopicState.PendingMirror(this.linkName(), this.linkId(), Uuid.randomUuid(), "PausedMirror", Time.SYSTEM.milliseconds()));
    }

    @Test
    public void testRepairMirror() {
        ClusterLinkRepairMirrors repairMirror = new ClusterLinkRepairMirrors(this.brokerConfig(), this.linkManager(), this.scheduler(), this.clientManager().localBatchAdmin(), this.time(), 100);
        repairMirror.startup();
        this.verifyTransitionTask((ClusterLinkTransitionMirrors)repairMirror, (ClusterLinkTopicState)new ClusterLinkTopicState.PendingRepairMirror(this.linkName(), this.linkId(), Uuid.randomUuid(), MirrorTopicError.UNSUPPORTED_MESSAGE_FORMAT, Time.SYSTEM.milliseconds()));
    }

    @Test
    public void testClearStartOffsets() {
        ClusterLinkClearStartOffsetsForMirrors clearStartOffsets = new ClusterLinkClearStartOffsetsForMirrors(this.brokerConfig(), this.linkManager(), this.scheduler(), this.clientManager().localBatchAdmin(), this.time(), 100);
        clearStartOffsets.startup();
        String x$1 = this.linkName();
        Uuid x$2 = this.linkId();
        Uuid x$3 = Uuid.randomUuid();
        scala.collection.immutable.Seq x$4 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{10L, 20L}));
        long x$5 = Time.SYSTEM.milliseconds();
        this.verifyTransitionTask((ClusterLinkTransitionMirrors)clearStartOffsets, (ClusterLinkTopicState)new ClusterLinkTopicState.Mirror(x$1, x$2, x$3, x$5, (Seq)x$4));
    }

    private void verifyTransitionTask(ClusterLinkTransitionMirrors batchTask, ClusterLinkTopicState state) {
        new .colon.colon((Object)"topic1", (List)new .colon.colon((Object)"topic2", (List)new .colon.colon((Object)"topic3", (List)new .colon.colon((Object)"topic4", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)topic -> Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)ArgumentMatchers.eq((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))))).thenReturn(scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)state)}))));
        batchTask.maybeAddTask("topic1", this.mirrorState("topic1"), (Option)None$.MODULE$, this.clientManager());
        this.waitForTaskCount(1, batchTask);
        ClusterLinkTransitionMirrors.TaskInfo task = (ClusterLinkTransitionMirrors.TaskInfo)batchTask.subTask("topic1").get();
        Assertions.assertEquals((Object)this.linkId(), (Object)task.linkId());
        Assertions.assertEquals((Object)"topic1", (Object)task.topic());
        Assertions.assertNotEquals((Object)UnboundedClusterLinkRequestQuota$.MODULE$, (Object)task.task().quota());
        batchTask.maybeAddTask("topic1", this.mirrorState("topic1"), (Option)None$.MODULE$, this.clientManager());
        Assertions.assertEquals((int)1, (int)batchTask.subTaskCount());
        batchTask.maybeAddTask("topic2", this.mirrorState("topic2"), (Option)None$.MODULE$, this.clientManager());
        Assertions.assertEquals((int)2, (int)batchTask.subTaskCount());
        batchTask.maybeAddTask("topic3", (ClusterLinkTopicState)new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), Uuid.randomUuid(), MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, Time.SYSTEM.milliseconds()), (Option)None$.MODULE$, this.clientManager());
        Assertions.assertEquals((int)2, (int)batchTask.subTaskCount());
        batchTask.maybeAddTask("topic4", this.mirrorState("topic4"), (Option)new Some((Object)this.mirrorState("topic4")), this.clientManager());
        Assertions.assertEquals((int)2, (int)batchTask.subTaskCount());
    }

    private ClusterLinkConfig clusterLinkConfig(boolean enableGroups) {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        props.put(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), Boolean.toString(enableGroups));
        if (enableGroups) {
            props.put(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), ClusterLinkTestUtils$.MODULE$.AllGroupsFilter());
        }
        return ClusterLinkConfig$.MODULE$.create((java.util.Map)props, (Option)None$.MODULE$, true);
    }

    private boolean clusterLinkConfig$default$1() {
        return true;
    }

    private ConfigResource topicResource(String topic) {
        return new ConfigResource(ConfigResource.Type.TOPIC, topic);
    }

    private scala.collection.immutable.Seq<TopicPartition> partitions(String topic) {
        return new .colon.colon((Object)new TopicPartition(topic, 0), (List)Nil$.MODULE$);
    }

    private void mockTopicMetadata(String topic, boolean synchronize) {
        ClusterLinkTopicState.PendingStoppedMirror state = new ClusterLinkTopicState.PendingStoppedMirror(this.linkName(), this.linkId(), Uuid.randomUuid(), synchronize, Time.SYSTEM.milliseconds());
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)ArgumentMatchers.eq((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))))).thenReturn(scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)state)})));
        Mockito.when((Object)this.metadataManager().topicPartitions(topic)).thenReturn((Object)this.partitions(topic).toSet());
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)new Properties());
    }

    private void mockReplicaStatus(String topic) {
        ReplicaStatus replicaStatus = new ReplicaStatus(100, true, false, true, true, true, 100L, 1000L, -1L, -1L, Optional.of(this.linkName()), Optional.of(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.PENDING_STOPPED, -1L, 1000L)), Optional.of("pull"), OptionalLong.of(-2L));
        KafkaFuture future = KafkaFuture.completedFuture((Object)new PartitionResult(Collections.singletonList(replicaStatus)));
        scala.collection.immutable.Map results = ((IterableOnceOps)this.partitions(topic).map((Function1 & Serializable)x$8 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$8), (Object)future))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Mockito.when((Object)this.localAdmin().replicaStatus((java.util.Set)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava(results.keySet()).asJava()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)new ReplicaStatusResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)results).asJava()));
    }

    private void mockDescribeTopicConfigs(String topic) {
        DescribeConfigsResult result = (DescribeConfigsResult)Mockito.mock(DescribeConfigsResult.class);
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        Config config = new Config(Collections.emptySet());
        KafkaFuture allFuture = KafkaFuture.completedFuture(Collections.singletonMap(resource, config));
        Mockito.when((Object)result.all()).thenAnswer(x$9 -> allFuture);
        RetriableFuture<Config> resourceFuture = new RetriableFuture<Config>(this, config);
        this.describeTopicConfigsFutures().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), resourceFuture));
        Mockito.when((Object)result.values()).thenAnswer(x$10 -> Collections.singletonMap(resource, resourceFuture.nextFuture()));
        Mockito.when((Object)this.remoteAdmin().describeConfigs((Collection)ArgumentMatchers.eq(Collections.singleton(resource)), (DescribeConfigsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
    }

    private void mockAlterTopicConfigs(String topic) {
        AlterConfigsResult result = (AlterConfigsResult)Mockito.mock(AlterConfigsResult.class);
        KafkaFuture future = KafkaFuture.completedFuture(null);
        Mockito.when((Object)result.values()).thenAnswer(x$11 -> Collections.singletonMap(new ConfigResource(ConfigResource.Type.TOPIC, topic), future));
        Mockito.when((Object)this.localAdmin().incrementalAlterConfigs((java.util.Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
    }

    private void mockListConsumerGroups(ConfluentAdmin admin) {
        ListConsumerGroupsResult result = (ListConsumerGroupsResult)Mockito.mock(ListConsumerGroupsResult.class);
        KafkaFuture future = KafkaFuture.completedFuture(Collections.singleton(new ConsumerGroupListing("group", false)));
        Mockito.when((Object)result.all()).thenAnswer(x$12 -> future);
        Mockito.when((Object)admin.listConsumerGroups((ListConsumerGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
    }

    private void mockListConsumerGroupOffsets(ConfluentAdmin admin, String topic) {
        ListConsumerGroupOffsetsResult result = (ListConsumerGroupOffsetsResult)Mockito.mock(ListConsumerGroupOffsetsResult.class);
        scala.collection.immutable.Map offsets = ((IterableOnceOps)this.partitions(topic).map((Function1 & Serializable)x$13 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$13), (Object)new OffsetAndMetadata(5000L)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        KafkaFuture future = KafkaFuture.completedFuture((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)offsets).asJava());
        Mockito.when((Object)result.partitionsToOffsetAndMetadata()).thenAnswer(x$14 -> future);
        ListConsumerGroupOffsetsSpec spec = new ListConsumerGroupOffsetsSpec().topicPartitions((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)offsets.keySet().toList()).asJava());
        Mockito.when((Object)admin.listConsumerGroupOffsets((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap("group", spec)), (ListConsumerGroupOffsetsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
    }

    private void mockAlterConsumerGroupOffsets(String topic) {
        AlterConsumerGroupOffsetsResult result = (AlterConsumerGroupOffsetsResult)Mockito.mock(AlterConsumerGroupOffsetsResult.class);
        RetriableFuture<Object> future = new RetriableFuture<Object>(this, null);
        this.alterConsumerOffsetsFutures().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), future));
        Mockito.when((Object)result.all()).thenAnswer(x$15 -> future.nextFuture());
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)this.partitions(topic).map((Function1 & Serializable)x$16 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$16), (Object)new OffsetAndMetadata(1000L)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        Mockito.when((Object)this.localAdmin().alterConsumerGroupOffsets((String)ArgumentMatchers.eq((Object)"group"), (java.util.Map)ArgumentMatchers.eq((Object)offsets), (AlterConsumerGroupOffsetsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
    }

    private void mockAlterMirrors(String topic) {
        AlterMirrorsResult result = (AlterMirrorsResult)Mockito.mock(AlterMirrorsResult.class);
        KafkaFuture future = KafkaFuture.completedFuture(null);
        Mockito.when((Object)result.all()).thenReturn((Object)future);
        Mockito.when((Object)this.localAdmin().stopMirrors(this.stopMirrorsMatcher(topic))).thenReturn((Object)result);
    }

    private void setupMockForFailover(String topic) {
        this.mockTopicMetadata(topic, false);
        this.mockReplicaStatus(topic);
        this.mockListConsumerGroups((ConfluentAdmin)this.localAdmin());
        this.mockListConsumerGroupOffsets((ConfluentAdmin)this.localAdmin(), topic);
        this.mockAlterConsumerGroupOffsets(topic);
        this.mockAlterMirrors(topic);
    }

    private void setupMockForPromote(String topic) {
        this.mockTopicMetadata(topic, true);
        this.mockReplicaStatus(topic);
        this.mockDescribeTopicConfigs(topic);
        this.mockAlterTopicConfigs(topic);
        this.mockListConsumerGroups((ConfluentAdmin)this.localAdmin());
        this.mockListConsumerGroups(this.remoteAdmin());
        this.mockListConsumerGroupOffsets(this.remoteAdmin(), topic);
        this.mockListConsumerGroupOffsets((ConfluentAdmin)this.localAdmin(), topic);
        this.mockAlterConsumerGroupOffsets(topic);
        this.mockAlterMirrors(topic);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForTaskCount(int count, ClusterLinkTransitionMirrors batchTask) {
        void var4_9;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            int n = batchTask.subTaskCount();
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkTransitionMirrorsTest.$anonfun$waitForTaskCount$2(count, n)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var11_6 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int subtasks = tuple22._1$mcI$sp();
        Assertions.assertEquals((int)count, (int)var4_9);
    }

    private ClusterLinkTransitionMirrors waitForTaskCount$default$2() {
        return this.stopMirrors();
    }

    private void stopMirrorsAndWaitForCompletion(scala.collection.immutable.Seq<String> topics) {
        topics.foreach((Function1 & Serializable)topic -> {
            ClusterLinkTransitionMirrorsTest.$anonfun$stopMirrorsAndWaitForCompletion$1(this, topic);
            return BoxedUnit.UNIT;
        });
        this.waitForTaskCount(0, this.waitForTaskCount$default$2());
        topics.foreach((Function1 & Serializable)topic -> ((ClusterLinkLocalAdmin)Mockito.verify((Object)this.localAdmin(), (VerificationMode)Mockito.times((int)1))).stopMirrors(this.stopMirrorsMatcher((String)topic)));
    }

    private Map<String, scala.collection.immutable.Seq<Object>> stopMirrorsMatcher(String topic) {
        return (Map)ArgumentMatchers.argThat(ops -> {
            if (ops != null) {
                Set set = ops.keySet();
                Object object = Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
                if (!(set != null ? !set.equals(object) : object != null)) {
                    return true;
                }
            }
            return false;
        });
    }

    private ClusterLinkTopicState mirrorState(String topic) {
        return (ClusterLinkTopicState)this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).apply((Object)topic);
    }

    private final void RetriableFuture$lzycompute$1() {
        synchronized (this) {
            if (this.RetriableFuture$module == null) {
                this.RetriableFuture$module = new ClusterLinkTransitionMirrorsTest$RetriableFuture$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$setUp$3() {
        return 1;
    }

    public static final /* synthetic */ int $anonfun$setUp$4() {
        return 5;
    }

    public static final /* synthetic */ int $anonfun$setUp$6() {
        return 1;
    }

    public static final /* synthetic */ int $anonfun$setUp$7() {
        return 5;
    }

    public static final /* synthetic */ String $anonfun$testMultipleFailovers$1(ClusterLinkTransitionMirrorsTest $this, int i) {
        String topic = new StringBuilder(5).append("topic").append(i).toString();
        $this.setupMockForFailover(topic);
        if (i % 2 == 0) {
            ((RetriableFuture)$this.alterConsumerOffsetsFutures().apply((Object)topic)).failuresRemaining_$eq(Integer.MAX_VALUE);
        }
        return topic;
    }

    public static final /* synthetic */ String $anonfun$testMultiplePromotes$1(ClusterLinkTransitionMirrorsTest $this, int i) {
        String topic = new StringBuilder(5).append("topic").append(i).toString();
        $this.setupMockForPromote(topic);
        if (i % 2 == 0) {
            ((RetriableFuture)$this.alterConsumerOffsetsFutures().apply((Object)topic)).failuresRemaining_$eq(2);
        }
        return topic;
    }

    public static final /* synthetic */ String $anonfun$testMultiplePromoteAndFailovers$1(ClusterLinkTransitionMirrorsTest $this, int i) {
        String topic = new StringBuilder(5).append("topic").append(i).toString();
        $this.setupMockForFailover(topic);
        return topic;
    }

    public static final /* synthetic */ String $anonfun$testMultiplePromoteAndFailovers$2(ClusterLinkTransitionMirrorsTest $this, int i) {
        String topic = new StringBuilder(5).append("topic").append(i).toString();
        $this.setupMockForPromote(topic);
        return topic;
    }

    public static final /* synthetic */ void $anonfun$testMultiplePromoteAndFailovers$3(ClusterLinkTransitionMirrorsTest $this, String topic) {
        ((RetriableFuture)$this.alterConsumerOffsetsFutures().apply((Object)topic)).failuresRemaining_$eq(Integer.MAX_VALUE);
    }

    public static final /* synthetic */ void $anonfun$testMultiplePromoteAndFailovers$4(ClusterLinkTransitionMirrorsTest $this, String topic) {
        ((RetriableFuture)$this.describeTopicConfigsFutures().apply((Object)topic)).failuresRemaining_$eq(Integer.MAX_VALUE);
    }

    public static final /* synthetic */ void $anonfun$testMultiplePromoteAndFailovers$5(ClusterLinkTransitionMirrorsTest $this, String topic) {
        ((RetriableFuture)$this.alterConsumerOffsetsFutures().apply((Object)topic)).failuresRemaining_$eq(Integer.MAX_VALUE);
    }

    public static final /* synthetic */ void $anonfun$testMultiplePromoteAndFailovers$6(ClusterLinkTransitionMirrorsTest $this, String topic) {
        $this.stopMirrors().maybeAddTask(topic, $this.mirrorState(topic), (Option)None$.MODULE$, $this.clientManager());
    }

    public static final /* synthetic */ void $anonfun$testMultiplePromoteAndFailovers$7(ClusterLinkTransitionMirrorsTest $this, String topic) {
        $this.stopMirrors().maybeAddTask(topic, $this.mirrorState(topic), (Option)None$.MODULE$, $this.clientManager());
    }

    public static final /* synthetic */ void $anonfun$testMultiplePromoteAndFailovers$8(ClusterLinkTransitionMirrorsTest $this, String topic) {
        ((RetriableFuture)$this.alterConsumerOffsetsFutures().apply((Object)topic)).failuresRemaining_$eq(Integer.MAX_VALUE);
    }

    public static final /* synthetic */ boolean $anonfun$testMultiplePromoteAndFailovers$10(RetriableFuture x$5) {
        return x$5.failuresRemaining() > 0;
    }

    public static final /* synthetic */ void $anonfun$testStopMirror$1(ClusterLinkTransitionMirrorsTest $this, String topic) {
        $this.setupMockForPromote(topic);
        ((RetriableFuture)$this.describeTopicConfigsFutures().apply((Object)topic)).failuresRemaining_$eq(Integer.MAX_VALUE);
    }

    public static final /* synthetic */ int $anonfun$waitForTaskCount$1(ClusterLinkTransitionMirrors batchTask$1) {
        return batchTask$1.subTaskCount();
    }

    public static final /* synthetic */ boolean $anonfun$waitForTaskCount$2(int count$1, int x$17) {
        return x$17 == count$1;
    }

    public static final /* synthetic */ void $anonfun$stopMirrorsAndWaitForCompletion$1(ClusterLinkTransitionMirrorsTest $this, String topic) {
        $this.stopMirrors().maybeAddTask(topic, $this.mirrorState(topic), (Option)None$.MODULE$, $this.clientManager());
    }

    public ClusterLinkTransitionMirrorsTest() {
        this.linkName = "testLink";
    }

    public class RetriableFuture<T>
    implements Product,
    Serializable {
        private final T finalResult;
        private volatile int failuresRemaining;
        public final /* synthetic */ ClusterLinkTransitionMirrorsTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public T finalResult() {
            return this.finalResult;
        }

        public int failuresRemaining() {
            return this.failuresRemaining;
        }

        public void failuresRemaining_$eq(int x$1) {
            this.failuresRemaining = x$1;
        }

        public KafkaFuture<T> nextFuture() {
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (this.failuresRemaining() > 0) {
                this.failuresRemaining_$eq(this.failuresRemaining() - 1);
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException());
            } else {
                future.complete(this.finalResult());
            }
            return future;
        }

        public <T> RetriableFuture<T> copy(T finalResult) {
            return new RetriableFuture<T>(this.kafka$server$link$ClusterLinkTransitionMirrorsTest$RetriableFuture$$$outer(), finalResult);
        }

        public <T> T copy$default$1() {
            return this.finalResult();
        }

        public String productPrefix() {
            return "RetriableFuture";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.finalResult();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RetriableFuture;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "finalResult";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof RetriableFuture && ((RetriableFuture)x$1).kafka$server$link$ClusterLinkTransitionMirrorsTest$RetriableFuture$$$outer() == this.kafka$server$link$ClusterLinkTransitionMirrorsTest$RetriableFuture$$$outer())) break block3;
                    RetriableFuture retriableFuture = (RetriableFuture)x$1;
                    if (!BoxesRunTime.equals(this.finalResult(), retriableFuture.finalResult()) || !retriableFuture.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ClusterLinkTransitionMirrorsTest kafka$server$link$ClusterLinkTransitionMirrorsTest$RetriableFuture$$$outer() {
            return this.$outer;
        }

        public RetriableFuture(ClusterLinkTransitionMirrorsTest $outer, T finalResult) {
            this.finalResult = finalResult;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            this.failuresRemaining = 0;
        }
    }
}

