/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.kafka.link.ClusterLinkUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.controller.KafkaController;
import kafka.durability.DurabilityAuditMirrorState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataSupport;
import kafka.server.ZkSupport;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDynamicLogger;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.GroupClusterLinkFilter;
import kafka.server.link.GroupClusterLinkFilterInfo;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.MatchedGroup;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicClusterLinkFilter;
import kafka.server.link.TopicType$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.MirrorTopic;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t%a\u0001B\u00193\u0001eBQ\u0001\u0011\u0001\u0005\u0002\u0005Cq\u0001\u0012\u0001C\u0002\u0013\u0005Q\t\u0003\u0004J\u0001\u0001\u0006IA\u0012\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0011\u0019y\u0005\u0001)A\u0005\u0019\")\u0001\u000b\u0001C\u0001#\")!\r\u0001C\u0001#\")A\r\u0001C\u0001#\")a\r\u0001C\u0001#\")\u0001\u000e\u0001C\u0001#\")!\u000e\u0001C\u0001#\")A\u000e\u0001C\u0001#\")a\u000e\u0001C\u0001#\")\u0001\u000f\u0001C\u0001#\")!\u000f\u0001C\u0001#\")A\u000f\u0001C\u0001#\")a\u000f\u0001C\u0001#\")\u0001\u0010\u0001C\u0001#\")!\u0010\u0001C\u0001#\")A\u0010\u0001C\u0001#\")a\u0010\u0001C\u0001#\"1\u0011\u0011\u0001\u0001\u0005\u0002ECa!!\u0002\u0001\t\u0003\t\u0006BBA\u0005\u0001\u0011\u0005\u0011\u000b\u0003\u0004\u0002\u000e\u0001!\t!\u0015\u0005\u0007\u0003#\u0001A\u0011A)\t\r\u0005U\u0001\u0001\"\u0001R\u0011\u0019\tI\u0002\u0001C\u0001#\"9\u0011Q\u0004\u0001\u0005\n\u0005}\u0001BBA8\u0001\u0011\u0005\u0011\u000b\u0003\u0004\u0002t\u0001!\t!\u0015\u0005\u0007\u0003o\u0002A\u0011A)\t\r\u0005m\u0004\u0001\"\u0001R\u0011\u0019\ty\b\u0001C\u0001#\"1\u00111\u0011\u0001\u0005\u0002ECa!a\"\u0001\t\u0003\t\u0006BBAF\u0001\u0011\u0005\u0011\u000b\u0003\u0004\u0002\u0010\u0002!\t!\u0015\u0005\u0007\u0003'\u0003A\u0011A)\t\r\u0005]\u0005\u0001\"\u0001R\u0011\u0019\tY\n\u0001C\u0001#\"1\u0011q\u0014\u0001\u0005\u0002ECa!a)\u0001\t\u0003\t\u0006BBAT\u0001\u0011\u0005\u0011\u000b\u0003\u0004\u0002,\u0002!\t!\u0015\u0005\u0007\u0003_\u0003A\u0011A)\t\u000f\u0005M\u0006\u0001\"\u0003\u00026\"9\u0011\u0011\u001b\u0001\u0005\n\u0005M'\u0001F\"mkN$XM\u001d'j].,F/\u001b7t)\u0016\u001cHO\u0003\u00024i\u0005!A.\u001b8l\u0015\t)d'\u0001\u0004tKJ4XM\u001d\u0006\u0002o\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001;!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0011\t\u0003\u0007\u0002i\u0011AM\u0001\u000bY&t7nQ8oM&<W#\u0001$\u0011\u0005\r;\u0015B\u0001%3\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001\fY&t7nQ8oM&<\u0007%\u0001\u000bu_BL7mQ8oM&<7+\u001f8d%VdWm]\u000b\u0002\u0019B\u00111)T\u0005\u0003\u001dJ\u0012!$T5se>\u0014Hk\u001c9jG\u000e{gNZ5h'ft7MU;mKN\fQ\u0003^8qS\u000e\u001cuN\u001c4jONKhn\u0019*vY\u0016\u001c\b%\u0001\nuKN$h+\u00197jI2Kgn\u001b(b[\u0016\u001cH#\u0001*\u0011\u0005m\u001a\u0016B\u0001+=\u0005\u0011)f.\u001b;)\u0005\u00191\u0006CA,a\u001b\u0005A&BA-[\u0003\r\t\u0007/\u001b\u0006\u00037r\u000bqA[;qSR,'O\u0003\u0002^=\u0006)!.\u001e8ji*\tq,A\u0002pe\u001eL!!\u0019-\u0003\tQ+7\u000f^\u0001\u0015i\u0016\u001cH/\u00138wC2LG\rT5oW:\u000bW.Z:)\u0005\u001d1\u0016a\u0006;fgR4\u0016\r\\5eCR,W*\u001b:s_J\u0004&o\u001c9tQ\tAa+\u0001\u000fuKN$h+\u00197jI\u0006$X-T5se>\u0014\bK]8qg\u0016k\u0007\u000f^=)\u0005%1\u0016A\b;fgR4\u0016\r\\5eCR,\u0017J\u001c<bY&$W*\u001b:s_J\u0004&o\u001c9tQ\tQa+A\u0013uKN$h+\u00197jI\u0006$X-\u00138wC2LG-T5se>\u0014\bK]8qgNKhn\u001c8z[\"\u00121BV\u0001\u0014i\u0016\u001cH/\u00138ji6K'O]8s!J|\u0007o\u001d\u0015\u0003\u0019Y\u000ba\u0004^3ti&s\u0017\u000e^'jeJ|'\u000f\u0015:paNdunY1m\u00032<\u0018-_:)\u000551\u0016a\n;fgRLe.\u001b;NSJ\u0014xN\u001d)s_B\u001cXK\\6o_^t7i\u001c8gS\u001eLuM\\8sK\u0012D#A\u0004,\u0002+Q,7\u000f^+qI\u0006$X-T5se>\u0014\bK]8qg\"\u0012qBV\u0001*i\u0016\u001cH/\u00169eCR,W*\u001b:s_J\u0004&o\u001c9t+:\\gn\\<o\u0007>tg-[4JO:|'/\u001a3)\u0005A1\u0016A\b;fgR\u0014Vm]8mm\u0016\u001c%/Z1uKR{\u0007/[2Ti\u0006tG-\u0019:eQ\t\tb+\u0001\u000fuKN$(+Z:pYZ,7I]3bi\u0016l\u0015N\u001d:peR{\u0007/[2)\u0005I1\u0016A\t;fgR\u0014Vm]8mm\u0016\u001c%/Z1uK6K'O]8s)>\u0004\u0018nY#se>\u00148\u000f\u000b\u0002\u0014-\u0006aB/Z:u-\u0006d\u0017\u000eZ1uK\u000e\u0013X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001c\bF\u0001\u000bW\u0003)!Xm\u001d;GS2$XM\u001d\u0015\u0003+Y\u000bq\u0002^3ti\u001aKG\u000e^3s\u000fJ|W\u000f\u001d\u0015\u0003-Y\u000b!\u0003^3ti\u0012{g)\u001b7uKJ<%o\\;qg\"\u0012qCV\u0001&i\u0016\u001cHOR5mi\u0016\u0014xI]8vaR\u000b7.Z:V]&|gn\u00144U_BL7\rV=qKND#\u0001\u0007,\u0002#Q,7\u000f\u001e#z]\u0006l\u0017n\u0019'pO\u001e,'\u000f\u000b\u0002\u001a-\u0006\tC/Z:uSN\u0014un\u001c;tiJ\f\u0007oQ8oM2,XM\u001c;DY>,H\rS8ti\"\u0012!DV\u0001#i\u0016\u001cH/T1y\u0007J,\u0017\r^3DYV\u001cH/\u001a:MS:\\7\u000fV5nK>,H/T:)\u0005m1\u0016!\b;fgRL5/Q;uQ\u0016tG/[2bi&|g.\u0012=dKB$\u0018n\u001c8)\u0005q1\u0016AC7bW\u0016\u001cuN\u001c4jOR!\u0011\u0011EA\u001c!\u0011\t\u0019#a\r\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\tQ!\u00193nS:TA!a\u000b\u0002.\u000591\r\\5f]R\u001c(bA\u001c\u00020)\u0019\u0011\u0011\u00070\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t)$!\n\u0003\r\r{gNZ5h\u0011\u001d\tI$\ba\u0001\u0003w\tq!\u001a8ue&,7\u000f\u0005\u0004\u0002>\u00055\u00131\u000b\b\u0005\u0003\u007f\tIE\u0004\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)\u0005O\u0001\u0007yI|w\u000e\u001e \n\u0003uJ1!a\u0013=\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0014\u0002R\t\u00191+Z9\u000b\u0007\u0005-C\bE\u0005<\u0003+\nI&!\u0017\u0002j%\u0019\u0011q\u000b\u001f\u0003\rQ+\b\u000f\\34!\u0011\tY&a\u0019\u000f\t\u0005u\u0013q\f\t\u0004\u0003\u0003b\u0014bAA1y\u00051\u0001K]3eK\u001aLA!!\u001a\u0002h\t11\u000b\u001e:j]\u001eT1!!\u0019=!\rY\u00141N\u0005\u0004\u0003[b$a\u0002\"p_2,\u0017M\\\u0001Ii\u0016\u001cHoQ1o\u0011\u0006tG\r\\3EKN\u001c'/\u001b2f\u00072,8\u000f^3s\u0019&t7n\u001d*fcV,7\u000f\u001e*fiV\u0014hn]\"p_J$\u0017N\\1u_Jdu.\u00193J]B\u0013xn\u001a:fgND#A\b,\u0002{Q,7\u000f^\"b]\"\u000bg\u000e\u001a7f\t\u0016\u001c8M]5cK\u000ecWo\u001d;fe2Kgn[:SKF,Xm\u001d;SKR,(O\\:O_R\u001cun\u001c:eS:\fGo\u001c:)\u0005}1\u0016!\u000e;fgR\u001c\u0015M\u001c%b]\u0012dW\rR3tGJL'-Z\"mkN$XM\u001d'j].\u001c(+Z9vKN$\u0018j]\"p_J$\u0017N\\1u_JD#\u0001\t,\u0002uQ,7\u000f^\"b]\"\u000bg\u000e\u001a7f\t\u0016\u001c8M]5cK\u000ecWo\u001d;fe2Kgn[:MS:\\7i\\8sI&t\u0017\r^8s\u001d>$XI\\1cY\u0016$\u0007FA\u0011W\u00035#Xm\u001d;DC:D\u0015M\u001c3mK\u0012+7o\u0019:jE\u0016\u001cE.^:uKJd\u0015N\\6t%\u0016\fX/Z:u\u0013N\u001cun\u001c:eS:\fGo\u001c:XQ\u0016tgj\u001c'j].t\u0015-\\3t%\u0016\fX/Z:uK\u0012D#A\t,\u0002;R,7\u000f^\"b]\"\u000bg\u000e\u001a7f\t\u0016\u001c8M]5cK\u000ecWo\u001d;fe2Kgn[:SKF,Xm\u001d;SKR,(O\\:D_>\u0014H-\u001b8bi>\u0014Hj\\1e\u0013:\u0004&o\\4sKN\u001cx\u000b[3o\u001d>lU\r^1eCR\fW*\u00198bO\u0016\u0014\bFA\u0012W\u00039\"Xm\u001d;DC:D\u0015M\u001c3mK\u0012+7o\u0019:jE\u0016\u001cE.^:uKJd\u0015N\\6t\u001d>$8i\u001c8ue>dG.\u001a:)\u0005\u00112\u0016!\f;fgR\u001c\u0015M\u001c%b]\u0012dW\rR3tGJL'-Z\"mkN$XM\u001d'j].\u001c\u0018j]\"p]R\u0014x\u000e\u001c7fe\"\u0012QEV\u0001Di\u0016\u001cHoQ1o\u0011\u0006tG\r\\3EKN\u001c'/\u001b2f\u001b&\u0014(o\u001c:t%\u0016\fX/Z:u%\u0016$XO\u001d8t\u0007>|'\u000fZ5oCR|'\u000fT8bI&s\u0007K]8he\u0016\u001c8\u000f\u000b\u0002'-\u0006AD/Z:u\u0007\u0006t\u0007*\u00198eY\u0016$Um]2sS\n,W*\u001b:s_J\u001c(+Z9vKN$(+\u001a;ve:\u001chj\u001c;D_>\u0014H-\u001b8bi>\u0014\bFA\u0014W\u0003u#Xm\u001d;DC:D\u0015M\u001c3mK\u0012+7o\u0019:jE\u0016l\u0015N\u001d:peN\u0014V-];fgR\u0014V\r^;s]Ntu\u000e^\"p_J$\u0017N\\1u_J<\u0006.\u001a8O_R\fE\u000e\u001c+pa&\u001c7/\u0011:f\u001f^tW\r\u001a\"z\u0007>|'\u000fZ5oCR|'\u000f\u000b\u0002)-\u0006\u0001D/Z:u\u0007\u0006t\u0007*\u00198eY\u0016$Um]2sS\n,W*\u001b:s_J\u001c(+Z9vKN$\u0018j]\"p_J$\u0017N\\1u_JD#!\u000b,\u00021R,7\u000f^\"b]\"\u000bg\u000e\u001a7f\t\u0016\u001c8M]5cK6K'O]8sgJ+\u0017/^3tiJ+G/\u001e:og\u000e{wN\u001d3j]\u0006$xN\u001d'pC\u0012Le\u000e\u0015:pOJ,7o],iK:tu.T3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0015\u0003UY\u000b\u0011\u0006^3ti\u000e\u000bg\u000eS1oI2,G)Z:de&\u0014W-T5se>\u00148OT8u\u0007>tGO]8mY\u0016\u0014\bFA\u0016W\u0003!\"Xm\u001d;DC:D\u0015M\u001c3mK\u0012+7o\u0019:jE\u0016l\u0015N\u001d:peNL5oQ8oiJ|G\u000e\\3sQ\tac+A\ruKN$H)\u001e:bE&d\u0017\u000e^=Bk\u0012LGo\u0015;bi\u0016\u001c\bFA\u0017W\u0003]!Xm\u001d;UCN\\WI\u001d:pe\u000e{G-Z!oI6\u001bx\r\u000b\u0002/-\u0006qQ.Y6f!J|\u0007/\u001a:uS\u0016\u001cH\u0003BA\\\u0003\u000f\u0004B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,\u0001\u0003vi&d'BAAa\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00171\u0018\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA\u001d_\u0001\u0007\u0011\u0011\u001a\t\u0007\u0003{\ti%a3\u0011\u000fm\ni-!\u0017\u0002Z%\u0019\u0011q\u001a\u001f\u0003\rQ+\b\u000f\\33\u0003Ii\u0017m[3De\u0016\fG/\u00192mKR{\u0007/[2\u0015\u0015\u0005U\u0017Q^Ay\u0003w\u0014)\u0001\u0005\u0003\u0002X\u0006\u001dh\u0002BAm\u0003Gl!!a7\u000b\t\u0005u\u0017q\\\u0001\b[\u0016\u001c8/Y4f\u0015\u0011\t\t/!\f\u0002\r\r|W.\\8o\u0013\u0011\t)/a7\u0002/\r\u0013X-\u0019;f)>\u0004\u0018nY:SKF,Xm\u001d;ECR\f\u0017\u0002BAu\u0003W\u0014ab\u0011:fCR\f'\r\\3U_BL7M\u0003\u0003\u0002f\u0006m\u0007bBAxa\u0001\u0007\u0011\u0011L\u0001\u0005]\u0006lW\rC\u0004\u0002tB\u0002\r!!>\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t!\rY\u0014q_\u0005\u0004\u0003sd$aA%oi\"9\u0011Q \u0019A\u0002\u0005}\u0018\u0001\u00037j].t\u0015-\\3\u0011\u000bm\u0012\t!!\u0017\n\u0007\t\rAH\u0001\u0004PaRLwN\u001c\u0005\b\u0005\u000f\u0001\u0004\u0019AA\u0000\u0003-i\u0017N\u001d:peR{\u0007/[2")
public class ClusterLinkUtilsTest {
    private final ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)new Properties(null){
        {
            this.put("bootstrap.servers", "localhost:2345");
        }
    }, (Option)None$.MODULE$, true);
    private final MirrorTopicConfigSyncRules topicConfigSyncRules = this.linkConfig().topicConfigSyncRules();

    public ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    public MirrorTopicConfigSyncRules topicConfigSyncRules() {
        return this.topicConfigSyncRules;
    }

    @Test
    public void testValidLinkNames() {
        String assertValid$1_linkName = "ABCXYZ.abcxyz-0123456789_";
        ClusterLinkUtils.validateLinkNameOrThrow((String)assertValid$1_linkName);
        Object var1_1 = null;
        String assertValid$1_linkName2 = "...";
        ClusterLinkUtils.validateLinkNameOrThrow((String)assertValid$1_linkName2);
        Object var2_2 = null;
        String assertValid$1_linkName3 = "_.-";
        ClusterLinkUtils.validateLinkNameOrThrow((String)assertValid$1_linkName3);
        Object var3_3 = null;
        String assertValid$1_linkName4 = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0123456789"), 20);
        ClusterLinkUtils.validateLinkNameOrThrow((String)assertValid$1_linkName4);
    }

    @Test
    public void testInvalidLinkNames() {
        ClusterLinkUtilsTest.assertInvalid$1(null);
        ClusterLinkUtilsTest.assertInvalid$1("");
        ClusterLinkUtilsTest.assertInvalid$1(".");
        ClusterLinkUtilsTest.assertInvalid$1("..");
        ClusterLinkUtilsTest.assertInvalid$1("test/link");
        ClusterLinkUtilsTest.assertInvalid$1("test:link");
        ClusterLinkUtilsTest.assertInvalid$1("test\\link");
        ClusterLinkUtilsTest.assertInvalid$1("test\nlink");
        ClusterLinkUtilsTest.assertInvalid$1("test\tlink");
        ClusterLinkUtilsTest.assertInvalid$1(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0123456789"), 30));
    }

    @Test
    public void testValidateMirrorProps() {
        Properties props = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.downconversion.enable"), (Object)"true"), (List)Nil$.MODULE$));
        this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props);
    }

    @Test
    public void testValidateMirrorPropsEmpty() {
        this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", new Properties());
    }

    @Test
    public void testValidateInvalidMirrorProps() {
        Properties props = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props));
    }

    @Test
    public void testValidateInvalidMirrorPropsSynonym() {
        Properties props = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanupPolicyProp()), (Object)"compact"), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props));
    }

    @Test
    public void testInitMirrorProps() {
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"cleanup.policy", (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)"max.message.bytes", (Object)"10485760", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)"unclean.leader.election.enable", (Object)"true", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)"confluent.prefer.tier.fetch.ms", (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)"segment.ms", (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)"segment.bytes", (Object)"1048576", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))))));
        Properties localProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.downconversion.enable"), (Object)"true"), (List)Nil$.MODULE$));
        Properties newLocalProps = new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).initMirrorProps("test");
        Assertions.assertEquals((Object)this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.downconversion.enable"), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.message.bytes"), (Object)"10485760"), (List)Nil$.MODULE$)))), (Object)newLocalProps);
    }

    @Test
    public void testInitMirrorPropsLocalAlways() {
        Properties localProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> new MirrorTopicConfigsDelegate(localProps, this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())), this.topicConfigSyncRules()).initMirrorProps("test"));
    }

    @Test
    public void testInitMirrorPropsUnknownConfigIgnored() {
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"bad.config.key", (Object)"12345", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
        Properties localProps = new Properties();
        Assertions.assertTrue((boolean)new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).initMirrorProps("test").isEmpty());
    }

    @Test
    public void testUpdateMirrorProps() {
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"cleanup.policy", (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)"max.message.bytes", (Object)"10485760", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)"unclean.leader.election.enable", (Object)"true", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)"confluent.prefer.tier.fetch.ms", (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)"segment.ms", (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)"segment.bytes", (Object)"1048576", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))))));
        Properties localProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"delete"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.message.bytes"), (Object)"524288"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.downconversion.enable"), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unclean.leader.election.enable"), (Object)"false"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"200000"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"1048576"), (List)Nil$.MODULE$)))))));
        Properties expectedLocalProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.message.bytes"), (Object)"10485760"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.downconversion.enable"), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unclean.leader.election.enable"), (Object)"false"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"200000"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"1048576"), (List)Nil$.MODULE$)))))));
        Properties newLocalProps = new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).updateMirrorProps("test");
        Assertions.assertEquals((Object)expectedLocalProps, (Object)newLocalProps);
    }

    @Test
    public void testUpdateMirrorPropsUnknownConfigIgnored() {
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"bad.config.key", (Object)"12345", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
        Properties localProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"another.bad.config.key"), (Object)"23456"), (List)Nil$.MODULE$));
        Assertions.assertTrue((boolean)new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).updateMirrorProps("test").isEmpty());
    }

    @Test
    public void testResolveCreateTopicStandard() {
        Properties configs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unclean.leader.election.enable"), (Object)"true"), (List)Nil$.MODULE$));
        CreateTopicsRequestData.CreatableTopic topic = this.makeCreatableTopic("test-topic", 4, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        ClusterLinkUtils.ResolveCreateTopic result = ClusterLinkUtils$.MODULE$.resolveCreateTopic(topic, (Option)None$.MODULE$, configs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, "");
        Assertions.assertEquals((Object)configs, (Object)result.configs());
        Assertions.assertTrue((boolean)result.topicState().isEmpty());
        Assertions.assertEquals((int)-1, (int)result.numPartitions());
    }

    @Test
    public void testResolveCreateMirrorTopic() {
        Uuid linkId = Uuid.randomUuid();
        Properties configs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unclean.leader.election.enable"), (Object)"true"), (List)Nil$.MODULE$));
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"cleanup.policy", (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
        Properties expectedConfigs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unclean.leader.election.enable"), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), (List)Nil$.MODULE$)));
        ClusterLinkUtils.ResolveCreateTopic result1 = ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic("test-topic", -1, (Option<String>)new Some((Object)"link-name"), (Option<String>)new Some((Object)"test-topic")), (Option)new Some((Object)linkId), configs, true, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, "");
        Assertions.assertEquals((Object)configs, (Object)result1.configs());
        Assertions.assertTrue((boolean)result1.topicState().isEmpty());
        Assertions.assertEquals((int)-1, (int)result1.numPartitions());
        Node node = new Node(0, "localhost", 9092);
        java.util.List nodeList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)node, (List)Nil$.MODULE$)).asJava();
        .colon.colon partitionInfos = new .colon.colon((Object)new TopicPartitionInfo(0, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(1, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(2, node, nodeList, nodeList), (List)Nil$.MODULE$)));
        scala.collection.immutable.Set authorizedOperations = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ}));
        TopicDescription description = new TopicDescription("test-topic", false, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionInfos).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)authorizedOperations).asJava());
        CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
        future.complete(new ClusterLinkTopicInfo(description, remoteConfig, (Seq)package$.MODULE$.Seq().empty()));
        ClusterLinkUtils.ResolveCreateTopic result2 = ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic("test-topic", -1, (Option<String>)new Some((Object)"link-name"), (Option<String>)new Some((Object)"test-topic")), (Option)new Some((Object)linkId), configs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), "");
        Assertions.assertEquals((Object)expectedConfigs, (Object)result2.configs());
        Assertions.assertTrue((boolean)(result2.topicState().get() instanceof ClusterLinkTopicState.Mirror));
        Assertions.assertEquals((Object)"link-name", (Object)((ClusterLinkTopicState)result2.topicState().get()).linkName());
        Assertions.assertEquals((int)3, (int)result2.numPartitions());
    }

    @Test
    public void testResolveCreateMirrorTopicErrors() {
        String topic = "test-topic";
        String linkName = "link-name";
        Uuid linkId = Uuid.randomUuid();
        Properties validConfigs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unclean.leader.election.enable"), (Object)"true"), (List)Nil$.MODULE$));
        Properties invalidConfigs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), (List)Nil$.MODULE$));
        Node node = new Node(0, "localhost", 9092);
        java.util.List nodeList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)node, (List)Nil$.MODULE$)).asJava();
        .colon.colon partitionInfos = new .colon.colon((Object)new TopicPartitionInfo(0, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(1, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(2, node, nodeList, nodeList), (List)Nil$.MODULE$)));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)None$.MODULE$), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, 4, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)"different-topic")), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(UnsupportedVersionException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), invalidConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            CompletableFuture future = new CompletableFuture();
            return ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), "");
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally((Throwable)new TimeoutException("timeout"));
            return ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), "");
        }, ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        Assertions$.MODULE$.intercept(() -> ClusterLinkUtilsTest.$anonfun$testResolveCreateMirrorTopicErrors$9(this, (List)partitionInfos, topic, linkName, linkId, validConfigs), ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        Assertions.assertEquals((Object)((ClusterLinkNotFoundException)Assertions$.MODULE$.intercept(() -> ClusterLinkUtilsTest.$anonfun$testResolveCreateMirrorTopicErrors$10(this, (List)partitionInfos, topic, linkName, validConfigs), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297))).getMessage(), (Object)new StringBuilder(41).append("Cluster link with name '").append(linkName).append("' does not exist.").toString());
    }

    @Test
    public void testValidateCreatePartitions() {
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, true, (Option)None$.MODULE$);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, false, (Option)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 2, false, (Option)new Some((Object)future)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        future.complete(BoxesRunTime.boxToInteger((int)3));
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 2, false, (Option)new Some(future));
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, false, (Option)new Some(future));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 4, false, (Option)new Some((Object)future)), ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
    }

    @Test
    public void testFilter() {
        ClusterLinkFilterInfo fooLiteral = ClusterLinkUtilsTest.filterInfo$1("fooLiteral", PatternType.LITERAL, "include");
        ClusterLinkFilterInfo bar = ClusterLinkUtilsTest.filterInfo$1("bar", PatternType.PREFIXED, "include");
        ClusterLinkFilterInfo barExclude = ClusterLinkUtilsTest.filterInfo$1("barExclude", PatternType.PREFIXED, "exclude");
        ClusterLinkFilterInfo baz = ClusterLinkUtilsTest.filterInfo$1("baz", PatternType.PREFIXED, "include");
        ClusterLinkFilterInfo bazExclude = ClusterLinkUtilsTest.filterInfo$1("bazExclude", PatternType.LITERAL, "exclude");
        .colon.colon filters = new .colon.colon((Object)fooLiteral, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)barExclude, (List)new .colon.colon((Object)baz, (List)new .colon.colon((Object)bazExclude, (List)Nil$.MODULE$)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExcludeNot"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilterTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), (scala.collection.immutable.Seq)filters)._2()).toSet());
        scala.collection.immutable.Seq filters2 = (scala.collection.immutable.Seq)filters.$plus$plus((IterableOnce)new .colon.colon((Object)ClusterLinkUtilsTest.filterInfo$1("*", PatternType.LITERAL, "include"), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExcludeNot"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilterTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters2)._2()).toSet());
        scala.collection.immutable.Seq filters3 = (scala.collection.immutable.Seq)filters.$plus$plus((IterableOnce)new .colon.colon((Object)ClusterLinkUtilsTest.filterInfo$1("*", PatternType.LITERAL, "exclude"), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilterTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters3)._2()).toSet());
        Assertions.assertTrue((boolean)bar.matchesIncludeOrExclude("bar"));
        Assertions.assertTrue((boolean)bar.matchesIncludeOrExclude("barInclude"));
        Assertions.assertFalse((boolean)bar.matchesIncludeOrExclude("foo"));
        Assertions.assertTrue((boolean)barExclude.matchesIncludeOrExclude("barExclude"));
        Assertions.assertTrue((boolean)barExclude.matchesIncludeOrExclude("barExcluded"));
        Assertions.assertFalse((boolean)barExclude.matchesIncludeOrExclude("foo"));
    }

    @Test
    public void testFilterGroup() {
        scala.collection.immutable.Set allTopicTypes = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TopicType$.MODULE$.LOCAL_MIRROR(), TopicType$.MODULE$.REMOTE_MIRROR()}));
        GroupClusterLinkFilterInfo fooLiteral = ClusterLinkUtilsTest.filterInfo$2("fooLiteral", PatternType.LITERAL, "include", allTopicTypes);
        GroupClusterLinkFilterInfo bar = ClusterLinkUtilsTest.filterInfo$2("bar", PatternType.PREFIXED, "include", allTopicTypes);
        GroupClusterLinkFilterInfo barExclude = ClusterLinkUtilsTest.filterInfo$2("barExclude", PatternType.PREFIXED, "exclude", allTopicTypes);
        GroupClusterLinkFilterInfo baz = ClusterLinkUtilsTest.filterInfo$2("baz", PatternType.PREFIXED, "include", allTopicTypes);
        GroupClusterLinkFilterInfo bazExclude = ClusterLinkUtilsTest.filterInfo$2("bazExclude", PatternType.LITERAL, "exclude", allTopicTypes);
        .colon.colon filters = new .colon.colon((Object)fooLiteral, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)barExclude, (List)new .colon.colon((Object)baz, (List)new .colon.colon((Object)bazExclude, (List)Nil$.MODULE$)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$2(Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("fooLiteral", allTopicTypes)})), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("bar", allTopicTypes), new MatchedGroup("barred", allTopicTypes)})), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("baz", allTopicTypes), new MatchedGroup("bazExcludeNot", allTopicTypes)})), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral.filterInfo(), bar.filterInfo(), barExclude.filterInfo()})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), (scala.collection.immutable.Seq)filters)._2()).toSet());
        scala.collection.immutable.Seq filters2 = (scala.collection.immutable.Seq)filters.$plus$plus((IterableOnce)new .colon.colon((Object)ClusterLinkUtilsTest.filterInfo$2("*", PatternType.LITERAL, "include", allTopicTypes), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$2(Predef$.MODULE$.Set().empty(), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("fooLiteral", allTopicTypes), new MatchedGroup("abc", allTopicTypes)})), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("bar", allTopicTypes), new MatchedGroup("barred", allTopicTypes)})), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("baz", allTopicTypes), new MatchedGroup("bazExcludeNot", allTopicTypes)})), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral.filterInfo(), bar.filterInfo(), barExclude.filterInfo()})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters2)._2()).toSet());
        scala.collection.immutable.Seq filters3 = (scala.collection.immutable.Seq)filters.$plus$plus((IterableOnce)new .colon.colon((Object)ClusterLinkUtilsTest.filterInfo$2("*", PatternType.LITERAL, "exclude", allTopicTypes), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$2(Predef$.MODULE$.Set().empty(), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral.filterInfo(), bar.filterInfo(), barExclude.filterInfo()})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters3)._2()).toSet());
        Assertions.assertTrue((boolean)bar.filterInfo().matchesIncludeOrExclude("bar"));
        Assertions.assertTrue((boolean)bar.filterInfo().matchesIncludeOrExclude("barInclude"));
        Assertions.assertFalse((boolean)bar.filterInfo().matchesIncludeOrExclude("foo"));
        Assertions.assertTrue((boolean)barExclude.filterInfo().matchesIncludeOrExclude("barExclude"));
        Assertions.assertTrue((boolean)barExclude.filterInfo().matchesIncludeOrExclude("barExcluded"));
        Assertions.assertFalse((boolean)barExclude.filterInfo().matchesIncludeOrExclude("foo"));
    }

    @Test
    public void testDoFilterGroups() {
        .colon.colon allTopicTypeStrs = new .colon.colon((Object)"LOCAL_MIRROR", (List)new .colon.colon((Object)"REMOTE_MIRROR", (List)Nil$.MODULE$));
        GroupFilterJson literalFilter = new GroupFilterJson((scala.collection.immutable.Seq)new .colon.colon((Object)new GroupClusterLinkFilter("foo", PatternType.LITERAL.name(), "INCLUDE", (scala.collection.immutable.Seq)allTopicTypeStrs), (List)Nil$.MODULE$));
        GroupFilterJson prefixFilter = new GroupFilterJson((scala.collection.immutable.Seq)new .colon.colon((Object)new GroupClusterLinkFilter("f", PatternType.PREFIXED.name(), "INCLUDE", (scala.collection.immutable.Seq)allTopicTypeStrs), (List)Nil$.MODULE$));
        GroupFilterJson starFilter = new GroupFilterJson((scala.collection.immutable.Seq)new .colon.colon((Object)new GroupClusterLinkFilter("*", PatternType.LITERAL.name(), "INCLUDE", (scala.collection.immutable.Seq)allTopicTypeStrs), (List)Nil$.MODULE$));
        .colon.colon allTopicTypes = new .colon.colon((Object)TopicType$.MODULE$.LOCAL_MIRROR(), (List)new .colon.colon((Object)TopicType$.MODULE$.REMOTE_MIRROR(), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("lkc-123_east_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"lkc-123_east_foo"})), (Option)new Some((Object)literalFilter), (Option)new Some((Object)"lkc-123_"), (Option)new Some((Object)"east_"), ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("lkc-123_east_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"lkc-123_east_foo"})), (Option)new Some((Object)prefixFilter), (Option)new Some((Object)"lkc-123_"), (Option)new Some((Object)"east_"), ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("lkc-123_east_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"lkc-123_east_foo"})), (Option)new Some((Object)starFilter), (Option)new Some((Object)"lkc-123_"), (Option)new Some((Object)"east_"), ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("east_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"east_foo"})), (Option)new Some((Object)literalFilter), (Option)None$.MODULE$, (Option)new Some((Object)"east_"), ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("east_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"east_foo"})), (Option)new Some((Object)prefixFilter), (Option)None$.MODULE$, (Option)new Some((Object)"east_"), ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("east_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"east_foo"})), (Option)new Some((Object)starFilter), (Option)None$.MODULE$, (Option)new Some((Object)"east_"), ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("lkc-123_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"lkc-123_foo"})), (Option)new Some((Object)literalFilter), (Option)new Some((Object)"lkc-123_"), (Option)None$.MODULE$, ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("lkc-123_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"lkc-123_foo"})), (Option)new Some((Object)prefixFilter), (Option)new Some((Object)"lkc-123_"), (Option)None$.MODULE$, ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("lkc-123_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"lkc-123_foo"})), (Option)new Some((Object)starFilter), (Option)new Some((Object)"lkc-123_"), (Option)None$.MODULE$, ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Option)new Some((Object)literalFilter), (Option)None$.MODULE$, (Option)None$.MODULE$, ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Option)new Some((Object)prefixFilter), (Option)None$.MODULE$, (Option)None$.MODULE$, ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Option)new Some((Object)starFilter), (Option)None$.MODULE$, (Option)None$.MODULE$, ClusterLinkConfig.LinkMode.DESTINATION)._1());
    }

    @Test
    public void testFilterGroupTakesUnionOfTopicTypes() {
        scala.collection.immutable.Set allTopicTypes = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TopicType$.MODULE$.LOCAL_MIRROR(), TopicType$.MODULE$.REMOTE_MIRROR()}));
        scala.collection.immutable.Set localOnlyTopicType = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TopicType$.MODULE$.LOCAL_MIRROR()}));
        scala.collection.immutable.Set remoteOnlyTopicType = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TopicType$.MODULE$.REMOTE_MIRROR()}));
        GroupClusterLinkFilterInfo fooLiteral = ClusterLinkUtilsTest.filterInfo$3("fooLiteral", PatternType.LITERAL, "include", localOnlyTopicType);
        GroupClusterLinkFilterInfo fooPrefixed = ClusterLinkUtilsTest.filterInfo$3("foo", PatternType.PREFIXED, "include", remoteOnlyTopicType);
        GroupClusterLinkFilterInfo baz = ClusterLinkUtilsTest.filterInfo$3("baz", PatternType.PREFIXED, "include", allTopicTypes);
        GroupClusterLinkFilterInfo bar = ClusterLinkUtilsTest.filterInfo$3("bar", PatternType.PREFIXED, "include", localOnlyTopicType);
        GroupClusterLinkFilterInfo bat = ClusterLinkUtilsTest.filterInfo$3("bat", PatternType.PREFIXED, "include", remoteOnlyTopicType);
        .colon.colon filters = new .colon.colon((Object)fooLiteral, (List)new .colon.colon((Object)fooPrefixed, (List)new .colon.colon((Object)baz, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)bat, (List)Nil$.MODULE$)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("fooLiteral", allTopicTypes), new MatchedGroup("baz", allTopicTypes), new MatchedGroup("bar", localOnlyTopicType), new MatchedGroup("foo", remoteOnlyTopicType)})), (Object)ClusterLinkUtilsTest.filter$3((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "baz", "bar", "foo"})), (scala.collection.immutable.Seq)filters));
        GroupClusterLinkFilterInfo fooLiteralAllTopicTypes = ClusterLinkUtilsTest.filterInfo$3("fooLiteral", PatternType.LITERAL, "include", allTopicTypes);
        GroupClusterLinkFilterInfo fooPrefixedExcludesRemote = ClusterLinkUtilsTest.filterInfo$3("foo", PatternType.PREFIXED, "exclude", remoteOnlyTopicType);
        .colon.colon filtersWithExcludingRemote = new .colon.colon((Object)fooLiteralAllTopicTypes, (List)new .colon.colon((Object)fooPrefixedExcludesRemote, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("fooLiteral", localOnlyTopicType)})), (Object)ClusterLinkUtilsTest.filter$3((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral"})), (scala.collection.immutable.Seq)filtersWithExcludingRemote));
        GroupClusterLinkFilterInfo fooPrefixedExcludesLocal = ClusterLinkUtilsTest.filterInfo$3("foo", PatternType.PREFIXED, "exclude", localOnlyTopicType);
        .colon.colon filtersWithExcludingLocal = new .colon.colon((Object)fooLiteralAllTopicTypes, (List)new .colon.colon((Object)fooPrefixedExcludesLocal, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("fooLiteral", remoteOnlyTopicType)})), (Object)ClusterLinkUtilsTest.filter$3((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral"})), (scala.collection.immutable.Seq)filtersWithExcludingLocal));
    }

    @Test
    public void testDynamicLogger() {
        RuntimeException e1 = new RuntimeException("runtime exception");
        IllegalStateException e2 = new IllegalStateException("illegal state");
        IllegalArgumentException e3 = new IllegalArgumentException("illegal arg");
        .colon.colon exceptions = new .colon.colon((Object)e1, (List)new .colon.colon((Object)e2, (List)new .colon.colon((Object)e3, (List)Nil$.MODULE$)));
        scala.collection.mutable.Map errorCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map debugCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map warnCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Logging logging = new Logging(null, errorCounts, debugCounts, warnCounts){
            private Logger logger;
            private String logIdent;
            private volatile boolean bitmap$0;
            private final scala.collection.mutable.Map errorCounts$1;
            private final scala.collection.mutable.Map debugCounts$1;
            private final scala.collection.mutable.Map warnCounts$1;

            public String loggerName() {
                return Logging.loggerName$((Logging)this);
            }

            public String msgWithLogIdent(String msg) {
                return Logging.msgWithLogIdent$((Logging)this, (String)msg);
            }

            public void trace(Function0<String> msg) {
                Logging.trace$((Logging)this, msg);
            }

            public void trace(Function0<String> msg, Function0<Throwable> e) {
                Logging.trace$((Logging)this, msg, e);
            }

            public boolean isDebugEnabled() {
                return Logging.isDebugEnabled$((Logging)this);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void debug(Function0<String> msg) {
                Logging.debug$((Logging)this, msg);
            }

            public void info(Function0<String> msg) {
                Logging.info$((Logging)this, msg);
            }

            public void info(Function0<String> msg, Function0<Throwable> e) {
                Logging.info$((Logging)this, msg, e);
            }

            public void warn(Function0<String> msg) {
                Logging.warn$((Logging)this, msg);
            }

            public void error(Function0<String> msg) {
                Logging.error$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg) {
                Logging.fatal$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg, Function0<Throwable> e) {
                Logging.fatal$((Logging)this, msg, e);
            }

            private Logger logger$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.logger = Logging.logger$((Logging)this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                if (!this.bitmap$0) {
                    return this.logger$lzycompute();
                }
                return this.logger;
            }

            public String logIdent() {
                return this.logIdent;
            }

            public void logIdent_$eq(String x$1) {
                this.logIdent = x$1;
            }

            public void error(Function0<String> msg, Function0<Throwable> e) {
                Class<?> clazz = e.apply().getClass();
                this.errorCounts$1.update(clazz, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.errorCounts$1.apply(clazz)) + 1)));
                if (this.logger().underlying().isErrorEnabled()) {
                    String msgWithLogIdent_msg = (String)msg.apply();
                    Object var4_4 = null;
                    this.logger().underlying().error(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg), (Throwable)e.apply());
                    return;
                }
            }

            public void debug(Function0<String> msg, Function0<Throwable> e) {
                Class<?> clazz = e.apply().getClass();
                this.debugCounts$1.update(clazz, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.debugCounts$1.apply(clazz)) + 1)));
                if (this.logger().underlying().isDebugEnabled()) {
                    String msgWithLogIdent_msg = (String)msg.apply();
                    Object var4_4 = null;
                    this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg), (Throwable)e.apply());
                    return;
                }
            }

            public void warn(Function0<String> msg, Function0<Throwable> e) {
                Class<?> clazz = e.apply().getClass();
                this.warnCounts$1.update(clazz, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.warnCounts$1.apply(clazz)) + 1)));
                if (this.logger().underlying().isDebugEnabled()) {
                    String msgWithLogIdent_msg = (String)msg.apply();
                    Object var4_4 = null;
                    this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg), (Throwable)e.apply());
                    return;
                }
            }
            {
                this.errorCounts$1 = errorCounts$1;
                this.debugCounts$1 = debugCounts$1;
                this.warnCounts$1 = warnCounts$1;
            }
        };
        ClusterLinkDynamicLogger dynamicLogger = new ClusterLinkDynamicLogger(logging, 4, 2, 50);
        ClusterLinkUtilsTest.clearCounts$1((scala.collection.immutable.Seq)exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> ClusterLinkUtilsTest.$anonfun$testDynamicLogger$2(dynamicLogger, e1, errorCounts, warnCounts, debugCounts, (scala.collection.immutable.Seq)exceptions, arg_0)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> ClusterLinkUtilsTest.$anonfun$testDynamicLogger$4(dynamicLogger, e1, e2, errorCounts, warnCounts, debugCounts, (scala.collection.immutable.Seq)exceptions, arg_0)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> dynamicLogger.error(new StringBuilder(5).append("test ").append(i).toString(), (Throwable)e1));
        ClusterLinkUtilsTest.verifyCounts$1(e1, 10, 0, 0, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.clearCounts$1((scala.collection.immutable.Seq)exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> dynamicLogger.error("test", (Throwable)new RuntimeException(new StringBuilder(5).append("test ").append(i).toString(), e1)));
        ClusterLinkUtilsTest.verifyCounts$1(e1, 10, 0, 0, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.clearCounts$1((scala.collection.immutable.Seq)exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int n = i % 3;
            switch (n) {
                case 0: {
                    dynamicLogger.error("test", (Throwable)e1);
                    return;
                }
                case 1: {
                    dynamicLogger.error("test", (Throwable)e2);
                    return;
                }
                case 2: {
                    dynamicLogger.error("test", (Throwable)e3);
                    return;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        });
        exceptions.foreach((Function1 & Serializable)e -> {
            ClusterLinkUtilsTest.verifyCounts$1(e, 10, 0, 0, errorCounts, warnCounts, debugCounts, dynamicLogger);
            return BoxedUnit.UNIT;
        });
        dynamicLogger.resetErrors();
        ClusterLinkUtilsTest.clearCounts$1((scala.collection.immutable.Seq)exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> dynamicLogger.error(e1.getMessage(), (Throwable)e1));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> dynamicLogger.error(e2.getMessage(), (Throwable)e2));
        ClusterLinkUtilsTest.verifyCounts$1(e1, 4, 2, 94, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.verifyCounts$1(e2, 4, 4, 192, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.clearCounts$1((scala.collection.immutable.Seq)exceptions, errorCounts, debugCounts, warnCounts);
    }

    @Test
    public void testisBootstrapConfluentCloudHost() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig brokerConfigs = KafkaConfig$.MODULE$.fromProps(props);
        Assertions.assertFalse((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("localhost:2345")));
        Assertions.assertFalse((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("PLAINTEXT://:2345")));
        Assertions.assertFalse((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("localhost:2345,test.stag.cpdev.cloud:9002")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("test.stag.cpdev.cloud:9002")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("test.devel.cpdev.cloud:9003")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("foo.bar.us-west2.aws.confluent.cloud:9003")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("foo.bar.us-west2.aws.confluent.cloud:9003,foo.bar.us-east2.aws.confluent.cloud:9003")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("SASL_PLAINTEXT://foo.bar.us-west2.aws.confluent.cloud:9003")));
    }

    @Test
    public void testMaxCreateClusterLinksTimeoutMs() {
        int fiveMins = 300000;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkUtils$.MODULE$.checkTimeoutMs(fiveMins));
        InvalidRequestException exception = new InvalidRequestException("Timeout of 300001(ms) is above maximum allowed of 300000(ms).");
        Option actual = ClusterLinkUtils$.MODULE$.checkTimeoutMs(fiveMins + 1);
        Assertions.assertTrue((boolean)actual.isDefined());
        Assertions.assertEquals((Object)exception.getMessage(), (Object)((Throwable)actual.get()).getMessage());
    }

    @Test
    public void testIsAuthenticationException() {
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isAuthenticationException((KafkaException)new AuthenticationException("Auth issue")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isAuthenticationException(new KafkaException((Throwable)new AuthenticationException("Auth issue"))));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isAuthenticationException((KafkaException)new SaslAuthenticationException("Auth issue")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isAuthenticationException(new KafkaException((Throwable)new SaslAuthenticationException("Auth issue"))));
        Assertions.assertFalse((boolean)ClusterLinkUtils$.MODULE$.isAuthenticationException((KafkaException)new TimeoutException("Timeout")));
    }

    private Config makeConfig(scala.collection.immutable.Seq<Tuple3<String, String, Object>> entries) {
        scala.collection.immutable.Seq configEntries = (scala.collection.immutable.Seq)entries.map((Function1 & Serializable)entry -> {
            ConfigEntry.ConfigSource source = BoxesRunTime.unboxToBoolean((Object)entry._3()) ? ConfigEntry.ConfigSource.DEFAULT_CONFIG : ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG;
            return new ConfigEntry((String)entry._1(), (String)entry._2(), source, false, false, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava(), ConfigEntry.ConfigType.UNKNOWN, null);
        });
        return new Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)configEntries).asJavaCollection());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCanHandleDescribeClusterLinksRequestReturnsCoordinatorLoadInProgress() {
        void var8_8;
        MetadataSupport metadataSupport = (MetadataSupport)Mockito.mock(MetadataSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        ClusterLinkFactory.AdminManager adminManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        ClusterLinkFactory.LinkManager linkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
        Mockito.when((Object)adminManager.clusterLinkManager()).thenReturn((Object)linkManager);
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)linkManager.clusterLinkMetadataManager()).thenReturn((Object)new Some((Object)metadataManager));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorInitialized())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Some linkNames = new Some(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"link-1"})));
        Tuple2 tuple2 = ClusterLinkUtils$.MODULE$.canHandleDescribeClusterLinksRequest((short)4, metadataSupport, config, adminManager, (Option)linkNames);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option errors = (Option)tuple2._1();
        Assertions.assertEquals((Object)new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS), (Object)var8_8);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCanHandleDescribeClusterLinksRequestReturnsNotCoordinator() {
        void var9_9;
        MetadataSupport metadataSupport = (MetadataSupport)Mockito.mock(MetadataSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        ClusterLinkFactory.AdminManager adminManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        ClusterLinkFactory.LinkManager linkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
        Mockito.when((Object)adminManager.clusterLinkManager()).thenReturn((Object)linkManager);
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)linkManager.clusterLinkMetadataManager()).thenReturn((Object)new Some((Object)metadataManager));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorInitialized())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        String link = "link-1";
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinator(link))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Some linkNames = new Some(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{link})));
        Tuple2 tuple2 = ClusterLinkUtils$.MODULE$.canHandleDescribeClusterLinksRequest((short)4, metadataSupport, config, adminManager, (Option)linkNames);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option errors = (Option)tuple2._1();
        Assertions.assertEquals((Object)new Some((Object)Errors.NOT_COORDINATOR), (Object)var9_9);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCanHandleDescribeClusterLinksRequestIsCoordinator() {
        void var9_9;
        MetadataSupport metadataSupport = (MetadataSupport)Mockito.mock(MetadataSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        ClusterLinkFactory.AdminManager adminManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        ClusterLinkFactory.LinkManager linkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
        Mockito.when((Object)adminManager.clusterLinkManager()).thenReturn((Object)linkManager);
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)linkManager.clusterLinkMetadataManager()).thenReturn((Object)new Some((Object)metadataManager));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorInitialized())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        String link = "link-1";
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinator(link))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Some linkNames = new Some(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{link})));
        Tuple2 tuple2 = ClusterLinkUtils$.MODULE$.canHandleDescribeClusterLinksRequest((short)4, metadataSupport, config, adminManager, (Option)linkNames);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option errors = (Option)tuple2._1();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)var9_9);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCanHandleDescribeClusterLinksLinkCoordinatorNotEnabled() {
        void var9_9;
        MetadataSupport metadataSupport = (MetadataSupport)Mockito.mock(MetadataSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        ClusterLinkFactory.AdminManager adminManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        ClusterLinkFactory.LinkManager linkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
        Mockito.when((Object)adminManager.clusterLinkManager()).thenReturn((Object)linkManager);
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)linkManager.clusterLinkMetadataManager()).thenReturn((Object)new Some((Object)metadataManager));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        String link = "link-1";
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinator(link))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Some linkNames = new Some(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{link})));
        Tuple2 tuple2 = ClusterLinkUtils$.MODULE$.canHandleDescribeClusterLinksRequest((short)4, metadataSupport, config, adminManager, (Option)linkNames);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option errors = (Option)tuple2._1();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)var9_9);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCanHandleDescribeClusterLinksRequestIsCoordinatorWhenNoLinkNamesRequested() {
        void var7_7;
        MetadataSupport metadataSupport = (MetadataSupport)Mockito.mock(MetadataSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        ClusterLinkFactory.AdminManager adminManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        ClusterLinkFactory.LinkManager linkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
        Mockito.when((Object)adminManager.clusterLinkManager()).thenReturn((Object)linkManager);
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)linkManager.clusterLinkMetadataManager()).thenReturn((Object)new Some((Object)metadataManager));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorInitialized())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Tuple2 tuple2 = ClusterLinkUtils$.MODULE$.canHandleDescribeClusterLinksRequest((short)4, metadataSupport, config, adminManager, (Option)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option errors = (Option)tuple2._1();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)var7_7);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCanHandleDescribeClusterLinksRequestReturnsCoordinatorLoadInProgressWhenNoMetadataManager() {
        void var7_7;
        MetadataSupport metadataSupport = (MetadataSupport)Mockito.mock(MetadataSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        ClusterLinkFactory.AdminManager adminManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        ClusterLinkFactory.LinkManager linkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
        Mockito.when((Object)adminManager.clusterLinkManager()).thenReturn((Object)linkManager);
        Mockito.when((Object)linkManager.clusterLinkMetadataManager()).thenReturn((Object)None$.MODULE$);
        Some linkNames = new Some(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"link-1"})));
        Tuple2 tuple2 = ClusterLinkUtils$.MODULE$.canHandleDescribeClusterLinksRequest((short)4, metadataSupport, config, adminManager, (Option)linkNames);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option errors = (Option)tuple2._1();
        Assertions.assertEquals((Object)new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS), (Object)var7_7);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCanHandleDescribeClusterLinksNotController() {
        void var6_6;
        ZkSupport metadataSupport = (ZkSupport)Mockito.mock(ZkSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)config.migrationEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
        Mockito.when((Object)metadataSupport.controller()).thenReturn((Object)controller);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)controller.isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ClusterLinkFactory.AdminManager linkManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        Tuple2 tuple2 = ClusterLinkUtils$.MODULE$.canHandleDescribeClusterLinksRequest((short)3, (MetadataSupport)metadataSupport, config, linkManager, (Option)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option errors = (Option)tuple2._1();
        Assertions.assertEquals((Object)new Some((Object)Errors.NOT_CONTROLLER), (Object)var6_6);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCanHandleDescribeClusterLinksIsController() {
        void var6_6;
        ZkSupport metadataSupport = (ZkSupport)Mockito.mock(ZkSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)config.migrationEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
        Mockito.when((Object)metadataSupport.controller()).thenReturn((Object)controller);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)controller.isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ClusterLinkFactory.AdminManager linkManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        Tuple2 tuple2 = ClusterLinkUtils$.MODULE$.canHandleDescribeClusterLinksRequest((short)3, (MetadataSupport)metadataSupport, config, linkManager, (Option)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option errors = (Option)tuple2._1();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)var6_6);
    }

    @Test
    public void testCanHandleDescribeMirrorsRequestReturnsCoordinatorLoadInProgress() {
        MetadataSupport metadataSupport = (MetadataSupport)Mockito.mock(MetadataSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        ClusterLinkFactory.AdminManager adminManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        ClusterLinkFactory.LinkManager linkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
        Mockito.when((Object)adminManager.clusterLinkManager()).thenReturn((Object)linkManager);
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)linkManager.clusterLinkMetadataManager()).thenReturn((Object)new Some((Object)metadataManager));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorInitialized())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        scala.collection.immutable.Set topics = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic-1"}));
        Option errors = ClusterLinkUtils$.MODULE$.canHandleDescribeMirrorsRequest(true, metadataSupport, config, adminManager, topics);
        Assertions.assertEquals((Object)new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS), (Object)errors);
    }

    @Test
    public void testCanHandleDescribeMirrorsRequestReturnsNotCoordinator() {
        MetadataSupport metadataSupport = (MetadataSupport)Mockito.mock(MetadataSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        ClusterLinkFactory.AdminManager adminManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        ClusterLinkFactory.LinkManager linkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
        Mockito.when((Object)adminManager.clusterLinkManager()).thenReturn((Object)linkManager);
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)linkManager.clusterLinkMetadataManager()).thenReturn((Object)new Some((Object)metadataManager));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorInitialized())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        String topic = "topic-1";
        scala.collection.immutable.Set topics = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorForMirrorTopic(topic))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Option errors = ClusterLinkUtils$.MODULE$.canHandleDescribeMirrorsRequest(true, metadataSupport, config, adminManager, topics);
        Assertions.assertEquals((Object)new Some((Object)Errors.NOT_COORDINATOR), (Object)errors);
    }

    @Test
    public void testCanHandleDescribeMirrorsRequestReturnsNotCoordinatorWhenNotAllTopicsAreOwnedByCoordinator() {
        MetadataSupport metadataSupport = (MetadataSupport)Mockito.mock(MetadataSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        ClusterLinkFactory.AdminManager adminManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        ClusterLinkFactory.LinkManager linkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
        Mockito.when((Object)adminManager.clusterLinkManager()).thenReturn((Object)linkManager);
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)linkManager.clusterLinkMetadataManager()).thenReturn((Object)new Some((Object)metadataManager));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorInitialized())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        String topic = "topic-1";
        String topicTwo = "topic-2";
        scala.collection.immutable.Set topics = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic, topicTwo}));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorForMirrorTopic(topic))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorForMirrorTopic(topicTwo))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Option errors = ClusterLinkUtils$.MODULE$.canHandleDescribeMirrorsRequest(true, metadataSupport, config, adminManager, topics);
        Assertions.assertEquals((Object)new Some((Object)Errors.NOT_COORDINATOR), (Object)errors);
    }

    @Test
    public void testCanHandleDescribeMirrorsRequestIsCoordinator() {
        MetadataSupport metadataSupport = (MetadataSupport)Mockito.mock(MetadataSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        ClusterLinkFactory.AdminManager adminManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        ClusterLinkFactory.LinkManager linkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
        Mockito.when((Object)adminManager.clusterLinkManager()).thenReturn((Object)linkManager);
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)linkManager.clusterLinkMetadataManager()).thenReturn((Object)new Some((Object)metadataManager));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorInitialized())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        String topic = "topic-1";
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataManager.isLinkCoordinatorForMirrorTopic(topic))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        scala.collection.immutable.Set topics = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        Option errors = ClusterLinkUtils$.MODULE$.canHandleDescribeMirrorsRequest(true, metadataSupport, config, adminManager, topics);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)errors);
    }

    @Test
    public void testCanHandleDescribeMirrorsRequestReturnsCoordinatorLoadInProgressWhenNoMetadataManager() {
        MetadataSupport metadataSupport = (MetadataSupport)Mockito.mock(MetadataSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        ClusterLinkFactory.AdminManager adminManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        ClusterLinkFactory.LinkManager linkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
        Mockito.when((Object)adminManager.clusterLinkManager()).thenReturn((Object)linkManager);
        Mockito.when((Object)linkManager.clusterLinkMetadataManager()).thenReturn((Object)None$.MODULE$);
        scala.collection.immutable.Set topics = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic-1"}));
        Option errors = ClusterLinkUtils$.MODULE$.canHandleDescribeMirrorsRequest(true, metadataSupport, config, adminManager, topics);
        Assertions.assertEquals((Object)new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS), (Object)errors);
    }

    @Test
    public void testCanHandleDescribeMirrorsNotController() {
        ZkSupport metadataSupport = (ZkSupport)Mockito.mock(ZkSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)config.migrationEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
        Mockito.when((Object)metadataSupport.controller()).thenReturn((Object)controller);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)controller.isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ClusterLinkFactory.AdminManager linkManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        Option errors = ClusterLinkUtils$.MODULE$.canHandleDescribeMirrorsRequest(false, (MetadataSupport)metadataSupport, config, linkManager, Predef$.MODULE$.Set().empty());
        Assertions.assertEquals((Object)new Some((Object)Errors.NOT_CONTROLLER), (Object)errors);
    }

    @Test
    public void testCanHandleDescribeMirrorsIsController() {
        ZkSupport metadataSupport = (ZkSupport)Mockito.mock(ZkSupport.class);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)config.migrationEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
        Mockito.when((Object)metadataSupport.controller()).thenReturn((Object)controller);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)controller.isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ClusterLinkFactory.AdminManager linkManager = (ClusterLinkFactory.AdminManager)Mockito.mock(ClusterLinkFactory.AdminManager.class);
        Option errors = ClusterLinkUtils$.MODULE$.canHandleDescribeMirrorsRequest(false, (MetadataSupport)metadataSupport, config, linkManager, Predef$.MODULE$.Set().empty());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)errors);
    }

    @Test
    public void testDurabilityAuditStates() {
        scala.collection.immutable.Set expectedStates = Predef$.MODULE$.wrapRefArray((Object[])MirrorTopic.State.values()).toSet();
        scala.collection.immutable.Set daStates = CollectionConverters$.MODULE$.ListHasAsScala(DurabilityAuditMirrorState.STATES).asScala().toSet();
        Assertions.assertEquals((Object)expectedStates.map((Function1 & Serializable)x$6 -> x$6.stateName()), (Object)daStates.map((Function1 & Serializable)x$7 -> x$7.getName()));
    }

    @Test
    public void testTaskErrorCodeAndMsg() {
        ExecutionException ex = new ExecutionException((Throwable)new SaslAuthenticationException(""));
        TaskErrorCodeAndMsg err = ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg("My task failed", true, ex);
        Assertions.assertEquals((Object)BrokerAuthenticationTaskErrorCode$.MODULE$, (Object)err.code());
        Assertions.assertEquals((Object)"My task failed due to authentication issues.", (Object)err.msg());
        err = ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg("My task failed", false, ex);
        Assertions.assertEquals((Object)AuthenticationTaskErrorCode$.MODULE$, (Object)err.code());
        Assertions.assertEquals((Object)"My task failed due to authentication issues.", (Object)err.msg());
        ex = new ExecutionException((Throwable)new TopicAuthorizationException(""));
        err = ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg("My task failed", true, ex);
        Assertions.assertEquals((Object)BrokerAuthorizationTaskErrorCode$.MODULE$, (Object)err.code());
        Assertions.assertEquals((Object)"My task failed due to authorization issues.", (Object)err.msg());
        err = ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg("My task failed", false, ex);
        Assertions.assertEquals((Object)AuthorizationTaskErrorCode$.MODULE$, (Object)err.code());
        Assertions.assertEquals((Object)"My task failed due to authorization issues.", (Object)err.msg());
        ex = new ExecutionException((Throwable)new TimeoutException(""));
        err = ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg("My task failed", true, ex);
        Assertions.assertEquals((Object)InternalTaskErrorCode$.MODULE$, (Object)err.code());
        Assertions.assertEquals((Object)"My task failed for an unknown reason.", (Object)err.msg());
        err = ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg("My task failed", false, ex);
        Assertions.assertEquals((Object)InternalTaskErrorCode$.MODULE$, (Object)err.code());
        Assertions.assertEquals((Object)"My task failed for an unknown reason.", (Object)err.msg());
    }

    private Properties makeProperties(scala.collection.immutable.Seq<Tuple2<String, String>> entries) {
        Properties props = new Properties();
        entries.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                String value = (String)x0$1._2();
                return props.put(name, value);
            }
            throw new MatchError(null);
        });
        return props;
    }

    private CreateTopicsRequestData.CreatableTopic makeCreatableTopic(String name, int numPartitions, Option<String> linkName, Option<String> mirrorTopic) {
        return new CreateTopicsRequestData.CreatableTopic().setName(name).setNumPartitions(numPartitions).setReplicationFactor((short)3).setLinkName((String)linkName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setMirrorTopic((String)mirrorTopic.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private static final void assertValid$1(String linkName) {
        ClusterLinkUtils.validateLinkNameOrThrow((String)linkName);
    }

    private static final void assertInvalid$1(String linkName) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ClusterLinkUtils$.MODULE$.validateLinkName(linkName), ClassTag$.MODULE$.apply(InvalidClusterLinkException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
    }

    public static final /* synthetic */ ClusterLinkUtils.ResolveCreateTopic $anonfun$testResolveCreateMirrorTopicErrors$9(ClusterLinkUtilsTest $this, List partitionInfos$1, String topic$1, String linkName$2, Uuid linkId$1, Properties validConfigs$1) {
        TopicDescription description = new TopicDescription("test-topic", false, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionInfos$1).asJava());
        CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
        future.complete(new ClusterLinkTopicInfo(description, $this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())), (Seq)package$.MODULE$.Seq().empty()));
        return ClusterLinkUtils$.MODULE$.resolveCreateTopic($this.makeCreatableTopic(topic$1, -1, (Option<String>)new Some((Object)linkName$2), (Option<String>)new Some((Object)topic$1)), (Option)new Some((Object)linkId$1), validConfigs$1, false, (Option)new Some((Object)$this.linkConfig()), (Option)new Some(future), "");
    }

    public static final /* synthetic */ ClusterLinkUtils.ResolveCreateTopic $anonfun$testResolveCreateMirrorTopicErrors$10(ClusterLinkUtilsTest $this, List partitionInfos$1, String topic$1, String linkName$2, Properties validConfigs$1) {
        scala.collection.immutable.Set authorizedOperations = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ}));
        TopicDescription description = new TopicDescription("test-topic", false, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionInfos$1).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)authorizedOperations).asJava());
        CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
        future.complete(new ClusterLinkTopicInfo(description, $this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())), (Seq)package$.MODULE$.Seq().empty()));
        return ClusterLinkUtils$.MODULE$.resolveCreateTopic($this.makeCreatableTopic(topic$1, -1, (Option<String>)new Some((Object)linkName$2), (Option<String>)new Some((Object)topic$1)), (Option)None$.MODULE$, validConfigs$1, false, (Option)new Some((Object)$this.linkConfig()), (Option)new Some(future), "");
    }

    private static final ClusterLinkFilterInfo filterInfo$1(String name, PatternType patternType, String filterType) {
        return new ClusterLinkFilterInfo(name, patternType, filterType, (ClusterLinkFilter)new TopicClusterLinkFilter(name, patternType.name(), filterType));
    }

    private static final scala.collection.immutable.Set filter$1(scala.collection.immutable.Set items, scala.collection.immutable.Seq filters) {
        return (scala.collection.immutable.Set)ClusterLinkUtils$.MODULE$.doFilterTopics(items, filters)._1();
    }

    private static final GroupClusterLinkFilterInfo filterInfo$2(String name, PatternType patternType, String filterType, scala.collection.immutable.Set topicTypes) {
        return new GroupClusterLinkFilterInfo(new ClusterLinkFilterInfo(name, patternType, filterType, (ClusterLinkFilter)new TopicClusterLinkFilter(name, patternType.name(), filterType)), topicTypes.toSeq());
    }

    private static final scala.collection.immutable.Set filter$2(scala.collection.immutable.Set items, scala.collection.immutable.Seq filters) {
        return (scala.collection.immutable.Set)ClusterLinkUtils$.MODULE$.doFilterGroups(items, filters)._1();
    }

    private static final GroupClusterLinkFilterInfo filterInfo$3(String name, PatternType patternType, String filterType, scala.collection.immutable.Set topicTypes) {
        return new GroupClusterLinkFilterInfo(new ClusterLinkFilterInfo(name, patternType, filterType, (ClusterLinkFilter)new TopicClusterLinkFilter(name, patternType.name(), filterType)), topicTypes.toSeq());
    }

    private static final scala.collection.immutable.Set filter$3(scala.collection.immutable.Set items, scala.collection.immutable.Seq filters) {
        return (scala.collection.immutable.Set)ClusterLinkUtils$.MODULE$.doFilterGroups(items, filters)._1();
    }

    private static final void clearCounts$1(scala.collection.immutable.Seq exceptions$1, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map debugCounts$1, scala.collection.mutable.Map warnCounts$1) {
        exceptions$1.foreach((Function1 & Serializable)e -> {
            errorCounts$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getClass()), (Object)BoxesRunTime.boxToInteger((int)0)));
            debugCounts$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getClass()), (Object)BoxesRunTime.boxToInteger((int)0)));
            return (scala.collection.mutable.Map)warnCounts$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getClass()), (Object)BoxesRunTime.boxToInteger((int)0)));
        });
    }

    private static final void verifyCounts$1(Throwable e, int expectedErrors, int expectedWarn, int expectedDebug, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map warnCounts$1, scala.collection.mutable.Map debugCounts$1, ClusterLinkDynamicLogger dynamicLogger$1) {
        Assertions.assertEquals((int)expectedErrors, (int)BoxesRunTime.unboxToInt((Object)errorCounts$1.apply(e.getClass())), (String)"Incorrect error count");
        Assertions.assertEquals((int)expectedWarn, (int)BoxesRunTime.unboxToInt((Object)warnCounts$1.apply(e.getClass())), (String)"Incorrect warn count");
        Assertions.assertEquals((int)expectedDebug, (int)BoxesRunTime.unboxToInt((Object)debugCounts$1.apply(e.getClass())), (String)"Incorrect debug count");
        dynamicLogger$1.resetErrors();
    }

    public static final /* synthetic */ void $anonfun$testDynamicLogger$2(ClusterLinkDynamicLogger dynamicLogger$1, RuntimeException e1$1, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map warnCounts$1, scala.collection.mutable.Map debugCounts$1, scala.collection.immutable.Seq exceptions$1, int x$1) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> dynamicLogger$1.error(e1$1.getMessage(), (Throwable)e1$1));
        ClusterLinkUtilsTest.verifyCounts$1(e1$1, 4, 0, 6, errorCounts$1, warnCounts$1, debugCounts$1, dynamicLogger$1);
        ClusterLinkUtilsTest.clearCounts$1(exceptions$1, errorCounts$1, debugCounts$1, warnCounts$1);
    }

    public static final /* synthetic */ void $anonfun$testDynamicLogger$4(ClusterLinkDynamicLogger dynamicLogger$1, RuntimeException e1$1, IllegalStateException e2$1, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map warnCounts$1, scala.collection.mutable.Map debugCounts$1, scala.collection.immutable.Seq exceptions$1, int x$3) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int n = i % 2;
            switch (n) {
                case 0: {
                    dynamicLogger$1.error(e1$1.getMessage(), (Throwable)e1$1);
                    return;
                }
                case 1: {
                    dynamicLogger$1.error(e2$1.getMessage(), (Throwable)e2$1);
                    return;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        });
        ClusterLinkUtilsTest.verifyCounts$1(e1$1, 4, 0, 6, errorCounts$1, warnCounts$1, debugCounts$1, dynamicLogger$1);
        ClusterLinkUtilsTest.verifyCounts$1(e2$1, 4, 0, 6, errorCounts$1, warnCounts$1, debugCounts$1, dynamicLogger$1);
        ClusterLinkUtilsTest.clearCounts$1(exceptions$1, errorCounts$1, debugCounts$1, warnCounts$1);
    }

    private static final ClusterLinkConfig linkConfig$1(String bootstrapServers) {
        return ClusterLinkConfig$.MODULE$.create((Map)new Properties(null, bootstrapServers){
            {
                this.put("bootstrap.servers", bootstrapServers$1);
            }
        }, (Option)None$.MODULE$, true);
    }
}

