/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.server.link.LazyResource;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001B\u0010!\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013%1\u0007\u0003\u0004B\u0001\u0001\u0006I\u0001\u000e\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0011\u00199\u0005\u0001)A\u0005\t\"9\u0001\n\u0001b\u0001\n\u0013I\u0005BB5\u0001A\u0003%!\nC\u0004k\u0001\t\u0007I\u0011B6\t\rQ\u0004\u0001\u0015!\u0003m\u0011\u001d)\bA1A\u0005\nYCaA\u001e\u0001!\u0002\u00139\u0006\"B<\u0001\t\u0003)\u0007BBA\u0004\u0001\u0011\u0005Q\rC\u0004\u0002\f\u0001!I!!\u0004\t\u0013\u0005\r\u0002!%A\u0005\n\u0005\u0015\u0002BBA\u001e\u0001\u0011\u0005Q\rC\u0004\u0002@\u0001!I!!\u0011\t\u0013\u0005%\u0003!%A\u0005\n\u0005\u0015\u0002BBA&\u0001\u0011\u0005Q\r\u0003\u0004\u0002P\u0001!\t!\u001a\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBq!a\u001a\u0001\t\u0013\tIG\u0002\u0003P\u0001\u0001\u0001\u0006\u0002C)\u0019\u0005\u000b\u0007I\u0011A\"\t\u0011IC\"\u0011!Q\u0001\n\u0011CQA\f\r\u0005\u0002MCq!\u0016\rC\u0002\u0013\u0005a\u000b\u0003\u0004d1\u0001\u0006Ia\u0016\u0005\u0006Ib!\t!\u001a\u0002\u0011\u0019\u0006T\u0018PU3t_V\u00148-\u001a+fgRT!!\t\u0012\u0002\t1Lgn\u001b\u0006\u0003G\u0011\naa]3sm\u0016\u0014(\"A\u0013\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0001\u0004CA\u0019\u0001\u001b\u0005\u0001\u0013\u0001\u0002;j[\u0016,\u0012\u0001\u000e\t\u0003k}j\u0011A\u000e\u0006\u0003oa\nQ!\u001e;jYNT!!\u000f\u001e\u0002\r\r|W.\\8o\u0015\t)3H\u0003\u0002={\u00051\u0011\r]1dQ\u0016T\u0011AP\u0001\u0004_J<\u0017B\u0001!7\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!C7bq&#G.Z't+\u0005!\u0005CA\u0015F\u0013\t1%FA\u0002J]R\f!\"\\1y\u0013\u0012dW-T:!\u00031a\u0017M_=SKN|WO]2f+\u0005Q\u0005cA\u0019L\u001b&\u0011A\n\t\u0002\r\u0019\u0006T\u0018PU3t_V\u00148-\u001a\t\u0003\u001dbi\u0011\u0001\u0001\u0002\r)\u0016\u001cHOU3t_V\u00148-Z\n\u00031!\n!!\u001b3\u0002\u0007%$\u0007\u0005\u0006\u0002N)\")\u0011k\u0007a\u0001\t\u0006Q1\r\\8tK\u000e{WO\u001c;\u0016\u0003]\u0003\"\u0001W1\u000e\u0003eS!AW.\u0002\r\u0005$x.\\5d\u0015\taV,\u0001\u0006d_:\u001cWO\u001d:f]RT!AX0\u0002\tU$\u0018\u000e\u001c\u0006\u0002A\u0006!!.\u0019<b\u0013\t\u0011\u0017LA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\fG2|7/Z\"pk:$\b%A\u0003dY>\u001cX\rF\u0001g!\tIs-\u0003\u0002iU\t!QK\\5u\u00035a\u0017M_=SKN|WO]2fA\u0005I!/Z:pkJ\u001cWm]\u000b\u0002YB\u0019QN]'\u000e\u00039T!a\u001c9\u0002\u000f5,H/\u00192mK*\u0011\u0011OK\u0001\u000bG>dG.Z2uS>t\u0017BA:o\u0005\u0019\u0011UO\u001a4fe\u0006Q!/Z:pkJ\u001cWm\u001d\u0011\u0002\r9,\u0007\u0010^%e\u0003\u001dqW\r\u001f;JI\u0002\n!\u0002^3ti\u000e\u0013X-\u0019;fQ\ta\u0011\u0010E\u0002{\u0003\u0007i\u0011a\u001f\u0006\u0003yv\f1!\u00199j\u0015\tqx0A\u0004kkBLG/\u001a:\u000b\u0007\u0005\u0005Q(A\u0003kk:LG/C\u0002\u0002\u0006m\u0014A\u0001V3ti\u0006aA/Z:u\u0003V$x.\u00133mK\"\u0012Q\"_\u0001\u000fm\u0016\u0014\u0018NZ=BkR|\u0017\n\u001a7f)\u001d1\u0017qBA\t\u00033AQ\u0001\u0013\bA\u0002)CaA\u0011\bA\u0002\u0005M\u0001cA\u0015\u0002\u0016%\u0019\u0011q\u0003\u0016\u0003\t1{gn\u001a\u0005\n\u00037q\u0001\u0013!a\u0001\u0003;\tq\"\u001b8ji&\fGNU3t_V\u00148-\u001a\t\u0005S\u0005}Q*C\u0002\u0002\")\u0012aa\u00149uS>t\u0017\u0001\u0007<fe&4\u00170Q;u_&#G.\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0005\u0016\u0005\u0003;\tIc\u000b\u0002\u0002,A!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012!C;oG\",7m[3e\u0015\r\t)DK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001d\u0003_\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003=!Xm\u001d;O_R\fU\u000f^8JI2,\u0007F\u0001\tz\u0003E1XM]5gs:{G/Q;u_&#G.\u001a\u000b\bM\u0006\r\u0013QIA$\u0011\u0015A\u0015\u00031\u0001K\u0011\u0019\u0011\u0015\u00031\u0001\u0002\u0014!I\u00111D\t\u0011\u0002\u0003\u0007\u0011QD\u0001\u001cm\u0016\u0014\u0018NZ=O_R\fU\u000f^8JI2,G\u0005Z3gCVdG\u000fJ\u001a\u0002;Q,7\u000f\u001e*fG>tg-[4ve\u0016,\u0005\u0010]5ss\u0006+Ho\\%eY\u0016D#aE=\u0002AQ,7\u000f\u001e*fG>tg-[4ve\u0016,\u0005\u0010]5ss:{G/Q;u_&#G.\u001a\u0015\u0003)e\faC]3tKR\fe\u000eZ\"sK\u0006$XMU3t_V\u00148-\u001a\u000b\u0006M\u0006]\u0013\u0011\f\u0005\u0006\u0011V\u0001\rA\u0013\u0005\b\u00037*\u0002\u0019AA/\u00035\tW\u000f^8Ti\u0006\u0014H/\u00133mKB\u0019\u0011&a\u0018\n\u0007\u0005\u0005$FA\u0004C_>dW-\u00198\u0002\u001d\r\u0014X-\u0019;f%\u0016\u001cx.\u001e:dKR\tQ*A\nbY2\u0014Vm]8ve\u000e,7o\u0011:fCR,G-\u0006\u0002\u0002lA)\u0011QNA8\t6\t\u0001/C\u0002\u0002rA\u00141aU3r\u0001")
public class LazyResourceTest {
    private final MockTime time = new MockTime();
    private final int maxIdleMs;
    private final LazyResource<TestResource> lazyResource = new LazyResource((Function0 & Serializable)() -> this.createResource(), (Function1 & Serializable)x$1 -> {
        x$1.close();
        return BoxedUnit.UNIT;
    }, (Time)this.time(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.maxIdleMs());
    private final Buffer<TestResource> resources = (Buffer)Buffer$.MODULE$.empty();
    private final AtomicInteger nextId = new AtomicInteger();

    private MockTime time() {
        return this.time;
    }

    private int maxIdleMs() {
        return this.maxIdleMs;
    }

    private LazyResource<TestResource> lazyResource() {
        return this.lazyResource;
    }

    private Buffer<TestResource> resources() {
        return this.resources;
    }

    private AtomicInteger nextId() {
        return this.nextId;
    }

    @Test
    public void testCreate() {
        Assertions.assertEquals((Object)Seq$.MODULE$.empty(), this.allResourcesCreated());
        TestResource resource1 = (TestResource)this.lazyResource().getOrCreate(false);
        Assertions.assertSame((Object)resource1, (Object)this.resources().head());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.allResourcesCreated());
        Assertions.assertSame((Object)resource1, (Object)this.lazyResource().getOrCreate(false));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.allResourcesCreated());
        LazyResource anotherResource = new LazyResource((Function0 & Serializable)() -> this.createResource(), (Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        }, (Time)this.time(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.maxIdleMs());
        TestResource resource2 = (TestResource)anotherResource.getOrCreate(false);
        Assertions.assertNotSame((Object)resource1, (Object)resource2);
        Assertions.assertSame((Object)this.resources().apply(1), (Object)resource2);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.allResourcesCreated());
        this.lazyResource().getOrCreate(false);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.allResourcesCreated());
        anotherResource.getOrCreate(false);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.allResourcesCreated());
        Assertions.assertEquals((int)0, (int)resource1.closeCount().get());
        Assertions.assertEquals((int)0, (int)resource2.closeCount().get());
        this.lazyResource().closeResource();
        Assertions.assertEquals((int)1, (int)resource1.closeCount().get());
        Assertions.assertEquals((int)0, (int)resource2.closeCount().get());
        this.lazyResource().closeResource();
        Assertions.assertEquals((int)1, (int)resource1.closeCount().get());
        Assertions.assertEquals((int)0, (int)resource2.closeCount().get());
        anotherResource.closeResource();
        Assertions.assertEquals((int)1, (int)resource1.closeCount().get());
        Assertions.assertEquals((int)1, (int)resource2.closeCount().get());
        TestResource resource3 = (TestResource)this.lazyResource().getOrCreate(false);
        Assertions.assertNotSame((Object)resource1, (Object)resource3);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), this.allResourcesCreated());
        this.lazyResource().shutdown();
        Assertions.assertEquals((int)1, (int)resource3.closeCount().get());
        Assertions.assertThrows(IllegalStateException.class, () -> this.lazyResource().getOrCreate(false));
        Assertions.assertThrows(IllegalStateException.class, () -> this.lazyResource().getOrCreate(true));
        this.lazyResource().shutdown();
        Assertions.assertEquals((int)1, (int)resource3.closeCount().get());
    }

    @Test
    public void testAutoIdle() {
        this.verifyNotAutoIdle(this.lazyResource(), this.maxIdleMs(), (Option<TestResource>)None$.MODULE$);
    }

    private void verifyAutoIdle(LazyResource<TestResource> lazyResource, long maxIdleMs, Option<TestResource> initialResource) {
        TestResource resource1 = (TestResource)initialResource.getOrElse((Function0 & Serializable)() -> (TestResource)lazyResource.getOrCreate(true));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.allResourcesCreated());
        Assertions.assertEquals((int)0, (int)resource1.closeCount().get());
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)0, (int)resource1.closeCount().get());
        Assertions.assertSame((Object)resource1, (Object)lazyResource.getOrCreate(true));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.allResourcesCreated());
        this.time().sleep(maxIdleMs + 1L);
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)1, (int)resource1.closeCount().get());
        TestResource resource2 = (TestResource)lazyResource.getOrCreate(true);
        Assertions.assertNotSame((Object)resource1, (Object)resource2);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.allResourcesCreated());
        this.time().sleep(maxIdleMs / 2L);
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)0, (int)resource2.closeCount().get());
        Assertions.assertSame((Object)resource2, (Object)lazyResource.getOrCreate(true));
        this.time().sleep(maxIdleMs / 2L + 1L);
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)0, (int)resource2.closeCount().get());
        this.time().sleep(maxIdleMs / 2L);
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)1, (int)resource2.closeCount().get());
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)1, (int)resource2.closeCount().get());
        lazyResource.closeResource();
        Assertions.assertEquals((int)1, (int)resource2.closeCount().get());
        Assertions.assertNotSame((Object)resource2, (Object)lazyResource.getOrCreate(true));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), this.allResourcesCreated());
    }

    private Option<TestResource> verifyAutoIdle$default$3() {
        return None$.MODULE$;
    }

    @Test
    public void testNotAutoIdle() {
        this.verifyNotAutoIdle(this.lazyResource(), this.maxIdleMs(), (Option<TestResource>)None$.MODULE$);
    }

    private void verifyNotAutoIdle(LazyResource<TestResource> lazyResource, long maxIdleMs, Option<TestResource> initialResource) {
        TestResource resource1 = (TestResource)initialResource.getOrElse((Function0 & Serializable)() -> (TestResource)lazyResource.getOrCreate(false));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.allResourcesCreated());
        Assertions.assertEquals((int)0, (int)resource1.closeCount().get());
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)0, (int)resource1.closeCount().get());
        Assertions.assertSame((Object)resource1, (Object)lazyResource.getOrCreate(false));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.allResourcesCreated());
        this.time().sleep(maxIdleMs + 1L);
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)0, (int)resource1.closeCount().get());
        Assertions.assertSame((Object)resource1, (Object)lazyResource.getOrCreate(false));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.allResourcesCreated());
        lazyResource.startIdle();
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)0, (int)resource1.closeCount().get());
        Assertions.assertSame((Object)resource1, (Object)lazyResource.getOrCreate(false));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.allResourcesCreated());
        this.time().sleep(maxIdleMs + 1L);
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)0, (int)resource1.closeCount().get());
        lazyResource.startIdle();
        this.time().sleep(maxIdleMs + 1L);
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)1, (int)resource1.closeCount().get());
        TestResource resource2 = (TestResource)lazyResource.getOrCreate(false);
        Assertions.assertNotSame((Object)resource1, (Object)resource2);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.allResourcesCreated());
        lazyResource.startIdle();
        this.time().sleep(maxIdleMs / 2L);
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)0, (int)resource2.closeCount().get());
        Assertions.assertSame((Object)resource2, (Object)lazyResource.getOrCreate(false));
        this.time().sleep(maxIdleMs + 1L);
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)0, (int)resource2.closeCount().get());
        lazyResource.startIdle();
        this.time().sleep(maxIdleMs + 1L);
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)1, (int)resource2.closeCount().get());
        lazyResource.closeIdleResource();
        Assertions.assertEquals((int)1, (int)resource2.closeCount().get());
        lazyResource.closeResource();
        Assertions.assertEquals((int)1, (int)resource2.closeCount().get());
        Assertions.assertNotSame((Object)resource2, (Object)lazyResource.getOrCreate(false));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), this.allResourcesCreated());
    }

    private Option<TestResource> verifyNotAutoIdle$default$3() {
        return None$.MODULE$;
    }

    @Test
    public void testReconfigureExpiryAutoIdle() {
        AtomicLong idleMs = new AtomicLong(this.maxIdleMs() * 10);
        LazyResource lazyResource = new LazyResource((Function0 & Serializable)() -> this.createResource(), (Function1 & Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        }, (Time)this.time(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> idleMs.get());
        this.verifyAutoIdle((LazyResource<TestResource>)lazyResource, idleMs.get(), (Option<TestResource>)None$.MODULE$);
        this.resetAndCreateResource((LazyResource<TestResource>)lazyResource, true);
        idleMs.set(this.maxIdleMs());
        this.verifyAutoIdle((LazyResource<TestResource>)lazyResource, idleMs.get(), (Option<TestResource>)lazyResource.value());
        this.resetAndCreateResource((LazyResource<TestResource>)lazyResource, true);
        idleMs.set(this.maxIdleMs() * 20);
        this.verifyAutoIdle((LazyResource<TestResource>)lazyResource, idleMs.get(), (Option<TestResource>)lazyResource.value());
    }

    @Test
    public void testReconfigureExpiryNotAutoIdle() {
        AtomicLong idleMs = new AtomicLong(this.maxIdleMs() * 10);
        LazyResource lazyResource = new LazyResource((Function0 & Serializable)() -> this.createResource(), (Function1 & Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        }, (Time)this.time(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> idleMs.get());
        this.verifyNotAutoIdle((LazyResource<TestResource>)lazyResource, idleMs.get(), (Option<TestResource>)None$.MODULE$);
        this.resetAndCreateResource((LazyResource<TestResource>)lazyResource, false);
        idleMs.set(this.maxIdleMs());
        this.verifyNotAutoIdle((LazyResource<TestResource>)lazyResource, idleMs.get(), (Option<TestResource>)lazyResource.value());
        this.resetAndCreateResource((LazyResource<TestResource>)lazyResource, false);
        idleMs.set(this.maxIdleMs() * 20);
        this.verifyNotAutoIdle((LazyResource<TestResource>)lazyResource, idleMs.get(), (Option<TestResource>)lazyResource.value());
    }

    private void resetAndCreateResource(LazyResource<TestResource> lazyResource, boolean autoStartIdle) {
        this.resources().clear();
        this.nextId().set(0);
        lazyResource.closeResource();
        lazyResource.getOrCreate(autoStartIdle);
    }

    private TestResource createResource() {
        TestResource resource = new TestResource(this, this.nextId().incrementAndGet());
        this.resources().$plus$eq((Object)resource);
        return resource;
    }

    private Seq<Object> allResourcesCreated() {
        return ((IterableOnceOps)this.resources().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()))).toSeq();
    }

    public LazyResourceTest() {
        this.maxIdleMs = 1000;
    }

    public class TestResource {
        private final int id;
        private final AtomicInteger closeCount;
        public final /* synthetic */ LazyResourceTest $outer;

        public int id() {
            return this.id;
        }

        public AtomicInteger closeCount() {
            return this.closeCount;
        }

        public void close() {
            this.closeCount().incrementAndGet();
        }

        public /* synthetic */ LazyResourceTest kafka$server$link$LazyResourceTest$TestResource$$$outer() {
            return this.$outer;
        }

        public TestResource(LazyResourceTest $outer, int id) {
            this.id = id;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.closeCount = new AtomicInteger();
        }
    }
}

