/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.resource;

import java.util.HashMap;
import kafka.metrics.LinuxDiskMetricsCollector;
import kafka.server.Defaults;
import kafka.server.KafkaConfig;
import kafka.server.resource.DiskIOManager;
import kafka.server.resource.ResourceUsageListener;
import kafka.server.resource.TierArchiverDiskThroughputListener;
import kafka.utils.TestUtils;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;

class DiskIOManagerTest {
    private static final long GP3_DISK_THROUGHPUT_LIMIT_FREE = 0x7D00000L;
    private static final long DEFAULT_DISK_THROUGHPUT_HEADROOM = 0xA00000L;
    private static final long DISK_THROUGHPUT_QUOTA_TIER_ARCHIVER_DEFAULT = 0x3200000L;
    private static final long DISK_THROUGHPUT_QUOTA_TIER_ARCHIVER_THROTTLED = 0x500000L;
    private final Metrics metrics = new Metrics();

    DiskIOManagerTest() {
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testDiskIOManager() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("zookeeper.connect", "localhost:2181");
        configs.put(KafkaConfig.DiskIOManagerEnableProp(), "true");
        configs.put(KafkaConfig.DiskThroughputLimitBytePerSecProp(), String.valueOf(0x7D00000L));
        configs.put(KafkaConfig.DiskThroughputHeadroomBytePerSecProp(), String.valueOf(0xA00000L));
        configs.put(KafkaConfig.DiskThroughputQuotaForTierArchiveBytePerSecProp(), String.valueOf(0x3200000L));
        configs.put(KafkaConfig.DiskThroughputThrottledQuotaForTierArchiveBytePerSecProp(), String.valueOf(0x500000L));
        KafkaConfig config = new KafkaConfig(configs);
        LinuxDiskMetricsCollector linuxDiskMetricsCollector = (LinuxDiskMetricsCollector)Mockito.mock(LinuxDiskMetricsCollector.class);
        Mockito.when((Object)linuxDiskMetricsCollector.metricRate(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt())).thenReturn((Object)1.0);
        DiskIOManager diskIOManager = new DiskIOManager(this.metrics, config, linuxDiskMetricsCollector, 512, "sda");
        TierArchiverDiskThroughputListener listener = new TierArchiverDiskThroughputListener((Time)new MockTime());
        diskIOManager.registerListener((ResourceUsageListener)listener);
        Assertions.assertEquals((double)Defaults.DiskThroughputQuotaForTierArchiveBytePerSec(), (double)listener.quota());
        diskIOManager.startup();
        Assertions.assertTrue((boolean)this.metrics.metrics().containsKey(DiskIOManager.DISK_THROUGHPUT_BYTE_PER_SEC));
        Assertions.assertTrue((boolean)this.metrics.metrics().containsKey(DiskIOManager.DISK_THROUGHPUT_LIMIT_BYTE_PER_SEC));
        TestUtils.waitUntilTrue((Function0<Object>)((Function0)() -> (Double)this.metrics.metric(DiskIOManager.DISK_THROUGHPUT_BYTE_PER_SEC).metricValue() > 0.0), (Function0<String>)((Function0)() -> "DiskIOManager fails to get linux level stats from linuxDiskMetricsCollector"), 60000L, 2000L);
        Assertions.assertFalse((boolean)diskIOManager.isThrottled());
        Mockito.when((Object)linuxDiskMetricsCollector.metricRate(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt())).thenReturn((Object)128000.0);
        TestUtils.waitUntilTrue((Function0<Object>)((Function0)() -> ((DiskIOManager)diskIOManager).isThrottled()), (Function0<String>)((Function0)() -> "DiskIOManager fails to transition to throttled mode"), 60000L, 2000L);
        Assertions.assertEquals((double)5242880.0, (double)listener.quota());
        Mockito.when((Object)linuxDiskMetricsCollector.metricRate(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt())).thenReturn((Object)1.0);
        TestUtils.waitUntilTrue((Function0<Object>)((Function0)() -> !diskIOManager.isThrottled()), (Function0<String>)((Function0)() -> "DiskIOManager fails to exit throttled mode"), 60000L, 2000L);
        Assertions.assertEquals((double)5.24288E7, (double)listener.quota());
        diskIOManager.shutdown();
        Assertions.assertFalse((boolean)this.metrics.metrics().containsKey(DiskIOManager.DISK_THROUGHPUT_BYTE_PER_SEC));
        Assertions.assertFalse((boolean)this.metrics.metrics().containsKey(DiskIOManager.DISK_THROUGHPUT_LIMIT_BYTE_PER_SEC));
    }
}

