/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.resource;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.NotificationEmitter;
import kafka.server.KafkaConfig;
import kafka.server.resource.HeapWatcher;
import kafka.utils.TestUtils;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockSettings;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import scala.Function0;

public class HeapWatcherTest {
    private final Metrics metrics = new Metrics();

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    private MemoryPoolMXBean getMockMemoryPoolMXBean(MemoryType type, String name, boolean supported) {
        MemoryPoolMXBean bean = (MemoryPoolMXBean)Mockito.mock(MemoryPoolMXBean.class);
        Mockito.when((Object)((Object)bean.getType())).thenReturn((Object)type);
        Mockito.when((Object)bean.getName()).thenReturn((Object)name);
        Mockito.when((Object)bean.isCollectionUsageThresholdSupported()).thenReturn((Object)supported);
        return bean;
    }

    @Test
    public void TestGetTenuredPoolMXBean() {
        MemoryPoolMXBean nonTenuredHeap = this.getMockMemoryPoolMXBean(MemoryType.HEAP, "new-gen", true);
        MemoryPoolMXBean notHeap = this.getMockMemoryPoolMXBean(MemoryType.NON_HEAP, "Old", true);
        MemoryPoolMXBean tenuredBean = this.getMockMemoryPoolMXBean(MemoryType.HEAP, "Tenured", true);
        MemoryPoolMXBean tenuredBean2 = this.getMockMemoryPoolMXBean(MemoryType.HEAP, "Old", true);
        try (MockedStatic managmentFactoryMock = Mockito.mockStatic(ManagementFactory.class);){
            managmentFactoryMock.when(ManagementFactory::getMemoryPoolMXBeans).thenReturn(Arrays.asList(nonTenuredHeap, notHeap));
            Assertions.assertNull((Object)HeapWatcher.getTenuredPoolMXBean());
            managmentFactoryMock.when(ManagementFactory::getMemoryPoolMXBeans).thenReturn(Arrays.asList(nonTenuredHeap, notHeap, tenuredBean));
            Assertions.assertEquals((Object)tenuredBean, (Object)HeapWatcher.getTenuredPoolMXBean());
            managmentFactoryMock.when(ManagementFactory::getMemoryPoolMXBeans).thenReturn(Arrays.asList(nonTenuredHeap, notHeap, tenuredBean2));
            Assertions.assertEquals((Object)tenuredBean2, (Object)HeapWatcher.getTenuredPoolMXBean());
        }
    }

    @Test
    public void TestNotCreated() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try (MockedStatic managmentFactoryMock = Mockito.mockStatic(ManagementFactory.class);){
            managmentFactoryMock.when(ManagementFactory::getPlatformMBeanServer).thenReturn((Object)mBeanServer);
            managmentFactoryMock.when(ManagementFactory::getMemoryPoolMXBeans).thenReturn(Arrays.asList(new Object[0]));
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("zookeeper.connect", "localhost:2181");
            Assertions.assertThrows(IllegalStateException.class, () -> new HeapWatcher(this.metrics, new KafkaConfig(configs)), (String)"Shouldn't create if bean doesn't exists");
            MemoryPoolMXBean notSupportedBean = this.getMockMemoryPoolMXBean(MemoryType.HEAP, "Tenured", false);
            managmentFactoryMock.when(ManagementFactory::getMemoryPoolMXBeans).thenReturn(Arrays.asList(notSupportedBean));
            Assertions.assertThrows(IllegalArgumentException.class, () -> new HeapWatcher(this.metrics, new KafkaConfig(configs)), (String)"Shouldn't create if bean doesn't support collection usage threshold");
        }
    }

    @Test
    public void TestTheresholdOverMax() {
        HeapWatcher heapWatcher;
        MemoryPoolMXBean mockMemoryPoolMXBean;
        MemoryUsage memoryUsage;
        MemoryMXBean mockMemoryMXBean = (MemoryMXBean)Mockito.mock(MemoryMXBean.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{NotificationEmitter.class}));
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("zookeeper.connect", "localhost:2181");
        try (MockedStatic managmentFactoryMock = Mockito.mockStatic(ManagementFactory.class);){
            managmentFactoryMock.when(ManagementFactory::getPlatformMBeanServer).thenReturn((Object)mBeanServer);
            managmentFactoryMock.when(ManagementFactory::getMemoryMXBean).thenReturn((Object)mockMemoryMXBean);
            memoryUsage = new MemoryUsage(1L, 100L, 100L, 200L);
            mockMemoryPoolMXBean = this.getMockMemoryPoolMXBean(MemoryType.HEAP, "Tenured", true);
            Mockito.when((Object)mockMemoryPoolMXBean.getUsage()).thenReturn((Object)memoryUsage);
            managmentFactoryMock.when(ManagementFactory::getMemoryPoolMXBeans).thenReturn(Arrays.asList(mockMemoryPoolMXBean));
            configs.put("confluent.heap.tenured.notify.bytes", Long.toString(201L));
            heapWatcher = new HeapWatcher(this.metrics, new KafkaConfig(configs));
            ((MemoryPoolMXBean)Mockito.verify((Object)mockMemoryPoolMXBean)).setCollectionUsageThreshold(0L);
            heapWatcher.shutdown();
        }
        managmentFactoryMock = Mockito.mockStatic(ManagementFactory.class);
        var5_5 = null;
        try {
            managmentFactoryMock.when(ManagementFactory::getPlatformMBeanServer).thenReturn((Object)mBeanServer);
            managmentFactoryMock.when(ManagementFactory::getMemoryMXBean).thenReturn((Object)mockMemoryMXBean);
            memoryUsage = new MemoryUsage(1L, 100L, 100L, -1L);
            mockMemoryPoolMXBean = this.getMockMemoryPoolMXBean(MemoryType.HEAP, "Tenured2", true);
            Mockito.when((Object)mockMemoryPoolMXBean.getUsage()).thenReturn((Object)memoryUsage);
            managmentFactoryMock.when(ManagementFactory::getMemoryPoolMXBeans).thenReturn(Arrays.asList(mockMemoryPoolMXBean));
            configs.put("confluent.heap.tenured.notify.bytes", Long.toString(201L));
            heapWatcher = new HeapWatcher(this.metrics, new KafkaConfig(configs));
            ((MemoryPoolMXBean)Mockito.verify((Object)mockMemoryPoolMXBean)).setCollectionUsageThreshold(201L);
            heapWatcher.shutdown();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (managmentFactoryMock != null) {
                if (var5_5 != null) {
                    try {
                        managmentFactoryMock.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    managmentFactoryMock.close();
                }
            }
        }
    }

    private void allocateObjects(List<byte[]> list, long sizeMb) {
        int i = 0;
        while ((long)i < sizeMb) {
            byte[] arr = new byte[0x100000];
            list.add(arr);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    @Test
    public void TestNotification() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("zookeeper.connect", "localhost:2181");
        MemoryPoolMXBean tenuredPoolBean = HeapWatcher.getTenuredPoolMXBean();
        MemoryUsage usage = tenuredPoolBean.getCollectionUsage();
        long threshold = Math.min(usage.getMax(), usage.getUsed() + 0xA00000L);
        configs.put("confluent.heap.tenured.notify.bytes", Long.toString(threshold));
        HeapWatcher heapWatcher = new HeapWatcher(this.metrics, new KafkaConfig(configs));
        MetricName metricName = heapWatcher.almostOOMMetricName;
        Assertions.assertTrue((boolean)this.metrics.metrics().containsKey(metricName));
        Assertions.assertEquals((double)0.0, (double)((Double)this.metrics.metric(metricName).metricValue()));
        ArrayList<byte[]> allocated = new ArrayList<byte[]>();
        this.allocateObjects(allocated, 10L);
        System.gc();
        TestUtils.waitUntilTrue((Function0<Object>)((Function0)() -> (Double)this.metrics.metric(metricName).metricValue() > 0.0), (Function0<String>)((Function0)() -> "Almost-OOM metric didn't fire"), 10000L, 100L);
        Assertions.assertEquals((double)1.0, (double)((Double)this.metrics.metric(metricName).metricValue()));
        this.allocateObjects(allocated, 1L);
        Assertions.assertEquals((double)1.0, (double)((Double)this.metrics.metric(metricName).metricValue()));
        heapWatcher.shutdown();
        allocated.clear();
        System.gc();
    }
}

