/*
 * Decompiled with CFR 0.152.
 */
package kafka.test;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;

public class JarResourceLoader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File loadFileFromResource(Class clazz, String resourcePath) {
        if (System.getenv("BAZEL_TEST") != null) {
            try (InputStream is = clazz.getResource(resourcePath).openStream();){
                File tempFile = File.createTempFile(resourcePath, null);
                Files.copy(is, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                File file = tempFile;
                return file;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            URL resource = clazz.getResource(resourcePath);
            return new File(resource.toURI());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File loadFileFromResourceWithClassLoader(Class clazz, String resourcePath) {
        if (System.getenv("BAZEL_TEST") != null) {
            try (InputStream is = clazz.getClassLoader().getResource(resourcePath).openStream();){
                File tempFile = File.createTempFile(resourcePath, null);
                Files.copy(is, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                File file = tempFile;
                return file;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            URL resource = clazz.getClassLoader().getResource(resourcePath);
            return new File(resource.toURI());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File loadDirectoryFromResource(ClassLoader loader, String resourcePath) {
        return JarResourceLoader.loadDirectoryFromResource(loader::getResource, resourcePath);
    }

    public static File loadDirectoryFromResource(Class clazz, String resourcePath) {
        return JarResourceLoader.loadDirectoryFromResource(clazz::getResource, resourcePath);
    }

    public static File loadDirectoryFromResource(Function<String, URL> getResource, String resourcePath) {
        if (System.getenv("BAZEL_TEST") != null) {
            try {
                Path tempDir = Files.createTempDirectory("resources", new FileAttribute[0]);
                URI uri = getResource.apply(resourcePath).toURI();
                FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                Path newPath = fileSystem.getPath(resourcePath, new String[0]);
                Stream<Path> walk = Files.walk(newPath, 10, new FileVisitOption[0]);
                Iterator it = walk.iterator();
                while (it.hasNext()) {
                    Path filePath = (Path)it.next();
                    if (Files.isDirectory(filePath, new LinkOption[0])) continue;
                    File tempFile = new File(Paths.get(tempDir.toString(), filePath.toString()).toUri());
                    Path baseDir = Paths.get(tempFile.getParent(), new String[0]);
                    if (!Files.exists(baseDir, new LinkOption[0])) {
                        Files.createDirectories(baseDir, new FileAttribute[0]);
                    }
                    InputStream isf = getResource.apply(filePath.toString()).openStream();
                    Throwable throwable = null;
                    try {
                        Files.copy(isf, tempFile.toPath(), new CopyOption[0]);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (isf == null) continue;
                        if (throwable != null) {
                            try {
                                isf.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        isf.close();
                    }
                }
                fileSystem.close();
                return new File(Paths.get(tempDir.toString(), resourcePath).toUri());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            URL resource = getResource.apply(resourcePath);
            return new File(resource.toURI());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

