/*
 * Decompiled with CFR 0.152.
 */
package kafka.test.annotation;

import java.util.function.Consumer;
import kafka.test.ClusterConfig;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.test.junit.ZkToKRaftClusterInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;

public enum Type {
    KRAFT{

        @Override
        public void invocationContexts(String baseDisplayName, ClusterConfig config, Consumer<TestTemplateInvocationContext> invocationConsumer) {
            invocationConsumer.accept(new RaftClusterInvocationContext(baseDisplayName, config.copyOf(), false));
        }
    }
    ,
    CO_KRAFT{

        @Override
        public void invocationContexts(String baseDisplayName, ClusterConfig config, Consumer<TestTemplateInvocationContext> invocationConsumer) {
            invocationConsumer.accept(new RaftClusterInvocationContext(baseDisplayName, config.copyOf(), true));
        }
    }
    ,
    ZK{

        @Override
        public void invocationContexts(String baseDisplayName, ClusterConfig config, Consumer<TestTemplateInvocationContext> invocationConsumer) {
            invocationConsumer.accept(new ZkClusterInvocationContext(baseDisplayName, config.copyOf()));
        }
    }
    ,
    ZK_TO_KRAFT{

        @Override
        public void invocationContexts(String baseDisplayName, ClusterConfig config, Consumer<TestTemplateInvocationContext> invocationConsumer) {
            invocationConsumer.accept(new ZkToKRaftClusterInvocationContext(config.copyOf()));
        }
    }
    ,
    ALL_NON_CORESIDENT{

        @Override
        public void invocationContexts(String baseDisplayName, ClusterConfig config, Consumer<TestTemplateInvocationContext> invocationConsumer) {
            invocationConsumer.accept(new RaftClusterInvocationContext(baseDisplayName, config.copyOf(), false));
            invocationConsumer.accept(new ZkClusterInvocationContext(baseDisplayName, config.copyOf()));
        }
    }
    ,
    ALL{

        @Override
        public void invocationContexts(String baseDisplayName, ClusterConfig config, Consumer<TestTemplateInvocationContext> invocationConsumer) {
            invocationConsumer.accept(new RaftClusterInvocationContext(baseDisplayName, config.copyOf(), false));
            invocationConsumer.accept(new RaftClusterInvocationContext(baseDisplayName, config.copyOf(), true));
            invocationConsumer.accept(new ZkClusterInvocationContext(baseDisplayName, config.copyOf()));
        }
    }
    ,
    DEFAULT{

        @Override
        public void invocationContexts(String baseDisplayName, ClusterConfig config, Consumer<TestTemplateInvocationContext> invocationConsumer) {
            throw new UnsupportedOperationException("Cannot create invocation contexts for DEFAULT type");
        }
    };


    public abstract void invocationContexts(String var1, ClusterConfig var2, Consumer<TestTemplateInvocationContext> var3);
}

