/*
 * Decompiled with CFR 0.152.
 */
package kafka.test.junit;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kafka.test.ClusterConfig;
import kafka.test.ClusterGenerator;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.util.ReflectionUtils;

public class ClusterTestExtensions
implements TestTemplateInvocationContextProvider {
    public boolean supportsTestTemplate(ExtensionContext context) {
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        ClusterTests clusterTestsAnnot;
        ClusterTest clusterTestAnnot;
        ClusterTestDefaults defaults = this.getClusterTestDefaults(context.getRequiredTestClass());
        ArrayList generatedContexts = new ArrayList();
        ClusterTemplate clusterTemplateAnnot = context.getRequiredTestMethod().getDeclaredAnnotation(ClusterTemplate.class);
        if (clusterTemplateAnnot != null) {
            this.processClusterTemplate(context, clusterTemplateAnnot, generatedContexts::add);
            if (generatedContexts.size() == 0) {
                throw new IllegalStateException("ClusterConfig generator method should provide at least one config");
            }
        }
        if ((clusterTestAnnot = context.getRequiredTestMethod().getDeclaredAnnotation(ClusterTest.class)) != null) {
            this.processClusterTest(context, clusterTestAnnot, defaults, generatedContexts::add);
        }
        if ((clusterTestsAnnot = context.getRequiredTestMethod().getDeclaredAnnotation(ClusterTests.class)) != null) {
            for (ClusterTest annot : clusterTestsAnnot.value()) {
                this.processClusterTest(context, annot, defaults, generatedContexts::add);
            }
        }
        if (generatedContexts.size() == 0) {
            throw new IllegalStateException("Please annotate test methods with @ClusterTemplate, @ClusterTest, or @ClusterTests when using the ClusterTestExtensions provider");
        }
        return generatedContexts.stream();
    }

    private void processClusterTemplate(ExtensionContext context, ClusterTemplate annot, Consumer<TestTemplateInvocationContext> testInvocations) {
        ArrayList<ClusterConfig> generatedClusterConfigs = new ArrayList<ClusterConfig>();
        if (!annot.value().isEmpty()) {
            this.generateClusterConfigurations(context, annot.value(), generatedClusterConfigs::add);
        } else {
            generatedClusterConfigs.add(ClusterConfig.defaultClusterBuilder().build());
        }
        String baseDisplayName = context.getRequiredTestMethod().getName();
        generatedClusterConfigs.forEach(config -> config.clusterType().invocationContexts(baseDisplayName, (ClusterConfig)config, testInvocations));
    }

    private void generateClusterConfigurations(ExtensionContext context, String generateClustersMethods, ClusterGenerator generator) {
        Object testInstance = context.getTestInstance().orElse(null);
        Method method = ReflectionUtils.getRequiredMethod((Class)context.getRequiredTestClass(), (String)generateClustersMethods, (Class[])new Class[]{ClusterGenerator.class});
        ReflectionUtils.invokeMethod((Method)method, testInstance, (Object[])new Object[]{generator});
    }

    private void processClusterTest(ExtensionContext context, ClusterTest annot, ClusterTestDefaults defaults, Consumer<TestTemplateInvocationContext> testInvocations) {
        boolean autoStart;
        Type type = annot.clusterType() == Type.DEFAULT ? defaults.clusterType() : annot.clusterType();
        int brokers = annot.brokers() == 0 ? defaults.brokers() : annot.brokers();
        int controllers = annot.controllers() == 0 ? defaults.controllers() : annot.controllers();
        if (brokers <= 0 || controllers <= 0) {
            throw new IllegalArgumentException("Number of brokers/controllers must be greater than zero.");
        }
        switch (annot.autoStart()) {
            case YES: {
                autoStart = true;
                break;
            }
            case NO: {
                autoStart = false;
                break;
            }
            case DEFAULT: {
                autoStart = defaults.autoStart();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ClusterConfig.Builder builder = ClusterConfig.clusterBuilder(type, brokers, controllers, autoStart, annot.securityProtocol(), annot.metadataVersion(), 0);
        if (!annot.name().isEmpty()) {
            builder.name(annot.name());
        }
        if (!annot.listener().isEmpty()) {
            builder.listenerName(annot.listener());
        }
        Properties properties = new Properties();
        for (ClusterConfigProperty property : annot.serverProperties()) {
            properties.put(property.key(), property.value());
        }
        ClusterConfig config = builder.build();
        config.serverProperties().putAll((Map<?, ?>)properties);
        type.invocationContexts(context.getRequiredTestMethod().getName(), config, testInvocations);
    }

    private ClusterTestDefaults getClusterTestDefaults(Class<?> testClass) {
        return Optional.ofNullable(testClass.getDeclaredAnnotation(ClusterTestDefaults.class)).orElseGet(() -> EmptyClass.class.getDeclaredAnnotation(ClusterTestDefaults.class));
    }

    @ClusterTestDefaults
    private static final class EmptyClass {
        private EmptyClass() {
        }
    }
}

