/*
 * Decompiled with CFR 0.152.
 */
package kafka.test.junit;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig;
import kafka.test.ClusterConfig;
import kafka.test.junit.ClusterInstanceParameterResolver;
import kafka.test.junit.GenericParameterResolver;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.testkit.KafkaClusterTestKit;
import kafka.zk.EmbeddedZookeeper;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;

public class ZkToKRaftClusterInvocationContext
implements TestTemplateInvocationContext {
    private final ClusterConfig clusterConfig;
    private final AtomicReference<IntegrationTestHarness> zkClusterReference;
    private final AtomicReference<KafkaClusterTestKit> kraftClusterReference;
    private final AtomicReference<EmbeddedZookeeper> zkReference;

    public ZkToKRaftClusterInvocationContext(ClusterConfig clusterConfig) {
        this.clusterConfig = clusterConfig;
        this.zkClusterReference = new AtomicReference();
        this.kraftClusterReference = new AtomicReference();
        this.zkReference = new AtomicReference();
    }

    public String getDisplayName(int invocationIndex) {
        String clusterDesc = this.clusterConfig.nameTags().entrySet().stream().map(Object::toString).collect(Collectors.joining(", "));
        return String.format("[%d] Type=Hybrid, %s", invocationIndex, clusterDesc);
    }

    public List<Extension> getAdditionalExtensions() {
        ClusterConfig zkClusterConfig = this.clusterConfig.copyOf();
        ClusterConfig kraftClusterConfig = this.clusterConfig.copyOf(builder -> builder.brokers(0));
        ZkClusterInvocationContext.ZkClusterInstance zkClusterInstance = new ZkClusterInvocationContext.ZkClusterInstance(zkClusterConfig, this.zkClusterReference);
        RaftClusterInvocationContext.RaftClusterInstance kraftClusterInstance = new RaftClusterInvocationContext.RaftClusterInstance(this.kraftClusterReference, this.zkReference, kraftClusterConfig);
        return Arrays.asList(context -> {
            this.zkClusterReference.set(ZkClusterInvocationContext.createClusterReference(zkClusterConfig));
            zkClusterInstance.config().serverProperties().put("confluent.cluster.link.metadata.topic.enable", "true");
            zkClusterInstance.config().serverProperties().put("confluent.cluster.link.metadata.topic.replication.factor", "1");
            zkClusterInstance.config().serverProperties().put("confluent.cluster.link.metadata.topic.partitions", "1");
            zkClusterInstance.start();
            Uuid clusterId = Uuid.fromString((String)((String)this.zkClusterReference.get().zkClientOrNull().getClusterId().get()));
            kraftClusterInstance.config().serverProperties().put(KafkaConfig.MigrationEnabledProp(), "true");
            kraftClusterInstance.config().serverProperties().put(KafkaConfig.ControllerListenerNamesProp(), "CONTROLLER");
            Map.Entry<KafkaClusterTestKit, EmbeddedZookeeper> entry = RaftClusterInvocationContext.createClusterReference(kraftClusterConfig, false, clusterId, Optional.of(this.zkClusterReference.get().zookeeper()));
            this.kraftClusterReference.set(entry.getKey());
            kraftClusterInstance.start();
            zkClusterInstance.config().serverProperties().put(KafkaConfig.MigrationEnabledProp(), "true");
            zkClusterInstance.config().serverProperties().put(KafkaConfig.QuorumVotersProp(), this.kraftClusterReference.get().quorumVotersString().get());
            zkClusterInstance.config().serverProperties().put(KafkaConfig.ControllerListenerNamesProp(), "CONTROLLER");
            zkClusterInstance.config().serverProperties().put(KafkaConfig.AdvertisedListenersProp(), "PLAINTEXT://localhost:0,EXTERNAL://localhost:0");
            zkClusterInstance.config().serverProperties().put(KafkaConfig.ListenersProp(), "PLAINTEXT://localhost:0,EXTERNAL://localhost:0");
            zkClusterInstance.config().serverProperties().put(KafkaConfig.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkClusterInstance.rollingBrokerRestart();
            TestUtils.waitForCondition(() -> this.zkClusterReference.get().zkClientOrNull().getMigrationState().exists(state -> state.kraftMetadataOffset() > 0L), (long)30000L, (String)"Waiting for migration to complete");
        }, context -> {
            zkClusterInstance.stop();
            kraftClusterInstance.stop();
        }, new ClusterInstanceParameterResolver(zkClusterInstance), new GenericParameterResolver<ClusterConfig>(zkClusterConfig, ClusterConfig.class));
    }
}

