/*
 * Decompiled with CFR 0.152.
 */
package kafka.testkit;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kafka.testkit.BrokerNode;
import kafka.testkit.ControllerNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;

public class TestKitNodes {
    private final String baseDirectory;
    private final Uuid clusterId;
    private final BootstrapMetadata bootstrapMetadata;
    private final NavigableMap<Integer, ControllerNode> controllerNodes;
    private final NavigableMap<Integer, BrokerNode> brokerNodes;

    private TestKitNodes(String baseDirectory, Uuid clusterId, BootstrapMetadata bootstrapMetadata, NavigableMap<Integer, ControllerNode> controllerNodes, NavigableMap<Integer, BrokerNode> brokerNodes) {
        this.baseDirectory = baseDirectory;
        this.clusterId = clusterId;
        this.bootstrapMetadata = bootstrapMetadata;
        this.controllerNodes = controllerNodes;
        this.brokerNodes = brokerNodes;
    }

    public boolean isCombined(int node) {
        return this.controllerNodes.containsKey(node) && this.brokerNodes.containsKey(node);
    }

    public String baseDirectory() {
        return this.baseDirectory;
    }

    public Uuid clusterId() {
        return this.clusterId;
    }

    public MetadataVersion bootstrapMetadataVersion() {
        return this.bootstrapMetadata.metadataVersion();
    }

    public Map<Integer, ControllerNode> controllerNodes() {
        return this.controllerNodes;
    }

    public BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    public NavigableMap<Integer, BrokerNode> brokerNodes() {
        return this.brokerNodes;
    }

    public ListenerName interBrokerListenerName() {
        return new ListenerName("EXTERNAL");
    }

    public ListenerName externalListenerName() {
        return new ListenerName("EXTERNAL");
    }

    public ListenerName controllerListenerName() {
        return new ListenerName("CONTROLLER");
    }

    public static class Builder {
        private boolean combined = false;
        private Uuid clusterId = null;
        private BootstrapMetadata bootstrapMetadata = BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.latestTesting(), (String)"testkit", (boolean)false);
        private final NavigableMap<Integer, ControllerNode.Builder> controllerNodeBuilders = new TreeMap<Integer, ControllerNode.Builder>();
        private final NavigableMap<Integer, BrokerNode.Builder> brokerNodeBuilders = new TreeMap<Integer, BrokerNode.Builder>();

        public Builder setClusterId(Uuid clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder setBootstrapMetadataVersion(MetadataVersion metadataVersion) {
            this.bootstrapMetadata = BootstrapMetadata.fromVersion((MetadataVersion)metadataVersion, (String)"test", (boolean)false);
            return this;
        }

        public Builder setBootstrapMetadata(BootstrapMetadata bootstrapMetadata) {
            this.bootstrapMetadata = bootstrapMetadata;
            return this;
        }

        public Builder setCombined(boolean combined) {
            this.combined = combined;
            return this;
        }

        public Builder setNumControllerNodes(int numControllerNodes) {
            if (numControllerNodes < 0) {
                throw new RuntimeException("Invalid negative value for numControllerNodes");
            }
            while (this.controllerNodeBuilders.size() > numControllerNodes) {
                this.controllerNodeBuilders.pollFirstEntry();
            }
            while (this.controllerNodeBuilders.size() < numControllerNodes) {
                int nextId = this.startControllerId();
                if (!this.controllerNodeBuilders.isEmpty()) {
                    nextId = (Integer)this.controllerNodeBuilders.lastKey() + 1;
                }
                this.controllerNodeBuilders.put(nextId, new ControllerNode.Builder().setId(nextId));
            }
            return this;
        }

        public Builder setNumBrokerNodes(int numBrokerNodes) {
            return this.setBrokerNodes(numBrokerNodes, 1);
        }

        public Builder setBrokerNodes(int numBrokerNodes, int disksPerBroker) {
            if (numBrokerNodes < 0) {
                throw new RuntimeException("Invalid negative value for numBrokerNodes");
            }
            if (disksPerBroker <= 0) {
                throw new RuntimeException("Invalid value for disksPerBroker");
            }
            while (this.brokerNodeBuilders.size() > numBrokerNodes) {
                this.brokerNodeBuilders.pollFirstEntry();
            }
            while (this.brokerNodeBuilders.size() < numBrokerNodes) {
                int nextId = this.startBrokerId();
                if (!this.brokerNodeBuilders.isEmpty()) {
                    nextId = (Integer)this.brokerNodeBuilders.lastKey() + 1;
                }
                BrokerNode.Builder brokerNodeBuilder = new BrokerNode.Builder().setId(nextId).setNumLogDirectories(disksPerBroker);
                this.brokerNodeBuilders.put(nextId, brokerNodeBuilder);
            }
            return this;
        }

        public TestKitNodes build() {
            String baseDirectory = TestUtils.tempDirectory().getAbsolutePath();
            try {
                if (this.clusterId == null) {
                    this.clusterId = Uuid.randomUuid();
                }
                TreeMap<Integer, ControllerNode> controllerNodes = new TreeMap<Integer, ControllerNode>();
                for (ControllerNode.Builder builder : this.controllerNodeBuilders.values()) {
                    ControllerNode node = builder.build(baseDirectory, this.clusterId, this.brokerNodeBuilders.containsKey(builder.id()));
                    if (controllerNodes.put(node.id(), node) == null) continue;
                    throw new RuntimeException("Duplicate builder for controller " + node.id());
                }
                TreeMap<Integer, BrokerNode> brokerNodes = new TreeMap<Integer, BrokerNode>();
                for (BrokerNode.Builder builder : this.brokerNodeBuilders.values()) {
                    BrokerNode node = builder.build(baseDirectory, this.clusterId, this.controllerNodeBuilders.containsKey(builder.id()));
                    if (brokerNodes.put(node.id(), node) == null) continue;
                    throw new RuntimeException("Duplicate builder for broker " + node.id());
                }
                return new TestKitNodes(baseDirectory, this.clusterId, this.bootstrapMetadata, controllerNodes, brokerNodes);
            }
            catch (Exception e) {
                try {
                    Files.delete(Paths.get(baseDirectory, new String[0]));
                }
                catch (Exception x) {
                    throw new RuntimeException("Failed to delete base directory " + baseDirectory, x);
                }
                throw e;
            }
        }

        private int startBrokerId() {
            return 0;
        }

        private int startControllerId() {
            if (this.combined) {
                return this.startBrokerId();
            }
            return this.startBrokerId() + 3000;
        }
    }
}

