/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.TierLogSegment;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.state.BaseTierStateTest;
import kafka.tier.store.TierObjectStore;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Tag(value="bazel:shard_count:6")
@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001B\u0006\r\u0001EAQ\u0001\u0007\u0001\u0005\u0002eAQ\u0001\b\u0001\u0005BuAQ\u0001\n\u0001\u0005B\u0015BQa\r\u0001\u0005\u0002QBQ!\u0018\u0001\u0005\u0002yCQ!\u001a\u0001\u0005\u0002\u0019DQa\u001b\u0001\u0005\u00021DQ!\u001d\u0001\u0005\u0002IDQa\u001e\u0001\u0005\u0002aDQ! \u0001\u0005\u0002y\u0014a\u0003R5tC\ndW\rV5feN#xN]1hKR+7\u000f\u001e\u0006\u0003\u001b9\tA\u0001^5fe*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"BA\u000b\r\u0003\u0015\u0019H/\u0019;f\u0013\t9BCA\tCCN,G+[3s'R\fG/\u001a+fgR\fa\u0001P5oSRtD#\u0001\u000e\u0011\u0005m\u0001Q\"\u0001\u0007\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t\u0019\u0011J\u001c;\u0002/\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001cHC\u0001\u0014*!\tyr%\u0003\u0002)A\t!QK\\5u\u0011\u0015Q3\u00011\u0001,\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0003YEj\u0011!\f\u0006\u0003]=\nA!\u001e;jY*\t\u0001'\u0001\u0003kCZ\f\u0017B\u0001\u001a.\u0005)\u0001&o\u001c9feRLWm]\u0001*i\u0016\u001cHOR3uG\"\u0014V-];fgR<\u0016\u000e\u001e5US\u0016\u0014X\rZ*u_J\fw-\u001a#jg\u0006\u0014G.\u001a3\u0015\u0005\u0019*\u0004\"\u0002\u001c\u0005\u0001\u00049\u0014AB9v_J,X\u000e\u0005\u00029\u007f9\u0011\u0011(\u0010\t\u0003u\u0001j\u0011a\u000f\u0006\u0003yA\ta\u0001\u0010:p_Rt\u0014B\u0001 !\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\u0002\u0003\u0006\u0002\u0003D\u001fB\u0003\"\u0001R'\u000e\u0003\u0015S!AR$\u0002\rA\f'/Y7t\u0015\tA\u0015*A\u0004kkBLG/\u001a:\u000b\u0005)[\u0015!\u00026v]&$(\"\u0001'\u0002\u0007=\u0014x-\u0003\u0002O\u000b\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002#\u0006\u00113\u0010Z5ta2\f\u0017PT1nKvt30\u0019:hk6,g\u000e^:XSRDg*Y7fgvDC\u0001B*Z5B\u0011AkV\u0007\u0002+*\u0011a+R\u0001\taJ|g/\u001b3fe&\u0011\u0001,\u0016\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0003m\u000b\u0013\u0001X\u0001\u0003u.\f!\u0006^3ti\u0006#GMT3x%\u0016\u0004H.[2b/&$\b\u000eV5fe\u0016$7\u000b^8sC\u001e,G)[:bE2,G\r\u0006\u0002'?\")a'\u0002a\u0001o!\"QaQ(QQ\u0011)1+\u00172-\u0005m\u001b\u0017%\u00013\u0002\u000b-\u0014\u0018M\u001a;\u0002QQ,7\u000f\u001e*fa2L7-\u0019;j_:<\u0016\u000e\u001e5US\u0016\u0014X\rZ*u_J\fw-\u001a#jg\u0006\u0014G.\u001a3\u0015\u0005\u0019:\u0007\"\u0002\u001c\u0007\u0001\u00049\u0004\u0006\u0002\u0004D\u001fBCCAB*ZU2\u00121lY\u0001)i\u0016\u001cH\u000fR3mKR,Gk\u001c9jG^KG\u000f\u001b+jKJ,Gm\u0015;pe\u0006<W\rR5tC\ndW\r\u001a\u000b\u0003M5DQAN\u0004A\u0002]BCaB\"P!\"\"qaU-qY\tY6-A\u0015uKN$Hj\\4SKR,g\u000e^5p]^KG\u000f\u001b+jKJ,Gm\u0015;pe\u0006<W\rR5tC\ndW\r\u001a\u000b\u0003MMDQA\u000e\u0005A\u0002]BC\u0001C\"P!\"\"\u0001bU-wY\tY6-\u0001!uKN$Hj\\4SKR,g\u000e^5p]\u00063G/\u001a:US\u0016\u0014X\r\u001a#bi\u0006L5\u000fR3mKR,G-\u00118e)&,'/\u001a3Ti>\u0014\u0018mZ3ESN\f'\r\\3e)\t1\u0013\u0010C\u00037\u0013\u0001\u0007q\u0007\u000b\u0003\n\u0007>\u0003\u0006\u0006B\u0005T3rd#aW2\u0002gQ,7\u000f\u001e#fY\u0016$\u0018n\u001c8UCN\\7\u000b^1uK6\u000b7\r[5oK^CWM\u001c+jKJ\u001cFo\u001c:bO\u0016$\u0015n]1cY\u0016$GC\u0001\u0014\u0000\u0011\u00151$\u00021\u00018Q\u0011Q1i\u0014))\u000b)\u0019\u0016,!\u0002-\u0005m\u001b\u0007f\u0002\u0001\u0002\n\u0005U\u0011q\u0003\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB$\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002\u0014\u00055!a\u0001+bO\u0006)a/\u00197vK\u0006\u0012\u0011\u0011D\u0001\u0014E\u0006TX\r\u001c\u001etQ\u0006\u0014HmX2pk:$(H\u000e")
public class DisableTierStorageTest
extends BaseTierStateTest {
    @Override
    public int brokerCount() {
        return 5;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        super.brokerPropertyOverrides(properties);
        properties.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testFetchRequestWithTieredStorageDisabled(String quorum) {
        void var4_4;
        void var3_3;
        Tuple2<Object, Object> tuple2 = this.createTopicAndGetReplicas();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int replica1 = tuple2._1$mcI$sp();
        int replica2 = tuple2._2$mcI$sp();
        this.appendMessagesAndWaitUntilTieredAndSynced((int)var3_3, (int)var4_4);
        this.waitForHotSetRetentionToKickIn((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{var3_3, var4_4}))));
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Fetch with tier enabled");
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        AbstractLog leaderLog = (AbstractLog)((KafkaBroker)this.brokerForId((int)var3_3).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 30000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testFetchRequestWithTieredStorageDisabled$2(leaderLog)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for tiered storage to be turned off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Fetch with tier disabled");
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
        this.switchLeader((int)var3_3, (int)var4_4);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Fetch with tier disabled and new leader elected");
        this.fetchTieredAndLocalDataAndValidate((int)var4_4, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        this.switchLeader((int)var4_4, (int)var3_3);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Fetch with tier disabled and new leader elected (that has since been rolled)");
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAddNewReplicaWithTieredStorageDisabled(String quorum) {
        void var3_3;
        Tuple2<Object, Object> tuple2 = this.createTopicAndGetReplicas();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int replica1 = tuple2._1$mcI$sp();
        this.appendMessagesToLeaderAndWaitUntilTiered((int)var3_3, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId((int)var3_3).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$1(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$2(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int replica3 = this.addReplicaToAssignment((int)var3_3);
        this.waitForReplicaToGetInSync((int)var3_3, replica3);
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$3(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for tiered storage to be turned off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        int replica4 = this.addReplicaToAssignment((int)var3_3);
        this.waitForReplicaToGetInSync((int)var3_3, replica4);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testReplicationWithTieredStorageDisabled(String quorum) {
        Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topicName(), 1, 3, this.props(), this.createTopic$default$5(), this.createTopic$default$6());
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        int replica1 = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)this.topicPartition().partition())));
        Seq followers = (Seq)((KafkaBroker)this.brokerForId(replica1).get()).replicaManager().getPartitionOrException(this.topicPartition()).assignmentState().replicas().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 != replica1);
        followers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)follower -> this.killBroker(follower));
        this.appendMessagesToLeaderAndWaitUntilTiered(replica1, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(replica1).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$3(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$4(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.restartDeadBroker(BoxesRunTime.unboxToInt((Object)followers.head()), this.restartDeadBroker$default$2());
        this.waitForReplicaToGetInSync(replica1, BoxesRunTime.unboxToInt((Object)followers.head()));
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$5(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for tiered storage to be turned off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.restartDeadBroker(BoxesRunTime.unboxToInt((Object)followers.apply(1)), this.restartDeadBroker$default$2());
        this.waitForReplicaToGetInSync(replica1, BoxesRunTime.unboxToInt((Object)followers.apply(1)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteTopicWithTieredStorageDisabled(String quorum) {
        String topic1 = "foo";
        String topic2 = "bar";
        TopicPartition topicPartition1 = new TopicPartition(topic1, 0);
        TopicPartition topicPartition2 = new TopicPartition(topic2, 0);
        int topic1LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic1, 1, 1, this.props(), this.createTopic$default$5(), this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(topicPartition1);
        AbstractLog topic1Log = (AbstractLog)((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().getLog(topicPartition1).get();
        int topic2LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic2, 1, 1, this.props(), this.createTopic$default$5(), this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(topicPartition2);
        AbstractLog topic2Log = (AbstractLog)((KafkaBroker)this.brokerForId(topic2LeaderId).get()).replicaManager().getLog(topicPartition2).get();
        int numMessages = 100;
        int n = 0;
        while (topic1Log.numberOfSegments() <= 3) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), topic1, numMessages, -1);
            n += numMessages;
        }
        int n2 = 0;
        while (topic2Log.numberOfSegments() <= 3) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), topic2, numMessages, -1);
            n2 += numMessages;
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(topic1Log.logEndOffset() == (long)n && this.tierLogSegments(topic1Log).size() >= topic1Log.numberOfSegments() - 1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting for all messages to be written and tiered");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 60000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!(topic2Log.logEndOffset() == (long)n2 && this.tierLogSegments(topic2Log).size() >= topic2Log.numberOfSegments() - 1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timeout waiting for all messages to be written and tiered");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        List<TierLogSegment> tieredSegments1 = this.tierLogSegments(topic1Log);
        List<TierLogSegment> tieredSegments2 = this.tierLogSegments(topic2Log);
        ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        DeleteTopicsResult future1 = adminClient.deleteTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJavaCollection());
        this.changeTopicConfig("confluent.tier.enable", "false", topic2);
        long l3 = 200L;
        long waitUntilTrue_waitTimeMs3 = 30000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$5(topic2Log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timed out waiting for tiered storage to be turned off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        DeleteTopicsResult future2 = adminClient.deleteTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJavaCollection());
        future1.all().get(30000L, TimeUnit.MILLISECONDS);
        future2.all().get(30000L, TimeUnit.MILLISECONDS);
        TierObjectStore objStore = (TierObjectStore)((KafkaBroker)this.brokerForId(topic1LeaderId).get()).tierObjectStoreOpt().get();
        this.verifyTieredSegmentsDeleted(topic1, objStore, tieredSegments1);
        this.verifyTieredSegmentsDeleted(topic2, objStore, tieredSegments2);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLogRetentionWithTieredStorageDisabled(String quorum) {
        int numMessages = 100;
        ObjectRef topic = ObjectRef.create((Object)"");
        ((IterableOps)new .colon.colon((Object)"false", (List)new .colon.colon((Object)"true", (List)Nil$.MODULE$)).zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$2(this, topic, numMessages, x$3);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled(String quorum) {
        int numMessages = 100;
        int leaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topicName(), 1, 1, this.props(), this.createTopic$default$5(), this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        LogManager qual$1 = ((KafkaBroker)this.brokerForId(leaderId).get()).logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(x$1, x$2).get();
        while (log.numberOfSegments() < 4) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, -1);
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 30000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$1(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for segments to be tiered and deleted from local storage");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.changeTopicConfig("confluent.tier.enable", "false", this.topicName());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$3(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for tiering to disable");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long currentNumMessages = log.logEndOffset();
        long lastTieredOffset = log.tierPartitionState().endOffset();
        String desiredRetentionSizeBytes = Long.toString(log.size());
        while (log.logEndOffset() < currentNumMessages * 3L) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, -1);
        }
        List segmentsNotTiered = CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments(lastTieredOffset + 1L, log.logEndOffset())).asScala().toList();
        this.changeTopicConfig("retention.bytes", desiredRetentionSizeBytes, this.topicName());
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 30000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$5(log, segmentsNotTiered)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timed out waiting for retention to delete some local segments");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 30000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$7(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$8(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 60000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$9(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"FirstTieredOffset is defined after all tiered segments are deleted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeletionTaskStateMachineWhenTierStorageDisabled(String quorum) {
        this.props().put("retention.bytes", "-1");
        this.props().put("retention.ms", "-1");
        int leaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topicPartition().topic(), 1, 1, this.props(), this.createTopic$default$5(), this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(this.topicPartition()).get();
        TierObjectStore objStore = (TierObjectStore)((KafkaBroker)this.brokerForId(leaderId).get()).tierObjectStoreOpt().get();
        this.appendMessagesToLeaderAndWaitUntilTiered(leaderId, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 10000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$1(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for tiered storage to be turned off");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        List<TierLogSegment> tieredSegments = this.tierLogSegments(log);
        this.changeTopicConfig("retention.ms", "100", this.changeTopicConfig$default$3());
        this.verifyTieredSegmentsDeleted(this.topicPartition().topic(), objStore, tieredSegments);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 10000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$3(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for all tiered segments to delete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestWithTieredStorageDisabled$2(AbstractLog leaderLog$1) {
        return !leaderLog$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testFetchRequestWithTieredStorageDisabled$3() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testAddNewReplicaWithTieredStorageDisabled$1(AbstractLog log$1) {
        return log$1.logStartOffset() < log$1.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testAddNewReplicaWithTieredStorageDisabled$2(AbstractLog log$1) {
        return new StringBuilder(88).append("Timed out waiting for hot set retention to kick in logStartOffset: ").append(log$1.logStartOffset()).append(" localLogStartOffset ").append(log$1.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAddNewReplicaWithTieredStorageDisabled$3(AbstractLog log$1) {
        return !log$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testAddNewReplicaWithTieredStorageDisabled$4() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicationWithTieredStorageDisabled$3(AbstractLog log$2) {
        return log$2.logStartOffset() < log$2.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testReplicationWithTieredStorageDisabled$4(AbstractLog log$2) {
        return new StringBuilder(88).append("Timed out waiting for hot set retention to kick in logStartOffset: ").append(log$2.logStartOffset()).append(" localLogStartOffset ").append(log$2.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicationWithTieredStorageDisabled$5(AbstractLog log$2) {
        return !log$2.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testReplicationWithTieredStorageDisabled$6() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicWithTieredStorageDisabled$1(DisableTierStorageTest $this, AbstractLog topic1Log$1, IntRef totalMessages1$1) {
        return topic1Log$1.logEndOffset() == (long)totalMessages1$1.elem && $this.tierLogSegments(topic1Log$1).size() >= topic1Log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicWithTieredStorageDisabled$2() {
        return "Timeout waiting for all messages to be written and tiered";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicWithTieredStorageDisabled$3(DisableTierStorageTest $this, AbstractLog topic2Log$1, IntRef totalMessages2$1) {
        return topic2Log$1.logEndOffset() == (long)totalMessages2$1.elem && $this.tierLogSegments(topic2Log$1).size() >= topic2Log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicWithTieredStorageDisabled$4() {
        return "Timeout waiting for all messages to be written and tiered";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicWithTieredStorageDisabled$5(AbstractLog topic2Log$1) {
        return !topic2Log$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicWithTieredStorageDisabled$6() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$4(Partition partition$1) {
        return partition$1.log().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$5(Partition partition$1) {
        return new StringBuilder(34).append("log did not resolve for partition ").append(partition$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$6(Partition partition$1) {
        return ((AbstractLog)partition$1.log().get()).tierPartitionState().numSegments() >= ((AbstractLog)partition$1.log().get()).numberOfSegments() - 1 && ((AbstractLog)partition$1.log().get()).localLogStartOffset() > Predef$.MODULE$.Long2long((Long)((AbstractLog)partition$1.log().get()).tierPartitionState().startOffset().get());
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$7() {
        return "Timed out waiting for segments to be tiered and deleted from local storage";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$8(Partition partition$1) {
        return !((AbstractLog)partition$1.log().get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$9() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$10(LongRef expectedLogStartOffset$1, Partition partition$1) {
        return expectedLogStartOffset$1.elem == partition$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$11(Partition partition$1, LongRef expectedLogStartOffset$1) {
        return new StringBuilder(46).append("Unexpected log start offset: ").append(partition$1.logStartOffset()).append(" Expected value: ").append(expectedLogStartOffset$1.elem).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testLogRetentionWithTieredStorageDisabled$2(DisableTierStorageTest $this, ObjectRef topic$1, int numMessages$1, Tuple2 x$3) {
        if (x$3 != null) {
            long l;
            long retentionSizeBytes;
            String configVal = (String)x$3._1();
            int index = x$3._2$mcI$sp();
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Testing topic created with config.TierEnable = ").append(configVal).toString());
            $this.props().put("confluent.tier.enable", configVal);
            topic$1.elem = new StringBuilder(1).append($this.topicName()).append("-").append(index).toString();
            int leaderId = BoxesRunTime.unboxToInt((Object)$this.createTopic((String)topic$1.elem, 1, 1, $this.props(), $this.createTopic$default$5(), $this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
            $this.waitUntilLogCreatedOnBrokers((String)topic$1.elem, 0);
            Partition partition = ((KafkaBroker)$this.brokerForId(leaderId).get()).replicaManager().getPartitionOrException(new TopicPartition((String)topic$1.elem, 0));
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$4(partition)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$5(partition));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            while (((AbstractLog)partition.log().get()).numberOfSegments() < 4) {
                TestUtils$.MODULE$.generateAndProduceMessages($this.brokers().toSeq(), (String)topic$1.elem, numMessages$1, -1);
            }
            String string = configVal;
            String string2 = "true";
            if (string != null && string.equals(string2)) {
                long l3 = 100L;
                long waitUntilTrue_waitTimeMs2 = 30000L;
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$6(partition)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                        Assertions.fail((String)"Timed out waiting for segments to be tiered and deleted from local storage");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
                }
                $this.changeTopicConfig("confluent.tier.enable", "false", (String)topic$1.elem);
                long l4 = 100L;
                long waitUntilTrue_waitTimeMs3 = 30000L;
                long waitUntilTrue_startTime3 = System.currentTimeMillis();
                while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$8(partition)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                        Assertions.fail((String)"Timed out waiting for tiering to disable");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
                }
                List<TierLogSegment> tieredSegments = $this.tierLogSegments((AbstractLog)partition.log().get());
                retentionSizeBytes = ((AbstractLog)partition.log().get()).size() - (long)(((TierLogSegment)tieredSegments.head()).size() + 1);
                l = ((TierLogSegment)tieredSegments.apply(1)).baseOffset();
            } else {
                retentionSizeBytes = ((AbstractLog)partition.log().get()).size() - (long)(((LogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(((AbstractLog)partition.log().get()).localLogSegments()).asScala().head()).size() + 1);
                l = ((LogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(((AbstractLog)partition.log().get()).localLogSegments()).asScala().toList().apply(1)).baseOffset();
            }
            $this.changeTopicConfig("retention.bytes", Long.toString(retentionSizeBytes), (String)topic$1.elem);
            long l5 = 10L;
            long waitUntilTrue_waitTimeMs4 = 60000L;
            long waitUntilTrue_startTime4 = System.currentTimeMillis();
            while (!(l == partition.logStartOffset())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                    Assertions.fail((String)new StringBuilder(46).append("Unexpected log start offset: ").append(partition.logStartOffset()).append(" Expected value: ").append(l).toString());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$1(AbstractLog log$3) {
        return log$3.tierPartitionState().numSegments() >= log$3.numberOfSegments() - 1 && log$3.localLogStartOffset() > Predef$.MODULE$.Long2long((Long)log$3.tierPartitionState().startOffset().get());
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$2() {
        return "Timed out waiting for segments to be tiered and deleted from local storage";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$3(AbstractLog log$3) {
        return !log$3.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$4() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$5(AbstractLog log$3, List segmentsNotTiered$1) {
        return log$3.logStartOffset() >= ((LogSegment)segmentsNotTiered$1.apply(1)).baseOffset();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$6() {
        return "Timed out waiting for retention to delete some local segments";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$7(AbstractLog log$3) {
        return log$3.localLogStartOffset() == log$3.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$8(AbstractLog log$3) {
        return new StringBuilder(39).append("LogStartOffset ").append(log$3.logStartOffset()).append(" != localLogStartOffset ").append(log$3.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$9(AbstractLog log$3) {
        return !log$3.tierPartitionState().startOffset().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$10() {
        return "FirstTieredOffset is defined after all tiered segments are deleted";
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$1(AbstractLog log$4) {
        return !log$4.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$2() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$3(AbstractLog log$4) {
        return log$4.tierPartitionState().numSegments() == 0;
    }

    public static final /* synthetic */ String $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$4() {
        return "Timed out waiting for all tiered segments to delete";
    }
}

