/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.job.BrokerAuditJob;
import kafka.durability.audit.manager.BrokerAuditManager;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.utils.DurabilityTierTopicReader;
import kafka.durability.utils.TierTopicEvents;
import kafka.durability.utils.TierTopicEvents$;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005R1BQa\r\u0001\u0005\nQBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004C\u0001\u0001\u0006IA\u000f\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003-\u0011\u0019!\u0005\u0001)A\u0005[!9Q\t\u0001b\u0001\n\u0013a\u0003B\u0002$\u0001A\u0003%Q\u0006C\u0004H\u0001\u0001\u0007I\u0011\u0002\u0017\t\u000f!\u0003\u0001\u0019!C\u0005\u0013\"1A\n\u0001Q!\n5Bq!\u0014\u0001C\u0002\u0013%a\n\u0003\u0004X\u0001\u0001\u0006Ia\u0014\u0005\u00061\u0002!I!\u0017\u0005\bc\u0002\u0011\r\u0011\"\u0001s\u0011\u0019i\b\u0001)A\u0005g\")a\u0010\u0001C!\u007f\"1\u0011q\u0004\u0001\u0005BQBq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002n\u0001!I!a\u001c\t\u000f\u00055\u0004\u0001\"\u0003\u0002v!1\u0011q\u0011\u0001\u0005\nQBq!!#\u0001\t\u0013\tY\tC\u0004\u0002\u0012\u0002!I!a%\u00039\u0011+(/\u00192jY&$\u0018\u0010V5fe\u000e{W\u000e]1di&|g\u000eV3ti*\u0011A$H\u0001\u0005i&,'OC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011j\u0012aA1qS&\u0011ae\t\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012!\u000b\t\u0003U\u0001i\u0011aG\u0001\fEJ|7.\u001a:D_VtG/F\u0001.!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\rIe\u000e^\u0001\u000eG>tg-[4ve\u0016lunY6\u0015\u0003U\u0002\"A\f\u001c\n\u0005]z#\u0001B+oSR\fQ\u0001^8qS\u000e,\u0012A\u000f\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nA\u0001\\1oO*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n!\u0002]1si&$\u0018n\u001c8t\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\u0002\u001b5\f\u0007PT;n%\u0016\u001cwN\u001d3t\u00039i\u0017\r\u001f(v[J+7m\u001c:eg\u0002\n!C\\;n!J|G-^2fIJ+7m\u001c:eg\u00061b.^7Qe>$WoY3e%\u0016\u001cwN\u001d3t?\u0012*\u0017\u000f\u0006\u00026\u0015\"91jCA\u0001\u0002\u0004i\u0013a\u0001=%c\u0005\u0019b.^7Qe>$WoY3e%\u0016\u001cwN\u001d3tA\u0005y\u0001O]8ek\u000e,GMU3d_J$7/F\u0001P!\u0011\u0001V+L\u0017\u000e\u0003ES!AU*\u0002\u000f5,H/\u00192mK*\u0011AkL\u0001\u000bG>dG.Z2uS>t\u0017B\u0001,R\u0005\ri\u0015\r]\u0001\u0011aJ|G-^2fIJ+7m\u001c:eg\u0002\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u000b\u00025B\u00191l\u00194\u000f\u0005q\u000bgBA/a\u001b\u0005q&BA0 \u0003\u0019a$o\\8u}%\t\u0001'\u0003\u0002c_\u00059\u0001/Y2lC\u001e,\u0017B\u00013f\u0005\r\u0019V-\u001d\u0006\u0003E>\u0002\"aZ8\u000e\u0003!T!!\u001b6\u0002\r\r|W.\\8o\u0015\tq2N\u0003\u0002m[\u00061\u0011\r]1dQ\u0016T\u0011A\\\u0001\u0004_J<\u0017B\u00019i\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fa!\u001a=ji\u0016$W#A:\u0011\u0005Q\\X\"A;\u000b\u0005Y<\u0018AB1u_6L7M\u0003\u0002ys\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005it\u0014\u0001B;uS2L!\u0001`;\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003\u001d)\u00070\u001b;fI\u0002\nQa]3u+B$2!NA\u0001\u0011\u001d\t\u0019A\u0005a\u0001\u0003\u000b\t\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003\u000f\t\u0019\"\u0004\u0002\u0002\n)\u0019A%a\u0003\u000b\t\u00055\u0011qB\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\t\"\\\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003+\tIA\u0001\u0005UKN$\u0018J\u001c4pQ\r\u0011\u0012\u0011\u0004\t\u0005\u0003\u000f\tY\"\u0003\u0003\u0002\u001e\u0005%!A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\u0014\u0003G\u0001B!a\u0002\u0002&%!\u0011qEA\u0005\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\fuKN$h)\u001b7uKJ\u001cu.\u001c9bGR,e/\u001a8ugR\u0019Q'!\f\t\u000f\u0005=B\u00031\u0001\u00022\u00051\u0011/^8sk6\u0004B!a\r\u0002<9!\u0011QGA\u001c!\tiv&C\u0002\u0002:=\na\u0001\u0015:fI\u00164\u0017bA!\u0002>)\u0019\u0011\u0011H\u0018)\u000fQ\t\t%!\u0014\u0002PA!\u00111IA%\u001b\t\t)E\u0003\u0003\u0002H\u0005-\u0011A\u00029be\u0006l7/\u0003\u0003\u0002L\u0005\u0015#!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\t\t&\u0001\u0012|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018|CJ<W/\\3oiN<\u0016\u000e\u001e5OC6,7/ \u0015\b)\u0005U\u0013\u0011MA2!\u0011\t9&!\u0018\u000e\u0005\u0005e#\u0002BA.\u0003\u000b\n\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003?\nIFA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003K\nI'\t\u0002\u0002h\u0005\u0011!p[\u0011\u0003\u0003W\nQa\u001b:bMR\f1\u0003\u001d:pIV\u001cWmS3zK\u0012\u0014VmY8sIN$2!NA9\u0011\u0019\t\u0019(\u0006a\u0001[\u0005Qa.^7SK\u000e|'\u000fZ:\u0015\u0007U\n9\bC\u0004\u0002zY\u0001\r!a\u001f\u0002\u0013-,\u0017PV1mk\u0016\u001c\b#B.\u0002~\u0005\u0005\u0015bAA@K\n!A*[:u!\u0015q\u00131Q\u0017.\u0013\r\t)i\f\u0002\u0007)V\u0004H.\u001a\u001a\u0002G]\f\u0017\u000e^+oi&d7+Z4nK:$8\u000fV5fe\u0016$\u0017I\u001c3D_6\u0004\u0018m\u0019;fI\u0006Ab/\u001a:jMf\u001cu.\\7ji\u0006sGmU<ba\u00163XM\u001c;\u0015\u0007U\ni\t\u0003\u0004\u0002\u0010b\u0001\rAZ\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0003-\u0011XO\\!vI&$(j\u001c2\u0015\u0007U\n)\nC\u0004\u0002\u0018f\u0001\r!!'\u0002%Q|\u0007/[2QCJ$\u0018\u000e^5p]&sgm\u001c\t\u00057\u000e\fY\n\u0005\u0004/\u0003\u00073\u0017Q\u0014\t\u0004]\u0005}\u0015bAAQ_\t!Aj\u001c8h\u0001")
public class DurabilityTierCompactionTest
extends IntegrationTestHarness {
    private final String topic;
    private final int partitions;
    private final int maxNumRecords;
    private int numProducedRecords;
    private final Map<Object, Object> producedRecords;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 1;
    }

    private void configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private int maxNumRecords() {
        return this.maxNumRecords;
    }

    private int numProducedRecords() {
        return this.numProducedRecords;
    }

    private void numProducedRecords_$eq(int x$1) {
        this.numProducedRecords = x$1;
    }

    private Map<Object, Object> producedRecords() {
        return this.producedRecords;
    }

    private Seq<TopicPartition> topicPartitions() {
        return package$.MODULE$.Range().apply(0, this.partitions()).map((Function1 & Serializable)p -> DurabilityTierCompactionTest.$anonfun$topicPartitions$1(this, BoxesRunTime.unboxToInt((Object)p)));
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
        this.numProducedRecords_$eq(0);
        this.producedRecords().clear();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.numProducedRecords_$eq(0);
        this.producedRecords().clear();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFilterCompactEvents(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.createTopic(this.topic(), this.partitions(), 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        this.verifyCommitAndSwapEvent(topicPartition);
        long config = ConfigFlag$.MODULE$.OnceCompacted().id();
        this.runAuditJob((Seq<Tuple2<TopicPartition, Object>>)new .colon.colon((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)config)), (List)Nil$.MODULE$));
    }

    private void produceKeyedRecords(int numRecords) {
        Random random = new Random();
        List keyValues = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).toList().map((Function1 & Serializable)i -> DurabilityTierCompactionTest.$anonfun$produceKeyedRecords$1(this, random, BoxesRunTime.unboxToInt((Object)i)));
        this.produceKeyedRecords((List<Tuple2<Object, Object>>)keyValues);
        this.numProducedRecords_$eq(this.numProducedRecords() + numRecords);
    }

    private void produceKeyedRecords(List<Tuple2<Object, Object>> keyValues) {
        try (KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());){
            keyValues.grouped(10).foreach((Function1 & Serializable)group -> group.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int k = x0$1._1$mcI$sp();
                    int v = x0$1._2$mcI$sp();
                    this.producedRecords().put((Object)BoxesRunTime.boxToInteger((int)k), (Object)BoxesRunTime.boxToInteger((int)v));
                    long timestamp = System.currentTimeMillis();
                    return new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(timestamp), (Object)Integer.toString(k).getBytes(StandardCharsets.UTF_8), (Object)Integer.toString(v).getBytes(StandardCharsets.UTF_8));
                }
                throw new MatchError(null);
            }).map((Function1 & Serializable)x$1 -> producer.send(x$1)).map((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS)));
        }
    }

    private void waitUntilSegmentsTieredAndCompacted() {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            DurabilityTierCompactionTest.$anonfun$waitUntilSegmentsTieredAndCompacted$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Unable to fully structure code
     */
    private void verifyCommitAndSwapEvent(TopicPartition topicPartition) {
        brokerId = 0;
        broker = (KafkaBroker)this.brokerForId(brokerId).get();
        qual$1 = broker.logManager();
        x$2 = qual$1.getLog$default$2();
        topicId = (Uuid)((AbstractLog)qual$1.getLog(topicPartition, x$2).get()).topicId().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$verifyCommitAndSwapEvent$1(), ()Lorg/apache/kafka/common/Uuid;)());
        topicIdPartition = new TopicIdPartition(topicPartition.topic(), new UUID(topicId.getMostSignificantBits(), topicId.getLeastSignificantBits()), topicPartition.partition());
        auditManager = (BrokerAuditManager)broker.auditManager().get();
        var17_9 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)BoxesRunTime.boxToLong((long)DurabilityAuditConstants$.MODULE$.TIER_TOPIC_INITIAL_SEEK()))}));
        var16_10 = new CountDownLatch(1);
        apply_config = auditManager.config();
        var15_11 = null;
        var16_10 = null;
        var17_9 = null;
        eventFromStart = new DurabilityTierTopicReader(apply_config, (CountDownLatch)apply_onCompleteSignaller, (scala.collection.immutable.Map)apply_topicPartitionsMap).retrieveTierRecords();
        Assertions.assertTrue((boolean)eventFromStart.contains((Object)topicIdPartition), (String)"Expected non-zero events");
        topicEvents1 = (TierTopicEvents)eventFromStart.getOrElse((Object)topicIdPartition, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$verifyCommitAndSwapEvent$2(), ()Lkafka/durability/utils/TierTopicEvents;)());
        Assertions.assertTrue((boolean)(topicEvents1.uploadMessages().nonEmpty() != false && topicEvents1.uploadInitMessages().nonEmpty() != false && topicEvents1.commitAndSwapMessages().nonEmpty() != false), (String)"Expected non-zero events");
        var20_14 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        var19_15 = new CountDownLatch(1);
        apply_config = auditManager.config();
        var18_16 = null;
        var19_15 = null;
        var20_14 = null;
        Assertions.assertTrue((boolean)new DurabilityTierTopicReader(apply_config, (CountDownLatch)apply_onCompleteSignaller, (scala.collection.immutable.Map)apply_topicPartitionsMap).retrieveTierRecords().contains((Object)topicIdPartition), (String)"Expected non-zero events");
        topicEvents2 = (TierTopicEvents)eventFromStart.getOrElse((Object)topicIdPartition, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$verifyCommitAndSwapEvent$3(), ()Lkafka/durability/utils/TierTopicEvents;)());
        Assertions.assertTrue((boolean)(topicEvents2.uploadMessages().nonEmpty() != false && topicEvents2.uploadInitMessages().nonEmpty() != false && topicEvents2.commitAndSwapMessages().nonEmpty() != false), (String)"Expected non-zero events");
        v0 = topicEvents2.uploadMessages();
        var12_18 = topicEvents1.uploadMessages();
        if (v0 != null ? v0.equals(var12_18) == false : var12_18 != null) ** GOTO lbl-1000
        v1 = topicEvents2.uploadInitMessages();
        var13_19 = topicEvents1.uploadInitMessages();
        if (v1 != null ? v1.equals(var13_19) == false : var13_19 != null) ** GOTO lbl-1000
        v2 = topicEvents2.commitAndSwapMessages();
        var14_20 = topicEvents1.commitAndSwapMessages();
        if (!(v2 != null ? v2.equals(var14_20) == false : var14_20 != null)) {
            v3 = true;
        } else lbl-1000:
        // 3 sources

        {
            v3 = false;
        }
        Assertions.assertTrue((boolean)v3, (String)"Messages count doesn't match");
    }

    private void runAuditJob(Seq<Tuple2<TopicPartition, Object>> topicPartitionInfo) {
        int brokerId = 0;
        KafkaBroker broker = (KafkaBroker)this.brokerForId(brokerId).get();
        BrokerAuditManager auditManager = (BrokerAuditManager)broker.auditManager().get();
        Set auditChecks = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        new BrokerAuditJob(topicPartitionInfo, broker.logManager(), new CountDownLatch(1), auditManager.reporter(), auditManager.auditJobSummary(), 0, broker.tierObjectStoreOpt(), Time.SYSTEM, auditChecks, auditManager.config(), auditManager.db(), (Option)new Some((Object)auditManager.replicaManager()), false, (Option)None$.MODULE$).run();
        topicPartitionInfo.foreach((Function1 & Serializable)x0$1 -> {
            DurabilityTierCompactionTest.$anonfun$runAuditJob$1(auditManager, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(DurabilityTierCompactionTest $this, int p) {
        return new TopicPartition($this.topic(), p);
    }

    public static final /* synthetic */ Tuple2 $anonfun$produceKeyedRecords$1(DurabilityTierCompactionTest $this, Random random$1, int i) {
        return new Tuple2.mcII.sp(random$1.nextInt($this.maxNumRecords() / 10), $this.numProducedRecords() + i);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTieredAndCompacted$3(TierPartitionState tierPartitionState$1, AbstractLog log$1) {
        tierPartitionState$1.flush();
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState$1.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
        return log$1.tierableLogSegments().isEmpty() && tierPartitionState$1.compactDirtyStartOffset() > tierPartitionState$1.endOffset() && tierPartitionState$1.endOffset() == tierPartitionState$1.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTieredAndCompacted$5(AbstractLog log$1, TierPartitionState tierPartitionState$1) {
        return new StringBuilder(168).append("timeout waiting for tiered segments to be compacted.").append(" tierable segments: ").append(log$1.tierableLogSegments()).append(",").append(" local segments ").append(log$1.localLogSegments()).append(",").append(" tiered segments: ").append(CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState$1.segments()).asScala().toList()).append(",").append(" end offset: ").append(tierPartitionState$1.endOffset()).append(",").append(" committed end offset: ").append(tierPartitionState$1.committedEndOffset()).append(",").append(" dirty start offset: ").append(tierPartitionState$1.compactDirtyStartOffset()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$2(TopicPartition tp$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$1, x$2).get();
        TierPartitionState tierPartitionState = log.tierPartitionState();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 90000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityTierCompactionTest.$anonfun$waitUntilSegmentsTieredAndCompacted$3(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityTierCompactionTest.$anonfun$waitUntilSegmentsTieredAndCompacted$5(log, tierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$1(DurabilityTierCompactionTest $this, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable)broker -> {
            DurabilityTierCompactionTest.$anonfun$waitUntilSegmentsTieredAndCompacted$2(tp, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Uuid $anonfun$verifyCommitAndSwapEvent$1() {
        return Uuid.ZERO_UUID;
    }

    public static final /* synthetic */ TierTopicEvents $anonfun$verifyCommitAndSwapEvent$2() {
        return TierTopicEvents$.MODULE$.apply();
    }

    public static final /* synthetic */ TierTopicEvents $anonfun$verifyCommitAndSwapEvent$3() {
        return TierTopicEvents$.MODULE$.apply();
    }

    public static final /* synthetic */ void $anonfun$runAuditJob$1(BrokerAuditManager auditManager$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            Assertions.assertTrue((auditManager$1.reporter().getDurabilityCounters(topicPartition).loss() == 0L ? 1 : 0) != 0);
            return;
        }
        throw new MatchError(null);
    }

    public DurabilityTierCompactionTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerCompactMinEfficiencyProp(), "0.001");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        this.serverConfig().setProperty("confluent.durability.audit.enable", Boolean.toString(true));
        this.serverConfig().setProperty("confluent.durability.topic.replication.factor", "1");
        this.serverConfig().setProperty("confluent.durability.topic.partition.count", "1");
        this.serverConfig().setProperty("confluent.durability.audit.batch.flush.frequency.ms", "1500");
        this.serverConfig().setProperty("confluent.durability.events.allowed", "OffsetChangeType,EpochChangeType,IsrExpandType,DeleteRecordsType,RetentionChangeType,StartOffsetChangeType,DeletePartitionType,HealthCheckType");
        this.serverConfig().setProperty("confluent.durability.audit.idempotent.producer", Boolean.toString(false));
        this.configureMock();
        this.topic = "test_topic";
        this.partitions = 1;
        this.maxNumRecords = 5000;
        this.numProducedRecords = 0;
        this.producedRecords = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.exited = new AtomicBoolean(false);
    }
}

